//
//  Copyright (C) 1999 by
//  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
// DESCRIPTION:
//  Gamma correction LUT.
//

#ifndef __I_GAMMA__
#define __I_GAMMA__

#include "doomtype.h"

/*
// This table was created with the following code
// with gammatable[5][256] being the original array as found in v_video.c:

static const float gammalevels[9] =
{
    // Darker
    0.50f, 0.55f, 0.60f, 0.65f, 0.70f, 0.75f, 0.80f, 0.85f, 0.90f,
};

static byte gamma2table[18][256];

static void I_InitGamma2Table(void)
{
  int i, j, k;

  for (i = 0; i < 9; ++i)
    for (j = 0; j < 256; ++j)
    {
      gamma2table[i][j] = (byte)(pow(j / 255.0, 1.0 / gammalevels[i]) * 255.0 + 0.5);
    }

  // [crispy] 5 original gamma levels
  for (i = 9, k = 0; i < 18 && k < 5; i += 2, k++)
    memcpy(gamma2table[i], gammatable[k], 256);

  // [crispy] 4 intermediate gamma levels
  for (i = 10, k = 0; i < 18 && k < 4; i += 2, k++)
    for (j = 0; j < 256; ++j)
    {
      gamma2table[i][j] = (gammatable[k][j] + gammatable[k + 1][j]) / 2;
    }
}
*/

// Now where did these came from?
static const byte gammatable[18][256] = {
    {
        0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,
        1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   3,   3,
        3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6,   6,   7,
        7,   7,   8,   8,   8,   9,   9,   9,   10,  10,  11,  11,  11,  12,
        12,  13,  13,  14,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,
        19,  20,  20,  21,  21,  22,  23,  23,  24,  24,  25,  26,  26,  27,
        28,  28,  29,  30,  30,  31,  32,  32,  33,  34,  35,  35,  36,  37,
        38,  38,  39,  40,  41,  42,  42,  43,  44,  45,  46,  47,  47,  48,
        49,  50,  51,  52,  53,  54,  55,  56,  56,  57,  58,  59,  60,  61,
        62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  73,  74,  75,  76,
        77,  78,  79,  80,  81,  82,  84,  85,  86,  87,  88,  89,  91,  92,
        93,  94,  95,  97,  98,  99,  100, 102, 103, 104, 105, 107, 108, 109,
        111, 112, 113, 115, 116, 117, 119, 120, 121, 123, 124, 126, 127, 128,
        130, 131, 133, 134, 136, 137, 139, 140, 142, 143, 145, 146, 148, 149,
        151, 152, 154, 155, 157, 158, 160, 162, 163, 165, 166, 168, 170, 171,
        173, 175, 176, 178, 180, 181, 183, 185, 186, 188, 190, 192, 193, 195,
        197, 199, 200, 202, 204, 206, 207, 209, 211, 213, 215, 217, 218, 220,
        222, 224, 226, 228, 230, 232, 233, 235, 237, 239, 241, 243, 245, 247,
        249, 251, 253, 255,
    },
    {
        0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,
        1,   1,   2,   2,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4,
        5,   5,   5,   6,   6,   6,   7,   7,   7,   8,   8,   8,   9,   9,
        10,  10,  10,  11,  11,  12,  12,  13,  13,  14,  14,  15,  15,  16,
        16,  17,  17,  18,  18,  19,  19,  20,  21,  21,  22,  22,  23,  24,
        24,  25,  26,  26,  27,  28,  28,  29,  30,  30,  31,  32,  32,  33,
        34,  35,  35,  36,  37,  38,  38,  39,  40,  41,  42,  42,  43,  44,
        45,  46,  46,  47,  48,  49,  50,  51,  52,  53,  53,  54,  55,  56,
        57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,
        71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  84,  85,
        86,  87,  88,  89,  90,  91,  93,  94,  95,  96,  97,  98,  100, 101,
        102, 103, 104, 106, 107, 108, 109, 111, 112, 113, 114, 116, 117, 118,
        119, 121, 122, 123, 125, 126, 127, 129, 130, 131, 133, 134, 135, 137,
        138, 139, 141, 142, 144, 145, 147, 148, 149, 151, 152, 154, 155, 157,
        158, 160, 161, 162, 164, 165, 167, 168, 170, 171, 173, 175, 176, 178,
        179, 181, 182, 184, 185, 187, 189, 190, 192, 193, 195, 197, 198, 200,
        201, 203, 205, 206, 208, 210, 211, 213, 215, 216, 218, 220, 222, 223,
        225, 227, 228, 230, 232, 234, 235, 237, 239, 241, 242, 244, 246, 248,
        250, 251, 253, 255,
    },
    {
        0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   2,   2,
        2,   2,   3,   3,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6,
        6,   7,   7,   8,   8,   8,   9,   9,   10,  10,  11,  11,  12,  12,
        13,  13,  14,  14,  15,  15,  16,  16,  17,  17,  18,  19,  19,  20,
        20,  21,  22,  22,  23,  24,  24,  25,  25,  26,  27,  27,  28,  29,
        30,  30,  31,  32,  32,  33,  34,  35,  35,  36,  37,  38,  38,  39,
        40,  41,  42,  42,  43,  44,  45,  46,  47,  47,  48,  49,  50,  51,
        52,  53,  54,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,
        65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,
        79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  91,  92,  93,
        94,  95,  96,  97,  98,  100, 101, 102, 103, 104, 105, 106, 108, 109,
        110, 111, 112, 114, 115, 116, 117, 118, 120, 121, 122, 123, 125, 126,
        127, 128, 130, 131, 132, 134, 135, 136, 137, 139, 140, 141, 143, 144,
        145, 147, 148, 149, 151, 152, 153, 155, 156, 158, 159, 160, 162, 163,
        164, 166, 167, 169, 170, 172, 173, 174, 176, 177, 179, 180, 182, 183,
        185, 186, 187, 189, 190, 192, 193, 195, 196, 198, 199, 201, 202, 204,
        205, 207, 209, 210, 212, 213, 215, 216, 218, 219, 221, 223, 224, 226,
        227, 229, 230, 232, 234, 235, 237, 239, 240, 242, 243, 245, 247, 248,
        250, 252, 253, 255,
    },
    {
        0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   2,   2,   2,   3,
        3,   3,   4,   4,   4,   5,   5,   5,   6,   6,   7,   7,   8,   8,
        9,   9,   9,   10,  10,  11,  11,  12,  13,  13,  14,  14,  15,  15,
        16,  16,  17,  18,  18,  19,  20,  20,  21,  21,  22,  23,  23,  24,
        25,  25,  26,  27,  28,  28,  29,  30,  30,  31,  32,  33,  33,  34,
        35,  36,  36,  37,  38,  39,  40,  40,  41,  42,  43,  44,  45,  45,
        46,  47,  48,  49,  50,  50,  51,  52,  53,  54,  55,  56,  57,  58,
        59,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,
        72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,
        86,  87,  88,  89,  90,  92,  93,  94,  95,  96,  97,  98,  99,  100,
        101, 102, 104, 105, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116,
        117, 119, 120, 121, 122, 123, 124, 126, 127, 128, 129, 131, 132, 133,
        134, 135, 137, 138, 139, 140, 142, 143, 144, 145, 147, 148, 149, 150,
        152, 153, 154, 156, 157, 158, 160, 161, 162, 163, 165, 166, 167, 169,
        170, 171, 173, 174, 175, 177, 178, 180, 181, 182, 184, 185, 186, 188,
        189, 191, 192, 193, 195, 196, 198, 199, 200, 202, 203, 205, 206, 207,
        209, 210, 212, 213, 215, 216, 218, 219, 220, 222, 223, 225, 226, 228,
        229, 231, 232, 234, 235, 237, 238, 240, 241, 243, 244, 246, 247, 249,
        250, 252, 253, 255,
    },
    {
        0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   2,   3,   3,   4,
        4,   4,   5,   5,   6,   6,   7,   7,   8,   8,   9,   9,   10,  10,
        11,  11,  12,  13,  13,  14,  14,  15,  16,  16,  17,  17,  18,  19,
        19,  20,  21,  21,  22,  23,  23,  24,  25,  26,  26,  27,  28,  29,
        29,  30,  31,  32,  32,  33,  34,  35,  35,  36,  37,  38,  39,  39,
        40,  41,  42,  43,  44,  44,  45,  46,  47,  48,  49,  50,  50,  51,
        52,  53,  54,  55,  56,  57,  58,  59,  59,  60,  61,  62,  63,  64,
        65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,
        79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,
        93,  94,  95,  96,  97,  98,  100, 101, 102, 103, 104, 105, 106, 107,
        108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 121, 122, 123,
        124, 125, 126, 128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 139,
        140, 142, 143, 144, 145, 146, 148, 149, 150, 151, 153, 154, 155, 156,
        158, 159, 160, 161, 162, 164, 165, 166, 167, 169, 170, 171, 173, 174,
        175, 176, 178, 179, 180, 182, 183, 184, 185, 187, 188, 189, 191, 192,
        193, 195, 196, 197, 199, 200, 201, 203, 204, 205, 207, 208, 209, 211,
        212, 213, 215, 216, 217, 219, 220, 221, 223, 224, 226, 227, 228, 230,
        231, 232, 234, 235, 237, 238, 239, 241, 242, 244, 245, 246, 248, 249,
        251, 252, 254, 255,
    },
    {
        0,   0,   0,   1,   1,   1,   2,   2,   3,   3,   3,   4,   4,   5,
        5,   6,   6,   7,   7,   8,   9,   9,   10,  10,  11,  12,  12,  13,
        13,  14,  15,  15,  16,  17,  17,  18,  19,  19,  20,  21,  22,  22,
        23,  24,  24,  25,  26,  27,  28,  28,  29,  30,  31,  31,  32,  33,
        34,  35,  35,  36,  37,  38,  39,  40,  40,  41,  42,  43,  44,  45,
        45,  46,  47,  48,  49,  50,  51,  52,  53,  53,  54,  55,  56,  57,
        58,  59,  60,  61,  62,  63,  64,  65,  65,  66,  67,  68,  69,  70,
        71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,
        85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  98,  99,
        100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 114,
        115, 116, 117, 118, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129,
        130, 131, 132, 134, 135, 136, 137, 138, 139, 140, 142, 143, 144, 145,
        146, 147, 149, 150, 151, 152, 153, 154, 156, 157, 158, 159, 160, 161,
        163, 164, 165, 166, 167, 169, 170, 171, 172, 173, 175, 176, 177, 178,
        180, 181, 182, 183, 184, 186, 187, 188, 189, 191, 192, 193, 194, 196,
        197, 198, 199, 201, 202, 203, 204, 206, 207, 208, 209, 211, 212, 213,
        215, 216, 217, 218, 220, 221, 222, 224, 225, 226, 227, 229, 230, 231,
        233, 234, 235, 237, 238, 239, 240, 242, 243, 244, 246, 247, 248, 250,
        251, 252, 254, 255,
    },
    {
        0,   0,   1,   1,   1,   2,   2,   3,   3,   4,   4,   5,   6,   6,
        7,   7,   8,   9,   9,   10,  11,  11,  12,  13,  13,  14,  15,  15,
        16,  17,  18,  18,  19,  20,  21,  21,  22,  23,  24,  24,  25,  26,
        27,  28,  28,  29,  30,  31,  32,  32,  33,  34,  35,  36,  37,  37,
        38,  39,  40,  41,  42,  43,  44,  44,  45,  46,  47,  48,  49,  50,
        51,  52,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
        64,  65,  66,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,
        77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
        91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 103, 104, 105,
        106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
        121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 134, 135,
        136, 137, 138, 139, 140, 141, 142, 144, 145, 146, 147, 148, 149, 150,
        151, 152, 154, 155, 156, 157, 158, 159, 160, 162, 163, 164, 165, 166,
        167, 168, 170, 171, 172, 173, 174, 175, 177, 178, 179, 180, 181, 182,
        184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 196, 198, 199,
        200, 201, 202, 204, 205, 206, 207, 208, 210, 211, 212, 213, 214, 216,
        217, 218, 219, 220, 222, 223, 224, 225, 227, 228, 229, 230, 231, 233,
        234, 235, 236, 238, 239, 240, 241, 243, 244, 245, 246, 248, 249, 250,
        251, 253, 254, 255,
    },
    {
        0,   0,   1,   1,   2,   2,   3,   4,   4,   5,   6,   6,   7,   8,
        8,   9,   10,  11,  11,  12,  13,  14,  14,  15,  16,  17,  17,  18,
        19,  20,  21,  21,  22,  23,  24,  25,  25,  26,  27,  28,  29,  30,
        31,  31,  32,  33,  34,  35,  36,  37,  38,  38,  39,  40,  41,  42,
        43,  44,  45,  46,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,
        56,  57,  58,  59,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,
        69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,
        83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
        97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
        111, 112, 113, 114, 115, 116, 118, 119, 120, 121, 122, 123, 124, 125,
        126, 127, 128, 129, 130, 131, 132, 133, 134, 136, 137, 138, 139, 140,
        141, 142, 143, 144, 145, 146, 147, 148, 150, 151, 152, 153, 154, 155,
        156, 157, 158, 159, 160, 162, 163, 164, 165, 166, 167, 168, 169, 170,
        171, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 185, 186,
        187, 188, 189, 190, 192, 193, 194, 195, 196, 197, 198, 200, 201, 202,
        203, 204, 205, 206, 207, 209, 210, 211, 212, 213, 214, 215, 217, 218,
        219, 220, 221, 222, 224, 225, 226, 227, 228, 229, 230, 232, 233, 234,
        235, 236, 237, 239, 240, 241, 242, 243, 244, 246, 247, 248, 249, 250,
        251, 253, 254, 255,
    },
    {
        0,   1,   1,   2,   3,   3,   4,   5,   5,   6,   7,   8,   9,   9,
        10,  11,  12,  13,  13,  14,  15,  16,  17,  18,  18,  19,  20,  21,
        22,  23,  24,  25,  25,  26,  27,  28,  29,  30,  31,  32,  33,  33,
        34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  45,  46,
        47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,
        61,  62,  63,  64,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,
        74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,
        88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101,
        102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 144, 145,
        146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
        160, 161, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174,
        175, 176, 177, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
        190, 191, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
        206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 218, 219, 220,
        221, 222, 223, 224, 225, 226, 227, 228, 230, 231, 232, 233, 234, 235,
        236, 237, 238, 239, 241, 242, 243, 244, 245, 246, 247, 248, 249, 251,
        252, 253, 254, 255,
    },
    {
        1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
        15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,
        29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,
        43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,
        57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,
        71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,
        85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,
        99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
        113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,
        127, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
        140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
        154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
        168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
        182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195,
        196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
        210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
        224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237,
        238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
        252, 253, 254, 255,
    },
    {
        1,   3,   4,   5,   6,   8,   9,   10,  11,  12,  13,  15,  16,  17,
        18,  19,  20,  21,  22,  23,  25,  26,  27,  28,  29,  30,  31,  32,
        33,  34,  35,  36,  37,  39,  40,  41,  42,  43,  44,  45,  46,  47,
        48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,
        63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,
        77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,
        91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
        105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118,
        119, 120, 121, 122, 123, 123, 124, 125, 126, 127, 128, 129, 130, 131,
        132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 142, 143, 144,
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158,
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 170, 171,
        172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185,
        186, 187, 188, 189, 190, 191, 192, 192, 193, 194, 195, 196, 197, 198,
        199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 211,
        212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225,
        226, 227, 228, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238,
        239, 240, 241, 242, 243, 244, 244, 245, 246, 247, 248, 249, 250, 251,
        252, 253, 254, 255,
    },
    {
        2,   4,   5,   7,   8,   10,  11,  12,  14,  15,  16,  18,  19,  20,
        21,  23,  24,  25,  26,  27,  29,  30,  31,  32,  33,  34,  36,  37,
        38,  39,  40,  41,  42,  44,  45,  46,  47,  48,  49,  50,  51,  52,
        54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,
        69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,
        83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
        97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
        111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124,
        125, 126, 127, 128, 129, 129, 130, 131, 132, 133, 134, 135, 136, 137,
        138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 148, 149, 150,
        151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 163,
        164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 175, 176,
        177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 186, 187, 188, 189,
        190, 191, 192, 193, 194, 195, 196, 196, 197, 198, 199, 200, 201, 202,
        203, 204, 205, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 214,
        215, 216, 217, 218, 219, 220, 221, 222, 222, 223, 224, 225, 226, 227,
        228, 229, 230, 230, 231, 232, 233, 234, 235, 236, 237, 237, 238, 239,
        240, 241, 242, 243, 244, 245, 245, 246, 247, 248, 249, 250, 251, 252,
        252, 253, 254, 255,
    },
    {
        3,   5,   7,   9,   10,  12,  14,  15,  17,  18,  20,  22,  23,  24,
        25,  27,  28,  30,  31,  32,  34,  35,  36,  37,  39,  40,  41,  42,
        44,  45,  46,  47,  48,  50,  51,  52,  53,  54,  55,  56,  58,  59,
        60,  61,  62,  63,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
        76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
        90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103,
        104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
        118, 119, 120, 121, 122, 123, 124, 125, 126, 126, 127, 128, 129, 130,
        131, 132, 133, 134, 135, 136, 137, 137, 138, 139, 140, 141, 142, 143,
        144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 154, 155, 156,
        157, 158, 159, 160, 160, 161, 162, 163, 164, 165, 166, 167, 168, 168,
        169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 178, 179, 180, 181,
        182, 183, 183, 184, 185, 186, 187, 188, 189, 190, 190, 191, 192, 193,
        194, 195, 196, 197, 197, 198, 199, 200, 201, 202, 202, 203, 204, 205,
        206, 207, 208, 208, 209, 210, 211, 212, 213, 214, 214, 215, 216, 217,
        218, 218, 219, 220, 221, 222, 223, 224, 224, 225, 226, 227, 228, 229,
        229, 230, 231, 232, 233, 233, 234, 235, 236, 237, 238, 238, 239, 240,
        241, 242, 243, 243, 244, 245, 246, 246, 247, 248, 249, 250, 251, 252,
        252, 253, 254, 255,
    },
    {
        4,   7,   9,   11,  13,  15,  17,  19,  21,  22,  24,  26,  27,  29,
        30,  32,  33,  35,  36,  38,  39,  40,  42,  43,  45,  46,  47,  48,
        50,  51,  52,  54,  55,  56,  57,  59,  60,  61,  62,  63,  65,  66,
        67,  68,  69,  70,  72,  73,  74,  75,  76,  77,  78,  79,  80,  82,
        83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
        97,  98,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
        112, 113, 114, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124,
        125, 126, 127, 128, 129, 130, 131, 132, 133, 133, 134, 135, 136, 137,
        138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150,
        151, 152, 153, 153, 154, 155, 156, 157, 158, 159, 160, 160, 161, 162,
        163, 164, 165, 166, 166, 167, 168, 169, 170, 171, 172, 172, 173, 174,
        175, 176, 177, 178, 178, 179, 180, 181, 182, 183, 183, 184, 185, 186,
        187, 188, 188, 189, 190, 191, 192, 193, 193, 194, 195, 196, 197, 197,
        198, 199, 200, 201, 201, 202, 203, 204, 205, 206, 206, 207, 208, 209,
        210, 210, 211, 212, 213, 213, 214, 215, 216, 217, 217, 218, 219, 220,
        221, 221, 222, 223, 224, 224, 225, 226, 227, 228, 228, 229, 230, 231,
        231, 232, 233, 234, 235, 235, 236, 237, 238, 238, 239, 240, 241, 241,
        242, 243, 244, 244, 245, 246, 247, 247, 248, 249, 250, 251, 251, 252,
        253, 254, 254, 255,
    },
    {
        6,   9,   12,  15,  17,  19,  22,  24,  26,  28,  30,  32,  33,  35,
        36,  38,  40,  42,  43,  45,  46,  47,  49,  50,  52,  53,  55,  56,
        57,  59,  60,  62,  63,  64,  65,  67,  68,  69,  70,  71,  73,  74,
        75,  76,  77,  78,  80,  81,  82,  83,  84,  85,  86,  87,  89,  90,
        91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
        105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
        120, 121, 122, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
        133, 134, 135, 135, 136, 137, 138, 139, 140, 141, 142, 142, 143, 144,
        145, 146, 147, 148, 149, 150, 151, 151, 152, 153, 154, 155, 156, 157,
        158, 158, 159, 160, 161, 162, 162, 163, 164, 165, 166, 166, 167, 168,
        169, 170, 171, 172, 172, 173, 174, 175, 176, 177, 177, 178, 179, 180,
        180, 181, 182, 183, 183, 184, 185, 186, 187, 188, 188, 189, 190, 191,
        192, 192, 193, 194, 195, 195, 196, 197, 197, 198, 199, 200, 201, 201,
        202, 203, 204, 205, 205, 206, 207, 208, 208, 209, 210, 210, 211, 212,
        213, 213, 214, 215, 216, 216, 217, 218, 219, 220, 220, 221, 222, 222,
        223, 224, 224, 225, 226, 226, 227, 228, 229, 230, 230, 231, 232, 233,
        233, 234, 235, 235, 236, 236, 237, 238, 239, 239, 240, 241, 242, 242,
        243, 244, 245, 245, 246, 246, 247, 248, 248, 249, 250, 251, 251, 252,
        253, 254, 254, 255,
    },
    {
        8,   12,  16,  19,  22,  24,  27,  29,  31,  34,  36,  38,  40,  41,
        43,  45,  47,  49,  50,  52,  53,  55,  57,  58,  60,  61,  63,  64,
        65,  67,  68,  70,  71,  72,  74,  75,  76,  77,  79,  80,  81,  82,
        84,  85,  86,  87,  88,  90,  91,  92,  93,  94,  95,  96,  98,  99,
        100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
        114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
        128, 129, 130, 131, 132, 133, 134, 135, 135, 136, 137, 138, 139, 140,
        141, 142, 143, 143, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152,
        153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 164,
        165, 165, 166, 167, 168, 169, 169, 170, 171, 172, 173, 173, 174, 175,
        176, 176, 177, 178, 179, 180, 180, 181, 182, 183, 183, 184, 185, 186,
        186, 187, 188, 189, 189, 190, 191, 192, 192, 193, 194, 195, 195, 196,
        197, 197, 198, 199, 200, 200, 201, 202, 202, 203, 204, 205, 205, 206,
        207, 207, 208, 209, 210, 210, 211, 212, 212, 213, 214, 214, 215, 216,
        216, 217, 218, 219, 219, 220, 221, 221, 222, 223, 223, 224, 225, 225,
        226, 227, 227, 228, 229, 229, 230, 231, 231, 232, 233, 233, 234, 235,
        235, 236, 237, 237, 238, 238, 239, 240, 240, 241, 242, 242, 243, 244,
        244, 245, 246, 246, 247, 247, 248, 249, 249, 250, 251, 251, 252, 253,
        253, 254, 254, 255,
    },
    {
        12,  17,  22,  25,  29,  31,  34,  37,  39,  42,  44,  46,  48,  50,
        52,  54,  56,  58,  59,  61,  63,  65,  66,  68,  70,  71,  73,  74,
        75,  77,  78,  80,  81,  82,  84,  85,  86,  87,  89,  90,  91,  92,
        94,  95,  96,  97,  98,  100, 101, 102, 103, 104, 105, 106, 108, 109,
        110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
        124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 133, 134, 135, 136,
        137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149,
        150, 150, 151, 152, 153, 154, 154, 155, 156, 157, 158, 158, 159, 160,
        161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 169, 170, 171,
        172, 172, 173, 174, 175, 176, 176, 177, 178, 179, 180, 180, 181, 182,
        182, 183, 184, 184, 185, 186, 186, 187, 188, 189, 189, 190, 191, 192,
        192, 193, 194, 194, 195, 196, 196, 197, 197, 198, 199, 200, 200, 201,
        202, 202, 203, 204, 205, 205, 206, 206, 207, 208, 208, 209, 209, 210,
        211, 211, 212, 213, 214, 214, 215, 216, 216, 217, 217, 218, 219, 219,
        220, 220, 221, 222, 222, 223, 224, 224, 225, 226, 226, 227, 227, 228,
        229, 229, 230, 230, 231, 231, 232, 233, 233, 234, 235, 235, 236, 237,
        237, 238, 238, 239, 239, 240, 240, 241, 241, 242, 243, 243, 244, 245,
        245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 251, 251, 252, 253,
        253, 254, 254, 255,
    },
    {
        16,  23,  28,  32,  36,  39,  42,  45,  48,  50,  53,  55,  57,  60,
        62,  64,  66,  68,  69,  71,  73,  75,  76,  78,  80,  81,  83,  84,
        86,  87,  89,  90,  92,  93,  94,  96,  97,  98,  100, 101, 102, 103,
        105, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119,
        120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133,
        134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 143, 144, 145, 146,
        147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158,
        159, 159, 160, 161, 162, 163, 163, 164, 165, 166, 166, 167, 168, 169,
        169, 170, 171, 172, 172, 173, 174, 175, 175, 176, 177, 177, 178, 179,
        180, 180, 181, 182, 182, 183, 184, 184, 185, 186, 187, 187, 188, 189,
        189, 190, 191, 191, 192, 193, 193, 194, 195, 195, 196, 196, 197, 198,
        198, 199, 200, 200, 201, 202, 202, 203, 203, 204, 205, 205, 206, 207,
        207, 208, 208, 209, 210, 210, 211, 211, 212, 213, 213, 214, 214, 215,
        216, 216, 217, 217, 218, 219, 219, 220, 220, 221, 221, 222, 223, 223,
        224, 224, 225, 225, 226, 227, 227, 228, 228, 229, 229, 230, 230, 231,
        232, 232, 233, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 239,
        239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246,
        246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253,
        254, 254, 255, 255,
    },
};

#endif
