
// SPDX-License-Identifier: MIT OR Apache-2.0 OR Zlib
// This file was automatically generated using keysym-generator.

// Copyright 2022-2023 John Nunley
// 
// Licensed under the Apache License, Version 2.0, the MIT License, and
// the Zlib license ("the Licenses"), you may not use this file except in 
// compliance with one of the the Licenses, at your option. You may obtain
//  a copy of the Licenses at
// 
//     http://www.apache.org/licenses/LICENSE-2.0
//     http://opensource.org/licenses/MIT
//     http://opensource.org/licenses/Zlib
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the Licenses is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the Licenses for the specific language governing permissions and
// limitations under the Licenses.

use super::Keysym;

/// A list of raw keyboard symbols.
pub mod key {
    use crate::RawKeysym;

    #[doc(alias = "XK_VoidSymbol")]
    pub const VoidSymbol: RawKeysym = 0xffffff;
    #[doc(alias = "XK_BackSpace")]
    pub const BackSpace: RawKeysym = 0xff08;
    #[doc(alias = "XK_Tab")]
    pub const Tab: RawKeysym = 0xff09;
    #[doc(alias = "XK_Linefeed")]
    pub const Linefeed: RawKeysym = 0xff0a;
    #[doc(alias = "XK_Clear")]
    pub const Clear: RawKeysym = 0xff0b;
    #[doc(alias = "XK_Return")]
    pub const Return: RawKeysym = 0xff0d;
    #[doc(alias = "XK_Pause")]
    pub const Pause: RawKeysym = 0xff13;
    #[doc(alias = "XK_Scroll_Lock")]
    pub const Scroll_Lock: RawKeysym = 0xff14;
    #[doc(alias = "XK_Sys_Req")]
    pub const Sys_Req: RawKeysym = 0xff15;
    #[doc(alias = "XK_Escape")]
    pub const Escape: RawKeysym = 0xff1b;
    #[doc(alias = "XK_Delete")]
    pub const Delete: RawKeysym = 0xffff;
    #[doc(alias = "XK_Multi_key")]
    pub const Multi_key: RawKeysym = 0xff20;
    #[doc(alias = "XK_Codeinput")]
    pub const Codeinput: RawKeysym = 0xff37;
    #[doc(alias = "XK_SingleCandidate")]
    pub const SingleCandidate: RawKeysym = 0xff3c;
    #[doc(alias = "XK_MultipleCandidate")]
    pub const MultipleCandidate: RawKeysym = 0xff3d;
    #[doc(alias = "XK_PreviousCandidate")]
    pub const PreviousCandidate: RawKeysym = 0xff3e;
    #[doc(alias = "XK_Kanji")]
    pub const Kanji: RawKeysym = 0xff21;
    #[doc(alias = "XK_Muhenkan")]
    pub const Muhenkan: RawKeysym = 0xff22;
    #[doc(alias = "XK_Henkan_Mode")]
    pub const Henkan_Mode: RawKeysym = 0xff23;
    #[doc(alias = "XK_Henkan")]
    pub const Henkan: RawKeysym = 0xff23;
    #[doc(alias = "XK_Romaji")]
    pub const Romaji: RawKeysym = 0xff24;
    #[doc(alias = "XK_Hiragana")]
    pub const Hiragana: RawKeysym = 0xff25;
    #[doc(alias = "XK_Katakana")]
    pub const Katakana: RawKeysym = 0xff26;
    #[doc(alias = "XK_Hiragana_Katakana")]
    pub const Hiragana_Katakana: RawKeysym = 0xff27;
    #[doc(alias = "XK_Zenkaku")]
    pub const Zenkaku: RawKeysym = 0xff28;
    #[doc(alias = "XK_Hankaku")]
    pub const Hankaku: RawKeysym = 0xff29;
    #[doc(alias = "XK_Zenkaku_Hankaku")]
    pub const Zenkaku_Hankaku: RawKeysym = 0xff2a;
    #[doc(alias = "XK_Touroku")]
    pub const Touroku: RawKeysym = 0xff2b;
    #[doc(alias = "XK_Massyo")]
    pub const Massyo: RawKeysym = 0xff2c;
    #[doc(alias = "XK_Kana_Lock")]
    pub const Kana_Lock: RawKeysym = 0xff2d;
    #[doc(alias = "XK_Kana_Shift")]
    pub const Kana_Shift: RawKeysym = 0xff2e;
    #[doc(alias = "XK_Eisu_Shift")]
    pub const Eisu_Shift: RawKeysym = 0xff2f;
    #[doc(alias = "XK_Eisu_toggle")]
    pub const Eisu_toggle: RawKeysym = 0xff30;
    #[doc(alias = "XK_Kanji_Bangou")]
    pub const Kanji_Bangou: RawKeysym = 0xff37;
    #[doc(alias = "XK_Zen_Koho")]
    pub const Zen_Koho: RawKeysym = 0xff3d;
    #[doc(alias = "XK_Mae_Koho")]
    pub const Mae_Koho: RawKeysym = 0xff3e;
    #[doc(alias = "XK_Home")]
    pub const Home: RawKeysym = 0xff50;
    #[doc(alias = "XK_Left")]
    pub const Left: RawKeysym = 0xff51;
    #[doc(alias = "XK_Up")]
    pub const Up: RawKeysym = 0xff52;
    #[doc(alias = "XK_Right")]
    pub const Right: RawKeysym = 0xff53;
    #[doc(alias = "XK_Down")]
    pub const Down: RawKeysym = 0xff54;
    #[doc(alias = "XK_Prior")]
    pub const Prior: RawKeysym = 0xff55;
    #[doc(alias = "XK_Page_Up")]
    pub const Page_Up: RawKeysym = 0xff55;
    #[doc(alias = "XK_Next")]
    pub const Next: RawKeysym = 0xff56;
    #[doc(alias = "XK_Page_Down")]
    pub const Page_Down: RawKeysym = 0xff56;
    #[doc(alias = "XK_End")]
    pub const End: RawKeysym = 0xff57;
    #[doc(alias = "XK_Begin")]
    pub const Begin: RawKeysym = 0xff58;
    #[doc(alias = "XK_Select")]
    pub const Select: RawKeysym = 0xff60;
    #[doc(alias = "XK_Print")]
    pub const Print: RawKeysym = 0xff61;
    #[doc(alias = "XK_Execute")]
    pub const Execute: RawKeysym = 0xff62;
    #[doc(alias = "XK_Insert")]
    pub const Insert: RawKeysym = 0xff63;
    #[doc(alias = "XK_Undo")]
    pub const Undo: RawKeysym = 0xff65;
    #[doc(alias = "XK_Redo")]
    pub const Redo: RawKeysym = 0xff66;
    #[doc(alias = "XK_Menu")]
    pub const Menu: RawKeysym = 0xff67;
    #[doc(alias = "XK_Find")]
    pub const Find: RawKeysym = 0xff68;
    #[doc(alias = "XK_Cancel")]
    pub const Cancel: RawKeysym = 0xff69;
    #[doc(alias = "XK_Help")]
    pub const Help: RawKeysym = 0xff6a;
    #[doc(alias = "XK_Break")]
    pub const Break: RawKeysym = 0xff6b;
    #[doc(alias = "XK_Mode_switch")]
    pub const Mode_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_script_switch")]
    pub const script_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_Num_Lock")]
    pub const Num_Lock: RawKeysym = 0xff7f;
    #[doc(alias = "XK_KP_Space")]
    pub const KP_Space: RawKeysym = 0xff80;
    #[doc(alias = "XK_KP_Tab")]
    pub const KP_Tab: RawKeysym = 0xff89;
    #[doc(alias = "XK_KP_Enter")]
    pub const KP_Enter: RawKeysym = 0xff8d;
    #[doc(alias = "XK_KP_F1")]
    pub const KP_F1: RawKeysym = 0xff91;
    #[doc(alias = "XK_KP_F2")]
    pub const KP_F2: RawKeysym = 0xff92;
    #[doc(alias = "XK_KP_F3")]
    pub const KP_F3: RawKeysym = 0xff93;
    #[doc(alias = "XK_KP_F4")]
    pub const KP_F4: RawKeysym = 0xff94;
    #[doc(alias = "XK_KP_Home")]
    pub const KP_Home: RawKeysym = 0xff95;
    #[doc(alias = "XK_KP_Left")]
    pub const KP_Left: RawKeysym = 0xff96;
    #[doc(alias = "XK_KP_Up")]
    pub const KP_Up: RawKeysym = 0xff97;
    #[doc(alias = "XK_KP_Right")]
    pub const KP_Right: RawKeysym = 0xff98;
    #[doc(alias = "XK_KP_Down")]
    pub const KP_Down: RawKeysym = 0xff99;
    #[doc(alias = "XK_KP_Prior")]
    pub const KP_Prior: RawKeysym = 0xff9a;
    #[doc(alias = "XK_KP_Page_Up")]
    pub const KP_Page_Up: RawKeysym = 0xff9a;
    #[doc(alias = "XK_KP_Next")]
    pub const KP_Next: RawKeysym = 0xff9b;
    #[doc(alias = "XK_KP_Page_Down")]
    pub const KP_Page_Down: RawKeysym = 0xff9b;
    #[doc(alias = "XK_KP_End")]
    pub const KP_End: RawKeysym = 0xff9c;
    #[doc(alias = "XK_KP_Begin")]
    pub const KP_Begin: RawKeysym = 0xff9d;
    #[doc(alias = "XK_KP_Insert")]
    pub const KP_Insert: RawKeysym = 0xff9e;
    #[doc(alias = "XK_KP_Delete")]
    pub const KP_Delete: RawKeysym = 0xff9f;
    #[doc(alias = "XK_KP_Equal")]
    pub const KP_Equal: RawKeysym = 0xffbd;
    #[doc(alias = "XK_KP_Multiply")]
    pub const KP_Multiply: RawKeysym = 0xffaa;
    #[doc(alias = "XK_KP_Add")]
    pub const KP_Add: RawKeysym = 0xffab;
    #[doc(alias = "XK_KP_Separator")]
    pub const KP_Separator: RawKeysym = 0xffac;
    #[doc(alias = "XK_KP_Subtract")]
    pub const KP_Subtract: RawKeysym = 0xffad;
    #[doc(alias = "XK_KP_Decimal")]
    pub const KP_Decimal: RawKeysym = 0xffae;
    #[doc(alias = "XK_KP_Divide")]
    pub const KP_Divide: RawKeysym = 0xffaf;
    #[doc(alias = "XK_KP_0")]
    pub const KP_0: RawKeysym = 0xffb0;
    #[doc(alias = "XK_KP_1")]
    pub const KP_1: RawKeysym = 0xffb1;
    #[doc(alias = "XK_KP_2")]
    pub const KP_2: RawKeysym = 0xffb2;
    #[doc(alias = "XK_KP_3")]
    pub const KP_3: RawKeysym = 0xffb3;
    #[doc(alias = "XK_KP_4")]
    pub const KP_4: RawKeysym = 0xffb4;
    #[doc(alias = "XK_KP_5")]
    pub const KP_5: RawKeysym = 0xffb5;
    #[doc(alias = "XK_KP_6")]
    pub const KP_6: RawKeysym = 0xffb6;
    #[doc(alias = "XK_KP_7")]
    pub const KP_7: RawKeysym = 0xffb7;
    #[doc(alias = "XK_KP_8")]
    pub const KP_8: RawKeysym = 0xffb8;
    #[doc(alias = "XK_KP_9")]
    pub const KP_9: RawKeysym = 0xffb9;
    #[doc(alias = "XK_F1")]
    pub const F1: RawKeysym = 0xffbe;
    #[doc(alias = "XK_F2")]
    pub const F2: RawKeysym = 0xffbf;
    #[doc(alias = "XK_F3")]
    pub const F3: RawKeysym = 0xffc0;
    #[doc(alias = "XK_F4")]
    pub const F4: RawKeysym = 0xffc1;
    #[doc(alias = "XK_F5")]
    pub const F5: RawKeysym = 0xffc2;
    #[doc(alias = "XK_F6")]
    pub const F6: RawKeysym = 0xffc3;
    #[doc(alias = "XK_F7")]
    pub const F7: RawKeysym = 0xffc4;
    #[doc(alias = "XK_F8")]
    pub const F8: RawKeysym = 0xffc5;
    #[doc(alias = "XK_F9")]
    pub const F9: RawKeysym = 0xffc6;
    #[doc(alias = "XK_F10")]
    pub const F10: RawKeysym = 0xffc7;
    #[doc(alias = "XK_F11")]
    pub const F11: RawKeysym = 0xffc8;
    #[doc(alias = "XK_L1")]
    pub const L1: RawKeysym = 0xffc8;
    #[doc(alias = "XK_F12")]
    pub const F12: RawKeysym = 0xffc9;
    #[doc(alias = "XK_L2")]
    pub const L2: RawKeysym = 0xffc9;
    #[doc(alias = "XK_F13")]
    pub const F13: RawKeysym = 0xffca;
    #[doc(alias = "XK_L3")]
    pub const L3: RawKeysym = 0xffca;
    #[doc(alias = "XK_F14")]
    pub const F14: RawKeysym = 0xffcb;
    #[doc(alias = "XK_L4")]
    pub const L4: RawKeysym = 0xffcb;
    #[doc(alias = "XK_F15")]
    pub const F15: RawKeysym = 0xffcc;
    #[doc(alias = "XK_L5")]
    pub const L5: RawKeysym = 0xffcc;
    #[doc(alias = "XK_F16")]
    pub const F16: RawKeysym = 0xffcd;
    #[doc(alias = "XK_L6")]
    pub const L6: RawKeysym = 0xffcd;
    #[doc(alias = "XK_F17")]
    pub const F17: RawKeysym = 0xffce;
    #[doc(alias = "XK_L7")]
    pub const L7: RawKeysym = 0xffce;
    #[doc(alias = "XK_F18")]
    pub const F18: RawKeysym = 0xffcf;
    #[doc(alias = "XK_L8")]
    pub const L8: RawKeysym = 0xffcf;
    #[doc(alias = "XK_F19")]
    pub const F19: RawKeysym = 0xffd0;
    #[doc(alias = "XK_L9")]
    pub const L9: RawKeysym = 0xffd0;
    #[doc(alias = "XK_F20")]
    pub const F20: RawKeysym = 0xffd1;
    #[doc(alias = "XK_L10")]
    pub const L10: RawKeysym = 0xffd1;
    #[doc(alias = "XK_F21")]
    pub const F21: RawKeysym = 0xffd2;
    #[doc(alias = "XK_R1")]
    pub const R1: RawKeysym = 0xffd2;
    #[doc(alias = "XK_F22")]
    pub const F22: RawKeysym = 0xffd3;
    #[doc(alias = "XK_R2")]
    pub const R2: RawKeysym = 0xffd3;
    #[doc(alias = "XK_F23")]
    pub const F23: RawKeysym = 0xffd4;
    #[doc(alias = "XK_R3")]
    pub const R3: RawKeysym = 0xffd4;
    #[doc(alias = "XK_F24")]
    pub const F24: RawKeysym = 0xffd5;
    #[doc(alias = "XK_R4")]
    pub const R4: RawKeysym = 0xffd5;
    #[doc(alias = "XK_F25")]
    pub const F25: RawKeysym = 0xffd6;
    #[doc(alias = "XK_R5")]
    pub const R5: RawKeysym = 0xffd6;
    #[doc(alias = "XK_F26")]
    pub const F26: RawKeysym = 0xffd7;
    #[doc(alias = "XK_R6")]
    pub const R6: RawKeysym = 0xffd7;
    #[doc(alias = "XK_F27")]
    pub const F27: RawKeysym = 0xffd8;
    #[doc(alias = "XK_R7")]
    pub const R7: RawKeysym = 0xffd8;
    #[doc(alias = "XK_F28")]
    pub const F28: RawKeysym = 0xffd9;
    #[doc(alias = "XK_R8")]
    pub const R8: RawKeysym = 0xffd9;
    #[doc(alias = "XK_F29")]
    pub const F29: RawKeysym = 0xffda;
    #[doc(alias = "XK_R9")]
    pub const R9: RawKeysym = 0xffda;
    #[doc(alias = "XK_F30")]
    pub const F30: RawKeysym = 0xffdb;
    #[doc(alias = "XK_R10")]
    pub const R10: RawKeysym = 0xffdb;
    #[doc(alias = "XK_F31")]
    pub const F31: RawKeysym = 0xffdc;
    #[doc(alias = "XK_R11")]
    pub const R11: RawKeysym = 0xffdc;
    #[doc(alias = "XK_F32")]
    pub const F32: RawKeysym = 0xffdd;
    #[doc(alias = "XK_R12")]
    pub const R12: RawKeysym = 0xffdd;
    #[doc(alias = "XK_F33")]
    pub const F33: RawKeysym = 0xffde;
    #[doc(alias = "XK_R13")]
    pub const R13: RawKeysym = 0xffde;
    #[doc(alias = "XK_F34")]
    pub const F34: RawKeysym = 0xffdf;
    #[doc(alias = "XK_R14")]
    pub const R14: RawKeysym = 0xffdf;
    #[doc(alias = "XK_F35")]
    pub const F35: RawKeysym = 0xffe0;
    #[doc(alias = "XK_R15")]
    pub const R15: RawKeysym = 0xffe0;
    #[doc(alias = "XK_Shift_L")]
    pub const Shift_L: RawKeysym = 0xffe1;
    #[doc(alias = "XK_Shift_R")]
    pub const Shift_R: RawKeysym = 0xffe2;
    #[doc(alias = "XK_Control_L")]
    pub const Control_L: RawKeysym = 0xffe3;
    #[doc(alias = "XK_Control_R")]
    pub const Control_R: RawKeysym = 0xffe4;
    #[doc(alias = "XK_Caps_Lock")]
    pub const Caps_Lock: RawKeysym = 0xffe5;
    #[doc(alias = "XK_Shift_Lock")]
    pub const Shift_Lock: RawKeysym = 0xffe6;
    #[doc(alias = "XK_Meta_L")]
    pub const Meta_L: RawKeysym = 0xffe7;
    #[doc(alias = "XK_Meta_R")]
    pub const Meta_R: RawKeysym = 0xffe8;
    #[doc(alias = "XK_Alt_L")]
    pub const Alt_L: RawKeysym = 0xffe9;
    #[doc(alias = "XK_Alt_R")]
    pub const Alt_R: RawKeysym = 0xffea;
    #[doc(alias = "XK_Super_L")]
    pub const Super_L: RawKeysym = 0xffeb;
    #[doc(alias = "XK_Super_R")]
    pub const Super_R: RawKeysym = 0xffec;
    #[doc(alias = "XK_Hyper_L")]
    pub const Hyper_L: RawKeysym = 0xffed;
    #[doc(alias = "XK_Hyper_R")]
    pub const Hyper_R: RawKeysym = 0xffee;
    #[doc(alias = "XK_ISO_Lock")]
    pub const ISO_Lock: RawKeysym = 0xfe01;
    #[doc(alias = "XK_ISO_Level2_Latch")]
    pub const ISO_Level2_Latch: RawKeysym = 0xfe02;
    #[doc(alias = "XK_ISO_Level3_Shift")]
    pub const ISO_Level3_Shift: RawKeysym = 0xfe03;
    #[doc(alias = "XK_ISO_Level3_Latch")]
    pub const ISO_Level3_Latch: RawKeysym = 0xfe04;
    #[doc(alias = "XK_ISO_Level3_Lock")]
    pub const ISO_Level3_Lock: RawKeysym = 0xfe05;
    #[doc(alias = "XK_ISO_Level5_Shift")]
    pub const ISO_Level5_Shift: RawKeysym = 0xfe11;
    #[doc(alias = "XK_ISO_Level5_Latch")]
    pub const ISO_Level5_Latch: RawKeysym = 0xfe12;
    #[doc(alias = "XK_ISO_Level5_Lock")]
    pub const ISO_Level5_Lock: RawKeysym = 0xfe13;
    #[doc(alias = "XK_ISO_Group_Shift")]
    pub const ISO_Group_Shift: RawKeysym = 0xff7e;
    #[doc(alias = "XK_ISO_Group_Latch")]
    pub const ISO_Group_Latch: RawKeysym = 0xfe06;
    #[doc(alias = "XK_ISO_Group_Lock")]
    pub const ISO_Group_Lock: RawKeysym = 0xfe07;
    #[doc(alias = "XK_ISO_Next_Group")]
    pub const ISO_Next_Group: RawKeysym = 0xfe08;
    #[doc(alias = "XK_ISO_Next_Group_Lock")]
    pub const ISO_Next_Group_Lock: RawKeysym = 0xfe09;
    #[doc(alias = "XK_ISO_Prev_Group")]
    pub const ISO_Prev_Group: RawKeysym = 0xfe0a;
    #[doc(alias = "XK_ISO_Prev_Group_Lock")]
    pub const ISO_Prev_Group_Lock: RawKeysym = 0xfe0b;
    #[doc(alias = "XK_ISO_First_Group")]
    pub const ISO_First_Group: RawKeysym = 0xfe0c;
    #[doc(alias = "XK_ISO_First_Group_Lock")]
    pub const ISO_First_Group_Lock: RawKeysym = 0xfe0d;
    #[doc(alias = "XK_ISO_Last_Group")]
    pub const ISO_Last_Group: RawKeysym = 0xfe0e;
    #[doc(alias = "XK_ISO_Last_Group_Lock")]
    pub const ISO_Last_Group_Lock: RawKeysym = 0xfe0f;
    #[doc(alias = "XK_ISO_Left_Tab")]
    pub const ISO_Left_Tab: RawKeysym = 0xfe20;
    #[doc(alias = "XK_ISO_Move_Line_Up")]
    pub const ISO_Move_Line_Up: RawKeysym = 0xfe21;
    #[doc(alias = "XK_ISO_Move_Line_Down")]
    pub const ISO_Move_Line_Down: RawKeysym = 0xfe22;
    #[doc(alias = "XK_ISO_Partial_Line_Up")]
    pub const ISO_Partial_Line_Up: RawKeysym = 0xfe23;
    #[doc(alias = "XK_ISO_Partial_Line_Down")]
    pub const ISO_Partial_Line_Down: RawKeysym = 0xfe24;
    #[doc(alias = "XK_ISO_Partial_Space_Left")]
    pub const ISO_Partial_Space_Left: RawKeysym = 0xfe25;
    #[doc(alias = "XK_ISO_Partial_Space_Right")]
    pub const ISO_Partial_Space_Right: RawKeysym = 0xfe26;
    #[doc(alias = "XK_ISO_Set_Margin_Left")]
    pub const ISO_Set_Margin_Left: RawKeysym = 0xfe27;
    #[doc(alias = "XK_ISO_Set_Margin_Right")]
    pub const ISO_Set_Margin_Right: RawKeysym = 0xfe28;
    #[doc(alias = "XK_ISO_Release_Margin_Left")]
    pub const ISO_Release_Margin_Left: RawKeysym = 0xfe29;
    #[doc(alias = "XK_ISO_Release_Margin_Right")]
    pub const ISO_Release_Margin_Right: RawKeysym = 0xfe2a;
    #[doc(alias = "XK_ISO_Release_Both_Margins")]
    pub const ISO_Release_Both_Margins: RawKeysym = 0xfe2b;
    #[doc(alias = "XK_ISO_Fast_Cursor_Left")]
    pub const ISO_Fast_Cursor_Left: RawKeysym = 0xfe2c;
    #[doc(alias = "XK_ISO_Fast_Cursor_Right")]
    pub const ISO_Fast_Cursor_Right: RawKeysym = 0xfe2d;
    #[doc(alias = "XK_ISO_Fast_Cursor_Up")]
    pub const ISO_Fast_Cursor_Up: RawKeysym = 0xfe2e;
    #[doc(alias = "XK_ISO_Fast_Cursor_Down")]
    pub const ISO_Fast_Cursor_Down: RawKeysym = 0xfe2f;
    #[doc(alias = "XK_ISO_Continuous_Underline")]
    pub const ISO_Continuous_Underline: RawKeysym = 0xfe30;
    #[doc(alias = "XK_ISO_Discontinuous_Underline")]
    pub const ISO_Discontinuous_Underline: RawKeysym = 0xfe31;
    #[doc(alias = "XK_ISO_Emphasize")]
    pub const ISO_Emphasize: RawKeysym = 0xfe32;
    #[doc(alias = "XK_ISO_Center_Object")]
    pub const ISO_Center_Object: RawKeysym = 0xfe33;
    #[doc(alias = "XK_ISO_Enter")]
    pub const ISO_Enter: RawKeysym = 0xfe34;
    #[doc(alias = "XK_dead_grave")]
    pub const dead_grave: RawKeysym = 0xfe50;
    #[doc(alias = "XK_dead_acute")]
    pub const dead_acute: RawKeysym = 0xfe51;
    #[doc(alias = "XK_dead_circumflex")]
    pub const dead_circumflex: RawKeysym = 0xfe52;
    #[doc(alias = "XK_dead_tilde")]
    pub const dead_tilde: RawKeysym = 0xfe53;
    #[doc(alias = "XK_dead_perispomeni")]
    pub const dead_perispomeni: RawKeysym = 0xfe53;
    #[doc(alias = "XK_dead_macron")]
    pub const dead_macron: RawKeysym = 0xfe54;
    #[doc(alias = "XK_dead_breve")]
    pub const dead_breve: RawKeysym = 0xfe55;
    #[doc(alias = "XK_dead_abovedot")]
    pub const dead_abovedot: RawKeysym = 0xfe56;
    #[doc(alias = "XK_dead_diaeresis")]
    pub const dead_diaeresis: RawKeysym = 0xfe57;
    #[doc(alias = "XK_dead_abovering")]
    pub const dead_abovering: RawKeysym = 0xfe58;
    #[doc(alias = "XK_dead_doubleacute")]
    pub const dead_doubleacute: RawKeysym = 0xfe59;
    #[doc(alias = "XK_dead_caron")]
    pub const dead_caron: RawKeysym = 0xfe5a;
    #[doc(alias = "XK_dead_cedilla")]
    pub const dead_cedilla: RawKeysym = 0xfe5b;
    #[doc(alias = "XK_dead_ogonek")]
    pub const dead_ogonek: RawKeysym = 0xfe5c;
    #[doc(alias = "XK_dead_iota")]
    pub const dead_iota: RawKeysym = 0xfe5d;
    #[doc(alias = "XK_dead_voiced_sound")]
    pub const dead_voiced_sound: RawKeysym = 0xfe5e;
    #[doc(alias = "XK_dead_semivoiced_sound")]
    pub const dead_semivoiced_sound: RawKeysym = 0xfe5f;
    #[doc(alias = "XK_dead_belowdot")]
    pub const dead_belowdot: RawKeysym = 0xfe60;
    #[doc(alias = "XK_dead_hook")]
    pub const dead_hook: RawKeysym = 0xfe61;
    #[doc(alias = "XK_dead_horn")]
    pub const dead_horn: RawKeysym = 0xfe62;
    #[doc(alias = "XK_dead_stroke")]
    pub const dead_stroke: RawKeysym = 0xfe63;
    #[doc(alias = "XK_dead_abovecomma")]
    pub const dead_abovecomma: RawKeysym = 0xfe64;
    #[doc(alias = "XK_dead_psili")]
    pub const dead_psili: RawKeysym = 0xfe64;
    #[doc(alias = "XK_dead_abovereversedcomma")]
    pub const dead_abovereversedcomma: RawKeysym = 0xfe65;
    #[doc(alias = "XK_dead_dasia")]
    pub const dead_dasia: RawKeysym = 0xfe65;
    #[doc(alias = "XK_dead_doublegrave")]
    pub const dead_doublegrave: RawKeysym = 0xfe66;
    #[doc(alias = "XK_dead_belowring")]
    pub const dead_belowring: RawKeysym = 0xfe67;
    #[doc(alias = "XK_dead_belowmacron")]
    pub const dead_belowmacron: RawKeysym = 0xfe68;
    #[doc(alias = "XK_dead_belowcircumflex")]
    pub const dead_belowcircumflex: RawKeysym = 0xfe69;
    #[doc(alias = "XK_dead_belowtilde")]
    pub const dead_belowtilde: RawKeysym = 0xfe6a;
    #[doc(alias = "XK_dead_belowbreve")]
    pub const dead_belowbreve: RawKeysym = 0xfe6b;
    #[doc(alias = "XK_dead_belowdiaeresis")]
    pub const dead_belowdiaeresis: RawKeysym = 0xfe6c;
    #[doc(alias = "XK_dead_invertedbreve")]
    pub const dead_invertedbreve: RawKeysym = 0xfe6d;
    #[doc(alias = "XK_dead_belowcomma")]
    pub const dead_belowcomma: RawKeysym = 0xfe6e;
    #[doc(alias = "XK_dead_currency")]
    pub const dead_currency: RawKeysym = 0xfe6f;
    #[doc(alias = "XK_dead_lowline")]
    pub const dead_lowline: RawKeysym = 0xfe90;
    #[doc(alias = "XK_dead_aboveverticalline")]
    pub const dead_aboveverticalline: RawKeysym = 0xfe91;
    #[doc(alias = "XK_dead_belowverticalline")]
    pub const dead_belowverticalline: RawKeysym = 0xfe92;
    #[doc(alias = "XK_dead_longsolidusoverlay")]
    pub const dead_longsolidusoverlay: RawKeysym = 0xfe93;
    #[doc(alias = "XK_dead_a")]
    pub const dead_a: RawKeysym = 0xfe80;
    #[doc(alias = "XK_dead_A")]
    pub const dead_A: RawKeysym = 0xfe81;
    #[doc(alias = "XK_dead_e")]
    pub const dead_e: RawKeysym = 0xfe82;
    #[doc(alias = "XK_dead_E")]
    pub const dead_E: RawKeysym = 0xfe83;
    #[doc(alias = "XK_dead_i")]
    pub const dead_i: RawKeysym = 0xfe84;
    #[doc(alias = "XK_dead_I")]
    pub const dead_I: RawKeysym = 0xfe85;
    #[doc(alias = "XK_dead_o")]
    pub const dead_o: RawKeysym = 0xfe86;
    #[doc(alias = "XK_dead_O")]
    pub const dead_O: RawKeysym = 0xfe87;
    #[doc(alias = "XK_dead_u")]
    pub const dead_u: RawKeysym = 0xfe88;
    #[doc(alias = "XK_dead_U")]
    pub const dead_U: RawKeysym = 0xfe89;
    #[doc(alias = "XK_dead_small_schwa")]
    pub const dead_small_schwa: RawKeysym = 0xfe8a;
    #[doc(alias = "XK_dead_capital_schwa")]
    pub const dead_capital_schwa: RawKeysym = 0xfe8b;
    #[doc(alias = "XK_dead_greek")]
    pub const dead_greek: RawKeysym = 0xfe8c;
    #[doc(alias = "XK_First_Virtual_Screen")]
    pub const First_Virtual_Screen: RawKeysym = 0xfed0;
    #[doc(alias = "XK_Prev_Virtual_Screen")]
    pub const Prev_Virtual_Screen: RawKeysym = 0xfed1;
    #[doc(alias = "XK_Next_Virtual_Screen")]
    pub const Next_Virtual_Screen: RawKeysym = 0xfed2;
    #[doc(alias = "XK_Last_Virtual_Screen")]
    pub const Last_Virtual_Screen: RawKeysym = 0xfed4;
    #[doc(alias = "XK_Terminate_Server")]
    pub const Terminate_Server: RawKeysym = 0xfed5;
    #[doc(alias = "XK_AccessX_Enable")]
    pub const AccessX_Enable: RawKeysym = 0xfe70;
    #[doc(alias = "XK_AccessX_Feedback_Enable")]
    pub const AccessX_Feedback_Enable: RawKeysym = 0xfe71;
    #[doc(alias = "XK_RepeatKeys_Enable")]
    pub const RepeatKeys_Enable: RawKeysym = 0xfe72;
    #[doc(alias = "XK_SlowKeys_Enable")]
    pub const SlowKeys_Enable: RawKeysym = 0xfe73;
    #[doc(alias = "XK_BounceKeys_Enable")]
    pub const BounceKeys_Enable: RawKeysym = 0xfe74;
    #[doc(alias = "XK_StickyKeys_Enable")]
    pub const StickyKeys_Enable: RawKeysym = 0xfe75;
    #[doc(alias = "XK_MouseKeys_Enable")]
    pub const MouseKeys_Enable: RawKeysym = 0xfe76;
    #[doc(alias = "XK_MouseKeys_Accel_Enable")]
    pub const MouseKeys_Accel_Enable: RawKeysym = 0xfe77;
    #[doc(alias = "XK_Overlay1_Enable")]
    pub const Overlay1_Enable: RawKeysym = 0xfe78;
    #[doc(alias = "XK_Overlay2_Enable")]
    pub const Overlay2_Enable: RawKeysym = 0xfe79;
    #[doc(alias = "XK_AudibleBell_Enable")]
    pub const AudibleBell_Enable: RawKeysym = 0xfe7a;
    #[doc(alias = "XK_Pointer_Left")]
    pub const Pointer_Left: RawKeysym = 0xfee0;
    #[doc(alias = "XK_Pointer_Right")]
    pub const Pointer_Right: RawKeysym = 0xfee1;
    #[doc(alias = "XK_Pointer_Up")]
    pub const Pointer_Up: RawKeysym = 0xfee2;
    #[doc(alias = "XK_Pointer_Down")]
    pub const Pointer_Down: RawKeysym = 0xfee3;
    #[doc(alias = "XK_Pointer_UpLeft")]
    pub const Pointer_UpLeft: RawKeysym = 0xfee4;
    #[doc(alias = "XK_Pointer_UpRight")]
    pub const Pointer_UpRight: RawKeysym = 0xfee5;
    #[doc(alias = "XK_Pointer_DownLeft")]
    pub const Pointer_DownLeft: RawKeysym = 0xfee6;
    #[doc(alias = "XK_Pointer_DownRight")]
    pub const Pointer_DownRight: RawKeysym = 0xfee7;
    #[doc(alias = "XK_Pointer_Button_Dflt")]
    pub const Pointer_Button_Dflt: RawKeysym = 0xfee8;
    #[doc(alias = "XK_Pointer_Button1")]
    pub const Pointer_Button1: RawKeysym = 0xfee9;
    #[doc(alias = "XK_Pointer_Button2")]
    pub const Pointer_Button2: RawKeysym = 0xfeea;
    #[doc(alias = "XK_Pointer_Button3")]
    pub const Pointer_Button3: RawKeysym = 0xfeeb;
    #[doc(alias = "XK_Pointer_Button4")]
    pub const Pointer_Button4: RawKeysym = 0xfeec;
    #[doc(alias = "XK_Pointer_Button5")]
    pub const Pointer_Button5: RawKeysym = 0xfeed;
    #[doc(alias = "XK_Pointer_DblClick_Dflt")]
    pub const Pointer_DblClick_Dflt: RawKeysym = 0xfeee;
    #[doc(alias = "XK_Pointer_DblClick1")]
    pub const Pointer_DblClick1: RawKeysym = 0xfeef;
    #[doc(alias = "XK_Pointer_DblClick2")]
    pub const Pointer_DblClick2: RawKeysym = 0xfef0;
    #[doc(alias = "XK_Pointer_DblClick3")]
    pub const Pointer_DblClick3: RawKeysym = 0xfef1;
    #[doc(alias = "XK_Pointer_DblClick4")]
    pub const Pointer_DblClick4: RawKeysym = 0xfef2;
    #[doc(alias = "XK_Pointer_DblClick5")]
    pub const Pointer_DblClick5: RawKeysym = 0xfef3;
    #[doc(alias = "XK_Pointer_Drag_Dflt")]
    pub const Pointer_Drag_Dflt: RawKeysym = 0xfef4;
    #[doc(alias = "XK_Pointer_Drag1")]
    pub const Pointer_Drag1: RawKeysym = 0xfef5;
    #[doc(alias = "XK_Pointer_Drag2")]
    pub const Pointer_Drag2: RawKeysym = 0xfef6;
    #[doc(alias = "XK_Pointer_Drag3")]
    pub const Pointer_Drag3: RawKeysym = 0xfef7;
    #[doc(alias = "XK_Pointer_Drag4")]
    pub const Pointer_Drag4: RawKeysym = 0xfef8;
    #[doc(alias = "XK_Pointer_Drag5")]
    pub const Pointer_Drag5: RawKeysym = 0xfefd;
    #[doc(alias = "XK_Pointer_EnableKeys")]
    pub const Pointer_EnableKeys: RawKeysym = 0xfef9;
    #[doc(alias = "XK_Pointer_Accelerate")]
    pub const Pointer_Accelerate: RawKeysym = 0xfefa;
    #[doc(alias = "XK_Pointer_DfltBtnNext")]
    pub const Pointer_DfltBtnNext: RawKeysym = 0xfefb;
    #[doc(alias = "XK_Pointer_DfltBtnPrev")]
    pub const Pointer_DfltBtnPrev: RawKeysym = 0xfefc;
    #[doc(alias = "XK_ch")]
    pub const ch: RawKeysym = 0xfea0;
    #[doc(alias = "XK_Ch")]
    pub const Ch: RawKeysym = 0xfea1;
    #[doc(alias = "XK_CH")]
    pub const CH: RawKeysym = 0xfea2;
    #[doc(alias = "XK_c_h")]
    pub const c_h: RawKeysym = 0xfea3;
    #[doc(alias = "XK_C_h")]
    pub const C_h: RawKeysym = 0xfea4;
    #[doc(alias = "XK_C_H")]
    pub const C_H: RawKeysym = 0xfea5;
    #[doc(alias = "XK_3270_Duplicate")]
    pub const _3270_Duplicate: RawKeysym = 0xfd01;
    #[doc(alias = "XK_3270_FieldMark")]
    pub const _3270_FieldMark: RawKeysym = 0xfd02;
    #[doc(alias = "XK_3270_Right2")]
    pub const _3270_Right2: RawKeysym = 0xfd03;
    #[doc(alias = "XK_3270_Left2")]
    pub const _3270_Left2: RawKeysym = 0xfd04;
    #[doc(alias = "XK_3270_BackTab")]
    pub const _3270_BackTab: RawKeysym = 0xfd05;
    #[doc(alias = "XK_3270_EraseEOF")]
    pub const _3270_EraseEOF: RawKeysym = 0xfd06;
    #[doc(alias = "XK_3270_EraseInput")]
    pub const _3270_EraseInput: RawKeysym = 0xfd07;
    #[doc(alias = "XK_3270_Reset")]
    pub const _3270_Reset: RawKeysym = 0xfd08;
    #[doc(alias = "XK_3270_Quit")]
    pub const _3270_Quit: RawKeysym = 0xfd09;
    #[doc(alias = "XK_3270_PA1")]
    pub const _3270_PA1: RawKeysym = 0xfd0a;
    #[doc(alias = "XK_3270_PA2")]
    pub const _3270_PA2: RawKeysym = 0xfd0b;
    #[doc(alias = "XK_3270_PA3")]
    pub const _3270_PA3: RawKeysym = 0xfd0c;
    #[doc(alias = "XK_3270_Test")]
    pub const _3270_Test: RawKeysym = 0xfd0d;
    #[doc(alias = "XK_3270_Attn")]
    pub const _3270_Attn: RawKeysym = 0xfd0e;
    #[doc(alias = "XK_3270_CursorBlink")]
    pub const _3270_CursorBlink: RawKeysym = 0xfd0f;
    #[doc(alias = "XK_3270_AltCursor")]
    pub const _3270_AltCursor: RawKeysym = 0xfd10;
    #[doc(alias = "XK_3270_KeyClick")]
    pub const _3270_KeyClick: RawKeysym = 0xfd11;
    #[doc(alias = "XK_3270_Jump")]
    pub const _3270_Jump: RawKeysym = 0xfd12;
    #[doc(alias = "XK_3270_Ident")]
    pub const _3270_Ident: RawKeysym = 0xfd13;
    #[doc(alias = "XK_3270_Rule")]
    pub const _3270_Rule: RawKeysym = 0xfd14;
    #[doc(alias = "XK_3270_Copy")]
    pub const _3270_Copy: RawKeysym = 0xfd15;
    #[doc(alias = "XK_3270_Play")]
    pub const _3270_Play: RawKeysym = 0xfd16;
    #[doc(alias = "XK_3270_Setup")]
    pub const _3270_Setup: RawKeysym = 0xfd17;
    #[doc(alias = "XK_3270_Record")]
    pub const _3270_Record: RawKeysym = 0xfd18;
    #[doc(alias = "XK_3270_ChangeScreen")]
    pub const _3270_ChangeScreen: RawKeysym = 0xfd19;
    #[doc(alias = "XK_3270_DeleteWord")]
    pub const _3270_DeleteWord: RawKeysym = 0xfd1a;
    #[doc(alias = "XK_3270_ExSelect")]
    pub const _3270_ExSelect: RawKeysym = 0xfd1b;
    #[doc(alias = "XK_3270_CursorSelect")]
    pub const _3270_CursorSelect: RawKeysym = 0xfd1c;
    #[doc(alias = "XK_3270_PrintScreen")]
    pub const _3270_PrintScreen: RawKeysym = 0xfd1d;
    #[doc(alias = "XK_3270_Enter")]
    pub const _3270_Enter: RawKeysym = 0xfd1e;
    #[doc(alias = "XK_space")]
    pub const space: RawKeysym = 0x20;
    #[doc(alias = "XK_exclam")]
    pub const exclam: RawKeysym = 0x21;
    #[doc(alias = "XK_quotedbl")]
    pub const quotedbl: RawKeysym = 0x22;
    #[doc(alias = "XK_numbersign")]
    pub const numbersign: RawKeysym = 0x23;
    #[doc(alias = "XK_dollar")]
    pub const dollar: RawKeysym = 0x24;
    #[doc(alias = "XK_percent")]
    pub const percent: RawKeysym = 0x25;
    #[doc(alias = "XK_ampersand")]
    pub const ampersand: RawKeysym = 0x26;
    #[doc(alias = "XK_apostrophe")]
    pub const apostrophe: RawKeysym = 0x27;
    #[doc(alias = "XK_quoteright")]
    pub const quoteright: RawKeysym = 0x27;
    #[doc(alias = "XK_parenleft")]
    pub const parenleft: RawKeysym = 0x28;
    #[doc(alias = "XK_parenright")]
    pub const parenright: RawKeysym = 0x29;
    #[doc(alias = "XK_asterisk")]
    pub const asterisk: RawKeysym = 0x2a;
    #[doc(alias = "XK_plus")]
    pub const plus: RawKeysym = 0x2b;
    #[doc(alias = "XK_comma")]
    pub const comma: RawKeysym = 0x2c;
    #[doc(alias = "XK_minus")]
    pub const minus: RawKeysym = 0x2d;
    #[doc(alias = "XK_period")]
    pub const period: RawKeysym = 0x2e;
    #[doc(alias = "XK_slash")]
    pub const slash: RawKeysym = 0x2f;
    #[doc(alias = "XK_0")]
    pub const _0: RawKeysym = 0x30;
    #[doc(alias = "XK_1")]
    pub const _1: RawKeysym = 0x31;
    #[doc(alias = "XK_2")]
    pub const _2: RawKeysym = 0x32;
    #[doc(alias = "XK_3")]
    pub const _3: RawKeysym = 0x33;
    #[doc(alias = "XK_4")]
    pub const _4: RawKeysym = 0x34;
    #[doc(alias = "XK_5")]
    pub const _5: RawKeysym = 0x35;
    #[doc(alias = "XK_6")]
    pub const _6: RawKeysym = 0x36;
    #[doc(alias = "XK_7")]
    pub const _7: RawKeysym = 0x37;
    #[doc(alias = "XK_8")]
    pub const _8: RawKeysym = 0x38;
    #[doc(alias = "XK_9")]
    pub const _9: RawKeysym = 0x39;
    #[doc(alias = "XK_colon")]
    pub const colon: RawKeysym = 0x3a;
    #[doc(alias = "XK_semicolon")]
    pub const semicolon: RawKeysym = 0x3b;
    #[doc(alias = "XK_less")]
    pub const less: RawKeysym = 0x3c;
    #[doc(alias = "XK_equal")]
    pub const equal: RawKeysym = 0x3d;
    #[doc(alias = "XK_greater")]
    pub const greater: RawKeysym = 0x3e;
    #[doc(alias = "XK_question")]
    pub const question: RawKeysym = 0x3f;
    #[doc(alias = "XK_at")]
    pub const at: RawKeysym = 0x40;
    #[doc(alias = "XK_A")]
    pub const A: RawKeysym = 0x41;
    #[doc(alias = "XK_B")]
    pub const B: RawKeysym = 0x42;
    #[doc(alias = "XK_C")]
    pub const C: RawKeysym = 0x43;
    #[doc(alias = "XK_D")]
    pub const D: RawKeysym = 0x44;
    #[doc(alias = "XK_E")]
    pub const E: RawKeysym = 0x45;
    #[doc(alias = "XK_F")]
    pub const F: RawKeysym = 0x46;
    #[doc(alias = "XK_G")]
    pub const G: RawKeysym = 0x47;
    #[doc(alias = "XK_H")]
    pub const H: RawKeysym = 0x48;
    #[doc(alias = "XK_I")]
    pub const I: RawKeysym = 0x49;
    #[doc(alias = "XK_J")]
    pub const J: RawKeysym = 0x4a;
    #[doc(alias = "XK_K")]
    pub const K: RawKeysym = 0x4b;
    #[doc(alias = "XK_L")]
    pub const L: RawKeysym = 0x4c;
    #[doc(alias = "XK_M")]
    pub const M: RawKeysym = 0x4d;
    #[doc(alias = "XK_N")]
    pub const N: RawKeysym = 0x4e;
    #[doc(alias = "XK_O")]
    pub const O: RawKeysym = 0x4f;
    #[doc(alias = "XK_P")]
    pub const P: RawKeysym = 0x50;
    #[doc(alias = "XK_Q")]
    pub const Q: RawKeysym = 0x51;
    #[doc(alias = "XK_R")]
    pub const R: RawKeysym = 0x52;
    #[doc(alias = "XK_S")]
    pub const S: RawKeysym = 0x53;
    #[doc(alias = "XK_T")]
    pub const T: RawKeysym = 0x54;
    #[doc(alias = "XK_U")]
    pub const U: RawKeysym = 0x55;
    #[doc(alias = "XK_V")]
    pub const V: RawKeysym = 0x56;
    #[doc(alias = "XK_W")]
    pub const W: RawKeysym = 0x57;
    #[doc(alias = "XK_X")]
    pub const X: RawKeysym = 0x58;
    #[doc(alias = "XK_Y")]
    pub const Y: RawKeysym = 0x59;
    #[doc(alias = "XK_Z")]
    pub const Z: RawKeysym = 0x5a;
    #[doc(alias = "XK_bracketleft")]
    pub const bracketleft: RawKeysym = 0x5b;
    #[doc(alias = "XK_backslash")]
    pub const backslash: RawKeysym = 0x5c;
    #[doc(alias = "XK_bracketright")]
    pub const bracketright: RawKeysym = 0x5d;
    #[doc(alias = "XK_asciicircum")]
    pub const asciicircum: RawKeysym = 0x5e;
    #[doc(alias = "XK_underscore")]
    pub const underscore: RawKeysym = 0x5f;
    #[doc(alias = "XK_grave")]
    pub const grave: RawKeysym = 0x60;
    #[doc(alias = "XK_quoteleft")]
    pub const quoteleft: RawKeysym = 0x60;
    #[doc(alias = "XK_a")]
    pub const a: RawKeysym = 0x61;
    #[doc(alias = "XK_b")]
    pub const b: RawKeysym = 0x62;
    #[doc(alias = "XK_c")]
    pub const c: RawKeysym = 0x63;
    #[doc(alias = "XK_d")]
    pub const d: RawKeysym = 0x64;
    #[doc(alias = "XK_e")]
    pub const e: RawKeysym = 0x65;
    #[doc(alias = "XK_f")]
    pub const f: RawKeysym = 0x66;
    #[doc(alias = "XK_g")]
    pub const g: RawKeysym = 0x67;
    #[doc(alias = "XK_h")]
    pub const h: RawKeysym = 0x68;
    #[doc(alias = "XK_i")]
    pub const i: RawKeysym = 0x69;
    #[doc(alias = "XK_j")]
    pub const j: RawKeysym = 0x6a;
    #[doc(alias = "XK_k")]
    pub const k: RawKeysym = 0x6b;
    #[doc(alias = "XK_l")]
    pub const l: RawKeysym = 0x6c;
    #[doc(alias = "XK_m")]
    pub const m: RawKeysym = 0x6d;
    #[doc(alias = "XK_n")]
    pub const n: RawKeysym = 0x6e;
    #[doc(alias = "XK_o")]
    pub const o: RawKeysym = 0x6f;
    #[doc(alias = "XK_p")]
    pub const p: RawKeysym = 0x70;
    #[doc(alias = "XK_q")]
    pub const q: RawKeysym = 0x71;
    #[doc(alias = "XK_r")]
    pub const r: RawKeysym = 0x72;
    #[doc(alias = "XK_s")]
    pub const s: RawKeysym = 0x73;
    #[doc(alias = "XK_t")]
    pub const t: RawKeysym = 0x74;
    #[doc(alias = "XK_u")]
    pub const u: RawKeysym = 0x75;
    #[doc(alias = "XK_v")]
    pub const v: RawKeysym = 0x76;
    #[doc(alias = "XK_w")]
    pub const w: RawKeysym = 0x77;
    #[doc(alias = "XK_x")]
    pub const x: RawKeysym = 0x78;
    #[doc(alias = "XK_y")]
    pub const y: RawKeysym = 0x79;
    #[doc(alias = "XK_z")]
    pub const z: RawKeysym = 0x7a;
    #[doc(alias = "XK_braceleft")]
    pub const braceleft: RawKeysym = 0x7b;
    #[doc(alias = "XK_bar")]
    pub const bar: RawKeysym = 0x7c;
    #[doc(alias = "XK_braceright")]
    pub const braceright: RawKeysym = 0x7d;
    #[doc(alias = "XK_asciitilde")]
    pub const asciitilde: RawKeysym = 0x7e;
    #[doc(alias = "XK_nobreakspace")]
    pub const nobreakspace: RawKeysym = 0xa0;
    #[doc(alias = "XK_exclamdown")]
    pub const exclamdown: RawKeysym = 0xa1;
    #[doc(alias = "XK_cent")]
    pub const cent: RawKeysym = 0xa2;
    #[doc(alias = "XK_sterling")]
    pub const sterling: RawKeysym = 0xa3;
    #[doc(alias = "XK_currency")]
    pub const currency: RawKeysym = 0xa4;
    #[doc(alias = "XK_yen")]
    pub const yen: RawKeysym = 0xa5;
    #[doc(alias = "XK_brokenbar")]
    pub const brokenbar: RawKeysym = 0xa6;
    #[doc(alias = "XK_section")]
    pub const section: RawKeysym = 0xa7;
    #[doc(alias = "XK_diaeresis")]
    pub const diaeresis: RawKeysym = 0xa8;
    #[doc(alias = "XK_copyright")]
    pub const copyright: RawKeysym = 0xa9;
    #[doc(alias = "XK_ordfeminine")]
    pub const ordfeminine: RawKeysym = 0xaa;
    #[doc(alias = "XK_guillemotleft")]
    pub const guillemotleft: RawKeysym = 0xab;
    #[doc(alias = "XK_notsign")]
    pub const notsign: RawKeysym = 0xac;
    #[doc(alias = "XK_hyphen")]
    pub const hyphen: RawKeysym = 0xad;
    #[doc(alias = "XK_registered")]
    pub const registered: RawKeysym = 0xae;
    #[doc(alias = "XK_macron")]
    pub const macron: RawKeysym = 0xaf;
    #[doc(alias = "XK_degree")]
    pub const degree: RawKeysym = 0xb0;
    #[doc(alias = "XK_plusminus")]
    pub const plusminus: RawKeysym = 0xb1;
    #[doc(alias = "XK_twosuperior")]
    pub const twosuperior: RawKeysym = 0xb2;
    #[doc(alias = "XK_threesuperior")]
    pub const threesuperior: RawKeysym = 0xb3;
    #[doc(alias = "XK_acute")]
    pub const acute: RawKeysym = 0xb4;
    #[doc(alias = "XK_mu")]
    pub const mu: RawKeysym = 0xb5;
    #[doc(alias = "XK_paragraph")]
    pub const paragraph: RawKeysym = 0xb6;
    #[doc(alias = "XK_periodcentered")]
    pub const periodcentered: RawKeysym = 0xb7;
    #[doc(alias = "XK_cedilla")]
    pub const cedilla: RawKeysym = 0xb8;
    #[doc(alias = "XK_onesuperior")]
    pub const onesuperior: RawKeysym = 0xb9;
    #[doc(alias = "XK_masculine")]
    pub const masculine: RawKeysym = 0xba;
    #[doc(alias = "XK_guillemotright")]
    pub const guillemotright: RawKeysym = 0xbb;
    #[doc(alias = "XK_onequarter")]
    pub const onequarter: RawKeysym = 0xbc;
    #[doc(alias = "XK_onehalf")]
    pub const onehalf: RawKeysym = 0xbd;
    #[doc(alias = "XK_threequarters")]
    pub const threequarters: RawKeysym = 0xbe;
    #[doc(alias = "XK_questiondown")]
    pub const questiondown: RawKeysym = 0xbf;
    #[doc(alias = "XK_Agrave")]
    pub const Agrave: RawKeysym = 0xc0;
    #[doc(alias = "XK_Aacute")]
    pub const Aacute: RawKeysym = 0xc1;
    #[doc(alias = "XK_Acircumflex")]
    pub const Acircumflex: RawKeysym = 0xc2;
    #[doc(alias = "XK_Atilde")]
    pub const Atilde: RawKeysym = 0xc3;
    #[doc(alias = "XK_Adiaeresis")]
    pub const Adiaeresis: RawKeysym = 0xc4;
    #[doc(alias = "XK_Aring")]
    pub const Aring: RawKeysym = 0xc5;
    #[doc(alias = "XK_AE")]
    pub const AE: RawKeysym = 0xc6;
    #[doc(alias = "XK_Ccedilla")]
    pub const Ccedilla: RawKeysym = 0xc7;
    #[doc(alias = "XK_Egrave")]
    pub const Egrave: RawKeysym = 0xc8;
    #[doc(alias = "XK_Eacute")]
    pub const Eacute: RawKeysym = 0xc9;
    #[doc(alias = "XK_Ecircumflex")]
    pub const Ecircumflex: RawKeysym = 0xca;
    #[doc(alias = "XK_Ediaeresis")]
    pub const Ediaeresis: RawKeysym = 0xcb;
    #[doc(alias = "XK_Igrave")]
    pub const Igrave: RawKeysym = 0xcc;
    #[doc(alias = "XK_Iacute")]
    pub const Iacute: RawKeysym = 0xcd;
    #[doc(alias = "XK_Icircumflex")]
    pub const Icircumflex: RawKeysym = 0xce;
    #[doc(alias = "XK_Idiaeresis")]
    pub const Idiaeresis: RawKeysym = 0xcf;
    #[doc(alias = "XK_ETH")]
    pub const ETH: RawKeysym = 0xd0;
    #[doc(alias = "XK_Eth")]
    pub const Eth: RawKeysym = 0xd0;
    #[doc(alias = "XK_Ntilde")]
    pub const Ntilde: RawKeysym = 0xd1;
    #[doc(alias = "XK_Ograve")]
    pub const Ograve: RawKeysym = 0xd2;
    #[doc(alias = "XK_Oacute")]
    pub const Oacute: RawKeysym = 0xd3;
    #[doc(alias = "XK_Ocircumflex")]
    pub const Ocircumflex: RawKeysym = 0xd4;
    #[doc(alias = "XK_Otilde")]
    pub const Otilde: RawKeysym = 0xd5;
    #[doc(alias = "XK_Odiaeresis")]
    pub const Odiaeresis: RawKeysym = 0xd6;
    #[doc(alias = "XK_multiply")]
    pub const multiply: RawKeysym = 0xd7;
    #[doc(alias = "XK_Oslash")]
    pub const Oslash: RawKeysym = 0xd8;
    #[doc(alias = "XK_Ooblique")]
    pub const Ooblique: RawKeysym = 0xd8;
    #[doc(alias = "XK_Ugrave")]
    pub const Ugrave: RawKeysym = 0xd9;
    #[doc(alias = "XK_Uacute")]
    pub const Uacute: RawKeysym = 0xda;
    #[doc(alias = "XK_Ucircumflex")]
    pub const Ucircumflex: RawKeysym = 0xdb;
    #[doc(alias = "XK_Udiaeresis")]
    pub const Udiaeresis: RawKeysym = 0xdc;
    #[doc(alias = "XK_Yacute")]
    pub const Yacute: RawKeysym = 0xdd;
    #[doc(alias = "XK_THORN")]
    pub const THORN: RawKeysym = 0xde;
    #[doc(alias = "XK_Thorn")]
    pub const Thorn: RawKeysym = 0xde;
    #[doc(alias = "XK_ssharp")]
    pub const ssharp: RawKeysym = 0xdf;
    #[doc(alias = "XK_agrave")]
    pub const agrave: RawKeysym = 0xe0;
    #[doc(alias = "XK_aacute")]
    pub const aacute: RawKeysym = 0xe1;
    #[doc(alias = "XK_acircumflex")]
    pub const acircumflex: RawKeysym = 0xe2;
    #[doc(alias = "XK_atilde")]
    pub const atilde: RawKeysym = 0xe3;
    #[doc(alias = "XK_adiaeresis")]
    pub const adiaeresis: RawKeysym = 0xe4;
    #[doc(alias = "XK_aring")]
    pub const aring: RawKeysym = 0xe5;
    #[doc(alias = "XK_ae")]
    pub const ae: RawKeysym = 0xe6;
    #[doc(alias = "XK_ccedilla")]
    pub const ccedilla: RawKeysym = 0xe7;
    #[doc(alias = "XK_egrave")]
    pub const egrave: RawKeysym = 0xe8;
    #[doc(alias = "XK_eacute")]
    pub const eacute: RawKeysym = 0xe9;
    #[doc(alias = "XK_ecircumflex")]
    pub const ecircumflex: RawKeysym = 0xea;
    #[doc(alias = "XK_ediaeresis")]
    pub const ediaeresis: RawKeysym = 0xeb;
    #[doc(alias = "XK_igrave")]
    pub const igrave: RawKeysym = 0xec;
    #[doc(alias = "XK_iacute")]
    pub const iacute: RawKeysym = 0xed;
    #[doc(alias = "XK_icircumflex")]
    pub const icircumflex: RawKeysym = 0xee;
    #[doc(alias = "XK_idiaeresis")]
    pub const idiaeresis: RawKeysym = 0xef;
    #[doc(alias = "XK_eth")]
    pub const eth: RawKeysym = 0xf0;
    #[doc(alias = "XK_ntilde")]
    pub const ntilde: RawKeysym = 0xf1;
    #[doc(alias = "XK_ograve")]
    pub const ograve: RawKeysym = 0xf2;
    #[doc(alias = "XK_oacute")]
    pub const oacute: RawKeysym = 0xf3;
    #[doc(alias = "XK_ocircumflex")]
    pub const ocircumflex: RawKeysym = 0xf4;
    #[doc(alias = "XK_otilde")]
    pub const otilde: RawKeysym = 0xf5;
    #[doc(alias = "XK_odiaeresis")]
    pub const odiaeresis: RawKeysym = 0xf6;
    #[doc(alias = "XK_division")]
    pub const division: RawKeysym = 0xf7;
    #[doc(alias = "XK_oslash")]
    pub const oslash: RawKeysym = 0xf8;
    #[doc(alias = "XK_ooblique")]
    pub const ooblique: RawKeysym = 0xf8;
    #[doc(alias = "XK_ugrave")]
    pub const ugrave: RawKeysym = 0xf9;
    #[doc(alias = "XK_uacute")]
    pub const uacute: RawKeysym = 0xfa;
    #[doc(alias = "XK_ucircumflex")]
    pub const ucircumflex: RawKeysym = 0xfb;
    #[doc(alias = "XK_udiaeresis")]
    pub const udiaeresis: RawKeysym = 0xfc;
    #[doc(alias = "XK_yacute")]
    pub const yacute: RawKeysym = 0xfd;
    #[doc(alias = "XK_thorn")]
    pub const thorn: RawKeysym = 0xfe;
    #[doc(alias = "XK_ydiaeresis")]
    pub const ydiaeresis: RawKeysym = 0xff;
    #[doc(alias = "XK_Aogonek")]
    pub const Aogonek: RawKeysym = 0x1a1;
    #[doc(alias = "XK_breve")]
    pub const breve: RawKeysym = 0x1a2;
    #[doc(alias = "XK_Lstroke")]
    pub const Lstroke: RawKeysym = 0x1a3;
    #[doc(alias = "XK_Lcaron")]
    pub const Lcaron: RawKeysym = 0x1a5;
    #[doc(alias = "XK_Sacute")]
    pub const Sacute: RawKeysym = 0x1a6;
    #[doc(alias = "XK_Scaron")]
    pub const Scaron: RawKeysym = 0x1a9;
    #[doc(alias = "XK_Scedilla")]
    pub const Scedilla: RawKeysym = 0x1aa;
    #[doc(alias = "XK_Tcaron")]
    pub const Tcaron: RawKeysym = 0x1ab;
    #[doc(alias = "XK_Zacute")]
    pub const Zacute: RawKeysym = 0x1ac;
    #[doc(alias = "XK_Zcaron")]
    pub const Zcaron: RawKeysym = 0x1ae;
    #[doc(alias = "XK_Zabovedot")]
    pub const Zabovedot: RawKeysym = 0x1af;
    #[doc(alias = "XK_aogonek")]
    pub const aogonek: RawKeysym = 0x1b1;
    #[doc(alias = "XK_ogonek")]
    pub const ogonek: RawKeysym = 0x1b2;
    #[doc(alias = "XK_lstroke")]
    pub const lstroke: RawKeysym = 0x1b3;
    #[doc(alias = "XK_lcaron")]
    pub const lcaron: RawKeysym = 0x1b5;
    #[doc(alias = "XK_sacute")]
    pub const sacute: RawKeysym = 0x1b6;
    #[doc(alias = "XK_caron")]
    pub const caron: RawKeysym = 0x1b7;
    #[doc(alias = "XK_scaron")]
    pub const scaron: RawKeysym = 0x1b9;
    #[doc(alias = "XK_scedilla")]
    pub const scedilla: RawKeysym = 0x1ba;
    #[doc(alias = "XK_tcaron")]
    pub const tcaron: RawKeysym = 0x1bb;
    #[doc(alias = "XK_zacute")]
    pub const zacute: RawKeysym = 0x1bc;
    #[doc(alias = "XK_doubleacute")]
    pub const doubleacute: RawKeysym = 0x1bd;
    #[doc(alias = "XK_zcaron")]
    pub const zcaron: RawKeysym = 0x1be;
    #[doc(alias = "XK_zabovedot")]
    pub const zabovedot: RawKeysym = 0x1bf;
    #[doc(alias = "XK_Racute")]
    pub const Racute: RawKeysym = 0x1c0;
    #[doc(alias = "XK_Abreve")]
    pub const Abreve: RawKeysym = 0x1c3;
    #[doc(alias = "XK_Lacute")]
    pub const Lacute: RawKeysym = 0x1c5;
    #[doc(alias = "XK_Cacute")]
    pub const Cacute: RawKeysym = 0x1c6;
    #[doc(alias = "XK_Ccaron")]
    pub const Ccaron: RawKeysym = 0x1c8;
    #[doc(alias = "XK_Eogonek")]
    pub const Eogonek: RawKeysym = 0x1ca;
    #[doc(alias = "XK_Ecaron")]
    pub const Ecaron: RawKeysym = 0x1cc;
    #[doc(alias = "XK_Dcaron")]
    pub const Dcaron: RawKeysym = 0x1cf;
    #[doc(alias = "XK_Dstroke")]
    pub const Dstroke: RawKeysym = 0x1d0;
    #[doc(alias = "XK_Nacute")]
    pub const Nacute: RawKeysym = 0x1d1;
    #[doc(alias = "XK_Ncaron")]
    pub const Ncaron: RawKeysym = 0x1d2;
    #[doc(alias = "XK_Odoubleacute")]
    pub const Odoubleacute: RawKeysym = 0x1d5;
    #[doc(alias = "XK_Rcaron")]
    pub const Rcaron: RawKeysym = 0x1d8;
    #[doc(alias = "XK_Uring")]
    pub const Uring: RawKeysym = 0x1d9;
    #[doc(alias = "XK_Udoubleacute")]
    pub const Udoubleacute: RawKeysym = 0x1db;
    #[doc(alias = "XK_Tcedilla")]
    pub const Tcedilla: RawKeysym = 0x1de;
    #[doc(alias = "XK_racute")]
    pub const racute: RawKeysym = 0x1e0;
    #[doc(alias = "XK_abreve")]
    pub const abreve: RawKeysym = 0x1e3;
    #[doc(alias = "XK_lacute")]
    pub const lacute: RawKeysym = 0x1e5;
    #[doc(alias = "XK_cacute")]
    pub const cacute: RawKeysym = 0x1e6;
    #[doc(alias = "XK_ccaron")]
    pub const ccaron: RawKeysym = 0x1e8;
    #[doc(alias = "XK_eogonek")]
    pub const eogonek: RawKeysym = 0x1ea;
    #[doc(alias = "XK_ecaron")]
    pub const ecaron: RawKeysym = 0x1ec;
    #[doc(alias = "XK_dcaron")]
    pub const dcaron: RawKeysym = 0x1ef;
    #[doc(alias = "XK_dstroke")]
    pub const dstroke: RawKeysym = 0x1f0;
    #[doc(alias = "XK_nacute")]
    pub const nacute: RawKeysym = 0x1f1;
    #[doc(alias = "XK_ncaron")]
    pub const ncaron: RawKeysym = 0x1f2;
    #[doc(alias = "XK_odoubleacute")]
    pub const odoubleacute: RawKeysym = 0x1f5;
    #[doc(alias = "XK_rcaron")]
    pub const rcaron: RawKeysym = 0x1f8;
    #[doc(alias = "XK_uring")]
    pub const uring: RawKeysym = 0x1f9;
    #[doc(alias = "XK_udoubleacute")]
    pub const udoubleacute: RawKeysym = 0x1fb;
    #[doc(alias = "XK_tcedilla")]
    pub const tcedilla: RawKeysym = 0x1fe;
    #[doc(alias = "XK_abovedot")]
    pub const abovedot: RawKeysym = 0x1ff;
    #[doc(alias = "XK_Hstroke")]
    pub const Hstroke: RawKeysym = 0x2a1;
    #[doc(alias = "XK_Hcircumflex")]
    pub const Hcircumflex: RawKeysym = 0x2a6;
    #[doc(alias = "XK_Iabovedot")]
    pub const Iabovedot: RawKeysym = 0x2a9;
    #[doc(alias = "XK_Gbreve")]
    pub const Gbreve: RawKeysym = 0x2ab;
    #[doc(alias = "XK_Jcircumflex")]
    pub const Jcircumflex: RawKeysym = 0x2ac;
    #[doc(alias = "XK_hstroke")]
    pub const hstroke: RawKeysym = 0x2b1;
    #[doc(alias = "XK_hcircumflex")]
    pub const hcircumflex: RawKeysym = 0x2b6;
    #[doc(alias = "XK_idotless")]
    pub const idotless: RawKeysym = 0x2b9;
    #[doc(alias = "XK_gbreve")]
    pub const gbreve: RawKeysym = 0x2bb;
    #[doc(alias = "XK_jcircumflex")]
    pub const jcircumflex: RawKeysym = 0x2bc;
    #[doc(alias = "XK_Cabovedot")]
    pub const Cabovedot: RawKeysym = 0x2c5;
    #[doc(alias = "XK_Ccircumflex")]
    pub const Ccircumflex: RawKeysym = 0x2c6;
    #[doc(alias = "XK_Gabovedot")]
    pub const Gabovedot: RawKeysym = 0x2d5;
    #[doc(alias = "XK_Gcircumflex")]
    pub const Gcircumflex: RawKeysym = 0x2d8;
    #[doc(alias = "XK_Ubreve")]
    pub const Ubreve: RawKeysym = 0x2dd;
    #[doc(alias = "XK_Scircumflex")]
    pub const Scircumflex: RawKeysym = 0x2de;
    #[doc(alias = "XK_cabovedot")]
    pub const cabovedot: RawKeysym = 0x2e5;
    #[doc(alias = "XK_ccircumflex")]
    pub const ccircumflex: RawKeysym = 0x2e6;
    #[doc(alias = "XK_gabovedot")]
    pub const gabovedot: RawKeysym = 0x2f5;
    #[doc(alias = "XK_gcircumflex")]
    pub const gcircumflex: RawKeysym = 0x2f8;
    #[doc(alias = "XK_ubreve")]
    pub const ubreve: RawKeysym = 0x2fd;
    #[doc(alias = "XK_scircumflex")]
    pub const scircumflex: RawKeysym = 0x2fe;
    #[doc(alias = "XK_kra")]
    pub const kra: RawKeysym = 0x3a2;
    #[doc(alias = "XK_kappa")]
    pub const kappa: RawKeysym = 0x3a2;
    #[doc(alias = "XK_Rcedilla")]
    pub const Rcedilla: RawKeysym = 0x3a3;
    #[doc(alias = "XK_Itilde")]
    pub const Itilde: RawKeysym = 0x3a5;
    #[doc(alias = "XK_Lcedilla")]
    pub const Lcedilla: RawKeysym = 0x3a6;
    #[doc(alias = "XK_Emacron")]
    pub const Emacron: RawKeysym = 0x3aa;
    #[doc(alias = "XK_Gcedilla")]
    pub const Gcedilla: RawKeysym = 0x3ab;
    #[doc(alias = "XK_Tslash")]
    pub const Tslash: RawKeysym = 0x3ac;
    #[doc(alias = "XK_rcedilla")]
    pub const rcedilla: RawKeysym = 0x3b3;
    #[doc(alias = "XK_itilde")]
    pub const itilde: RawKeysym = 0x3b5;
    #[doc(alias = "XK_lcedilla")]
    pub const lcedilla: RawKeysym = 0x3b6;
    #[doc(alias = "XK_emacron")]
    pub const emacron: RawKeysym = 0x3ba;
    #[doc(alias = "XK_gcedilla")]
    pub const gcedilla: RawKeysym = 0x3bb;
    #[doc(alias = "XK_tslash")]
    pub const tslash: RawKeysym = 0x3bc;
    #[doc(alias = "XK_ENG")]
    pub const ENG: RawKeysym = 0x3bd;
    #[doc(alias = "XK_eng")]
    pub const eng: RawKeysym = 0x3bf;
    #[doc(alias = "XK_Amacron")]
    pub const Amacron: RawKeysym = 0x3c0;
    #[doc(alias = "XK_Iogonek")]
    pub const Iogonek: RawKeysym = 0x3c7;
    #[doc(alias = "XK_Eabovedot")]
    pub const Eabovedot: RawKeysym = 0x3cc;
    #[doc(alias = "XK_Imacron")]
    pub const Imacron: RawKeysym = 0x3cf;
    #[doc(alias = "XK_Ncedilla")]
    pub const Ncedilla: RawKeysym = 0x3d1;
    #[doc(alias = "XK_Omacron")]
    pub const Omacron: RawKeysym = 0x3d2;
    #[doc(alias = "XK_Kcedilla")]
    pub const Kcedilla: RawKeysym = 0x3d3;
    #[doc(alias = "XK_Uogonek")]
    pub const Uogonek: RawKeysym = 0x3d9;
    #[doc(alias = "XK_Utilde")]
    pub const Utilde: RawKeysym = 0x3dd;
    #[doc(alias = "XK_Umacron")]
    pub const Umacron: RawKeysym = 0x3de;
    #[doc(alias = "XK_amacron")]
    pub const amacron: RawKeysym = 0x3e0;
    #[doc(alias = "XK_iogonek")]
    pub const iogonek: RawKeysym = 0x3e7;
    #[doc(alias = "XK_eabovedot")]
    pub const eabovedot: RawKeysym = 0x3ec;
    #[doc(alias = "XK_imacron")]
    pub const imacron: RawKeysym = 0x3ef;
    #[doc(alias = "XK_ncedilla")]
    pub const ncedilla: RawKeysym = 0x3f1;
    #[doc(alias = "XK_omacron")]
    pub const omacron: RawKeysym = 0x3f2;
    #[doc(alias = "XK_kcedilla")]
    pub const kcedilla: RawKeysym = 0x3f3;
    #[doc(alias = "XK_uogonek")]
    pub const uogonek: RawKeysym = 0x3f9;
    #[doc(alias = "XK_utilde")]
    pub const utilde: RawKeysym = 0x3fd;
    #[doc(alias = "XK_umacron")]
    pub const umacron: RawKeysym = 0x3fe;
    #[doc(alias = "XK_Wcircumflex")]
    pub const Wcircumflex: RawKeysym = 0x1000174;
    #[doc(alias = "XK_wcircumflex")]
    pub const wcircumflex: RawKeysym = 0x1000175;
    #[doc(alias = "XK_Ycircumflex")]
    pub const Ycircumflex: RawKeysym = 0x1000176;
    #[doc(alias = "XK_ycircumflex")]
    pub const ycircumflex: RawKeysym = 0x1000177;
    #[doc(alias = "XK_Babovedot")]
    pub const Babovedot: RawKeysym = 0x1001e02;
    #[doc(alias = "XK_babovedot")]
    pub const babovedot: RawKeysym = 0x1001e03;
    #[doc(alias = "XK_Dabovedot")]
    pub const Dabovedot: RawKeysym = 0x1001e0a;
    #[doc(alias = "XK_dabovedot")]
    pub const dabovedot: RawKeysym = 0x1001e0b;
    #[doc(alias = "XK_Fabovedot")]
    pub const Fabovedot: RawKeysym = 0x1001e1e;
    #[doc(alias = "XK_fabovedot")]
    pub const fabovedot: RawKeysym = 0x1001e1f;
    #[doc(alias = "XK_Mabovedot")]
    pub const Mabovedot: RawKeysym = 0x1001e40;
    #[doc(alias = "XK_mabovedot")]
    pub const mabovedot: RawKeysym = 0x1001e41;
    #[doc(alias = "XK_Pabovedot")]
    pub const Pabovedot: RawKeysym = 0x1001e56;
    #[doc(alias = "XK_pabovedot")]
    pub const pabovedot: RawKeysym = 0x1001e57;
    #[doc(alias = "XK_Sabovedot")]
    pub const Sabovedot: RawKeysym = 0x1001e60;
    #[doc(alias = "XK_sabovedot")]
    pub const sabovedot: RawKeysym = 0x1001e61;
    #[doc(alias = "XK_Tabovedot")]
    pub const Tabovedot: RawKeysym = 0x1001e6a;
    #[doc(alias = "XK_tabovedot")]
    pub const tabovedot: RawKeysym = 0x1001e6b;
    #[doc(alias = "XK_Wgrave")]
    pub const Wgrave: RawKeysym = 0x1001e80;
    #[doc(alias = "XK_wgrave")]
    pub const wgrave: RawKeysym = 0x1001e81;
    #[doc(alias = "XK_Wacute")]
    pub const Wacute: RawKeysym = 0x1001e82;
    #[doc(alias = "XK_wacute")]
    pub const wacute: RawKeysym = 0x1001e83;
    #[doc(alias = "XK_Wdiaeresis")]
    pub const Wdiaeresis: RawKeysym = 0x1001e84;
    #[doc(alias = "XK_wdiaeresis")]
    pub const wdiaeresis: RawKeysym = 0x1001e85;
    #[doc(alias = "XK_Ygrave")]
    pub const Ygrave: RawKeysym = 0x1001ef2;
    #[doc(alias = "XK_ygrave")]
    pub const ygrave: RawKeysym = 0x1001ef3;
    #[doc(alias = "XK_OE")]
    pub const OE: RawKeysym = 0x13bc;
    #[doc(alias = "XK_oe")]
    pub const oe: RawKeysym = 0x13bd;
    #[doc(alias = "XK_Ydiaeresis")]
    pub const Ydiaeresis: RawKeysym = 0x13be;
    #[doc(alias = "XK_overline")]
    pub const overline: RawKeysym = 0x47e;
    #[doc(alias = "XK_kana_fullstop")]
    pub const kana_fullstop: RawKeysym = 0x4a1;
    #[doc(alias = "XK_kana_openingbracket")]
    pub const kana_openingbracket: RawKeysym = 0x4a2;
    #[doc(alias = "XK_kana_closingbracket")]
    pub const kana_closingbracket: RawKeysym = 0x4a3;
    #[doc(alias = "XK_kana_comma")]
    pub const kana_comma: RawKeysym = 0x4a4;
    #[doc(alias = "XK_kana_conjunctive")]
    pub const kana_conjunctive: RawKeysym = 0x4a5;
    #[doc(alias = "XK_kana_middledot")]
    pub const kana_middledot: RawKeysym = 0x4a5;
    #[doc(alias = "XK_kana_WO")]
    pub const kana_WO: RawKeysym = 0x4a6;
    #[doc(alias = "XK_kana_a")]
    pub const kana_a: RawKeysym = 0x4a7;
    #[doc(alias = "XK_kana_i")]
    pub const kana_i: RawKeysym = 0x4a8;
    #[doc(alias = "XK_kana_u")]
    pub const kana_u: RawKeysym = 0x4a9;
    #[doc(alias = "XK_kana_e")]
    pub const kana_e: RawKeysym = 0x4aa;
    #[doc(alias = "XK_kana_o")]
    pub const kana_o: RawKeysym = 0x4ab;
    #[doc(alias = "XK_kana_ya")]
    pub const kana_ya: RawKeysym = 0x4ac;
    #[doc(alias = "XK_kana_yu")]
    pub const kana_yu: RawKeysym = 0x4ad;
    #[doc(alias = "XK_kana_yo")]
    pub const kana_yo: RawKeysym = 0x4ae;
    #[doc(alias = "XK_kana_tsu")]
    pub const kana_tsu: RawKeysym = 0x4af;
    #[doc(alias = "XK_kana_tu")]
    pub const kana_tu: RawKeysym = 0x4af;
    #[doc(alias = "XK_prolongedsound")]
    pub const prolongedsound: RawKeysym = 0x4b0;
    #[doc(alias = "XK_kana_A")]
    pub const kana_A: RawKeysym = 0x4b1;
    #[doc(alias = "XK_kana_I")]
    pub const kana_I: RawKeysym = 0x4b2;
    #[doc(alias = "XK_kana_U")]
    pub const kana_U: RawKeysym = 0x4b3;
    #[doc(alias = "XK_kana_E")]
    pub const kana_E: RawKeysym = 0x4b4;
    #[doc(alias = "XK_kana_O")]
    pub const kana_O: RawKeysym = 0x4b5;
    #[doc(alias = "XK_kana_KA")]
    pub const kana_KA: RawKeysym = 0x4b6;
    #[doc(alias = "XK_kana_KI")]
    pub const kana_KI: RawKeysym = 0x4b7;
    #[doc(alias = "XK_kana_KU")]
    pub const kana_KU: RawKeysym = 0x4b8;
    #[doc(alias = "XK_kana_KE")]
    pub const kana_KE: RawKeysym = 0x4b9;
    #[doc(alias = "XK_kana_KO")]
    pub const kana_KO: RawKeysym = 0x4ba;
    #[doc(alias = "XK_kana_SA")]
    pub const kana_SA: RawKeysym = 0x4bb;
    #[doc(alias = "XK_kana_SHI")]
    pub const kana_SHI: RawKeysym = 0x4bc;
    #[doc(alias = "XK_kana_SU")]
    pub const kana_SU: RawKeysym = 0x4bd;
    #[doc(alias = "XK_kana_SE")]
    pub const kana_SE: RawKeysym = 0x4be;
    #[doc(alias = "XK_kana_SO")]
    pub const kana_SO: RawKeysym = 0x4bf;
    #[doc(alias = "XK_kana_TA")]
    pub const kana_TA: RawKeysym = 0x4c0;
    #[doc(alias = "XK_kana_CHI")]
    pub const kana_CHI: RawKeysym = 0x4c1;
    #[doc(alias = "XK_kana_TI")]
    pub const kana_TI: RawKeysym = 0x4c1;
    #[doc(alias = "XK_kana_TSU")]
    pub const kana_TSU: RawKeysym = 0x4c2;
    #[doc(alias = "XK_kana_TU")]
    pub const kana_TU: RawKeysym = 0x4c2;
    #[doc(alias = "XK_kana_TE")]
    pub const kana_TE: RawKeysym = 0x4c3;
    #[doc(alias = "XK_kana_TO")]
    pub const kana_TO: RawKeysym = 0x4c4;
    #[doc(alias = "XK_kana_NA")]
    pub const kana_NA: RawKeysym = 0x4c5;
    #[doc(alias = "XK_kana_NI")]
    pub const kana_NI: RawKeysym = 0x4c6;
    #[doc(alias = "XK_kana_NU")]
    pub const kana_NU: RawKeysym = 0x4c7;
    #[doc(alias = "XK_kana_NE")]
    pub const kana_NE: RawKeysym = 0x4c8;
    #[doc(alias = "XK_kana_NO")]
    pub const kana_NO: RawKeysym = 0x4c9;
    #[doc(alias = "XK_kana_HA")]
    pub const kana_HA: RawKeysym = 0x4ca;
    #[doc(alias = "XK_kana_HI")]
    pub const kana_HI: RawKeysym = 0x4cb;
    #[doc(alias = "XK_kana_FU")]
    pub const kana_FU: RawKeysym = 0x4cc;
    #[doc(alias = "XK_kana_HU")]
    pub const kana_HU: RawKeysym = 0x4cc;
    #[doc(alias = "XK_kana_HE")]
    pub const kana_HE: RawKeysym = 0x4cd;
    #[doc(alias = "XK_kana_HO")]
    pub const kana_HO: RawKeysym = 0x4ce;
    #[doc(alias = "XK_kana_MA")]
    pub const kana_MA: RawKeysym = 0x4cf;
    #[doc(alias = "XK_kana_MI")]
    pub const kana_MI: RawKeysym = 0x4d0;
    #[doc(alias = "XK_kana_MU")]
    pub const kana_MU: RawKeysym = 0x4d1;
    #[doc(alias = "XK_kana_ME")]
    pub const kana_ME: RawKeysym = 0x4d2;
    #[doc(alias = "XK_kana_MO")]
    pub const kana_MO: RawKeysym = 0x4d3;
    #[doc(alias = "XK_kana_YA")]
    pub const kana_YA: RawKeysym = 0x4d4;
    #[doc(alias = "XK_kana_YU")]
    pub const kana_YU: RawKeysym = 0x4d5;
    #[doc(alias = "XK_kana_YO")]
    pub const kana_YO: RawKeysym = 0x4d6;
    #[doc(alias = "XK_kana_RA")]
    pub const kana_RA: RawKeysym = 0x4d7;
    #[doc(alias = "XK_kana_RI")]
    pub const kana_RI: RawKeysym = 0x4d8;
    #[doc(alias = "XK_kana_RU")]
    pub const kana_RU: RawKeysym = 0x4d9;
    #[doc(alias = "XK_kana_RE")]
    pub const kana_RE: RawKeysym = 0x4da;
    #[doc(alias = "XK_kana_RO")]
    pub const kana_RO: RawKeysym = 0x4db;
    #[doc(alias = "XK_kana_WA")]
    pub const kana_WA: RawKeysym = 0x4dc;
    #[doc(alias = "XK_kana_N")]
    pub const kana_N: RawKeysym = 0x4dd;
    #[doc(alias = "XK_voicedsound")]
    pub const voicedsound: RawKeysym = 0x4de;
    #[doc(alias = "XK_semivoicedsound")]
    pub const semivoicedsound: RawKeysym = 0x4df;
    #[doc(alias = "XK_kana_switch")]
    pub const kana_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_Farsi_0")]
    pub const Farsi_0: RawKeysym = 0x10006f0;
    #[doc(alias = "XK_Farsi_1")]
    pub const Farsi_1: RawKeysym = 0x10006f1;
    #[doc(alias = "XK_Farsi_2")]
    pub const Farsi_2: RawKeysym = 0x10006f2;
    #[doc(alias = "XK_Farsi_3")]
    pub const Farsi_3: RawKeysym = 0x10006f3;
    #[doc(alias = "XK_Farsi_4")]
    pub const Farsi_4: RawKeysym = 0x10006f4;
    #[doc(alias = "XK_Farsi_5")]
    pub const Farsi_5: RawKeysym = 0x10006f5;
    #[doc(alias = "XK_Farsi_6")]
    pub const Farsi_6: RawKeysym = 0x10006f6;
    #[doc(alias = "XK_Farsi_7")]
    pub const Farsi_7: RawKeysym = 0x10006f7;
    #[doc(alias = "XK_Farsi_8")]
    pub const Farsi_8: RawKeysym = 0x10006f8;
    #[doc(alias = "XK_Farsi_9")]
    pub const Farsi_9: RawKeysym = 0x10006f9;
    #[doc(alias = "XK_Arabic_percent")]
    pub const Arabic_percent: RawKeysym = 0x100066a;
    #[doc(alias = "XK_Arabic_superscript_alef")]
    pub const Arabic_superscript_alef: RawKeysym = 0x1000670;
    #[doc(alias = "XK_Arabic_tteh")]
    pub const Arabic_tteh: RawKeysym = 0x1000679;
    #[doc(alias = "XK_Arabic_peh")]
    pub const Arabic_peh: RawKeysym = 0x100067e;
    #[doc(alias = "XK_Arabic_tcheh")]
    pub const Arabic_tcheh: RawKeysym = 0x1000686;
    #[doc(alias = "XK_Arabic_ddal")]
    pub const Arabic_ddal: RawKeysym = 0x1000688;
    #[doc(alias = "XK_Arabic_rreh")]
    pub const Arabic_rreh: RawKeysym = 0x1000691;
    #[doc(alias = "XK_Arabic_comma")]
    pub const Arabic_comma: RawKeysym = 0x5ac;
    #[doc(alias = "XK_Arabic_fullstop")]
    pub const Arabic_fullstop: RawKeysym = 0x10006d4;
    #[doc(alias = "XK_Arabic_0")]
    pub const Arabic_0: RawKeysym = 0x1000660;
    #[doc(alias = "XK_Arabic_1")]
    pub const Arabic_1: RawKeysym = 0x1000661;
    #[doc(alias = "XK_Arabic_2")]
    pub const Arabic_2: RawKeysym = 0x1000662;
    #[doc(alias = "XK_Arabic_3")]
    pub const Arabic_3: RawKeysym = 0x1000663;
    #[doc(alias = "XK_Arabic_4")]
    pub const Arabic_4: RawKeysym = 0x1000664;
    #[doc(alias = "XK_Arabic_5")]
    pub const Arabic_5: RawKeysym = 0x1000665;
    #[doc(alias = "XK_Arabic_6")]
    pub const Arabic_6: RawKeysym = 0x1000666;
    #[doc(alias = "XK_Arabic_7")]
    pub const Arabic_7: RawKeysym = 0x1000667;
    #[doc(alias = "XK_Arabic_8")]
    pub const Arabic_8: RawKeysym = 0x1000668;
    #[doc(alias = "XK_Arabic_9")]
    pub const Arabic_9: RawKeysym = 0x1000669;
    #[doc(alias = "XK_Arabic_semicolon")]
    pub const Arabic_semicolon: RawKeysym = 0x5bb;
    #[doc(alias = "XK_Arabic_question_mark")]
    pub const Arabic_question_mark: RawKeysym = 0x5bf;
    #[doc(alias = "XK_Arabic_hamza")]
    pub const Arabic_hamza: RawKeysym = 0x5c1;
    #[doc(alias = "XK_Arabic_maddaonalef")]
    pub const Arabic_maddaonalef: RawKeysym = 0x5c2;
    #[doc(alias = "XK_Arabic_hamzaonalef")]
    pub const Arabic_hamzaonalef: RawKeysym = 0x5c3;
    #[doc(alias = "XK_Arabic_hamzaonwaw")]
    pub const Arabic_hamzaonwaw: RawKeysym = 0x5c4;
    #[doc(alias = "XK_Arabic_hamzaunderalef")]
    pub const Arabic_hamzaunderalef: RawKeysym = 0x5c5;
    #[doc(alias = "XK_Arabic_hamzaonyeh")]
    pub const Arabic_hamzaonyeh: RawKeysym = 0x5c6;
    #[doc(alias = "XK_Arabic_alef")]
    pub const Arabic_alef: RawKeysym = 0x5c7;
    #[doc(alias = "XK_Arabic_beh")]
    pub const Arabic_beh: RawKeysym = 0x5c8;
    #[doc(alias = "XK_Arabic_tehmarbuta")]
    pub const Arabic_tehmarbuta: RawKeysym = 0x5c9;
    #[doc(alias = "XK_Arabic_teh")]
    pub const Arabic_teh: RawKeysym = 0x5ca;
    #[doc(alias = "XK_Arabic_theh")]
    pub const Arabic_theh: RawKeysym = 0x5cb;
    #[doc(alias = "XK_Arabic_jeem")]
    pub const Arabic_jeem: RawKeysym = 0x5cc;
    #[doc(alias = "XK_Arabic_hah")]
    pub const Arabic_hah: RawKeysym = 0x5cd;
    #[doc(alias = "XK_Arabic_khah")]
    pub const Arabic_khah: RawKeysym = 0x5ce;
    #[doc(alias = "XK_Arabic_dal")]
    pub const Arabic_dal: RawKeysym = 0x5cf;
    #[doc(alias = "XK_Arabic_thal")]
    pub const Arabic_thal: RawKeysym = 0x5d0;
    #[doc(alias = "XK_Arabic_ra")]
    pub const Arabic_ra: RawKeysym = 0x5d1;
    #[doc(alias = "XK_Arabic_zain")]
    pub const Arabic_zain: RawKeysym = 0x5d2;
    #[doc(alias = "XK_Arabic_seen")]
    pub const Arabic_seen: RawKeysym = 0x5d3;
    #[doc(alias = "XK_Arabic_sheen")]
    pub const Arabic_sheen: RawKeysym = 0x5d4;
    #[doc(alias = "XK_Arabic_sad")]
    pub const Arabic_sad: RawKeysym = 0x5d5;
    #[doc(alias = "XK_Arabic_dad")]
    pub const Arabic_dad: RawKeysym = 0x5d6;
    #[doc(alias = "XK_Arabic_tah")]
    pub const Arabic_tah: RawKeysym = 0x5d7;
    #[doc(alias = "XK_Arabic_zah")]
    pub const Arabic_zah: RawKeysym = 0x5d8;
    #[doc(alias = "XK_Arabic_ain")]
    pub const Arabic_ain: RawKeysym = 0x5d9;
    #[doc(alias = "XK_Arabic_ghain")]
    pub const Arabic_ghain: RawKeysym = 0x5da;
    #[doc(alias = "XK_Arabic_tatweel")]
    pub const Arabic_tatweel: RawKeysym = 0x5e0;
    #[doc(alias = "XK_Arabic_feh")]
    pub const Arabic_feh: RawKeysym = 0x5e1;
    #[doc(alias = "XK_Arabic_qaf")]
    pub const Arabic_qaf: RawKeysym = 0x5e2;
    #[doc(alias = "XK_Arabic_kaf")]
    pub const Arabic_kaf: RawKeysym = 0x5e3;
    #[doc(alias = "XK_Arabic_lam")]
    pub const Arabic_lam: RawKeysym = 0x5e4;
    #[doc(alias = "XK_Arabic_meem")]
    pub const Arabic_meem: RawKeysym = 0x5e5;
    #[doc(alias = "XK_Arabic_noon")]
    pub const Arabic_noon: RawKeysym = 0x5e6;
    #[doc(alias = "XK_Arabic_ha")]
    pub const Arabic_ha: RawKeysym = 0x5e7;
    #[doc(alias = "XK_Arabic_heh")]
    pub const Arabic_heh: RawKeysym = 0x5e7;
    #[doc(alias = "XK_Arabic_waw")]
    pub const Arabic_waw: RawKeysym = 0x5e8;
    #[doc(alias = "XK_Arabic_alefmaksura")]
    pub const Arabic_alefmaksura: RawKeysym = 0x5e9;
    #[doc(alias = "XK_Arabic_yeh")]
    pub const Arabic_yeh: RawKeysym = 0x5ea;
    #[doc(alias = "XK_Arabic_fathatan")]
    pub const Arabic_fathatan: RawKeysym = 0x5eb;
    #[doc(alias = "XK_Arabic_dammatan")]
    pub const Arabic_dammatan: RawKeysym = 0x5ec;
    #[doc(alias = "XK_Arabic_kasratan")]
    pub const Arabic_kasratan: RawKeysym = 0x5ed;
    #[doc(alias = "XK_Arabic_fatha")]
    pub const Arabic_fatha: RawKeysym = 0x5ee;
    #[doc(alias = "XK_Arabic_damma")]
    pub const Arabic_damma: RawKeysym = 0x5ef;
    #[doc(alias = "XK_Arabic_kasra")]
    pub const Arabic_kasra: RawKeysym = 0x5f0;
    #[doc(alias = "XK_Arabic_shadda")]
    pub const Arabic_shadda: RawKeysym = 0x5f1;
    #[doc(alias = "XK_Arabic_sukun")]
    pub const Arabic_sukun: RawKeysym = 0x5f2;
    #[doc(alias = "XK_Arabic_madda_above")]
    pub const Arabic_madda_above: RawKeysym = 0x1000653;
    #[doc(alias = "XK_Arabic_hamza_above")]
    pub const Arabic_hamza_above: RawKeysym = 0x1000654;
    #[doc(alias = "XK_Arabic_hamza_below")]
    pub const Arabic_hamza_below: RawKeysym = 0x1000655;
    #[doc(alias = "XK_Arabic_jeh")]
    pub const Arabic_jeh: RawKeysym = 0x1000698;
    #[doc(alias = "XK_Arabic_veh")]
    pub const Arabic_veh: RawKeysym = 0x10006a4;
    #[doc(alias = "XK_Arabic_keheh")]
    pub const Arabic_keheh: RawKeysym = 0x10006a9;
    #[doc(alias = "XK_Arabic_gaf")]
    pub const Arabic_gaf: RawKeysym = 0x10006af;
    #[doc(alias = "XK_Arabic_noon_ghunna")]
    pub const Arabic_noon_ghunna: RawKeysym = 0x10006ba;
    #[doc(alias = "XK_Arabic_heh_doachashmee")]
    pub const Arabic_heh_doachashmee: RawKeysym = 0x10006be;
    #[doc(alias = "XK_Farsi_yeh")]
    pub const Farsi_yeh: RawKeysym = 0x10006cc;
    #[doc(alias = "XK_Arabic_farsi_yeh")]
    pub const Arabic_farsi_yeh: RawKeysym = 0x10006cc;
    #[doc(alias = "XK_Arabic_yeh_baree")]
    pub const Arabic_yeh_baree: RawKeysym = 0x10006d2;
    #[doc(alias = "XK_Arabic_heh_goal")]
    pub const Arabic_heh_goal: RawKeysym = 0x10006c1;
    #[doc(alias = "XK_Arabic_switch")]
    pub const Arabic_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_Cyrillic_GHE_bar")]
    pub const Cyrillic_GHE_bar: RawKeysym = 0x1000492;
    #[doc(alias = "XK_Cyrillic_ghe_bar")]
    pub const Cyrillic_ghe_bar: RawKeysym = 0x1000493;
    #[doc(alias = "XK_Cyrillic_ZHE_descender")]
    pub const Cyrillic_ZHE_descender: RawKeysym = 0x1000496;
    #[doc(alias = "XK_Cyrillic_zhe_descender")]
    pub const Cyrillic_zhe_descender: RawKeysym = 0x1000497;
    #[doc(alias = "XK_Cyrillic_KA_descender")]
    pub const Cyrillic_KA_descender: RawKeysym = 0x100049a;
    #[doc(alias = "XK_Cyrillic_ka_descender")]
    pub const Cyrillic_ka_descender: RawKeysym = 0x100049b;
    #[doc(alias = "XK_Cyrillic_KA_vertstroke")]
    pub const Cyrillic_KA_vertstroke: RawKeysym = 0x100049c;
    #[doc(alias = "XK_Cyrillic_ka_vertstroke")]
    pub const Cyrillic_ka_vertstroke: RawKeysym = 0x100049d;
    #[doc(alias = "XK_Cyrillic_EN_descender")]
    pub const Cyrillic_EN_descender: RawKeysym = 0x10004a2;
    #[doc(alias = "XK_Cyrillic_en_descender")]
    pub const Cyrillic_en_descender: RawKeysym = 0x10004a3;
    #[doc(alias = "XK_Cyrillic_U_straight")]
    pub const Cyrillic_U_straight: RawKeysym = 0x10004ae;
    #[doc(alias = "XK_Cyrillic_u_straight")]
    pub const Cyrillic_u_straight: RawKeysym = 0x10004af;
    #[doc(alias = "XK_Cyrillic_U_straight_bar")]
    pub const Cyrillic_U_straight_bar: RawKeysym = 0x10004b0;
    #[doc(alias = "XK_Cyrillic_u_straight_bar")]
    pub const Cyrillic_u_straight_bar: RawKeysym = 0x10004b1;
    #[doc(alias = "XK_Cyrillic_HA_descender")]
    pub const Cyrillic_HA_descender: RawKeysym = 0x10004b2;
    #[doc(alias = "XK_Cyrillic_ha_descender")]
    pub const Cyrillic_ha_descender: RawKeysym = 0x10004b3;
    #[doc(alias = "XK_Cyrillic_CHE_descender")]
    pub const Cyrillic_CHE_descender: RawKeysym = 0x10004b6;
    #[doc(alias = "XK_Cyrillic_che_descender")]
    pub const Cyrillic_che_descender: RawKeysym = 0x10004b7;
    #[doc(alias = "XK_Cyrillic_CHE_vertstroke")]
    pub const Cyrillic_CHE_vertstroke: RawKeysym = 0x10004b8;
    #[doc(alias = "XK_Cyrillic_che_vertstroke")]
    pub const Cyrillic_che_vertstroke: RawKeysym = 0x10004b9;
    #[doc(alias = "XK_Cyrillic_SHHA")]
    pub const Cyrillic_SHHA: RawKeysym = 0x10004ba;
    #[doc(alias = "XK_Cyrillic_shha")]
    pub const Cyrillic_shha: RawKeysym = 0x10004bb;
    #[doc(alias = "XK_Cyrillic_SCHWA")]
    pub const Cyrillic_SCHWA: RawKeysym = 0x10004d8;
    #[doc(alias = "XK_Cyrillic_schwa")]
    pub const Cyrillic_schwa: RawKeysym = 0x10004d9;
    #[doc(alias = "XK_Cyrillic_I_macron")]
    pub const Cyrillic_I_macron: RawKeysym = 0x10004e2;
    #[doc(alias = "XK_Cyrillic_i_macron")]
    pub const Cyrillic_i_macron: RawKeysym = 0x10004e3;
    #[doc(alias = "XK_Cyrillic_O_bar")]
    pub const Cyrillic_O_bar: RawKeysym = 0x10004e8;
    #[doc(alias = "XK_Cyrillic_o_bar")]
    pub const Cyrillic_o_bar: RawKeysym = 0x10004e9;
    #[doc(alias = "XK_Cyrillic_U_macron")]
    pub const Cyrillic_U_macron: RawKeysym = 0x10004ee;
    #[doc(alias = "XK_Cyrillic_u_macron")]
    pub const Cyrillic_u_macron: RawKeysym = 0x10004ef;
    #[doc(alias = "XK_Serbian_dje")]
    pub const Serbian_dje: RawKeysym = 0x6a1;
    #[doc(alias = "XK_Macedonia_gje")]
    pub const Macedonia_gje: RawKeysym = 0x6a2;
    #[doc(alias = "XK_Cyrillic_io")]
    pub const Cyrillic_io: RawKeysym = 0x6a3;
    #[doc(alias = "XK_Ukrainian_ie")]
    pub const Ukrainian_ie: RawKeysym = 0x6a4;
    #[doc(alias = "XK_Ukranian_je")]
    pub const Ukranian_je: RawKeysym = 0x6a4;
    #[doc(alias = "XK_Macedonia_dse")]
    pub const Macedonia_dse: RawKeysym = 0x6a5;
    #[doc(alias = "XK_Ukrainian_i")]
    pub const Ukrainian_i: RawKeysym = 0x6a6;
    #[doc(alias = "XK_Ukranian_i")]
    pub const Ukranian_i: RawKeysym = 0x6a6;
    #[doc(alias = "XK_Ukrainian_yi")]
    pub const Ukrainian_yi: RawKeysym = 0x6a7;
    #[doc(alias = "XK_Ukranian_yi")]
    pub const Ukranian_yi: RawKeysym = 0x6a7;
    #[doc(alias = "XK_Cyrillic_je")]
    pub const Cyrillic_je: RawKeysym = 0x6a8;
    #[doc(alias = "XK_Serbian_je")]
    pub const Serbian_je: RawKeysym = 0x6a8;
    #[doc(alias = "XK_Cyrillic_lje")]
    pub const Cyrillic_lje: RawKeysym = 0x6a9;
    #[doc(alias = "XK_Serbian_lje")]
    pub const Serbian_lje: RawKeysym = 0x6a9;
    #[doc(alias = "XK_Cyrillic_nje")]
    pub const Cyrillic_nje: RawKeysym = 0x6aa;
    #[doc(alias = "XK_Serbian_nje")]
    pub const Serbian_nje: RawKeysym = 0x6aa;
    #[doc(alias = "XK_Serbian_tshe")]
    pub const Serbian_tshe: RawKeysym = 0x6ab;
    #[doc(alias = "XK_Macedonia_kje")]
    pub const Macedonia_kje: RawKeysym = 0x6ac;
    #[doc(alias = "XK_Ukrainian_ghe_with_upturn")]
    pub const Ukrainian_ghe_with_upturn: RawKeysym = 0x6ad;
    #[doc(alias = "XK_Byelorussian_shortu")]
    pub const Byelorussian_shortu: RawKeysym = 0x6ae;
    #[doc(alias = "XK_Cyrillic_dzhe")]
    pub const Cyrillic_dzhe: RawKeysym = 0x6af;
    #[doc(alias = "XK_Serbian_dze")]
    pub const Serbian_dze: RawKeysym = 0x6af;
    #[doc(alias = "XK_numerosign")]
    pub const numerosign: RawKeysym = 0x6b0;
    #[doc(alias = "XK_Serbian_DJE")]
    pub const Serbian_DJE: RawKeysym = 0x6b1;
    #[doc(alias = "XK_Macedonia_GJE")]
    pub const Macedonia_GJE: RawKeysym = 0x6b2;
    #[doc(alias = "XK_Cyrillic_IO")]
    pub const Cyrillic_IO: RawKeysym = 0x6b3;
    #[doc(alias = "XK_Ukrainian_IE")]
    pub const Ukrainian_IE: RawKeysym = 0x6b4;
    #[doc(alias = "XK_Ukranian_JE")]
    pub const Ukranian_JE: RawKeysym = 0x6b4;
    #[doc(alias = "XK_Macedonia_DSE")]
    pub const Macedonia_DSE: RawKeysym = 0x6b5;
    #[doc(alias = "XK_Ukrainian_I")]
    pub const Ukrainian_I: RawKeysym = 0x6b6;
    #[doc(alias = "XK_Ukranian_I")]
    pub const Ukranian_I: RawKeysym = 0x6b6;
    #[doc(alias = "XK_Ukrainian_YI")]
    pub const Ukrainian_YI: RawKeysym = 0x6b7;
    #[doc(alias = "XK_Ukranian_YI")]
    pub const Ukranian_YI: RawKeysym = 0x6b7;
    #[doc(alias = "XK_Cyrillic_JE")]
    pub const Cyrillic_JE: RawKeysym = 0x6b8;
    #[doc(alias = "XK_Serbian_JE")]
    pub const Serbian_JE: RawKeysym = 0x6b8;
    #[doc(alias = "XK_Cyrillic_LJE")]
    pub const Cyrillic_LJE: RawKeysym = 0x6b9;
    #[doc(alias = "XK_Serbian_LJE")]
    pub const Serbian_LJE: RawKeysym = 0x6b9;
    #[doc(alias = "XK_Cyrillic_NJE")]
    pub const Cyrillic_NJE: RawKeysym = 0x6ba;
    #[doc(alias = "XK_Serbian_NJE")]
    pub const Serbian_NJE: RawKeysym = 0x6ba;
    #[doc(alias = "XK_Serbian_TSHE")]
    pub const Serbian_TSHE: RawKeysym = 0x6bb;
    #[doc(alias = "XK_Macedonia_KJE")]
    pub const Macedonia_KJE: RawKeysym = 0x6bc;
    #[doc(alias = "XK_Ukrainian_GHE_WITH_UPTURN")]
    pub const Ukrainian_GHE_WITH_UPTURN: RawKeysym = 0x6bd;
    #[doc(alias = "XK_Byelorussian_SHORTU")]
    pub const Byelorussian_SHORTU: RawKeysym = 0x6be;
    #[doc(alias = "XK_Cyrillic_DZHE")]
    pub const Cyrillic_DZHE: RawKeysym = 0x6bf;
    #[doc(alias = "XK_Serbian_DZE")]
    pub const Serbian_DZE: RawKeysym = 0x6bf;
    #[doc(alias = "XK_Cyrillic_yu")]
    pub const Cyrillic_yu: RawKeysym = 0x6c0;
    #[doc(alias = "XK_Cyrillic_a")]
    pub const Cyrillic_a: RawKeysym = 0x6c1;
    #[doc(alias = "XK_Cyrillic_be")]
    pub const Cyrillic_be: RawKeysym = 0x6c2;
    #[doc(alias = "XK_Cyrillic_tse")]
    pub const Cyrillic_tse: RawKeysym = 0x6c3;
    #[doc(alias = "XK_Cyrillic_de")]
    pub const Cyrillic_de: RawKeysym = 0x6c4;
    #[doc(alias = "XK_Cyrillic_ie")]
    pub const Cyrillic_ie: RawKeysym = 0x6c5;
    #[doc(alias = "XK_Cyrillic_ef")]
    pub const Cyrillic_ef: RawKeysym = 0x6c6;
    #[doc(alias = "XK_Cyrillic_ghe")]
    pub const Cyrillic_ghe: RawKeysym = 0x6c7;
    #[doc(alias = "XK_Cyrillic_ha")]
    pub const Cyrillic_ha: RawKeysym = 0x6c8;
    #[doc(alias = "XK_Cyrillic_i")]
    pub const Cyrillic_i: RawKeysym = 0x6c9;
    #[doc(alias = "XK_Cyrillic_shorti")]
    pub const Cyrillic_shorti: RawKeysym = 0x6ca;
    #[doc(alias = "XK_Cyrillic_ka")]
    pub const Cyrillic_ka: RawKeysym = 0x6cb;
    #[doc(alias = "XK_Cyrillic_el")]
    pub const Cyrillic_el: RawKeysym = 0x6cc;
    #[doc(alias = "XK_Cyrillic_em")]
    pub const Cyrillic_em: RawKeysym = 0x6cd;
    #[doc(alias = "XK_Cyrillic_en")]
    pub const Cyrillic_en: RawKeysym = 0x6ce;
    #[doc(alias = "XK_Cyrillic_o")]
    pub const Cyrillic_o: RawKeysym = 0x6cf;
    #[doc(alias = "XK_Cyrillic_pe")]
    pub const Cyrillic_pe: RawKeysym = 0x6d0;
    #[doc(alias = "XK_Cyrillic_ya")]
    pub const Cyrillic_ya: RawKeysym = 0x6d1;
    #[doc(alias = "XK_Cyrillic_er")]
    pub const Cyrillic_er: RawKeysym = 0x6d2;
    #[doc(alias = "XK_Cyrillic_es")]
    pub const Cyrillic_es: RawKeysym = 0x6d3;
    #[doc(alias = "XK_Cyrillic_te")]
    pub const Cyrillic_te: RawKeysym = 0x6d4;
    #[doc(alias = "XK_Cyrillic_u")]
    pub const Cyrillic_u: RawKeysym = 0x6d5;
    #[doc(alias = "XK_Cyrillic_zhe")]
    pub const Cyrillic_zhe: RawKeysym = 0x6d6;
    #[doc(alias = "XK_Cyrillic_ve")]
    pub const Cyrillic_ve: RawKeysym = 0x6d7;
    #[doc(alias = "XK_Cyrillic_softsign")]
    pub const Cyrillic_softsign: RawKeysym = 0x6d8;
    #[doc(alias = "XK_Cyrillic_yeru")]
    pub const Cyrillic_yeru: RawKeysym = 0x6d9;
    #[doc(alias = "XK_Cyrillic_ze")]
    pub const Cyrillic_ze: RawKeysym = 0x6da;
    #[doc(alias = "XK_Cyrillic_sha")]
    pub const Cyrillic_sha: RawKeysym = 0x6db;
    #[doc(alias = "XK_Cyrillic_e")]
    pub const Cyrillic_e: RawKeysym = 0x6dc;
    #[doc(alias = "XK_Cyrillic_shcha")]
    pub const Cyrillic_shcha: RawKeysym = 0x6dd;
    #[doc(alias = "XK_Cyrillic_che")]
    pub const Cyrillic_che: RawKeysym = 0x6de;
    #[doc(alias = "XK_Cyrillic_hardsign")]
    pub const Cyrillic_hardsign: RawKeysym = 0x6df;
    #[doc(alias = "XK_Cyrillic_YU")]
    pub const Cyrillic_YU: RawKeysym = 0x6e0;
    #[doc(alias = "XK_Cyrillic_A")]
    pub const Cyrillic_A: RawKeysym = 0x6e1;
    #[doc(alias = "XK_Cyrillic_BE")]
    pub const Cyrillic_BE: RawKeysym = 0x6e2;
    #[doc(alias = "XK_Cyrillic_TSE")]
    pub const Cyrillic_TSE: RawKeysym = 0x6e3;
    #[doc(alias = "XK_Cyrillic_DE")]
    pub const Cyrillic_DE: RawKeysym = 0x6e4;
    #[doc(alias = "XK_Cyrillic_IE")]
    pub const Cyrillic_IE: RawKeysym = 0x6e5;
    #[doc(alias = "XK_Cyrillic_EF")]
    pub const Cyrillic_EF: RawKeysym = 0x6e6;
    #[doc(alias = "XK_Cyrillic_GHE")]
    pub const Cyrillic_GHE: RawKeysym = 0x6e7;
    #[doc(alias = "XK_Cyrillic_HA")]
    pub const Cyrillic_HA: RawKeysym = 0x6e8;
    #[doc(alias = "XK_Cyrillic_I")]
    pub const Cyrillic_I: RawKeysym = 0x6e9;
    #[doc(alias = "XK_Cyrillic_SHORTI")]
    pub const Cyrillic_SHORTI: RawKeysym = 0x6ea;
    #[doc(alias = "XK_Cyrillic_KA")]
    pub const Cyrillic_KA: RawKeysym = 0x6eb;
    #[doc(alias = "XK_Cyrillic_EL")]
    pub const Cyrillic_EL: RawKeysym = 0x6ec;
    #[doc(alias = "XK_Cyrillic_EM")]
    pub const Cyrillic_EM: RawKeysym = 0x6ed;
    #[doc(alias = "XK_Cyrillic_EN")]
    pub const Cyrillic_EN: RawKeysym = 0x6ee;
    #[doc(alias = "XK_Cyrillic_O")]
    pub const Cyrillic_O: RawKeysym = 0x6ef;
    #[doc(alias = "XK_Cyrillic_PE")]
    pub const Cyrillic_PE: RawKeysym = 0x6f0;
    #[doc(alias = "XK_Cyrillic_YA")]
    pub const Cyrillic_YA: RawKeysym = 0x6f1;
    #[doc(alias = "XK_Cyrillic_ER")]
    pub const Cyrillic_ER: RawKeysym = 0x6f2;
    #[doc(alias = "XK_Cyrillic_ES")]
    pub const Cyrillic_ES: RawKeysym = 0x6f3;
    #[doc(alias = "XK_Cyrillic_TE")]
    pub const Cyrillic_TE: RawKeysym = 0x6f4;
    #[doc(alias = "XK_Cyrillic_U")]
    pub const Cyrillic_U: RawKeysym = 0x6f5;
    #[doc(alias = "XK_Cyrillic_ZHE")]
    pub const Cyrillic_ZHE: RawKeysym = 0x6f6;
    #[doc(alias = "XK_Cyrillic_VE")]
    pub const Cyrillic_VE: RawKeysym = 0x6f7;
    #[doc(alias = "XK_Cyrillic_SOFTSIGN")]
    pub const Cyrillic_SOFTSIGN: RawKeysym = 0x6f8;
    #[doc(alias = "XK_Cyrillic_YERU")]
    pub const Cyrillic_YERU: RawKeysym = 0x6f9;
    #[doc(alias = "XK_Cyrillic_ZE")]
    pub const Cyrillic_ZE: RawKeysym = 0x6fa;
    #[doc(alias = "XK_Cyrillic_SHA")]
    pub const Cyrillic_SHA: RawKeysym = 0x6fb;
    #[doc(alias = "XK_Cyrillic_E")]
    pub const Cyrillic_E: RawKeysym = 0x6fc;
    #[doc(alias = "XK_Cyrillic_SHCHA")]
    pub const Cyrillic_SHCHA: RawKeysym = 0x6fd;
    #[doc(alias = "XK_Cyrillic_CHE")]
    pub const Cyrillic_CHE: RawKeysym = 0x6fe;
    #[doc(alias = "XK_Cyrillic_HARDSIGN")]
    pub const Cyrillic_HARDSIGN: RawKeysym = 0x6ff;
    #[doc(alias = "XK_Greek_ALPHAaccent")]
    pub const Greek_ALPHAaccent: RawKeysym = 0x7a1;
    #[doc(alias = "XK_Greek_EPSILONaccent")]
    pub const Greek_EPSILONaccent: RawKeysym = 0x7a2;
    #[doc(alias = "XK_Greek_ETAaccent")]
    pub const Greek_ETAaccent: RawKeysym = 0x7a3;
    #[doc(alias = "XK_Greek_IOTAaccent")]
    pub const Greek_IOTAaccent: RawKeysym = 0x7a4;
    #[doc(alias = "XK_Greek_IOTAdieresis")]
    pub const Greek_IOTAdieresis: RawKeysym = 0x7a5;
    #[doc(alias = "XK_Greek_IOTAdiaeresis")]
    pub const Greek_IOTAdiaeresis: RawKeysym = 0x7a5;
    #[doc(alias = "XK_Greek_OMICRONaccent")]
    pub const Greek_OMICRONaccent: RawKeysym = 0x7a7;
    #[doc(alias = "XK_Greek_UPSILONaccent")]
    pub const Greek_UPSILONaccent: RawKeysym = 0x7a8;
    #[doc(alias = "XK_Greek_UPSILONdieresis")]
    pub const Greek_UPSILONdieresis: RawKeysym = 0x7a9;
    #[doc(alias = "XK_Greek_OMEGAaccent")]
    pub const Greek_OMEGAaccent: RawKeysym = 0x7ab;
    #[doc(alias = "XK_Greek_accentdieresis")]
    pub const Greek_accentdieresis: RawKeysym = 0x7ae;
    #[doc(alias = "XK_Greek_horizbar")]
    pub const Greek_horizbar: RawKeysym = 0x7af;
    #[doc(alias = "XK_Greek_alphaaccent")]
    pub const Greek_alphaaccent: RawKeysym = 0x7b1;
    #[doc(alias = "XK_Greek_epsilonaccent")]
    pub const Greek_epsilonaccent: RawKeysym = 0x7b2;
    #[doc(alias = "XK_Greek_etaaccent")]
    pub const Greek_etaaccent: RawKeysym = 0x7b3;
    #[doc(alias = "XK_Greek_iotaaccent")]
    pub const Greek_iotaaccent: RawKeysym = 0x7b4;
    #[doc(alias = "XK_Greek_iotadieresis")]
    pub const Greek_iotadieresis: RawKeysym = 0x7b5;
    #[doc(alias = "XK_Greek_iotaaccentdieresis")]
    pub const Greek_iotaaccentdieresis: RawKeysym = 0x7b6;
    #[doc(alias = "XK_Greek_omicronaccent")]
    pub const Greek_omicronaccent: RawKeysym = 0x7b7;
    #[doc(alias = "XK_Greek_upsilonaccent")]
    pub const Greek_upsilonaccent: RawKeysym = 0x7b8;
    #[doc(alias = "XK_Greek_upsilondieresis")]
    pub const Greek_upsilondieresis: RawKeysym = 0x7b9;
    #[doc(alias = "XK_Greek_upsilonaccentdieresis")]
    pub const Greek_upsilonaccentdieresis: RawKeysym = 0x7ba;
    #[doc(alias = "XK_Greek_omegaaccent")]
    pub const Greek_omegaaccent: RawKeysym = 0x7bb;
    #[doc(alias = "XK_Greek_ALPHA")]
    pub const Greek_ALPHA: RawKeysym = 0x7c1;
    #[doc(alias = "XK_Greek_BETA")]
    pub const Greek_BETA: RawKeysym = 0x7c2;
    #[doc(alias = "XK_Greek_GAMMA")]
    pub const Greek_GAMMA: RawKeysym = 0x7c3;
    #[doc(alias = "XK_Greek_DELTA")]
    pub const Greek_DELTA: RawKeysym = 0x7c4;
    #[doc(alias = "XK_Greek_EPSILON")]
    pub const Greek_EPSILON: RawKeysym = 0x7c5;
    #[doc(alias = "XK_Greek_ZETA")]
    pub const Greek_ZETA: RawKeysym = 0x7c6;
    #[doc(alias = "XK_Greek_ETA")]
    pub const Greek_ETA: RawKeysym = 0x7c7;
    #[doc(alias = "XK_Greek_THETA")]
    pub const Greek_THETA: RawKeysym = 0x7c8;
    #[doc(alias = "XK_Greek_IOTA")]
    pub const Greek_IOTA: RawKeysym = 0x7c9;
    #[doc(alias = "XK_Greek_KAPPA")]
    pub const Greek_KAPPA: RawKeysym = 0x7ca;
    #[doc(alias = "XK_Greek_LAMDA")]
    pub const Greek_LAMDA: RawKeysym = 0x7cb;
    #[doc(alias = "XK_Greek_LAMBDA")]
    pub const Greek_LAMBDA: RawKeysym = 0x7cb;
    #[doc(alias = "XK_Greek_MU")]
    pub const Greek_MU: RawKeysym = 0x7cc;
    #[doc(alias = "XK_Greek_NU")]
    pub const Greek_NU: RawKeysym = 0x7cd;
    #[doc(alias = "XK_Greek_XI")]
    pub const Greek_XI: RawKeysym = 0x7ce;
    #[doc(alias = "XK_Greek_OMICRON")]
    pub const Greek_OMICRON: RawKeysym = 0x7cf;
    #[doc(alias = "XK_Greek_PI")]
    pub const Greek_PI: RawKeysym = 0x7d0;
    #[doc(alias = "XK_Greek_RHO")]
    pub const Greek_RHO: RawKeysym = 0x7d1;
    #[doc(alias = "XK_Greek_SIGMA")]
    pub const Greek_SIGMA: RawKeysym = 0x7d2;
    #[doc(alias = "XK_Greek_TAU")]
    pub const Greek_TAU: RawKeysym = 0x7d4;
    #[doc(alias = "XK_Greek_UPSILON")]
    pub const Greek_UPSILON: RawKeysym = 0x7d5;
    #[doc(alias = "XK_Greek_PHI")]
    pub const Greek_PHI: RawKeysym = 0x7d6;
    #[doc(alias = "XK_Greek_CHI")]
    pub const Greek_CHI: RawKeysym = 0x7d7;
    #[doc(alias = "XK_Greek_PSI")]
    pub const Greek_PSI: RawKeysym = 0x7d8;
    #[doc(alias = "XK_Greek_OMEGA")]
    pub const Greek_OMEGA: RawKeysym = 0x7d9;
    #[doc(alias = "XK_Greek_alpha")]
    pub const Greek_alpha: RawKeysym = 0x7e1;
    #[doc(alias = "XK_Greek_beta")]
    pub const Greek_beta: RawKeysym = 0x7e2;
    #[doc(alias = "XK_Greek_gamma")]
    pub const Greek_gamma: RawKeysym = 0x7e3;
    #[doc(alias = "XK_Greek_delta")]
    pub const Greek_delta: RawKeysym = 0x7e4;
    #[doc(alias = "XK_Greek_epsilon")]
    pub const Greek_epsilon: RawKeysym = 0x7e5;
    #[doc(alias = "XK_Greek_zeta")]
    pub const Greek_zeta: RawKeysym = 0x7e6;
    #[doc(alias = "XK_Greek_eta")]
    pub const Greek_eta: RawKeysym = 0x7e7;
    #[doc(alias = "XK_Greek_theta")]
    pub const Greek_theta: RawKeysym = 0x7e8;
    #[doc(alias = "XK_Greek_iota")]
    pub const Greek_iota: RawKeysym = 0x7e9;
    #[doc(alias = "XK_Greek_kappa")]
    pub const Greek_kappa: RawKeysym = 0x7ea;
    #[doc(alias = "XK_Greek_lamda")]
    pub const Greek_lamda: RawKeysym = 0x7eb;
    #[doc(alias = "XK_Greek_lambda")]
    pub const Greek_lambda: RawKeysym = 0x7eb;
    #[doc(alias = "XK_Greek_mu")]
    pub const Greek_mu: RawKeysym = 0x7ec;
    #[doc(alias = "XK_Greek_nu")]
    pub const Greek_nu: RawKeysym = 0x7ed;
    #[doc(alias = "XK_Greek_xi")]
    pub const Greek_xi: RawKeysym = 0x7ee;
    #[doc(alias = "XK_Greek_omicron")]
    pub const Greek_omicron: RawKeysym = 0x7ef;
    #[doc(alias = "XK_Greek_pi")]
    pub const Greek_pi: RawKeysym = 0x7f0;
    #[doc(alias = "XK_Greek_rho")]
    pub const Greek_rho: RawKeysym = 0x7f1;
    #[doc(alias = "XK_Greek_sigma")]
    pub const Greek_sigma: RawKeysym = 0x7f2;
    #[doc(alias = "XK_Greek_finalsmallsigma")]
    pub const Greek_finalsmallsigma: RawKeysym = 0x7f3;
    #[doc(alias = "XK_Greek_tau")]
    pub const Greek_tau: RawKeysym = 0x7f4;
    #[doc(alias = "XK_Greek_upsilon")]
    pub const Greek_upsilon: RawKeysym = 0x7f5;
    #[doc(alias = "XK_Greek_phi")]
    pub const Greek_phi: RawKeysym = 0x7f6;
    #[doc(alias = "XK_Greek_chi")]
    pub const Greek_chi: RawKeysym = 0x7f7;
    #[doc(alias = "XK_Greek_psi")]
    pub const Greek_psi: RawKeysym = 0x7f8;
    #[doc(alias = "XK_Greek_omega")]
    pub const Greek_omega: RawKeysym = 0x7f9;
    #[doc(alias = "XK_Greek_switch")]
    pub const Greek_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_leftradical")]
    pub const leftradical: RawKeysym = 0x8a1;
    #[doc(alias = "XK_topleftradical")]
    pub const topleftradical: RawKeysym = 0x8a2;
    #[doc(alias = "XK_horizconnector")]
    pub const horizconnector: RawKeysym = 0x8a3;
    #[doc(alias = "XK_topintegral")]
    pub const topintegral: RawKeysym = 0x8a4;
    #[doc(alias = "XK_botintegral")]
    pub const botintegral: RawKeysym = 0x8a5;
    #[doc(alias = "XK_vertconnector")]
    pub const vertconnector: RawKeysym = 0x8a6;
    #[doc(alias = "XK_topleftsqbracket")]
    pub const topleftsqbracket: RawKeysym = 0x8a7;
    #[doc(alias = "XK_botleftsqbracket")]
    pub const botleftsqbracket: RawKeysym = 0x8a8;
    #[doc(alias = "XK_toprightsqbracket")]
    pub const toprightsqbracket: RawKeysym = 0x8a9;
    #[doc(alias = "XK_botrightsqbracket")]
    pub const botrightsqbracket: RawKeysym = 0x8aa;
    #[doc(alias = "XK_topleftparens")]
    pub const topleftparens: RawKeysym = 0x8ab;
    #[doc(alias = "XK_botleftparens")]
    pub const botleftparens: RawKeysym = 0x8ac;
    #[doc(alias = "XK_toprightparens")]
    pub const toprightparens: RawKeysym = 0x8ad;
    #[doc(alias = "XK_botrightparens")]
    pub const botrightparens: RawKeysym = 0x8ae;
    #[doc(alias = "XK_leftmiddlecurlybrace")]
    pub const leftmiddlecurlybrace: RawKeysym = 0x8af;
    #[doc(alias = "XK_rightmiddlecurlybrace")]
    pub const rightmiddlecurlybrace: RawKeysym = 0x8b0;
    #[doc(alias = "XK_topleftsummation")]
    pub const topleftsummation: RawKeysym = 0x8b1;
    #[doc(alias = "XK_botleftsummation")]
    pub const botleftsummation: RawKeysym = 0x8b2;
    #[doc(alias = "XK_topvertsummationconnector")]
    pub const topvertsummationconnector: RawKeysym = 0x8b3;
    #[doc(alias = "XK_botvertsummationconnector")]
    pub const botvertsummationconnector: RawKeysym = 0x8b4;
    #[doc(alias = "XK_toprightsummation")]
    pub const toprightsummation: RawKeysym = 0x8b5;
    #[doc(alias = "XK_botrightsummation")]
    pub const botrightsummation: RawKeysym = 0x8b6;
    #[doc(alias = "XK_rightmiddlesummation")]
    pub const rightmiddlesummation: RawKeysym = 0x8b7;
    #[doc(alias = "XK_lessthanequal")]
    pub const lessthanequal: RawKeysym = 0x8bc;
    #[doc(alias = "XK_notequal")]
    pub const notequal: RawKeysym = 0x8bd;
    #[doc(alias = "XK_greaterthanequal")]
    pub const greaterthanequal: RawKeysym = 0x8be;
    #[doc(alias = "XK_integral")]
    pub const integral: RawKeysym = 0x8bf;
    #[doc(alias = "XK_therefore")]
    pub const therefore: RawKeysym = 0x8c0;
    #[doc(alias = "XK_variation")]
    pub const variation: RawKeysym = 0x8c1;
    #[doc(alias = "XK_infinity")]
    pub const infinity: RawKeysym = 0x8c2;
    #[doc(alias = "XK_nabla")]
    pub const nabla: RawKeysym = 0x8c5;
    #[doc(alias = "XK_approximate")]
    pub const approximate: RawKeysym = 0x8c8;
    #[doc(alias = "XK_similarequal")]
    pub const similarequal: RawKeysym = 0x8c9;
    #[doc(alias = "XK_ifonlyif")]
    pub const ifonlyif: RawKeysym = 0x8cd;
    #[doc(alias = "XK_implies")]
    pub const implies: RawKeysym = 0x8ce;
    #[doc(alias = "XK_identical")]
    pub const identical: RawKeysym = 0x8cf;
    #[doc(alias = "XK_radical")]
    pub const radical: RawKeysym = 0x8d6;
    #[doc(alias = "XK_includedin")]
    pub const includedin: RawKeysym = 0x8da;
    #[doc(alias = "XK_includes")]
    pub const includes: RawKeysym = 0x8db;
    #[doc(alias = "XK_intersection")]
    pub const intersection: RawKeysym = 0x8dc;
    #[doc(alias = "XK_union")]
    pub const union: RawKeysym = 0x8dd;
    #[doc(alias = "XK_logicaland")]
    pub const logicaland: RawKeysym = 0x8de;
    #[doc(alias = "XK_logicalor")]
    pub const logicalor: RawKeysym = 0x8df;
    #[doc(alias = "XK_partialderivative")]
    pub const partialderivative: RawKeysym = 0x8ef;
    #[doc(alias = "XK_function")]
    pub const function: RawKeysym = 0x8f6;
    #[doc(alias = "XK_leftarrow")]
    pub const leftarrow: RawKeysym = 0x8fb;
    #[doc(alias = "XK_uparrow")]
    pub const uparrow: RawKeysym = 0x8fc;
    #[doc(alias = "XK_rightarrow")]
    pub const rightarrow: RawKeysym = 0x8fd;
    #[doc(alias = "XK_downarrow")]
    pub const downarrow: RawKeysym = 0x8fe;
    #[doc(alias = "XK_blank")]
    pub const blank: RawKeysym = 0x9df;
    #[doc(alias = "XK_soliddiamond")]
    pub const soliddiamond: RawKeysym = 0x9e0;
    #[doc(alias = "XK_checkerboard")]
    pub const checkerboard: RawKeysym = 0x9e1;
    #[doc(alias = "XK_ht")]
    pub const ht: RawKeysym = 0x9e2;
    #[doc(alias = "XK_ff")]
    pub const ff: RawKeysym = 0x9e3;
    #[doc(alias = "XK_cr")]
    pub const cr: RawKeysym = 0x9e4;
    #[doc(alias = "XK_lf")]
    pub const lf: RawKeysym = 0x9e5;
    #[doc(alias = "XK_nl")]
    pub const nl: RawKeysym = 0x9e8;
    #[doc(alias = "XK_vt")]
    pub const vt: RawKeysym = 0x9e9;
    #[doc(alias = "XK_lowrightcorner")]
    pub const lowrightcorner: RawKeysym = 0x9ea;
    #[doc(alias = "XK_uprightcorner")]
    pub const uprightcorner: RawKeysym = 0x9eb;
    #[doc(alias = "XK_upleftcorner")]
    pub const upleftcorner: RawKeysym = 0x9ec;
    #[doc(alias = "XK_lowleftcorner")]
    pub const lowleftcorner: RawKeysym = 0x9ed;
    #[doc(alias = "XK_crossinglines")]
    pub const crossinglines: RawKeysym = 0x9ee;
    #[doc(alias = "XK_horizlinescan1")]
    pub const horizlinescan1: RawKeysym = 0x9ef;
    #[doc(alias = "XK_horizlinescan3")]
    pub const horizlinescan3: RawKeysym = 0x9f0;
    #[doc(alias = "XK_horizlinescan5")]
    pub const horizlinescan5: RawKeysym = 0x9f1;
    #[doc(alias = "XK_horizlinescan7")]
    pub const horizlinescan7: RawKeysym = 0x9f2;
    #[doc(alias = "XK_horizlinescan9")]
    pub const horizlinescan9: RawKeysym = 0x9f3;
    #[doc(alias = "XK_leftt")]
    pub const leftt: RawKeysym = 0x9f4;
    #[doc(alias = "XK_rightt")]
    pub const rightt: RawKeysym = 0x9f5;
    #[doc(alias = "XK_bott")]
    pub const bott: RawKeysym = 0x9f6;
    #[doc(alias = "XK_topt")]
    pub const topt: RawKeysym = 0x9f7;
    #[doc(alias = "XK_vertbar")]
    pub const vertbar: RawKeysym = 0x9f8;
    #[doc(alias = "XK_emspace")]
    pub const emspace: RawKeysym = 0xaa1;
    #[doc(alias = "XK_enspace")]
    pub const enspace: RawKeysym = 0xaa2;
    #[doc(alias = "XK_em3space")]
    pub const em3space: RawKeysym = 0xaa3;
    #[doc(alias = "XK_em4space")]
    pub const em4space: RawKeysym = 0xaa4;
    #[doc(alias = "XK_digitspace")]
    pub const digitspace: RawKeysym = 0xaa5;
    #[doc(alias = "XK_punctspace")]
    pub const punctspace: RawKeysym = 0xaa6;
    #[doc(alias = "XK_thinspace")]
    pub const thinspace: RawKeysym = 0xaa7;
    #[doc(alias = "XK_hairspace")]
    pub const hairspace: RawKeysym = 0xaa8;
    #[doc(alias = "XK_emdash")]
    pub const emdash: RawKeysym = 0xaa9;
    #[doc(alias = "XK_endash")]
    pub const endash: RawKeysym = 0xaaa;
    #[doc(alias = "XK_signifblank")]
    pub const signifblank: RawKeysym = 0xaac;
    #[doc(alias = "XK_ellipsis")]
    pub const ellipsis: RawKeysym = 0xaae;
    #[doc(alias = "XK_doubbaselinedot")]
    pub const doubbaselinedot: RawKeysym = 0xaaf;
    #[doc(alias = "XK_onethird")]
    pub const onethird: RawKeysym = 0xab0;
    #[doc(alias = "XK_twothirds")]
    pub const twothirds: RawKeysym = 0xab1;
    #[doc(alias = "XK_onefifth")]
    pub const onefifth: RawKeysym = 0xab2;
    #[doc(alias = "XK_twofifths")]
    pub const twofifths: RawKeysym = 0xab3;
    #[doc(alias = "XK_threefifths")]
    pub const threefifths: RawKeysym = 0xab4;
    #[doc(alias = "XK_fourfifths")]
    pub const fourfifths: RawKeysym = 0xab5;
    #[doc(alias = "XK_onesixth")]
    pub const onesixth: RawKeysym = 0xab6;
    #[doc(alias = "XK_fivesixths")]
    pub const fivesixths: RawKeysym = 0xab7;
    #[doc(alias = "XK_careof")]
    pub const careof: RawKeysym = 0xab8;
    #[doc(alias = "XK_figdash")]
    pub const figdash: RawKeysym = 0xabb;
    #[doc(alias = "XK_leftanglebracket")]
    pub const leftanglebracket: RawKeysym = 0xabc;
    #[doc(alias = "XK_decimalpoint")]
    pub const decimalpoint: RawKeysym = 0xabd;
    #[doc(alias = "XK_rightanglebracket")]
    pub const rightanglebracket: RawKeysym = 0xabe;
    #[doc(alias = "XK_marker")]
    pub const marker: RawKeysym = 0xabf;
    #[doc(alias = "XK_oneeighth")]
    pub const oneeighth: RawKeysym = 0xac3;
    #[doc(alias = "XK_threeeighths")]
    pub const threeeighths: RawKeysym = 0xac4;
    #[doc(alias = "XK_fiveeighths")]
    pub const fiveeighths: RawKeysym = 0xac5;
    #[doc(alias = "XK_seveneighths")]
    pub const seveneighths: RawKeysym = 0xac6;
    #[doc(alias = "XK_trademark")]
    pub const trademark: RawKeysym = 0xac9;
    #[doc(alias = "XK_signaturemark")]
    pub const signaturemark: RawKeysym = 0xaca;
    #[doc(alias = "XK_trademarkincircle")]
    pub const trademarkincircle: RawKeysym = 0xacb;
    #[doc(alias = "XK_leftopentriangle")]
    pub const leftopentriangle: RawKeysym = 0xacc;
    #[doc(alias = "XK_rightopentriangle")]
    pub const rightopentriangle: RawKeysym = 0xacd;
    #[doc(alias = "XK_emopencircle")]
    pub const emopencircle: RawKeysym = 0xace;
    #[doc(alias = "XK_emopenrectangle")]
    pub const emopenrectangle: RawKeysym = 0xacf;
    #[doc(alias = "XK_leftsinglequotemark")]
    pub const leftsinglequotemark: RawKeysym = 0xad0;
    #[doc(alias = "XK_rightsinglequotemark")]
    pub const rightsinglequotemark: RawKeysym = 0xad1;
    #[doc(alias = "XK_leftdoublequotemark")]
    pub const leftdoublequotemark: RawKeysym = 0xad2;
    #[doc(alias = "XK_rightdoublequotemark")]
    pub const rightdoublequotemark: RawKeysym = 0xad3;
    #[doc(alias = "XK_prescription")]
    pub const prescription: RawKeysym = 0xad4;
    #[doc(alias = "XK_permille")]
    pub const permille: RawKeysym = 0xad5;
    #[doc(alias = "XK_minutes")]
    pub const minutes: RawKeysym = 0xad6;
    #[doc(alias = "XK_seconds")]
    pub const seconds: RawKeysym = 0xad7;
    #[doc(alias = "XK_latincross")]
    pub const latincross: RawKeysym = 0xad9;
    #[doc(alias = "XK_hexagram")]
    pub const hexagram: RawKeysym = 0xada;
    #[doc(alias = "XK_filledrectbullet")]
    pub const filledrectbullet: RawKeysym = 0xadb;
    #[doc(alias = "XK_filledlefttribullet")]
    pub const filledlefttribullet: RawKeysym = 0xadc;
    #[doc(alias = "XK_filledrighttribullet")]
    pub const filledrighttribullet: RawKeysym = 0xadd;
    #[doc(alias = "XK_emfilledcircle")]
    pub const emfilledcircle: RawKeysym = 0xade;
    #[doc(alias = "XK_emfilledrect")]
    pub const emfilledrect: RawKeysym = 0xadf;
    #[doc(alias = "XK_enopencircbullet")]
    pub const enopencircbullet: RawKeysym = 0xae0;
    #[doc(alias = "XK_enopensquarebullet")]
    pub const enopensquarebullet: RawKeysym = 0xae1;
    #[doc(alias = "XK_openrectbullet")]
    pub const openrectbullet: RawKeysym = 0xae2;
    #[doc(alias = "XK_opentribulletup")]
    pub const opentribulletup: RawKeysym = 0xae3;
    #[doc(alias = "XK_opentribulletdown")]
    pub const opentribulletdown: RawKeysym = 0xae4;
    #[doc(alias = "XK_openstar")]
    pub const openstar: RawKeysym = 0xae5;
    #[doc(alias = "XK_enfilledcircbullet")]
    pub const enfilledcircbullet: RawKeysym = 0xae6;
    #[doc(alias = "XK_enfilledsqbullet")]
    pub const enfilledsqbullet: RawKeysym = 0xae7;
    #[doc(alias = "XK_filledtribulletup")]
    pub const filledtribulletup: RawKeysym = 0xae8;
    #[doc(alias = "XK_filledtribulletdown")]
    pub const filledtribulletdown: RawKeysym = 0xae9;
    #[doc(alias = "XK_leftpointer")]
    pub const leftpointer: RawKeysym = 0xaea;
    #[doc(alias = "XK_rightpointer")]
    pub const rightpointer: RawKeysym = 0xaeb;
    #[doc(alias = "XK_club")]
    pub const club: RawKeysym = 0xaec;
    #[doc(alias = "XK_diamond")]
    pub const diamond: RawKeysym = 0xaed;
    #[doc(alias = "XK_heart")]
    pub const heart: RawKeysym = 0xaee;
    #[doc(alias = "XK_maltesecross")]
    pub const maltesecross: RawKeysym = 0xaf0;
    #[doc(alias = "XK_dagger")]
    pub const dagger: RawKeysym = 0xaf1;
    #[doc(alias = "XK_doubledagger")]
    pub const doubledagger: RawKeysym = 0xaf2;
    #[doc(alias = "XK_checkmark")]
    pub const checkmark: RawKeysym = 0xaf3;
    #[doc(alias = "XK_ballotcross")]
    pub const ballotcross: RawKeysym = 0xaf4;
    #[doc(alias = "XK_musicalsharp")]
    pub const musicalsharp: RawKeysym = 0xaf5;
    #[doc(alias = "XK_musicalflat")]
    pub const musicalflat: RawKeysym = 0xaf6;
    #[doc(alias = "XK_malesymbol")]
    pub const malesymbol: RawKeysym = 0xaf7;
    #[doc(alias = "XK_femalesymbol")]
    pub const femalesymbol: RawKeysym = 0xaf8;
    #[doc(alias = "XK_telephone")]
    pub const telephone: RawKeysym = 0xaf9;
    #[doc(alias = "XK_telephonerecorder")]
    pub const telephonerecorder: RawKeysym = 0xafa;
    #[doc(alias = "XK_phonographcopyright")]
    pub const phonographcopyright: RawKeysym = 0xafb;
    #[doc(alias = "XK_caret")]
    pub const caret: RawKeysym = 0xafc;
    #[doc(alias = "XK_singlelowquotemark")]
    pub const singlelowquotemark: RawKeysym = 0xafd;
    #[doc(alias = "XK_doublelowquotemark")]
    pub const doublelowquotemark: RawKeysym = 0xafe;
    #[doc(alias = "XK_cursor")]
    pub const cursor: RawKeysym = 0xaff;
    #[doc(alias = "XK_leftcaret")]
    pub const leftcaret: RawKeysym = 0xba3;
    #[doc(alias = "XK_rightcaret")]
    pub const rightcaret: RawKeysym = 0xba6;
    #[doc(alias = "XK_downcaret")]
    pub const downcaret: RawKeysym = 0xba8;
    #[doc(alias = "XK_upcaret")]
    pub const upcaret: RawKeysym = 0xba9;
    #[doc(alias = "XK_overbar")]
    pub const overbar: RawKeysym = 0xbc0;
    #[doc(alias = "XK_downtack")]
    pub const downtack: RawKeysym = 0xbc2;
    #[doc(alias = "XK_upshoe")]
    pub const upshoe: RawKeysym = 0xbc3;
    #[doc(alias = "XK_downstile")]
    pub const downstile: RawKeysym = 0xbc4;
    #[doc(alias = "XK_underbar")]
    pub const underbar: RawKeysym = 0xbc6;
    #[doc(alias = "XK_jot")]
    pub const jot: RawKeysym = 0xbca;
    #[doc(alias = "XK_quad")]
    pub const quad: RawKeysym = 0xbcc;
    #[doc(alias = "XK_uptack")]
    pub const uptack: RawKeysym = 0xbce;
    #[doc(alias = "XK_circle")]
    pub const circle: RawKeysym = 0xbcf;
    #[doc(alias = "XK_upstile")]
    pub const upstile: RawKeysym = 0xbd3;
    #[doc(alias = "XK_downshoe")]
    pub const downshoe: RawKeysym = 0xbd6;
    #[doc(alias = "XK_rightshoe")]
    pub const rightshoe: RawKeysym = 0xbd8;
    #[doc(alias = "XK_leftshoe")]
    pub const leftshoe: RawKeysym = 0xbda;
    #[doc(alias = "XK_lefttack")]
    pub const lefttack: RawKeysym = 0xbdc;
    #[doc(alias = "XK_righttack")]
    pub const righttack: RawKeysym = 0xbfc;
    #[doc(alias = "XK_hebrew_doublelowline")]
    pub const hebrew_doublelowline: RawKeysym = 0xcdf;
    #[doc(alias = "XK_hebrew_aleph")]
    pub const hebrew_aleph: RawKeysym = 0xce0;
    #[doc(alias = "XK_hebrew_bet")]
    pub const hebrew_bet: RawKeysym = 0xce1;
    #[doc(alias = "XK_hebrew_beth")]
    pub const hebrew_beth: RawKeysym = 0xce1;
    #[doc(alias = "XK_hebrew_gimel")]
    pub const hebrew_gimel: RawKeysym = 0xce2;
    #[doc(alias = "XK_hebrew_gimmel")]
    pub const hebrew_gimmel: RawKeysym = 0xce2;
    #[doc(alias = "XK_hebrew_dalet")]
    pub const hebrew_dalet: RawKeysym = 0xce3;
    #[doc(alias = "XK_hebrew_daleth")]
    pub const hebrew_daleth: RawKeysym = 0xce3;
    #[doc(alias = "XK_hebrew_he")]
    pub const hebrew_he: RawKeysym = 0xce4;
    #[doc(alias = "XK_hebrew_waw")]
    pub const hebrew_waw: RawKeysym = 0xce5;
    #[doc(alias = "XK_hebrew_zain")]
    pub const hebrew_zain: RawKeysym = 0xce6;
    #[doc(alias = "XK_hebrew_zayin")]
    pub const hebrew_zayin: RawKeysym = 0xce6;
    #[doc(alias = "XK_hebrew_chet")]
    pub const hebrew_chet: RawKeysym = 0xce7;
    #[doc(alias = "XK_hebrew_het")]
    pub const hebrew_het: RawKeysym = 0xce7;
    #[doc(alias = "XK_hebrew_tet")]
    pub const hebrew_tet: RawKeysym = 0xce8;
    #[doc(alias = "XK_hebrew_teth")]
    pub const hebrew_teth: RawKeysym = 0xce8;
    #[doc(alias = "XK_hebrew_yod")]
    pub const hebrew_yod: RawKeysym = 0xce9;
    #[doc(alias = "XK_hebrew_finalkaph")]
    pub const hebrew_finalkaph: RawKeysym = 0xcea;
    #[doc(alias = "XK_hebrew_kaph")]
    pub const hebrew_kaph: RawKeysym = 0xceb;
    #[doc(alias = "XK_hebrew_lamed")]
    pub const hebrew_lamed: RawKeysym = 0xcec;
    #[doc(alias = "XK_hebrew_finalmem")]
    pub const hebrew_finalmem: RawKeysym = 0xced;
    #[doc(alias = "XK_hebrew_mem")]
    pub const hebrew_mem: RawKeysym = 0xcee;
    #[doc(alias = "XK_hebrew_finalnun")]
    pub const hebrew_finalnun: RawKeysym = 0xcef;
    #[doc(alias = "XK_hebrew_nun")]
    pub const hebrew_nun: RawKeysym = 0xcf0;
    #[doc(alias = "XK_hebrew_samech")]
    pub const hebrew_samech: RawKeysym = 0xcf1;
    #[doc(alias = "XK_hebrew_samekh")]
    pub const hebrew_samekh: RawKeysym = 0xcf1;
    #[doc(alias = "XK_hebrew_ayin")]
    pub const hebrew_ayin: RawKeysym = 0xcf2;
    #[doc(alias = "XK_hebrew_finalpe")]
    pub const hebrew_finalpe: RawKeysym = 0xcf3;
    #[doc(alias = "XK_hebrew_pe")]
    pub const hebrew_pe: RawKeysym = 0xcf4;
    #[doc(alias = "XK_hebrew_finalzade")]
    pub const hebrew_finalzade: RawKeysym = 0xcf5;
    #[doc(alias = "XK_hebrew_finalzadi")]
    pub const hebrew_finalzadi: RawKeysym = 0xcf5;
    #[doc(alias = "XK_hebrew_zade")]
    pub const hebrew_zade: RawKeysym = 0xcf6;
    #[doc(alias = "XK_hebrew_zadi")]
    pub const hebrew_zadi: RawKeysym = 0xcf6;
    #[doc(alias = "XK_hebrew_qoph")]
    pub const hebrew_qoph: RawKeysym = 0xcf7;
    #[doc(alias = "XK_hebrew_kuf")]
    pub const hebrew_kuf: RawKeysym = 0xcf7;
    #[doc(alias = "XK_hebrew_resh")]
    pub const hebrew_resh: RawKeysym = 0xcf8;
    #[doc(alias = "XK_hebrew_shin")]
    pub const hebrew_shin: RawKeysym = 0xcf9;
    #[doc(alias = "XK_hebrew_taw")]
    pub const hebrew_taw: RawKeysym = 0xcfa;
    #[doc(alias = "XK_hebrew_taf")]
    pub const hebrew_taf: RawKeysym = 0xcfa;
    #[doc(alias = "XK_Hebrew_switch")]
    pub const Hebrew_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_Thai_kokai")]
    pub const Thai_kokai: RawKeysym = 0xda1;
    #[doc(alias = "XK_Thai_khokhai")]
    pub const Thai_khokhai: RawKeysym = 0xda2;
    #[doc(alias = "XK_Thai_khokhuat")]
    pub const Thai_khokhuat: RawKeysym = 0xda3;
    #[doc(alias = "XK_Thai_khokhwai")]
    pub const Thai_khokhwai: RawKeysym = 0xda4;
    #[doc(alias = "XK_Thai_khokhon")]
    pub const Thai_khokhon: RawKeysym = 0xda5;
    #[doc(alias = "XK_Thai_khorakhang")]
    pub const Thai_khorakhang: RawKeysym = 0xda6;
    #[doc(alias = "XK_Thai_ngongu")]
    pub const Thai_ngongu: RawKeysym = 0xda7;
    #[doc(alias = "XK_Thai_chochan")]
    pub const Thai_chochan: RawKeysym = 0xda8;
    #[doc(alias = "XK_Thai_choching")]
    pub const Thai_choching: RawKeysym = 0xda9;
    #[doc(alias = "XK_Thai_chochang")]
    pub const Thai_chochang: RawKeysym = 0xdaa;
    #[doc(alias = "XK_Thai_soso")]
    pub const Thai_soso: RawKeysym = 0xdab;
    #[doc(alias = "XK_Thai_chochoe")]
    pub const Thai_chochoe: RawKeysym = 0xdac;
    #[doc(alias = "XK_Thai_yoying")]
    pub const Thai_yoying: RawKeysym = 0xdad;
    #[doc(alias = "XK_Thai_dochada")]
    pub const Thai_dochada: RawKeysym = 0xdae;
    #[doc(alias = "XK_Thai_topatak")]
    pub const Thai_topatak: RawKeysym = 0xdaf;
    #[doc(alias = "XK_Thai_thothan")]
    pub const Thai_thothan: RawKeysym = 0xdb0;
    #[doc(alias = "XK_Thai_thonangmontho")]
    pub const Thai_thonangmontho: RawKeysym = 0xdb1;
    #[doc(alias = "XK_Thai_thophuthao")]
    pub const Thai_thophuthao: RawKeysym = 0xdb2;
    #[doc(alias = "XK_Thai_nonen")]
    pub const Thai_nonen: RawKeysym = 0xdb3;
    #[doc(alias = "XK_Thai_dodek")]
    pub const Thai_dodek: RawKeysym = 0xdb4;
    #[doc(alias = "XK_Thai_totao")]
    pub const Thai_totao: RawKeysym = 0xdb5;
    #[doc(alias = "XK_Thai_thothung")]
    pub const Thai_thothung: RawKeysym = 0xdb6;
    #[doc(alias = "XK_Thai_thothahan")]
    pub const Thai_thothahan: RawKeysym = 0xdb7;
    #[doc(alias = "XK_Thai_thothong")]
    pub const Thai_thothong: RawKeysym = 0xdb8;
    #[doc(alias = "XK_Thai_nonu")]
    pub const Thai_nonu: RawKeysym = 0xdb9;
    #[doc(alias = "XK_Thai_bobaimai")]
    pub const Thai_bobaimai: RawKeysym = 0xdba;
    #[doc(alias = "XK_Thai_popla")]
    pub const Thai_popla: RawKeysym = 0xdbb;
    #[doc(alias = "XK_Thai_phophung")]
    pub const Thai_phophung: RawKeysym = 0xdbc;
    #[doc(alias = "XK_Thai_fofa")]
    pub const Thai_fofa: RawKeysym = 0xdbd;
    #[doc(alias = "XK_Thai_phophan")]
    pub const Thai_phophan: RawKeysym = 0xdbe;
    #[doc(alias = "XK_Thai_fofan")]
    pub const Thai_fofan: RawKeysym = 0xdbf;
    #[doc(alias = "XK_Thai_phosamphao")]
    pub const Thai_phosamphao: RawKeysym = 0xdc0;
    #[doc(alias = "XK_Thai_moma")]
    pub const Thai_moma: RawKeysym = 0xdc1;
    #[doc(alias = "XK_Thai_yoyak")]
    pub const Thai_yoyak: RawKeysym = 0xdc2;
    #[doc(alias = "XK_Thai_rorua")]
    pub const Thai_rorua: RawKeysym = 0xdc3;
    #[doc(alias = "XK_Thai_ru")]
    pub const Thai_ru: RawKeysym = 0xdc4;
    #[doc(alias = "XK_Thai_loling")]
    pub const Thai_loling: RawKeysym = 0xdc5;
    #[doc(alias = "XK_Thai_lu")]
    pub const Thai_lu: RawKeysym = 0xdc6;
    #[doc(alias = "XK_Thai_wowaen")]
    pub const Thai_wowaen: RawKeysym = 0xdc7;
    #[doc(alias = "XK_Thai_sosala")]
    pub const Thai_sosala: RawKeysym = 0xdc8;
    #[doc(alias = "XK_Thai_sorusi")]
    pub const Thai_sorusi: RawKeysym = 0xdc9;
    #[doc(alias = "XK_Thai_sosua")]
    pub const Thai_sosua: RawKeysym = 0xdca;
    #[doc(alias = "XK_Thai_hohip")]
    pub const Thai_hohip: RawKeysym = 0xdcb;
    #[doc(alias = "XK_Thai_lochula")]
    pub const Thai_lochula: RawKeysym = 0xdcc;
    #[doc(alias = "XK_Thai_oang")]
    pub const Thai_oang: RawKeysym = 0xdcd;
    #[doc(alias = "XK_Thai_honokhuk")]
    pub const Thai_honokhuk: RawKeysym = 0xdce;
    #[doc(alias = "XK_Thai_paiyannoi")]
    pub const Thai_paiyannoi: RawKeysym = 0xdcf;
    #[doc(alias = "XK_Thai_saraa")]
    pub const Thai_saraa: RawKeysym = 0xdd0;
    #[doc(alias = "XK_Thai_maihanakat")]
    pub const Thai_maihanakat: RawKeysym = 0xdd1;
    #[doc(alias = "XK_Thai_saraaa")]
    pub const Thai_saraaa: RawKeysym = 0xdd2;
    #[doc(alias = "XK_Thai_saraam")]
    pub const Thai_saraam: RawKeysym = 0xdd3;
    #[doc(alias = "XK_Thai_sarai")]
    pub const Thai_sarai: RawKeysym = 0xdd4;
    #[doc(alias = "XK_Thai_saraii")]
    pub const Thai_saraii: RawKeysym = 0xdd5;
    #[doc(alias = "XK_Thai_saraue")]
    pub const Thai_saraue: RawKeysym = 0xdd6;
    #[doc(alias = "XK_Thai_sarauee")]
    pub const Thai_sarauee: RawKeysym = 0xdd7;
    #[doc(alias = "XK_Thai_sarau")]
    pub const Thai_sarau: RawKeysym = 0xdd8;
    #[doc(alias = "XK_Thai_sarauu")]
    pub const Thai_sarauu: RawKeysym = 0xdd9;
    #[doc(alias = "XK_Thai_phinthu")]
    pub const Thai_phinthu: RawKeysym = 0xdda;
    #[doc(alias = "XK_Thai_maihanakat_maitho")]
    pub const Thai_maihanakat_maitho: RawKeysym = 0xdde;
    #[doc(alias = "XK_Thai_baht")]
    pub const Thai_baht: RawKeysym = 0xddf;
    #[doc(alias = "XK_Thai_sarae")]
    pub const Thai_sarae: RawKeysym = 0xde0;
    #[doc(alias = "XK_Thai_saraae")]
    pub const Thai_saraae: RawKeysym = 0xde1;
    #[doc(alias = "XK_Thai_sarao")]
    pub const Thai_sarao: RawKeysym = 0xde2;
    #[doc(alias = "XK_Thai_saraaimaimuan")]
    pub const Thai_saraaimaimuan: RawKeysym = 0xde3;
    #[doc(alias = "XK_Thai_saraaimaimalai")]
    pub const Thai_saraaimaimalai: RawKeysym = 0xde4;
    #[doc(alias = "XK_Thai_lakkhangyao")]
    pub const Thai_lakkhangyao: RawKeysym = 0xde5;
    #[doc(alias = "XK_Thai_maiyamok")]
    pub const Thai_maiyamok: RawKeysym = 0xde6;
    #[doc(alias = "XK_Thai_maitaikhu")]
    pub const Thai_maitaikhu: RawKeysym = 0xde7;
    #[doc(alias = "XK_Thai_maiek")]
    pub const Thai_maiek: RawKeysym = 0xde8;
    #[doc(alias = "XK_Thai_maitho")]
    pub const Thai_maitho: RawKeysym = 0xde9;
    #[doc(alias = "XK_Thai_maitri")]
    pub const Thai_maitri: RawKeysym = 0xdea;
    #[doc(alias = "XK_Thai_maichattawa")]
    pub const Thai_maichattawa: RawKeysym = 0xdeb;
    #[doc(alias = "XK_Thai_thanthakhat")]
    pub const Thai_thanthakhat: RawKeysym = 0xdec;
    #[doc(alias = "XK_Thai_nikhahit")]
    pub const Thai_nikhahit: RawKeysym = 0xded;
    #[doc(alias = "XK_Thai_leksun")]
    pub const Thai_leksun: RawKeysym = 0xdf0;
    #[doc(alias = "XK_Thai_leknung")]
    pub const Thai_leknung: RawKeysym = 0xdf1;
    #[doc(alias = "XK_Thai_leksong")]
    pub const Thai_leksong: RawKeysym = 0xdf2;
    #[doc(alias = "XK_Thai_leksam")]
    pub const Thai_leksam: RawKeysym = 0xdf3;
    #[doc(alias = "XK_Thai_leksi")]
    pub const Thai_leksi: RawKeysym = 0xdf4;
    #[doc(alias = "XK_Thai_lekha")]
    pub const Thai_lekha: RawKeysym = 0xdf5;
    #[doc(alias = "XK_Thai_lekhok")]
    pub const Thai_lekhok: RawKeysym = 0xdf6;
    #[doc(alias = "XK_Thai_lekchet")]
    pub const Thai_lekchet: RawKeysym = 0xdf7;
    #[doc(alias = "XK_Thai_lekpaet")]
    pub const Thai_lekpaet: RawKeysym = 0xdf8;
    #[doc(alias = "XK_Thai_lekkao")]
    pub const Thai_lekkao: RawKeysym = 0xdf9;
    #[doc(alias = "XK_Hangul")]
    pub const Hangul: RawKeysym = 0xff31;
    #[doc(alias = "XK_Hangul_Start")]
    pub const Hangul_Start: RawKeysym = 0xff32;
    #[doc(alias = "XK_Hangul_End")]
    pub const Hangul_End: RawKeysym = 0xff33;
    #[doc(alias = "XK_Hangul_Hanja")]
    pub const Hangul_Hanja: RawKeysym = 0xff34;
    #[doc(alias = "XK_Hangul_Jamo")]
    pub const Hangul_Jamo: RawKeysym = 0xff35;
    #[doc(alias = "XK_Hangul_Romaja")]
    pub const Hangul_Romaja: RawKeysym = 0xff36;
    #[doc(alias = "XK_Hangul_Codeinput")]
    pub const Hangul_Codeinput: RawKeysym = 0xff37;
    #[doc(alias = "XK_Hangul_Jeonja")]
    pub const Hangul_Jeonja: RawKeysym = 0xff38;
    #[doc(alias = "XK_Hangul_Banja")]
    pub const Hangul_Banja: RawKeysym = 0xff39;
    #[doc(alias = "XK_Hangul_PreHanja")]
    pub const Hangul_PreHanja: RawKeysym = 0xff3a;
    #[doc(alias = "XK_Hangul_PostHanja")]
    pub const Hangul_PostHanja: RawKeysym = 0xff3b;
    #[doc(alias = "XK_Hangul_SingleCandidate")]
    pub const Hangul_SingleCandidate: RawKeysym = 0xff3c;
    #[doc(alias = "XK_Hangul_MultipleCandidate")]
    pub const Hangul_MultipleCandidate: RawKeysym = 0xff3d;
    #[doc(alias = "XK_Hangul_PreviousCandidate")]
    pub const Hangul_PreviousCandidate: RawKeysym = 0xff3e;
    #[doc(alias = "XK_Hangul_Special")]
    pub const Hangul_Special: RawKeysym = 0xff3f;
    #[doc(alias = "XK_Hangul_switch")]
    pub const Hangul_switch: RawKeysym = 0xff7e;
    #[doc(alias = "XK_Hangul_Kiyeog")]
    pub const Hangul_Kiyeog: RawKeysym = 0xea1;
    #[doc(alias = "XK_Hangul_SsangKiyeog")]
    pub const Hangul_SsangKiyeog: RawKeysym = 0xea2;
    #[doc(alias = "XK_Hangul_KiyeogSios")]
    pub const Hangul_KiyeogSios: RawKeysym = 0xea3;
    #[doc(alias = "XK_Hangul_Nieun")]
    pub const Hangul_Nieun: RawKeysym = 0xea4;
    #[doc(alias = "XK_Hangul_NieunJieuj")]
    pub const Hangul_NieunJieuj: RawKeysym = 0xea5;
    #[doc(alias = "XK_Hangul_NieunHieuh")]
    pub const Hangul_NieunHieuh: RawKeysym = 0xea6;
    #[doc(alias = "XK_Hangul_Dikeud")]
    pub const Hangul_Dikeud: RawKeysym = 0xea7;
    #[doc(alias = "XK_Hangul_SsangDikeud")]
    pub const Hangul_SsangDikeud: RawKeysym = 0xea8;
    #[doc(alias = "XK_Hangul_Rieul")]
    pub const Hangul_Rieul: RawKeysym = 0xea9;
    #[doc(alias = "XK_Hangul_RieulKiyeog")]
    pub const Hangul_RieulKiyeog: RawKeysym = 0xeaa;
    #[doc(alias = "XK_Hangul_RieulMieum")]
    pub const Hangul_RieulMieum: RawKeysym = 0xeab;
    #[doc(alias = "XK_Hangul_RieulPieub")]
    pub const Hangul_RieulPieub: RawKeysym = 0xeac;
    #[doc(alias = "XK_Hangul_RieulSios")]
    pub const Hangul_RieulSios: RawKeysym = 0xead;
    #[doc(alias = "XK_Hangul_RieulTieut")]
    pub const Hangul_RieulTieut: RawKeysym = 0xeae;
    #[doc(alias = "XK_Hangul_RieulPhieuf")]
    pub const Hangul_RieulPhieuf: RawKeysym = 0xeaf;
    #[doc(alias = "XK_Hangul_RieulHieuh")]
    pub const Hangul_RieulHieuh: RawKeysym = 0xeb0;
    #[doc(alias = "XK_Hangul_Mieum")]
    pub const Hangul_Mieum: RawKeysym = 0xeb1;
    #[doc(alias = "XK_Hangul_Pieub")]
    pub const Hangul_Pieub: RawKeysym = 0xeb2;
    #[doc(alias = "XK_Hangul_SsangPieub")]
    pub const Hangul_SsangPieub: RawKeysym = 0xeb3;
    #[doc(alias = "XK_Hangul_PieubSios")]
    pub const Hangul_PieubSios: RawKeysym = 0xeb4;
    #[doc(alias = "XK_Hangul_Sios")]
    pub const Hangul_Sios: RawKeysym = 0xeb5;
    #[doc(alias = "XK_Hangul_SsangSios")]
    pub const Hangul_SsangSios: RawKeysym = 0xeb6;
    #[doc(alias = "XK_Hangul_Ieung")]
    pub const Hangul_Ieung: RawKeysym = 0xeb7;
    #[doc(alias = "XK_Hangul_Jieuj")]
    pub const Hangul_Jieuj: RawKeysym = 0xeb8;
    #[doc(alias = "XK_Hangul_SsangJieuj")]
    pub const Hangul_SsangJieuj: RawKeysym = 0xeb9;
    #[doc(alias = "XK_Hangul_Cieuc")]
    pub const Hangul_Cieuc: RawKeysym = 0xeba;
    #[doc(alias = "XK_Hangul_Khieuq")]
    pub const Hangul_Khieuq: RawKeysym = 0xebb;
    #[doc(alias = "XK_Hangul_Tieut")]
    pub const Hangul_Tieut: RawKeysym = 0xebc;
    #[doc(alias = "XK_Hangul_Phieuf")]
    pub const Hangul_Phieuf: RawKeysym = 0xebd;
    #[doc(alias = "XK_Hangul_Hieuh")]
    pub const Hangul_Hieuh: RawKeysym = 0xebe;
    #[doc(alias = "XK_Hangul_A")]
    pub const Hangul_A: RawKeysym = 0xebf;
    #[doc(alias = "XK_Hangul_AE")]
    pub const Hangul_AE: RawKeysym = 0xec0;
    #[doc(alias = "XK_Hangul_YA")]
    pub const Hangul_YA: RawKeysym = 0xec1;
    #[doc(alias = "XK_Hangul_YAE")]
    pub const Hangul_YAE: RawKeysym = 0xec2;
    #[doc(alias = "XK_Hangul_EO")]
    pub const Hangul_EO: RawKeysym = 0xec3;
    #[doc(alias = "XK_Hangul_E")]
    pub const Hangul_E: RawKeysym = 0xec4;
    #[doc(alias = "XK_Hangul_YEO")]
    pub const Hangul_YEO: RawKeysym = 0xec5;
    #[doc(alias = "XK_Hangul_YE")]
    pub const Hangul_YE: RawKeysym = 0xec6;
    #[doc(alias = "XK_Hangul_O")]
    pub const Hangul_O: RawKeysym = 0xec7;
    #[doc(alias = "XK_Hangul_WA")]
    pub const Hangul_WA: RawKeysym = 0xec8;
    #[doc(alias = "XK_Hangul_WAE")]
    pub const Hangul_WAE: RawKeysym = 0xec9;
    #[doc(alias = "XK_Hangul_OE")]
    pub const Hangul_OE: RawKeysym = 0xeca;
    #[doc(alias = "XK_Hangul_YO")]
    pub const Hangul_YO: RawKeysym = 0xecb;
    #[doc(alias = "XK_Hangul_U")]
    pub const Hangul_U: RawKeysym = 0xecc;
    #[doc(alias = "XK_Hangul_WEO")]
    pub const Hangul_WEO: RawKeysym = 0xecd;
    #[doc(alias = "XK_Hangul_WE")]
    pub const Hangul_WE: RawKeysym = 0xece;
    #[doc(alias = "XK_Hangul_WI")]
    pub const Hangul_WI: RawKeysym = 0xecf;
    #[doc(alias = "XK_Hangul_YU")]
    pub const Hangul_YU: RawKeysym = 0xed0;
    #[doc(alias = "XK_Hangul_EU")]
    pub const Hangul_EU: RawKeysym = 0xed1;
    #[doc(alias = "XK_Hangul_YI")]
    pub const Hangul_YI: RawKeysym = 0xed2;
    #[doc(alias = "XK_Hangul_I")]
    pub const Hangul_I: RawKeysym = 0xed3;
    #[doc(alias = "XK_Hangul_J_Kiyeog")]
    pub const Hangul_J_Kiyeog: RawKeysym = 0xed4;
    #[doc(alias = "XK_Hangul_J_SsangKiyeog")]
    pub const Hangul_J_SsangKiyeog: RawKeysym = 0xed5;
    #[doc(alias = "XK_Hangul_J_KiyeogSios")]
    pub const Hangul_J_KiyeogSios: RawKeysym = 0xed6;
    #[doc(alias = "XK_Hangul_J_Nieun")]
    pub const Hangul_J_Nieun: RawKeysym = 0xed7;
    #[doc(alias = "XK_Hangul_J_NieunJieuj")]
    pub const Hangul_J_NieunJieuj: RawKeysym = 0xed8;
    #[doc(alias = "XK_Hangul_J_NieunHieuh")]
    pub const Hangul_J_NieunHieuh: RawKeysym = 0xed9;
    #[doc(alias = "XK_Hangul_J_Dikeud")]
    pub const Hangul_J_Dikeud: RawKeysym = 0xeda;
    #[doc(alias = "XK_Hangul_J_Rieul")]
    pub const Hangul_J_Rieul: RawKeysym = 0xedb;
    #[doc(alias = "XK_Hangul_J_RieulKiyeog")]
    pub const Hangul_J_RieulKiyeog: RawKeysym = 0xedc;
    #[doc(alias = "XK_Hangul_J_RieulMieum")]
    pub const Hangul_J_RieulMieum: RawKeysym = 0xedd;
    #[doc(alias = "XK_Hangul_J_RieulPieub")]
    pub const Hangul_J_RieulPieub: RawKeysym = 0xede;
    #[doc(alias = "XK_Hangul_J_RieulSios")]
    pub const Hangul_J_RieulSios: RawKeysym = 0xedf;
    #[doc(alias = "XK_Hangul_J_RieulTieut")]
    pub const Hangul_J_RieulTieut: RawKeysym = 0xee0;
    #[doc(alias = "XK_Hangul_J_RieulPhieuf")]
    pub const Hangul_J_RieulPhieuf: RawKeysym = 0xee1;
    #[doc(alias = "XK_Hangul_J_RieulHieuh")]
    pub const Hangul_J_RieulHieuh: RawKeysym = 0xee2;
    #[doc(alias = "XK_Hangul_J_Mieum")]
    pub const Hangul_J_Mieum: RawKeysym = 0xee3;
    #[doc(alias = "XK_Hangul_J_Pieub")]
    pub const Hangul_J_Pieub: RawKeysym = 0xee4;
    #[doc(alias = "XK_Hangul_J_PieubSios")]
    pub const Hangul_J_PieubSios: RawKeysym = 0xee5;
    #[doc(alias = "XK_Hangul_J_Sios")]
    pub const Hangul_J_Sios: RawKeysym = 0xee6;
    #[doc(alias = "XK_Hangul_J_SsangSios")]
    pub const Hangul_J_SsangSios: RawKeysym = 0xee7;
    #[doc(alias = "XK_Hangul_J_Ieung")]
    pub const Hangul_J_Ieung: RawKeysym = 0xee8;
    #[doc(alias = "XK_Hangul_J_Jieuj")]
    pub const Hangul_J_Jieuj: RawKeysym = 0xee9;
    #[doc(alias = "XK_Hangul_J_Cieuc")]
    pub const Hangul_J_Cieuc: RawKeysym = 0xeea;
    #[doc(alias = "XK_Hangul_J_Khieuq")]
    pub const Hangul_J_Khieuq: RawKeysym = 0xeeb;
    #[doc(alias = "XK_Hangul_J_Tieut")]
    pub const Hangul_J_Tieut: RawKeysym = 0xeec;
    #[doc(alias = "XK_Hangul_J_Phieuf")]
    pub const Hangul_J_Phieuf: RawKeysym = 0xeed;
    #[doc(alias = "XK_Hangul_J_Hieuh")]
    pub const Hangul_J_Hieuh: RawKeysym = 0xeee;
    #[doc(alias = "XK_Hangul_RieulYeorinHieuh")]
    pub const Hangul_RieulYeorinHieuh: RawKeysym = 0xeef;
    #[doc(alias = "XK_Hangul_SunkyeongeumMieum")]
    pub const Hangul_SunkyeongeumMieum: RawKeysym = 0xef0;
    #[doc(alias = "XK_Hangul_SunkyeongeumPieub")]
    pub const Hangul_SunkyeongeumPieub: RawKeysym = 0xef1;
    #[doc(alias = "XK_Hangul_PanSios")]
    pub const Hangul_PanSios: RawKeysym = 0xef2;
    #[doc(alias = "XK_Hangul_KkogjiDalrinIeung")]
    pub const Hangul_KkogjiDalrinIeung: RawKeysym = 0xef3;
    #[doc(alias = "XK_Hangul_SunkyeongeumPhieuf")]
    pub const Hangul_SunkyeongeumPhieuf: RawKeysym = 0xef4;
    #[doc(alias = "XK_Hangul_YeorinHieuh")]
    pub const Hangul_YeorinHieuh: RawKeysym = 0xef5;
    #[doc(alias = "XK_Hangul_AraeA")]
    pub const Hangul_AraeA: RawKeysym = 0xef6;
    #[doc(alias = "XK_Hangul_AraeAE")]
    pub const Hangul_AraeAE: RawKeysym = 0xef7;
    #[doc(alias = "XK_Hangul_J_PanSios")]
    pub const Hangul_J_PanSios: RawKeysym = 0xef8;
    #[doc(alias = "XK_Hangul_J_KkogjiDalrinIeung")]
    pub const Hangul_J_KkogjiDalrinIeung: RawKeysym = 0xef9;
    #[doc(alias = "XK_Hangul_J_YeorinHieuh")]
    pub const Hangul_J_YeorinHieuh: RawKeysym = 0xefa;
    #[doc(alias = "XK_Korean_Won")]
    pub const Korean_Won: RawKeysym = 0xeff;
    #[doc(alias = "XK_Armenian_ligature_ew")]
    pub const Armenian_ligature_ew: RawKeysym = 0x1000587;
    #[doc(alias = "XK_Armenian_full_stop")]
    pub const Armenian_full_stop: RawKeysym = 0x1000589;
    #[doc(alias = "XK_Armenian_verjaket")]
    pub const Armenian_verjaket: RawKeysym = 0x1000589;
    #[doc(alias = "XK_Armenian_separation_mark")]
    pub const Armenian_separation_mark: RawKeysym = 0x100055d;
    #[doc(alias = "XK_Armenian_but")]
    pub const Armenian_but: RawKeysym = 0x100055d;
    #[doc(alias = "XK_Armenian_hyphen")]
    pub const Armenian_hyphen: RawKeysym = 0x100058a;
    #[doc(alias = "XK_Armenian_yentamna")]
    pub const Armenian_yentamna: RawKeysym = 0x100058a;
    #[doc(alias = "XK_Armenian_exclam")]
    pub const Armenian_exclam: RawKeysym = 0x100055c;
    #[doc(alias = "XK_Armenian_amanak")]
    pub const Armenian_amanak: RawKeysym = 0x100055c;
    #[doc(alias = "XK_Armenian_accent")]
    pub const Armenian_accent: RawKeysym = 0x100055b;
    #[doc(alias = "XK_Armenian_shesht")]
    pub const Armenian_shesht: RawKeysym = 0x100055b;
    #[doc(alias = "XK_Armenian_question")]
    pub const Armenian_question: RawKeysym = 0x100055e;
    #[doc(alias = "XK_Armenian_paruyk")]
    pub const Armenian_paruyk: RawKeysym = 0x100055e;
    #[doc(alias = "XK_Armenian_AYB")]
    pub const Armenian_AYB: RawKeysym = 0x1000531;
    #[doc(alias = "XK_Armenian_ayb")]
    pub const Armenian_ayb: RawKeysym = 0x1000561;
    #[doc(alias = "XK_Armenian_BEN")]
    pub const Armenian_BEN: RawKeysym = 0x1000532;
    #[doc(alias = "XK_Armenian_ben")]
    pub const Armenian_ben: RawKeysym = 0x1000562;
    #[doc(alias = "XK_Armenian_GIM")]
    pub const Armenian_GIM: RawKeysym = 0x1000533;
    #[doc(alias = "XK_Armenian_gim")]
    pub const Armenian_gim: RawKeysym = 0x1000563;
    #[doc(alias = "XK_Armenian_DA")]
    pub const Armenian_DA: RawKeysym = 0x1000534;
    #[doc(alias = "XK_Armenian_da")]
    pub const Armenian_da: RawKeysym = 0x1000564;
    #[doc(alias = "XK_Armenian_YECH")]
    pub const Armenian_YECH: RawKeysym = 0x1000535;
    #[doc(alias = "XK_Armenian_yech")]
    pub const Armenian_yech: RawKeysym = 0x1000565;
    #[doc(alias = "XK_Armenian_ZA")]
    pub const Armenian_ZA: RawKeysym = 0x1000536;
    #[doc(alias = "XK_Armenian_za")]
    pub const Armenian_za: RawKeysym = 0x1000566;
    #[doc(alias = "XK_Armenian_E")]
    pub const Armenian_E: RawKeysym = 0x1000537;
    #[doc(alias = "XK_Armenian_e")]
    pub const Armenian_e: RawKeysym = 0x1000567;
    #[doc(alias = "XK_Armenian_AT")]
    pub const Armenian_AT: RawKeysym = 0x1000538;
    #[doc(alias = "XK_Armenian_at")]
    pub const Armenian_at: RawKeysym = 0x1000568;
    #[doc(alias = "XK_Armenian_TO")]
    pub const Armenian_TO: RawKeysym = 0x1000539;
    #[doc(alias = "XK_Armenian_to")]
    pub const Armenian_to: RawKeysym = 0x1000569;
    #[doc(alias = "XK_Armenian_ZHE")]
    pub const Armenian_ZHE: RawKeysym = 0x100053a;
    #[doc(alias = "XK_Armenian_zhe")]
    pub const Armenian_zhe: RawKeysym = 0x100056a;
    #[doc(alias = "XK_Armenian_INI")]
    pub const Armenian_INI: RawKeysym = 0x100053b;
    #[doc(alias = "XK_Armenian_ini")]
    pub const Armenian_ini: RawKeysym = 0x100056b;
    #[doc(alias = "XK_Armenian_LYUN")]
    pub const Armenian_LYUN: RawKeysym = 0x100053c;
    #[doc(alias = "XK_Armenian_lyun")]
    pub const Armenian_lyun: RawKeysym = 0x100056c;
    #[doc(alias = "XK_Armenian_KHE")]
    pub const Armenian_KHE: RawKeysym = 0x100053d;
    #[doc(alias = "XK_Armenian_khe")]
    pub const Armenian_khe: RawKeysym = 0x100056d;
    #[doc(alias = "XK_Armenian_TSA")]
    pub const Armenian_TSA: RawKeysym = 0x100053e;
    #[doc(alias = "XK_Armenian_tsa")]
    pub const Armenian_tsa: RawKeysym = 0x100056e;
    #[doc(alias = "XK_Armenian_KEN")]
    pub const Armenian_KEN: RawKeysym = 0x100053f;
    #[doc(alias = "XK_Armenian_ken")]
    pub const Armenian_ken: RawKeysym = 0x100056f;
    #[doc(alias = "XK_Armenian_HO")]
    pub const Armenian_HO: RawKeysym = 0x1000540;
    #[doc(alias = "XK_Armenian_ho")]
    pub const Armenian_ho: RawKeysym = 0x1000570;
    #[doc(alias = "XK_Armenian_DZA")]
    pub const Armenian_DZA: RawKeysym = 0x1000541;
    #[doc(alias = "XK_Armenian_dza")]
    pub const Armenian_dza: RawKeysym = 0x1000571;
    #[doc(alias = "XK_Armenian_GHAT")]
    pub const Armenian_GHAT: RawKeysym = 0x1000542;
    #[doc(alias = "XK_Armenian_ghat")]
    pub const Armenian_ghat: RawKeysym = 0x1000572;
    #[doc(alias = "XK_Armenian_TCHE")]
    pub const Armenian_TCHE: RawKeysym = 0x1000543;
    #[doc(alias = "XK_Armenian_tche")]
    pub const Armenian_tche: RawKeysym = 0x1000573;
    #[doc(alias = "XK_Armenian_MEN")]
    pub const Armenian_MEN: RawKeysym = 0x1000544;
    #[doc(alias = "XK_Armenian_men")]
    pub const Armenian_men: RawKeysym = 0x1000574;
    #[doc(alias = "XK_Armenian_HI")]
    pub const Armenian_HI: RawKeysym = 0x1000545;
    #[doc(alias = "XK_Armenian_hi")]
    pub const Armenian_hi: RawKeysym = 0x1000575;
    #[doc(alias = "XK_Armenian_NU")]
    pub const Armenian_NU: RawKeysym = 0x1000546;
    #[doc(alias = "XK_Armenian_nu")]
    pub const Armenian_nu: RawKeysym = 0x1000576;
    #[doc(alias = "XK_Armenian_SHA")]
    pub const Armenian_SHA: RawKeysym = 0x1000547;
    #[doc(alias = "XK_Armenian_sha")]
    pub const Armenian_sha: RawKeysym = 0x1000577;
    #[doc(alias = "XK_Armenian_VO")]
    pub const Armenian_VO: RawKeysym = 0x1000548;
    #[doc(alias = "XK_Armenian_vo")]
    pub const Armenian_vo: RawKeysym = 0x1000578;
    #[doc(alias = "XK_Armenian_CHA")]
    pub const Armenian_CHA: RawKeysym = 0x1000549;
    #[doc(alias = "XK_Armenian_cha")]
    pub const Armenian_cha: RawKeysym = 0x1000579;
    #[doc(alias = "XK_Armenian_PE")]
    pub const Armenian_PE: RawKeysym = 0x100054a;
    #[doc(alias = "XK_Armenian_pe")]
    pub const Armenian_pe: RawKeysym = 0x100057a;
    #[doc(alias = "XK_Armenian_JE")]
    pub const Armenian_JE: RawKeysym = 0x100054b;
    #[doc(alias = "XK_Armenian_je")]
    pub const Armenian_je: RawKeysym = 0x100057b;
    #[doc(alias = "XK_Armenian_RA")]
    pub const Armenian_RA: RawKeysym = 0x100054c;
    #[doc(alias = "XK_Armenian_ra")]
    pub const Armenian_ra: RawKeysym = 0x100057c;
    #[doc(alias = "XK_Armenian_SE")]
    pub const Armenian_SE: RawKeysym = 0x100054d;
    #[doc(alias = "XK_Armenian_se")]
    pub const Armenian_se: RawKeysym = 0x100057d;
    #[doc(alias = "XK_Armenian_VEV")]
    pub const Armenian_VEV: RawKeysym = 0x100054e;
    #[doc(alias = "XK_Armenian_vev")]
    pub const Armenian_vev: RawKeysym = 0x100057e;
    #[doc(alias = "XK_Armenian_TYUN")]
    pub const Armenian_TYUN: RawKeysym = 0x100054f;
    #[doc(alias = "XK_Armenian_tyun")]
    pub const Armenian_tyun: RawKeysym = 0x100057f;
    #[doc(alias = "XK_Armenian_RE")]
    pub const Armenian_RE: RawKeysym = 0x1000550;
    #[doc(alias = "XK_Armenian_re")]
    pub const Armenian_re: RawKeysym = 0x1000580;
    #[doc(alias = "XK_Armenian_TSO")]
    pub const Armenian_TSO: RawKeysym = 0x1000551;
    #[doc(alias = "XK_Armenian_tso")]
    pub const Armenian_tso: RawKeysym = 0x1000581;
    #[doc(alias = "XK_Armenian_VYUN")]
    pub const Armenian_VYUN: RawKeysym = 0x1000552;
    #[doc(alias = "XK_Armenian_vyun")]
    pub const Armenian_vyun: RawKeysym = 0x1000582;
    #[doc(alias = "XK_Armenian_PYUR")]
    pub const Armenian_PYUR: RawKeysym = 0x1000553;
    #[doc(alias = "XK_Armenian_pyur")]
    pub const Armenian_pyur: RawKeysym = 0x1000583;
    #[doc(alias = "XK_Armenian_KE")]
    pub const Armenian_KE: RawKeysym = 0x1000554;
    #[doc(alias = "XK_Armenian_ke")]
    pub const Armenian_ke: RawKeysym = 0x1000584;
    #[doc(alias = "XK_Armenian_O")]
    pub const Armenian_O: RawKeysym = 0x1000555;
    #[doc(alias = "XK_Armenian_o")]
    pub const Armenian_o: RawKeysym = 0x1000585;
    #[doc(alias = "XK_Armenian_FE")]
    pub const Armenian_FE: RawKeysym = 0x1000556;
    #[doc(alias = "XK_Armenian_fe")]
    pub const Armenian_fe: RawKeysym = 0x1000586;
    #[doc(alias = "XK_Armenian_apostrophe")]
    pub const Armenian_apostrophe: RawKeysym = 0x100055a;
    #[doc(alias = "XK_Georgian_an")]
    pub const Georgian_an: RawKeysym = 0x10010d0;
    #[doc(alias = "XK_Georgian_ban")]
    pub const Georgian_ban: RawKeysym = 0x10010d1;
    #[doc(alias = "XK_Georgian_gan")]
    pub const Georgian_gan: RawKeysym = 0x10010d2;
    #[doc(alias = "XK_Georgian_don")]
    pub const Georgian_don: RawKeysym = 0x10010d3;
    #[doc(alias = "XK_Georgian_en")]
    pub const Georgian_en: RawKeysym = 0x10010d4;
    #[doc(alias = "XK_Georgian_vin")]
    pub const Georgian_vin: RawKeysym = 0x10010d5;
    #[doc(alias = "XK_Georgian_zen")]
    pub const Georgian_zen: RawKeysym = 0x10010d6;
    #[doc(alias = "XK_Georgian_tan")]
    pub const Georgian_tan: RawKeysym = 0x10010d7;
    #[doc(alias = "XK_Georgian_in")]
    pub const Georgian_in: RawKeysym = 0x10010d8;
    #[doc(alias = "XK_Georgian_kan")]
    pub const Georgian_kan: RawKeysym = 0x10010d9;
    #[doc(alias = "XK_Georgian_las")]
    pub const Georgian_las: RawKeysym = 0x10010da;
    #[doc(alias = "XK_Georgian_man")]
    pub const Georgian_man: RawKeysym = 0x10010db;
    #[doc(alias = "XK_Georgian_nar")]
    pub const Georgian_nar: RawKeysym = 0x10010dc;
    #[doc(alias = "XK_Georgian_on")]
    pub const Georgian_on: RawKeysym = 0x10010dd;
    #[doc(alias = "XK_Georgian_par")]
    pub const Georgian_par: RawKeysym = 0x10010de;
    #[doc(alias = "XK_Georgian_zhar")]
    pub const Georgian_zhar: RawKeysym = 0x10010df;
    #[doc(alias = "XK_Georgian_rae")]
    pub const Georgian_rae: RawKeysym = 0x10010e0;
    #[doc(alias = "XK_Georgian_san")]
    pub const Georgian_san: RawKeysym = 0x10010e1;
    #[doc(alias = "XK_Georgian_tar")]
    pub const Georgian_tar: RawKeysym = 0x10010e2;
    #[doc(alias = "XK_Georgian_un")]
    pub const Georgian_un: RawKeysym = 0x10010e3;
    #[doc(alias = "XK_Georgian_phar")]
    pub const Georgian_phar: RawKeysym = 0x10010e4;
    #[doc(alias = "XK_Georgian_khar")]
    pub const Georgian_khar: RawKeysym = 0x10010e5;
    #[doc(alias = "XK_Georgian_ghan")]
    pub const Georgian_ghan: RawKeysym = 0x10010e6;
    #[doc(alias = "XK_Georgian_qar")]
    pub const Georgian_qar: RawKeysym = 0x10010e7;
    #[doc(alias = "XK_Georgian_shin")]
    pub const Georgian_shin: RawKeysym = 0x10010e8;
    #[doc(alias = "XK_Georgian_chin")]
    pub const Georgian_chin: RawKeysym = 0x10010e9;
    #[doc(alias = "XK_Georgian_can")]
    pub const Georgian_can: RawKeysym = 0x10010ea;
    #[doc(alias = "XK_Georgian_jil")]
    pub const Georgian_jil: RawKeysym = 0x10010eb;
    #[doc(alias = "XK_Georgian_cil")]
    pub const Georgian_cil: RawKeysym = 0x10010ec;
    #[doc(alias = "XK_Georgian_char")]
    pub const Georgian_char: RawKeysym = 0x10010ed;
    #[doc(alias = "XK_Georgian_xan")]
    pub const Georgian_xan: RawKeysym = 0x10010ee;
    #[doc(alias = "XK_Georgian_jhan")]
    pub const Georgian_jhan: RawKeysym = 0x10010ef;
    #[doc(alias = "XK_Georgian_hae")]
    pub const Georgian_hae: RawKeysym = 0x10010f0;
    #[doc(alias = "XK_Georgian_he")]
    pub const Georgian_he: RawKeysym = 0x10010f1;
    #[doc(alias = "XK_Georgian_hie")]
    pub const Georgian_hie: RawKeysym = 0x10010f2;
    #[doc(alias = "XK_Georgian_we")]
    pub const Georgian_we: RawKeysym = 0x10010f3;
    #[doc(alias = "XK_Georgian_har")]
    pub const Georgian_har: RawKeysym = 0x10010f4;
    #[doc(alias = "XK_Georgian_hoe")]
    pub const Georgian_hoe: RawKeysym = 0x10010f5;
    #[doc(alias = "XK_Georgian_fi")]
    pub const Georgian_fi: RawKeysym = 0x10010f6;
    #[doc(alias = "XK_Xabovedot")]
    pub const Xabovedot: RawKeysym = 0x1001e8a;
    #[doc(alias = "XK_Ibreve")]
    pub const Ibreve: RawKeysym = 0x100012c;
    #[doc(alias = "XK_Zstroke")]
    pub const Zstroke: RawKeysym = 0x10001b5;
    #[doc(alias = "XK_Gcaron")]
    pub const Gcaron: RawKeysym = 0x10001e6;
    #[doc(alias = "XK_Ocaron")]
    pub const Ocaron: RawKeysym = 0x10001d1;
    #[doc(alias = "XK_Obarred")]
    pub const Obarred: RawKeysym = 0x100019f;
    #[doc(alias = "XK_xabovedot")]
    pub const xabovedot: RawKeysym = 0x1001e8b;
    #[doc(alias = "XK_ibreve")]
    pub const ibreve: RawKeysym = 0x100012d;
    #[doc(alias = "XK_zstroke")]
    pub const zstroke: RawKeysym = 0x10001b6;
    #[doc(alias = "XK_gcaron")]
    pub const gcaron: RawKeysym = 0x10001e7;
    #[doc(alias = "XK_ocaron")]
    pub const ocaron: RawKeysym = 0x10001d2;
    #[doc(alias = "XK_obarred")]
    pub const obarred: RawKeysym = 0x1000275;
    #[doc(alias = "XK_SCHWA")]
    pub const SCHWA: RawKeysym = 0x100018f;
    #[doc(alias = "XK_schwa")]
    pub const schwa: RawKeysym = 0x1000259;
    #[doc(alias = "XK_EZH")]
    pub const EZH: RawKeysym = 0x10001b7;
    #[doc(alias = "XK_ezh")]
    pub const ezh: RawKeysym = 0x1000292;
    #[doc(alias = "XK_Lbelowdot")]
    pub const Lbelowdot: RawKeysym = 0x1001e36;
    #[doc(alias = "XK_lbelowdot")]
    pub const lbelowdot: RawKeysym = 0x1001e37;
    #[doc(alias = "XK_Abelowdot")]
    pub const Abelowdot: RawKeysym = 0x1001ea0;
    #[doc(alias = "XK_abelowdot")]
    pub const abelowdot: RawKeysym = 0x1001ea1;
    #[doc(alias = "XK_Ahook")]
    pub const Ahook: RawKeysym = 0x1001ea2;
    #[doc(alias = "XK_ahook")]
    pub const ahook: RawKeysym = 0x1001ea3;
    #[doc(alias = "XK_Acircumflexacute")]
    pub const Acircumflexacute: RawKeysym = 0x1001ea4;
    #[doc(alias = "XK_acircumflexacute")]
    pub const acircumflexacute: RawKeysym = 0x1001ea5;
    #[doc(alias = "XK_Acircumflexgrave")]
    pub const Acircumflexgrave: RawKeysym = 0x1001ea6;
    #[doc(alias = "XK_acircumflexgrave")]
    pub const acircumflexgrave: RawKeysym = 0x1001ea7;
    #[doc(alias = "XK_Acircumflexhook")]
    pub const Acircumflexhook: RawKeysym = 0x1001ea8;
    #[doc(alias = "XK_acircumflexhook")]
    pub const acircumflexhook: RawKeysym = 0x1001ea9;
    #[doc(alias = "XK_Acircumflextilde")]
    pub const Acircumflextilde: RawKeysym = 0x1001eaa;
    #[doc(alias = "XK_acircumflextilde")]
    pub const acircumflextilde: RawKeysym = 0x1001eab;
    #[doc(alias = "XK_Acircumflexbelowdot")]
    pub const Acircumflexbelowdot: RawKeysym = 0x1001eac;
    #[doc(alias = "XK_acircumflexbelowdot")]
    pub const acircumflexbelowdot: RawKeysym = 0x1001ead;
    #[doc(alias = "XK_Abreveacute")]
    pub const Abreveacute: RawKeysym = 0x1001eae;
    #[doc(alias = "XK_abreveacute")]
    pub const abreveacute: RawKeysym = 0x1001eaf;
    #[doc(alias = "XK_Abrevegrave")]
    pub const Abrevegrave: RawKeysym = 0x1001eb0;
    #[doc(alias = "XK_abrevegrave")]
    pub const abrevegrave: RawKeysym = 0x1001eb1;
    #[doc(alias = "XK_Abrevehook")]
    pub const Abrevehook: RawKeysym = 0x1001eb2;
    #[doc(alias = "XK_abrevehook")]
    pub const abrevehook: RawKeysym = 0x1001eb3;
    #[doc(alias = "XK_Abrevetilde")]
    pub const Abrevetilde: RawKeysym = 0x1001eb4;
    #[doc(alias = "XK_abrevetilde")]
    pub const abrevetilde: RawKeysym = 0x1001eb5;
    #[doc(alias = "XK_Abrevebelowdot")]
    pub const Abrevebelowdot: RawKeysym = 0x1001eb6;
    #[doc(alias = "XK_abrevebelowdot")]
    pub const abrevebelowdot: RawKeysym = 0x1001eb7;
    #[doc(alias = "XK_Ebelowdot")]
    pub const Ebelowdot: RawKeysym = 0x1001eb8;
    #[doc(alias = "XK_ebelowdot")]
    pub const ebelowdot: RawKeysym = 0x1001eb9;
    #[doc(alias = "XK_Ehook")]
    pub const Ehook: RawKeysym = 0x1001eba;
    #[doc(alias = "XK_ehook")]
    pub const ehook: RawKeysym = 0x1001ebb;
    #[doc(alias = "XK_Etilde")]
    pub const Etilde: RawKeysym = 0x1001ebc;
    #[doc(alias = "XK_etilde")]
    pub const etilde: RawKeysym = 0x1001ebd;
    #[doc(alias = "XK_Ecircumflexacute")]
    pub const Ecircumflexacute: RawKeysym = 0x1001ebe;
    #[doc(alias = "XK_ecircumflexacute")]
    pub const ecircumflexacute: RawKeysym = 0x1001ebf;
    #[doc(alias = "XK_Ecircumflexgrave")]
    pub const Ecircumflexgrave: RawKeysym = 0x1001ec0;
    #[doc(alias = "XK_ecircumflexgrave")]
    pub const ecircumflexgrave: RawKeysym = 0x1001ec1;
    #[doc(alias = "XK_Ecircumflexhook")]
    pub const Ecircumflexhook: RawKeysym = 0x1001ec2;
    #[doc(alias = "XK_ecircumflexhook")]
    pub const ecircumflexhook: RawKeysym = 0x1001ec3;
    #[doc(alias = "XK_Ecircumflextilde")]
    pub const Ecircumflextilde: RawKeysym = 0x1001ec4;
    #[doc(alias = "XK_ecircumflextilde")]
    pub const ecircumflextilde: RawKeysym = 0x1001ec5;
    #[doc(alias = "XK_Ecircumflexbelowdot")]
    pub const Ecircumflexbelowdot: RawKeysym = 0x1001ec6;
    #[doc(alias = "XK_ecircumflexbelowdot")]
    pub const ecircumflexbelowdot: RawKeysym = 0x1001ec7;
    #[doc(alias = "XK_Ihook")]
    pub const Ihook: RawKeysym = 0x1001ec8;
    #[doc(alias = "XK_ihook")]
    pub const ihook: RawKeysym = 0x1001ec9;
    #[doc(alias = "XK_Ibelowdot")]
    pub const Ibelowdot: RawKeysym = 0x1001eca;
    #[doc(alias = "XK_ibelowdot")]
    pub const ibelowdot: RawKeysym = 0x1001ecb;
    #[doc(alias = "XK_Obelowdot")]
    pub const Obelowdot: RawKeysym = 0x1001ecc;
    #[doc(alias = "XK_obelowdot")]
    pub const obelowdot: RawKeysym = 0x1001ecd;
    #[doc(alias = "XK_Ohook")]
    pub const Ohook: RawKeysym = 0x1001ece;
    #[doc(alias = "XK_ohook")]
    pub const ohook: RawKeysym = 0x1001ecf;
    #[doc(alias = "XK_Ocircumflexacute")]
    pub const Ocircumflexacute: RawKeysym = 0x1001ed0;
    #[doc(alias = "XK_ocircumflexacute")]
    pub const ocircumflexacute: RawKeysym = 0x1001ed1;
    #[doc(alias = "XK_Ocircumflexgrave")]
    pub const Ocircumflexgrave: RawKeysym = 0x1001ed2;
    #[doc(alias = "XK_ocircumflexgrave")]
    pub const ocircumflexgrave: RawKeysym = 0x1001ed3;
    #[doc(alias = "XK_Ocircumflexhook")]
    pub const Ocircumflexhook: RawKeysym = 0x1001ed4;
    #[doc(alias = "XK_ocircumflexhook")]
    pub const ocircumflexhook: RawKeysym = 0x1001ed5;
    #[doc(alias = "XK_Ocircumflextilde")]
    pub const Ocircumflextilde: RawKeysym = 0x1001ed6;
    #[doc(alias = "XK_ocircumflextilde")]
    pub const ocircumflextilde: RawKeysym = 0x1001ed7;
    #[doc(alias = "XK_Ocircumflexbelowdot")]
    pub const Ocircumflexbelowdot: RawKeysym = 0x1001ed8;
    #[doc(alias = "XK_ocircumflexbelowdot")]
    pub const ocircumflexbelowdot: RawKeysym = 0x1001ed9;
    #[doc(alias = "XK_Ohornacute")]
    pub const Ohornacute: RawKeysym = 0x1001eda;
    #[doc(alias = "XK_ohornacute")]
    pub const ohornacute: RawKeysym = 0x1001edb;
    #[doc(alias = "XK_Ohorngrave")]
    pub const Ohorngrave: RawKeysym = 0x1001edc;
    #[doc(alias = "XK_ohorngrave")]
    pub const ohorngrave: RawKeysym = 0x1001edd;
    #[doc(alias = "XK_Ohornhook")]
    pub const Ohornhook: RawKeysym = 0x1001ede;
    #[doc(alias = "XK_ohornhook")]
    pub const ohornhook: RawKeysym = 0x1001edf;
    #[doc(alias = "XK_Ohorntilde")]
    pub const Ohorntilde: RawKeysym = 0x1001ee0;
    #[doc(alias = "XK_ohorntilde")]
    pub const ohorntilde: RawKeysym = 0x1001ee1;
    #[doc(alias = "XK_Ohornbelowdot")]
    pub const Ohornbelowdot: RawKeysym = 0x1001ee2;
    #[doc(alias = "XK_ohornbelowdot")]
    pub const ohornbelowdot: RawKeysym = 0x1001ee3;
    #[doc(alias = "XK_Ubelowdot")]
    pub const Ubelowdot: RawKeysym = 0x1001ee4;
    #[doc(alias = "XK_ubelowdot")]
    pub const ubelowdot: RawKeysym = 0x1001ee5;
    #[doc(alias = "XK_Uhook")]
    pub const Uhook: RawKeysym = 0x1001ee6;
    #[doc(alias = "XK_uhook")]
    pub const uhook: RawKeysym = 0x1001ee7;
    #[doc(alias = "XK_Uhornacute")]
    pub const Uhornacute: RawKeysym = 0x1001ee8;
    #[doc(alias = "XK_uhornacute")]
    pub const uhornacute: RawKeysym = 0x1001ee9;
    #[doc(alias = "XK_Uhorngrave")]
    pub const Uhorngrave: RawKeysym = 0x1001eea;
    #[doc(alias = "XK_uhorngrave")]
    pub const uhorngrave: RawKeysym = 0x1001eeb;
    #[doc(alias = "XK_Uhornhook")]
    pub const Uhornhook: RawKeysym = 0x1001eec;
    #[doc(alias = "XK_uhornhook")]
    pub const uhornhook: RawKeysym = 0x1001eed;
    #[doc(alias = "XK_Uhorntilde")]
    pub const Uhorntilde: RawKeysym = 0x1001eee;
    #[doc(alias = "XK_uhorntilde")]
    pub const uhorntilde: RawKeysym = 0x1001eef;
    #[doc(alias = "XK_Uhornbelowdot")]
    pub const Uhornbelowdot: RawKeysym = 0x1001ef0;
    #[doc(alias = "XK_uhornbelowdot")]
    pub const uhornbelowdot: RawKeysym = 0x1001ef1;
    #[doc(alias = "XK_Ybelowdot")]
    pub const Ybelowdot: RawKeysym = 0x1001ef4;
    #[doc(alias = "XK_ybelowdot")]
    pub const ybelowdot: RawKeysym = 0x1001ef5;
    #[doc(alias = "XK_Yhook")]
    pub const Yhook: RawKeysym = 0x1001ef6;
    #[doc(alias = "XK_yhook")]
    pub const yhook: RawKeysym = 0x1001ef7;
    #[doc(alias = "XK_Ytilde")]
    pub const Ytilde: RawKeysym = 0x1001ef8;
    #[doc(alias = "XK_ytilde")]
    pub const ytilde: RawKeysym = 0x1001ef9;
    #[doc(alias = "XK_Ohorn")]
    pub const Ohorn: RawKeysym = 0x10001a0;
    #[doc(alias = "XK_ohorn")]
    pub const ohorn: RawKeysym = 0x10001a1;
    #[doc(alias = "XK_Uhorn")]
    pub const Uhorn: RawKeysym = 0x10001af;
    #[doc(alias = "XK_uhorn")]
    pub const uhorn: RawKeysym = 0x10001b0;
    #[doc(alias = "XK_combining_tilde")]
    pub const combining_tilde: RawKeysym = 0x1000303;
    #[doc(alias = "XK_combining_grave")]
    pub const combining_grave: RawKeysym = 0x1000300;
    #[doc(alias = "XK_combining_acute")]
    pub const combining_acute: RawKeysym = 0x1000301;
    #[doc(alias = "XK_combining_hook")]
    pub const combining_hook: RawKeysym = 0x1000309;
    #[doc(alias = "XK_combining_belowdot")]
    pub const combining_belowdot: RawKeysym = 0x1000323;
    #[doc(alias = "XK_EcuSign")]
    pub const EcuSign: RawKeysym = 0x10020a0;
    #[doc(alias = "XK_ColonSign")]
    pub const ColonSign: RawKeysym = 0x10020a1;
    #[doc(alias = "XK_CruzeiroSign")]
    pub const CruzeiroSign: RawKeysym = 0x10020a2;
    #[doc(alias = "XK_FFrancSign")]
    pub const FFrancSign: RawKeysym = 0x10020a3;
    #[doc(alias = "XK_LiraSign")]
    pub const LiraSign: RawKeysym = 0x10020a4;
    #[doc(alias = "XK_MillSign")]
    pub const MillSign: RawKeysym = 0x10020a5;
    #[doc(alias = "XK_NairaSign")]
    pub const NairaSign: RawKeysym = 0x10020a6;
    #[doc(alias = "XK_PesetaSign")]
    pub const PesetaSign: RawKeysym = 0x10020a7;
    #[doc(alias = "XK_RupeeSign")]
    pub const RupeeSign: RawKeysym = 0x10020a8;
    #[doc(alias = "XK_WonSign")]
    pub const WonSign: RawKeysym = 0x10020a9;
    #[doc(alias = "XK_NewSheqelSign")]
    pub const NewSheqelSign: RawKeysym = 0x10020aa;
    #[doc(alias = "XK_DongSign")]
    pub const DongSign: RawKeysym = 0x10020ab;
    #[doc(alias = "XK_EuroSign")]
    pub const EuroSign: RawKeysym = 0x20ac;
    #[doc(alias = "XK_zerosuperior")]
    pub const zerosuperior: RawKeysym = 0x1002070;
    #[doc(alias = "XK_foursuperior")]
    pub const foursuperior: RawKeysym = 0x1002074;
    #[doc(alias = "XK_fivesuperior")]
    pub const fivesuperior: RawKeysym = 0x1002075;
    #[doc(alias = "XK_sixsuperior")]
    pub const sixsuperior: RawKeysym = 0x1002076;
    #[doc(alias = "XK_sevensuperior")]
    pub const sevensuperior: RawKeysym = 0x1002077;
    #[doc(alias = "XK_eightsuperior")]
    pub const eightsuperior: RawKeysym = 0x1002078;
    #[doc(alias = "XK_ninesuperior")]
    pub const ninesuperior: RawKeysym = 0x1002079;
    #[doc(alias = "XK_zerosubscript")]
    pub const zerosubscript: RawKeysym = 0x1002080;
    #[doc(alias = "XK_onesubscript")]
    pub const onesubscript: RawKeysym = 0x1002081;
    #[doc(alias = "XK_twosubscript")]
    pub const twosubscript: RawKeysym = 0x1002082;
    #[doc(alias = "XK_threesubscript")]
    pub const threesubscript: RawKeysym = 0x1002083;
    #[doc(alias = "XK_foursubscript")]
    pub const foursubscript: RawKeysym = 0x1002084;
    #[doc(alias = "XK_fivesubscript")]
    pub const fivesubscript: RawKeysym = 0x1002085;
    #[doc(alias = "XK_sixsubscript")]
    pub const sixsubscript: RawKeysym = 0x1002086;
    #[doc(alias = "XK_sevensubscript")]
    pub const sevensubscript: RawKeysym = 0x1002087;
    #[doc(alias = "XK_eightsubscript")]
    pub const eightsubscript: RawKeysym = 0x1002088;
    #[doc(alias = "XK_ninesubscript")]
    pub const ninesubscript: RawKeysym = 0x1002089;
    #[doc(alias = "XK_partdifferential")]
    pub const partdifferential: RawKeysym = 0x1002202;
    #[doc(alias = "XK_emptyset")]
    pub const emptyset: RawKeysym = 0x1002205;
    #[doc(alias = "XK_elementof")]
    pub const elementof: RawKeysym = 0x1002208;
    #[doc(alias = "XK_notelementof")]
    pub const notelementof: RawKeysym = 0x1002209;
    #[doc(alias = "XK_containsas")]
    pub const containsas: RawKeysym = 0x100220b;
    #[doc(alias = "XK_squareroot")]
    pub const squareroot: RawKeysym = 0x100221a;
    #[doc(alias = "XK_cuberoot")]
    pub const cuberoot: RawKeysym = 0x100221b;
    #[doc(alias = "XK_fourthroot")]
    pub const fourthroot: RawKeysym = 0x100221c;
    #[doc(alias = "XK_dintegral")]
    pub const dintegral: RawKeysym = 0x100222c;
    #[doc(alias = "XK_tintegral")]
    pub const tintegral: RawKeysym = 0x100222d;
    #[doc(alias = "XK_because")]
    pub const because: RawKeysym = 0x1002235;
    #[doc(alias = "XK_approxeq")]
    pub const approxeq: RawKeysym = 0x1002248;
    #[doc(alias = "XK_notapproxeq")]
    pub const notapproxeq: RawKeysym = 0x1002247;
    #[doc(alias = "XK_notidentical")]
    pub const notidentical: RawKeysym = 0x1002262;
    #[doc(alias = "XK_stricteq")]
    pub const stricteq: RawKeysym = 0x1002263;
    #[doc(alias = "XK_braille_dot_1")]
    pub const braille_dot_1: RawKeysym = 0xfff1;
    #[doc(alias = "XK_braille_dot_2")]
    pub const braille_dot_2: RawKeysym = 0xfff2;
    #[doc(alias = "XK_braille_dot_3")]
    pub const braille_dot_3: RawKeysym = 0xfff3;
    #[doc(alias = "XK_braille_dot_4")]
    pub const braille_dot_4: RawKeysym = 0xfff4;
    #[doc(alias = "XK_braille_dot_5")]
    pub const braille_dot_5: RawKeysym = 0xfff5;
    #[doc(alias = "XK_braille_dot_6")]
    pub const braille_dot_6: RawKeysym = 0xfff6;
    #[doc(alias = "XK_braille_dot_7")]
    pub const braille_dot_7: RawKeysym = 0xfff7;
    #[doc(alias = "XK_braille_dot_8")]
    pub const braille_dot_8: RawKeysym = 0xfff8;
    #[doc(alias = "XK_braille_dot_9")]
    pub const braille_dot_9: RawKeysym = 0xfff9;
    #[doc(alias = "XK_braille_dot_10")]
    pub const braille_dot_10: RawKeysym = 0xfffa;
    #[doc(alias = "XK_braille_blank")]
    pub const braille_blank: RawKeysym = 0x1002800;
    #[doc(alias = "XK_braille_dots_1")]
    pub const braille_dots_1: RawKeysym = 0x1002801;
    #[doc(alias = "XK_braille_dots_2")]
    pub const braille_dots_2: RawKeysym = 0x1002802;
    #[doc(alias = "XK_braille_dots_12")]
    pub const braille_dots_12: RawKeysym = 0x1002803;
    #[doc(alias = "XK_braille_dots_3")]
    pub const braille_dots_3: RawKeysym = 0x1002804;
    #[doc(alias = "XK_braille_dots_13")]
    pub const braille_dots_13: RawKeysym = 0x1002805;
    #[doc(alias = "XK_braille_dots_23")]
    pub const braille_dots_23: RawKeysym = 0x1002806;
    #[doc(alias = "XK_braille_dots_123")]
    pub const braille_dots_123: RawKeysym = 0x1002807;
    #[doc(alias = "XK_braille_dots_4")]
    pub const braille_dots_4: RawKeysym = 0x1002808;
    #[doc(alias = "XK_braille_dots_14")]
    pub const braille_dots_14: RawKeysym = 0x1002809;
    #[doc(alias = "XK_braille_dots_24")]
    pub const braille_dots_24: RawKeysym = 0x100280a;
    #[doc(alias = "XK_braille_dots_124")]
    pub const braille_dots_124: RawKeysym = 0x100280b;
    #[doc(alias = "XK_braille_dots_34")]
    pub const braille_dots_34: RawKeysym = 0x100280c;
    #[doc(alias = "XK_braille_dots_134")]
    pub const braille_dots_134: RawKeysym = 0x100280d;
    #[doc(alias = "XK_braille_dots_234")]
    pub const braille_dots_234: RawKeysym = 0x100280e;
    #[doc(alias = "XK_braille_dots_1234")]
    pub const braille_dots_1234: RawKeysym = 0x100280f;
    #[doc(alias = "XK_braille_dots_5")]
    pub const braille_dots_5: RawKeysym = 0x1002810;
    #[doc(alias = "XK_braille_dots_15")]
    pub const braille_dots_15: RawKeysym = 0x1002811;
    #[doc(alias = "XK_braille_dots_25")]
    pub const braille_dots_25: RawKeysym = 0x1002812;
    #[doc(alias = "XK_braille_dots_125")]
    pub const braille_dots_125: RawKeysym = 0x1002813;
    #[doc(alias = "XK_braille_dots_35")]
    pub const braille_dots_35: RawKeysym = 0x1002814;
    #[doc(alias = "XK_braille_dots_135")]
    pub const braille_dots_135: RawKeysym = 0x1002815;
    #[doc(alias = "XK_braille_dots_235")]
    pub const braille_dots_235: RawKeysym = 0x1002816;
    #[doc(alias = "XK_braille_dots_1235")]
    pub const braille_dots_1235: RawKeysym = 0x1002817;
    #[doc(alias = "XK_braille_dots_45")]
    pub const braille_dots_45: RawKeysym = 0x1002818;
    #[doc(alias = "XK_braille_dots_145")]
    pub const braille_dots_145: RawKeysym = 0x1002819;
    #[doc(alias = "XK_braille_dots_245")]
    pub const braille_dots_245: RawKeysym = 0x100281a;
    #[doc(alias = "XK_braille_dots_1245")]
    pub const braille_dots_1245: RawKeysym = 0x100281b;
    #[doc(alias = "XK_braille_dots_345")]
    pub const braille_dots_345: RawKeysym = 0x100281c;
    #[doc(alias = "XK_braille_dots_1345")]
    pub const braille_dots_1345: RawKeysym = 0x100281d;
    #[doc(alias = "XK_braille_dots_2345")]
    pub const braille_dots_2345: RawKeysym = 0x100281e;
    #[doc(alias = "XK_braille_dots_12345")]
    pub const braille_dots_12345: RawKeysym = 0x100281f;
    #[doc(alias = "XK_braille_dots_6")]
    pub const braille_dots_6: RawKeysym = 0x1002820;
    #[doc(alias = "XK_braille_dots_16")]
    pub const braille_dots_16: RawKeysym = 0x1002821;
    #[doc(alias = "XK_braille_dots_26")]
    pub const braille_dots_26: RawKeysym = 0x1002822;
    #[doc(alias = "XK_braille_dots_126")]
    pub const braille_dots_126: RawKeysym = 0x1002823;
    #[doc(alias = "XK_braille_dots_36")]
    pub const braille_dots_36: RawKeysym = 0x1002824;
    #[doc(alias = "XK_braille_dots_136")]
    pub const braille_dots_136: RawKeysym = 0x1002825;
    #[doc(alias = "XK_braille_dots_236")]
    pub const braille_dots_236: RawKeysym = 0x1002826;
    #[doc(alias = "XK_braille_dots_1236")]
    pub const braille_dots_1236: RawKeysym = 0x1002827;
    #[doc(alias = "XK_braille_dots_46")]
    pub const braille_dots_46: RawKeysym = 0x1002828;
    #[doc(alias = "XK_braille_dots_146")]
    pub const braille_dots_146: RawKeysym = 0x1002829;
    #[doc(alias = "XK_braille_dots_246")]
    pub const braille_dots_246: RawKeysym = 0x100282a;
    #[doc(alias = "XK_braille_dots_1246")]
    pub const braille_dots_1246: RawKeysym = 0x100282b;
    #[doc(alias = "XK_braille_dots_346")]
    pub const braille_dots_346: RawKeysym = 0x100282c;
    #[doc(alias = "XK_braille_dots_1346")]
    pub const braille_dots_1346: RawKeysym = 0x100282d;
    #[doc(alias = "XK_braille_dots_2346")]
    pub const braille_dots_2346: RawKeysym = 0x100282e;
    #[doc(alias = "XK_braille_dots_12346")]
    pub const braille_dots_12346: RawKeysym = 0x100282f;
    #[doc(alias = "XK_braille_dots_56")]
    pub const braille_dots_56: RawKeysym = 0x1002830;
    #[doc(alias = "XK_braille_dots_156")]
    pub const braille_dots_156: RawKeysym = 0x1002831;
    #[doc(alias = "XK_braille_dots_256")]
    pub const braille_dots_256: RawKeysym = 0x1002832;
    #[doc(alias = "XK_braille_dots_1256")]
    pub const braille_dots_1256: RawKeysym = 0x1002833;
    #[doc(alias = "XK_braille_dots_356")]
    pub const braille_dots_356: RawKeysym = 0x1002834;
    #[doc(alias = "XK_braille_dots_1356")]
    pub const braille_dots_1356: RawKeysym = 0x1002835;
    #[doc(alias = "XK_braille_dots_2356")]
    pub const braille_dots_2356: RawKeysym = 0x1002836;
    #[doc(alias = "XK_braille_dots_12356")]
    pub const braille_dots_12356: RawKeysym = 0x1002837;
    #[doc(alias = "XK_braille_dots_456")]
    pub const braille_dots_456: RawKeysym = 0x1002838;
    #[doc(alias = "XK_braille_dots_1456")]
    pub const braille_dots_1456: RawKeysym = 0x1002839;
    #[doc(alias = "XK_braille_dots_2456")]
    pub const braille_dots_2456: RawKeysym = 0x100283a;
    #[doc(alias = "XK_braille_dots_12456")]
    pub const braille_dots_12456: RawKeysym = 0x100283b;
    #[doc(alias = "XK_braille_dots_3456")]
    pub const braille_dots_3456: RawKeysym = 0x100283c;
    #[doc(alias = "XK_braille_dots_13456")]
    pub const braille_dots_13456: RawKeysym = 0x100283d;
    #[doc(alias = "XK_braille_dots_23456")]
    pub const braille_dots_23456: RawKeysym = 0x100283e;
    #[doc(alias = "XK_braille_dots_123456")]
    pub const braille_dots_123456: RawKeysym = 0x100283f;
    #[doc(alias = "XK_braille_dots_7")]
    pub const braille_dots_7: RawKeysym = 0x1002840;
    #[doc(alias = "XK_braille_dots_17")]
    pub const braille_dots_17: RawKeysym = 0x1002841;
    #[doc(alias = "XK_braille_dots_27")]
    pub const braille_dots_27: RawKeysym = 0x1002842;
    #[doc(alias = "XK_braille_dots_127")]
    pub const braille_dots_127: RawKeysym = 0x1002843;
    #[doc(alias = "XK_braille_dots_37")]
    pub const braille_dots_37: RawKeysym = 0x1002844;
    #[doc(alias = "XK_braille_dots_137")]
    pub const braille_dots_137: RawKeysym = 0x1002845;
    #[doc(alias = "XK_braille_dots_237")]
    pub const braille_dots_237: RawKeysym = 0x1002846;
    #[doc(alias = "XK_braille_dots_1237")]
    pub const braille_dots_1237: RawKeysym = 0x1002847;
    #[doc(alias = "XK_braille_dots_47")]
    pub const braille_dots_47: RawKeysym = 0x1002848;
    #[doc(alias = "XK_braille_dots_147")]
    pub const braille_dots_147: RawKeysym = 0x1002849;
    #[doc(alias = "XK_braille_dots_247")]
    pub const braille_dots_247: RawKeysym = 0x100284a;
    #[doc(alias = "XK_braille_dots_1247")]
    pub const braille_dots_1247: RawKeysym = 0x100284b;
    #[doc(alias = "XK_braille_dots_347")]
    pub const braille_dots_347: RawKeysym = 0x100284c;
    #[doc(alias = "XK_braille_dots_1347")]
    pub const braille_dots_1347: RawKeysym = 0x100284d;
    #[doc(alias = "XK_braille_dots_2347")]
    pub const braille_dots_2347: RawKeysym = 0x100284e;
    #[doc(alias = "XK_braille_dots_12347")]
    pub const braille_dots_12347: RawKeysym = 0x100284f;
    #[doc(alias = "XK_braille_dots_57")]
    pub const braille_dots_57: RawKeysym = 0x1002850;
    #[doc(alias = "XK_braille_dots_157")]
    pub const braille_dots_157: RawKeysym = 0x1002851;
    #[doc(alias = "XK_braille_dots_257")]
    pub const braille_dots_257: RawKeysym = 0x1002852;
    #[doc(alias = "XK_braille_dots_1257")]
    pub const braille_dots_1257: RawKeysym = 0x1002853;
    #[doc(alias = "XK_braille_dots_357")]
    pub const braille_dots_357: RawKeysym = 0x1002854;
    #[doc(alias = "XK_braille_dots_1357")]
    pub const braille_dots_1357: RawKeysym = 0x1002855;
    #[doc(alias = "XK_braille_dots_2357")]
    pub const braille_dots_2357: RawKeysym = 0x1002856;
    #[doc(alias = "XK_braille_dots_12357")]
    pub const braille_dots_12357: RawKeysym = 0x1002857;
    #[doc(alias = "XK_braille_dots_457")]
    pub const braille_dots_457: RawKeysym = 0x1002858;
    #[doc(alias = "XK_braille_dots_1457")]
    pub const braille_dots_1457: RawKeysym = 0x1002859;
    #[doc(alias = "XK_braille_dots_2457")]
    pub const braille_dots_2457: RawKeysym = 0x100285a;
    #[doc(alias = "XK_braille_dots_12457")]
    pub const braille_dots_12457: RawKeysym = 0x100285b;
    #[doc(alias = "XK_braille_dots_3457")]
    pub const braille_dots_3457: RawKeysym = 0x100285c;
    #[doc(alias = "XK_braille_dots_13457")]
    pub const braille_dots_13457: RawKeysym = 0x100285d;
    #[doc(alias = "XK_braille_dots_23457")]
    pub const braille_dots_23457: RawKeysym = 0x100285e;
    #[doc(alias = "XK_braille_dots_123457")]
    pub const braille_dots_123457: RawKeysym = 0x100285f;
    #[doc(alias = "XK_braille_dots_67")]
    pub const braille_dots_67: RawKeysym = 0x1002860;
    #[doc(alias = "XK_braille_dots_167")]
    pub const braille_dots_167: RawKeysym = 0x1002861;
    #[doc(alias = "XK_braille_dots_267")]
    pub const braille_dots_267: RawKeysym = 0x1002862;
    #[doc(alias = "XK_braille_dots_1267")]
    pub const braille_dots_1267: RawKeysym = 0x1002863;
    #[doc(alias = "XK_braille_dots_367")]
    pub const braille_dots_367: RawKeysym = 0x1002864;
    #[doc(alias = "XK_braille_dots_1367")]
    pub const braille_dots_1367: RawKeysym = 0x1002865;
    #[doc(alias = "XK_braille_dots_2367")]
    pub const braille_dots_2367: RawKeysym = 0x1002866;
    #[doc(alias = "XK_braille_dots_12367")]
    pub const braille_dots_12367: RawKeysym = 0x1002867;
    #[doc(alias = "XK_braille_dots_467")]
    pub const braille_dots_467: RawKeysym = 0x1002868;
    #[doc(alias = "XK_braille_dots_1467")]
    pub const braille_dots_1467: RawKeysym = 0x1002869;
    #[doc(alias = "XK_braille_dots_2467")]
    pub const braille_dots_2467: RawKeysym = 0x100286a;
    #[doc(alias = "XK_braille_dots_12467")]
    pub const braille_dots_12467: RawKeysym = 0x100286b;
    #[doc(alias = "XK_braille_dots_3467")]
    pub const braille_dots_3467: RawKeysym = 0x100286c;
    #[doc(alias = "XK_braille_dots_13467")]
    pub const braille_dots_13467: RawKeysym = 0x100286d;
    #[doc(alias = "XK_braille_dots_23467")]
    pub const braille_dots_23467: RawKeysym = 0x100286e;
    #[doc(alias = "XK_braille_dots_123467")]
    pub const braille_dots_123467: RawKeysym = 0x100286f;
    #[doc(alias = "XK_braille_dots_567")]
    pub const braille_dots_567: RawKeysym = 0x1002870;
    #[doc(alias = "XK_braille_dots_1567")]
    pub const braille_dots_1567: RawKeysym = 0x1002871;
    #[doc(alias = "XK_braille_dots_2567")]
    pub const braille_dots_2567: RawKeysym = 0x1002872;
    #[doc(alias = "XK_braille_dots_12567")]
    pub const braille_dots_12567: RawKeysym = 0x1002873;
    #[doc(alias = "XK_braille_dots_3567")]
    pub const braille_dots_3567: RawKeysym = 0x1002874;
    #[doc(alias = "XK_braille_dots_13567")]
    pub const braille_dots_13567: RawKeysym = 0x1002875;
    #[doc(alias = "XK_braille_dots_23567")]
    pub const braille_dots_23567: RawKeysym = 0x1002876;
    #[doc(alias = "XK_braille_dots_123567")]
    pub const braille_dots_123567: RawKeysym = 0x1002877;
    #[doc(alias = "XK_braille_dots_4567")]
    pub const braille_dots_4567: RawKeysym = 0x1002878;
    #[doc(alias = "XK_braille_dots_14567")]
    pub const braille_dots_14567: RawKeysym = 0x1002879;
    #[doc(alias = "XK_braille_dots_24567")]
    pub const braille_dots_24567: RawKeysym = 0x100287a;
    #[doc(alias = "XK_braille_dots_124567")]
    pub const braille_dots_124567: RawKeysym = 0x100287b;
    #[doc(alias = "XK_braille_dots_34567")]
    pub const braille_dots_34567: RawKeysym = 0x100287c;
    #[doc(alias = "XK_braille_dots_134567")]
    pub const braille_dots_134567: RawKeysym = 0x100287d;
    #[doc(alias = "XK_braille_dots_234567")]
    pub const braille_dots_234567: RawKeysym = 0x100287e;
    #[doc(alias = "XK_braille_dots_1234567")]
    pub const braille_dots_1234567: RawKeysym = 0x100287f;
    #[doc(alias = "XK_braille_dots_8")]
    pub const braille_dots_8: RawKeysym = 0x1002880;
    #[doc(alias = "XK_braille_dots_18")]
    pub const braille_dots_18: RawKeysym = 0x1002881;
    #[doc(alias = "XK_braille_dots_28")]
    pub const braille_dots_28: RawKeysym = 0x1002882;
    #[doc(alias = "XK_braille_dots_128")]
    pub const braille_dots_128: RawKeysym = 0x1002883;
    #[doc(alias = "XK_braille_dots_38")]
    pub const braille_dots_38: RawKeysym = 0x1002884;
    #[doc(alias = "XK_braille_dots_138")]
    pub const braille_dots_138: RawKeysym = 0x1002885;
    #[doc(alias = "XK_braille_dots_238")]
    pub const braille_dots_238: RawKeysym = 0x1002886;
    #[doc(alias = "XK_braille_dots_1238")]
    pub const braille_dots_1238: RawKeysym = 0x1002887;
    #[doc(alias = "XK_braille_dots_48")]
    pub const braille_dots_48: RawKeysym = 0x1002888;
    #[doc(alias = "XK_braille_dots_148")]
    pub const braille_dots_148: RawKeysym = 0x1002889;
    #[doc(alias = "XK_braille_dots_248")]
    pub const braille_dots_248: RawKeysym = 0x100288a;
    #[doc(alias = "XK_braille_dots_1248")]
    pub const braille_dots_1248: RawKeysym = 0x100288b;
    #[doc(alias = "XK_braille_dots_348")]
    pub const braille_dots_348: RawKeysym = 0x100288c;
    #[doc(alias = "XK_braille_dots_1348")]
    pub const braille_dots_1348: RawKeysym = 0x100288d;
    #[doc(alias = "XK_braille_dots_2348")]
    pub const braille_dots_2348: RawKeysym = 0x100288e;
    #[doc(alias = "XK_braille_dots_12348")]
    pub const braille_dots_12348: RawKeysym = 0x100288f;
    #[doc(alias = "XK_braille_dots_58")]
    pub const braille_dots_58: RawKeysym = 0x1002890;
    #[doc(alias = "XK_braille_dots_158")]
    pub const braille_dots_158: RawKeysym = 0x1002891;
    #[doc(alias = "XK_braille_dots_258")]
    pub const braille_dots_258: RawKeysym = 0x1002892;
    #[doc(alias = "XK_braille_dots_1258")]
    pub const braille_dots_1258: RawKeysym = 0x1002893;
    #[doc(alias = "XK_braille_dots_358")]
    pub const braille_dots_358: RawKeysym = 0x1002894;
    #[doc(alias = "XK_braille_dots_1358")]
    pub const braille_dots_1358: RawKeysym = 0x1002895;
    #[doc(alias = "XK_braille_dots_2358")]
    pub const braille_dots_2358: RawKeysym = 0x1002896;
    #[doc(alias = "XK_braille_dots_12358")]
    pub const braille_dots_12358: RawKeysym = 0x1002897;
    #[doc(alias = "XK_braille_dots_458")]
    pub const braille_dots_458: RawKeysym = 0x1002898;
    #[doc(alias = "XK_braille_dots_1458")]
    pub const braille_dots_1458: RawKeysym = 0x1002899;
    #[doc(alias = "XK_braille_dots_2458")]
    pub const braille_dots_2458: RawKeysym = 0x100289a;
    #[doc(alias = "XK_braille_dots_12458")]
    pub const braille_dots_12458: RawKeysym = 0x100289b;
    #[doc(alias = "XK_braille_dots_3458")]
    pub const braille_dots_3458: RawKeysym = 0x100289c;
    #[doc(alias = "XK_braille_dots_13458")]
    pub const braille_dots_13458: RawKeysym = 0x100289d;
    #[doc(alias = "XK_braille_dots_23458")]
    pub const braille_dots_23458: RawKeysym = 0x100289e;
    #[doc(alias = "XK_braille_dots_123458")]
    pub const braille_dots_123458: RawKeysym = 0x100289f;
    #[doc(alias = "XK_braille_dots_68")]
    pub const braille_dots_68: RawKeysym = 0x10028a0;
    #[doc(alias = "XK_braille_dots_168")]
    pub const braille_dots_168: RawKeysym = 0x10028a1;
    #[doc(alias = "XK_braille_dots_268")]
    pub const braille_dots_268: RawKeysym = 0x10028a2;
    #[doc(alias = "XK_braille_dots_1268")]
    pub const braille_dots_1268: RawKeysym = 0x10028a3;
    #[doc(alias = "XK_braille_dots_368")]
    pub const braille_dots_368: RawKeysym = 0x10028a4;
    #[doc(alias = "XK_braille_dots_1368")]
    pub const braille_dots_1368: RawKeysym = 0x10028a5;
    #[doc(alias = "XK_braille_dots_2368")]
    pub const braille_dots_2368: RawKeysym = 0x10028a6;
    #[doc(alias = "XK_braille_dots_12368")]
    pub const braille_dots_12368: RawKeysym = 0x10028a7;
    #[doc(alias = "XK_braille_dots_468")]
    pub const braille_dots_468: RawKeysym = 0x10028a8;
    #[doc(alias = "XK_braille_dots_1468")]
    pub const braille_dots_1468: RawKeysym = 0x10028a9;
    #[doc(alias = "XK_braille_dots_2468")]
    pub const braille_dots_2468: RawKeysym = 0x10028aa;
    #[doc(alias = "XK_braille_dots_12468")]
    pub const braille_dots_12468: RawKeysym = 0x10028ab;
    #[doc(alias = "XK_braille_dots_3468")]
    pub const braille_dots_3468: RawKeysym = 0x10028ac;
    #[doc(alias = "XK_braille_dots_13468")]
    pub const braille_dots_13468: RawKeysym = 0x10028ad;
    #[doc(alias = "XK_braille_dots_23468")]
    pub const braille_dots_23468: RawKeysym = 0x10028ae;
    #[doc(alias = "XK_braille_dots_123468")]
    pub const braille_dots_123468: RawKeysym = 0x10028af;
    #[doc(alias = "XK_braille_dots_568")]
    pub const braille_dots_568: RawKeysym = 0x10028b0;
    #[doc(alias = "XK_braille_dots_1568")]
    pub const braille_dots_1568: RawKeysym = 0x10028b1;
    #[doc(alias = "XK_braille_dots_2568")]
    pub const braille_dots_2568: RawKeysym = 0x10028b2;
    #[doc(alias = "XK_braille_dots_12568")]
    pub const braille_dots_12568: RawKeysym = 0x10028b3;
    #[doc(alias = "XK_braille_dots_3568")]
    pub const braille_dots_3568: RawKeysym = 0x10028b4;
    #[doc(alias = "XK_braille_dots_13568")]
    pub const braille_dots_13568: RawKeysym = 0x10028b5;
    #[doc(alias = "XK_braille_dots_23568")]
    pub const braille_dots_23568: RawKeysym = 0x10028b6;
    #[doc(alias = "XK_braille_dots_123568")]
    pub const braille_dots_123568: RawKeysym = 0x10028b7;
    #[doc(alias = "XK_braille_dots_4568")]
    pub const braille_dots_4568: RawKeysym = 0x10028b8;
    #[doc(alias = "XK_braille_dots_14568")]
    pub const braille_dots_14568: RawKeysym = 0x10028b9;
    #[doc(alias = "XK_braille_dots_24568")]
    pub const braille_dots_24568: RawKeysym = 0x10028ba;
    #[doc(alias = "XK_braille_dots_124568")]
    pub const braille_dots_124568: RawKeysym = 0x10028bb;
    #[doc(alias = "XK_braille_dots_34568")]
    pub const braille_dots_34568: RawKeysym = 0x10028bc;
    #[doc(alias = "XK_braille_dots_134568")]
    pub const braille_dots_134568: RawKeysym = 0x10028bd;
    #[doc(alias = "XK_braille_dots_234568")]
    pub const braille_dots_234568: RawKeysym = 0x10028be;
    #[doc(alias = "XK_braille_dots_1234568")]
    pub const braille_dots_1234568: RawKeysym = 0x10028bf;
    #[doc(alias = "XK_braille_dots_78")]
    pub const braille_dots_78: RawKeysym = 0x10028c0;
    #[doc(alias = "XK_braille_dots_178")]
    pub const braille_dots_178: RawKeysym = 0x10028c1;
    #[doc(alias = "XK_braille_dots_278")]
    pub const braille_dots_278: RawKeysym = 0x10028c2;
    #[doc(alias = "XK_braille_dots_1278")]
    pub const braille_dots_1278: RawKeysym = 0x10028c3;
    #[doc(alias = "XK_braille_dots_378")]
    pub const braille_dots_378: RawKeysym = 0x10028c4;
    #[doc(alias = "XK_braille_dots_1378")]
    pub const braille_dots_1378: RawKeysym = 0x10028c5;
    #[doc(alias = "XK_braille_dots_2378")]
    pub const braille_dots_2378: RawKeysym = 0x10028c6;
    #[doc(alias = "XK_braille_dots_12378")]
    pub const braille_dots_12378: RawKeysym = 0x10028c7;
    #[doc(alias = "XK_braille_dots_478")]
    pub const braille_dots_478: RawKeysym = 0x10028c8;
    #[doc(alias = "XK_braille_dots_1478")]
    pub const braille_dots_1478: RawKeysym = 0x10028c9;
    #[doc(alias = "XK_braille_dots_2478")]
    pub const braille_dots_2478: RawKeysym = 0x10028ca;
    #[doc(alias = "XK_braille_dots_12478")]
    pub const braille_dots_12478: RawKeysym = 0x10028cb;
    #[doc(alias = "XK_braille_dots_3478")]
    pub const braille_dots_3478: RawKeysym = 0x10028cc;
    #[doc(alias = "XK_braille_dots_13478")]
    pub const braille_dots_13478: RawKeysym = 0x10028cd;
    #[doc(alias = "XK_braille_dots_23478")]
    pub const braille_dots_23478: RawKeysym = 0x10028ce;
    #[doc(alias = "XK_braille_dots_123478")]
    pub const braille_dots_123478: RawKeysym = 0x10028cf;
    #[doc(alias = "XK_braille_dots_578")]
    pub const braille_dots_578: RawKeysym = 0x10028d0;
    #[doc(alias = "XK_braille_dots_1578")]
    pub const braille_dots_1578: RawKeysym = 0x10028d1;
    #[doc(alias = "XK_braille_dots_2578")]
    pub const braille_dots_2578: RawKeysym = 0x10028d2;
    #[doc(alias = "XK_braille_dots_12578")]
    pub const braille_dots_12578: RawKeysym = 0x10028d3;
    #[doc(alias = "XK_braille_dots_3578")]
    pub const braille_dots_3578: RawKeysym = 0x10028d4;
    #[doc(alias = "XK_braille_dots_13578")]
    pub const braille_dots_13578: RawKeysym = 0x10028d5;
    #[doc(alias = "XK_braille_dots_23578")]
    pub const braille_dots_23578: RawKeysym = 0x10028d6;
    #[doc(alias = "XK_braille_dots_123578")]
    pub const braille_dots_123578: RawKeysym = 0x10028d7;
    #[doc(alias = "XK_braille_dots_4578")]
    pub const braille_dots_4578: RawKeysym = 0x10028d8;
    #[doc(alias = "XK_braille_dots_14578")]
    pub const braille_dots_14578: RawKeysym = 0x10028d9;
    #[doc(alias = "XK_braille_dots_24578")]
    pub const braille_dots_24578: RawKeysym = 0x10028da;
    #[doc(alias = "XK_braille_dots_124578")]
    pub const braille_dots_124578: RawKeysym = 0x10028db;
    #[doc(alias = "XK_braille_dots_34578")]
    pub const braille_dots_34578: RawKeysym = 0x10028dc;
    #[doc(alias = "XK_braille_dots_134578")]
    pub const braille_dots_134578: RawKeysym = 0x10028dd;
    #[doc(alias = "XK_braille_dots_234578")]
    pub const braille_dots_234578: RawKeysym = 0x10028de;
    #[doc(alias = "XK_braille_dots_1234578")]
    pub const braille_dots_1234578: RawKeysym = 0x10028df;
    #[doc(alias = "XK_braille_dots_678")]
    pub const braille_dots_678: RawKeysym = 0x10028e0;
    #[doc(alias = "XK_braille_dots_1678")]
    pub const braille_dots_1678: RawKeysym = 0x10028e1;
    #[doc(alias = "XK_braille_dots_2678")]
    pub const braille_dots_2678: RawKeysym = 0x10028e2;
    #[doc(alias = "XK_braille_dots_12678")]
    pub const braille_dots_12678: RawKeysym = 0x10028e3;
    #[doc(alias = "XK_braille_dots_3678")]
    pub const braille_dots_3678: RawKeysym = 0x10028e4;
    #[doc(alias = "XK_braille_dots_13678")]
    pub const braille_dots_13678: RawKeysym = 0x10028e5;
    #[doc(alias = "XK_braille_dots_23678")]
    pub const braille_dots_23678: RawKeysym = 0x10028e6;
    #[doc(alias = "XK_braille_dots_123678")]
    pub const braille_dots_123678: RawKeysym = 0x10028e7;
    #[doc(alias = "XK_braille_dots_4678")]
    pub const braille_dots_4678: RawKeysym = 0x10028e8;
    #[doc(alias = "XK_braille_dots_14678")]
    pub const braille_dots_14678: RawKeysym = 0x10028e9;
    #[doc(alias = "XK_braille_dots_24678")]
    pub const braille_dots_24678: RawKeysym = 0x10028ea;
    #[doc(alias = "XK_braille_dots_124678")]
    pub const braille_dots_124678: RawKeysym = 0x10028eb;
    #[doc(alias = "XK_braille_dots_34678")]
    pub const braille_dots_34678: RawKeysym = 0x10028ec;
    #[doc(alias = "XK_braille_dots_134678")]
    pub const braille_dots_134678: RawKeysym = 0x10028ed;
    #[doc(alias = "XK_braille_dots_234678")]
    pub const braille_dots_234678: RawKeysym = 0x10028ee;
    #[doc(alias = "XK_braille_dots_1234678")]
    pub const braille_dots_1234678: RawKeysym = 0x10028ef;
    #[doc(alias = "XK_braille_dots_5678")]
    pub const braille_dots_5678: RawKeysym = 0x10028f0;
    #[doc(alias = "XK_braille_dots_15678")]
    pub const braille_dots_15678: RawKeysym = 0x10028f1;
    #[doc(alias = "XK_braille_dots_25678")]
    pub const braille_dots_25678: RawKeysym = 0x10028f2;
    #[doc(alias = "XK_braille_dots_125678")]
    pub const braille_dots_125678: RawKeysym = 0x10028f3;
    #[doc(alias = "XK_braille_dots_35678")]
    pub const braille_dots_35678: RawKeysym = 0x10028f4;
    #[doc(alias = "XK_braille_dots_135678")]
    pub const braille_dots_135678: RawKeysym = 0x10028f5;
    #[doc(alias = "XK_braille_dots_235678")]
    pub const braille_dots_235678: RawKeysym = 0x10028f6;
    #[doc(alias = "XK_braille_dots_1235678")]
    pub const braille_dots_1235678: RawKeysym = 0x10028f7;
    #[doc(alias = "XK_braille_dots_45678")]
    pub const braille_dots_45678: RawKeysym = 0x10028f8;
    #[doc(alias = "XK_braille_dots_145678")]
    pub const braille_dots_145678: RawKeysym = 0x10028f9;
    #[doc(alias = "XK_braille_dots_245678")]
    pub const braille_dots_245678: RawKeysym = 0x10028fa;
    #[doc(alias = "XK_braille_dots_1245678")]
    pub const braille_dots_1245678: RawKeysym = 0x10028fb;
    #[doc(alias = "XK_braille_dots_345678")]
    pub const braille_dots_345678: RawKeysym = 0x10028fc;
    #[doc(alias = "XK_braille_dots_1345678")]
    pub const braille_dots_1345678: RawKeysym = 0x10028fd;
    #[doc(alias = "XK_braille_dots_2345678")]
    pub const braille_dots_2345678: RawKeysym = 0x10028fe;
    #[doc(alias = "XK_braille_dots_12345678")]
    pub const braille_dots_12345678: RawKeysym = 0x10028ff;
    #[doc(alias = "XK_Sinh_ng")]
    pub const Sinh_ng: RawKeysym = 0x1000d82;
    #[doc(alias = "XK_Sinh_h2")]
    pub const Sinh_h2: RawKeysym = 0x1000d83;
    #[doc(alias = "XK_Sinh_a")]
    pub const Sinh_a: RawKeysym = 0x1000d85;
    #[doc(alias = "XK_Sinh_aa")]
    pub const Sinh_aa: RawKeysym = 0x1000d86;
    #[doc(alias = "XK_Sinh_ae")]
    pub const Sinh_ae: RawKeysym = 0x1000d87;
    #[doc(alias = "XK_Sinh_aee")]
    pub const Sinh_aee: RawKeysym = 0x1000d88;
    #[doc(alias = "XK_Sinh_i")]
    pub const Sinh_i: RawKeysym = 0x1000d89;
    #[doc(alias = "XK_Sinh_ii")]
    pub const Sinh_ii: RawKeysym = 0x1000d8a;
    #[doc(alias = "XK_Sinh_u")]
    pub const Sinh_u: RawKeysym = 0x1000d8b;
    #[doc(alias = "XK_Sinh_uu")]
    pub const Sinh_uu: RawKeysym = 0x1000d8c;
    #[doc(alias = "XK_Sinh_ri")]
    pub const Sinh_ri: RawKeysym = 0x1000d8d;
    #[doc(alias = "XK_Sinh_rii")]
    pub const Sinh_rii: RawKeysym = 0x1000d8e;
    #[doc(alias = "XK_Sinh_lu")]
    pub const Sinh_lu: RawKeysym = 0x1000d8f;
    #[doc(alias = "XK_Sinh_luu")]
    pub const Sinh_luu: RawKeysym = 0x1000d90;
    #[doc(alias = "XK_Sinh_e")]
    pub const Sinh_e: RawKeysym = 0x1000d91;
    #[doc(alias = "XK_Sinh_ee")]
    pub const Sinh_ee: RawKeysym = 0x1000d92;
    #[doc(alias = "XK_Sinh_ai")]
    pub const Sinh_ai: RawKeysym = 0x1000d93;
    #[doc(alias = "XK_Sinh_o")]
    pub const Sinh_o: RawKeysym = 0x1000d94;
    #[doc(alias = "XK_Sinh_oo")]
    pub const Sinh_oo: RawKeysym = 0x1000d95;
    #[doc(alias = "XK_Sinh_au")]
    pub const Sinh_au: RawKeysym = 0x1000d96;
    #[doc(alias = "XK_Sinh_ka")]
    pub const Sinh_ka: RawKeysym = 0x1000d9a;
    #[doc(alias = "XK_Sinh_kha")]
    pub const Sinh_kha: RawKeysym = 0x1000d9b;
    #[doc(alias = "XK_Sinh_ga")]
    pub const Sinh_ga: RawKeysym = 0x1000d9c;
    #[doc(alias = "XK_Sinh_gha")]
    pub const Sinh_gha: RawKeysym = 0x1000d9d;
    #[doc(alias = "XK_Sinh_ng2")]
    pub const Sinh_ng2: RawKeysym = 0x1000d9e;
    #[doc(alias = "XK_Sinh_nga")]
    pub const Sinh_nga: RawKeysym = 0x1000d9f;
    #[doc(alias = "XK_Sinh_ca")]
    pub const Sinh_ca: RawKeysym = 0x1000da0;
    #[doc(alias = "XK_Sinh_cha")]
    pub const Sinh_cha: RawKeysym = 0x1000da1;
    #[doc(alias = "XK_Sinh_ja")]
    pub const Sinh_ja: RawKeysym = 0x1000da2;
    #[doc(alias = "XK_Sinh_jha")]
    pub const Sinh_jha: RawKeysym = 0x1000da3;
    #[doc(alias = "XK_Sinh_nya")]
    pub const Sinh_nya: RawKeysym = 0x1000da4;
    #[doc(alias = "XK_Sinh_jnya")]
    pub const Sinh_jnya: RawKeysym = 0x1000da5;
    #[doc(alias = "XK_Sinh_nja")]
    pub const Sinh_nja: RawKeysym = 0x1000da6;
    #[doc(alias = "XK_Sinh_tta")]
    pub const Sinh_tta: RawKeysym = 0x1000da7;
    #[doc(alias = "XK_Sinh_ttha")]
    pub const Sinh_ttha: RawKeysym = 0x1000da8;
    #[doc(alias = "XK_Sinh_dda")]
    pub const Sinh_dda: RawKeysym = 0x1000da9;
    #[doc(alias = "XK_Sinh_ddha")]
    pub const Sinh_ddha: RawKeysym = 0x1000daa;
    #[doc(alias = "XK_Sinh_nna")]
    pub const Sinh_nna: RawKeysym = 0x1000dab;
    #[doc(alias = "XK_Sinh_ndda")]
    pub const Sinh_ndda: RawKeysym = 0x1000dac;
    #[doc(alias = "XK_Sinh_tha")]
    pub const Sinh_tha: RawKeysym = 0x1000dad;
    #[doc(alias = "XK_Sinh_thha")]
    pub const Sinh_thha: RawKeysym = 0x1000dae;
    #[doc(alias = "XK_Sinh_dha")]
    pub const Sinh_dha: RawKeysym = 0x1000daf;
    #[doc(alias = "XK_Sinh_dhha")]
    pub const Sinh_dhha: RawKeysym = 0x1000db0;
    #[doc(alias = "XK_Sinh_na")]
    pub const Sinh_na: RawKeysym = 0x1000db1;
    #[doc(alias = "XK_Sinh_ndha")]
    pub const Sinh_ndha: RawKeysym = 0x1000db3;
    #[doc(alias = "XK_Sinh_pa")]
    pub const Sinh_pa: RawKeysym = 0x1000db4;
    #[doc(alias = "XK_Sinh_pha")]
    pub const Sinh_pha: RawKeysym = 0x1000db5;
    #[doc(alias = "XK_Sinh_ba")]
    pub const Sinh_ba: RawKeysym = 0x1000db6;
    #[doc(alias = "XK_Sinh_bha")]
    pub const Sinh_bha: RawKeysym = 0x1000db7;
    #[doc(alias = "XK_Sinh_ma")]
    pub const Sinh_ma: RawKeysym = 0x1000db8;
    #[doc(alias = "XK_Sinh_mba")]
    pub const Sinh_mba: RawKeysym = 0x1000db9;
    #[doc(alias = "XK_Sinh_ya")]
    pub const Sinh_ya: RawKeysym = 0x1000dba;
    #[doc(alias = "XK_Sinh_ra")]
    pub const Sinh_ra: RawKeysym = 0x1000dbb;
    #[doc(alias = "XK_Sinh_la")]
    pub const Sinh_la: RawKeysym = 0x1000dbd;
    #[doc(alias = "XK_Sinh_va")]
    pub const Sinh_va: RawKeysym = 0x1000dc0;
    #[doc(alias = "XK_Sinh_sha")]
    pub const Sinh_sha: RawKeysym = 0x1000dc1;
    #[doc(alias = "XK_Sinh_ssha")]
    pub const Sinh_ssha: RawKeysym = 0x1000dc2;
    #[doc(alias = "XK_Sinh_sa")]
    pub const Sinh_sa: RawKeysym = 0x1000dc3;
    #[doc(alias = "XK_Sinh_ha")]
    pub const Sinh_ha: RawKeysym = 0x1000dc4;
    #[doc(alias = "XK_Sinh_lla")]
    pub const Sinh_lla: RawKeysym = 0x1000dc5;
    #[doc(alias = "XK_Sinh_fa")]
    pub const Sinh_fa: RawKeysym = 0x1000dc6;
    #[doc(alias = "XK_Sinh_al")]
    pub const Sinh_al: RawKeysym = 0x1000dca;
    #[doc(alias = "XK_Sinh_aa2")]
    pub const Sinh_aa2: RawKeysym = 0x1000dcf;
    #[doc(alias = "XK_Sinh_ae2")]
    pub const Sinh_ae2: RawKeysym = 0x1000dd0;
    #[doc(alias = "XK_Sinh_aee2")]
    pub const Sinh_aee2: RawKeysym = 0x1000dd1;
    #[doc(alias = "XK_Sinh_i2")]
    pub const Sinh_i2: RawKeysym = 0x1000dd2;
    #[doc(alias = "XK_Sinh_ii2")]
    pub const Sinh_ii2: RawKeysym = 0x1000dd3;
    #[doc(alias = "XK_Sinh_u2")]
    pub const Sinh_u2: RawKeysym = 0x1000dd4;
    #[doc(alias = "XK_Sinh_uu2")]
    pub const Sinh_uu2: RawKeysym = 0x1000dd6;
    #[doc(alias = "XK_Sinh_ru2")]
    pub const Sinh_ru2: RawKeysym = 0x1000dd8;
    #[doc(alias = "XK_Sinh_e2")]
    pub const Sinh_e2: RawKeysym = 0x1000dd9;
    #[doc(alias = "XK_Sinh_ee2")]
    pub const Sinh_ee2: RawKeysym = 0x1000dda;
    #[doc(alias = "XK_Sinh_ai2")]
    pub const Sinh_ai2: RawKeysym = 0x1000ddb;
    #[doc(alias = "XK_Sinh_o2")]
    pub const Sinh_o2: RawKeysym = 0x1000ddc;
    #[doc(alias = "XK_Sinh_oo2")]
    pub const Sinh_oo2: RawKeysym = 0x1000ddd;
    #[doc(alias = "XK_Sinh_au2")]
    pub const Sinh_au2: RawKeysym = 0x1000dde;
    #[doc(alias = "XK_Sinh_lu2")]
    pub const Sinh_lu2: RawKeysym = 0x1000ddf;
    #[doc(alias = "XK_Sinh_ruu2")]
    pub const Sinh_ruu2: RawKeysym = 0x1000df2;
    #[doc(alias = "XK_Sinh_luu2")]
    pub const Sinh_luu2: RawKeysym = 0x1000df3;
    #[doc(alias = "XK_Sinh_kunddaliya")]
    pub const Sinh_kunddaliya: RawKeysym = 0x1000df4;
    #[doc(alias = "XF86XK_ModeLock")]
    pub const XF86_ModeLock: RawKeysym = 0x1008ff01;
    #[doc(alias = "XF86XK_MonBrightnessUp")]
    pub const XF86_MonBrightnessUp: RawKeysym = 0x1008ff02;
    #[doc(alias = "XF86XK_MonBrightnessDown")]
    pub const XF86_MonBrightnessDown: RawKeysym = 0x1008ff03;
    #[doc(alias = "XF86XK_KbdLightOnOff")]
    pub const XF86_KbdLightOnOff: RawKeysym = 0x1008ff04;
    #[doc(alias = "XF86XK_KbdBrightnessUp")]
    pub const XF86_KbdBrightnessUp: RawKeysym = 0x1008ff05;
    #[doc(alias = "XF86XK_KbdBrightnessDown")]
    pub const XF86_KbdBrightnessDown: RawKeysym = 0x1008ff06;
    #[doc(alias = "XF86XK_MonBrightnessCycle")]
    pub const XF86_MonBrightnessCycle: RawKeysym = 0x1008ff07;
    #[doc(alias = "XF86XK_Standby")]
    pub const XF86_Standby: RawKeysym = 0x1008ff10;
    #[doc(alias = "XF86XK_AudioLowerVolume")]
    pub const XF86_AudioLowerVolume: RawKeysym = 0x1008ff11;
    #[doc(alias = "XF86XK_AudioMute")]
    pub const XF86_AudioMute: RawKeysym = 0x1008ff12;
    #[doc(alias = "XF86XK_AudioRaiseVolume")]
    pub const XF86_AudioRaiseVolume: RawKeysym = 0x1008ff13;
    #[doc(alias = "XF86XK_AudioPlay")]
    pub const XF86_AudioPlay: RawKeysym = 0x1008ff14;
    #[doc(alias = "XF86XK_AudioStop")]
    pub const XF86_AudioStop: RawKeysym = 0x1008ff15;
    #[doc(alias = "XF86XK_AudioPrev")]
    pub const XF86_AudioPrev: RawKeysym = 0x1008ff16;
    #[doc(alias = "XF86XK_AudioNext")]
    pub const XF86_AudioNext: RawKeysym = 0x1008ff17;
    #[doc(alias = "XF86XK_HomePage")]
    pub const XF86_HomePage: RawKeysym = 0x1008ff18;
    #[doc(alias = "XF86XK_Mail")]
    pub const XF86_Mail: RawKeysym = 0x1008ff19;
    #[doc(alias = "XF86XK_Start")]
    pub const XF86_Start: RawKeysym = 0x1008ff1a;
    #[doc(alias = "XF86XK_Search")]
    pub const XF86_Search: RawKeysym = 0x1008ff1b;
    #[doc(alias = "XF86XK_AudioRecord")]
    pub const XF86_AudioRecord: RawKeysym = 0x1008ff1c;
    #[doc(alias = "XF86XK_Calculator")]
    pub const XF86_Calculator: RawKeysym = 0x1008ff1d;
    #[doc(alias = "XF86XK_Memo")]
    pub const XF86_Memo: RawKeysym = 0x1008ff1e;
    #[doc(alias = "XF86XK_ToDoList")]
    pub const XF86_ToDoList: RawKeysym = 0x1008ff1f;
    #[doc(alias = "XF86XK_Calendar")]
    pub const XF86_Calendar: RawKeysym = 0x1008ff20;
    #[doc(alias = "XF86XK_PowerDown")]
    pub const XF86_PowerDown: RawKeysym = 0x1008ff21;
    #[doc(alias = "XF86XK_ContrastAdjust")]
    pub const XF86_ContrastAdjust: RawKeysym = 0x1008ff22;
    #[doc(alias = "XF86XK_RockerUp")]
    pub const XF86_RockerUp: RawKeysym = 0x1008ff23;
    #[doc(alias = "XF86XK_RockerDown")]
    pub const XF86_RockerDown: RawKeysym = 0x1008ff24;
    #[doc(alias = "XF86XK_RockerEnter")]
    pub const XF86_RockerEnter: RawKeysym = 0x1008ff25;
    #[doc(alias = "XF86XK_Back")]
    pub const XF86_Back: RawKeysym = 0x1008ff26;
    #[doc(alias = "XF86XK_Forward")]
    pub const XF86_Forward: RawKeysym = 0x1008ff27;
    #[doc(alias = "XF86XK_Stop")]
    pub const XF86_Stop: RawKeysym = 0x1008ff28;
    #[doc(alias = "XF86XK_Refresh")]
    pub const XF86_Refresh: RawKeysym = 0x1008ff29;
    #[doc(alias = "XF86XK_PowerOff")]
    pub const XF86_PowerOff: RawKeysym = 0x1008ff2a;
    #[doc(alias = "XF86XK_WakeUp")]
    pub const XF86_WakeUp: RawKeysym = 0x1008ff2b;
    #[doc(alias = "XF86XK_Eject")]
    pub const XF86_Eject: RawKeysym = 0x1008ff2c;
    #[doc(alias = "XF86XK_ScreenSaver")]
    pub const XF86_ScreenSaver: RawKeysym = 0x1008ff2d;
    #[doc(alias = "XF86XK_WWW")]
    pub const XF86_WWW: RawKeysym = 0x1008ff2e;
    #[doc(alias = "XF86XK_Sleep")]
    pub const XF86_Sleep: RawKeysym = 0x1008ff2f;
    #[doc(alias = "XF86XK_Favorites")]
    pub const XF86_Favorites: RawKeysym = 0x1008ff30;
    #[doc(alias = "XF86XK_AudioPause")]
    pub const XF86_AudioPause: RawKeysym = 0x1008ff31;
    #[doc(alias = "XF86XK_AudioMedia")]
    pub const XF86_AudioMedia: RawKeysym = 0x1008ff32;
    #[doc(alias = "XF86XK_MyComputer")]
    pub const XF86_MyComputer: RawKeysym = 0x1008ff33;
    #[doc(alias = "XF86XK_VendorHome")]
    pub const XF86_VendorHome: RawKeysym = 0x1008ff34;
    #[doc(alias = "XF86XK_LightBulb")]
    pub const XF86_LightBulb: RawKeysym = 0x1008ff35;
    #[doc(alias = "XF86XK_Shop")]
    pub const XF86_Shop: RawKeysym = 0x1008ff36;
    #[doc(alias = "XF86XK_History")]
    pub const XF86_History: RawKeysym = 0x1008ff37;
    #[doc(alias = "XF86XK_OpenURL")]
    pub const XF86_OpenURL: RawKeysym = 0x1008ff38;
    #[doc(alias = "XF86XK_AddFavorite")]
    pub const XF86_AddFavorite: RawKeysym = 0x1008ff39;
    #[doc(alias = "XF86XK_HotLinks")]
    pub const XF86_HotLinks: RawKeysym = 0x1008ff3a;
    #[doc(alias = "XF86XK_BrightnessAdjust")]
    pub const XF86_BrightnessAdjust: RawKeysym = 0x1008ff3b;
    #[doc(alias = "XF86XK_Finance")]
    pub const XF86_Finance: RawKeysym = 0x1008ff3c;
    #[doc(alias = "XF86XK_Community")]
    pub const XF86_Community: RawKeysym = 0x1008ff3d;
    #[doc(alias = "XF86XK_AudioRewind")]
    pub const XF86_AudioRewind: RawKeysym = 0x1008ff3e;
    #[doc(alias = "XF86XK_BackForward")]
    pub const XF86_BackForward: RawKeysym = 0x1008ff3f;
    #[doc(alias = "XF86XK_Launch0")]
    pub const XF86_Launch0: RawKeysym = 0x1008ff40;
    #[doc(alias = "XF86XK_Launch1")]
    pub const XF86_Launch1: RawKeysym = 0x1008ff41;
    #[doc(alias = "XF86XK_Launch2")]
    pub const XF86_Launch2: RawKeysym = 0x1008ff42;
    #[doc(alias = "XF86XK_Launch3")]
    pub const XF86_Launch3: RawKeysym = 0x1008ff43;
    #[doc(alias = "XF86XK_Launch4")]
    pub const XF86_Launch4: RawKeysym = 0x1008ff44;
    #[doc(alias = "XF86XK_Launch5")]
    pub const XF86_Launch5: RawKeysym = 0x1008ff45;
    #[doc(alias = "XF86XK_Launch6")]
    pub const XF86_Launch6: RawKeysym = 0x1008ff46;
    #[doc(alias = "XF86XK_Launch7")]
    pub const XF86_Launch7: RawKeysym = 0x1008ff47;
    #[doc(alias = "XF86XK_Launch8")]
    pub const XF86_Launch8: RawKeysym = 0x1008ff48;
    #[doc(alias = "XF86XK_Launch9")]
    pub const XF86_Launch9: RawKeysym = 0x1008ff49;
    #[doc(alias = "XF86XK_LaunchA")]
    pub const XF86_LaunchA: RawKeysym = 0x1008ff4a;
    #[doc(alias = "XF86XK_LaunchB")]
    pub const XF86_LaunchB: RawKeysym = 0x1008ff4b;
    #[doc(alias = "XF86XK_LaunchC")]
    pub const XF86_LaunchC: RawKeysym = 0x1008ff4c;
    #[doc(alias = "XF86XK_LaunchD")]
    pub const XF86_LaunchD: RawKeysym = 0x1008ff4d;
    #[doc(alias = "XF86XK_LaunchE")]
    pub const XF86_LaunchE: RawKeysym = 0x1008ff4e;
    #[doc(alias = "XF86XK_LaunchF")]
    pub const XF86_LaunchF: RawKeysym = 0x1008ff4f;
    #[doc(alias = "XF86XK_ApplicationLeft")]
    pub const XF86_ApplicationLeft: RawKeysym = 0x1008ff50;
    #[doc(alias = "XF86XK_ApplicationRight")]
    pub const XF86_ApplicationRight: RawKeysym = 0x1008ff51;
    #[doc(alias = "XF86XK_Book")]
    pub const XF86_Book: RawKeysym = 0x1008ff52;
    #[doc(alias = "XF86XK_CD")]
    pub const XF86_CD: RawKeysym = 0x1008ff53;
    #[doc(alias = "XF86XK_Calculater")]
    pub const XF86_Calculater: RawKeysym = 0x1008ff54;
    #[doc(alias = "XF86XK_Clear")]
    pub const XF86_Clear: RawKeysym = 0x1008ff55;
    #[doc(alias = "XF86XK_Close")]
    pub const XF86_Close: RawKeysym = 0x1008ff56;
    #[doc(alias = "XF86XK_Copy")]
    pub const XF86_Copy: RawKeysym = 0x1008ff57;
    #[doc(alias = "XF86XK_Cut")]
    pub const XF86_Cut: RawKeysym = 0x1008ff58;
    #[doc(alias = "XF86XK_Display")]
    pub const XF86_Display: RawKeysym = 0x1008ff59;
    #[doc(alias = "XF86XK_DOS")]
    pub const XF86_DOS: RawKeysym = 0x1008ff5a;
    #[doc(alias = "XF86XK_Documents")]
    pub const XF86_Documents: RawKeysym = 0x1008ff5b;
    #[doc(alias = "XF86XK_Excel")]
    pub const XF86_Excel: RawKeysym = 0x1008ff5c;
    #[doc(alias = "XF86XK_Explorer")]
    pub const XF86_Explorer: RawKeysym = 0x1008ff5d;
    #[doc(alias = "XF86XK_Game")]
    pub const XF86_Game: RawKeysym = 0x1008ff5e;
    #[doc(alias = "XF86XK_Go")]
    pub const XF86_Go: RawKeysym = 0x1008ff5f;
    #[doc(alias = "XF86XK_iTouch")]
    pub const XF86_iTouch: RawKeysym = 0x1008ff60;
    #[doc(alias = "XF86XK_LogOff")]
    pub const XF86_LogOff: RawKeysym = 0x1008ff61;
    #[doc(alias = "XF86XK_Market")]
    pub const XF86_Market: RawKeysym = 0x1008ff62;
    #[doc(alias = "XF86XK_Meeting")]
    pub const XF86_Meeting: RawKeysym = 0x1008ff63;
    #[doc(alias = "XF86XK_MenuKB")]
    pub const XF86_MenuKB: RawKeysym = 0x1008ff65;
    #[doc(alias = "XF86XK_MenuPB")]
    pub const XF86_MenuPB: RawKeysym = 0x1008ff66;
    #[doc(alias = "XF86XK_MySites")]
    pub const XF86_MySites: RawKeysym = 0x1008ff67;
    #[doc(alias = "XF86XK_New")]
    pub const XF86_New: RawKeysym = 0x1008ff68;
    #[doc(alias = "XF86XK_News")]
    pub const XF86_News: RawKeysym = 0x1008ff69;
    #[doc(alias = "XF86XK_OfficeHome")]
    pub const XF86_OfficeHome: RawKeysym = 0x1008ff6a;
    #[doc(alias = "XF86XK_Open")]
    pub const XF86_Open: RawKeysym = 0x1008ff6b;
    #[doc(alias = "XF86XK_Option")]
    pub const XF86_Option: RawKeysym = 0x1008ff6c;
    #[doc(alias = "XF86XK_Paste")]
    pub const XF86_Paste: RawKeysym = 0x1008ff6d;
    #[doc(alias = "XF86XK_Phone")]
    pub const XF86_Phone: RawKeysym = 0x1008ff6e;
    #[doc(alias = "XF86XK_Q")]
    pub const XF86_Q: RawKeysym = 0x1008ff70;
    #[doc(alias = "XF86XK_Reply")]
    pub const XF86_Reply: RawKeysym = 0x1008ff72;
    #[doc(alias = "XF86XK_Reload")]
    pub const XF86_Reload: RawKeysym = 0x1008ff73;
    #[doc(alias = "XF86XK_RotateWindows")]
    pub const XF86_RotateWindows: RawKeysym = 0x1008ff74;
    #[doc(alias = "XF86XK_RotationPB")]
    pub const XF86_RotationPB: RawKeysym = 0x1008ff75;
    #[doc(alias = "XF86XK_RotationKB")]
    pub const XF86_RotationKB: RawKeysym = 0x1008ff76;
    #[doc(alias = "XF86XK_Save")]
    pub const XF86_Save: RawKeysym = 0x1008ff77;
    #[doc(alias = "XF86XK_ScrollUp")]
    pub const XF86_ScrollUp: RawKeysym = 0x1008ff78;
    #[doc(alias = "XF86XK_ScrollDown")]
    pub const XF86_ScrollDown: RawKeysym = 0x1008ff79;
    #[doc(alias = "XF86XK_ScrollClick")]
    pub const XF86_ScrollClick: RawKeysym = 0x1008ff7a;
    #[doc(alias = "XF86XK_Send")]
    pub const XF86_Send: RawKeysym = 0x1008ff7b;
    #[doc(alias = "XF86XK_Spell")]
    pub const XF86_Spell: RawKeysym = 0x1008ff7c;
    #[doc(alias = "XF86XK_SplitScreen")]
    pub const XF86_SplitScreen: RawKeysym = 0x1008ff7d;
    #[doc(alias = "XF86XK_Support")]
    pub const XF86_Support: RawKeysym = 0x1008ff7e;
    #[doc(alias = "XF86XK_TaskPane")]
    pub const XF86_TaskPane: RawKeysym = 0x1008ff7f;
    #[doc(alias = "XF86XK_Terminal")]
    pub const XF86_Terminal: RawKeysym = 0x1008ff80;
    #[doc(alias = "XF86XK_Tools")]
    pub const XF86_Tools: RawKeysym = 0x1008ff81;
    #[doc(alias = "XF86XK_Travel")]
    pub const XF86_Travel: RawKeysym = 0x1008ff82;
    #[doc(alias = "XF86XK_UserPB")]
    pub const XF86_UserPB: RawKeysym = 0x1008ff84;
    #[doc(alias = "XF86XK_User1KB")]
    pub const XF86_User1KB: RawKeysym = 0x1008ff85;
    #[doc(alias = "XF86XK_User2KB")]
    pub const XF86_User2KB: RawKeysym = 0x1008ff86;
    #[doc(alias = "XF86XK_Video")]
    pub const XF86_Video: RawKeysym = 0x1008ff87;
    #[doc(alias = "XF86XK_WheelButton")]
    pub const XF86_WheelButton: RawKeysym = 0x1008ff88;
    #[doc(alias = "XF86XK_Word")]
    pub const XF86_Word: RawKeysym = 0x1008ff89;
    #[doc(alias = "XF86XK_Xfer")]
    pub const XF86_Xfer: RawKeysym = 0x1008ff8a;
    #[doc(alias = "XF86XK_ZoomIn")]
    pub const XF86_ZoomIn: RawKeysym = 0x1008ff8b;
    #[doc(alias = "XF86XK_ZoomOut")]
    pub const XF86_ZoomOut: RawKeysym = 0x1008ff8c;
    #[doc(alias = "XF86XK_Away")]
    pub const XF86_Away: RawKeysym = 0x1008ff8d;
    #[doc(alias = "XF86XK_Messenger")]
    pub const XF86_Messenger: RawKeysym = 0x1008ff8e;
    #[doc(alias = "XF86XK_WebCam")]
    pub const XF86_WebCam: RawKeysym = 0x1008ff8f;
    #[doc(alias = "XF86XK_MailForward")]
    pub const XF86_MailForward: RawKeysym = 0x1008ff90;
    #[doc(alias = "XF86XK_Pictures")]
    pub const XF86_Pictures: RawKeysym = 0x1008ff91;
    #[doc(alias = "XF86XK_Music")]
    pub const XF86_Music: RawKeysym = 0x1008ff92;
    #[doc(alias = "XF86XK_Battery")]
    pub const XF86_Battery: RawKeysym = 0x1008ff93;
    #[doc(alias = "XF86XK_Bluetooth")]
    pub const XF86_Bluetooth: RawKeysym = 0x1008ff94;
    #[doc(alias = "XF86XK_WLAN")]
    pub const XF86_WLAN: RawKeysym = 0x1008ff95;
    #[doc(alias = "XF86XK_UWB")]
    pub const XF86_UWB: RawKeysym = 0x1008ff96;
    #[doc(alias = "XF86XK_AudioForward")]
    pub const XF86_AudioForward: RawKeysym = 0x1008ff97;
    #[doc(alias = "XF86XK_AudioRepeat")]
    pub const XF86_AudioRepeat: RawKeysym = 0x1008ff98;
    #[doc(alias = "XF86XK_AudioRandomPlay")]
    pub const XF86_AudioRandomPlay: RawKeysym = 0x1008ff99;
    #[doc(alias = "XF86XK_Subtitle")]
    pub const XF86_Subtitle: RawKeysym = 0x1008ff9a;
    #[doc(alias = "XF86XK_AudioCycleTrack")]
    pub const XF86_AudioCycleTrack: RawKeysym = 0x1008ff9b;
    #[doc(alias = "XF86XK_CycleAngle")]
    pub const XF86_CycleAngle: RawKeysym = 0x1008ff9c;
    #[doc(alias = "XF86XK_FrameBack")]
    pub const XF86_FrameBack: RawKeysym = 0x1008ff9d;
    #[doc(alias = "XF86XK_FrameForward")]
    pub const XF86_FrameForward: RawKeysym = 0x1008ff9e;
    #[doc(alias = "XF86XK_Time")]
    pub const XF86_Time: RawKeysym = 0x1008ff9f;
    #[doc(alias = "XF86XK_Select")]
    pub const XF86_Select: RawKeysym = 0x1008ffa0;
    #[doc(alias = "XF86XK_View")]
    pub const XF86_View: RawKeysym = 0x1008ffa1;
    #[doc(alias = "XF86XK_TopMenu")]
    pub const XF86_TopMenu: RawKeysym = 0x1008ffa2;
    #[doc(alias = "XF86XK_Red")]
    pub const XF86_Red: RawKeysym = 0x1008ffa3;
    #[doc(alias = "XF86XK_Green")]
    pub const XF86_Green: RawKeysym = 0x1008ffa4;
    #[doc(alias = "XF86XK_Yellow")]
    pub const XF86_Yellow: RawKeysym = 0x1008ffa5;
    #[doc(alias = "XF86XK_Blue")]
    pub const XF86_Blue: RawKeysym = 0x1008ffa6;
    #[doc(alias = "XF86XK_Suspend")]
    pub const XF86_Suspend: RawKeysym = 0x1008ffa7;
    #[doc(alias = "XF86XK_Hibernate")]
    pub const XF86_Hibernate: RawKeysym = 0x1008ffa8;
    #[doc(alias = "XF86XK_TouchpadToggle")]
    pub const XF86_TouchpadToggle: RawKeysym = 0x1008ffa9;
    #[doc(alias = "XF86XK_TouchpadOn")]
    pub const XF86_TouchpadOn: RawKeysym = 0x1008ffb0;
    #[doc(alias = "XF86XK_TouchpadOff")]
    pub const XF86_TouchpadOff: RawKeysym = 0x1008ffb1;
    #[doc(alias = "XF86XK_AudioMicMute")]
    pub const XF86_AudioMicMute: RawKeysym = 0x1008ffb2;
    #[doc(alias = "XF86XK_Keyboard")]
    pub const XF86_Keyboard: RawKeysym = 0x1008ffb3;
    #[doc(alias = "XF86XK_WWAN")]
    pub const XF86_WWAN: RawKeysym = 0x1008ffb4;
    #[doc(alias = "XF86XK_RFKill")]
    pub const XF86_RFKill: RawKeysym = 0x1008ffb5;
    #[doc(alias = "XF86XK_AudioPreset")]
    pub const XF86_AudioPreset: RawKeysym = 0x1008ffb6;
    #[doc(alias = "XF86XK_RotationLockToggle")]
    pub const XF86_RotationLockToggle: RawKeysym = 0x1008ffb7;
    #[doc(alias = "XF86XK_FullScreen")]
    pub const XF86_FullScreen: RawKeysym = 0x1008ffb8;
    #[doc(alias = "XF86XK_Switch_VT_1")]
    pub const XF86_Switch_VT_1: RawKeysym = 0x1008fe01;
    #[doc(alias = "XF86XK_Switch_VT_2")]
    pub const XF86_Switch_VT_2: RawKeysym = 0x1008fe02;
    #[doc(alias = "XF86XK_Switch_VT_3")]
    pub const XF86_Switch_VT_3: RawKeysym = 0x1008fe03;
    #[doc(alias = "XF86XK_Switch_VT_4")]
    pub const XF86_Switch_VT_4: RawKeysym = 0x1008fe04;
    #[doc(alias = "XF86XK_Switch_VT_5")]
    pub const XF86_Switch_VT_5: RawKeysym = 0x1008fe05;
    #[doc(alias = "XF86XK_Switch_VT_6")]
    pub const XF86_Switch_VT_6: RawKeysym = 0x1008fe06;
    #[doc(alias = "XF86XK_Switch_VT_7")]
    pub const XF86_Switch_VT_7: RawKeysym = 0x1008fe07;
    #[doc(alias = "XF86XK_Switch_VT_8")]
    pub const XF86_Switch_VT_8: RawKeysym = 0x1008fe08;
    #[doc(alias = "XF86XK_Switch_VT_9")]
    pub const XF86_Switch_VT_9: RawKeysym = 0x1008fe09;
    #[doc(alias = "XF86XK_Switch_VT_10")]
    pub const XF86_Switch_VT_10: RawKeysym = 0x1008fe0a;
    #[doc(alias = "XF86XK_Switch_VT_11")]
    pub const XF86_Switch_VT_11: RawKeysym = 0x1008fe0b;
    #[doc(alias = "XF86XK_Switch_VT_12")]
    pub const XF86_Switch_VT_12: RawKeysym = 0x1008fe0c;
    #[doc(alias = "XF86XK_Ungrab")]
    pub const XF86_Ungrab: RawKeysym = 0x1008fe20;
    #[doc(alias = "XF86XK_ClearGrab")]
    pub const XF86_ClearGrab: RawKeysym = 0x1008fe21;
    #[doc(alias = "XF86XK_Next_VMode")]
    pub const XF86_Next_VMode: RawKeysym = 0x1008fe22;
    #[doc(alias = "XF86XK_Prev_VMode")]
    pub const XF86_Prev_VMode: RawKeysym = 0x1008fe23;
    #[doc(alias = "XF86XK_LogWindowTree")]
    pub const XF86_LogWindowTree: RawKeysym = 0x1008fe24;
    #[doc(alias = "XF86XK_LogGrabInfo")]
    pub const XF86_LogGrabInfo: RawKeysym = 0x1008fe25;
    #[doc(alias = "XF86XK_BrightnessAuto")]
    pub const XF86_BrightnessAuto: RawKeysym = 0x100810f4;
    #[doc(alias = "XF86XK_DisplayOff")]
    pub const XF86_DisplayOff: RawKeysym = 0x100810f5;
    #[doc(alias = "XF86XK_Info")]
    pub const XF86_Info: RawKeysym = 0x10081166;
    #[doc(alias = "XF86XK_AspectRatio")]
    pub const XF86_AspectRatio: RawKeysym = 0x10081177;
    #[doc(alias = "XF86XK_DVD")]
    pub const XF86_DVD: RawKeysym = 0x10081185;
    #[doc(alias = "XF86XK_Audio")]
    pub const XF86_Audio: RawKeysym = 0x10081188;
    #[doc(alias = "XF86XK_ChannelUp")]
    pub const XF86_ChannelUp: RawKeysym = 0x10081192;
    #[doc(alias = "XF86XK_ChannelDown")]
    pub const XF86_ChannelDown: RawKeysym = 0x10081193;
    #[doc(alias = "XF86XK_Break")]
    pub const XF86_Break: RawKeysym = 0x1008119b;
    #[doc(alias = "XF86XK_VideoPhone")]
    pub const XF86_VideoPhone: RawKeysym = 0x100811a0;
    #[doc(alias = "XF86XK_ZoomReset")]
    pub const XF86_ZoomReset: RawKeysym = 0x100811a4;
    #[doc(alias = "XF86XK_Editor")]
    pub const XF86_Editor: RawKeysym = 0x100811a6;
    #[doc(alias = "XF86XK_GraphicsEditor")]
    pub const XF86_GraphicsEditor: RawKeysym = 0x100811a8;
    #[doc(alias = "XF86XK_Presentation")]
    pub const XF86_Presentation: RawKeysym = 0x100811a9;
    #[doc(alias = "XF86XK_Database")]
    pub const XF86_Database: RawKeysym = 0x100811aa;
    #[doc(alias = "XF86XK_Voicemail")]
    pub const XF86_Voicemail: RawKeysym = 0x100811ac;
    #[doc(alias = "XF86XK_Addressbook")]
    pub const XF86_Addressbook: RawKeysym = 0x100811ad;
    #[doc(alias = "XF86XK_DisplayToggle")]
    pub const XF86_DisplayToggle: RawKeysym = 0x100811af;
    #[doc(alias = "XF86XK_SpellCheck")]
    pub const XF86_SpellCheck: RawKeysym = 0x100811b0;
    #[doc(alias = "XF86XK_ContextMenu")]
    pub const XF86_ContextMenu: RawKeysym = 0x100811b6;
    #[doc(alias = "XF86XK_MediaRepeat")]
    pub const XF86_MediaRepeat: RawKeysym = 0x100811b7;
    #[doc(alias = "XF86XK_10ChannelsUp")]
    pub const XF86_10ChannelsUp: RawKeysym = 0x100811b8;
    #[doc(alias = "XF86XK_10ChannelsDown")]
    pub const XF86_10ChannelsDown: RawKeysym = 0x100811b9;
    #[doc(alias = "XF86XK_Images")]
    pub const XF86_Images: RawKeysym = 0x100811ba;
    #[doc(alias = "XF86XK_NotificationCenter")]
    pub const XF86_NotificationCenter: RawKeysym = 0x100811bc;
    #[doc(alias = "XF86XK_PickupPhone")]
    pub const XF86_PickupPhone: RawKeysym = 0x100811bd;
    #[doc(alias = "XF86XK_HangupPhone")]
    pub const XF86_HangupPhone: RawKeysym = 0x100811be;
    #[doc(alias = "XF86XK_Fn")]
    pub const XF86_Fn: RawKeysym = 0x100811d0;
    #[doc(alias = "XF86XK_Fn_Esc")]
    pub const XF86_Fn_Esc: RawKeysym = 0x100811d1;
    #[doc(alias = "XF86XK_FnRightShift")]
    pub const XF86_FnRightShift: RawKeysym = 0x100811e5;
    #[doc(alias = "XF86XK_Numeric0")]
    pub const XF86_Numeric0: RawKeysym = 0x10081200;
    #[doc(alias = "XF86XK_Numeric1")]
    pub const XF86_Numeric1: RawKeysym = 0x10081201;
    #[doc(alias = "XF86XK_Numeric2")]
    pub const XF86_Numeric2: RawKeysym = 0x10081202;
    #[doc(alias = "XF86XK_Numeric3")]
    pub const XF86_Numeric3: RawKeysym = 0x10081203;
    #[doc(alias = "XF86XK_Numeric4")]
    pub const XF86_Numeric4: RawKeysym = 0x10081204;
    #[doc(alias = "XF86XK_Numeric5")]
    pub const XF86_Numeric5: RawKeysym = 0x10081205;
    #[doc(alias = "XF86XK_Numeric6")]
    pub const XF86_Numeric6: RawKeysym = 0x10081206;
    #[doc(alias = "XF86XK_Numeric7")]
    pub const XF86_Numeric7: RawKeysym = 0x10081207;
    #[doc(alias = "XF86XK_Numeric8")]
    pub const XF86_Numeric8: RawKeysym = 0x10081208;
    #[doc(alias = "XF86XK_Numeric9")]
    pub const XF86_Numeric9: RawKeysym = 0x10081209;
    #[doc(alias = "XF86XK_NumericStar")]
    pub const XF86_NumericStar: RawKeysym = 0x1008120a;
    #[doc(alias = "XF86XK_NumericPound")]
    pub const XF86_NumericPound: RawKeysym = 0x1008120b;
    #[doc(alias = "XF86XK_NumericA")]
    pub const XF86_NumericA: RawKeysym = 0x1008120c;
    #[doc(alias = "XF86XK_NumericB")]
    pub const XF86_NumericB: RawKeysym = 0x1008120d;
    #[doc(alias = "XF86XK_NumericC")]
    pub const XF86_NumericC: RawKeysym = 0x1008120e;
    #[doc(alias = "XF86XK_NumericD")]
    pub const XF86_NumericD: RawKeysym = 0x1008120f;
    #[doc(alias = "XF86XK_CameraFocus")]
    pub const XF86_CameraFocus: RawKeysym = 0x10081210;
    #[doc(alias = "XF86XK_WPSButton")]
    pub const XF86_WPSButton: RawKeysym = 0x10081211;
    #[doc(alias = "XF86XK_CameraZoomIn")]
    pub const XF86_CameraZoomIn: RawKeysym = 0x10081215;
    #[doc(alias = "XF86XK_CameraZoomOut")]
    pub const XF86_CameraZoomOut: RawKeysym = 0x10081216;
    #[doc(alias = "XF86XK_CameraUp")]
    pub const XF86_CameraUp: RawKeysym = 0x10081217;
    #[doc(alias = "XF86XK_CameraDown")]
    pub const XF86_CameraDown: RawKeysym = 0x10081218;
    #[doc(alias = "XF86XK_CameraLeft")]
    pub const XF86_CameraLeft: RawKeysym = 0x10081219;
    #[doc(alias = "XF86XK_CameraRight")]
    pub const XF86_CameraRight: RawKeysym = 0x1008121a;
    #[doc(alias = "XF86XK_AttendantOn")]
    pub const XF86_AttendantOn: RawKeysym = 0x1008121b;
    #[doc(alias = "XF86XK_AttendantOff")]
    pub const XF86_AttendantOff: RawKeysym = 0x1008121c;
    #[doc(alias = "XF86XK_AttendantToggle")]
    pub const XF86_AttendantToggle: RawKeysym = 0x1008121d;
    #[doc(alias = "XF86XK_LightsToggle")]
    pub const XF86_LightsToggle: RawKeysym = 0x1008121e;
    #[doc(alias = "XF86XK_ALSToggle")]
    pub const XF86_ALSToggle: RawKeysym = 0x10081230;
    #[doc(alias = "XF86XK_Buttonconfig")]
    pub const XF86_Buttonconfig: RawKeysym = 0x10081240;
    #[doc(alias = "XF86XK_Taskmanager")]
    pub const XF86_Taskmanager: RawKeysym = 0x10081241;
    #[doc(alias = "XF86XK_Journal")]
    pub const XF86_Journal: RawKeysym = 0x10081242;
    #[doc(alias = "XF86XK_ControlPanel")]
    pub const XF86_ControlPanel: RawKeysym = 0x10081243;
    #[doc(alias = "XF86XK_AppSelect")]
    pub const XF86_AppSelect: RawKeysym = 0x10081244;
    #[doc(alias = "XF86XK_Screensaver")]
    pub const XF86_Screensaver: RawKeysym = 0x10081245;
    #[doc(alias = "XF86XK_VoiceCommand")]
    pub const XF86_VoiceCommand: RawKeysym = 0x10081246;
    #[doc(alias = "XF86XK_Assistant")]
    pub const XF86_Assistant: RawKeysym = 0x10081247;
    #[doc(alias = "XF86XK_BrightnessMin")]
    pub const XF86_BrightnessMin: RawKeysym = 0x10081250;
    #[doc(alias = "XF86XK_BrightnessMax")]
    pub const XF86_BrightnessMax: RawKeysym = 0x10081251;
    #[doc(alias = "XF86XK_KbdInputAssistPrev")]
    pub const XF86_KbdInputAssistPrev: RawKeysym = 0x10081260;
    #[doc(alias = "XF86XK_KbdInputAssistNext")]
    pub const XF86_KbdInputAssistNext: RawKeysym = 0x10081261;
    #[doc(alias = "XF86XK_KbdInputAssistPrevgroup")]
    pub const XF86_KbdInputAssistPrevgroup: RawKeysym = 0x10081262;
    #[doc(alias = "XF86XK_KbdInputAssistNextgroup")]
    pub const XF86_KbdInputAssistNextgroup: RawKeysym = 0x10081263;
    #[doc(alias = "XF86XK_KbdInputAssistAccept")]
    pub const XF86_KbdInputAssistAccept: RawKeysym = 0x10081264;
    #[doc(alias = "XF86XK_KbdInputAssistCancel")]
    pub const XF86_KbdInputAssistCancel: RawKeysym = 0x10081265;
    #[doc(alias = "XF86XK_RightUp")]
    pub const XF86_RightUp: RawKeysym = 0x10081266;
    #[doc(alias = "XF86XK_RightDown")]
    pub const XF86_RightDown: RawKeysym = 0x10081267;
    #[doc(alias = "XF86XK_LeftUp")]
    pub const XF86_LeftUp: RawKeysym = 0x10081268;
    #[doc(alias = "XF86XK_LeftDown")]
    pub const XF86_LeftDown: RawKeysym = 0x10081269;
    #[doc(alias = "XF86XK_RootMenu")]
    pub const XF86_RootMenu: RawKeysym = 0x1008126a;
    #[doc(alias = "XF86XK_MediaTopMenu")]
    pub const XF86_MediaTopMenu: RawKeysym = 0x1008126b;
    #[doc(alias = "XF86XK_Numeric11")]
    pub const XF86_Numeric11: RawKeysym = 0x1008126c;
    #[doc(alias = "XF86XK_Numeric12")]
    pub const XF86_Numeric12: RawKeysym = 0x1008126d;
    #[doc(alias = "XF86XK_AudioDesc")]
    pub const XF86_AudioDesc: RawKeysym = 0x1008126e;
    #[doc(alias = "XF86XK_3DMode")]
    pub const XF86_3DMode: RawKeysym = 0x1008126f;
    #[doc(alias = "XF86XK_NextFavorite")]
    pub const XF86_NextFavorite: RawKeysym = 0x10081270;
    #[doc(alias = "XF86XK_StopRecord")]
    pub const XF86_StopRecord: RawKeysym = 0x10081271;
    #[doc(alias = "XF86XK_PauseRecord")]
    pub const XF86_PauseRecord: RawKeysym = 0x10081272;
    #[doc(alias = "XF86XK_VOD")]
    pub const XF86_VOD: RawKeysym = 0x10081273;
    #[doc(alias = "XF86XK_Unmute")]
    pub const XF86_Unmute: RawKeysym = 0x10081274;
    #[doc(alias = "XF86XK_FastReverse")]
    pub const XF86_FastReverse: RawKeysym = 0x10081275;
    #[doc(alias = "XF86XK_SlowReverse")]
    pub const XF86_SlowReverse: RawKeysym = 0x10081276;
    #[doc(alias = "XF86XK_Data")]
    pub const XF86_Data: RawKeysym = 0x10081277;
    #[doc(alias = "XF86XK_OnScreenKeyboard")]
    pub const XF86_OnScreenKeyboard: RawKeysym = 0x10081278;
    #[doc(alias = "XF86XK_PrivacyScreenToggle")]
    pub const XF86_PrivacyScreenToggle: RawKeysym = 0x10081279;
    #[doc(alias = "XF86XK_SelectiveScreenshot")]
    pub const XF86_SelectiveScreenshot: RawKeysym = 0x1008127a;
    #[doc(alias = "XF86XK_Macro1")]
    pub const XF86_Macro1: RawKeysym = 0x10081290;
    #[doc(alias = "XF86XK_Macro2")]
    pub const XF86_Macro2: RawKeysym = 0x10081291;
    #[doc(alias = "XF86XK_Macro3")]
    pub const XF86_Macro3: RawKeysym = 0x10081292;
    #[doc(alias = "XF86XK_Macro4")]
    pub const XF86_Macro4: RawKeysym = 0x10081293;
    #[doc(alias = "XF86XK_Macro5")]
    pub const XF86_Macro5: RawKeysym = 0x10081294;
    #[doc(alias = "XF86XK_Macro6")]
    pub const XF86_Macro6: RawKeysym = 0x10081295;
    #[doc(alias = "XF86XK_Macro7")]
    pub const XF86_Macro7: RawKeysym = 0x10081296;
    #[doc(alias = "XF86XK_Macro8")]
    pub const XF86_Macro8: RawKeysym = 0x10081297;
    #[doc(alias = "XF86XK_Macro9")]
    pub const XF86_Macro9: RawKeysym = 0x10081298;
    #[doc(alias = "XF86XK_Macro10")]
    pub const XF86_Macro10: RawKeysym = 0x10081299;
    #[doc(alias = "XF86XK_Macro11")]
    pub const XF86_Macro11: RawKeysym = 0x1008129a;
    #[doc(alias = "XF86XK_Macro12")]
    pub const XF86_Macro12: RawKeysym = 0x1008129b;
    #[doc(alias = "XF86XK_Macro13")]
    pub const XF86_Macro13: RawKeysym = 0x1008129c;
    #[doc(alias = "XF86XK_Macro14")]
    pub const XF86_Macro14: RawKeysym = 0x1008129d;
    #[doc(alias = "XF86XK_Macro15")]
    pub const XF86_Macro15: RawKeysym = 0x1008129e;
    #[doc(alias = "XF86XK_Macro16")]
    pub const XF86_Macro16: RawKeysym = 0x1008129f;
    #[doc(alias = "XF86XK_Macro17")]
    pub const XF86_Macro17: RawKeysym = 0x100812a0;
    #[doc(alias = "XF86XK_Macro18")]
    pub const XF86_Macro18: RawKeysym = 0x100812a1;
    #[doc(alias = "XF86XK_Macro19")]
    pub const XF86_Macro19: RawKeysym = 0x100812a2;
    #[doc(alias = "XF86XK_Macro20")]
    pub const XF86_Macro20: RawKeysym = 0x100812a3;
    #[doc(alias = "XF86XK_Macro21")]
    pub const XF86_Macro21: RawKeysym = 0x100812a4;
    #[doc(alias = "XF86XK_Macro22")]
    pub const XF86_Macro22: RawKeysym = 0x100812a5;
    #[doc(alias = "XF86XK_Macro23")]
    pub const XF86_Macro23: RawKeysym = 0x100812a6;
    #[doc(alias = "XF86XK_Macro24")]
    pub const XF86_Macro24: RawKeysym = 0x100812a7;
    #[doc(alias = "XF86XK_Macro25")]
    pub const XF86_Macro25: RawKeysym = 0x100812a8;
    #[doc(alias = "XF86XK_Macro26")]
    pub const XF86_Macro26: RawKeysym = 0x100812a9;
    #[doc(alias = "XF86XK_Macro27")]
    pub const XF86_Macro27: RawKeysym = 0x100812aa;
    #[doc(alias = "XF86XK_Macro28")]
    pub const XF86_Macro28: RawKeysym = 0x100812ab;
    #[doc(alias = "XF86XK_Macro29")]
    pub const XF86_Macro29: RawKeysym = 0x100812ac;
    #[doc(alias = "XF86XK_Macro30")]
    pub const XF86_Macro30: RawKeysym = 0x100812ad;
    #[doc(alias = "XF86XK_MacroRecordStart")]
    pub const XF86_MacroRecordStart: RawKeysym = 0x100812b0;
    #[doc(alias = "XF86XK_MacroRecordStop")]
    pub const XF86_MacroRecordStop: RawKeysym = 0x100812b1;
    #[doc(alias = "XF86XK_MacroPresetCycle")]
    pub const XF86_MacroPresetCycle: RawKeysym = 0x100812b2;
    #[doc(alias = "XF86XK_MacroPreset1")]
    pub const XF86_MacroPreset1: RawKeysym = 0x100812b3;
    #[doc(alias = "XF86XK_MacroPreset2")]
    pub const XF86_MacroPreset2: RawKeysym = 0x100812b4;
    #[doc(alias = "XF86XK_MacroPreset3")]
    pub const XF86_MacroPreset3: RawKeysym = 0x100812b5;
    #[doc(alias = "XF86XK_KbdLcdMenu1")]
    pub const XF86_KbdLcdMenu1: RawKeysym = 0x100812b8;
    #[doc(alias = "XF86XK_KbdLcdMenu2")]
    pub const XF86_KbdLcdMenu2: RawKeysym = 0x100812b9;
    #[doc(alias = "XF86XK_KbdLcdMenu3")]
    pub const XF86_KbdLcdMenu3: RawKeysym = 0x100812ba;
    #[doc(alias = "XF86XK_KbdLcdMenu4")]
    pub const XF86_KbdLcdMenu4: RawKeysym = 0x100812bb;
    #[doc(alias = "XF86XK_KbdLcdMenu5")]
    pub const XF86_KbdLcdMenu5: RawKeysym = 0x100812bc;
    #[doc(alias = "SunXK_FA_Grave")]
    pub const SUN_FA_Grave: RawKeysym = 0x1005ff00;
    #[doc(alias = "SunXK_FA_Circum")]
    pub const SUN_FA_Circum: RawKeysym = 0x1005ff01;
    #[doc(alias = "SunXK_FA_Tilde")]
    pub const SUN_FA_Tilde: RawKeysym = 0x1005ff02;
    #[doc(alias = "SunXK_FA_Acute")]
    pub const SUN_FA_Acute: RawKeysym = 0x1005ff03;
    #[doc(alias = "SunXK_FA_Diaeresis")]
    pub const SUN_FA_Diaeresis: RawKeysym = 0x1005ff04;
    #[doc(alias = "SunXK_FA_Cedilla")]
    pub const SUN_FA_Cedilla: RawKeysym = 0x1005ff05;
    #[doc(alias = "SunXK_F36")]
    pub const SUN_F36: RawKeysym = 0x1005ff10;
    #[doc(alias = "SunXK_F37")]
    pub const SUN_F37: RawKeysym = 0x1005ff11;
    #[doc(alias = "SunXK_Sys_Req")]
    pub const SUN_Sys_Req: RawKeysym = 0x1005ff60;
    #[doc(alias = "SunXK_Print_Screen")]
    pub const SUN_Print_Screen: RawKeysym = 0xff61;
    #[doc(alias = "SunXK_Compose")]
    pub const SUN_Compose: RawKeysym = 0xff20;
    #[doc(alias = "SunXK_AltGraph")]
    pub const SUN_AltGraph: RawKeysym = 0xff7e;
    #[doc(alias = "SunXK_PageUp")]
    pub const SUN_PageUp: RawKeysym = 0xff55;
    #[doc(alias = "SunXK_PageDown")]
    pub const SUN_PageDown: RawKeysym = 0xff56;
    #[doc(alias = "SunXK_Undo")]
    pub const SUN_Undo: RawKeysym = 0xff65;
    #[doc(alias = "SunXK_Again")]
    pub const SUN_Again: RawKeysym = 0xff66;
    #[doc(alias = "SunXK_Find")]
    pub const SUN_Find: RawKeysym = 0xff68;
    #[doc(alias = "SunXK_Stop")]
    pub const SUN_Stop: RawKeysym = 0xff69;
    #[doc(alias = "SunXK_Props")]
    pub const SUN_Props: RawKeysym = 0x1005ff70;
    #[doc(alias = "SunXK_Front")]
    pub const SUN_Front: RawKeysym = 0x1005ff71;
    #[doc(alias = "SunXK_Copy")]
    pub const SUN_Copy: RawKeysym = 0x1005ff72;
    #[doc(alias = "SunXK_Open")]
    pub const SUN_Open: RawKeysym = 0x1005ff73;
    #[doc(alias = "SunXK_Paste")]
    pub const SUN_Paste: RawKeysym = 0x1005ff74;
    #[doc(alias = "SunXK_Cut")]
    pub const SUN_Cut: RawKeysym = 0x1005ff75;
    #[doc(alias = "SunXK_PowerSwitch")]
    pub const SUN_PowerSwitch: RawKeysym = 0x1005ff76;
    #[doc(alias = "SunXK_AudioLowerVolume")]
    pub const SUN_AudioLowerVolume: RawKeysym = 0x1005ff77;
    #[doc(alias = "SunXK_AudioMute")]
    pub const SUN_AudioMute: RawKeysym = 0x1005ff78;
    #[doc(alias = "SunXK_AudioRaiseVolume")]
    pub const SUN_AudioRaiseVolume: RawKeysym = 0x1005ff79;
    #[doc(alias = "SunXK_VideoDegauss")]
    pub const SUN_VideoDegauss: RawKeysym = 0x1005ff7a;
    #[doc(alias = "SunXK_VideoLowerBrightness")]
    pub const SUN_VideoLowerBrightness: RawKeysym = 0x1005ff7b;
    #[doc(alias = "SunXK_VideoRaiseBrightness")]
    pub const SUN_VideoRaiseBrightness: RawKeysym = 0x1005ff7c;
    #[doc(alias = "SunXK_PowerSwitchShift")]
    pub const SUN_PowerSwitchShift: RawKeysym = 0x1005ff7d;
    #[doc(alias = "DXK_ring_accent")]
    pub const D_ring_accent: RawKeysym = 0x1000feb0;
    #[doc(alias = "DXK_circumflex_accent")]
    pub const D_circumflex_accent: RawKeysym = 0x1000fe5e;
    #[doc(alias = "DXK_cedilla_accent")]
    pub const D_cedilla_accent: RawKeysym = 0x1000fe2c;
    #[doc(alias = "DXK_acute_accent")]
    pub const D_acute_accent: RawKeysym = 0x1000fe27;
    #[doc(alias = "DXK_grave_accent")]
    pub const D_grave_accent: RawKeysym = 0x1000fe60;
    #[doc(alias = "DXK_tilde")]
    pub const D_tilde: RawKeysym = 0x1000fe7e;
    #[doc(alias = "DXK_diaeresis")]
    pub const D_diaeresis: RawKeysym = 0x1000fe22;
    #[doc(alias = "DXK_Remove")]
    pub const D_Remove: RawKeysym = 0x1000ff00;
    #[doc(alias = "hpXK_ClearLine")]
    pub const HP_ClearLine: RawKeysym = 0x1000ff6f;
    #[doc(alias = "hpXK_InsertLine")]
    pub const HP_InsertLine: RawKeysym = 0x1000ff70;
    #[doc(alias = "hpXK_DeleteLine")]
    pub const HP_DeleteLine: RawKeysym = 0x1000ff71;
    #[doc(alias = "hpXK_InsertChar")]
    pub const HP_InsertChar: RawKeysym = 0x1000ff72;
    #[doc(alias = "hpXK_DeleteChar")]
    pub const HP_DeleteChar: RawKeysym = 0x1000ff73;
    #[doc(alias = "hpXK_BackTab")]
    pub const HP_BackTab: RawKeysym = 0x1000ff74;
    #[doc(alias = "hpXK_KP_BackTab")]
    pub const HP_KP_BackTab: RawKeysym = 0x1000ff75;
    #[doc(alias = "hpXK_Modelock1")]
    pub const HP_Modelock1: RawKeysym = 0x1000ff48;
    #[doc(alias = "hpXK_Modelock2")]
    pub const HP_Modelock2: RawKeysym = 0x1000ff49;
    #[doc(alias = "hpXK_Reset")]
    pub const HP_Reset: RawKeysym = 0x1000ff6c;
    #[doc(alias = "hpXK_System")]
    pub const HP_System: RawKeysym = 0x1000ff6d;
    #[doc(alias = "hpXK_User")]
    pub const HP_User: RawKeysym = 0x1000ff6e;
    #[doc(alias = "hpXK_mute_acute")]
    pub const HP_mute_acute: RawKeysym = 0x100000a8;
    #[doc(alias = "hpXK_mute_grave")]
    pub const HP_mute_grave: RawKeysym = 0x100000a9;
    #[doc(alias = "hpXK_mute_asciicircum")]
    pub const HP_mute_asciicircum: RawKeysym = 0x100000aa;
    #[doc(alias = "hpXK_mute_diaeresis")]
    pub const HP_mute_diaeresis: RawKeysym = 0x100000ab;
    #[doc(alias = "hpXK_mute_asciitilde")]
    pub const HP_mute_asciitilde: RawKeysym = 0x100000ac;
    #[doc(alias = "hpXK_lira")]
    pub const HP_lira: RawKeysym = 0x100000af;
    #[doc(alias = "hpXK_guilder")]
    pub const HP_guilder: RawKeysym = 0x100000be;
    #[doc(alias = "hpXK_IO")]
    pub const HP_IO: RawKeysym = 0x100000ee;
    #[doc(alias = "hpXK_longminus")]
    pub const HP_longminus: RawKeysym = 0x100000f6;
    #[doc(alias = "hpXK_block")]
    pub const HP_block: RawKeysym = 0x100000fc;
    #[doc(alias = "osfXK_Copy")]
    pub const OSF_Copy: RawKeysym = 0x1004ff02;
    #[doc(alias = "osfXK_Cut")]
    pub const OSF_Cut: RawKeysym = 0x1004ff03;
    #[doc(alias = "osfXK_Paste")]
    pub const OSF_Paste: RawKeysym = 0x1004ff04;
    #[doc(alias = "osfXK_BackTab")]
    pub const OSF_BackTab: RawKeysym = 0x1004ff07;
    #[doc(alias = "osfXK_BackSpace")]
    pub const OSF_BackSpace: RawKeysym = 0x1004ff08;
    #[doc(alias = "osfXK_Clear")]
    pub const OSF_Clear: RawKeysym = 0x1004ff0b;
    #[doc(alias = "osfXK_Escape")]
    pub const OSF_Escape: RawKeysym = 0x1004ff1b;
    #[doc(alias = "osfXK_AddMode")]
    pub const OSF_AddMode: RawKeysym = 0x1004ff31;
    #[doc(alias = "osfXK_PrimaryPaste")]
    pub const OSF_PrimaryPaste: RawKeysym = 0x1004ff32;
    #[doc(alias = "osfXK_QuickPaste")]
    pub const OSF_QuickPaste: RawKeysym = 0x1004ff33;
    #[doc(alias = "osfXK_PageLeft")]
    pub const OSF_PageLeft: RawKeysym = 0x1004ff40;
    #[doc(alias = "osfXK_PageUp")]
    pub const OSF_PageUp: RawKeysym = 0x1004ff41;
    #[doc(alias = "osfXK_PageDown")]
    pub const OSF_PageDown: RawKeysym = 0x1004ff42;
    #[doc(alias = "osfXK_PageRight")]
    pub const OSF_PageRight: RawKeysym = 0x1004ff43;
    #[doc(alias = "osfXK_Activate")]
    pub const OSF_Activate: RawKeysym = 0x1004ff44;
    #[doc(alias = "osfXK_MenuBar")]
    pub const OSF_MenuBar: RawKeysym = 0x1004ff45;
    #[doc(alias = "osfXK_Left")]
    pub const OSF_Left: RawKeysym = 0x1004ff51;
    #[doc(alias = "osfXK_Up")]
    pub const OSF_Up: RawKeysym = 0x1004ff52;
    #[doc(alias = "osfXK_Right")]
    pub const OSF_Right: RawKeysym = 0x1004ff53;
    #[doc(alias = "osfXK_Down")]
    pub const OSF_Down: RawKeysym = 0x1004ff54;
    #[doc(alias = "osfXK_EndLine")]
    pub const OSF_EndLine: RawKeysym = 0x1004ff57;
    #[doc(alias = "osfXK_BeginLine")]
    pub const OSF_BeginLine: RawKeysym = 0x1004ff58;
    #[doc(alias = "osfXK_EndData")]
    pub const OSF_EndData: RawKeysym = 0x1004ff59;
    #[doc(alias = "osfXK_BeginData")]
    pub const OSF_BeginData: RawKeysym = 0x1004ff5a;
    #[doc(alias = "osfXK_PrevMenu")]
    pub const OSF_PrevMenu: RawKeysym = 0x1004ff5b;
    #[doc(alias = "osfXK_NextMenu")]
    pub const OSF_NextMenu: RawKeysym = 0x1004ff5c;
    #[doc(alias = "osfXK_PrevField")]
    pub const OSF_PrevField: RawKeysym = 0x1004ff5d;
    #[doc(alias = "osfXK_NextField")]
    pub const OSF_NextField: RawKeysym = 0x1004ff5e;
    #[doc(alias = "osfXK_Select")]
    pub const OSF_Select: RawKeysym = 0x1004ff60;
    #[doc(alias = "osfXK_Insert")]
    pub const OSF_Insert: RawKeysym = 0x1004ff63;
    #[doc(alias = "osfXK_Undo")]
    pub const OSF_Undo: RawKeysym = 0x1004ff65;
    #[doc(alias = "osfXK_Menu")]
    pub const OSF_Menu: RawKeysym = 0x1004ff67;
    #[doc(alias = "osfXK_Cancel")]
    pub const OSF_Cancel: RawKeysym = 0x1004ff69;
    #[doc(alias = "osfXK_Help")]
    pub const OSF_Help: RawKeysym = 0x1004ff6a;
    #[doc(alias = "osfXK_SelectAll")]
    pub const OSF_SelectAll: RawKeysym = 0x1004ff71;
    #[doc(alias = "osfXK_DeselectAll")]
    pub const OSF_DeselectAll: RawKeysym = 0x1004ff72;
    #[doc(alias = "osfXK_Reselect")]
    pub const OSF_Reselect: RawKeysym = 0x1004ff73;
    #[doc(alias = "osfXK_Extend")]
    pub const OSF_Extend: RawKeysym = 0x1004ff74;
    #[doc(alias = "osfXK_Restore")]
    pub const OSF_Restore: RawKeysym = 0x1004ff78;
    #[doc(alias = "osfXK_Delete")]
    pub const OSF_Delete: RawKeysym = 0x1004ffff;
    #[doc(alias = "XK_Reset")]
    pub const Reset: RawKeysym = 0x1000ff6c;
    #[doc(alias = "XK_System")]
    pub const System: RawKeysym = 0x1000ff6d;
    #[doc(alias = "XK_User")]
    pub const User: RawKeysym = 0x1000ff6e;
    #[doc(alias = "XK_ClearLine")]
    pub const ClearLine: RawKeysym = 0x1000ff6f;
    #[doc(alias = "XK_InsertLine")]
    pub const InsertLine: RawKeysym = 0x1000ff70;
    #[doc(alias = "XK_DeleteLine")]
    pub const DeleteLine: RawKeysym = 0x1000ff71;
    #[doc(alias = "XK_InsertChar")]
    pub const InsertChar: RawKeysym = 0x1000ff72;
    #[doc(alias = "XK_DeleteChar")]
    pub const DeleteChar: RawKeysym = 0x1000ff73;
    #[doc(alias = "XK_BackTab")]
    pub const BackTab: RawKeysym = 0x1000ff74;
    #[doc(alias = "XK_KP_BackTab")]
    pub const KP_BackTab: RawKeysym = 0x1000ff75;
    #[doc(alias = "XK_Ext16bit_L")]
    pub const Ext16bit_L: RawKeysym = 0x1000ff76;
    #[doc(alias = "XK_Ext16bit_R")]
    pub const Ext16bit_R: RawKeysym = 0x1000ff77;
    #[doc(alias = "XK_mute_acute")]
    pub const mute_acute: RawKeysym = 0x100000a8;
    #[doc(alias = "XK_mute_grave")]
    pub const mute_grave: RawKeysym = 0x100000a9;
    #[doc(alias = "XK_mute_asciicircum")]
    pub const mute_asciicircum: RawKeysym = 0x100000aa;
    #[doc(alias = "XK_mute_diaeresis")]
    pub const mute_diaeresis: RawKeysym = 0x100000ab;
    #[doc(alias = "XK_mute_asciitilde")]
    pub const mute_asciitilde: RawKeysym = 0x100000ac;
    #[doc(alias = "XK_lira")]
    pub const lira: RawKeysym = 0x100000af;
    #[doc(alias = "XK_guilder")]
    pub const guilder: RawKeysym = 0x100000be;
    #[doc(alias = "XK_IO")]
    pub const IO: RawKeysym = 0x100000ee;
    #[doc(alias = "XK_longminus")]
    pub const longminus: RawKeysym = 0x100000f6;
    #[doc(alias = "XK_block")]
    pub const block: RawKeysym = 0x100000fc;
}
impl Keysym {
    #[doc(alias = "XK_VoidSymbol")]
    pub const VoidSymbol: Keysym = Keysym(key::VoidSymbol);
    #[doc(alias = "XK_BackSpace")]
    pub const BackSpace: Keysym = Keysym(key::BackSpace);
    #[doc(alias = "XK_Tab")]
    pub const Tab: Keysym = Keysym(key::Tab);
    #[doc(alias = "XK_Linefeed")]
    pub const Linefeed: Keysym = Keysym(key::Linefeed);
    #[doc(alias = "XK_Clear")]
    pub const Clear: Keysym = Keysym(key::Clear);
    #[doc(alias = "XK_Return")]
    pub const Return: Keysym = Keysym(key::Return);
    #[doc(alias = "XK_Pause")]
    pub const Pause: Keysym = Keysym(key::Pause);
    #[doc(alias = "XK_Scroll_Lock")]
    pub const Scroll_Lock: Keysym = Keysym(key::Scroll_Lock);
    #[doc(alias = "XK_Sys_Req")]
    pub const Sys_Req: Keysym = Keysym(key::Sys_Req);
    #[doc(alias = "XK_Escape")]
    pub const Escape: Keysym = Keysym(key::Escape);
    #[doc(alias = "XK_Delete")]
    pub const Delete: Keysym = Keysym(key::Delete);
    #[doc(alias = "XK_Multi_key")]
    pub const Multi_key: Keysym = Keysym(key::Multi_key);
    #[doc(alias = "XK_Codeinput")]
    pub const Codeinput: Keysym = Keysym(key::Codeinput);
    #[doc(alias = "XK_SingleCandidate")]
    pub const SingleCandidate: Keysym = Keysym(key::SingleCandidate);
    #[doc(alias = "XK_MultipleCandidate")]
    pub const MultipleCandidate: Keysym = Keysym(key::MultipleCandidate);
    #[doc(alias = "XK_PreviousCandidate")]
    pub const PreviousCandidate: Keysym = Keysym(key::PreviousCandidate);
    #[doc(alias = "XK_Kanji")]
    pub const Kanji: Keysym = Keysym(key::Kanji);
    #[doc(alias = "XK_Muhenkan")]
    pub const Muhenkan: Keysym = Keysym(key::Muhenkan);
    #[doc(alias = "XK_Henkan_Mode")]
    pub const Henkan_Mode: Keysym = Keysym(key::Henkan_Mode);
    #[doc(alias = "XK_Henkan")]
    pub const Henkan: Keysym = Keysym(key::Henkan);
    #[doc(alias = "XK_Romaji")]
    pub const Romaji: Keysym = Keysym(key::Romaji);
    #[doc(alias = "XK_Hiragana")]
    pub const Hiragana: Keysym = Keysym(key::Hiragana);
    #[doc(alias = "XK_Katakana")]
    pub const Katakana: Keysym = Keysym(key::Katakana);
    #[doc(alias = "XK_Hiragana_Katakana")]
    pub const Hiragana_Katakana: Keysym = Keysym(key::Hiragana_Katakana);
    #[doc(alias = "XK_Zenkaku")]
    pub const Zenkaku: Keysym = Keysym(key::Zenkaku);
    #[doc(alias = "XK_Hankaku")]
    pub const Hankaku: Keysym = Keysym(key::Hankaku);
    #[doc(alias = "XK_Zenkaku_Hankaku")]
    pub const Zenkaku_Hankaku: Keysym = Keysym(key::Zenkaku_Hankaku);
    #[doc(alias = "XK_Touroku")]
    pub const Touroku: Keysym = Keysym(key::Touroku);
    #[doc(alias = "XK_Massyo")]
    pub const Massyo: Keysym = Keysym(key::Massyo);
    #[doc(alias = "XK_Kana_Lock")]
    pub const Kana_Lock: Keysym = Keysym(key::Kana_Lock);
    #[doc(alias = "XK_Kana_Shift")]
    pub const Kana_Shift: Keysym = Keysym(key::Kana_Shift);
    #[doc(alias = "XK_Eisu_Shift")]
    pub const Eisu_Shift: Keysym = Keysym(key::Eisu_Shift);
    #[doc(alias = "XK_Eisu_toggle")]
    pub const Eisu_toggle: Keysym = Keysym(key::Eisu_toggle);
    #[doc(alias = "XK_Kanji_Bangou")]
    pub const Kanji_Bangou: Keysym = Keysym(key::Kanji_Bangou);
    #[doc(alias = "XK_Zen_Koho")]
    pub const Zen_Koho: Keysym = Keysym(key::Zen_Koho);
    #[doc(alias = "XK_Mae_Koho")]
    pub const Mae_Koho: Keysym = Keysym(key::Mae_Koho);
    #[doc(alias = "XK_Home")]
    pub const Home: Keysym = Keysym(key::Home);
    #[doc(alias = "XK_Left")]
    pub const Left: Keysym = Keysym(key::Left);
    #[doc(alias = "XK_Up")]
    pub const Up: Keysym = Keysym(key::Up);
    #[doc(alias = "XK_Right")]
    pub const Right: Keysym = Keysym(key::Right);
    #[doc(alias = "XK_Down")]
    pub const Down: Keysym = Keysym(key::Down);
    #[doc(alias = "XK_Prior")]
    pub const Prior: Keysym = Keysym(key::Prior);
    #[doc(alias = "XK_Page_Up")]
    pub const Page_Up: Keysym = Keysym(key::Page_Up);
    #[doc(alias = "XK_Next")]
    pub const Next: Keysym = Keysym(key::Next);
    #[doc(alias = "XK_Page_Down")]
    pub const Page_Down: Keysym = Keysym(key::Page_Down);
    #[doc(alias = "XK_End")]
    pub const End: Keysym = Keysym(key::End);
    #[doc(alias = "XK_Begin")]
    pub const Begin: Keysym = Keysym(key::Begin);
    #[doc(alias = "XK_Select")]
    pub const Select: Keysym = Keysym(key::Select);
    #[doc(alias = "XK_Print")]
    pub const Print: Keysym = Keysym(key::Print);
    #[doc(alias = "XK_Execute")]
    pub const Execute: Keysym = Keysym(key::Execute);
    #[doc(alias = "XK_Insert")]
    pub const Insert: Keysym = Keysym(key::Insert);
    #[doc(alias = "XK_Undo")]
    pub const Undo: Keysym = Keysym(key::Undo);
    #[doc(alias = "XK_Redo")]
    pub const Redo: Keysym = Keysym(key::Redo);
    #[doc(alias = "XK_Menu")]
    pub const Menu: Keysym = Keysym(key::Menu);
    #[doc(alias = "XK_Find")]
    pub const Find: Keysym = Keysym(key::Find);
    #[doc(alias = "XK_Cancel")]
    pub const Cancel: Keysym = Keysym(key::Cancel);
    #[doc(alias = "XK_Help")]
    pub const Help: Keysym = Keysym(key::Help);
    #[doc(alias = "XK_Break")]
    pub const Break: Keysym = Keysym(key::Break);
    #[doc(alias = "XK_Mode_switch")]
    pub const Mode_switch: Keysym = Keysym(key::Mode_switch);
    #[doc(alias = "XK_script_switch")]
    pub const script_switch: Keysym = Keysym(key::script_switch);
    #[doc(alias = "XK_Num_Lock")]
    pub const Num_Lock: Keysym = Keysym(key::Num_Lock);
    #[doc(alias = "XK_KP_Space")]
    pub const KP_Space: Keysym = Keysym(key::KP_Space);
    #[doc(alias = "XK_KP_Tab")]
    pub const KP_Tab: Keysym = Keysym(key::KP_Tab);
    #[doc(alias = "XK_KP_Enter")]
    pub const KP_Enter: Keysym = Keysym(key::KP_Enter);
    #[doc(alias = "XK_KP_F1")]
    pub const KP_F1: Keysym = Keysym(key::KP_F1);
    #[doc(alias = "XK_KP_F2")]
    pub const KP_F2: Keysym = Keysym(key::KP_F2);
    #[doc(alias = "XK_KP_F3")]
    pub const KP_F3: Keysym = Keysym(key::KP_F3);
    #[doc(alias = "XK_KP_F4")]
    pub const KP_F4: Keysym = Keysym(key::KP_F4);
    #[doc(alias = "XK_KP_Home")]
    pub const KP_Home: Keysym = Keysym(key::KP_Home);
    #[doc(alias = "XK_KP_Left")]
    pub const KP_Left: Keysym = Keysym(key::KP_Left);
    #[doc(alias = "XK_KP_Up")]
    pub const KP_Up: Keysym = Keysym(key::KP_Up);
    #[doc(alias = "XK_KP_Right")]
    pub const KP_Right: Keysym = Keysym(key::KP_Right);
    #[doc(alias = "XK_KP_Down")]
    pub const KP_Down: Keysym = Keysym(key::KP_Down);
    #[doc(alias = "XK_KP_Prior")]
    pub const KP_Prior: Keysym = Keysym(key::KP_Prior);
    #[doc(alias = "XK_KP_Page_Up")]
    pub const KP_Page_Up: Keysym = Keysym(key::KP_Page_Up);
    #[doc(alias = "XK_KP_Next")]
    pub const KP_Next: Keysym = Keysym(key::KP_Next);
    #[doc(alias = "XK_KP_Page_Down")]
    pub const KP_Page_Down: Keysym = Keysym(key::KP_Page_Down);
    #[doc(alias = "XK_KP_End")]
    pub const KP_End: Keysym = Keysym(key::KP_End);
    #[doc(alias = "XK_KP_Begin")]
    pub const KP_Begin: Keysym = Keysym(key::KP_Begin);
    #[doc(alias = "XK_KP_Insert")]
    pub const KP_Insert: Keysym = Keysym(key::KP_Insert);
    #[doc(alias = "XK_KP_Delete")]
    pub const KP_Delete: Keysym = Keysym(key::KP_Delete);
    #[doc(alias = "XK_KP_Equal")]
    pub const KP_Equal: Keysym = Keysym(key::KP_Equal);
    #[doc(alias = "XK_KP_Multiply")]
    pub const KP_Multiply: Keysym = Keysym(key::KP_Multiply);
    #[doc(alias = "XK_KP_Add")]
    pub const KP_Add: Keysym = Keysym(key::KP_Add);
    #[doc(alias = "XK_KP_Separator")]
    pub const KP_Separator: Keysym = Keysym(key::KP_Separator);
    #[doc(alias = "XK_KP_Subtract")]
    pub const KP_Subtract: Keysym = Keysym(key::KP_Subtract);
    #[doc(alias = "XK_KP_Decimal")]
    pub const KP_Decimal: Keysym = Keysym(key::KP_Decimal);
    #[doc(alias = "XK_KP_Divide")]
    pub const KP_Divide: Keysym = Keysym(key::KP_Divide);
    #[doc(alias = "XK_KP_0")]
    pub const KP_0: Keysym = Keysym(key::KP_0);
    #[doc(alias = "XK_KP_1")]
    pub const KP_1: Keysym = Keysym(key::KP_1);
    #[doc(alias = "XK_KP_2")]
    pub const KP_2: Keysym = Keysym(key::KP_2);
    #[doc(alias = "XK_KP_3")]
    pub const KP_3: Keysym = Keysym(key::KP_3);
    #[doc(alias = "XK_KP_4")]
    pub const KP_4: Keysym = Keysym(key::KP_4);
    #[doc(alias = "XK_KP_5")]
    pub const KP_5: Keysym = Keysym(key::KP_5);
    #[doc(alias = "XK_KP_6")]
    pub const KP_6: Keysym = Keysym(key::KP_6);
    #[doc(alias = "XK_KP_7")]
    pub const KP_7: Keysym = Keysym(key::KP_7);
    #[doc(alias = "XK_KP_8")]
    pub const KP_8: Keysym = Keysym(key::KP_8);
    #[doc(alias = "XK_KP_9")]
    pub const KP_9: Keysym = Keysym(key::KP_9);
    #[doc(alias = "XK_F1")]
    pub const F1: Keysym = Keysym(key::F1);
    #[doc(alias = "XK_F2")]
    pub const F2: Keysym = Keysym(key::F2);
    #[doc(alias = "XK_F3")]
    pub const F3: Keysym = Keysym(key::F3);
    #[doc(alias = "XK_F4")]
    pub const F4: Keysym = Keysym(key::F4);
    #[doc(alias = "XK_F5")]
    pub const F5: Keysym = Keysym(key::F5);
    #[doc(alias = "XK_F6")]
    pub const F6: Keysym = Keysym(key::F6);
    #[doc(alias = "XK_F7")]
    pub const F7: Keysym = Keysym(key::F7);
    #[doc(alias = "XK_F8")]
    pub const F8: Keysym = Keysym(key::F8);
    #[doc(alias = "XK_F9")]
    pub const F9: Keysym = Keysym(key::F9);
    #[doc(alias = "XK_F10")]
    pub const F10: Keysym = Keysym(key::F10);
    #[doc(alias = "XK_F11")]
    pub const F11: Keysym = Keysym(key::F11);
    #[doc(alias = "XK_L1")]
    pub const L1: Keysym = Keysym(key::L1);
    #[doc(alias = "XK_F12")]
    pub const F12: Keysym = Keysym(key::F12);
    #[doc(alias = "XK_L2")]
    pub const L2: Keysym = Keysym(key::L2);
    #[doc(alias = "XK_F13")]
    pub const F13: Keysym = Keysym(key::F13);
    #[doc(alias = "XK_L3")]
    pub const L3: Keysym = Keysym(key::L3);
    #[doc(alias = "XK_F14")]
    pub const F14: Keysym = Keysym(key::F14);
    #[doc(alias = "XK_L4")]
    pub const L4: Keysym = Keysym(key::L4);
    #[doc(alias = "XK_F15")]
    pub const F15: Keysym = Keysym(key::F15);
    #[doc(alias = "XK_L5")]
    pub const L5: Keysym = Keysym(key::L5);
    #[doc(alias = "XK_F16")]
    pub const F16: Keysym = Keysym(key::F16);
    #[doc(alias = "XK_L6")]
    pub const L6: Keysym = Keysym(key::L6);
    #[doc(alias = "XK_F17")]
    pub const F17: Keysym = Keysym(key::F17);
    #[doc(alias = "XK_L7")]
    pub const L7: Keysym = Keysym(key::L7);
    #[doc(alias = "XK_F18")]
    pub const F18: Keysym = Keysym(key::F18);
    #[doc(alias = "XK_L8")]
    pub const L8: Keysym = Keysym(key::L8);
    #[doc(alias = "XK_F19")]
    pub const F19: Keysym = Keysym(key::F19);
    #[doc(alias = "XK_L9")]
    pub const L9: Keysym = Keysym(key::L9);
    #[doc(alias = "XK_F20")]
    pub const F20: Keysym = Keysym(key::F20);
    #[doc(alias = "XK_L10")]
    pub const L10: Keysym = Keysym(key::L10);
    #[doc(alias = "XK_F21")]
    pub const F21: Keysym = Keysym(key::F21);
    #[doc(alias = "XK_R1")]
    pub const R1: Keysym = Keysym(key::R1);
    #[doc(alias = "XK_F22")]
    pub const F22: Keysym = Keysym(key::F22);
    #[doc(alias = "XK_R2")]
    pub const R2: Keysym = Keysym(key::R2);
    #[doc(alias = "XK_F23")]
    pub const F23: Keysym = Keysym(key::F23);
    #[doc(alias = "XK_R3")]
    pub const R3: Keysym = Keysym(key::R3);
    #[doc(alias = "XK_F24")]
    pub const F24: Keysym = Keysym(key::F24);
    #[doc(alias = "XK_R4")]
    pub const R4: Keysym = Keysym(key::R4);
    #[doc(alias = "XK_F25")]
    pub const F25: Keysym = Keysym(key::F25);
    #[doc(alias = "XK_R5")]
    pub const R5: Keysym = Keysym(key::R5);
    #[doc(alias = "XK_F26")]
    pub const F26: Keysym = Keysym(key::F26);
    #[doc(alias = "XK_R6")]
    pub const R6: Keysym = Keysym(key::R6);
    #[doc(alias = "XK_F27")]
    pub const F27: Keysym = Keysym(key::F27);
    #[doc(alias = "XK_R7")]
    pub const R7: Keysym = Keysym(key::R7);
    #[doc(alias = "XK_F28")]
    pub const F28: Keysym = Keysym(key::F28);
    #[doc(alias = "XK_R8")]
    pub const R8: Keysym = Keysym(key::R8);
    #[doc(alias = "XK_F29")]
    pub const F29: Keysym = Keysym(key::F29);
    #[doc(alias = "XK_R9")]
    pub const R9: Keysym = Keysym(key::R9);
    #[doc(alias = "XK_F30")]
    pub const F30: Keysym = Keysym(key::F30);
    #[doc(alias = "XK_R10")]
    pub const R10: Keysym = Keysym(key::R10);
    #[doc(alias = "XK_F31")]
    pub const F31: Keysym = Keysym(key::F31);
    #[doc(alias = "XK_R11")]
    pub const R11: Keysym = Keysym(key::R11);
    #[doc(alias = "XK_F32")]
    pub const F32: Keysym = Keysym(key::F32);
    #[doc(alias = "XK_R12")]
    pub const R12: Keysym = Keysym(key::R12);
    #[doc(alias = "XK_F33")]
    pub const F33: Keysym = Keysym(key::F33);
    #[doc(alias = "XK_R13")]
    pub const R13: Keysym = Keysym(key::R13);
    #[doc(alias = "XK_F34")]
    pub const F34: Keysym = Keysym(key::F34);
    #[doc(alias = "XK_R14")]
    pub const R14: Keysym = Keysym(key::R14);
    #[doc(alias = "XK_F35")]
    pub const F35: Keysym = Keysym(key::F35);
    #[doc(alias = "XK_R15")]
    pub const R15: Keysym = Keysym(key::R15);
    #[doc(alias = "XK_Shift_L")]
    pub const Shift_L: Keysym = Keysym(key::Shift_L);
    #[doc(alias = "XK_Shift_R")]
    pub const Shift_R: Keysym = Keysym(key::Shift_R);
    #[doc(alias = "XK_Control_L")]
    pub const Control_L: Keysym = Keysym(key::Control_L);
    #[doc(alias = "XK_Control_R")]
    pub const Control_R: Keysym = Keysym(key::Control_R);
    #[doc(alias = "XK_Caps_Lock")]
    pub const Caps_Lock: Keysym = Keysym(key::Caps_Lock);
    #[doc(alias = "XK_Shift_Lock")]
    pub const Shift_Lock: Keysym = Keysym(key::Shift_Lock);
    #[doc(alias = "XK_Meta_L")]
    pub const Meta_L: Keysym = Keysym(key::Meta_L);
    #[doc(alias = "XK_Meta_R")]
    pub const Meta_R: Keysym = Keysym(key::Meta_R);
    #[doc(alias = "XK_Alt_L")]
    pub const Alt_L: Keysym = Keysym(key::Alt_L);
    #[doc(alias = "XK_Alt_R")]
    pub const Alt_R: Keysym = Keysym(key::Alt_R);
    #[doc(alias = "XK_Super_L")]
    pub const Super_L: Keysym = Keysym(key::Super_L);
    #[doc(alias = "XK_Super_R")]
    pub const Super_R: Keysym = Keysym(key::Super_R);
    #[doc(alias = "XK_Hyper_L")]
    pub const Hyper_L: Keysym = Keysym(key::Hyper_L);
    #[doc(alias = "XK_Hyper_R")]
    pub const Hyper_R: Keysym = Keysym(key::Hyper_R);
    #[doc(alias = "XK_ISO_Lock")]
    pub const ISO_Lock: Keysym = Keysym(key::ISO_Lock);
    #[doc(alias = "XK_ISO_Level2_Latch")]
    pub const ISO_Level2_Latch: Keysym = Keysym(key::ISO_Level2_Latch);
    #[doc(alias = "XK_ISO_Level3_Shift")]
    pub const ISO_Level3_Shift: Keysym = Keysym(key::ISO_Level3_Shift);
    #[doc(alias = "XK_ISO_Level3_Latch")]
    pub const ISO_Level3_Latch: Keysym = Keysym(key::ISO_Level3_Latch);
    #[doc(alias = "XK_ISO_Level3_Lock")]
    pub const ISO_Level3_Lock: Keysym = Keysym(key::ISO_Level3_Lock);
    #[doc(alias = "XK_ISO_Level5_Shift")]
    pub const ISO_Level5_Shift: Keysym = Keysym(key::ISO_Level5_Shift);
    #[doc(alias = "XK_ISO_Level5_Latch")]
    pub const ISO_Level5_Latch: Keysym = Keysym(key::ISO_Level5_Latch);
    #[doc(alias = "XK_ISO_Level5_Lock")]
    pub const ISO_Level5_Lock: Keysym = Keysym(key::ISO_Level5_Lock);
    #[doc(alias = "XK_ISO_Group_Shift")]
    pub const ISO_Group_Shift: Keysym = Keysym(key::ISO_Group_Shift);
    #[doc(alias = "XK_ISO_Group_Latch")]
    pub const ISO_Group_Latch: Keysym = Keysym(key::ISO_Group_Latch);
    #[doc(alias = "XK_ISO_Group_Lock")]
    pub const ISO_Group_Lock: Keysym = Keysym(key::ISO_Group_Lock);
    #[doc(alias = "XK_ISO_Next_Group")]
    pub const ISO_Next_Group: Keysym = Keysym(key::ISO_Next_Group);
    #[doc(alias = "XK_ISO_Next_Group_Lock")]
    pub const ISO_Next_Group_Lock: Keysym = Keysym(key::ISO_Next_Group_Lock);
    #[doc(alias = "XK_ISO_Prev_Group")]
    pub const ISO_Prev_Group: Keysym = Keysym(key::ISO_Prev_Group);
    #[doc(alias = "XK_ISO_Prev_Group_Lock")]
    pub const ISO_Prev_Group_Lock: Keysym = Keysym(key::ISO_Prev_Group_Lock);
    #[doc(alias = "XK_ISO_First_Group")]
    pub const ISO_First_Group: Keysym = Keysym(key::ISO_First_Group);
    #[doc(alias = "XK_ISO_First_Group_Lock")]
    pub const ISO_First_Group_Lock: Keysym = Keysym(key::ISO_First_Group_Lock);
    #[doc(alias = "XK_ISO_Last_Group")]
    pub const ISO_Last_Group: Keysym = Keysym(key::ISO_Last_Group);
    #[doc(alias = "XK_ISO_Last_Group_Lock")]
    pub const ISO_Last_Group_Lock: Keysym = Keysym(key::ISO_Last_Group_Lock);
    #[doc(alias = "XK_ISO_Left_Tab")]
    pub const ISO_Left_Tab: Keysym = Keysym(key::ISO_Left_Tab);
    #[doc(alias = "XK_ISO_Move_Line_Up")]
    pub const ISO_Move_Line_Up: Keysym = Keysym(key::ISO_Move_Line_Up);
    #[doc(alias = "XK_ISO_Move_Line_Down")]
    pub const ISO_Move_Line_Down: Keysym = Keysym(key::ISO_Move_Line_Down);
    #[doc(alias = "XK_ISO_Partial_Line_Up")]
    pub const ISO_Partial_Line_Up: Keysym = Keysym(key::ISO_Partial_Line_Up);
    #[doc(alias = "XK_ISO_Partial_Line_Down")]
    pub const ISO_Partial_Line_Down: Keysym = Keysym(key::ISO_Partial_Line_Down);
    #[doc(alias = "XK_ISO_Partial_Space_Left")]
    pub const ISO_Partial_Space_Left: Keysym = Keysym(key::ISO_Partial_Space_Left);
    #[doc(alias = "XK_ISO_Partial_Space_Right")]
    pub const ISO_Partial_Space_Right: Keysym = Keysym(key::ISO_Partial_Space_Right);
    #[doc(alias = "XK_ISO_Set_Margin_Left")]
    pub const ISO_Set_Margin_Left: Keysym = Keysym(key::ISO_Set_Margin_Left);
    #[doc(alias = "XK_ISO_Set_Margin_Right")]
    pub const ISO_Set_Margin_Right: Keysym = Keysym(key::ISO_Set_Margin_Right);
    #[doc(alias = "XK_ISO_Release_Margin_Left")]
    pub const ISO_Release_Margin_Left: Keysym = Keysym(key::ISO_Release_Margin_Left);
    #[doc(alias = "XK_ISO_Release_Margin_Right")]
    pub const ISO_Release_Margin_Right: Keysym = Keysym(key::ISO_Release_Margin_Right);
    #[doc(alias = "XK_ISO_Release_Both_Margins")]
    pub const ISO_Release_Both_Margins: Keysym = Keysym(key::ISO_Release_Both_Margins);
    #[doc(alias = "XK_ISO_Fast_Cursor_Left")]
    pub const ISO_Fast_Cursor_Left: Keysym = Keysym(key::ISO_Fast_Cursor_Left);
    #[doc(alias = "XK_ISO_Fast_Cursor_Right")]
    pub const ISO_Fast_Cursor_Right: Keysym = Keysym(key::ISO_Fast_Cursor_Right);
    #[doc(alias = "XK_ISO_Fast_Cursor_Up")]
    pub const ISO_Fast_Cursor_Up: Keysym = Keysym(key::ISO_Fast_Cursor_Up);
    #[doc(alias = "XK_ISO_Fast_Cursor_Down")]
    pub const ISO_Fast_Cursor_Down: Keysym = Keysym(key::ISO_Fast_Cursor_Down);
    #[doc(alias = "XK_ISO_Continuous_Underline")]
    pub const ISO_Continuous_Underline: Keysym = Keysym(key::ISO_Continuous_Underline);
    #[doc(alias = "XK_ISO_Discontinuous_Underline")]
    pub const ISO_Discontinuous_Underline: Keysym = Keysym(key::ISO_Discontinuous_Underline);
    #[doc(alias = "XK_ISO_Emphasize")]
    pub const ISO_Emphasize: Keysym = Keysym(key::ISO_Emphasize);
    #[doc(alias = "XK_ISO_Center_Object")]
    pub const ISO_Center_Object: Keysym = Keysym(key::ISO_Center_Object);
    #[doc(alias = "XK_ISO_Enter")]
    pub const ISO_Enter: Keysym = Keysym(key::ISO_Enter);
    #[doc(alias = "XK_dead_grave")]
    pub const dead_grave: Keysym = Keysym(key::dead_grave);
    #[doc(alias = "XK_dead_acute")]
    pub const dead_acute: Keysym = Keysym(key::dead_acute);
    #[doc(alias = "XK_dead_circumflex")]
    pub const dead_circumflex: Keysym = Keysym(key::dead_circumflex);
    #[doc(alias = "XK_dead_tilde")]
    pub const dead_tilde: Keysym = Keysym(key::dead_tilde);
    #[doc(alias = "XK_dead_perispomeni")]
    pub const dead_perispomeni: Keysym = Keysym(key::dead_perispomeni);
    #[doc(alias = "XK_dead_macron")]
    pub const dead_macron: Keysym = Keysym(key::dead_macron);
    #[doc(alias = "XK_dead_breve")]
    pub const dead_breve: Keysym = Keysym(key::dead_breve);
    #[doc(alias = "XK_dead_abovedot")]
    pub const dead_abovedot: Keysym = Keysym(key::dead_abovedot);
    #[doc(alias = "XK_dead_diaeresis")]
    pub const dead_diaeresis: Keysym = Keysym(key::dead_diaeresis);
    #[doc(alias = "XK_dead_abovering")]
    pub const dead_abovering: Keysym = Keysym(key::dead_abovering);
    #[doc(alias = "XK_dead_doubleacute")]
    pub const dead_doubleacute: Keysym = Keysym(key::dead_doubleacute);
    #[doc(alias = "XK_dead_caron")]
    pub const dead_caron: Keysym = Keysym(key::dead_caron);
    #[doc(alias = "XK_dead_cedilla")]
    pub const dead_cedilla: Keysym = Keysym(key::dead_cedilla);
    #[doc(alias = "XK_dead_ogonek")]
    pub const dead_ogonek: Keysym = Keysym(key::dead_ogonek);
    #[doc(alias = "XK_dead_iota")]
    pub const dead_iota: Keysym = Keysym(key::dead_iota);
    #[doc(alias = "XK_dead_voiced_sound")]
    pub const dead_voiced_sound: Keysym = Keysym(key::dead_voiced_sound);
    #[doc(alias = "XK_dead_semivoiced_sound")]
    pub const dead_semivoiced_sound: Keysym = Keysym(key::dead_semivoiced_sound);
    #[doc(alias = "XK_dead_belowdot")]
    pub const dead_belowdot: Keysym = Keysym(key::dead_belowdot);
    #[doc(alias = "XK_dead_hook")]
    pub const dead_hook: Keysym = Keysym(key::dead_hook);
    #[doc(alias = "XK_dead_horn")]
    pub const dead_horn: Keysym = Keysym(key::dead_horn);
    #[doc(alias = "XK_dead_stroke")]
    pub const dead_stroke: Keysym = Keysym(key::dead_stroke);
    #[doc(alias = "XK_dead_abovecomma")]
    pub const dead_abovecomma: Keysym = Keysym(key::dead_abovecomma);
    #[doc(alias = "XK_dead_psili")]
    pub const dead_psili: Keysym = Keysym(key::dead_psili);
    #[doc(alias = "XK_dead_abovereversedcomma")]
    pub const dead_abovereversedcomma: Keysym = Keysym(key::dead_abovereversedcomma);
    #[doc(alias = "XK_dead_dasia")]
    pub const dead_dasia: Keysym = Keysym(key::dead_dasia);
    #[doc(alias = "XK_dead_doublegrave")]
    pub const dead_doublegrave: Keysym = Keysym(key::dead_doublegrave);
    #[doc(alias = "XK_dead_belowring")]
    pub const dead_belowring: Keysym = Keysym(key::dead_belowring);
    #[doc(alias = "XK_dead_belowmacron")]
    pub const dead_belowmacron: Keysym = Keysym(key::dead_belowmacron);
    #[doc(alias = "XK_dead_belowcircumflex")]
    pub const dead_belowcircumflex: Keysym = Keysym(key::dead_belowcircumflex);
    #[doc(alias = "XK_dead_belowtilde")]
    pub const dead_belowtilde: Keysym = Keysym(key::dead_belowtilde);
    #[doc(alias = "XK_dead_belowbreve")]
    pub const dead_belowbreve: Keysym = Keysym(key::dead_belowbreve);
    #[doc(alias = "XK_dead_belowdiaeresis")]
    pub const dead_belowdiaeresis: Keysym = Keysym(key::dead_belowdiaeresis);
    #[doc(alias = "XK_dead_invertedbreve")]
    pub const dead_invertedbreve: Keysym = Keysym(key::dead_invertedbreve);
    #[doc(alias = "XK_dead_belowcomma")]
    pub const dead_belowcomma: Keysym = Keysym(key::dead_belowcomma);
    #[doc(alias = "XK_dead_currency")]
    pub const dead_currency: Keysym = Keysym(key::dead_currency);
    #[doc(alias = "XK_dead_lowline")]
    pub const dead_lowline: Keysym = Keysym(key::dead_lowline);
    #[doc(alias = "XK_dead_aboveverticalline")]
    pub const dead_aboveverticalline: Keysym = Keysym(key::dead_aboveverticalline);
    #[doc(alias = "XK_dead_belowverticalline")]
    pub const dead_belowverticalline: Keysym = Keysym(key::dead_belowverticalline);
    #[doc(alias = "XK_dead_longsolidusoverlay")]
    pub const dead_longsolidusoverlay: Keysym = Keysym(key::dead_longsolidusoverlay);
    #[doc(alias = "XK_dead_a")]
    pub const dead_a: Keysym = Keysym(key::dead_a);
    #[doc(alias = "XK_dead_A")]
    pub const dead_A: Keysym = Keysym(key::dead_A);
    #[doc(alias = "XK_dead_e")]
    pub const dead_e: Keysym = Keysym(key::dead_e);
    #[doc(alias = "XK_dead_E")]
    pub const dead_E: Keysym = Keysym(key::dead_E);
    #[doc(alias = "XK_dead_i")]
    pub const dead_i: Keysym = Keysym(key::dead_i);
    #[doc(alias = "XK_dead_I")]
    pub const dead_I: Keysym = Keysym(key::dead_I);
    #[doc(alias = "XK_dead_o")]
    pub const dead_o: Keysym = Keysym(key::dead_o);
    #[doc(alias = "XK_dead_O")]
    pub const dead_O: Keysym = Keysym(key::dead_O);
    #[doc(alias = "XK_dead_u")]
    pub const dead_u: Keysym = Keysym(key::dead_u);
    #[doc(alias = "XK_dead_U")]
    pub const dead_U: Keysym = Keysym(key::dead_U);
    #[doc(alias = "XK_dead_small_schwa")]
    pub const dead_small_schwa: Keysym = Keysym(key::dead_small_schwa);
    #[doc(alias = "XK_dead_capital_schwa")]
    pub const dead_capital_schwa: Keysym = Keysym(key::dead_capital_schwa);
    #[doc(alias = "XK_dead_greek")]
    pub const dead_greek: Keysym = Keysym(key::dead_greek);
    #[doc(alias = "XK_First_Virtual_Screen")]
    pub const First_Virtual_Screen: Keysym = Keysym(key::First_Virtual_Screen);
    #[doc(alias = "XK_Prev_Virtual_Screen")]
    pub const Prev_Virtual_Screen: Keysym = Keysym(key::Prev_Virtual_Screen);
    #[doc(alias = "XK_Next_Virtual_Screen")]
    pub const Next_Virtual_Screen: Keysym = Keysym(key::Next_Virtual_Screen);
    #[doc(alias = "XK_Last_Virtual_Screen")]
    pub const Last_Virtual_Screen: Keysym = Keysym(key::Last_Virtual_Screen);
    #[doc(alias = "XK_Terminate_Server")]
    pub const Terminate_Server: Keysym = Keysym(key::Terminate_Server);
    #[doc(alias = "XK_AccessX_Enable")]
    pub const AccessX_Enable: Keysym = Keysym(key::AccessX_Enable);
    #[doc(alias = "XK_AccessX_Feedback_Enable")]
    pub const AccessX_Feedback_Enable: Keysym = Keysym(key::AccessX_Feedback_Enable);
    #[doc(alias = "XK_RepeatKeys_Enable")]
    pub const RepeatKeys_Enable: Keysym = Keysym(key::RepeatKeys_Enable);
    #[doc(alias = "XK_SlowKeys_Enable")]
    pub const SlowKeys_Enable: Keysym = Keysym(key::SlowKeys_Enable);
    #[doc(alias = "XK_BounceKeys_Enable")]
    pub const BounceKeys_Enable: Keysym = Keysym(key::BounceKeys_Enable);
    #[doc(alias = "XK_StickyKeys_Enable")]
    pub const StickyKeys_Enable: Keysym = Keysym(key::StickyKeys_Enable);
    #[doc(alias = "XK_MouseKeys_Enable")]
    pub const MouseKeys_Enable: Keysym = Keysym(key::MouseKeys_Enable);
    #[doc(alias = "XK_MouseKeys_Accel_Enable")]
    pub const MouseKeys_Accel_Enable: Keysym = Keysym(key::MouseKeys_Accel_Enable);
    #[doc(alias = "XK_Overlay1_Enable")]
    pub const Overlay1_Enable: Keysym = Keysym(key::Overlay1_Enable);
    #[doc(alias = "XK_Overlay2_Enable")]
    pub const Overlay2_Enable: Keysym = Keysym(key::Overlay2_Enable);
    #[doc(alias = "XK_AudibleBell_Enable")]
    pub const AudibleBell_Enable: Keysym = Keysym(key::AudibleBell_Enable);
    #[doc(alias = "XK_Pointer_Left")]
    pub const Pointer_Left: Keysym = Keysym(key::Pointer_Left);
    #[doc(alias = "XK_Pointer_Right")]
    pub const Pointer_Right: Keysym = Keysym(key::Pointer_Right);
    #[doc(alias = "XK_Pointer_Up")]
    pub const Pointer_Up: Keysym = Keysym(key::Pointer_Up);
    #[doc(alias = "XK_Pointer_Down")]
    pub const Pointer_Down: Keysym = Keysym(key::Pointer_Down);
    #[doc(alias = "XK_Pointer_UpLeft")]
    pub const Pointer_UpLeft: Keysym = Keysym(key::Pointer_UpLeft);
    #[doc(alias = "XK_Pointer_UpRight")]
    pub const Pointer_UpRight: Keysym = Keysym(key::Pointer_UpRight);
    #[doc(alias = "XK_Pointer_DownLeft")]
    pub const Pointer_DownLeft: Keysym = Keysym(key::Pointer_DownLeft);
    #[doc(alias = "XK_Pointer_DownRight")]
    pub const Pointer_DownRight: Keysym = Keysym(key::Pointer_DownRight);
    #[doc(alias = "XK_Pointer_Button_Dflt")]
    pub const Pointer_Button_Dflt: Keysym = Keysym(key::Pointer_Button_Dflt);
    #[doc(alias = "XK_Pointer_Button1")]
    pub const Pointer_Button1: Keysym = Keysym(key::Pointer_Button1);
    #[doc(alias = "XK_Pointer_Button2")]
    pub const Pointer_Button2: Keysym = Keysym(key::Pointer_Button2);
    #[doc(alias = "XK_Pointer_Button3")]
    pub const Pointer_Button3: Keysym = Keysym(key::Pointer_Button3);
    #[doc(alias = "XK_Pointer_Button4")]
    pub const Pointer_Button4: Keysym = Keysym(key::Pointer_Button4);
    #[doc(alias = "XK_Pointer_Button5")]
    pub const Pointer_Button5: Keysym = Keysym(key::Pointer_Button5);
    #[doc(alias = "XK_Pointer_DblClick_Dflt")]
    pub const Pointer_DblClick_Dflt: Keysym = Keysym(key::Pointer_DblClick_Dflt);
    #[doc(alias = "XK_Pointer_DblClick1")]
    pub const Pointer_DblClick1: Keysym = Keysym(key::Pointer_DblClick1);
    #[doc(alias = "XK_Pointer_DblClick2")]
    pub const Pointer_DblClick2: Keysym = Keysym(key::Pointer_DblClick2);
    #[doc(alias = "XK_Pointer_DblClick3")]
    pub const Pointer_DblClick3: Keysym = Keysym(key::Pointer_DblClick3);
    #[doc(alias = "XK_Pointer_DblClick4")]
    pub const Pointer_DblClick4: Keysym = Keysym(key::Pointer_DblClick4);
    #[doc(alias = "XK_Pointer_DblClick5")]
    pub const Pointer_DblClick5: Keysym = Keysym(key::Pointer_DblClick5);
    #[doc(alias = "XK_Pointer_Drag_Dflt")]
    pub const Pointer_Drag_Dflt: Keysym = Keysym(key::Pointer_Drag_Dflt);
    #[doc(alias = "XK_Pointer_Drag1")]
    pub const Pointer_Drag1: Keysym = Keysym(key::Pointer_Drag1);
    #[doc(alias = "XK_Pointer_Drag2")]
    pub const Pointer_Drag2: Keysym = Keysym(key::Pointer_Drag2);
    #[doc(alias = "XK_Pointer_Drag3")]
    pub const Pointer_Drag3: Keysym = Keysym(key::Pointer_Drag3);
    #[doc(alias = "XK_Pointer_Drag4")]
    pub const Pointer_Drag4: Keysym = Keysym(key::Pointer_Drag4);
    #[doc(alias = "XK_Pointer_Drag5")]
    pub const Pointer_Drag5: Keysym = Keysym(key::Pointer_Drag5);
    #[doc(alias = "XK_Pointer_EnableKeys")]
    pub const Pointer_EnableKeys: Keysym = Keysym(key::Pointer_EnableKeys);
    #[doc(alias = "XK_Pointer_Accelerate")]
    pub const Pointer_Accelerate: Keysym = Keysym(key::Pointer_Accelerate);
    #[doc(alias = "XK_Pointer_DfltBtnNext")]
    pub const Pointer_DfltBtnNext: Keysym = Keysym(key::Pointer_DfltBtnNext);
    #[doc(alias = "XK_Pointer_DfltBtnPrev")]
    pub const Pointer_DfltBtnPrev: Keysym = Keysym(key::Pointer_DfltBtnPrev);
    #[doc(alias = "XK_ch")]
    pub const ch: Keysym = Keysym(key::ch);
    #[doc(alias = "XK_Ch")]
    pub const Ch: Keysym = Keysym(key::Ch);
    #[doc(alias = "XK_CH")]
    pub const CH: Keysym = Keysym(key::CH);
    #[doc(alias = "XK_c_h")]
    pub const c_h: Keysym = Keysym(key::c_h);
    #[doc(alias = "XK_C_h")]
    pub const C_h: Keysym = Keysym(key::C_h);
    #[doc(alias = "XK_C_H")]
    pub const C_H: Keysym = Keysym(key::C_H);
    #[doc(alias = "XK_3270_Duplicate")]
    pub const _3270_Duplicate: Keysym = Keysym(key::_3270_Duplicate);
    #[doc(alias = "XK_3270_FieldMark")]
    pub const _3270_FieldMark: Keysym = Keysym(key::_3270_FieldMark);
    #[doc(alias = "XK_3270_Right2")]
    pub const _3270_Right2: Keysym = Keysym(key::_3270_Right2);
    #[doc(alias = "XK_3270_Left2")]
    pub const _3270_Left2: Keysym = Keysym(key::_3270_Left2);
    #[doc(alias = "XK_3270_BackTab")]
    pub const _3270_BackTab: Keysym = Keysym(key::_3270_BackTab);
    #[doc(alias = "XK_3270_EraseEOF")]
    pub const _3270_EraseEOF: Keysym = Keysym(key::_3270_EraseEOF);
    #[doc(alias = "XK_3270_EraseInput")]
    pub const _3270_EraseInput: Keysym = Keysym(key::_3270_EraseInput);
    #[doc(alias = "XK_3270_Reset")]
    pub const _3270_Reset: Keysym = Keysym(key::_3270_Reset);
    #[doc(alias = "XK_3270_Quit")]
    pub const _3270_Quit: Keysym = Keysym(key::_3270_Quit);
    #[doc(alias = "XK_3270_PA1")]
    pub const _3270_PA1: Keysym = Keysym(key::_3270_PA1);
    #[doc(alias = "XK_3270_PA2")]
    pub const _3270_PA2: Keysym = Keysym(key::_3270_PA2);
    #[doc(alias = "XK_3270_PA3")]
    pub const _3270_PA3: Keysym = Keysym(key::_3270_PA3);
    #[doc(alias = "XK_3270_Test")]
    pub const _3270_Test: Keysym = Keysym(key::_3270_Test);
    #[doc(alias = "XK_3270_Attn")]
    pub const _3270_Attn: Keysym = Keysym(key::_3270_Attn);
    #[doc(alias = "XK_3270_CursorBlink")]
    pub const _3270_CursorBlink: Keysym = Keysym(key::_3270_CursorBlink);
    #[doc(alias = "XK_3270_AltCursor")]
    pub const _3270_AltCursor: Keysym = Keysym(key::_3270_AltCursor);
    #[doc(alias = "XK_3270_KeyClick")]
    pub const _3270_KeyClick: Keysym = Keysym(key::_3270_KeyClick);
    #[doc(alias = "XK_3270_Jump")]
    pub const _3270_Jump: Keysym = Keysym(key::_3270_Jump);
    #[doc(alias = "XK_3270_Ident")]
    pub const _3270_Ident: Keysym = Keysym(key::_3270_Ident);
    #[doc(alias = "XK_3270_Rule")]
    pub const _3270_Rule: Keysym = Keysym(key::_3270_Rule);
    #[doc(alias = "XK_3270_Copy")]
    pub const _3270_Copy: Keysym = Keysym(key::_3270_Copy);
    #[doc(alias = "XK_3270_Play")]
    pub const _3270_Play: Keysym = Keysym(key::_3270_Play);
    #[doc(alias = "XK_3270_Setup")]
    pub const _3270_Setup: Keysym = Keysym(key::_3270_Setup);
    #[doc(alias = "XK_3270_Record")]
    pub const _3270_Record: Keysym = Keysym(key::_3270_Record);
    #[doc(alias = "XK_3270_ChangeScreen")]
    pub const _3270_ChangeScreen: Keysym = Keysym(key::_3270_ChangeScreen);
    #[doc(alias = "XK_3270_DeleteWord")]
    pub const _3270_DeleteWord: Keysym = Keysym(key::_3270_DeleteWord);
    #[doc(alias = "XK_3270_ExSelect")]
    pub const _3270_ExSelect: Keysym = Keysym(key::_3270_ExSelect);
    #[doc(alias = "XK_3270_CursorSelect")]
    pub const _3270_CursorSelect: Keysym = Keysym(key::_3270_CursorSelect);
    #[doc(alias = "XK_3270_PrintScreen")]
    pub const _3270_PrintScreen: Keysym = Keysym(key::_3270_PrintScreen);
    #[doc(alias = "XK_3270_Enter")]
    pub const _3270_Enter: Keysym = Keysym(key::_3270_Enter);
    #[doc(alias = "XK_space")]
    pub const space: Keysym = Keysym(key::space);
    #[doc(alias = "XK_exclam")]
    pub const exclam: Keysym = Keysym(key::exclam);
    #[doc(alias = "XK_quotedbl")]
    pub const quotedbl: Keysym = Keysym(key::quotedbl);
    #[doc(alias = "XK_numbersign")]
    pub const numbersign: Keysym = Keysym(key::numbersign);
    #[doc(alias = "XK_dollar")]
    pub const dollar: Keysym = Keysym(key::dollar);
    #[doc(alias = "XK_percent")]
    pub const percent: Keysym = Keysym(key::percent);
    #[doc(alias = "XK_ampersand")]
    pub const ampersand: Keysym = Keysym(key::ampersand);
    #[doc(alias = "XK_apostrophe")]
    pub const apostrophe: Keysym = Keysym(key::apostrophe);
    #[doc(alias = "XK_quoteright")]
    pub const quoteright: Keysym = Keysym(key::quoteright);
    #[doc(alias = "XK_parenleft")]
    pub const parenleft: Keysym = Keysym(key::parenleft);
    #[doc(alias = "XK_parenright")]
    pub const parenright: Keysym = Keysym(key::parenright);
    #[doc(alias = "XK_asterisk")]
    pub const asterisk: Keysym = Keysym(key::asterisk);
    #[doc(alias = "XK_plus")]
    pub const plus: Keysym = Keysym(key::plus);
    #[doc(alias = "XK_comma")]
    pub const comma: Keysym = Keysym(key::comma);
    #[doc(alias = "XK_minus")]
    pub const minus: Keysym = Keysym(key::minus);
    #[doc(alias = "XK_period")]
    pub const period: Keysym = Keysym(key::period);
    #[doc(alias = "XK_slash")]
    pub const slash: Keysym = Keysym(key::slash);
    #[doc(alias = "XK_0")]
    pub const _0: Keysym = Keysym(key::_0);
    #[doc(alias = "XK_1")]
    pub const _1: Keysym = Keysym(key::_1);
    #[doc(alias = "XK_2")]
    pub const _2: Keysym = Keysym(key::_2);
    #[doc(alias = "XK_3")]
    pub const _3: Keysym = Keysym(key::_3);
    #[doc(alias = "XK_4")]
    pub const _4: Keysym = Keysym(key::_4);
    #[doc(alias = "XK_5")]
    pub const _5: Keysym = Keysym(key::_5);
    #[doc(alias = "XK_6")]
    pub const _6: Keysym = Keysym(key::_6);
    #[doc(alias = "XK_7")]
    pub const _7: Keysym = Keysym(key::_7);
    #[doc(alias = "XK_8")]
    pub const _8: Keysym = Keysym(key::_8);
    #[doc(alias = "XK_9")]
    pub const _9: Keysym = Keysym(key::_9);
    #[doc(alias = "XK_colon")]
    pub const colon: Keysym = Keysym(key::colon);
    #[doc(alias = "XK_semicolon")]
    pub const semicolon: Keysym = Keysym(key::semicolon);
    #[doc(alias = "XK_less")]
    pub const less: Keysym = Keysym(key::less);
    #[doc(alias = "XK_equal")]
    pub const equal: Keysym = Keysym(key::equal);
    #[doc(alias = "XK_greater")]
    pub const greater: Keysym = Keysym(key::greater);
    #[doc(alias = "XK_question")]
    pub const question: Keysym = Keysym(key::question);
    #[doc(alias = "XK_at")]
    pub const at: Keysym = Keysym(key::at);
    #[doc(alias = "XK_A")]
    pub const A: Keysym = Keysym(key::A);
    #[doc(alias = "XK_B")]
    pub const B: Keysym = Keysym(key::B);
    #[doc(alias = "XK_C")]
    pub const C: Keysym = Keysym(key::C);
    #[doc(alias = "XK_D")]
    pub const D: Keysym = Keysym(key::D);
    #[doc(alias = "XK_E")]
    pub const E: Keysym = Keysym(key::E);
    #[doc(alias = "XK_F")]
    pub const F: Keysym = Keysym(key::F);
    #[doc(alias = "XK_G")]
    pub const G: Keysym = Keysym(key::G);
    #[doc(alias = "XK_H")]
    pub const H: Keysym = Keysym(key::H);
    #[doc(alias = "XK_I")]
    pub const I: Keysym = Keysym(key::I);
    #[doc(alias = "XK_J")]
    pub const J: Keysym = Keysym(key::J);
    #[doc(alias = "XK_K")]
    pub const K: Keysym = Keysym(key::K);
    #[doc(alias = "XK_L")]
    pub const L: Keysym = Keysym(key::L);
    #[doc(alias = "XK_M")]
    pub const M: Keysym = Keysym(key::M);
    #[doc(alias = "XK_N")]
    pub const N: Keysym = Keysym(key::N);
    #[doc(alias = "XK_O")]
    pub const O: Keysym = Keysym(key::O);
    #[doc(alias = "XK_P")]
    pub const P: Keysym = Keysym(key::P);
    #[doc(alias = "XK_Q")]
    pub const Q: Keysym = Keysym(key::Q);
    #[doc(alias = "XK_R")]
    pub const R: Keysym = Keysym(key::R);
    #[doc(alias = "XK_S")]
    pub const S: Keysym = Keysym(key::S);
    #[doc(alias = "XK_T")]
    pub const T: Keysym = Keysym(key::T);
    #[doc(alias = "XK_U")]
    pub const U: Keysym = Keysym(key::U);
    #[doc(alias = "XK_V")]
    pub const V: Keysym = Keysym(key::V);
    #[doc(alias = "XK_W")]
    pub const W: Keysym = Keysym(key::W);
    #[doc(alias = "XK_X")]
    pub const X: Keysym = Keysym(key::X);
    #[doc(alias = "XK_Y")]
    pub const Y: Keysym = Keysym(key::Y);
    #[doc(alias = "XK_Z")]
    pub const Z: Keysym = Keysym(key::Z);
    #[doc(alias = "XK_bracketleft")]
    pub const bracketleft: Keysym = Keysym(key::bracketleft);
    #[doc(alias = "XK_backslash")]
    pub const backslash: Keysym = Keysym(key::backslash);
    #[doc(alias = "XK_bracketright")]
    pub const bracketright: Keysym = Keysym(key::bracketright);
    #[doc(alias = "XK_asciicircum")]
    pub const asciicircum: Keysym = Keysym(key::asciicircum);
    #[doc(alias = "XK_underscore")]
    pub const underscore: Keysym = Keysym(key::underscore);
    #[doc(alias = "XK_grave")]
    pub const grave: Keysym = Keysym(key::grave);
    #[doc(alias = "XK_quoteleft")]
    pub const quoteleft: Keysym = Keysym(key::quoteleft);
    #[doc(alias = "XK_a")]
    pub const a: Keysym = Keysym(key::a);
    #[doc(alias = "XK_b")]
    pub const b: Keysym = Keysym(key::b);
    #[doc(alias = "XK_c")]
    pub const c: Keysym = Keysym(key::c);
    #[doc(alias = "XK_d")]
    pub const d: Keysym = Keysym(key::d);
    #[doc(alias = "XK_e")]
    pub const e: Keysym = Keysym(key::e);
    #[doc(alias = "XK_f")]
    pub const f: Keysym = Keysym(key::f);
    #[doc(alias = "XK_g")]
    pub const g: Keysym = Keysym(key::g);
    #[doc(alias = "XK_h")]
    pub const h: Keysym = Keysym(key::h);
    #[doc(alias = "XK_i")]
    pub const i: Keysym = Keysym(key::i);
    #[doc(alias = "XK_j")]
    pub const j: Keysym = Keysym(key::j);
    #[doc(alias = "XK_k")]
    pub const k: Keysym = Keysym(key::k);
    #[doc(alias = "XK_l")]
    pub const l: Keysym = Keysym(key::l);
    #[doc(alias = "XK_m")]
    pub const m: Keysym = Keysym(key::m);
    #[doc(alias = "XK_n")]
    pub const n: Keysym = Keysym(key::n);
    #[doc(alias = "XK_o")]
    pub const o: Keysym = Keysym(key::o);
    #[doc(alias = "XK_p")]
    pub const p: Keysym = Keysym(key::p);
    #[doc(alias = "XK_q")]
    pub const q: Keysym = Keysym(key::q);
    #[doc(alias = "XK_r")]
    pub const r: Keysym = Keysym(key::r);
    #[doc(alias = "XK_s")]
    pub const s: Keysym = Keysym(key::s);
    #[doc(alias = "XK_t")]
    pub const t: Keysym = Keysym(key::t);
    #[doc(alias = "XK_u")]
    pub const u: Keysym = Keysym(key::u);
    #[doc(alias = "XK_v")]
    pub const v: Keysym = Keysym(key::v);
    #[doc(alias = "XK_w")]
    pub const w: Keysym = Keysym(key::w);
    #[doc(alias = "XK_x")]
    pub const x: Keysym = Keysym(key::x);
    #[doc(alias = "XK_y")]
    pub const y: Keysym = Keysym(key::y);
    #[doc(alias = "XK_z")]
    pub const z: Keysym = Keysym(key::z);
    #[doc(alias = "XK_braceleft")]
    pub const braceleft: Keysym = Keysym(key::braceleft);
    #[doc(alias = "XK_bar")]
    pub const bar: Keysym = Keysym(key::bar);
    #[doc(alias = "XK_braceright")]
    pub const braceright: Keysym = Keysym(key::braceright);
    #[doc(alias = "XK_asciitilde")]
    pub const asciitilde: Keysym = Keysym(key::asciitilde);
    #[doc(alias = "XK_nobreakspace")]
    pub const nobreakspace: Keysym = Keysym(key::nobreakspace);
    #[doc(alias = "XK_exclamdown")]
    pub const exclamdown: Keysym = Keysym(key::exclamdown);
    #[doc(alias = "XK_cent")]
    pub const cent: Keysym = Keysym(key::cent);
    #[doc(alias = "XK_sterling")]
    pub const sterling: Keysym = Keysym(key::sterling);
    #[doc(alias = "XK_currency")]
    pub const currency: Keysym = Keysym(key::currency);
    #[doc(alias = "XK_yen")]
    pub const yen: Keysym = Keysym(key::yen);
    #[doc(alias = "XK_brokenbar")]
    pub const brokenbar: Keysym = Keysym(key::brokenbar);
    #[doc(alias = "XK_section")]
    pub const section: Keysym = Keysym(key::section);
    #[doc(alias = "XK_diaeresis")]
    pub const diaeresis: Keysym = Keysym(key::diaeresis);
    #[doc(alias = "XK_copyright")]
    pub const copyright: Keysym = Keysym(key::copyright);
    #[doc(alias = "XK_ordfeminine")]
    pub const ordfeminine: Keysym = Keysym(key::ordfeminine);
    #[doc(alias = "XK_guillemotleft")]
    pub const guillemotleft: Keysym = Keysym(key::guillemotleft);
    #[doc(alias = "XK_notsign")]
    pub const notsign: Keysym = Keysym(key::notsign);
    #[doc(alias = "XK_hyphen")]
    pub const hyphen: Keysym = Keysym(key::hyphen);
    #[doc(alias = "XK_registered")]
    pub const registered: Keysym = Keysym(key::registered);
    #[doc(alias = "XK_macron")]
    pub const macron: Keysym = Keysym(key::macron);
    #[doc(alias = "XK_degree")]
    pub const degree: Keysym = Keysym(key::degree);
    #[doc(alias = "XK_plusminus")]
    pub const plusminus: Keysym = Keysym(key::plusminus);
    #[doc(alias = "XK_twosuperior")]
    pub const twosuperior: Keysym = Keysym(key::twosuperior);
    #[doc(alias = "XK_threesuperior")]
    pub const threesuperior: Keysym = Keysym(key::threesuperior);
    #[doc(alias = "XK_acute")]
    pub const acute: Keysym = Keysym(key::acute);
    #[doc(alias = "XK_mu")]
    pub const mu: Keysym = Keysym(key::mu);
    #[doc(alias = "XK_paragraph")]
    pub const paragraph: Keysym = Keysym(key::paragraph);
    #[doc(alias = "XK_periodcentered")]
    pub const periodcentered: Keysym = Keysym(key::periodcentered);
    #[doc(alias = "XK_cedilla")]
    pub const cedilla: Keysym = Keysym(key::cedilla);
    #[doc(alias = "XK_onesuperior")]
    pub const onesuperior: Keysym = Keysym(key::onesuperior);
    #[doc(alias = "XK_masculine")]
    pub const masculine: Keysym = Keysym(key::masculine);
    #[doc(alias = "XK_guillemotright")]
    pub const guillemotright: Keysym = Keysym(key::guillemotright);
    #[doc(alias = "XK_onequarter")]
    pub const onequarter: Keysym = Keysym(key::onequarter);
    #[doc(alias = "XK_onehalf")]
    pub const onehalf: Keysym = Keysym(key::onehalf);
    #[doc(alias = "XK_threequarters")]
    pub const threequarters: Keysym = Keysym(key::threequarters);
    #[doc(alias = "XK_questiondown")]
    pub const questiondown: Keysym = Keysym(key::questiondown);
    #[doc(alias = "XK_Agrave")]
    pub const Agrave: Keysym = Keysym(key::Agrave);
    #[doc(alias = "XK_Aacute")]
    pub const Aacute: Keysym = Keysym(key::Aacute);
    #[doc(alias = "XK_Acircumflex")]
    pub const Acircumflex: Keysym = Keysym(key::Acircumflex);
    #[doc(alias = "XK_Atilde")]
    pub const Atilde: Keysym = Keysym(key::Atilde);
    #[doc(alias = "XK_Adiaeresis")]
    pub const Adiaeresis: Keysym = Keysym(key::Adiaeresis);
    #[doc(alias = "XK_Aring")]
    pub const Aring: Keysym = Keysym(key::Aring);
    #[doc(alias = "XK_AE")]
    pub const AE: Keysym = Keysym(key::AE);
    #[doc(alias = "XK_Ccedilla")]
    pub const Ccedilla: Keysym = Keysym(key::Ccedilla);
    #[doc(alias = "XK_Egrave")]
    pub const Egrave: Keysym = Keysym(key::Egrave);
    #[doc(alias = "XK_Eacute")]
    pub const Eacute: Keysym = Keysym(key::Eacute);
    #[doc(alias = "XK_Ecircumflex")]
    pub const Ecircumflex: Keysym = Keysym(key::Ecircumflex);
    #[doc(alias = "XK_Ediaeresis")]
    pub const Ediaeresis: Keysym = Keysym(key::Ediaeresis);
    #[doc(alias = "XK_Igrave")]
    pub const Igrave: Keysym = Keysym(key::Igrave);
    #[doc(alias = "XK_Iacute")]
    pub const Iacute: Keysym = Keysym(key::Iacute);
    #[doc(alias = "XK_Icircumflex")]
    pub const Icircumflex: Keysym = Keysym(key::Icircumflex);
    #[doc(alias = "XK_Idiaeresis")]
    pub const Idiaeresis: Keysym = Keysym(key::Idiaeresis);
    #[doc(alias = "XK_ETH")]
    pub const ETH: Keysym = Keysym(key::ETH);
    #[doc(alias = "XK_Eth")]
    pub const Eth: Keysym = Keysym(key::Eth);
    #[doc(alias = "XK_Ntilde")]
    pub const Ntilde: Keysym = Keysym(key::Ntilde);
    #[doc(alias = "XK_Ograve")]
    pub const Ograve: Keysym = Keysym(key::Ograve);
    #[doc(alias = "XK_Oacute")]
    pub const Oacute: Keysym = Keysym(key::Oacute);
    #[doc(alias = "XK_Ocircumflex")]
    pub const Ocircumflex: Keysym = Keysym(key::Ocircumflex);
    #[doc(alias = "XK_Otilde")]
    pub const Otilde: Keysym = Keysym(key::Otilde);
    #[doc(alias = "XK_Odiaeresis")]
    pub const Odiaeresis: Keysym = Keysym(key::Odiaeresis);
    #[doc(alias = "XK_multiply")]
    pub const multiply: Keysym = Keysym(key::multiply);
    #[doc(alias = "XK_Oslash")]
    pub const Oslash: Keysym = Keysym(key::Oslash);
    #[doc(alias = "XK_Ooblique")]
    pub const Ooblique: Keysym = Keysym(key::Ooblique);
    #[doc(alias = "XK_Ugrave")]
    pub const Ugrave: Keysym = Keysym(key::Ugrave);
    #[doc(alias = "XK_Uacute")]
    pub const Uacute: Keysym = Keysym(key::Uacute);
    #[doc(alias = "XK_Ucircumflex")]
    pub const Ucircumflex: Keysym = Keysym(key::Ucircumflex);
    #[doc(alias = "XK_Udiaeresis")]
    pub const Udiaeresis: Keysym = Keysym(key::Udiaeresis);
    #[doc(alias = "XK_Yacute")]
    pub const Yacute: Keysym = Keysym(key::Yacute);
    #[doc(alias = "XK_THORN")]
    pub const THORN: Keysym = Keysym(key::THORN);
    #[doc(alias = "XK_Thorn")]
    pub const Thorn: Keysym = Keysym(key::Thorn);
    #[doc(alias = "XK_ssharp")]
    pub const ssharp: Keysym = Keysym(key::ssharp);
    #[doc(alias = "XK_agrave")]
    pub const agrave: Keysym = Keysym(key::agrave);
    #[doc(alias = "XK_aacute")]
    pub const aacute: Keysym = Keysym(key::aacute);
    #[doc(alias = "XK_acircumflex")]
    pub const acircumflex: Keysym = Keysym(key::acircumflex);
    #[doc(alias = "XK_atilde")]
    pub const atilde: Keysym = Keysym(key::atilde);
    #[doc(alias = "XK_adiaeresis")]
    pub const adiaeresis: Keysym = Keysym(key::adiaeresis);
    #[doc(alias = "XK_aring")]
    pub const aring: Keysym = Keysym(key::aring);
    #[doc(alias = "XK_ae")]
    pub const ae: Keysym = Keysym(key::ae);
    #[doc(alias = "XK_ccedilla")]
    pub const ccedilla: Keysym = Keysym(key::ccedilla);
    #[doc(alias = "XK_egrave")]
    pub const egrave: Keysym = Keysym(key::egrave);
    #[doc(alias = "XK_eacute")]
    pub const eacute: Keysym = Keysym(key::eacute);
    #[doc(alias = "XK_ecircumflex")]
    pub const ecircumflex: Keysym = Keysym(key::ecircumflex);
    #[doc(alias = "XK_ediaeresis")]
    pub const ediaeresis: Keysym = Keysym(key::ediaeresis);
    #[doc(alias = "XK_igrave")]
    pub const igrave: Keysym = Keysym(key::igrave);
    #[doc(alias = "XK_iacute")]
    pub const iacute: Keysym = Keysym(key::iacute);
    #[doc(alias = "XK_icircumflex")]
    pub const icircumflex: Keysym = Keysym(key::icircumflex);
    #[doc(alias = "XK_idiaeresis")]
    pub const idiaeresis: Keysym = Keysym(key::idiaeresis);
    #[doc(alias = "XK_eth")]
    pub const eth: Keysym = Keysym(key::eth);
    #[doc(alias = "XK_ntilde")]
    pub const ntilde: Keysym = Keysym(key::ntilde);
    #[doc(alias = "XK_ograve")]
    pub const ograve: Keysym = Keysym(key::ograve);
    #[doc(alias = "XK_oacute")]
    pub const oacute: Keysym = Keysym(key::oacute);
    #[doc(alias = "XK_ocircumflex")]
    pub const ocircumflex: Keysym = Keysym(key::ocircumflex);
    #[doc(alias = "XK_otilde")]
    pub const otilde: Keysym = Keysym(key::otilde);
    #[doc(alias = "XK_odiaeresis")]
    pub const odiaeresis: Keysym = Keysym(key::odiaeresis);
    #[doc(alias = "XK_division")]
    pub const division: Keysym = Keysym(key::division);
    #[doc(alias = "XK_oslash")]
    pub const oslash: Keysym = Keysym(key::oslash);
    #[doc(alias = "XK_ooblique")]
    pub const ooblique: Keysym = Keysym(key::ooblique);
    #[doc(alias = "XK_ugrave")]
    pub const ugrave: Keysym = Keysym(key::ugrave);
    #[doc(alias = "XK_uacute")]
    pub const uacute: Keysym = Keysym(key::uacute);
    #[doc(alias = "XK_ucircumflex")]
    pub const ucircumflex: Keysym = Keysym(key::ucircumflex);
    #[doc(alias = "XK_udiaeresis")]
    pub const udiaeresis: Keysym = Keysym(key::udiaeresis);
    #[doc(alias = "XK_yacute")]
    pub const yacute: Keysym = Keysym(key::yacute);
    #[doc(alias = "XK_thorn")]
    pub const thorn: Keysym = Keysym(key::thorn);
    #[doc(alias = "XK_ydiaeresis")]
    pub const ydiaeresis: Keysym = Keysym(key::ydiaeresis);
    #[doc(alias = "XK_Aogonek")]
    pub const Aogonek: Keysym = Keysym(key::Aogonek);
    #[doc(alias = "XK_breve")]
    pub const breve: Keysym = Keysym(key::breve);
    #[doc(alias = "XK_Lstroke")]
    pub const Lstroke: Keysym = Keysym(key::Lstroke);
    #[doc(alias = "XK_Lcaron")]
    pub const Lcaron: Keysym = Keysym(key::Lcaron);
    #[doc(alias = "XK_Sacute")]
    pub const Sacute: Keysym = Keysym(key::Sacute);
    #[doc(alias = "XK_Scaron")]
    pub const Scaron: Keysym = Keysym(key::Scaron);
    #[doc(alias = "XK_Scedilla")]
    pub const Scedilla: Keysym = Keysym(key::Scedilla);
    #[doc(alias = "XK_Tcaron")]
    pub const Tcaron: Keysym = Keysym(key::Tcaron);
    #[doc(alias = "XK_Zacute")]
    pub const Zacute: Keysym = Keysym(key::Zacute);
    #[doc(alias = "XK_Zcaron")]
    pub const Zcaron: Keysym = Keysym(key::Zcaron);
    #[doc(alias = "XK_Zabovedot")]
    pub const Zabovedot: Keysym = Keysym(key::Zabovedot);
    #[doc(alias = "XK_aogonek")]
    pub const aogonek: Keysym = Keysym(key::aogonek);
    #[doc(alias = "XK_ogonek")]
    pub const ogonek: Keysym = Keysym(key::ogonek);
    #[doc(alias = "XK_lstroke")]
    pub const lstroke: Keysym = Keysym(key::lstroke);
    #[doc(alias = "XK_lcaron")]
    pub const lcaron: Keysym = Keysym(key::lcaron);
    #[doc(alias = "XK_sacute")]
    pub const sacute: Keysym = Keysym(key::sacute);
    #[doc(alias = "XK_caron")]
    pub const caron: Keysym = Keysym(key::caron);
    #[doc(alias = "XK_scaron")]
    pub const scaron: Keysym = Keysym(key::scaron);
    #[doc(alias = "XK_scedilla")]
    pub const scedilla: Keysym = Keysym(key::scedilla);
    #[doc(alias = "XK_tcaron")]
    pub const tcaron: Keysym = Keysym(key::tcaron);
    #[doc(alias = "XK_zacute")]
    pub const zacute: Keysym = Keysym(key::zacute);
    #[doc(alias = "XK_doubleacute")]
    pub const doubleacute: Keysym = Keysym(key::doubleacute);
    #[doc(alias = "XK_zcaron")]
    pub const zcaron: Keysym = Keysym(key::zcaron);
    #[doc(alias = "XK_zabovedot")]
    pub const zabovedot: Keysym = Keysym(key::zabovedot);
    #[doc(alias = "XK_Racute")]
    pub const Racute: Keysym = Keysym(key::Racute);
    #[doc(alias = "XK_Abreve")]
    pub const Abreve: Keysym = Keysym(key::Abreve);
    #[doc(alias = "XK_Lacute")]
    pub const Lacute: Keysym = Keysym(key::Lacute);
    #[doc(alias = "XK_Cacute")]
    pub const Cacute: Keysym = Keysym(key::Cacute);
    #[doc(alias = "XK_Ccaron")]
    pub const Ccaron: Keysym = Keysym(key::Ccaron);
    #[doc(alias = "XK_Eogonek")]
    pub const Eogonek: Keysym = Keysym(key::Eogonek);
    #[doc(alias = "XK_Ecaron")]
    pub const Ecaron: Keysym = Keysym(key::Ecaron);
    #[doc(alias = "XK_Dcaron")]
    pub const Dcaron: Keysym = Keysym(key::Dcaron);
    #[doc(alias = "XK_Dstroke")]
    pub const Dstroke: Keysym = Keysym(key::Dstroke);
    #[doc(alias = "XK_Nacute")]
    pub const Nacute: Keysym = Keysym(key::Nacute);
    #[doc(alias = "XK_Ncaron")]
    pub const Ncaron: Keysym = Keysym(key::Ncaron);
    #[doc(alias = "XK_Odoubleacute")]
    pub const Odoubleacute: Keysym = Keysym(key::Odoubleacute);
    #[doc(alias = "XK_Rcaron")]
    pub const Rcaron: Keysym = Keysym(key::Rcaron);
    #[doc(alias = "XK_Uring")]
    pub const Uring: Keysym = Keysym(key::Uring);
    #[doc(alias = "XK_Udoubleacute")]
    pub const Udoubleacute: Keysym = Keysym(key::Udoubleacute);
    #[doc(alias = "XK_Tcedilla")]
    pub const Tcedilla: Keysym = Keysym(key::Tcedilla);
    #[doc(alias = "XK_racute")]
    pub const racute: Keysym = Keysym(key::racute);
    #[doc(alias = "XK_abreve")]
    pub const abreve: Keysym = Keysym(key::abreve);
    #[doc(alias = "XK_lacute")]
    pub const lacute: Keysym = Keysym(key::lacute);
    #[doc(alias = "XK_cacute")]
    pub const cacute: Keysym = Keysym(key::cacute);
    #[doc(alias = "XK_ccaron")]
    pub const ccaron: Keysym = Keysym(key::ccaron);
    #[doc(alias = "XK_eogonek")]
    pub const eogonek: Keysym = Keysym(key::eogonek);
    #[doc(alias = "XK_ecaron")]
    pub const ecaron: Keysym = Keysym(key::ecaron);
    #[doc(alias = "XK_dcaron")]
    pub const dcaron: Keysym = Keysym(key::dcaron);
    #[doc(alias = "XK_dstroke")]
    pub const dstroke: Keysym = Keysym(key::dstroke);
    #[doc(alias = "XK_nacute")]
    pub const nacute: Keysym = Keysym(key::nacute);
    #[doc(alias = "XK_ncaron")]
    pub const ncaron: Keysym = Keysym(key::ncaron);
    #[doc(alias = "XK_odoubleacute")]
    pub const odoubleacute: Keysym = Keysym(key::odoubleacute);
    #[doc(alias = "XK_rcaron")]
    pub const rcaron: Keysym = Keysym(key::rcaron);
    #[doc(alias = "XK_uring")]
    pub const uring: Keysym = Keysym(key::uring);
    #[doc(alias = "XK_udoubleacute")]
    pub const udoubleacute: Keysym = Keysym(key::udoubleacute);
    #[doc(alias = "XK_tcedilla")]
    pub const tcedilla: Keysym = Keysym(key::tcedilla);
    #[doc(alias = "XK_abovedot")]
    pub const abovedot: Keysym = Keysym(key::abovedot);
    #[doc(alias = "XK_Hstroke")]
    pub const Hstroke: Keysym = Keysym(key::Hstroke);
    #[doc(alias = "XK_Hcircumflex")]
    pub const Hcircumflex: Keysym = Keysym(key::Hcircumflex);
    #[doc(alias = "XK_Iabovedot")]
    pub const Iabovedot: Keysym = Keysym(key::Iabovedot);
    #[doc(alias = "XK_Gbreve")]
    pub const Gbreve: Keysym = Keysym(key::Gbreve);
    #[doc(alias = "XK_Jcircumflex")]
    pub const Jcircumflex: Keysym = Keysym(key::Jcircumflex);
    #[doc(alias = "XK_hstroke")]
    pub const hstroke: Keysym = Keysym(key::hstroke);
    #[doc(alias = "XK_hcircumflex")]
    pub const hcircumflex: Keysym = Keysym(key::hcircumflex);
    #[doc(alias = "XK_idotless")]
    pub const idotless: Keysym = Keysym(key::idotless);
    #[doc(alias = "XK_gbreve")]
    pub const gbreve: Keysym = Keysym(key::gbreve);
    #[doc(alias = "XK_jcircumflex")]
    pub const jcircumflex: Keysym = Keysym(key::jcircumflex);
    #[doc(alias = "XK_Cabovedot")]
    pub const Cabovedot: Keysym = Keysym(key::Cabovedot);
    #[doc(alias = "XK_Ccircumflex")]
    pub const Ccircumflex: Keysym = Keysym(key::Ccircumflex);
    #[doc(alias = "XK_Gabovedot")]
    pub const Gabovedot: Keysym = Keysym(key::Gabovedot);
    #[doc(alias = "XK_Gcircumflex")]
    pub const Gcircumflex: Keysym = Keysym(key::Gcircumflex);
    #[doc(alias = "XK_Ubreve")]
    pub const Ubreve: Keysym = Keysym(key::Ubreve);
    #[doc(alias = "XK_Scircumflex")]
    pub const Scircumflex: Keysym = Keysym(key::Scircumflex);
    #[doc(alias = "XK_cabovedot")]
    pub const cabovedot: Keysym = Keysym(key::cabovedot);
    #[doc(alias = "XK_ccircumflex")]
    pub const ccircumflex: Keysym = Keysym(key::ccircumflex);
    #[doc(alias = "XK_gabovedot")]
    pub const gabovedot: Keysym = Keysym(key::gabovedot);
    #[doc(alias = "XK_gcircumflex")]
    pub const gcircumflex: Keysym = Keysym(key::gcircumflex);
    #[doc(alias = "XK_ubreve")]
    pub const ubreve: Keysym = Keysym(key::ubreve);
    #[doc(alias = "XK_scircumflex")]
    pub const scircumflex: Keysym = Keysym(key::scircumflex);
    #[doc(alias = "XK_kra")]
    pub const kra: Keysym = Keysym(key::kra);
    #[doc(alias = "XK_kappa")]
    pub const kappa: Keysym = Keysym(key::kappa);
    #[doc(alias = "XK_Rcedilla")]
    pub const Rcedilla: Keysym = Keysym(key::Rcedilla);
    #[doc(alias = "XK_Itilde")]
    pub const Itilde: Keysym = Keysym(key::Itilde);
    #[doc(alias = "XK_Lcedilla")]
    pub const Lcedilla: Keysym = Keysym(key::Lcedilla);
    #[doc(alias = "XK_Emacron")]
    pub const Emacron: Keysym = Keysym(key::Emacron);
    #[doc(alias = "XK_Gcedilla")]
    pub const Gcedilla: Keysym = Keysym(key::Gcedilla);
    #[doc(alias = "XK_Tslash")]
    pub const Tslash: Keysym = Keysym(key::Tslash);
    #[doc(alias = "XK_rcedilla")]
    pub const rcedilla: Keysym = Keysym(key::rcedilla);
    #[doc(alias = "XK_itilde")]
    pub const itilde: Keysym = Keysym(key::itilde);
    #[doc(alias = "XK_lcedilla")]
    pub const lcedilla: Keysym = Keysym(key::lcedilla);
    #[doc(alias = "XK_emacron")]
    pub const emacron: Keysym = Keysym(key::emacron);
    #[doc(alias = "XK_gcedilla")]
    pub const gcedilla: Keysym = Keysym(key::gcedilla);
    #[doc(alias = "XK_tslash")]
    pub const tslash: Keysym = Keysym(key::tslash);
    #[doc(alias = "XK_ENG")]
    pub const ENG: Keysym = Keysym(key::ENG);
    #[doc(alias = "XK_eng")]
    pub const eng: Keysym = Keysym(key::eng);
    #[doc(alias = "XK_Amacron")]
    pub const Amacron: Keysym = Keysym(key::Amacron);
    #[doc(alias = "XK_Iogonek")]
    pub const Iogonek: Keysym = Keysym(key::Iogonek);
    #[doc(alias = "XK_Eabovedot")]
    pub const Eabovedot: Keysym = Keysym(key::Eabovedot);
    #[doc(alias = "XK_Imacron")]
    pub const Imacron: Keysym = Keysym(key::Imacron);
    #[doc(alias = "XK_Ncedilla")]
    pub const Ncedilla: Keysym = Keysym(key::Ncedilla);
    #[doc(alias = "XK_Omacron")]
    pub const Omacron: Keysym = Keysym(key::Omacron);
    #[doc(alias = "XK_Kcedilla")]
    pub const Kcedilla: Keysym = Keysym(key::Kcedilla);
    #[doc(alias = "XK_Uogonek")]
    pub const Uogonek: Keysym = Keysym(key::Uogonek);
    #[doc(alias = "XK_Utilde")]
    pub const Utilde: Keysym = Keysym(key::Utilde);
    #[doc(alias = "XK_Umacron")]
    pub const Umacron: Keysym = Keysym(key::Umacron);
    #[doc(alias = "XK_amacron")]
    pub const amacron: Keysym = Keysym(key::amacron);
    #[doc(alias = "XK_iogonek")]
    pub const iogonek: Keysym = Keysym(key::iogonek);
    #[doc(alias = "XK_eabovedot")]
    pub const eabovedot: Keysym = Keysym(key::eabovedot);
    #[doc(alias = "XK_imacron")]
    pub const imacron: Keysym = Keysym(key::imacron);
    #[doc(alias = "XK_ncedilla")]
    pub const ncedilla: Keysym = Keysym(key::ncedilla);
    #[doc(alias = "XK_omacron")]
    pub const omacron: Keysym = Keysym(key::omacron);
    #[doc(alias = "XK_kcedilla")]
    pub const kcedilla: Keysym = Keysym(key::kcedilla);
    #[doc(alias = "XK_uogonek")]
    pub const uogonek: Keysym = Keysym(key::uogonek);
    #[doc(alias = "XK_utilde")]
    pub const utilde: Keysym = Keysym(key::utilde);
    #[doc(alias = "XK_umacron")]
    pub const umacron: Keysym = Keysym(key::umacron);
    #[doc(alias = "XK_Wcircumflex")]
    pub const Wcircumflex: Keysym = Keysym(key::Wcircumflex);
    #[doc(alias = "XK_wcircumflex")]
    pub const wcircumflex: Keysym = Keysym(key::wcircumflex);
    #[doc(alias = "XK_Ycircumflex")]
    pub const Ycircumflex: Keysym = Keysym(key::Ycircumflex);
    #[doc(alias = "XK_ycircumflex")]
    pub const ycircumflex: Keysym = Keysym(key::ycircumflex);
    #[doc(alias = "XK_Babovedot")]
    pub const Babovedot: Keysym = Keysym(key::Babovedot);
    #[doc(alias = "XK_babovedot")]
    pub const babovedot: Keysym = Keysym(key::babovedot);
    #[doc(alias = "XK_Dabovedot")]
    pub const Dabovedot: Keysym = Keysym(key::Dabovedot);
    #[doc(alias = "XK_dabovedot")]
    pub const dabovedot: Keysym = Keysym(key::dabovedot);
    #[doc(alias = "XK_Fabovedot")]
    pub const Fabovedot: Keysym = Keysym(key::Fabovedot);
    #[doc(alias = "XK_fabovedot")]
    pub const fabovedot: Keysym = Keysym(key::fabovedot);
    #[doc(alias = "XK_Mabovedot")]
    pub const Mabovedot: Keysym = Keysym(key::Mabovedot);
    #[doc(alias = "XK_mabovedot")]
    pub const mabovedot: Keysym = Keysym(key::mabovedot);
    #[doc(alias = "XK_Pabovedot")]
    pub const Pabovedot: Keysym = Keysym(key::Pabovedot);
    #[doc(alias = "XK_pabovedot")]
    pub const pabovedot: Keysym = Keysym(key::pabovedot);
    #[doc(alias = "XK_Sabovedot")]
    pub const Sabovedot: Keysym = Keysym(key::Sabovedot);
    #[doc(alias = "XK_sabovedot")]
    pub const sabovedot: Keysym = Keysym(key::sabovedot);
    #[doc(alias = "XK_Tabovedot")]
    pub const Tabovedot: Keysym = Keysym(key::Tabovedot);
    #[doc(alias = "XK_tabovedot")]
    pub const tabovedot: Keysym = Keysym(key::tabovedot);
    #[doc(alias = "XK_Wgrave")]
    pub const Wgrave: Keysym = Keysym(key::Wgrave);
    #[doc(alias = "XK_wgrave")]
    pub const wgrave: Keysym = Keysym(key::wgrave);
    #[doc(alias = "XK_Wacute")]
    pub const Wacute: Keysym = Keysym(key::Wacute);
    #[doc(alias = "XK_wacute")]
    pub const wacute: Keysym = Keysym(key::wacute);
    #[doc(alias = "XK_Wdiaeresis")]
    pub const Wdiaeresis: Keysym = Keysym(key::Wdiaeresis);
    #[doc(alias = "XK_wdiaeresis")]
    pub const wdiaeresis: Keysym = Keysym(key::wdiaeresis);
    #[doc(alias = "XK_Ygrave")]
    pub const Ygrave: Keysym = Keysym(key::Ygrave);
    #[doc(alias = "XK_ygrave")]
    pub const ygrave: Keysym = Keysym(key::ygrave);
    #[doc(alias = "XK_OE")]
    pub const OE: Keysym = Keysym(key::OE);
    #[doc(alias = "XK_oe")]
    pub const oe: Keysym = Keysym(key::oe);
    #[doc(alias = "XK_Ydiaeresis")]
    pub const Ydiaeresis: Keysym = Keysym(key::Ydiaeresis);
    #[doc(alias = "XK_overline")]
    pub const overline: Keysym = Keysym(key::overline);
    #[doc(alias = "XK_kana_fullstop")]
    pub const kana_fullstop: Keysym = Keysym(key::kana_fullstop);
    #[doc(alias = "XK_kana_openingbracket")]
    pub const kana_openingbracket: Keysym = Keysym(key::kana_openingbracket);
    #[doc(alias = "XK_kana_closingbracket")]
    pub const kana_closingbracket: Keysym = Keysym(key::kana_closingbracket);
    #[doc(alias = "XK_kana_comma")]
    pub const kana_comma: Keysym = Keysym(key::kana_comma);
    #[doc(alias = "XK_kana_conjunctive")]
    pub const kana_conjunctive: Keysym = Keysym(key::kana_conjunctive);
    #[doc(alias = "XK_kana_middledot")]
    pub const kana_middledot: Keysym = Keysym(key::kana_middledot);
    #[doc(alias = "XK_kana_WO")]
    pub const kana_WO: Keysym = Keysym(key::kana_WO);
    #[doc(alias = "XK_kana_a")]
    pub const kana_a: Keysym = Keysym(key::kana_a);
    #[doc(alias = "XK_kana_i")]
    pub const kana_i: Keysym = Keysym(key::kana_i);
    #[doc(alias = "XK_kana_u")]
    pub const kana_u: Keysym = Keysym(key::kana_u);
    #[doc(alias = "XK_kana_e")]
    pub const kana_e: Keysym = Keysym(key::kana_e);
    #[doc(alias = "XK_kana_o")]
    pub const kana_o: Keysym = Keysym(key::kana_o);
    #[doc(alias = "XK_kana_ya")]
    pub const kana_ya: Keysym = Keysym(key::kana_ya);
    #[doc(alias = "XK_kana_yu")]
    pub const kana_yu: Keysym = Keysym(key::kana_yu);
    #[doc(alias = "XK_kana_yo")]
    pub const kana_yo: Keysym = Keysym(key::kana_yo);
    #[doc(alias = "XK_kana_tsu")]
    pub const kana_tsu: Keysym = Keysym(key::kana_tsu);
    #[doc(alias = "XK_kana_tu")]
    pub const kana_tu: Keysym = Keysym(key::kana_tu);
    #[doc(alias = "XK_prolongedsound")]
    pub const prolongedsound: Keysym = Keysym(key::prolongedsound);
    #[doc(alias = "XK_kana_A")]
    pub const kana_A: Keysym = Keysym(key::kana_A);
    #[doc(alias = "XK_kana_I")]
    pub const kana_I: Keysym = Keysym(key::kana_I);
    #[doc(alias = "XK_kana_U")]
    pub const kana_U: Keysym = Keysym(key::kana_U);
    #[doc(alias = "XK_kana_E")]
    pub const kana_E: Keysym = Keysym(key::kana_E);
    #[doc(alias = "XK_kana_O")]
    pub const kana_O: Keysym = Keysym(key::kana_O);
    #[doc(alias = "XK_kana_KA")]
    pub const kana_KA: Keysym = Keysym(key::kana_KA);
    #[doc(alias = "XK_kana_KI")]
    pub const kana_KI: Keysym = Keysym(key::kana_KI);
    #[doc(alias = "XK_kana_KU")]
    pub const kana_KU: Keysym = Keysym(key::kana_KU);
    #[doc(alias = "XK_kana_KE")]
    pub const kana_KE: Keysym = Keysym(key::kana_KE);
    #[doc(alias = "XK_kana_KO")]
    pub const kana_KO: Keysym = Keysym(key::kana_KO);
    #[doc(alias = "XK_kana_SA")]
    pub const kana_SA: Keysym = Keysym(key::kana_SA);
    #[doc(alias = "XK_kana_SHI")]
    pub const kana_SHI: Keysym = Keysym(key::kana_SHI);
    #[doc(alias = "XK_kana_SU")]
    pub const kana_SU: Keysym = Keysym(key::kana_SU);
    #[doc(alias = "XK_kana_SE")]
    pub const kana_SE: Keysym = Keysym(key::kana_SE);
    #[doc(alias = "XK_kana_SO")]
    pub const kana_SO: Keysym = Keysym(key::kana_SO);
    #[doc(alias = "XK_kana_TA")]
    pub const kana_TA: Keysym = Keysym(key::kana_TA);
    #[doc(alias = "XK_kana_CHI")]
    pub const kana_CHI: Keysym = Keysym(key::kana_CHI);
    #[doc(alias = "XK_kana_TI")]
    pub const kana_TI: Keysym = Keysym(key::kana_TI);
    #[doc(alias = "XK_kana_TSU")]
    pub const kana_TSU: Keysym = Keysym(key::kana_TSU);
    #[doc(alias = "XK_kana_TU")]
    pub const kana_TU: Keysym = Keysym(key::kana_TU);
    #[doc(alias = "XK_kana_TE")]
    pub const kana_TE: Keysym = Keysym(key::kana_TE);
    #[doc(alias = "XK_kana_TO")]
    pub const kana_TO: Keysym = Keysym(key::kana_TO);
    #[doc(alias = "XK_kana_NA")]
    pub const kana_NA: Keysym = Keysym(key::kana_NA);
    #[doc(alias = "XK_kana_NI")]
    pub const kana_NI: Keysym = Keysym(key::kana_NI);
    #[doc(alias = "XK_kana_NU")]
    pub const kana_NU: Keysym = Keysym(key::kana_NU);
    #[doc(alias = "XK_kana_NE")]
    pub const kana_NE: Keysym = Keysym(key::kana_NE);
    #[doc(alias = "XK_kana_NO")]
    pub const kana_NO: Keysym = Keysym(key::kana_NO);
    #[doc(alias = "XK_kana_HA")]
    pub const kana_HA: Keysym = Keysym(key::kana_HA);
    #[doc(alias = "XK_kana_HI")]
    pub const kana_HI: Keysym = Keysym(key::kana_HI);
    #[doc(alias = "XK_kana_FU")]
    pub const kana_FU: Keysym = Keysym(key::kana_FU);
    #[doc(alias = "XK_kana_HU")]
    pub const kana_HU: Keysym = Keysym(key::kana_HU);
    #[doc(alias = "XK_kana_HE")]
    pub const kana_HE: Keysym = Keysym(key::kana_HE);
    #[doc(alias = "XK_kana_HO")]
    pub const kana_HO: Keysym = Keysym(key::kana_HO);
    #[doc(alias = "XK_kana_MA")]
    pub const kana_MA: Keysym = Keysym(key::kana_MA);
    #[doc(alias = "XK_kana_MI")]
    pub const kana_MI: Keysym = Keysym(key::kana_MI);
    #[doc(alias = "XK_kana_MU")]
    pub const kana_MU: Keysym = Keysym(key::kana_MU);
    #[doc(alias = "XK_kana_ME")]
    pub const kana_ME: Keysym = Keysym(key::kana_ME);
    #[doc(alias = "XK_kana_MO")]
    pub const kana_MO: Keysym = Keysym(key::kana_MO);
    #[doc(alias = "XK_kana_YA")]
    pub const kana_YA: Keysym = Keysym(key::kana_YA);
    #[doc(alias = "XK_kana_YU")]
    pub const kana_YU: Keysym = Keysym(key::kana_YU);
    #[doc(alias = "XK_kana_YO")]
    pub const kana_YO: Keysym = Keysym(key::kana_YO);
    #[doc(alias = "XK_kana_RA")]
    pub const kana_RA: Keysym = Keysym(key::kana_RA);
    #[doc(alias = "XK_kana_RI")]
    pub const kana_RI: Keysym = Keysym(key::kana_RI);
    #[doc(alias = "XK_kana_RU")]
    pub const kana_RU: Keysym = Keysym(key::kana_RU);
    #[doc(alias = "XK_kana_RE")]
    pub const kana_RE: Keysym = Keysym(key::kana_RE);
    #[doc(alias = "XK_kana_RO")]
    pub const kana_RO: Keysym = Keysym(key::kana_RO);
    #[doc(alias = "XK_kana_WA")]
    pub const kana_WA: Keysym = Keysym(key::kana_WA);
    #[doc(alias = "XK_kana_N")]
    pub const kana_N: Keysym = Keysym(key::kana_N);
    #[doc(alias = "XK_voicedsound")]
    pub const voicedsound: Keysym = Keysym(key::voicedsound);
    #[doc(alias = "XK_semivoicedsound")]
    pub const semivoicedsound: Keysym = Keysym(key::semivoicedsound);
    #[doc(alias = "XK_kana_switch")]
    pub const kana_switch: Keysym = Keysym(key::kana_switch);
    #[doc(alias = "XK_Farsi_0")]
    pub const Farsi_0: Keysym = Keysym(key::Farsi_0);
    #[doc(alias = "XK_Farsi_1")]
    pub const Farsi_1: Keysym = Keysym(key::Farsi_1);
    #[doc(alias = "XK_Farsi_2")]
    pub const Farsi_2: Keysym = Keysym(key::Farsi_2);
    #[doc(alias = "XK_Farsi_3")]
    pub const Farsi_3: Keysym = Keysym(key::Farsi_3);
    #[doc(alias = "XK_Farsi_4")]
    pub const Farsi_4: Keysym = Keysym(key::Farsi_4);
    #[doc(alias = "XK_Farsi_5")]
    pub const Farsi_5: Keysym = Keysym(key::Farsi_5);
    #[doc(alias = "XK_Farsi_6")]
    pub const Farsi_6: Keysym = Keysym(key::Farsi_6);
    #[doc(alias = "XK_Farsi_7")]
    pub const Farsi_7: Keysym = Keysym(key::Farsi_7);
    #[doc(alias = "XK_Farsi_8")]
    pub const Farsi_8: Keysym = Keysym(key::Farsi_8);
    #[doc(alias = "XK_Farsi_9")]
    pub const Farsi_9: Keysym = Keysym(key::Farsi_9);
    #[doc(alias = "XK_Arabic_percent")]
    pub const Arabic_percent: Keysym = Keysym(key::Arabic_percent);
    #[doc(alias = "XK_Arabic_superscript_alef")]
    pub const Arabic_superscript_alef: Keysym = Keysym(key::Arabic_superscript_alef);
    #[doc(alias = "XK_Arabic_tteh")]
    pub const Arabic_tteh: Keysym = Keysym(key::Arabic_tteh);
    #[doc(alias = "XK_Arabic_peh")]
    pub const Arabic_peh: Keysym = Keysym(key::Arabic_peh);
    #[doc(alias = "XK_Arabic_tcheh")]
    pub const Arabic_tcheh: Keysym = Keysym(key::Arabic_tcheh);
    #[doc(alias = "XK_Arabic_ddal")]
    pub const Arabic_ddal: Keysym = Keysym(key::Arabic_ddal);
    #[doc(alias = "XK_Arabic_rreh")]
    pub const Arabic_rreh: Keysym = Keysym(key::Arabic_rreh);
    #[doc(alias = "XK_Arabic_comma")]
    pub const Arabic_comma: Keysym = Keysym(key::Arabic_comma);
    #[doc(alias = "XK_Arabic_fullstop")]
    pub const Arabic_fullstop: Keysym = Keysym(key::Arabic_fullstop);
    #[doc(alias = "XK_Arabic_0")]
    pub const Arabic_0: Keysym = Keysym(key::Arabic_0);
    #[doc(alias = "XK_Arabic_1")]
    pub const Arabic_1: Keysym = Keysym(key::Arabic_1);
    #[doc(alias = "XK_Arabic_2")]
    pub const Arabic_2: Keysym = Keysym(key::Arabic_2);
    #[doc(alias = "XK_Arabic_3")]
    pub const Arabic_3: Keysym = Keysym(key::Arabic_3);
    #[doc(alias = "XK_Arabic_4")]
    pub const Arabic_4: Keysym = Keysym(key::Arabic_4);
    #[doc(alias = "XK_Arabic_5")]
    pub const Arabic_5: Keysym = Keysym(key::Arabic_5);
    #[doc(alias = "XK_Arabic_6")]
    pub const Arabic_6: Keysym = Keysym(key::Arabic_6);
    #[doc(alias = "XK_Arabic_7")]
    pub const Arabic_7: Keysym = Keysym(key::Arabic_7);
    #[doc(alias = "XK_Arabic_8")]
    pub const Arabic_8: Keysym = Keysym(key::Arabic_8);
    #[doc(alias = "XK_Arabic_9")]
    pub const Arabic_9: Keysym = Keysym(key::Arabic_9);
    #[doc(alias = "XK_Arabic_semicolon")]
    pub const Arabic_semicolon: Keysym = Keysym(key::Arabic_semicolon);
    #[doc(alias = "XK_Arabic_question_mark")]
    pub const Arabic_question_mark: Keysym = Keysym(key::Arabic_question_mark);
    #[doc(alias = "XK_Arabic_hamza")]
    pub const Arabic_hamza: Keysym = Keysym(key::Arabic_hamza);
    #[doc(alias = "XK_Arabic_maddaonalef")]
    pub const Arabic_maddaonalef: Keysym = Keysym(key::Arabic_maddaonalef);
    #[doc(alias = "XK_Arabic_hamzaonalef")]
    pub const Arabic_hamzaonalef: Keysym = Keysym(key::Arabic_hamzaonalef);
    #[doc(alias = "XK_Arabic_hamzaonwaw")]
    pub const Arabic_hamzaonwaw: Keysym = Keysym(key::Arabic_hamzaonwaw);
    #[doc(alias = "XK_Arabic_hamzaunderalef")]
    pub const Arabic_hamzaunderalef: Keysym = Keysym(key::Arabic_hamzaunderalef);
    #[doc(alias = "XK_Arabic_hamzaonyeh")]
    pub const Arabic_hamzaonyeh: Keysym = Keysym(key::Arabic_hamzaonyeh);
    #[doc(alias = "XK_Arabic_alef")]
    pub const Arabic_alef: Keysym = Keysym(key::Arabic_alef);
    #[doc(alias = "XK_Arabic_beh")]
    pub const Arabic_beh: Keysym = Keysym(key::Arabic_beh);
    #[doc(alias = "XK_Arabic_tehmarbuta")]
    pub const Arabic_tehmarbuta: Keysym = Keysym(key::Arabic_tehmarbuta);
    #[doc(alias = "XK_Arabic_teh")]
    pub const Arabic_teh: Keysym = Keysym(key::Arabic_teh);
    #[doc(alias = "XK_Arabic_theh")]
    pub const Arabic_theh: Keysym = Keysym(key::Arabic_theh);
    #[doc(alias = "XK_Arabic_jeem")]
    pub const Arabic_jeem: Keysym = Keysym(key::Arabic_jeem);
    #[doc(alias = "XK_Arabic_hah")]
    pub const Arabic_hah: Keysym = Keysym(key::Arabic_hah);
    #[doc(alias = "XK_Arabic_khah")]
    pub const Arabic_khah: Keysym = Keysym(key::Arabic_khah);
    #[doc(alias = "XK_Arabic_dal")]
    pub const Arabic_dal: Keysym = Keysym(key::Arabic_dal);
    #[doc(alias = "XK_Arabic_thal")]
    pub const Arabic_thal: Keysym = Keysym(key::Arabic_thal);
    #[doc(alias = "XK_Arabic_ra")]
    pub const Arabic_ra: Keysym = Keysym(key::Arabic_ra);
    #[doc(alias = "XK_Arabic_zain")]
    pub const Arabic_zain: Keysym = Keysym(key::Arabic_zain);
    #[doc(alias = "XK_Arabic_seen")]
    pub const Arabic_seen: Keysym = Keysym(key::Arabic_seen);
    #[doc(alias = "XK_Arabic_sheen")]
    pub const Arabic_sheen: Keysym = Keysym(key::Arabic_sheen);
    #[doc(alias = "XK_Arabic_sad")]
    pub const Arabic_sad: Keysym = Keysym(key::Arabic_sad);
    #[doc(alias = "XK_Arabic_dad")]
    pub const Arabic_dad: Keysym = Keysym(key::Arabic_dad);
    #[doc(alias = "XK_Arabic_tah")]
    pub const Arabic_tah: Keysym = Keysym(key::Arabic_tah);
    #[doc(alias = "XK_Arabic_zah")]
    pub const Arabic_zah: Keysym = Keysym(key::Arabic_zah);
    #[doc(alias = "XK_Arabic_ain")]
    pub const Arabic_ain: Keysym = Keysym(key::Arabic_ain);
    #[doc(alias = "XK_Arabic_ghain")]
    pub const Arabic_ghain: Keysym = Keysym(key::Arabic_ghain);
    #[doc(alias = "XK_Arabic_tatweel")]
    pub const Arabic_tatweel: Keysym = Keysym(key::Arabic_tatweel);
    #[doc(alias = "XK_Arabic_feh")]
    pub const Arabic_feh: Keysym = Keysym(key::Arabic_feh);
    #[doc(alias = "XK_Arabic_qaf")]
    pub const Arabic_qaf: Keysym = Keysym(key::Arabic_qaf);
    #[doc(alias = "XK_Arabic_kaf")]
    pub const Arabic_kaf: Keysym = Keysym(key::Arabic_kaf);
    #[doc(alias = "XK_Arabic_lam")]
    pub const Arabic_lam: Keysym = Keysym(key::Arabic_lam);
    #[doc(alias = "XK_Arabic_meem")]
    pub const Arabic_meem: Keysym = Keysym(key::Arabic_meem);
    #[doc(alias = "XK_Arabic_noon")]
    pub const Arabic_noon: Keysym = Keysym(key::Arabic_noon);
    #[doc(alias = "XK_Arabic_ha")]
    pub const Arabic_ha: Keysym = Keysym(key::Arabic_ha);
    #[doc(alias = "XK_Arabic_heh")]
    pub const Arabic_heh: Keysym = Keysym(key::Arabic_heh);
    #[doc(alias = "XK_Arabic_waw")]
    pub const Arabic_waw: Keysym = Keysym(key::Arabic_waw);
    #[doc(alias = "XK_Arabic_alefmaksura")]
    pub const Arabic_alefmaksura: Keysym = Keysym(key::Arabic_alefmaksura);
    #[doc(alias = "XK_Arabic_yeh")]
    pub const Arabic_yeh: Keysym = Keysym(key::Arabic_yeh);
    #[doc(alias = "XK_Arabic_fathatan")]
    pub const Arabic_fathatan: Keysym = Keysym(key::Arabic_fathatan);
    #[doc(alias = "XK_Arabic_dammatan")]
    pub const Arabic_dammatan: Keysym = Keysym(key::Arabic_dammatan);
    #[doc(alias = "XK_Arabic_kasratan")]
    pub const Arabic_kasratan: Keysym = Keysym(key::Arabic_kasratan);
    #[doc(alias = "XK_Arabic_fatha")]
    pub const Arabic_fatha: Keysym = Keysym(key::Arabic_fatha);
    #[doc(alias = "XK_Arabic_damma")]
    pub const Arabic_damma: Keysym = Keysym(key::Arabic_damma);
    #[doc(alias = "XK_Arabic_kasra")]
    pub const Arabic_kasra: Keysym = Keysym(key::Arabic_kasra);
    #[doc(alias = "XK_Arabic_shadda")]
    pub const Arabic_shadda: Keysym = Keysym(key::Arabic_shadda);
    #[doc(alias = "XK_Arabic_sukun")]
    pub const Arabic_sukun: Keysym = Keysym(key::Arabic_sukun);
    #[doc(alias = "XK_Arabic_madda_above")]
    pub const Arabic_madda_above: Keysym = Keysym(key::Arabic_madda_above);
    #[doc(alias = "XK_Arabic_hamza_above")]
    pub const Arabic_hamza_above: Keysym = Keysym(key::Arabic_hamza_above);
    #[doc(alias = "XK_Arabic_hamza_below")]
    pub const Arabic_hamza_below: Keysym = Keysym(key::Arabic_hamza_below);
    #[doc(alias = "XK_Arabic_jeh")]
    pub const Arabic_jeh: Keysym = Keysym(key::Arabic_jeh);
    #[doc(alias = "XK_Arabic_veh")]
    pub const Arabic_veh: Keysym = Keysym(key::Arabic_veh);
    #[doc(alias = "XK_Arabic_keheh")]
    pub const Arabic_keheh: Keysym = Keysym(key::Arabic_keheh);
    #[doc(alias = "XK_Arabic_gaf")]
    pub const Arabic_gaf: Keysym = Keysym(key::Arabic_gaf);
    #[doc(alias = "XK_Arabic_noon_ghunna")]
    pub const Arabic_noon_ghunna: Keysym = Keysym(key::Arabic_noon_ghunna);
    #[doc(alias = "XK_Arabic_heh_doachashmee")]
    pub const Arabic_heh_doachashmee: Keysym = Keysym(key::Arabic_heh_doachashmee);
    #[doc(alias = "XK_Farsi_yeh")]
    pub const Farsi_yeh: Keysym = Keysym(key::Farsi_yeh);
    #[doc(alias = "XK_Arabic_farsi_yeh")]
    pub const Arabic_farsi_yeh: Keysym = Keysym(key::Arabic_farsi_yeh);
    #[doc(alias = "XK_Arabic_yeh_baree")]
    pub const Arabic_yeh_baree: Keysym = Keysym(key::Arabic_yeh_baree);
    #[doc(alias = "XK_Arabic_heh_goal")]
    pub const Arabic_heh_goal: Keysym = Keysym(key::Arabic_heh_goal);
    #[doc(alias = "XK_Arabic_switch")]
    pub const Arabic_switch: Keysym = Keysym(key::Arabic_switch);
    #[doc(alias = "XK_Cyrillic_GHE_bar")]
    pub const Cyrillic_GHE_bar: Keysym = Keysym(key::Cyrillic_GHE_bar);
    #[doc(alias = "XK_Cyrillic_ghe_bar")]
    pub const Cyrillic_ghe_bar: Keysym = Keysym(key::Cyrillic_ghe_bar);
    #[doc(alias = "XK_Cyrillic_ZHE_descender")]
    pub const Cyrillic_ZHE_descender: Keysym = Keysym(key::Cyrillic_ZHE_descender);
    #[doc(alias = "XK_Cyrillic_zhe_descender")]
    pub const Cyrillic_zhe_descender: Keysym = Keysym(key::Cyrillic_zhe_descender);
    #[doc(alias = "XK_Cyrillic_KA_descender")]
    pub const Cyrillic_KA_descender: Keysym = Keysym(key::Cyrillic_KA_descender);
    #[doc(alias = "XK_Cyrillic_ka_descender")]
    pub const Cyrillic_ka_descender: Keysym = Keysym(key::Cyrillic_ka_descender);
    #[doc(alias = "XK_Cyrillic_KA_vertstroke")]
    pub const Cyrillic_KA_vertstroke: Keysym = Keysym(key::Cyrillic_KA_vertstroke);
    #[doc(alias = "XK_Cyrillic_ka_vertstroke")]
    pub const Cyrillic_ka_vertstroke: Keysym = Keysym(key::Cyrillic_ka_vertstroke);
    #[doc(alias = "XK_Cyrillic_EN_descender")]
    pub const Cyrillic_EN_descender: Keysym = Keysym(key::Cyrillic_EN_descender);
    #[doc(alias = "XK_Cyrillic_en_descender")]
    pub const Cyrillic_en_descender: Keysym = Keysym(key::Cyrillic_en_descender);
    #[doc(alias = "XK_Cyrillic_U_straight")]
    pub const Cyrillic_U_straight: Keysym = Keysym(key::Cyrillic_U_straight);
    #[doc(alias = "XK_Cyrillic_u_straight")]
    pub const Cyrillic_u_straight: Keysym = Keysym(key::Cyrillic_u_straight);
    #[doc(alias = "XK_Cyrillic_U_straight_bar")]
    pub const Cyrillic_U_straight_bar: Keysym = Keysym(key::Cyrillic_U_straight_bar);
    #[doc(alias = "XK_Cyrillic_u_straight_bar")]
    pub const Cyrillic_u_straight_bar: Keysym = Keysym(key::Cyrillic_u_straight_bar);
    #[doc(alias = "XK_Cyrillic_HA_descender")]
    pub const Cyrillic_HA_descender: Keysym = Keysym(key::Cyrillic_HA_descender);
    #[doc(alias = "XK_Cyrillic_ha_descender")]
    pub const Cyrillic_ha_descender: Keysym = Keysym(key::Cyrillic_ha_descender);
    #[doc(alias = "XK_Cyrillic_CHE_descender")]
    pub const Cyrillic_CHE_descender: Keysym = Keysym(key::Cyrillic_CHE_descender);
    #[doc(alias = "XK_Cyrillic_che_descender")]
    pub const Cyrillic_che_descender: Keysym = Keysym(key::Cyrillic_che_descender);
    #[doc(alias = "XK_Cyrillic_CHE_vertstroke")]
    pub const Cyrillic_CHE_vertstroke: Keysym = Keysym(key::Cyrillic_CHE_vertstroke);
    #[doc(alias = "XK_Cyrillic_che_vertstroke")]
    pub const Cyrillic_che_vertstroke: Keysym = Keysym(key::Cyrillic_che_vertstroke);
    #[doc(alias = "XK_Cyrillic_SHHA")]
    pub const Cyrillic_SHHA: Keysym = Keysym(key::Cyrillic_SHHA);
    #[doc(alias = "XK_Cyrillic_shha")]
    pub const Cyrillic_shha: Keysym = Keysym(key::Cyrillic_shha);
    #[doc(alias = "XK_Cyrillic_SCHWA")]
    pub const Cyrillic_SCHWA: Keysym = Keysym(key::Cyrillic_SCHWA);
    #[doc(alias = "XK_Cyrillic_schwa")]
    pub const Cyrillic_schwa: Keysym = Keysym(key::Cyrillic_schwa);
    #[doc(alias = "XK_Cyrillic_I_macron")]
    pub const Cyrillic_I_macron: Keysym = Keysym(key::Cyrillic_I_macron);
    #[doc(alias = "XK_Cyrillic_i_macron")]
    pub const Cyrillic_i_macron: Keysym = Keysym(key::Cyrillic_i_macron);
    #[doc(alias = "XK_Cyrillic_O_bar")]
    pub const Cyrillic_O_bar: Keysym = Keysym(key::Cyrillic_O_bar);
    #[doc(alias = "XK_Cyrillic_o_bar")]
    pub const Cyrillic_o_bar: Keysym = Keysym(key::Cyrillic_o_bar);
    #[doc(alias = "XK_Cyrillic_U_macron")]
    pub const Cyrillic_U_macron: Keysym = Keysym(key::Cyrillic_U_macron);
    #[doc(alias = "XK_Cyrillic_u_macron")]
    pub const Cyrillic_u_macron: Keysym = Keysym(key::Cyrillic_u_macron);
    #[doc(alias = "XK_Serbian_dje")]
    pub const Serbian_dje: Keysym = Keysym(key::Serbian_dje);
    #[doc(alias = "XK_Macedonia_gje")]
    pub const Macedonia_gje: Keysym = Keysym(key::Macedonia_gje);
    #[doc(alias = "XK_Cyrillic_io")]
    pub const Cyrillic_io: Keysym = Keysym(key::Cyrillic_io);
    #[doc(alias = "XK_Ukrainian_ie")]
    pub const Ukrainian_ie: Keysym = Keysym(key::Ukrainian_ie);
    #[doc(alias = "XK_Ukranian_je")]
    pub const Ukranian_je: Keysym = Keysym(key::Ukranian_je);
    #[doc(alias = "XK_Macedonia_dse")]
    pub const Macedonia_dse: Keysym = Keysym(key::Macedonia_dse);
    #[doc(alias = "XK_Ukrainian_i")]
    pub const Ukrainian_i: Keysym = Keysym(key::Ukrainian_i);
    #[doc(alias = "XK_Ukranian_i")]
    pub const Ukranian_i: Keysym = Keysym(key::Ukranian_i);
    #[doc(alias = "XK_Ukrainian_yi")]
    pub const Ukrainian_yi: Keysym = Keysym(key::Ukrainian_yi);
    #[doc(alias = "XK_Ukranian_yi")]
    pub const Ukranian_yi: Keysym = Keysym(key::Ukranian_yi);
    #[doc(alias = "XK_Cyrillic_je")]
    pub const Cyrillic_je: Keysym = Keysym(key::Cyrillic_je);
    #[doc(alias = "XK_Serbian_je")]
    pub const Serbian_je: Keysym = Keysym(key::Serbian_je);
    #[doc(alias = "XK_Cyrillic_lje")]
    pub const Cyrillic_lje: Keysym = Keysym(key::Cyrillic_lje);
    #[doc(alias = "XK_Serbian_lje")]
    pub const Serbian_lje: Keysym = Keysym(key::Serbian_lje);
    #[doc(alias = "XK_Cyrillic_nje")]
    pub const Cyrillic_nje: Keysym = Keysym(key::Cyrillic_nje);
    #[doc(alias = "XK_Serbian_nje")]
    pub const Serbian_nje: Keysym = Keysym(key::Serbian_nje);
    #[doc(alias = "XK_Serbian_tshe")]
    pub const Serbian_tshe: Keysym = Keysym(key::Serbian_tshe);
    #[doc(alias = "XK_Macedonia_kje")]
    pub const Macedonia_kje: Keysym = Keysym(key::Macedonia_kje);
    #[doc(alias = "XK_Ukrainian_ghe_with_upturn")]
    pub const Ukrainian_ghe_with_upturn: Keysym = Keysym(key::Ukrainian_ghe_with_upturn);
    #[doc(alias = "XK_Byelorussian_shortu")]
    pub const Byelorussian_shortu: Keysym = Keysym(key::Byelorussian_shortu);
    #[doc(alias = "XK_Cyrillic_dzhe")]
    pub const Cyrillic_dzhe: Keysym = Keysym(key::Cyrillic_dzhe);
    #[doc(alias = "XK_Serbian_dze")]
    pub const Serbian_dze: Keysym = Keysym(key::Serbian_dze);
    #[doc(alias = "XK_numerosign")]
    pub const numerosign: Keysym = Keysym(key::numerosign);
    #[doc(alias = "XK_Serbian_DJE")]
    pub const Serbian_DJE: Keysym = Keysym(key::Serbian_DJE);
    #[doc(alias = "XK_Macedonia_GJE")]
    pub const Macedonia_GJE: Keysym = Keysym(key::Macedonia_GJE);
    #[doc(alias = "XK_Cyrillic_IO")]
    pub const Cyrillic_IO: Keysym = Keysym(key::Cyrillic_IO);
    #[doc(alias = "XK_Ukrainian_IE")]
    pub const Ukrainian_IE: Keysym = Keysym(key::Ukrainian_IE);
    #[doc(alias = "XK_Ukranian_JE")]
    pub const Ukranian_JE: Keysym = Keysym(key::Ukranian_JE);
    #[doc(alias = "XK_Macedonia_DSE")]
    pub const Macedonia_DSE: Keysym = Keysym(key::Macedonia_DSE);
    #[doc(alias = "XK_Ukrainian_I")]
    pub const Ukrainian_I: Keysym = Keysym(key::Ukrainian_I);
    #[doc(alias = "XK_Ukranian_I")]
    pub const Ukranian_I: Keysym = Keysym(key::Ukranian_I);
    #[doc(alias = "XK_Ukrainian_YI")]
    pub const Ukrainian_YI: Keysym = Keysym(key::Ukrainian_YI);
    #[doc(alias = "XK_Ukranian_YI")]
    pub const Ukranian_YI: Keysym = Keysym(key::Ukranian_YI);
    #[doc(alias = "XK_Cyrillic_JE")]
    pub const Cyrillic_JE: Keysym = Keysym(key::Cyrillic_JE);
    #[doc(alias = "XK_Serbian_JE")]
    pub const Serbian_JE: Keysym = Keysym(key::Serbian_JE);
    #[doc(alias = "XK_Cyrillic_LJE")]
    pub const Cyrillic_LJE: Keysym = Keysym(key::Cyrillic_LJE);
    #[doc(alias = "XK_Serbian_LJE")]
    pub const Serbian_LJE: Keysym = Keysym(key::Serbian_LJE);
    #[doc(alias = "XK_Cyrillic_NJE")]
    pub const Cyrillic_NJE: Keysym = Keysym(key::Cyrillic_NJE);
    #[doc(alias = "XK_Serbian_NJE")]
    pub const Serbian_NJE: Keysym = Keysym(key::Serbian_NJE);
    #[doc(alias = "XK_Serbian_TSHE")]
    pub const Serbian_TSHE: Keysym = Keysym(key::Serbian_TSHE);
    #[doc(alias = "XK_Macedonia_KJE")]
    pub const Macedonia_KJE: Keysym = Keysym(key::Macedonia_KJE);
    #[doc(alias = "XK_Ukrainian_GHE_WITH_UPTURN")]
    pub const Ukrainian_GHE_WITH_UPTURN: Keysym = Keysym(key::Ukrainian_GHE_WITH_UPTURN);
    #[doc(alias = "XK_Byelorussian_SHORTU")]
    pub const Byelorussian_SHORTU: Keysym = Keysym(key::Byelorussian_SHORTU);
    #[doc(alias = "XK_Cyrillic_DZHE")]
    pub const Cyrillic_DZHE: Keysym = Keysym(key::Cyrillic_DZHE);
    #[doc(alias = "XK_Serbian_DZE")]
    pub const Serbian_DZE: Keysym = Keysym(key::Serbian_DZE);
    #[doc(alias = "XK_Cyrillic_yu")]
    pub const Cyrillic_yu: Keysym = Keysym(key::Cyrillic_yu);
    #[doc(alias = "XK_Cyrillic_a")]
    pub const Cyrillic_a: Keysym = Keysym(key::Cyrillic_a);
    #[doc(alias = "XK_Cyrillic_be")]
    pub const Cyrillic_be: Keysym = Keysym(key::Cyrillic_be);
    #[doc(alias = "XK_Cyrillic_tse")]
    pub const Cyrillic_tse: Keysym = Keysym(key::Cyrillic_tse);
    #[doc(alias = "XK_Cyrillic_de")]
    pub const Cyrillic_de: Keysym = Keysym(key::Cyrillic_de);
    #[doc(alias = "XK_Cyrillic_ie")]
    pub const Cyrillic_ie: Keysym = Keysym(key::Cyrillic_ie);
    #[doc(alias = "XK_Cyrillic_ef")]
    pub const Cyrillic_ef: Keysym = Keysym(key::Cyrillic_ef);
    #[doc(alias = "XK_Cyrillic_ghe")]
    pub const Cyrillic_ghe: Keysym = Keysym(key::Cyrillic_ghe);
    #[doc(alias = "XK_Cyrillic_ha")]
    pub const Cyrillic_ha: Keysym = Keysym(key::Cyrillic_ha);
    #[doc(alias = "XK_Cyrillic_i")]
    pub const Cyrillic_i: Keysym = Keysym(key::Cyrillic_i);
    #[doc(alias = "XK_Cyrillic_shorti")]
    pub const Cyrillic_shorti: Keysym = Keysym(key::Cyrillic_shorti);
    #[doc(alias = "XK_Cyrillic_ka")]
    pub const Cyrillic_ka: Keysym = Keysym(key::Cyrillic_ka);
    #[doc(alias = "XK_Cyrillic_el")]
    pub const Cyrillic_el: Keysym = Keysym(key::Cyrillic_el);
    #[doc(alias = "XK_Cyrillic_em")]
    pub const Cyrillic_em: Keysym = Keysym(key::Cyrillic_em);
    #[doc(alias = "XK_Cyrillic_en")]
    pub const Cyrillic_en: Keysym = Keysym(key::Cyrillic_en);
    #[doc(alias = "XK_Cyrillic_o")]
    pub const Cyrillic_o: Keysym = Keysym(key::Cyrillic_o);
    #[doc(alias = "XK_Cyrillic_pe")]
    pub const Cyrillic_pe: Keysym = Keysym(key::Cyrillic_pe);
    #[doc(alias = "XK_Cyrillic_ya")]
    pub const Cyrillic_ya: Keysym = Keysym(key::Cyrillic_ya);
    #[doc(alias = "XK_Cyrillic_er")]
    pub const Cyrillic_er: Keysym = Keysym(key::Cyrillic_er);
    #[doc(alias = "XK_Cyrillic_es")]
    pub const Cyrillic_es: Keysym = Keysym(key::Cyrillic_es);
    #[doc(alias = "XK_Cyrillic_te")]
    pub const Cyrillic_te: Keysym = Keysym(key::Cyrillic_te);
    #[doc(alias = "XK_Cyrillic_u")]
    pub const Cyrillic_u: Keysym = Keysym(key::Cyrillic_u);
    #[doc(alias = "XK_Cyrillic_zhe")]
    pub const Cyrillic_zhe: Keysym = Keysym(key::Cyrillic_zhe);
    #[doc(alias = "XK_Cyrillic_ve")]
    pub const Cyrillic_ve: Keysym = Keysym(key::Cyrillic_ve);
    #[doc(alias = "XK_Cyrillic_softsign")]
    pub const Cyrillic_softsign: Keysym = Keysym(key::Cyrillic_softsign);
    #[doc(alias = "XK_Cyrillic_yeru")]
    pub const Cyrillic_yeru: Keysym = Keysym(key::Cyrillic_yeru);
    #[doc(alias = "XK_Cyrillic_ze")]
    pub const Cyrillic_ze: Keysym = Keysym(key::Cyrillic_ze);
    #[doc(alias = "XK_Cyrillic_sha")]
    pub const Cyrillic_sha: Keysym = Keysym(key::Cyrillic_sha);
    #[doc(alias = "XK_Cyrillic_e")]
    pub const Cyrillic_e: Keysym = Keysym(key::Cyrillic_e);
    #[doc(alias = "XK_Cyrillic_shcha")]
    pub const Cyrillic_shcha: Keysym = Keysym(key::Cyrillic_shcha);
    #[doc(alias = "XK_Cyrillic_che")]
    pub const Cyrillic_che: Keysym = Keysym(key::Cyrillic_che);
    #[doc(alias = "XK_Cyrillic_hardsign")]
    pub const Cyrillic_hardsign: Keysym = Keysym(key::Cyrillic_hardsign);
    #[doc(alias = "XK_Cyrillic_YU")]
    pub const Cyrillic_YU: Keysym = Keysym(key::Cyrillic_YU);
    #[doc(alias = "XK_Cyrillic_A")]
    pub const Cyrillic_A: Keysym = Keysym(key::Cyrillic_A);
    #[doc(alias = "XK_Cyrillic_BE")]
    pub const Cyrillic_BE: Keysym = Keysym(key::Cyrillic_BE);
    #[doc(alias = "XK_Cyrillic_TSE")]
    pub const Cyrillic_TSE: Keysym = Keysym(key::Cyrillic_TSE);
    #[doc(alias = "XK_Cyrillic_DE")]
    pub const Cyrillic_DE: Keysym = Keysym(key::Cyrillic_DE);
    #[doc(alias = "XK_Cyrillic_IE")]
    pub const Cyrillic_IE: Keysym = Keysym(key::Cyrillic_IE);
    #[doc(alias = "XK_Cyrillic_EF")]
    pub const Cyrillic_EF: Keysym = Keysym(key::Cyrillic_EF);
    #[doc(alias = "XK_Cyrillic_GHE")]
    pub const Cyrillic_GHE: Keysym = Keysym(key::Cyrillic_GHE);
    #[doc(alias = "XK_Cyrillic_HA")]
    pub const Cyrillic_HA: Keysym = Keysym(key::Cyrillic_HA);
    #[doc(alias = "XK_Cyrillic_I")]
    pub const Cyrillic_I: Keysym = Keysym(key::Cyrillic_I);
    #[doc(alias = "XK_Cyrillic_SHORTI")]
    pub const Cyrillic_SHORTI: Keysym = Keysym(key::Cyrillic_SHORTI);
    #[doc(alias = "XK_Cyrillic_KA")]
    pub const Cyrillic_KA: Keysym = Keysym(key::Cyrillic_KA);
    #[doc(alias = "XK_Cyrillic_EL")]
    pub const Cyrillic_EL: Keysym = Keysym(key::Cyrillic_EL);
    #[doc(alias = "XK_Cyrillic_EM")]
    pub const Cyrillic_EM: Keysym = Keysym(key::Cyrillic_EM);
    #[doc(alias = "XK_Cyrillic_EN")]
    pub const Cyrillic_EN: Keysym = Keysym(key::Cyrillic_EN);
    #[doc(alias = "XK_Cyrillic_O")]
    pub const Cyrillic_O: Keysym = Keysym(key::Cyrillic_O);
    #[doc(alias = "XK_Cyrillic_PE")]
    pub const Cyrillic_PE: Keysym = Keysym(key::Cyrillic_PE);
    #[doc(alias = "XK_Cyrillic_YA")]
    pub const Cyrillic_YA: Keysym = Keysym(key::Cyrillic_YA);
    #[doc(alias = "XK_Cyrillic_ER")]
    pub const Cyrillic_ER: Keysym = Keysym(key::Cyrillic_ER);
    #[doc(alias = "XK_Cyrillic_ES")]
    pub const Cyrillic_ES: Keysym = Keysym(key::Cyrillic_ES);
    #[doc(alias = "XK_Cyrillic_TE")]
    pub const Cyrillic_TE: Keysym = Keysym(key::Cyrillic_TE);
    #[doc(alias = "XK_Cyrillic_U")]
    pub const Cyrillic_U: Keysym = Keysym(key::Cyrillic_U);
    #[doc(alias = "XK_Cyrillic_ZHE")]
    pub const Cyrillic_ZHE: Keysym = Keysym(key::Cyrillic_ZHE);
    #[doc(alias = "XK_Cyrillic_VE")]
    pub const Cyrillic_VE: Keysym = Keysym(key::Cyrillic_VE);
    #[doc(alias = "XK_Cyrillic_SOFTSIGN")]
    pub const Cyrillic_SOFTSIGN: Keysym = Keysym(key::Cyrillic_SOFTSIGN);
    #[doc(alias = "XK_Cyrillic_YERU")]
    pub const Cyrillic_YERU: Keysym = Keysym(key::Cyrillic_YERU);
    #[doc(alias = "XK_Cyrillic_ZE")]
    pub const Cyrillic_ZE: Keysym = Keysym(key::Cyrillic_ZE);
    #[doc(alias = "XK_Cyrillic_SHA")]
    pub const Cyrillic_SHA: Keysym = Keysym(key::Cyrillic_SHA);
    #[doc(alias = "XK_Cyrillic_E")]
    pub const Cyrillic_E: Keysym = Keysym(key::Cyrillic_E);
    #[doc(alias = "XK_Cyrillic_SHCHA")]
    pub const Cyrillic_SHCHA: Keysym = Keysym(key::Cyrillic_SHCHA);
    #[doc(alias = "XK_Cyrillic_CHE")]
    pub const Cyrillic_CHE: Keysym = Keysym(key::Cyrillic_CHE);
    #[doc(alias = "XK_Cyrillic_HARDSIGN")]
    pub const Cyrillic_HARDSIGN: Keysym = Keysym(key::Cyrillic_HARDSIGN);
    #[doc(alias = "XK_Greek_ALPHAaccent")]
    pub const Greek_ALPHAaccent: Keysym = Keysym(key::Greek_ALPHAaccent);
    #[doc(alias = "XK_Greek_EPSILONaccent")]
    pub const Greek_EPSILONaccent: Keysym = Keysym(key::Greek_EPSILONaccent);
    #[doc(alias = "XK_Greek_ETAaccent")]
    pub const Greek_ETAaccent: Keysym = Keysym(key::Greek_ETAaccent);
    #[doc(alias = "XK_Greek_IOTAaccent")]
    pub const Greek_IOTAaccent: Keysym = Keysym(key::Greek_IOTAaccent);
    #[doc(alias = "XK_Greek_IOTAdieresis")]
    pub const Greek_IOTAdieresis: Keysym = Keysym(key::Greek_IOTAdieresis);
    #[doc(alias = "XK_Greek_IOTAdiaeresis")]
    pub const Greek_IOTAdiaeresis: Keysym = Keysym(key::Greek_IOTAdiaeresis);
    #[doc(alias = "XK_Greek_OMICRONaccent")]
    pub const Greek_OMICRONaccent: Keysym = Keysym(key::Greek_OMICRONaccent);
    #[doc(alias = "XK_Greek_UPSILONaccent")]
    pub const Greek_UPSILONaccent: Keysym = Keysym(key::Greek_UPSILONaccent);
    #[doc(alias = "XK_Greek_UPSILONdieresis")]
    pub const Greek_UPSILONdieresis: Keysym = Keysym(key::Greek_UPSILONdieresis);
    #[doc(alias = "XK_Greek_OMEGAaccent")]
    pub const Greek_OMEGAaccent: Keysym = Keysym(key::Greek_OMEGAaccent);
    #[doc(alias = "XK_Greek_accentdieresis")]
    pub const Greek_accentdieresis: Keysym = Keysym(key::Greek_accentdieresis);
    #[doc(alias = "XK_Greek_horizbar")]
    pub const Greek_horizbar: Keysym = Keysym(key::Greek_horizbar);
    #[doc(alias = "XK_Greek_alphaaccent")]
    pub const Greek_alphaaccent: Keysym = Keysym(key::Greek_alphaaccent);
    #[doc(alias = "XK_Greek_epsilonaccent")]
    pub const Greek_epsilonaccent: Keysym = Keysym(key::Greek_epsilonaccent);
    #[doc(alias = "XK_Greek_etaaccent")]
    pub const Greek_etaaccent: Keysym = Keysym(key::Greek_etaaccent);
    #[doc(alias = "XK_Greek_iotaaccent")]
    pub const Greek_iotaaccent: Keysym = Keysym(key::Greek_iotaaccent);
    #[doc(alias = "XK_Greek_iotadieresis")]
    pub const Greek_iotadieresis: Keysym = Keysym(key::Greek_iotadieresis);
    #[doc(alias = "XK_Greek_iotaaccentdieresis")]
    pub const Greek_iotaaccentdieresis: Keysym = Keysym(key::Greek_iotaaccentdieresis);
    #[doc(alias = "XK_Greek_omicronaccent")]
    pub const Greek_omicronaccent: Keysym = Keysym(key::Greek_omicronaccent);
    #[doc(alias = "XK_Greek_upsilonaccent")]
    pub const Greek_upsilonaccent: Keysym = Keysym(key::Greek_upsilonaccent);
    #[doc(alias = "XK_Greek_upsilondieresis")]
    pub const Greek_upsilondieresis: Keysym = Keysym(key::Greek_upsilondieresis);
    #[doc(alias = "XK_Greek_upsilonaccentdieresis")]
    pub const Greek_upsilonaccentdieresis: Keysym = Keysym(key::Greek_upsilonaccentdieresis);
    #[doc(alias = "XK_Greek_omegaaccent")]
    pub const Greek_omegaaccent: Keysym = Keysym(key::Greek_omegaaccent);
    #[doc(alias = "XK_Greek_ALPHA")]
    pub const Greek_ALPHA: Keysym = Keysym(key::Greek_ALPHA);
    #[doc(alias = "XK_Greek_BETA")]
    pub const Greek_BETA: Keysym = Keysym(key::Greek_BETA);
    #[doc(alias = "XK_Greek_GAMMA")]
    pub const Greek_GAMMA: Keysym = Keysym(key::Greek_GAMMA);
    #[doc(alias = "XK_Greek_DELTA")]
    pub const Greek_DELTA: Keysym = Keysym(key::Greek_DELTA);
    #[doc(alias = "XK_Greek_EPSILON")]
    pub const Greek_EPSILON: Keysym = Keysym(key::Greek_EPSILON);
    #[doc(alias = "XK_Greek_ZETA")]
    pub const Greek_ZETA: Keysym = Keysym(key::Greek_ZETA);
    #[doc(alias = "XK_Greek_ETA")]
    pub const Greek_ETA: Keysym = Keysym(key::Greek_ETA);
    #[doc(alias = "XK_Greek_THETA")]
    pub const Greek_THETA: Keysym = Keysym(key::Greek_THETA);
    #[doc(alias = "XK_Greek_IOTA")]
    pub const Greek_IOTA: Keysym = Keysym(key::Greek_IOTA);
    #[doc(alias = "XK_Greek_KAPPA")]
    pub const Greek_KAPPA: Keysym = Keysym(key::Greek_KAPPA);
    #[doc(alias = "XK_Greek_LAMDA")]
    pub const Greek_LAMDA: Keysym = Keysym(key::Greek_LAMDA);
    #[doc(alias = "XK_Greek_LAMBDA")]
    pub const Greek_LAMBDA: Keysym = Keysym(key::Greek_LAMBDA);
    #[doc(alias = "XK_Greek_MU")]
    pub const Greek_MU: Keysym = Keysym(key::Greek_MU);
    #[doc(alias = "XK_Greek_NU")]
    pub const Greek_NU: Keysym = Keysym(key::Greek_NU);
    #[doc(alias = "XK_Greek_XI")]
    pub const Greek_XI: Keysym = Keysym(key::Greek_XI);
    #[doc(alias = "XK_Greek_OMICRON")]
    pub const Greek_OMICRON: Keysym = Keysym(key::Greek_OMICRON);
    #[doc(alias = "XK_Greek_PI")]
    pub const Greek_PI: Keysym = Keysym(key::Greek_PI);
    #[doc(alias = "XK_Greek_RHO")]
    pub const Greek_RHO: Keysym = Keysym(key::Greek_RHO);
    #[doc(alias = "XK_Greek_SIGMA")]
    pub const Greek_SIGMA: Keysym = Keysym(key::Greek_SIGMA);
    #[doc(alias = "XK_Greek_TAU")]
    pub const Greek_TAU: Keysym = Keysym(key::Greek_TAU);
    #[doc(alias = "XK_Greek_UPSILON")]
    pub const Greek_UPSILON: Keysym = Keysym(key::Greek_UPSILON);
    #[doc(alias = "XK_Greek_PHI")]
    pub const Greek_PHI: Keysym = Keysym(key::Greek_PHI);
    #[doc(alias = "XK_Greek_CHI")]
    pub const Greek_CHI: Keysym = Keysym(key::Greek_CHI);
    #[doc(alias = "XK_Greek_PSI")]
    pub const Greek_PSI: Keysym = Keysym(key::Greek_PSI);
    #[doc(alias = "XK_Greek_OMEGA")]
    pub const Greek_OMEGA: Keysym = Keysym(key::Greek_OMEGA);
    #[doc(alias = "XK_Greek_alpha")]
    pub const Greek_alpha: Keysym = Keysym(key::Greek_alpha);
    #[doc(alias = "XK_Greek_beta")]
    pub const Greek_beta: Keysym = Keysym(key::Greek_beta);
    #[doc(alias = "XK_Greek_gamma")]
    pub const Greek_gamma: Keysym = Keysym(key::Greek_gamma);
    #[doc(alias = "XK_Greek_delta")]
    pub const Greek_delta: Keysym = Keysym(key::Greek_delta);
    #[doc(alias = "XK_Greek_epsilon")]
    pub const Greek_epsilon: Keysym = Keysym(key::Greek_epsilon);
    #[doc(alias = "XK_Greek_zeta")]
    pub const Greek_zeta: Keysym = Keysym(key::Greek_zeta);
    #[doc(alias = "XK_Greek_eta")]
    pub const Greek_eta: Keysym = Keysym(key::Greek_eta);
    #[doc(alias = "XK_Greek_theta")]
    pub const Greek_theta: Keysym = Keysym(key::Greek_theta);
    #[doc(alias = "XK_Greek_iota")]
    pub const Greek_iota: Keysym = Keysym(key::Greek_iota);
    #[doc(alias = "XK_Greek_kappa")]
    pub const Greek_kappa: Keysym = Keysym(key::Greek_kappa);
    #[doc(alias = "XK_Greek_lamda")]
    pub const Greek_lamda: Keysym = Keysym(key::Greek_lamda);
    #[doc(alias = "XK_Greek_lambda")]
    pub const Greek_lambda: Keysym = Keysym(key::Greek_lambda);
    #[doc(alias = "XK_Greek_mu")]
    pub const Greek_mu: Keysym = Keysym(key::Greek_mu);
    #[doc(alias = "XK_Greek_nu")]
    pub const Greek_nu: Keysym = Keysym(key::Greek_nu);
    #[doc(alias = "XK_Greek_xi")]
    pub const Greek_xi: Keysym = Keysym(key::Greek_xi);
    #[doc(alias = "XK_Greek_omicron")]
    pub const Greek_omicron: Keysym = Keysym(key::Greek_omicron);
    #[doc(alias = "XK_Greek_pi")]
    pub const Greek_pi: Keysym = Keysym(key::Greek_pi);
    #[doc(alias = "XK_Greek_rho")]
    pub const Greek_rho: Keysym = Keysym(key::Greek_rho);
    #[doc(alias = "XK_Greek_sigma")]
    pub const Greek_sigma: Keysym = Keysym(key::Greek_sigma);
    #[doc(alias = "XK_Greek_finalsmallsigma")]
    pub const Greek_finalsmallsigma: Keysym = Keysym(key::Greek_finalsmallsigma);
    #[doc(alias = "XK_Greek_tau")]
    pub const Greek_tau: Keysym = Keysym(key::Greek_tau);
    #[doc(alias = "XK_Greek_upsilon")]
    pub const Greek_upsilon: Keysym = Keysym(key::Greek_upsilon);
    #[doc(alias = "XK_Greek_phi")]
    pub const Greek_phi: Keysym = Keysym(key::Greek_phi);
    #[doc(alias = "XK_Greek_chi")]
    pub const Greek_chi: Keysym = Keysym(key::Greek_chi);
    #[doc(alias = "XK_Greek_psi")]
    pub const Greek_psi: Keysym = Keysym(key::Greek_psi);
    #[doc(alias = "XK_Greek_omega")]
    pub const Greek_omega: Keysym = Keysym(key::Greek_omega);
    #[doc(alias = "XK_Greek_switch")]
    pub const Greek_switch: Keysym = Keysym(key::Greek_switch);
    #[doc(alias = "XK_leftradical")]
    pub const leftradical: Keysym = Keysym(key::leftradical);
    #[doc(alias = "XK_topleftradical")]
    pub const topleftradical: Keysym = Keysym(key::topleftradical);
    #[doc(alias = "XK_horizconnector")]
    pub const horizconnector: Keysym = Keysym(key::horizconnector);
    #[doc(alias = "XK_topintegral")]
    pub const topintegral: Keysym = Keysym(key::topintegral);
    #[doc(alias = "XK_botintegral")]
    pub const botintegral: Keysym = Keysym(key::botintegral);
    #[doc(alias = "XK_vertconnector")]
    pub const vertconnector: Keysym = Keysym(key::vertconnector);
    #[doc(alias = "XK_topleftsqbracket")]
    pub const topleftsqbracket: Keysym = Keysym(key::topleftsqbracket);
    #[doc(alias = "XK_botleftsqbracket")]
    pub const botleftsqbracket: Keysym = Keysym(key::botleftsqbracket);
    #[doc(alias = "XK_toprightsqbracket")]
    pub const toprightsqbracket: Keysym = Keysym(key::toprightsqbracket);
    #[doc(alias = "XK_botrightsqbracket")]
    pub const botrightsqbracket: Keysym = Keysym(key::botrightsqbracket);
    #[doc(alias = "XK_topleftparens")]
    pub const topleftparens: Keysym = Keysym(key::topleftparens);
    #[doc(alias = "XK_botleftparens")]
    pub const botleftparens: Keysym = Keysym(key::botleftparens);
    #[doc(alias = "XK_toprightparens")]
    pub const toprightparens: Keysym = Keysym(key::toprightparens);
    #[doc(alias = "XK_botrightparens")]
    pub const botrightparens: Keysym = Keysym(key::botrightparens);
    #[doc(alias = "XK_leftmiddlecurlybrace")]
    pub const leftmiddlecurlybrace: Keysym = Keysym(key::leftmiddlecurlybrace);
    #[doc(alias = "XK_rightmiddlecurlybrace")]
    pub const rightmiddlecurlybrace: Keysym = Keysym(key::rightmiddlecurlybrace);
    #[doc(alias = "XK_topleftsummation")]
    pub const topleftsummation: Keysym = Keysym(key::topleftsummation);
    #[doc(alias = "XK_botleftsummation")]
    pub const botleftsummation: Keysym = Keysym(key::botleftsummation);
    #[doc(alias = "XK_topvertsummationconnector")]
    pub const topvertsummationconnector: Keysym = Keysym(key::topvertsummationconnector);
    #[doc(alias = "XK_botvertsummationconnector")]
    pub const botvertsummationconnector: Keysym = Keysym(key::botvertsummationconnector);
    #[doc(alias = "XK_toprightsummation")]
    pub const toprightsummation: Keysym = Keysym(key::toprightsummation);
    #[doc(alias = "XK_botrightsummation")]
    pub const botrightsummation: Keysym = Keysym(key::botrightsummation);
    #[doc(alias = "XK_rightmiddlesummation")]
    pub const rightmiddlesummation: Keysym = Keysym(key::rightmiddlesummation);
    #[doc(alias = "XK_lessthanequal")]
    pub const lessthanequal: Keysym = Keysym(key::lessthanequal);
    #[doc(alias = "XK_notequal")]
    pub const notequal: Keysym = Keysym(key::notequal);
    #[doc(alias = "XK_greaterthanequal")]
    pub const greaterthanequal: Keysym = Keysym(key::greaterthanequal);
    #[doc(alias = "XK_integral")]
    pub const integral: Keysym = Keysym(key::integral);
    #[doc(alias = "XK_therefore")]
    pub const therefore: Keysym = Keysym(key::therefore);
    #[doc(alias = "XK_variation")]
    pub const variation: Keysym = Keysym(key::variation);
    #[doc(alias = "XK_infinity")]
    pub const infinity: Keysym = Keysym(key::infinity);
    #[doc(alias = "XK_nabla")]
    pub const nabla: Keysym = Keysym(key::nabla);
    #[doc(alias = "XK_approximate")]
    pub const approximate: Keysym = Keysym(key::approximate);
    #[doc(alias = "XK_similarequal")]
    pub const similarequal: Keysym = Keysym(key::similarequal);
    #[doc(alias = "XK_ifonlyif")]
    pub const ifonlyif: Keysym = Keysym(key::ifonlyif);
    #[doc(alias = "XK_implies")]
    pub const implies: Keysym = Keysym(key::implies);
    #[doc(alias = "XK_identical")]
    pub const identical: Keysym = Keysym(key::identical);
    #[doc(alias = "XK_radical")]
    pub const radical: Keysym = Keysym(key::radical);
    #[doc(alias = "XK_includedin")]
    pub const includedin: Keysym = Keysym(key::includedin);
    #[doc(alias = "XK_includes")]
    pub const includes: Keysym = Keysym(key::includes);
    #[doc(alias = "XK_intersection")]
    pub const intersection: Keysym = Keysym(key::intersection);
    #[doc(alias = "XK_union")]
    pub const union: Keysym = Keysym(key::union);
    #[doc(alias = "XK_logicaland")]
    pub const logicaland: Keysym = Keysym(key::logicaland);
    #[doc(alias = "XK_logicalor")]
    pub const logicalor: Keysym = Keysym(key::logicalor);
    #[doc(alias = "XK_partialderivative")]
    pub const partialderivative: Keysym = Keysym(key::partialderivative);
    #[doc(alias = "XK_function")]
    pub const function: Keysym = Keysym(key::function);
    #[doc(alias = "XK_leftarrow")]
    pub const leftarrow: Keysym = Keysym(key::leftarrow);
    #[doc(alias = "XK_uparrow")]
    pub const uparrow: Keysym = Keysym(key::uparrow);
    #[doc(alias = "XK_rightarrow")]
    pub const rightarrow: Keysym = Keysym(key::rightarrow);
    #[doc(alias = "XK_downarrow")]
    pub const downarrow: Keysym = Keysym(key::downarrow);
    #[doc(alias = "XK_blank")]
    pub const blank: Keysym = Keysym(key::blank);
    #[doc(alias = "XK_soliddiamond")]
    pub const soliddiamond: Keysym = Keysym(key::soliddiamond);
    #[doc(alias = "XK_checkerboard")]
    pub const checkerboard: Keysym = Keysym(key::checkerboard);
    #[doc(alias = "XK_ht")]
    pub const ht: Keysym = Keysym(key::ht);
    #[doc(alias = "XK_ff")]
    pub const ff: Keysym = Keysym(key::ff);
    #[doc(alias = "XK_cr")]
    pub const cr: Keysym = Keysym(key::cr);
    #[doc(alias = "XK_lf")]
    pub const lf: Keysym = Keysym(key::lf);
    #[doc(alias = "XK_nl")]
    pub const nl: Keysym = Keysym(key::nl);
    #[doc(alias = "XK_vt")]
    pub const vt: Keysym = Keysym(key::vt);
    #[doc(alias = "XK_lowrightcorner")]
    pub const lowrightcorner: Keysym = Keysym(key::lowrightcorner);
    #[doc(alias = "XK_uprightcorner")]
    pub const uprightcorner: Keysym = Keysym(key::uprightcorner);
    #[doc(alias = "XK_upleftcorner")]
    pub const upleftcorner: Keysym = Keysym(key::upleftcorner);
    #[doc(alias = "XK_lowleftcorner")]
    pub const lowleftcorner: Keysym = Keysym(key::lowleftcorner);
    #[doc(alias = "XK_crossinglines")]
    pub const crossinglines: Keysym = Keysym(key::crossinglines);
    #[doc(alias = "XK_horizlinescan1")]
    pub const horizlinescan1: Keysym = Keysym(key::horizlinescan1);
    #[doc(alias = "XK_horizlinescan3")]
    pub const horizlinescan3: Keysym = Keysym(key::horizlinescan3);
    #[doc(alias = "XK_horizlinescan5")]
    pub const horizlinescan5: Keysym = Keysym(key::horizlinescan5);
    #[doc(alias = "XK_horizlinescan7")]
    pub const horizlinescan7: Keysym = Keysym(key::horizlinescan7);
    #[doc(alias = "XK_horizlinescan9")]
    pub const horizlinescan9: Keysym = Keysym(key::horizlinescan9);
    #[doc(alias = "XK_leftt")]
    pub const leftt: Keysym = Keysym(key::leftt);
    #[doc(alias = "XK_rightt")]
    pub const rightt: Keysym = Keysym(key::rightt);
    #[doc(alias = "XK_bott")]
    pub const bott: Keysym = Keysym(key::bott);
    #[doc(alias = "XK_topt")]
    pub const topt: Keysym = Keysym(key::topt);
    #[doc(alias = "XK_vertbar")]
    pub const vertbar: Keysym = Keysym(key::vertbar);
    #[doc(alias = "XK_emspace")]
    pub const emspace: Keysym = Keysym(key::emspace);
    #[doc(alias = "XK_enspace")]
    pub const enspace: Keysym = Keysym(key::enspace);
    #[doc(alias = "XK_em3space")]
    pub const em3space: Keysym = Keysym(key::em3space);
    #[doc(alias = "XK_em4space")]
    pub const em4space: Keysym = Keysym(key::em4space);
    #[doc(alias = "XK_digitspace")]
    pub const digitspace: Keysym = Keysym(key::digitspace);
    #[doc(alias = "XK_punctspace")]
    pub const punctspace: Keysym = Keysym(key::punctspace);
    #[doc(alias = "XK_thinspace")]
    pub const thinspace: Keysym = Keysym(key::thinspace);
    #[doc(alias = "XK_hairspace")]
    pub const hairspace: Keysym = Keysym(key::hairspace);
    #[doc(alias = "XK_emdash")]
    pub const emdash: Keysym = Keysym(key::emdash);
    #[doc(alias = "XK_endash")]
    pub const endash: Keysym = Keysym(key::endash);
    #[doc(alias = "XK_signifblank")]
    pub const signifblank: Keysym = Keysym(key::signifblank);
    #[doc(alias = "XK_ellipsis")]
    pub const ellipsis: Keysym = Keysym(key::ellipsis);
    #[doc(alias = "XK_doubbaselinedot")]
    pub const doubbaselinedot: Keysym = Keysym(key::doubbaselinedot);
    #[doc(alias = "XK_onethird")]
    pub const onethird: Keysym = Keysym(key::onethird);
    #[doc(alias = "XK_twothirds")]
    pub const twothirds: Keysym = Keysym(key::twothirds);
    #[doc(alias = "XK_onefifth")]
    pub const onefifth: Keysym = Keysym(key::onefifth);
    #[doc(alias = "XK_twofifths")]
    pub const twofifths: Keysym = Keysym(key::twofifths);
    #[doc(alias = "XK_threefifths")]
    pub const threefifths: Keysym = Keysym(key::threefifths);
    #[doc(alias = "XK_fourfifths")]
    pub const fourfifths: Keysym = Keysym(key::fourfifths);
    #[doc(alias = "XK_onesixth")]
    pub const onesixth: Keysym = Keysym(key::onesixth);
    #[doc(alias = "XK_fivesixths")]
    pub const fivesixths: Keysym = Keysym(key::fivesixths);
    #[doc(alias = "XK_careof")]
    pub const careof: Keysym = Keysym(key::careof);
    #[doc(alias = "XK_figdash")]
    pub const figdash: Keysym = Keysym(key::figdash);
    #[doc(alias = "XK_leftanglebracket")]
    pub const leftanglebracket: Keysym = Keysym(key::leftanglebracket);
    #[doc(alias = "XK_decimalpoint")]
    pub const decimalpoint: Keysym = Keysym(key::decimalpoint);
    #[doc(alias = "XK_rightanglebracket")]
    pub const rightanglebracket: Keysym = Keysym(key::rightanglebracket);
    #[doc(alias = "XK_marker")]
    pub const marker: Keysym = Keysym(key::marker);
    #[doc(alias = "XK_oneeighth")]
    pub const oneeighth: Keysym = Keysym(key::oneeighth);
    #[doc(alias = "XK_threeeighths")]
    pub const threeeighths: Keysym = Keysym(key::threeeighths);
    #[doc(alias = "XK_fiveeighths")]
    pub const fiveeighths: Keysym = Keysym(key::fiveeighths);
    #[doc(alias = "XK_seveneighths")]
    pub const seveneighths: Keysym = Keysym(key::seveneighths);
    #[doc(alias = "XK_trademark")]
    pub const trademark: Keysym = Keysym(key::trademark);
    #[doc(alias = "XK_signaturemark")]
    pub const signaturemark: Keysym = Keysym(key::signaturemark);
    #[doc(alias = "XK_trademarkincircle")]
    pub const trademarkincircle: Keysym = Keysym(key::trademarkincircle);
    #[doc(alias = "XK_leftopentriangle")]
    pub const leftopentriangle: Keysym = Keysym(key::leftopentriangle);
    #[doc(alias = "XK_rightopentriangle")]
    pub const rightopentriangle: Keysym = Keysym(key::rightopentriangle);
    #[doc(alias = "XK_emopencircle")]
    pub const emopencircle: Keysym = Keysym(key::emopencircle);
    #[doc(alias = "XK_emopenrectangle")]
    pub const emopenrectangle: Keysym = Keysym(key::emopenrectangle);
    #[doc(alias = "XK_leftsinglequotemark")]
    pub const leftsinglequotemark: Keysym = Keysym(key::leftsinglequotemark);
    #[doc(alias = "XK_rightsinglequotemark")]
    pub const rightsinglequotemark: Keysym = Keysym(key::rightsinglequotemark);
    #[doc(alias = "XK_leftdoublequotemark")]
    pub const leftdoublequotemark: Keysym = Keysym(key::leftdoublequotemark);
    #[doc(alias = "XK_rightdoublequotemark")]
    pub const rightdoublequotemark: Keysym = Keysym(key::rightdoublequotemark);
    #[doc(alias = "XK_prescription")]
    pub const prescription: Keysym = Keysym(key::prescription);
    #[doc(alias = "XK_permille")]
    pub const permille: Keysym = Keysym(key::permille);
    #[doc(alias = "XK_minutes")]
    pub const minutes: Keysym = Keysym(key::minutes);
    #[doc(alias = "XK_seconds")]
    pub const seconds: Keysym = Keysym(key::seconds);
    #[doc(alias = "XK_latincross")]
    pub const latincross: Keysym = Keysym(key::latincross);
    #[doc(alias = "XK_hexagram")]
    pub const hexagram: Keysym = Keysym(key::hexagram);
    #[doc(alias = "XK_filledrectbullet")]
    pub const filledrectbullet: Keysym = Keysym(key::filledrectbullet);
    #[doc(alias = "XK_filledlefttribullet")]
    pub const filledlefttribullet: Keysym = Keysym(key::filledlefttribullet);
    #[doc(alias = "XK_filledrighttribullet")]
    pub const filledrighttribullet: Keysym = Keysym(key::filledrighttribullet);
    #[doc(alias = "XK_emfilledcircle")]
    pub const emfilledcircle: Keysym = Keysym(key::emfilledcircle);
    #[doc(alias = "XK_emfilledrect")]
    pub const emfilledrect: Keysym = Keysym(key::emfilledrect);
    #[doc(alias = "XK_enopencircbullet")]
    pub const enopencircbullet: Keysym = Keysym(key::enopencircbullet);
    #[doc(alias = "XK_enopensquarebullet")]
    pub const enopensquarebullet: Keysym = Keysym(key::enopensquarebullet);
    #[doc(alias = "XK_openrectbullet")]
    pub const openrectbullet: Keysym = Keysym(key::openrectbullet);
    #[doc(alias = "XK_opentribulletup")]
    pub const opentribulletup: Keysym = Keysym(key::opentribulletup);
    #[doc(alias = "XK_opentribulletdown")]
    pub const opentribulletdown: Keysym = Keysym(key::opentribulletdown);
    #[doc(alias = "XK_openstar")]
    pub const openstar: Keysym = Keysym(key::openstar);
    #[doc(alias = "XK_enfilledcircbullet")]
    pub const enfilledcircbullet: Keysym = Keysym(key::enfilledcircbullet);
    #[doc(alias = "XK_enfilledsqbullet")]
    pub const enfilledsqbullet: Keysym = Keysym(key::enfilledsqbullet);
    #[doc(alias = "XK_filledtribulletup")]
    pub const filledtribulletup: Keysym = Keysym(key::filledtribulletup);
    #[doc(alias = "XK_filledtribulletdown")]
    pub const filledtribulletdown: Keysym = Keysym(key::filledtribulletdown);
    #[doc(alias = "XK_leftpointer")]
    pub const leftpointer: Keysym = Keysym(key::leftpointer);
    #[doc(alias = "XK_rightpointer")]
    pub const rightpointer: Keysym = Keysym(key::rightpointer);
    #[doc(alias = "XK_club")]
    pub const club: Keysym = Keysym(key::club);
    #[doc(alias = "XK_diamond")]
    pub const diamond: Keysym = Keysym(key::diamond);
    #[doc(alias = "XK_heart")]
    pub const heart: Keysym = Keysym(key::heart);
    #[doc(alias = "XK_maltesecross")]
    pub const maltesecross: Keysym = Keysym(key::maltesecross);
    #[doc(alias = "XK_dagger")]
    pub const dagger: Keysym = Keysym(key::dagger);
    #[doc(alias = "XK_doubledagger")]
    pub const doubledagger: Keysym = Keysym(key::doubledagger);
    #[doc(alias = "XK_checkmark")]
    pub const checkmark: Keysym = Keysym(key::checkmark);
    #[doc(alias = "XK_ballotcross")]
    pub const ballotcross: Keysym = Keysym(key::ballotcross);
    #[doc(alias = "XK_musicalsharp")]
    pub const musicalsharp: Keysym = Keysym(key::musicalsharp);
    #[doc(alias = "XK_musicalflat")]
    pub const musicalflat: Keysym = Keysym(key::musicalflat);
    #[doc(alias = "XK_malesymbol")]
    pub const malesymbol: Keysym = Keysym(key::malesymbol);
    #[doc(alias = "XK_femalesymbol")]
    pub const femalesymbol: Keysym = Keysym(key::femalesymbol);
    #[doc(alias = "XK_telephone")]
    pub const telephone: Keysym = Keysym(key::telephone);
    #[doc(alias = "XK_telephonerecorder")]
    pub const telephonerecorder: Keysym = Keysym(key::telephonerecorder);
    #[doc(alias = "XK_phonographcopyright")]
    pub const phonographcopyright: Keysym = Keysym(key::phonographcopyright);
    #[doc(alias = "XK_caret")]
    pub const caret: Keysym = Keysym(key::caret);
    #[doc(alias = "XK_singlelowquotemark")]
    pub const singlelowquotemark: Keysym = Keysym(key::singlelowquotemark);
    #[doc(alias = "XK_doublelowquotemark")]
    pub const doublelowquotemark: Keysym = Keysym(key::doublelowquotemark);
    #[doc(alias = "XK_cursor")]
    pub const cursor: Keysym = Keysym(key::cursor);
    #[doc(alias = "XK_leftcaret")]
    pub const leftcaret: Keysym = Keysym(key::leftcaret);
    #[doc(alias = "XK_rightcaret")]
    pub const rightcaret: Keysym = Keysym(key::rightcaret);
    #[doc(alias = "XK_downcaret")]
    pub const downcaret: Keysym = Keysym(key::downcaret);
    #[doc(alias = "XK_upcaret")]
    pub const upcaret: Keysym = Keysym(key::upcaret);
    #[doc(alias = "XK_overbar")]
    pub const overbar: Keysym = Keysym(key::overbar);
    #[doc(alias = "XK_downtack")]
    pub const downtack: Keysym = Keysym(key::downtack);
    #[doc(alias = "XK_upshoe")]
    pub const upshoe: Keysym = Keysym(key::upshoe);
    #[doc(alias = "XK_downstile")]
    pub const downstile: Keysym = Keysym(key::downstile);
    #[doc(alias = "XK_underbar")]
    pub const underbar: Keysym = Keysym(key::underbar);
    #[doc(alias = "XK_jot")]
    pub const jot: Keysym = Keysym(key::jot);
    #[doc(alias = "XK_quad")]
    pub const quad: Keysym = Keysym(key::quad);
    #[doc(alias = "XK_uptack")]
    pub const uptack: Keysym = Keysym(key::uptack);
    #[doc(alias = "XK_circle")]
    pub const circle: Keysym = Keysym(key::circle);
    #[doc(alias = "XK_upstile")]
    pub const upstile: Keysym = Keysym(key::upstile);
    #[doc(alias = "XK_downshoe")]
    pub const downshoe: Keysym = Keysym(key::downshoe);
    #[doc(alias = "XK_rightshoe")]
    pub const rightshoe: Keysym = Keysym(key::rightshoe);
    #[doc(alias = "XK_leftshoe")]
    pub const leftshoe: Keysym = Keysym(key::leftshoe);
    #[doc(alias = "XK_lefttack")]
    pub const lefttack: Keysym = Keysym(key::lefttack);
    #[doc(alias = "XK_righttack")]
    pub const righttack: Keysym = Keysym(key::righttack);
    #[doc(alias = "XK_hebrew_doublelowline")]
    pub const hebrew_doublelowline: Keysym = Keysym(key::hebrew_doublelowline);
    #[doc(alias = "XK_hebrew_aleph")]
    pub const hebrew_aleph: Keysym = Keysym(key::hebrew_aleph);
    #[doc(alias = "XK_hebrew_bet")]
    pub const hebrew_bet: Keysym = Keysym(key::hebrew_bet);
    #[doc(alias = "XK_hebrew_beth")]
    pub const hebrew_beth: Keysym = Keysym(key::hebrew_beth);
    #[doc(alias = "XK_hebrew_gimel")]
    pub const hebrew_gimel: Keysym = Keysym(key::hebrew_gimel);
    #[doc(alias = "XK_hebrew_gimmel")]
    pub const hebrew_gimmel: Keysym = Keysym(key::hebrew_gimmel);
    #[doc(alias = "XK_hebrew_dalet")]
    pub const hebrew_dalet: Keysym = Keysym(key::hebrew_dalet);
    #[doc(alias = "XK_hebrew_daleth")]
    pub const hebrew_daleth: Keysym = Keysym(key::hebrew_daleth);
    #[doc(alias = "XK_hebrew_he")]
    pub const hebrew_he: Keysym = Keysym(key::hebrew_he);
    #[doc(alias = "XK_hebrew_waw")]
    pub const hebrew_waw: Keysym = Keysym(key::hebrew_waw);
    #[doc(alias = "XK_hebrew_zain")]
    pub const hebrew_zain: Keysym = Keysym(key::hebrew_zain);
    #[doc(alias = "XK_hebrew_zayin")]
    pub const hebrew_zayin: Keysym = Keysym(key::hebrew_zayin);
    #[doc(alias = "XK_hebrew_chet")]
    pub const hebrew_chet: Keysym = Keysym(key::hebrew_chet);
    #[doc(alias = "XK_hebrew_het")]
    pub const hebrew_het: Keysym = Keysym(key::hebrew_het);
    #[doc(alias = "XK_hebrew_tet")]
    pub const hebrew_tet: Keysym = Keysym(key::hebrew_tet);
    #[doc(alias = "XK_hebrew_teth")]
    pub const hebrew_teth: Keysym = Keysym(key::hebrew_teth);
    #[doc(alias = "XK_hebrew_yod")]
    pub const hebrew_yod: Keysym = Keysym(key::hebrew_yod);
    #[doc(alias = "XK_hebrew_finalkaph")]
    pub const hebrew_finalkaph: Keysym = Keysym(key::hebrew_finalkaph);
    #[doc(alias = "XK_hebrew_kaph")]
    pub const hebrew_kaph: Keysym = Keysym(key::hebrew_kaph);
    #[doc(alias = "XK_hebrew_lamed")]
    pub const hebrew_lamed: Keysym = Keysym(key::hebrew_lamed);
    #[doc(alias = "XK_hebrew_finalmem")]
    pub const hebrew_finalmem: Keysym = Keysym(key::hebrew_finalmem);
    #[doc(alias = "XK_hebrew_mem")]
    pub const hebrew_mem: Keysym = Keysym(key::hebrew_mem);
    #[doc(alias = "XK_hebrew_finalnun")]
    pub const hebrew_finalnun: Keysym = Keysym(key::hebrew_finalnun);
    #[doc(alias = "XK_hebrew_nun")]
    pub const hebrew_nun: Keysym = Keysym(key::hebrew_nun);
    #[doc(alias = "XK_hebrew_samech")]
    pub const hebrew_samech: Keysym = Keysym(key::hebrew_samech);
    #[doc(alias = "XK_hebrew_samekh")]
    pub const hebrew_samekh: Keysym = Keysym(key::hebrew_samekh);
    #[doc(alias = "XK_hebrew_ayin")]
    pub const hebrew_ayin: Keysym = Keysym(key::hebrew_ayin);
    #[doc(alias = "XK_hebrew_finalpe")]
    pub const hebrew_finalpe: Keysym = Keysym(key::hebrew_finalpe);
    #[doc(alias = "XK_hebrew_pe")]
    pub const hebrew_pe: Keysym = Keysym(key::hebrew_pe);
    #[doc(alias = "XK_hebrew_finalzade")]
    pub const hebrew_finalzade: Keysym = Keysym(key::hebrew_finalzade);
    #[doc(alias = "XK_hebrew_finalzadi")]
    pub const hebrew_finalzadi: Keysym = Keysym(key::hebrew_finalzadi);
    #[doc(alias = "XK_hebrew_zade")]
    pub const hebrew_zade: Keysym = Keysym(key::hebrew_zade);
    #[doc(alias = "XK_hebrew_zadi")]
    pub const hebrew_zadi: Keysym = Keysym(key::hebrew_zadi);
    #[doc(alias = "XK_hebrew_qoph")]
    pub const hebrew_qoph: Keysym = Keysym(key::hebrew_qoph);
    #[doc(alias = "XK_hebrew_kuf")]
    pub const hebrew_kuf: Keysym = Keysym(key::hebrew_kuf);
    #[doc(alias = "XK_hebrew_resh")]
    pub const hebrew_resh: Keysym = Keysym(key::hebrew_resh);
    #[doc(alias = "XK_hebrew_shin")]
    pub const hebrew_shin: Keysym = Keysym(key::hebrew_shin);
    #[doc(alias = "XK_hebrew_taw")]
    pub const hebrew_taw: Keysym = Keysym(key::hebrew_taw);
    #[doc(alias = "XK_hebrew_taf")]
    pub const hebrew_taf: Keysym = Keysym(key::hebrew_taf);
    #[doc(alias = "XK_Hebrew_switch")]
    pub const Hebrew_switch: Keysym = Keysym(key::Hebrew_switch);
    #[doc(alias = "XK_Thai_kokai")]
    pub const Thai_kokai: Keysym = Keysym(key::Thai_kokai);
    #[doc(alias = "XK_Thai_khokhai")]
    pub const Thai_khokhai: Keysym = Keysym(key::Thai_khokhai);
    #[doc(alias = "XK_Thai_khokhuat")]
    pub const Thai_khokhuat: Keysym = Keysym(key::Thai_khokhuat);
    #[doc(alias = "XK_Thai_khokhwai")]
    pub const Thai_khokhwai: Keysym = Keysym(key::Thai_khokhwai);
    #[doc(alias = "XK_Thai_khokhon")]
    pub const Thai_khokhon: Keysym = Keysym(key::Thai_khokhon);
    #[doc(alias = "XK_Thai_khorakhang")]
    pub const Thai_khorakhang: Keysym = Keysym(key::Thai_khorakhang);
    #[doc(alias = "XK_Thai_ngongu")]
    pub const Thai_ngongu: Keysym = Keysym(key::Thai_ngongu);
    #[doc(alias = "XK_Thai_chochan")]
    pub const Thai_chochan: Keysym = Keysym(key::Thai_chochan);
    #[doc(alias = "XK_Thai_choching")]
    pub const Thai_choching: Keysym = Keysym(key::Thai_choching);
    #[doc(alias = "XK_Thai_chochang")]
    pub const Thai_chochang: Keysym = Keysym(key::Thai_chochang);
    #[doc(alias = "XK_Thai_soso")]
    pub const Thai_soso: Keysym = Keysym(key::Thai_soso);
    #[doc(alias = "XK_Thai_chochoe")]
    pub const Thai_chochoe: Keysym = Keysym(key::Thai_chochoe);
    #[doc(alias = "XK_Thai_yoying")]
    pub const Thai_yoying: Keysym = Keysym(key::Thai_yoying);
    #[doc(alias = "XK_Thai_dochada")]
    pub const Thai_dochada: Keysym = Keysym(key::Thai_dochada);
    #[doc(alias = "XK_Thai_topatak")]
    pub const Thai_topatak: Keysym = Keysym(key::Thai_topatak);
    #[doc(alias = "XK_Thai_thothan")]
    pub const Thai_thothan: Keysym = Keysym(key::Thai_thothan);
    #[doc(alias = "XK_Thai_thonangmontho")]
    pub const Thai_thonangmontho: Keysym = Keysym(key::Thai_thonangmontho);
    #[doc(alias = "XK_Thai_thophuthao")]
    pub const Thai_thophuthao: Keysym = Keysym(key::Thai_thophuthao);
    #[doc(alias = "XK_Thai_nonen")]
    pub const Thai_nonen: Keysym = Keysym(key::Thai_nonen);
    #[doc(alias = "XK_Thai_dodek")]
    pub const Thai_dodek: Keysym = Keysym(key::Thai_dodek);
    #[doc(alias = "XK_Thai_totao")]
    pub const Thai_totao: Keysym = Keysym(key::Thai_totao);
    #[doc(alias = "XK_Thai_thothung")]
    pub const Thai_thothung: Keysym = Keysym(key::Thai_thothung);
    #[doc(alias = "XK_Thai_thothahan")]
    pub const Thai_thothahan: Keysym = Keysym(key::Thai_thothahan);
    #[doc(alias = "XK_Thai_thothong")]
    pub const Thai_thothong: Keysym = Keysym(key::Thai_thothong);
    #[doc(alias = "XK_Thai_nonu")]
    pub const Thai_nonu: Keysym = Keysym(key::Thai_nonu);
    #[doc(alias = "XK_Thai_bobaimai")]
    pub const Thai_bobaimai: Keysym = Keysym(key::Thai_bobaimai);
    #[doc(alias = "XK_Thai_popla")]
    pub const Thai_popla: Keysym = Keysym(key::Thai_popla);
    #[doc(alias = "XK_Thai_phophung")]
    pub const Thai_phophung: Keysym = Keysym(key::Thai_phophung);
    #[doc(alias = "XK_Thai_fofa")]
    pub const Thai_fofa: Keysym = Keysym(key::Thai_fofa);
    #[doc(alias = "XK_Thai_phophan")]
    pub const Thai_phophan: Keysym = Keysym(key::Thai_phophan);
    #[doc(alias = "XK_Thai_fofan")]
    pub const Thai_fofan: Keysym = Keysym(key::Thai_fofan);
    #[doc(alias = "XK_Thai_phosamphao")]
    pub const Thai_phosamphao: Keysym = Keysym(key::Thai_phosamphao);
    #[doc(alias = "XK_Thai_moma")]
    pub const Thai_moma: Keysym = Keysym(key::Thai_moma);
    #[doc(alias = "XK_Thai_yoyak")]
    pub const Thai_yoyak: Keysym = Keysym(key::Thai_yoyak);
    #[doc(alias = "XK_Thai_rorua")]
    pub const Thai_rorua: Keysym = Keysym(key::Thai_rorua);
    #[doc(alias = "XK_Thai_ru")]
    pub const Thai_ru: Keysym = Keysym(key::Thai_ru);
    #[doc(alias = "XK_Thai_loling")]
    pub const Thai_loling: Keysym = Keysym(key::Thai_loling);
    #[doc(alias = "XK_Thai_lu")]
    pub const Thai_lu: Keysym = Keysym(key::Thai_lu);
    #[doc(alias = "XK_Thai_wowaen")]
    pub const Thai_wowaen: Keysym = Keysym(key::Thai_wowaen);
    #[doc(alias = "XK_Thai_sosala")]
    pub const Thai_sosala: Keysym = Keysym(key::Thai_sosala);
    #[doc(alias = "XK_Thai_sorusi")]
    pub const Thai_sorusi: Keysym = Keysym(key::Thai_sorusi);
    #[doc(alias = "XK_Thai_sosua")]
    pub const Thai_sosua: Keysym = Keysym(key::Thai_sosua);
    #[doc(alias = "XK_Thai_hohip")]
    pub const Thai_hohip: Keysym = Keysym(key::Thai_hohip);
    #[doc(alias = "XK_Thai_lochula")]
    pub const Thai_lochula: Keysym = Keysym(key::Thai_lochula);
    #[doc(alias = "XK_Thai_oang")]
    pub const Thai_oang: Keysym = Keysym(key::Thai_oang);
    #[doc(alias = "XK_Thai_honokhuk")]
    pub const Thai_honokhuk: Keysym = Keysym(key::Thai_honokhuk);
    #[doc(alias = "XK_Thai_paiyannoi")]
    pub const Thai_paiyannoi: Keysym = Keysym(key::Thai_paiyannoi);
    #[doc(alias = "XK_Thai_saraa")]
    pub const Thai_saraa: Keysym = Keysym(key::Thai_saraa);
    #[doc(alias = "XK_Thai_maihanakat")]
    pub const Thai_maihanakat: Keysym = Keysym(key::Thai_maihanakat);
    #[doc(alias = "XK_Thai_saraaa")]
    pub const Thai_saraaa: Keysym = Keysym(key::Thai_saraaa);
    #[doc(alias = "XK_Thai_saraam")]
    pub const Thai_saraam: Keysym = Keysym(key::Thai_saraam);
    #[doc(alias = "XK_Thai_sarai")]
    pub const Thai_sarai: Keysym = Keysym(key::Thai_sarai);
    #[doc(alias = "XK_Thai_saraii")]
    pub const Thai_saraii: Keysym = Keysym(key::Thai_saraii);
    #[doc(alias = "XK_Thai_saraue")]
    pub const Thai_saraue: Keysym = Keysym(key::Thai_saraue);
    #[doc(alias = "XK_Thai_sarauee")]
    pub const Thai_sarauee: Keysym = Keysym(key::Thai_sarauee);
    #[doc(alias = "XK_Thai_sarau")]
    pub const Thai_sarau: Keysym = Keysym(key::Thai_sarau);
    #[doc(alias = "XK_Thai_sarauu")]
    pub const Thai_sarauu: Keysym = Keysym(key::Thai_sarauu);
    #[doc(alias = "XK_Thai_phinthu")]
    pub const Thai_phinthu: Keysym = Keysym(key::Thai_phinthu);
    #[doc(alias = "XK_Thai_maihanakat_maitho")]
    pub const Thai_maihanakat_maitho: Keysym = Keysym(key::Thai_maihanakat_maitho);
    #[doc(alias = "XK_Thai_baht")]
    pub const Thai_baht: Keysym = Keysym(key::Thai_baht);
    #[doc(alias = "XK_Thai_sarae")]
    pub const Thai_sarae: Keysym = Keysym(key::Thai_sarae);
    #[doc(alias = "XK_Thai_saraae")]
    pub const Thai_saraae: Keysym = Keysym(key::Thai_saraae);
    #[doc(alias = "XK_Thai_sarao")]
    pub const Thai_sarao: Keysym = Keysym(key::Thai_sarao);
    #[doc(alias = "XK_Thai_saraaimaimuan")]
    pub const Thai_saraaimaimuan: Keysym = Keysym(key::Thai_saraaimaimuan);
    #[doc(alias = "XK_Thai_saraaimaimalai")]
    pub const Thai_saraaimaimalai: Keysym = Keysym(key::Thai_saraaimaimalai);
    #[doc(alias = "XK_Thai_lakkhangyao")]
    pub const Thai_lakkhangyao: Keysym = Keysym(key::Thai_lakkhangyao);
    #[doc(alias = "XK_Thai_maiyamok")]
    pub const Thai_maiyamok: Keysym = Keysym(key::Thai_maiyamok);
    #[doc(alias = "XK_Thai_maitaikhu")]
    pub const Thai_maitaikhu: Keysym = Keysym(key::Thai_maitaikhu);
    #[doc(alias = "XK_Thai_maiek")]
    pub const Thai_maiek: Keysym = Keysym(key::Thai_maiek);
    #[doc(alias = "XK_Thai_maitho")]
    pub const Thai_maitho: Keysym = Keysym(key::Thai_maitho);
    #[doc(alias = "XK_Thai_maitri")]
    pub const Thai_maitri: Keysym = Keysym(key::Thai_maitri);
    #[doc(alias = "XK_Thai_maichattawa")]
    pub const Thai_maichattawa: Keysym = Keysym(key::Thai_maichattawa);
    #[doc(alias = "XK_Thai_thanthakhat")]
    pub const Thai_thanthakhat: Keysym = Keysym(key::Thai_thanthakhat);
    #[doc(alias = "XK_Thai_nikhahit")]
    pub const Thai_nikhahit: Keysym = Keysym(key::Thai_nikhahit);
    #[doc(alias = "XK_Thai_leksun")]
    pub const Thai_leksun: Keysym = Keysym(key::Thai_leksun);
    #[doc(alias = "XK_Thai_leknung")]
    pub const Thai_leknung: Keysym = Keysym(key::Thai_leknung);
    #[doc(alias = "XK_Thai_leksong")]
    pub const Thai_leksong: Keysym = Keysym(key::Thai_leksong);
    #[doc(alias = "XK_Thai_leksam")]
    pub const Thai_leksam: Keysym = Keysym(key::Thai_leksam);
    #[doc(alias = "XK_Thai_leksi")]
    pub const Thai_leksi: Keysym = Keysym(key::Thai_leksi);
    #[doc(alias = "XK_Thai_lekha")]
    pub const Thai_lekha: Keysym = Keysym(key::Thai_lekha);
    #[doc(alias = "XK_Thai_lekhok")]
    pub const Thai_lekhok: Keysym = Keysym(key::Thai_lekhok);
    #[doc(alias = "XK_Thai_lekchet")]
    pub const Thai_lekchet: Keysym = Keysym(key::Thai_lekchet);
    #[doc(alias = "XK_Thai_lekpaet")]
    pub const Thai_lekpaet: Keysym = Keysym(key::Thai_lekpaet);
    #[doc(alias = "XK_Thai_lekkao")]
    pub const Thai_lekkao: Keysym = Keysym(key::Thai_lekkao);
    #[doc(alias = "XK_Hangul")]
    pub const Hangul: Keysym = Keysym(key::Hangul);
    #[doc(alias = "XK_Hangul_Start")]
    pub const Hangul_Start: Keysym = Keysym(key::Hangul_Start);
    #[doc(alias = "XK_Hangul_End")]
    pub const Hangul_End: Keysym = Keysym(key::Hangul_End);
    #[doc(alias = "XK_Hangul_Hanja")]
    pub const Hangul_Hanja: Keysym = Keysym(key::Hangul_Hanja);
    #[doc(alias = "XK_Hangul_Jamo")]
    pub const Hangul_Jamo: Keysym = Keysym(key::Hangul_Jamo);
    #[doc(alias = "XK_Hangul_Romaja")]
    pub const Hangul_Romaja: Keysym = Keysym(key::Hangul_Romaja);
    #[doc(alias = "XK_Hangul_Codeinput")]
    pub const Hangul_Codeinput: Keysym = Keysym(key::Hangul_Codeinput);
    #[doc(alias = "XK_Hangul_Jeonja")]
    pub const Hangul_Jeonja: Keysym = Keysym(key::Hangul_Jeonja);
    #[doc(alias = "XK_Hangul_Banja")]
    pub const Hangul_Banja: Keysym = Keysym(key::Hangul_Banja);
    #[doc(alias = "XK_Hangul_PreHanja")]
    pub const Hangul_PreHanja: Keysym = Keysym(key::Hangul_PreHanja);
    #[doc(alias = "XK_Hangul_PostHanja")]
    pub const Hangul_PostHanja: Keysym = Keysym(key::Hangul_PostHanja);
    #[doc(alias = "XK_Hangul_SingleCandidate")]
    pub const Hangul_SingleCandidate: Keysym = Keysym(key::Hangul_SingleCandidate);
    #[doc(alias = "XK_Hangul_MultipleCandidate")]
    pub const Hangul_MultipleCandidate: Keysym = Keysym(key::Hangul_MultipleCandidate);
    #[doc(alias = "XK_Hangul_PreviousCandidate")]
    pub const Hangul_PreviousCandidate: Keysym = Keysym(key::Hangul_PreviousCandidate);
    #[doc(alias = "XK_Hangul_Special")]
    pub const Hangul_Special: Keysym = Keysym(key::Hangul_Special);
    #[doc(alias = "XK_Hangul_switch")]
    pub const Hangul_switch: Keysym = Keysym(key::Hangul_switch);
    #[doc(alias = "XK_Hangul_Kiyeog")]
    pub const Hangul_Kiyeog: Keysym = Keysym(key::Hangul_Kiyeog);
    #[doc(alias = "XK_Hangul_SsangKiyeog")]
    pub const Hangul_SsangKiyeog: Keysym = Keysym(key::Hangul_SsangKiyeog);
    #[doc(alias = "XK_Hangul_KiyeogSios")]
    pub const Hangul_KiyeogSios: Keysym = Keysym(key::Hangul_KiyeogSios);
    #[doc(alias = "XK_Hangul_Nieun")]
    pub const Hangul_Nieun: Keysym = Keysym(key::Hangul_Nieun);
    #[doc(alias = "XK_Hangul_NieunJieuj")]
    pub const Hangul_NieunJieuj: Keysym = Keysym(key::Hangul_NieunJieuj);
    #[doc(alias = "XK_Hangul_NieunHieuh")]
    pub const Hangul_NieunHieuh: Keysym = Keysym(key::Hangul_NieunHieuh);
    #[doc(alias = "XK_Hangul_Dikeud")]
    pub const Hangul_Dikeud: Keysym = Keysym(key::Hangul_Dikeud);
    #[doc(alias = "XK_Hangul_SsangDikeud")]
    pub const Hangul_SsangDikeud: Keysym = Keysym(key::Hangul_SsangDikeud);
    #[doc(alias = "XK_Hangul_Rieul")]
    pub const Hangul_Rieul: Keysym = Keysym(key::Hangul_Rieul);
    #[doc(alias = "XK_Hangul_RieulKiyeog")]
    pub const Hangul_RieulKiyeog: Keysym = Keysym(key::Hangul_RieulKiyeog);
    #[doc(alias = "XK_Hangul_RieulMieum")]
    pub const Hangul_RieulMieum: Keysym = Keysym(key::Hangul_RieulMieum);
    #[doc(alias = "XK_Hangul_RieulPieub")]
    pub const Hangul_RieulPieub: Keysym = Keysym(key::Hangul_RieulPieub);
    #[doc(alias = "XK_Hangul_RieulSios")]
    pub const Hangul_RieulSios: Keysym = Keysym(key::Hangul_RieulSios);
    #[doc(alias = "XK_Hangul_RieulTieut")]
    pub const Hangul_RieulTieut: Keysym = Keysym(key::Hangul_RieulTieut);
    #[doc(alias = "XK_Hangul_RieulPhieuf")]
    pub const Hangul_RieulPhieuf: Keysym = Keysym(key::Hangul_RieulPhieuf);
    #[doc(alias = "XK_Hangul_RieulHieuh")]
    pub const Hangul_RieulHieuh: Keysym = Keysym(key::Hangul_RieulHieuh);
    #[doc(alias = "XK_Hangul_Mieum")]
    pub const Hangul_Mieum: Keysym = Keysym(key::Hangul_Mieum);
    #[doc(alias = "XK_Hangul_Pieub")]
    pub const Hangul_Pieub: Keysym = Keysym(key::Hangul_Pieub);
    #[doc(alias = "XK_Hangul_SsangPieub")]
    pub const Hangul_SsangPieub: Keysym = Keysym(key::Hangul_SsangPieub);
    #[doc(alias = "XK_Hangul_PieubSios")]
    pub const Hangul_PieubSios: Keysym = Keysym(key::Hangul_PieubSios);
    #[doc(alias = "XK_Hangul_Sios")]
    pub const Hangul_Sios: Keysym = Keysym(key::Hangul_Sios);
    #[doc(alias = "XK_Hangul_SsangSios")]
    pub const Hangul_SsangSios: Keysym = Keysym(key::Hangul_SsangSios);
    #[doc(alias = "XK_Hangul_Ieung")]
    pub const Hangul_Ieung: Keysym = Keysym(key::Hangul_Ieung);
    #[doc(alias = "XK_Hangul_Jieuj")]
    pub const Hangul_Jieuj: Keysym = Keysym(key::Hangul_Jieuj);
    #[doc(alias = "XK_Hangul_SsangJieuj")]
    pub const Hangul_SsangJieuj: Keysym = Keysym(key::Hangul_SsangJieuj);
    #[doc(alias = "XK_Hangul_Cieuc")]
    pub const Hangul_Cieuc: Keysym = Keysym(key::Hangul_Cieuc);
    #[doc(alias = "XK_Hangul_Khieuq")]
    pub const Hangul_Khieuq: Keysym = Keysym(key::Hangul_Khieuq);
    #[doc(alias = "XK_Hangul_Tieut")]
    pub const Hangul_Tieut: Keysym = Keysym(key::Hangul_Tieut);
    #[doc(alias = "XK_Hangul_Phieuf")]
    pub const Hangul_Phieuf: Keysym = Keysym(key::Hangul_Phieuf);
    #[doc(alias = "XK_Hangul_Hieuh")]
    pub const Hangul_Hieuh: Keysym = Keysym(key::Hangul_Hieuh);
    #[doc(alias = "XK_Hangul_A")]
    pub const Hangul_A: Keysym = Keysym(key::Hangul_A);
    #[doc(alias = "XK_Hangul_AE")]
    pub const Hangul_AE: Keysym = Keysym(key::Hangul_AE);
    #[doc(alias = "XK_Hangul_YA")]
    pub const Hangul_YA: Keysym = Keysym(key::Hangul_YA);
    #[doc(alias = "XK_Hangul_YAE")]
    pub const Hangul_YAE: Keysym = Keysym(key::Hangul_YAE);
    #[doc(alias = "XK_Hangul_EO")]
    pub const Hangul_EO: Keysym = Keysym(key::Hangul_EO);
    #[doc(alias = "XK_Hangul_E")]
    pub const Hangul_E: Keysym = Keysym(key::Hangul_E);
    #[doc(alias = "XK_Hangul_YEO")]
    pub const Hangul_YEO: Keysym = Keysym(key::Hangul_YEO);
    #[doc(alias = "XK_Hangul_YE")]
    pub const Hangul_YE: Keysym = Keysym(key::Hangul_YE);
    #[doc(alias = "XK_Hangul_O")]
    pub const Hangul_O: Keysym = Keysym(key::Hangul_O);
    #[doc(alias = "XK_Hangul_WA")]
    pub const Hangul_WA: Keysym = Keysym(key::Hangul_WA);
    #[doc(alias = "XK_Hangul_WAE")]
    pub const Hangul_WAE: Keysym = Keysym(key::Hangul_WAE);
    #[doc(alias = "XK_Hangul_OE")]
    pub const Hangul_OE: Keysym = Keysym(key::Hangul_OE);
    #[doc(alias = "XK_Hangul_YO")]
    pub const Hangul_YO: Keysym = Keysym(key::Hangul_YO);
    #[doc(alias = "XK_Hangul_U")]
    pub const Hangul_U: Keysym = Keysym(key::Hangul_U);
    #[doc(alias = "XK_Hangul_WEO")]
    pub const Hangul_WEO: Keysym = Keysym(key::Hangul_WEO);
    #[doc(alias = "XK_Hangul_WE")]
    pub const Hangul_WE: Keysym = Keysym(key::Hangul_WE);
    #[doc(alias = "XK_Hangul_WI")]
    pub const Hangul_WI: Keysym = Keysym(key::Hangul_WI);
    #[doc(alias = "XK_Hangul_YU")]
    pub const Hangul_YU: Keysym = Keysym(key::Hangul_YU);
    #[doc(alias = "XK_Hangul_EU")]
    pub const Hangul_EU: Keysym = Keysym(key::Hangul_EU);
    #[doc(alias = "XK_Hangul_YI")]
    pub const Hangul_YI: Keysym = Keysym(key::Hangul_YI);
    #[doc(alias = "XK_Hangul_I")]
    pub const Hangul_I: Keysym = Keysym(key::Hangul_I);
    #[doc(alias = "XK_Hangul_J_Kiyeog")]
    pub const Hangul_J_Kiyeog: Keysym = Keysym(key::Hangul_J_Kiyeog);
    #[doc(alias = "XK_Hangul_J_SsangKiyeog")]
    pub const Hangul_J_SsangKiyeog: Keysym = Keysym(key::Hangul_J_SsangKiyeog);
    #[doc(alias = "XK_Hangul_J_KiyeogSios")]
    pub const Hangul_J_KiyeogSios: Keysym = Keysym(key::Hangul_J_KiyeogSios);
    #[doc(alias = "XK_Hangul_J_Nieun")]
    pub const Hangul_J_Nieun: Keysym = Keysym(key::Hangul_J_Nieun);
    #[doc(alias = "XK_Hangul_J_NieunJieuj")]
    pub const Hangul_J_NieunJieuj: Keysym = Keysym(key::Hangul_J_NieunJieuj);
    #[doc(alias = "XK_Hangul_J_NieunHieuh")]
    pub const Hangul_J_NieunHieuh: Keysym = Keysym(key::Hangul_J_NieunHieuh);
    #[doc(alias = "XK_Hangul_J_Dikeud")]
    pub const Hangul_J_Dikeud: Keysym = Keysym(key::Hangul_J_Dikeud);
    #[doc(alias = "XK_Hangul_J_Rieul")]
    pub const Hangul_J_Rieul: Keysym = Keysym(key::Hangul_J_Rieul);
    #[doc(alias = "XK_Hangul_J_RieulKiyeog")]
    pub const Hangul_J_RieulKiyeog: Keysym = Keysym(key::Hangul_J_RieulKiyeog);
    #[doc(alias = "XK_Hangul_J_RieulMieum")]
    pub const Hangul_J_RieulMieum: Keysym = Keysym(key::Hangul_J_RieulMieum);
    #[doc(alias = "XK_Hangul_J_RieulPieub")]
    pub const Hangul_J_RieulPieub: Keysym = Keysym(key::Hangul_J_RieulPieub);
    #[doc(alias = "XK_Hangul_J_RieulSios")]
    pub const Hangul_J_RieulSios: Keysym = Keysym(key::Hangul_J_RieulSios);
    #[doc(alias = "XK_Hangul_J_RieulTieut")]
    pub const Hangul_J_RieulTieut: Keysym = Keysym(key::Hangul_J_RieulTieut);
    #[doc(alias = "XK_Hangul_J_RieulPhieuf")]
    pub const Hangul_J_RieulPhieuf: Keysym = Keysym(key::Hangul_J_RieulPhieuf);
    #[doc(alias = "XK_Hangul_J_RieulHieuh")]
    pub const Hangul_J_RieulHieuh: Keysym = Keysym(key::Hangul_J_RieulHieuh);
    #[doc(alias = "XK_Hangul_J_Mieum")]
    pub const Hangul_J_Mieum: Keysym = Keysym(key::Hangul_J_Mieum);
    #[doc(alias = "XK_Hangul_J_Pieub")]
    pub const Hangul_J_Pieub: Keysym = Keysym(key::Hangul_J_Pieub);
    #[doc(alias = "XK_Hangul_J_PieubSios")]
    pub const Hangul_J_PieubSios: Keysym = Keysym(key::Hangul_J_PieubSios);
    #[doc(alias = "XK_Hangul_J_Sios")]
    pub const Hangul_J_Sios: Keysym = Keysym(key::Hangul_J_Sios);
    #[doc(alias = "XK_Hangul_J_SsangSios")]
    pub const Hangul_J_SsangSios: Keysym = Keysym(key::Hangul_J_SsangSios);
    #[doc(alias = "XK_Hangul_J_Ieung")]
    pub const Hangul_J_Ieung: Keysym = Keysym(key::Hangul_J_Ieung);
    #[doc(alias = "XK_Hangul_J_Jieuj")]
    pub const Hangul_J_Jieuj: Keysym = Keysym(key::Hangul_J_Jieuj);
    #[doc(alias = "XK_Hangul_J_Cieuc")]
    pub const Hangul_J_Cieuc: Keysym = Keysym(key::Hangul_J_Cieuc);
    #[doc(alias = "XK_Hangul_J_Khieuq")]
    pub const Hangul_J_Khieuq: Keysym = Keysym(key::Hangul_J_Khieuq);
    #[doc(alias = "XK_Hangul_J_Tieut")]
    pub const Hangul_J_Tieut: Keysym = Keysym(key::Hangul_J_Tieut);
    #[doc(alias = "XK_Hangul_J_Phieuf")]
    pub const Hangul_J_Phieuf: Keysym = Keysym(key::Hangul_J_Phieuf);
    #[doc(alias = "XK_Hangul_J_Hieuh")]
    pub const Hangul_J_Hieuh: Keysym = Keysym(key::Hangul_J_Hieuh);
    #[doc(alias = "XK_Hangul_RieulYeorinHieuh")]
    pub const Hangul_RieulYeorinHieuh: Keysym = Keysym(key::Hangul_RieulYeorinHieuh);
    #[doc(alias = "XK_Hangul_SunkyeongeumMieum")]
    pub const Hangul_SunkyeongeumMieum: Keysym = Keysym(key::Hangul_SunkyeongeumMieum);
    #[doc(alias = "XK_Hangul_SunkyeongeumPieub")]
    pub const Hangul_SunkyeongeumPieub: Keysym = Keysym(key::Hangul_SunkyeongeumPieub);
    #[doc(alias = "XK_Hangul_PanSios")]
    pub const Hangul_PanSios: Keysym = Keysym(key::Hangul_PanSios);
    #[doc(alias = "XK_Hangul_KkogjiDalrinIeung")]
    pub const Hangul_KkogjiDalrinIeung: Keysym = Keysym(key::Hangul_KkogjiDalrinIeung);
    #[doc(alias = "XK_Hangul_SunkyeongeumPhieuf")]
    pub const Hangul_SunkyeongeumPhieuf: Keysym = Keysym(key::Hangul_SunkyeongeumPhieuf);
    #[doc(alias = "XK_Hangul_YeorinHieuh")]
    pub const Hangul_YeorinHieuh: Keysym = Keysym(key::Hangul_YeorinHieuh);
    #[doc(alias = "XK_Hangul_AraeA")]
    pub const Hangul_AraeA: Keysym = Keysym(key::Hangul_AraeA);
    #[doc(alias = "XK_Hangul_AraeAE")]
    pub const Hangul_AraeAE: Keysym = Keysym(key::Hangul_AraeAE);
    #[doc(alias = "XK_Hangul_J_PanSios")]
    pub const Hangul_J_PanSios: Keysym = Keysym(key::Hangul_J_PanSios);
    #[doc(alias = "XK_Hangul_J_KkogjiDalrinIeung")]
    pub const Hangul_J_KkogjiDalrinIeung: Keysym = Keysym(key::Hangul_J_KkogjiDalrinIeung);
    #[doc(alias = "XK_Hangul_J_YeorinHieuh")]
    pub const Hangul_J_YeorinHieuh: Keysym = Keysym(key::Hangul_J_YeorinHieuh);
    #[doc(alias = "XK_Korean_Won")]
    pub const Korean_Won: Keysym = Keysym(key::Korean_Won);
    #[doc(alias = "XK_Armenian_ligature_ew")]
    pub const Armenian_ligature_ew: Keysym = Keysym(key::Armenian_ligature_ew);
    #[doc(alias = "XK_Armenian_full_stop")]
    pub const Armenian_full_stop: Keysym = Keysym(key::Armenian_full_stop);
    #[doc(alias = "XK_Armenian_verjaket")]
    pub const Armenian_verjaket: Keysym = Keysym(key::Armenian_verjaket);
    #[doc(alias = "XK_Armenian_separation_mark")]
    pub const Armenian_separation_mark: Keysym = Keysym(key::Armenian_separation_mark);
    #[doc(alias = "XK_Armenian_but")]
    pub const Armenian_but: Keysym = Keysym(key::Armenian_but);
    #[doc(alias = "XK_Armenian_hyphen")]
    pub const Armenian_hyphen: Keysym = Keysym(key::Armenian_hyphen);
    #[doc(alias = "XK_Armenian_yentamna")]
    pub const Armenian_yentamna: Keysym = Keysym(key::Armenian_yentamna);
    #[doc(alias = "XK_Armenian_exclam")]
    pub const Armenian_exclam: Keysym = Keysym(key::Armenian_exclam);
    #[doc(alias = "XK_Armenian_amanak")]
    pub const Armenian_amanak: Keysym = Keysym(key::Armenian_amanak);
    #[doc(alias = "XK_Armenian_accent")]
    pub const Armenian_accent: Keysym = Keysym(key::Armenian_accent);
    #[doc(alias = "XK_Armenian_shesht")]
    pub const Armenian_shesht: Keysym = Keysym(key::Armenian_shesht);
    #[doc(alias = "XK_Armenian_question")]
    pub const Armenian_question: Keysym = Keysym(key::Armenian_question);
    #[doc(alias = "XK_Armenian_paruyk")]
    pub const Armenian_paruyk: Keysym = Keysym(key::Armenian_paruyk);
    #[doc(alias = "XK_Armenian_AYB")]
    pub const Armenian_AYB: Keysym = Keysym(key::Armenian_AYB);
    #[doc(alias = "XK_Armenian_ayb")]
    pub const Armenian_ayb: Keysym = Keysym(key::Armenian_ayb);
    #[doc(alias = "XK_Armenian_BEN")]
    pub const Armenian_BEN: Keysym = Keysym(key::Armenian_BEN);
    #[doc(alias = "XK_Armenian_ben")]
    pub const Armenian_ben: Keysym = Keysym(key::Armenian_ben);
    #[doc(alias = "XK_Armenian_GIM")]
    pub const Armenian_GIM: Keysym = Keysym(key::Armenian_GIM);
    #[doc(alias = "XK_Armenian_gim")]
    pub const Armenian_gim: Keysym = Keysym(key::Armenian_gim);
    #[doc(alias = "XK_Armenian_DA")]
    pub const Armenian_DA: Keysym = Keysym(key::Armenian_DA);
    #[doc(alias = "XK_Armenian_da")]
    pub const Armenian_da: Keysym = Keysym(key::Armenian_da);
    #[doc(alias = "XK_Armenian_YECH")]
    pub const Armenian_YECH: Keysym = Keysym(key::Armenian_YECH);
    #[doc(alias = "XK_Armenian_yech")]
    pub const Armenian_yech: Keysym = Keysym(key::Armenian_yech);
    #[doc(alias = "XK_Armenian_ZA")]
    pub const Armenian_ZA: Keysym = Keysym(key::Armenian_ZA);
    #[doc(alias = "XK_Armenian_za")]
    pub const Armenian_za: Keysym = Keysym(key::Armenian_za);
    #[doc(alias = "XK_Armenian_E")]
    pub const Armenian_E: Keysym = Keysym(key::Armenian_E);
    #[doc(alias = "XK_Armenian_e")]
    pub const Armenian_e: Keysym = Keysym(key::Armenian_e);
    #[doc(alias = "XK_Armenian_AT")]
    pub const Armenian_AT: Keysym = Keysym(key::Armenian_AT);
    #[doc(alias = "XK_Armenian_at")]
    pub const Armenian_at: Keysym = Keysym(key::Armenian_at);
    #[doc(alias = "XK_Armenian_TO")]
    pub const Armenian_TO: Keysym = Keysym(key::Armenian_TO);
    #[doc(alias = "XK_Armenian_to")]
    pub const Armenian_to: Keysym = Keysym(key::Armenian_to);
    #[doc(alias = "XK_Armenian_ZHE")]
    pub const Armenian_ZHE: Keysym = Keysym(key::Armenian_ZHE);
    #[doc(alias = "XK_Armenian_zhe")]
    pub const Armenian_zhe: Keysym = Keysym(key::Armenian_zhe);
    #[doc(alias = "XK_Armenian_INI")]
    pub const Armenian_INI: Keysym = Keysym(key::Armenian_INI);
    #[doc(alias = "XK_Armenian_ini")]
    pub const Armenian_ini: Keysym = Keysym(key::Armenian_ini);
    #[doc(alias = "XK_Armenian_LYUN")]
    pub const Armenian_LYUN: Keysym = Keysym(key::Armenian_LYUN);
    #[doc(alias = "XK_Armenian_lyun")]
    pub const Armenian_lyun: Keysym = Keysym(key::Armenian_lyun);
    #[doc(alias = "XK_Armenian_KHE")]
    pub const Armenian_KHE: Keysym = Keysym(key::Armenian_KHE);
    #[doc(alias = "XK_Armenian_khe")]
    pub const Armenian_khe: Keysym = Keysym(key::Armenian_khe);
    #[doc(alias = "XK_Armenian_TSA")]
    pub const Armenian_TSA: Keysym = Keysym(key::Armenian_TSA);
    #[doc(alias = "XK_Armenian_tsa")]
    pub const Armenian_tsa: Keysym = Keysym(key::Armenian_tsa);
    #[doc(alias = "XK_Armenian_KEN")]
    pub const Armenian_KEN: Keysym = Keysym(key::Armenian_KEN);
    #[doc(alias = "XK_Armenian_ken")]
    pub const Armenian_ken: Keysym = Keysym(key::Armenian_ken);
    #[doc(alias = "XK_Armenian_HO")]
    pub const Armenian_HO: Keysym = Keysym(key::Armenian_HO);
    #[doc(alias = "XK_Armenian_ho")]
    pub const Armenian_ho: Keysym = Keysym(key::Armenian_ho);
    #[doc(alias = "XK_Armenian_DZA")]
    pub const Armenian_DZA: Keysym = Keysym(key::Armenian_DZA);
    #[doc(alias = "XK_Armenian_dza")]
    pub const Armenian_dza: Keysym = Keysym(key::Armenian_dza);
    #[doc(alias = "XK_Armenian_GHAT")]
    pub const Armenian_GHAT: Keysym = Keysym(key::Armenian_GHAT);
    #[doc(alias = "XK_Armenian_ghat")]
    pub const Armenian_ghat: Keysym = Keysym(key::Armenian_ghat);
    #[doc(alias = "XK_Armenian_TCHE")]
    pub const Armenian_TCHE: Keysym = Keysym(key::Armenian_TCHE);
    #[doc(alias = "XK_Armenian_tche")]
    pub const Armenian_tche: Keysym = Keysym(key::Armenian_tche);
    #[doc(alias = "XK_Armenian_MEN")]
    pub const Armenian_MEN: Keysym = Keysym(key::Armenian_MEN);
    #[doc(alias = "XK_Armenian_men")]
    pub const Armenian_men: Keysym = Keysym(key::Armenian_men);
    #[doc(alias = "XK_Armenian_HI")]
    pub const Armenian_HI: Keysym = Keysym(key::Armenian_HI);
    #[doc(alias = "XK_Armenian_hi")]
    pub const Armenian_hi: Keysym = Keysym(key::Armenian_hi);
    #[doc(alias = "XK_Armenian_NU")]
    pub const Armenian_NU: Keysym = Keysym(key::Armenian_NU);
    #[doc(alias = "XK_Armenian_nu")]
    pub const Armenian_nu: Keysym = Keysym(key::Armenian_nu);
    #[doc(alias = "XK_Armenian_SHA")]
    pub const Armenian_SHA: Keysym = Keysym(key::Armenian_SHA);
    #[doc(alias = "XK_Armenian_sha")]
    pub const Armenian_sha: Keysym = Keysym(key::Armenian_sha);
    #[doc(alias = "XK_Armenian_VO")]
    pub const Armenian_VO: Keysym = Keysym(key::Armenian_VO);
    #[doc(alias = "XK_Armenian_vo")]
    pub const Armenian_vo: Keysym = Keysym(key::Armenian_vo);
    #[doc(alias = "XK_Armenian_CHA")]
    pub const Armenian_CHA: Keysym = Keysym(key::Armenian_CHA);
    #[doc(alias = "XK_Armenian_cha")]
    pub const Armenian_cha: Keysym = Keysym(key::Armenian_cha);
    #[doc(alias = "XK_Armenian_PE")]
    pub const Armenian_PE: Keysym = Keysym(key::Armenian_PE);
    #[doc(alias = "XK_Armenian_pe")]
    pub const Armenian_pe: Keysym = Keysym(key::Armenian_pe);
    #[doc(alias = "XK_Armenian_JE")]
    pub const Armenian_JE: Keysym = Keysym(key::Armenian_JE);
    #[doc(alias = "XK_Armenian_je")]
    pub const Armenian_je: Keysym = Keysym(key::Armenian_je);
    #[doc(alias = "XK_Armenian_RA")]
    pub const Armenian_RA: Keysym = Keysym(key::Armenian_RA);
    #[doc(alias = "XK_Armenian_ra")]
    pub const Armenian_ra: Keysym = Keysym(key::Armenian_ra);
    #[doc(alias = "XK_Armenian_SE")]
    pub const Armenian_SE: Keysym = Keysym(key::Armenian_SE);
    #[doc(alias = "XK_Armenian_se")]
    pub const Armenian_se: Keysym = Keysym(key::Armenian_se);
    #[doc(alias = "XK_Armenian_VEV")]
    pub const Armenian_VEV: Keysym = Keysym(key::Armenian_VEV);
    #[doc(alias = "XK_Armenian_vev")]
    pub const Armenian_vev: Keysym = Keysym(key::Armenian_vev);
    #[doc(alias = "XK_Armenian_TYUN")]
    pub const Armenian_TYUN: Keysym = Keysym(key::Armenian_TYUN);
    #[doc(alias = "XK_Armenian_tyun")]
    pub const Armenian_tyun: Keysym = Keysym(key::Armenian_tyun);
    #[doc(alias = "XK_Armenian_RE")]
    pub const Armenian_RE: Keysym = Keysym(key::Armenian_RE);
    #[doc(alias = "XK_Armenian_re")]
    pub const Armenian_re: Keysym = Keysym(key::Armenian_re);
    #[doc(alias = "XK_Armenian_TSO")]
    pub const Armenian_TSO: Keysym = Keysym(key::Armenian_TSO);
    #[doc(alias = "XK_Armenian_tso")]
    pub const Armenian_tso: Keysym = Keysym(key::Armenian_tso);
    #[doc(alias = "XK_Armenian_VYUN")]
    pub const Armenian_VYUN: Keysym = Keysym(key::Armenian_VYUN);
    #[doc(alias = "XK_Armenian_vyun")]
    pub const Armenian_vyun: Keysym = Keysym(key::Armenian_vyun);
    #[doc(alias = "XK_Armenian_PYUR")]
    pub const Armenian_PYUR: Keysym = Keysym(key::Armenian_PYUR);
    #[doc(alias = "XK_Armenian_pyur")]
    pub const Armenian_pyur: Keysym = Keysym(key::Armenian_pyur);
    #[doc(alias = "XK_Armenian_KE")]
    pub const Armenian_KE: Keysym = Keysym(key::Armenian_KE);
    #[doc(alias = "XK_Armenian_ke")]
    pub const Armenian_ke: Keysym = Keysym(key::Armenian_ke);
    #[doc(alias = "XK_Armenian_O")]
    pub const Armenian_O: Keysym = Keysym(key::Armenian_O);
    #[doc(alias = "XK_Armenian_o")]
    pub const Armenian_o: Keysym = Keysym(key::Armenian_o);
    #[doc(alias = "XK_Armenian_FE")]
    pub const Armenian_FE: Keysym = Keysym(key::Armenian_FE);
    #[doc(alias = "XK_Armenian_fe")]
    pub const Armenian_fe: Keysym = Keysym(key::Armenian_fe);
    #[doc(alias = "XK_Armenian_apostrophe")]
    pub const Armenian_apostrophe: Keysym = Keysym(key::Armenian_apostrophe);
    #[doc(alias = "XK_Georgian_an")]
    pub const Georgian_an: Keysym = Keysym(key::Georgian_an);
    #[doc(alias = "XK_Georgian_ban")]
    pub const Georgian_ban: Keysym = Keysym(key::Georgian_ban);
    #[doc(alias = "XK_Georgian_gan")]
    pub const Georgian_gan: Keysym = Keysym(key::Georgian_gan);
    #[doc(alias = "XK_Georgian_don")]
    pub const Georgian_don: Keysym = Keysym(key::Georgian_don);
    #[doc(alias = "XK_Georgian_en")]
    pub const Georgian_en: Keysym = Keysym(key::Georgian_en);
    #[doc(alias = "XK_Georgian_vin")]
    pub const Georgian_vin: Keysym = Keysym(key::Georgian_vin);
    #[doc(alias = "XK_Georgian_zen")]
    pub const Georgian_zen: Keysym = Keysym(key::Georgian_zen);
    #[doc(alias = "XK_Georgian_tan")]
    pub const Georgian_tan: Keysym = Keysym(key::Georgian_tan);
    #[doc(alias = "XK_Georgian_in")]
    pub const Georgian_in: Keysym = Keysym(key::Georgian_in);
    #[doc(alias = "XK_Georgian_kan")]
    pub const Georgian_kan: Keysym = Keysym(key::Georgian_kan);
    #[doc(alias = "XK_Georgian_las")]
    pub const Georgian_las: Keysym = Keysym(key::Georgian_las);
    #[doc(alias = "XK_Georgian_man")]
    pub const Georgian_man: Keysym = Keysym(key::Georgian_man);
    #[doc(alias = "XK_Georgian_nar")]
    pub const Georgian_nar: Keysym = Keysym(key::Georgian_nar);
    #[doc(alias = "XK_Georgian_on")]
    pub const Georgian_on: Keysym = Keysym(key::Georgian_on);
    #[doc(alias = "XK_Georgian_par")]
    pub const Georgian_par: Keysym = Keysym(key::Georgian_par);
    #[doc(alias = "XK_Georgian_zhar")]
    pub const Georgian_zhar: Keysym = Keysym(key::Georgian_zhar);
    #[doc(alias = "XK_Georgian_rae")]
    pub const Georgian_rae: Keysym = Keysym(key::Georgian_rae);
    #[doc(alias = "XK_Georgian_san")]
    pub const Georgian_san: Keysym = Keysym(key::Georgian_san);
    #[doc(alias = "XK_Georgian_tar")]
    pub const Georgian_tar: Keysym = Keysym(key::Georgian_tar);
    #[doc(alias = "XK_Georgian_un")]
    pub const Georgian_un: Keysym = Keysym(key::Georgian_un);
    #[doc(alias = "XK_Georgian_phar")]
    pub const Georgian_phar: Keysym = Keysym(key::Georgian_phar);
    #[doc(alias = "XK_Georgian_khar")]
    pub const Georgian_khar: Keysym = Keysym(key::Georgian_khar);
    #[doc(alias = "XK_Georgian_ghan")]
    pub const Georgian_ghan: Keysym = Keysym(key::Georgian_ghan);
    #[doc(alias = "XK_Georgian_qar")]
    pub const Georgian_qar: Keysym = Keysym(key::Georgian_qar);
    #[doc(alias = "XK_Georgian_shin")]
    pub const Georgian_shin: Keysym = Keysym(key::Georgian_shin);
    #[doc(alias = "XK_Georgian_chin")]
    pub const Georgian_chin: Keysym = Keysym(key::Georgian_chin);
    #[doc(alias = "XK_Georgian_can")]
    pub const Georgian_can: Keysym = Keysym(key::Georgian_can);
    #[doc(alias = "XK_Georgian_jil")]
    pub const Georgian_jil: Keysym = Keysym(key::Georgian_jil);
    #[doc(alias = "XK_Georgian_cil")]
    pub const Georgian_cil: Keysym = Keysym(key::Georgian_cil);
    #[doc(alias = "XK_Georgian_char")]
    pub const Georgian_char: Keysym = Keysym(key::Georgian_char);
    #[doc(alias = "XK_Georgian_xan")]
    pub const Georgian_xan: Keysym = Keysym(key::Georgian_xan);
    #[doc(alias = "XK_Georgian_jhan")]
    pub const Georgian_jhan: Keysym = Keysym(key::Georgian_jhan);
    #[doc(alias = "XK_Georgian_hae")]
    pub const Georgian_hae: Keysym = Keysym(key::Georgian_hae);
    #[doc(alias = "XK_Georgian_he")]
    pub const Georgian_he: Keysym = Keysym(key::Georgian_he);
    #[doc(alias = "XK_Georgian_hie")]
    pub const Georgian_hie: Keysym = Keysym(key::Georgian_hie);
    #[doc(alias = "XK_Georgian_we")]
    pub const Georgian_we: Keysym = Keysym(key::Georgian_we);
    #[doc(alias = "XK_Georgian_har")]
    pub const Georgian_har: Keysym = Keysym(key::Georgian_har);
    #[doc(alias = "XK_Georgian_hoe")]
    pub const Georgian_hoe: Keysym = Keysym(key::Georgian_hoe);
    #[doc(alias = "XK_Georgian_fi")]
    pub const Georgian_fi: Keysym = Keysym(key::Georgian_fi);
    #[doc(alias = "XK_Xabovedot")]
    pub const Xabovedot: Keysym = Keysym(key::Xabovedot);
    #[doc(alias = "XK_Ibreve")]
    pub const Ibreve: Keysym = Keysym(key::Ibreve);
    #[doc(alias = "XK_Zstroke")]
    pub const Zstroke: Keysym = Keysym(key::Zstroke);
    #[doc(alias = "XK_Gcaron")]
    pub const Gcaron: Keysym = Keysym(key::Gcaron);
    #[doc(alias = "XK_Ocaron")]
    pub const Ocaron: Keysym = Keysym(key::Ocaron);
    #[doc(alias = "XK_Obarred")]
    pub const Obarred: Keysym = Keysym(key::Obarred);
    #[doc(alias = "XK_xabovedot")]
    pub const xabovedot: Keysym = Keysym(key::xabovedot);
    #[doc(alias = "XK_ibreve")]
    pub const ibreve: Keysym = Keysym(key::ibreve);
    #[doc(alias = "XK_zstroke")]
    pub const zstroke: Keysym = Keysym(key::zstroke);
    #[doc(alias = "XK_gcaron")]
    pub const gcaron: Keysym = Keysym(key::gcaron);
    #[doc(alias = "XK_ocaron")]
    pub const ocaron: Keysym = Keysym(key::ocaron);
    #[doc(alias = "XK_obarred")]
    pub const obarred: Keysym = Keysym(key::obarred);
    #[doc(alias = "XK_SCHWA")]
    pub const SCHWA: Keysym = Keysym(key::SCHWA);
    #[doc(alias = "XK_schwa")]
    pub const schwa: Keysym = Keysym(key::schwa);
    #[doc(alias = "XK_EZH")]
    pub const EZH: Keysym = Keysym(key::EZH);
    #[doc(alias = "XK_ezh")]
    pub const ezh: Keysym = Keysym(key::ezh);
    #[doc(alias = "XK_Lbelowdot")]
    pub const Lbelowdot: Keysym = Keysym(key::Lbelowdot);
    #[doc(alias = "XK_lbelowdot")]
    pub const lbelowdot: Keysym = Keysym(key::lbelowdot);
    #[doc(alias = "XK_Abelowdot")]
    pub const Abelowdot: Keysym = Keysym(key::Abelowdot);
    #[doc(alias = "XK_abelowdot")]
    pub const abelowdot: Keysym = Keysym(key::abelowdot);
    #[doc(alias = "XK_Ahook")]
    pub const Ahook: Keysym = Keysym(key::Ahook);
    #[doc(alias = "XK_ahook")]
    pub const ahook: Keysym = Keysym(key::ahook);
    #[doc(alias = "XK_Acircumflexacute")]
    pub const Acircumflexacute: Keysym = Keysym(key::Acircumflexacute);
    #[doc(alias = "XK_acircumflexacute")]
    pub const acircumflexacute: Keysym = Keysym(key::acircumflexacute);
    #[doc(alias = "XK_Acircumflexgrave")]
    pub const Acircumflexgrave: Keysym = Keysym(key::Acircumflexgrave);
    #[doc(alias = "XK_acircumflexgrave")]
    pub const acircumflexgrave: Keysym = Keysym(key::acircumflexgrave);
    #[doc(alias = "XK_Acircumflexhook")]
    pub const Acircumflexhook: Keysym = Keysym(key::Acircumflexhook);
    #[doc(alias = "XK_acircumflexhook")]
    pub const acircumflexhook: Keysym = Keysym(key::acircumflexhook);
    #[doc(alias = "XK_Acircumflextilde")]
    pub const Acircumflextilde: Keysym = Keysym(key::Acircumflextilde);
    #[doc(alias = "XK_acircumflextilde")]
    pub const acircumflextilde: Keysym = Keysym(key::acircumflextilde);
    #[doc(alias = "XK_Acircumflexbelowdot")]
    pub const Acircumflexbelowdot: Keysym = Keysym(key::Acircumflexbelowdot);
    #[doc(alias = "XK_acircumflexbelowdot")]
    pub const acircumflexbelowdot: Keysym = Keysym(key::acircumflexbelowdot);
    #[doc(alias = "XK_Abreveacute")]
    pub const Abreveacute: Keysym = Keysym(key::Abreveacute);
    #[doc(alias = "XK_abreveacute")]
    pub const abreveacute: Keysym = Keysym(key::abreveacute);
    #[doc(alias = "XK_Abrevegrave")]
    pub const Abrevegrave: Keysym = Keysym(key::Abrevegrave);
    #[doc(alias = "XK_abrevegrave")]
    pub const abrevegrave: Keysym = Keysym(key::abrevegrave);
    #[doc(alias = "XK_Abrevehook")]
    pub const Abrevehook: Keysym = Keysym(key::Abrevehook);
    #[doc(alias = "XK_abrevehook")]
    pub const abrevehook: Keysym = Keysym(key::abrevehook);
    #[doc(alias = "XK_Abrevetilde")]
    pub const Abrevetilde: Keysym = Keysym(key::Abrevetilde);
    #[doc(alias = "XK_abrevetilde")]
    pub const abrevetilde: Keysym = Keysym(key::abrevetilde);
    #[doc(alias = "XK_Abrevebelowdot")]
    pub const Abrevebelowdot: Keysym = Keysym(key::Abrevebelowdot);
    #[doc(alias = "XK_abrevebelowdot")]
    pub const abrevebelowdot: Keysym = Keysym(key::abrevebelowdot);
    #[doc(alias = "XK_Ebelowdot")]
    pub const Ebelowdot: Keysym = Keysym(key::Ebelowdot);
    #[doc(alias = "XK_ebelowdot")]
    pub const ebelowdot: Keysym = Keysym(key::ebelowdot);
    #[doc(alias = "XK_Ehook")]
    pub const Ehook: Keysym = Keysym(key::Ehook);
    #[doc(alias = "XK_ehook")]
    pub const ehook: Keysym = Keysym(key::ehook);
    #[doc(alias = "XK_Etilde")]
    pub const Etilde: Keysym = Keysym(key::Etilde);
    #[doc(alias = "XK_etilde")]
    pub const etilde: Keysym = Keysym(key::etilde);
    #[doc(alias = "XK_Ecircumflexacute")]
    pub const Ecircumflexacute: Keysym = Keysym(key::Ecircumflexacute);
    #[doc(alias = "XK_ecircumflexacute")]
    pub const ecircumflexacute: Keysym = Keysym(key::ecircumflexacute);
    #[doc(alias = "XK_Ecircumflexgrave")]
    pub const Ecircumflexgrave: Keysym = Keysym(key::Ecircumflexgrave);
    #[doc(alias = "XK_ecircumflexgrave")]
    pub const ecircumflexgrave: Keysym = Keysym(key::ecircumflexgrave);
    #[doc(alias = "XK_Ecircumflexhook")]
    pub const Ecircumflexhook: Keysym = Keysym(key::Ecircumflexhook);
    #[doc(alias = "XK_ecircumflexhook")]
    pub const ecircumflexhook: Keysym = Keysym(key::ecircumflexhook);
    #[doc(alias = "XK_Ecircumflextilde")]
    pub const Ecircumflextilde: Keysym = Keysym(key::Ecircumflextilde);
    #[doc(alias = "XK_ecircumflextilde")]
    pub const ecircumflextilde: Keysym = Keysym(key::ecircumflextilde);
    #[doc(alias = "XK_Ecircumflexbelowdot")]
    pub const Ecircumflexbelowdot: Keysym = Keysym(key::Ecircumflexbelowdot);
    #[doc(alias = "XK_ecircumflexbelowdot")]
    pub const ecircumflexbelowdot: Keysym = Keysym(key::ecircumflexbelowdot);
    #[doc(alias = "XK_Ihook")]
    pub const Ihook: Keysym = Keysym(key::Ihook);
    #[doc(alias = "XK_ihook")]
    pub const ihook: Keysym = Keysym(key::ihook);
    #[doc(alias = "XK_Ibelowdot")]
    pub const Ibelowdot: Keysym = Keysym(key::Ibelowdot);
    #[doc(alias = "XK_ibelowdot")]
    pub const ibelowdot: Keysym = Keysym(key::ibelowdot);
    #[doc(alias = "XK_Obelowdot")]
    pub const Obelowdot: Keysym = Keysym(key::Obelowdot);
    #[doc(alias = "XK_obelowdot")]
    pub const obelowdot: Keysym = Keysym(key::obelowdot);
    #[doc(alias = "XK_Ohook")]
    pub const Ohook: Keysym = Keysym(key::Ohook);
    #[doc(alias = "XK_ohook")]
    pub const ohook: Keysym = Keysym(key::ohook);
    #[doc(alias = "XK_Ocircumflexacute")]
    pub const Ocircumflexacute: Keysym = Keysym(key::Ocircumflexacute);
    #[doc(alias = "XK_ocircumflexacute")]
    pub const ocircumflexacute: Keysym = Keysym(key::ocircumflexacute);
    #[doc(alias = "XK_Ocircumflexgrave")]
    pub const Ocircumflexgrave: Keysym = Keysym(key::Ocircumflexgrave);
    #[doc(alias = "XK_ocircumflexgrave")]
    pub const ocircumflexgrave: Keysym = Keysym(key::ocircumflexgrave);
    #[doc(alias = "XK_Ocircumflexhook")]
    pub const Ocircumflexhook: Keysym = Keysym(key::Ocircumflexhook);
    #[doc(alias = "XK_ocircumflexhook")]
    pub const ocircumflexhook: Keysym = Keysym(key::ocircumflexhook);
    #[doc(alias = "XK_Ocircumflextilde")]
    pub const Ocircumflextilde: Keysym = Keysym(key::Ocircumflextilde);
    #[doc(alias = "XK_ocircumflextilde")]
    pub const ocircumflextilde: Keysym = Keysym(key::ocircumflextilde);
    #[doc(alias = "XK_Ocircumflexbelowdot")]
    pub const Ocircumflexbelowdot: Keysym = Keysym(key::Ocircumflexbelowdot);
    #[doc(alias = "XK_ocircumflexbelowdot")]
    pub const ocircumflexbelowdot: Keysym = Keysym(key::ocircumflexbelowdot);
    #[doc(alias = "XK_Ohornacute")]
    pub const Ohornacute: Keysym = Keysym(key::Ohornacute);
    #[doc(alias = "XK_ohornacute")]
    pub const ohornacute: Keysym = Keysym(key::ohornacute);
    #[doc(alias = "XK_Ohorngrave")]
    pub const Ohorngrave: Keysym = Keysym(key::Ohorngrave);
    #[doc(alias = "XK_ohorngrave")]
    pub const ohorngrave: Keysym = Keysym(key::ohorngrave);
    #[doc(alias = "XK_Ohornhook")]
    pub const Ohornhook: Keysym = Keysym(key::Ohornhook);
    #[doc(alias = "XK_ohornhook")]
    pub const ohornhook: Keysym = Keysym(key::ohornhook);
    #[doc(alias = "XK_Ohorntilde")]
    pub const Ohorntilde: Keysym = Keysym(key::Ohorntilde);
    #[doc(alias = "XK_ohorntilde")]
    pub const ohorntilde: Keysym = Keysym(key::ohorntilde);
    #[doc(alias = "XK_Ohornbelowdot")]
    pub const Ohornbelowdot: Keysym = Keysym(key::Ohornbelowdot);
    #[doc(alias = "XK_ohornbelowdot")]
    pub const ohornbelowdot: Keysym = Keysym(key::ohornbelowdot);
    #[doc(alias = "XK_Ubelowdot")]
    pub const Ubelowdot: Keysym = Keysym(key::Ubelowdot);
    #[doc(alias = "XK_ubelowdot")]
    pub const ubelowdot: Keysym = Keysym(key::ubelowdot);
    #[doc(alias = "XK_Uhook")]
    pub const Uhook: Keysym = Keysym(key::Uhook);
    #[doc(alias = "XK_uhook")]
    pub const uhook: Keysym = Keysym(key::uhook);
    #[doc(alias = "XK_Uhornacute")]
    pub const Uhornacute: Keysym = Keysym(key::Uhornacute);
    #[doc(alias = "XK_uhornacute")]
    pub const uhornacute: Keysym = Keysym(key::uhornacute);
    #[doc(alias = "XK_Uhorngrave")]
    pub const Uhorngrave: Keysym = Keysym(key::Uhorngrave);
    #[doc(alias = "XK_uhorngrave")]
    pub const uhorngrave: Keysym = Keysym(key::uhorngrave);
    #[doc(alias = "XK_Uhornhook")]
    pub const Uhornhook: Keysym = Keysym(key::Uhornhook);
    #[doc(alias = "XK_uhornhook")]
    pub const uhornhook: Keysym = Keysym(key::uhornhook);
    #[doc(alias = "XK_Uhorntilde")]
    pub const Uhorntilde: Keysym = Keysym(key::Uhorntilde);
    #[doc(alias = "XK_uhorntilde")]
    pub const uhorntilde: Keysym = Keysym(key::uhorntilde);
    #[doc(alias = "XK_Uhornbelowdot")]
    pub const Uhornbelowdot: Keysym = Keysym(key::Uhornbelowdot);
    #[doc(alias = "XK_uhornbelowdot")]
    pub const uhornbelowdot: Keysym = Keysym(key::uhornbelowdot);
    #[doc(alias = "XK_Ybelowdot")]
    pub const Ybelowdot: Keysym = Keysym(key::Ybelowdot);
    #[doc(alias = "XK_ybelowdot")]
    pub const ybelowdot: Keysym = Keysym(key::ybelowdot);
    #[doc(alias = "XK_Yhook")]
    pub const Yhook: Keysym = Keysym(key::Yhook);
    #[doc(alias = "XK_yhook")]
    pub const yhook: Keysym = Keysym(key::yhook);
    #[doc(alias = "XK_Ytilde")]
    pub const Ytilde: Keysym = Keysym(key::Ytilde);
    #[doc(alias = "XK_ytilde")]
    pub const ytilde: Keysym = Keysym(key::ytilde);
    #[doc(alias = "XK_Ohorn")]
    pub const Ohorn: Keysym = Keysym(key::Ohorn);
    #[doc(alias = "XK_ohorn")]
    pub const ohorn: Keysym = Keysym(key::ohorn);
    #[doc(alias = "XK_Uhorn")]
    pub const Uhorn: Keysym = Keysym(key::Uhorn);
    #[doc(alias = "XK_uhorn")]
    pub const uhorn: Keysym = Keysym(key::uhorn);
    #[doc(alias = "XK_combining_tilde")]
    pub const combining_tilde: Keysym = Keysym(key::combining_tilde);
    #[doc(alias = "XK_combining_grave")]
    pub const combining_grave: Keysym = Keysym(key::combining_grave);
    #[doc(alias = "XK_combining_acute")]
    pub const combining_acute: Keysym = Keysym(key::combining_acute);
    #[doc(alias = "XK_combining_hook")]
    pub const combining_hook: Keysym = Keysym(key::combining_hook);
    #[doc(alias = "XK_combining_belowdot")]
    pub const combining_belowdot: Keysym = Keysym(key::combining_belowdot);
    #[doc(alias = "XK_EcuSign")]
    pub const EcuSign: Keysym = Keysym(key::EcuSign);
    #[doc(alias = "XK_ColonSign")]
    pub const ColonSign: Keysym = Keysym(key::ColonSign);
    #[doc(alias = "XK_CruzeiroSign")]
    pub const CruzeiroSign: Keysym = Keysym(key::CruzeiroSign);
    #[doc(alias = "XK_FFrancSign")]
    pub const FFrancSign: Keysym = Keysym(key::FFrancSign);
    #[doc(alias = "XK_LiraSign")]
    pub const LiraSign: Keysym = Keysym(key::LiraSign);
    #[doc(alias = "XK_MillSign")]
    pub const MillSign: Keysym = Keysym(key::MillSign);
    #[doc(alias = "XK_NairaSign")]
    pub const NairaSign: Keysym = Keysym(key::NairaSign);
    #[doc(alias = "XK_PesetaSign")]
    pub const PesetaSign: Keysym = Keysym(key::PesetaSign);
    #[doc(alias = "XK_RupeeSign")]
    pub const RupeeSign: Keysym = Keysym(key::RupeeSign);
    #[doc(alias = "XK_WonSign")]
    pub const WonSign: Keysym = Keysym(key::WonSign);
    #[doc(alias = "XK_NewSheqelSign")]
    pub const NewSheqelSign: Keysym = Keysym(key::NewSheqelSign);
    #[doc(alias = "XK_DongSign")]
    pub const DongSign: Keysym = Keysym(key::DongSign);
    #[doc(alias = "XK_EuroSign")]
    pub const EuroSign: Keysym = Keysym(key::EuroSign);
    #[doc(alias = "XK_zerosuperior")]
    pub const zerosuperior: Keysym = Keysym(key::zerosuperior);
    #[doc(alias = "XK_foursuperior")]
    pub const foursuperior: Keysym = Keysym(key::foursuperior);
    #[doc(alias = "XK_fivesuperior")]
    pub const fivesuperior: Keysym = Keysym(key::fivesuperior);
    #[doc(alias = "XK_sixsuperior")]
    pub const sixsuperior: Keysym = Keysym(key::sixsuperior);
    #[doc(alias = "XK_sevensuperior")]
    pub const sevensuperior: Keysym = Keysym(key::sevensuperior);
    #[doc(alias = "XK_eightsuperior")]
    pub const eightsuperior: Keysym = Keysym(key::eightsuperior);
    #[doc(alias = "XK_ninesuperior")]
    pub const ninesuperior: Keysym = Keysym(key::ninesuperior);
    #[doc(alias = "XK_zerosubscript")]
    pub const zerosubscript: Keysym = Keysym(key::zerosubscript);
    #[doc(alias = "XK_onesubscript")]
    pub const onesubscript: Keysym = Keysym(key::onesubscript);
    #[doc(alias = "XK_twosubscript")]
    pub const twosubscript: Keysym = Keysym(key::twosubscript);
    #[doc(alias = "XK_threesubscript")]
    pub const threesubscript: Keysym = Keysym(key::threesubscript);
    #[doc(alias = "XK_foursubscript")]
    pub const foursubscript: Keysym = Keysym(key::foursubscript);
    #[doc(alias = "XK_fivesubscript")]
    pub const fivesubscript: Keysym = Keysym(key::fivesubscript);
    #[doc(alias = "XK_sixsubscript")]
    pub const sixsubscript: Keysym = Keysym(key::sixsubscript);
    #[doc(alias = "XK_sevensubscript")]
    pub const sevensubscript: Keysym = Keysym(key::sevensubscript);
    #[doc(alias = "XK_eightsubscript")]
    pub const eightsubscript: Keysym = Keysym(key::eightsubscript);
    #[doc(alias = "XK_ninesubscript")]
    pub const ninesubscript: Keysym = Keysym(key::ninesubscript);
    #[doc(alias = "XK_partdifferential")]
    pub const partdifferential: Keysym = Keysym(key::partdifferential);
    #[doc(alias = "XK_emptyset")]
    pub const emptyset: Keysym = Keysym(key::emptyset);
    #[doc(alias = "XK_elementof")]
    pub const elementof: Keysym = Keysym(key::elementof);
    #[doc(alias = "XK_notelementof")]
    pub const notelementof: Keysym = Keysym(key::notelementof);
    #[doc(alias = "XK_containsas")]
    pub const containsas: Keysym = Keysym(key::containsas);
    #[doc(alias = "XK_squareroot")]
    pub const squareroot: Keysym = Keysym(key::squareroot);
    #[doc(alias = "XK_cuberoot")]
    pub const cuberoot: Keysym = Keysym(key::cuberoot);
    #[doc(alias = "XK_fourthroot")]
    pub const fourthroot: Keysym = Keysym(key::fourthroot);
    #[doc(alias = "XK_dintegral")]
    pub const dintegral: Keysym = Keysym(key::dintegral);
    #[doc(alias = "XK_tintegral")]
    pub const tintegral: Keysym = Keysym(key::tintegral);
    #[doc(alias = "XK_because")]
    pub const because: Keysym = Keysym(key::because);
    #[doc(alias = "XK_approxeq")]
    pub const approxeq: Keysym = Keysym(key::approxeq);
    #[doc(alias = "XK_notapproxeq")]
    pub const notapproxeq: Keysym = Keysym(key::notapproxeq);
    #[doc(alias = "XK_notidentical")]
    pub const notidentical: Keysym = Keysym(key::notidentical);
    #[doc(alias = "XK_stricteq")]
    pub const stricteq: Keysym = Keysym(key::stricteq);
    #[doc(alias = "XK_braille_dot_1")]
    pub const braille_dot_1: Keysym = Keysym(key::braille_dot_1);
    #[doc(alias = "XK_braille_dot_2")]
    pub const braille_dot_2: Keysym = Keysym(key::braille_dot_2);
    #[doc(alias = "XK_braille_dot_3")]
    pub const braille_dot_3: Keysym = Keysym(key::braille_dot_3);
    #[doc(alias = "XK_braille_dot_4")]
    pub const braille_dot_4: Keysym = Keysym(key::braille_dot_4);
    #[doc(alias = "XK_braille_dot_5")]
    pub const braille_dot_5: Keysym = Keysym(key::braille_dot_5);
    #[doc(alias = "XK_braille_dot_6")]
    pub const braille_dot_6: Keysym = Keysym(key::braille_dot_6);
    #[doc(alias = "XK_braille_dot_7")]
    pub const braille_dot_7: Keysym = Keysym(key::braille_dot_7);
    #[doc(alias = "XK_braille_dot_8")]
    pub const braille_dot_8: Keysym = Keysym(key::braille_dot_8);
    #[doc(alias = "XK_braille_dot_9")]
    pub const braille_dot_9: Keysym = Keysym(key::braille_dot_9);
    #[doc(alias = "XK_braille_dot_10")]
    pub const braille_dot_10: Keysym = Keysym(key::braille_dot_10);
    #[doc(alias = "XK_braille_blank")]
    pub const braille_blank: Keysym = Keysym(key::braille_blank);
    #[doc(alias = "XK_braille_dots_1")]
    pub const braille_dots_1: Keysym = Keysym(key::braille_dots_1);
    #[doc(alias = "XK_braille_dots_2")]
    pub const braille_dots_2: Keysym = Keysym(key::braille_dots_2);
    #[doc(alias = "XK_braille_dots_12")]
    pub const braille_dots_12: Keysym = Keysym(key::braille_dots_12);
    #[doc(alias = "XK_braille_dots_3")]
    pub const braille_dots_3: Keysym = Keysym(key::braille_dots_3);
    #[doc(alias = "XK_braille_dots_13")]
    pub const braille_dots_13: Keysym = Keysym(key::braille_dots_13);
    #[doc(alias = "XK_braille_dots_23")]
    pub const braille_dots_23: Keysym = Keysym(key::braille_dots_23);
    #[doc(alias = "XK_braille_dots_123")]
    pub const braille_dots_123: Keysym = Keysym(key::braille_dots_123);
    #[doc(alias = "XK_braille_dots_4")]
    pub const braille_dots_4: Keysym = Keysym(key::braille_dots_4);
    #[doc(alias = "XK_braille_dots_14")]
    pub const braille_dots_14: Keysym = Keysym(key::braille_dots_14);
    #[doc(alias = "XK_braille_dots_24")]
    pub const braille_dots_24: Keysym = Keysym(key::braille_dots_24);
    #[doc(alias = "XK_braille_dots_124")]
    pub const braille_dots_124: Keysym = Keysym(key::braille_dots_124);
    #[doc(alias = "XK_braille_dots_34")]
    pub const braille_dots_34: Keysym = Keysym(key::braille_dots_34);
    #[doc(alias = "XK_braille_dots_134")]
    pub const braille_dots_134: Keysym = Keysym(key::braille_dots_134);
    #[doc(alias = "XK_braille_dots_234")]
    pub const braille_dots_234: Keysym = Keysym(key::braille_dots_234);
    #[doc(alias = "XK_braille_dots_1234")]
    pub const braille_dots_1234: Keysym = Keysym(key::braille_dots_1234);
    #[doc(alias = "XK_braille_dots_5")]
    pub const braille_dots_5: Keysym = Keysym(key::braille_dots_5);
    #[doc(alias = "XK_braille_dots_15")]
    pub const braille_dots_15: Keysym = Keysym(key::braille_dots_15);
    #[doc(alias = "XK_braille_dots_25")]
    pub const braille_dots_25: Keysym = Keysym(key::braille_dots_25);
    #[doc(alias = "XK_braille_dots_125")]
    pub const braille_dots_125: Keysym = Keysym(key::braille_dots_125);
    #[doc(alias = "XK_braille_dots_35")]
    pub const braille_dots_35: Keysym = Keysym(key::braille_dots_35);
    #[doc(alias = "XK_braille_dots_135")]
    pub const braille_dots_135: Keysym = Keysym(key::braille_dots_135);
    #[doc(alias = "XK_braille_dots_235")]
    pub const braille_dots_235: Keysym = Keysym(key::braille_dots_235);
    #[doc(alias = "XK_braille_dots_1235")]
    pub const braille_dots_1235: Keysym = Keysym(key::braille_dots_1235);
    #[doc(alias = "XK_braille_dots_45")]
    pub const braille_dots_45: Keysym = Keysym(key::braille_dots_45);
    #[doc(alias = "XK_braille_dots_145")]
    pub const braille_dots_145: Keysym = Keysym(key::braille_dots_145);
    #[doc(alias = "XK_braille_dots_245")]
    pub const braille_dots_245: Keysym = Keysym(key::braille_dots_245);
    #[doc(alias = "XK_braille_dots_1245")]
    pub const braille_dots_1245: Keysym = Keysym(key::braille_dots_1245);
    #[doc(alias = "XK_braille_dots_345")]
    pub const braille_dots_345: Keysym = Keysym(key::braille_dots_345);
    #[doc(alias = "XK_braille_dots_1345")]
    pub const braille_dots_1345: Keysym = Keysym(key::braille_dots_1345);
    #[doc(alias = "XK_braille_dots_2345")]
    pub const braille_dots_2345: Keysym = Keysym(key::braille_dots_2345);
    #[doc(alias = "XK_braille_dots_12345")]
    pub const braille_dots_12345: Keysym = Keysym(key::braille_dots_12345);
    #[doc(alias = "XK_braille_dots_6")]
    pub const braille_dots_6: Keysym = Keysym(key::braille_dots_6);
    #[doc(alias = "XK_braille_dots_16")]
    pub const braille_dots_16: Keysym = Keysym(key::braille_dots_16);
    #[doc(alias = "XK_braille_dots_26")]
    pub const braille_dots_26: Keysym = Keysym(key::braille_dots_26);
    #[doc(alias = "XK_braille_dots_126")]
    pub const braille_dots_126: Keysym = Keysym(key::braille_dots_126);
    #[doc(alias = "XK_braille_dots_36")]
    pub const braille_dots_36: Keysym = Keysym(key::braille_dots_36);
    #[doc(alias = "XK_braille_dots_136")]
    pub const braille_dots_136: Keysym = Keysym(key::braille_dots_136);
    #[doc(alias = "XK_braille_dots_236")]
    pub const braille_dots_236: Keysym = Keysym(key::braille_dots_236);
    #[doc(alias = "XK_braille_dots_1236")]
    pub const braille_dots_1236: Keysym = Keysym(key::braille_dots_1236);
    #[doc(alias = "XK_braille_dots_46")]
    pub const braille_dots_46: Keysym = Keysym(key::braille_dots_46);
    #[doc(alias = "XK_braille_dots_146")]
    pub const braille_dots_146: Keysym = Keysym(key::braille_dots_146);
    #[doc(alias = "XK_braille_dots_246")]
    pub const braille_dots_246: Keysym = Keysym(key::braille_dots_246);
    #[doc(alias = "XK_braille_dots_1246")]
    pub const braille_dots_1246: Keysym = Keysym(key::braille_dots_1246);
    #[doc(alias = "XK_braille_dots_346")]
    pub const braille_dots_346: Keysym = Keysym(key::braille_dots_346);
    #[doc(alias = "XK_braille_dots_1346")]
    pub const braille_dots_1346: Keysym = Keysym(key::braille_dots_1346);
    #[doc(alias = "XK_braille_dots_2346")]
    pub const braille_dots_2346: Keysym = Keysym(key::braille_dots_2346);
    #[doc(alias = "XK_braille_dots_12346")]
    pub const braille_dots_12346: Keysym = Keysym(key::braille_dots_12346);
    #[doc(alias = "XK_braille_dots_56")]
    pub const braille_dots_56: Keysym = Keysym(key::braille_dots_56);
    #[doc(alias = "XK_braille_dots_156")]
    pub const braille_dots_156: Keysym = Keysym(key::braille_dots_156);
    #[doc(alias = "XK_braille_dots_256")]
    pub const braille_dots_256: Keysym = Keysym(key::braille_dots_256);
    #[doc(alias = "XK_braille_dots_1256")]
    pub const braille_dots_1256: Keysym = Keysym(key::braille_dots_1256);
    #[doc(alias = "XK_braille_dots_356")]
    pub const braille_dots_356: Keysym = Keysym(key::braille_dots_356);
    #[doc(alias = "XK_braille_dots_1356")]
    pub const braille_dots_1356: Keysym = Keysym(key::braille_dots_1356);
    #[doc(alias = "XK_braille_dots_2356")]
    pub const braille_dots_2356: Keysym = Keysym(key::braille_dots_2356);
    #[doc(alias = "XK_braille_dots_12356")]
    pub const braille_dots_12356: Keysym = Keysym(key::braille_dots_12356);
    #[doc(alias = "XK_braille_dots_456")]
    pub const braille_dots_456: Keysym = Keysym(key::braille_dots_456);
    #[doc(alias = "XK_braille_dots_1456")]
    pub const braille_dots_1456: Keysym = Keysym(key::braille_dots_1456);
    #[doc(alias = "XK_braille_dots_2456")]
    pub const braille_dots_2456: Keysym = Keysym(key::braille_dots_2456);
    #[doc(alias = "XK_braille_dots_12456")]
    pub const braille_dots_12456: Keysym = Keysym(key::braille_dots_12456);
    #[doc(alias = "XK_braille_dots_3456")]
    pub const braille_dots_3456: Keysym = Keysym(key::braille_dots_3456);
    #[doc(alias = "XK_braille_dots_13456")]
    pub const braille_dots_13456: Keysym = Keysym(key::braille_dots_13456);
    #[doc(alias = "XK_braille_dots_23456")]
    pub const braille_dots_23456: Keysym = Keysym(key::braille_dots_23456);
    #[doc(alias = "XK_braille_dots_123456")]
    pub const braille_dots_123456: Keysym = Keysym(key::braille_dots_123456);
    #[doc(alias = "XK_braille_dots_7")]
    pub const braille_dots_7: Keysym = Keysym(key::braille_dots_7);
    #[doc(alias = "XK_braille_dots_17")]
    pub const braille_dots_17: Keysym = Keysym(key::braille_dots_17);
    #[doc(alias = "XK_braille_dots_27")]
    pub const braille_dots_27: Keysym = Keysym(key::braille_dots_27);
    #[doc(alias = "XK_braille_dots_127")]
    pub const braille_dots_127: Keysym = Keysym(key::braille_dots_127);
    #[doc(alias = "XK_braille_dots_37")]
    pub const braille_dots_37: Keysym = Keysym(key::braille_dots_37);
    #[doc(alias = "XK_braille_dots_137")]
    pub const braille_dots_137: Keysym = Keysym(key::braille_dots_137);
    #[doc(alias = "XK_braille_dots_237")]
    pub const braille_dots_237: Keysym = Keysym(key::braille_dots_237);
    #[doc(alias = "XK_braille_dots_1237")]
    pub const braille_dots_1237: Keysym = Keysym(key::braille_dots_1237);
    #[doc(alias = "XK_braille_dots_47")]
    pub const braille_dots_47: Keysym = Keysym(key::braille_dots_47);
    #[doc(alias = "XK_braille_dots_147")]
    pub const braille_dots_147: Keysym = Keysym(key::braille_dots_147);
    #[doc(alias = "XK_braille_dots_247")]
    pub const braille_dots_247: Keysym = Keysym(key::braille_dots_247);
    #[doc(alias = "XK_braille_dots_1247")]
    pub const braille_dots_1247: Keysym = Keysym(key::braille_dots_1247);
    #[doc(alias = "XK_braille_dots_347")]
    pub const braille_dots_347: Keysym = Keysym(key::braille_dots_347);
    #[doc(alias = "XK_braille_dots_1347")]
    pub const braille_dots_1347: Keysym = Keysym(key::braille_dots_1347);
    #[doc(alias = "XK_braille_dots_2347")]
    pub const braille_dots_2347: Keysym = Keysym(key::braille_dots_2347);
    #[doc(alias = "XK_braille_dots_12347")]
    pub const braille_dots_12347: Keysym = Keysym(key::braille_dots_12347);
    #[doc(alias = "XK_braille_dots_57")]
    pub const braille_dots_57: Keysym = Keysym(key::braille_dots_57);
    #[doc(alias = "XK_braille_dots_157")]
    pub const braille_dots_157: Keysym = Keysym(key::braille_dots_157);
    #[doc(alias = "XK_braille_dots_257")]
    pub const braille_dots_257: Keysym = Keysym(key::braille_dots_257);
    #[doc(alias = "XK_braille_dots_1257")]
    pub const braille_dots_1257: Keysym = Keysym(key::braille_dots_1257);
    #[doc(alias = "XK_braille_dots_357")]
    pub const braille_dots_357: Keysym = Keysym(key::braille_dots_357);
    #[doc(alias = "XK_braille_dots_1357")]
    pub const braille_dots_1357: Keysym = Keysym(key::braille_dots_1357);
    #[doc(alias = "XK_braille_dots_2357")]
    pub const braille_dots_2357: Keysym = Keysym(key::braille_dots_2357);
    #[doc(alias = "XK_braille_dots_12357")]
    pub const braille_dots_12357: Keysym = Keysym(key::braille_dots_12357);
    #[doc(alias = "XK_braille_dots_457")]
    pub const braille_dots_457: Keysym = Keysym(key::braille_dots_457);
    #[doc(alias = "XK_braille_dots_1457")]
    pub const braille_dots_1457: Keysym = Keysym(key::braille_dots_1457);
    #[doc(alias = "XK_braille_dots_2457")]
    pub const braille_dots_2457: Keysym = Keysym(key::braille_dots_2457);
    #[doc(alias = "XK_braille_dots_12457")]
    pub const braille_dots_12457: Keysym = Keysym(key::braille_dots_12457);
    #[doc(alias = "XK_braille_dots_3457")]
    pub const braille_dots_3457: Keysym = Keysym(key::braille_dots_3457);
    #[doc(alias = "XK_braille_dots_13457")]
    pub const braille_dots_13457: Keysym = Keysym(key::braille_dots_13457);
    #[doc(alias = "XK_braille_dots_23457")]
    pub const braille_dots_23457: Keysym = Keysym(key::braille_dots_23457);
    #[doc(alias = "XK_braille_dots_123457")]
    pub const braille_dots_123457: Keysym = Keysym(key::braille_dots_123457);
    #[doc(alias = "XK_braille_dots_67")]
    pub const braille_dots_67: Keysym = Keysym(key::braille_dots_67);
    #[doc(alias = "XK_braille_dots_167")]
    pub const braille_dots_167: Keysym = Keysym(key::braille_dots_167);
    #[doc(alias = "XK_braille_dots_267")]
    pub const braille_dots_267: Keysym = Keysym(key::braille_dots_267);
    #[doc(alias = "XK_braille_dots_1267")]
    pub const braille_dots_1267: Keysym = Keysym(key::braille_dots_1267);
    #[doc(alias = "XK_braille_dots_367")]
    pub const braille_dots_367: Keysym = Keysym(key::braille_dots_367);
    #[doc(alias = "XK_braille_dots_1367")]
    pub const braille_dots_1367: Keysym = Keysym(key::braille_dots_1367);
    #[doc(alias = "XK_braille_dots_2367")]
    pub const braille_dots_2367: Keysym = Keysym(key::braille_dots_2367);
    #[doc(alias = "XK_braille_dots_12367")]
    pub const braille_dots_12367: Keysym = Keysym(key::braille_dots_12367);
    #[doc(alias = "XK_braille_dots_467")]
    pub const braille_dots_467: Keysym = Keysym(key::braille_dots_467);
    #[doc(alias = "XK_braille_dots_1467")]
    pub const braille_dots_1467: Keysym = Keysym(key::braille_dots_1467);
    #[doc(alias = "XK_braille_dots_2467")]
    pub const braille_dots_2467: Keysym = Keysym(key::braille_dots_2467);
    #[doc(alias = "XK_braille_dots_12467")]
    pub const braille_dots_12467: Keysym = Keysym(key::braille_dots_12467);
    #[doc(alias = "XK_braille_dots_3467")]
    pub const braille_dots_3467: Keysym = Keysym(key::braille_dots_3467);
    #[doc(alias = "XK_braille_dots_13467")]
    pub const braille_dots_13467: Keysym = Keysym(key::braille_dots_13467);
    #[doc(alias = "XK_braille_dots_23467")]
    pub const braille_dots_23467: Keysym = Keysym(key::braille_dots_23467);
    #[doc(alias = "XK_braille_dots_123467")]
    pub const braille_dots_123467: Keysym = Keysym(key::braille_dots_123467);
    #[doc(alias = "XK_braille_dots_567")]
    pub const braille_dots_567: Keysym = Keysym(key::braille_dots_567);
    #[doc(alias = "XK_braille_dots_1567")]
    pub const braille_dots_1567: Keysym = Keysym(key::braille_dots_1567);
    #[doc(alias = "XK_braille_dots_2567")]
    pub const braille_dots_2567: Keysym = Keysym(key::braille_dots_2567);
    #[doc(alias = "XK_braille_dots_12567")]
    pub const braille_dots_12567: Keysym = Keysym(key::braille_dots_12567);
    #[doc(alias = "XK_braille_dots_3567")]
    pub const braille_dots_3567: Keysym = Keysym(key::braille_dots_3567);
    #[doc(alias = "XK_braille_dots_13567")]
    pub const braille_dots_13567: Keysym = Keysym(key::braille_dots_13567);
    #[doc(alias = "XK_braille_dots_23567")]
    pub const braille_dots_23567: Keysym = Keysym(key::braille_dots_23567);
    #[doc(alias = "XK_braille_dots_123567")]
    pub const braille_dots_123567: Keysym = Keysym(key::braille_dots_123567);
    #[doc(alias = "XK_braille_dots_4567")]
    pub const braille_dots_4567: Keysym = Keysym(key::braille_dots_4567);
    #[doc(alias = "XK_braille_dots_14567")]
    pub const braille_dots_14567: Keysym = Keysym(key::braille_dots_14567);
    #[doc(alias = "XK_braille_dots_24567")]
    pub const braille_dots_24567: Keysym = Keysym(key::braille_dots_24567);
    #[doc(alias = "XK_braille_dots_124567")]
    pub const braille_dots_124567: Keysym = Keysym(key::braille_dots_124567);
    #[doc(alias = "XK_braille_dots_34567")]
    pub const braille_dots_34567: Keysym = Keysym(key::braille_dots_34567);
    #[doc(alias = "XK_braille_dots_134567")]
    pub const braille_dots_134567: Keysym = Keysym(key::braille_dots_134567);
    #[doc(alias = "XK_braille_dots_234567")]
    pub const braille_dots_234567: Keysym = Keysym(key::braille_dots_234567);
    #[doc(alias = "XK_braille_dots_1234567")]
    pub const braille_dots_1234567: Keysym = Keysym(key::braille_dots_1234567);
    #[doc(alias = "XK_braille_dots_8")]
    pub const braille_dots_8: Keysym = Keysym(key::braille_dots_8);
    #[doc(alias = "XK_braille_dots_18")]
    pub const braille_dots_18: Keysym = Keysym(key::braille_dots_18);
    #[doc(alias = "XK_braille_dots_28")]
    pub const braille_dots_28: Keysym = Keysym(key::braille_dots_28);
    #[doc(alias = "XK_braille_dots_128")]
    pub const braille_dots_128: Keysym = Keysym(key::braille_dots_128);
    #[doc(alias = "XK_braille_dots_38")]
    pub const braille_dots_38: Keysym = Keysym(key::braille_dots_38);
    #[doc(alias = "XK_braille_dots_138")]
    pub const braille_dots_138: Keysym = Keysym(key::braille_dots_138);
    #[doc(alias = "XK_braille_dots_238")]
    pub const braille_dots_238: Keysym = Keysym(key::braille_dots_238);
    #[doc(alias = "XK_braille_dots_1238")]
    pub const braille_dots_1238: Keysym = Keysym(key::braille_dots_1238);
    #[doc(alias = "XK_braille_dots_48")]
    pub const braille_dots_48: Keysym = Keysym(key::braille_dots_48);
    #[doc(alias = "XK_braille_dots_148")]
    pub const braille_dots_148: Keysym = Keysym(key::braille_dots_148);
    #[doc(alias = "XK_braille_dots_248")]
    pub const braille_dots_248: Keysym = Keysym(key::braille_dots_248);
    #[doc(alias = "XK_braille_dots_1248")]
    pub const braille_dots_1248: Keysym = Keysym(key::braille_dots_1248);
    #[doc(alias = "XK_braille_dots_348")]
    pub const braille_dots_348: Keysym = Keysym(key::braille_dots_348);
    #[doc(alias = "XK_braille_dots_1348")]
    pub const braille_dots_1348: Keysym = Keysym(key::braille_dots_1348);
    #[doc(alias = "XK_braille_dots_2348")]
    pub const braille_dots_2348: Keysym = Keysym(key::braille_dots_2348);
    #[doc(alias = "XK_braille_dots_12348")]
    pub const braille_dots_12348: Keysym = Keysym(key::braille_dots_12348);
    #[doc(alias = "XK_braille_dots_58")]
    pub const braille_dots_58: Keysym = Keysym(key::braille_dots_58);
    #[doc(alias = "XK_braille_dots_158")]
    pub const braille_dots_158: Keysym = Keysym(key::braille_dots_158);
    #[doc(alias = "XK_braille_dots_258")]
    pub const braille_dots_258: Keysym = Keysym(key::braille_dots_258);
    #[doc(alias = "XK_braille_dots_1258")]
    pub const braille_dots_1258: Keysym = Keysym(key::braille_dots_1258);
    #[doc(alias = "XK_braille_dots_358")]
    pub const braille_dots_358: Keysym = Keysym(key::braille_dots_358);
    #[doc(alias = "XK_braille_dots_1358")]
    pub const braille_dots_1358: Keysym = Keysym(key::braille_dots_1358);
    #[doc(alias = "XK_braille_dots_2358")]
    pub const braille_dots_2358: Keysym = Keysym(key::braille_dots_2358);
    #[doc(alias = "XK_braille_dots_12358")]
    pub const braille_dots_12358: Keysym = Keysym(key::braille_dots_12358);
    #[doc(alias = "XK_braille_dots_458")]
    pub const braille_dots_458: Keysym = Keysym(key::braille_dots_458);
    #[doc(alias = "XK_braille_dots_1458")]
    pub const braille_dots_1458: Keysym = Keysym(key::braille_dots_1458);
    #[doc(alias = "XK_braille_dots_2458")]
    pub const braille_dots_2458: Keysym = Keysym(key::braille_dots_2458);
    #[doc(alias = "XK_braille_dots_12458")]
    pub const braille_dots_12458: Keysym = Keysym(key::braille_dots_12458);
    #[doc(alias = "XK_braille_dots_3458")]
    pub const braille_dots_3458: Keysym = Keysym(key::braille_dots_3458);
    #[doc(alias = "XK_braille_dots_13458")]
    pub const braille_dots_13458: Keysym = Keysym(key::braille_dots_13458);
    #[doc(alias = "XK_braille_dots_23458")]
    pub const braille_dots_23458: Keysym = Keysym(key::braille_dots_23458);
    #[doc(alias = "XK_braille_dots_123458")]
    pub const braille_dots_123458: Keysym = Keysym(key::braille_dots_123458);
    #[doc(alias = "XK_braille_dots_68")]
    pub const braille_dots_68: Keysym = Keysym(key::braille_dots_68);
    #[doc(alias = "XK_braille_dots_168")]
    pub const braille_dots_168: Keysym = Keysym(key::braille_dots_168);
    #[doc(alias = "XK_braille_dots_268")]
    pub const braille_dots_268: Keysym = Keysym(key::braille_dots_268);
    #[doc(alias = "XK_braille_dots_1268")]
    pub const braille_dots_1268: Keysym = Keysym(key::braille_dots_1268);
    #[doc(alias = "XK_braille_dots_368")]
    pub const braille_dots_368: Keysym = Keysym(key::braille_dots_368);
    #[doc(alias = "XK_braille_dots_1368")]
    pub const braille_dots_1368: Keysym = Keysym(key::braille_dots_1368);
    #[doc(alias = "XK_braille_dots_2368")]
    pub const braille_dots_2368: Keysym = Keysym(key::braille_dots_2368);
    #[doc(alias = "XK_braille_dots_12368")]
    pub const braille_dots_12368: Keysym = Keysym(key::braille_dots_12368);
    #[doc(alias = "XK_braille_dots_468")]
    pub const braille_dots_468: Keysym = Keysym(key::braille_dots_468);
    #[doc(alias = "XK_braille_dots_1468")]
    pub const braille_dots_1468: Keysym = Keysym(key::braille_dots_1468);
    #[doc(alias = "XK_braille_dots_2468")]
    pub const braille_dots_2468: Keysym = Keysym(key::braille_dots_2468);
    #[doc(alias = "XK_braille_dots_12468")]
    pub const braille_dots_12468: Keysym = Keysym(key::braille_dots_12468);
    #[doc(alias = "XK_braille_dots_3468")]
    pub const braille_dots_3468: Keysym = Keysym(key::braille_dots_3468);
    #[doc(alias = "XK_braille_dots_13468")]
    pub const braille_dots_13468: Keysym = Keysym(key::braille_dots_13468);
    #[doc(alias = "XK_braille_dots_23468")]
    pub const braille_dots_23468: Keysym = Keysym(key::braille_dots_23468);
    #[doc(alias = "XK_braille_dots_123468")]
    pub const braille_dots_123468: Keysym = Keysym(key::braille_dots_123468);
    #[doc(alias = "XK_braille_dots_568")]
    pub const braille_dots_568: Keysym = Keysym(key::braille_dots_568);
    #[doc(alias = "XK_braille_dots_1568")]
    pub const braille_dots_1568: Keysym = Keysym(key::braille_dots_1568);
    #[doc(alias = "XK_braille_dots_2568")]
    pub const braille_dots_2568: Keysym = Keysym(key::braille_dots_2568);
    #[doc(alias = "XK_braille_dots_12568")]
    pub const braille_dots_12568: Keysym = Keysym(key::braille_dots_12568);
    #[doc(alias = "XK_braille_dots_3568")]
    pub const braille_dots_3568: Keysym = Keysym(key::braille_dots_3568);
    #[doc(alias = "XK_braille_dots_13568")]
    pub const braille_dots_13568: Keysym = Keysym(key::braille_dots_13568);
    #[doc(alias = "XK_braille_dots_23568")]
    pub const braille_dots_23568: Keysym = Keysym(key::braille_dots_23568);
    #[doc(alias = "XK_braille_dots_123568")]
    pub const braille_dots_123568: Keysym = Keysym(key::braille_dots_123568);
    #[doc(alias = "XK_braille_dots_4568")]
    pub const braille_dots_4568: Keysym = Keysym(key::braille_dots_4568);
    #[doc(alias = "XK_braille_dots_14568")]
    pub const braille_dots_14568: Keysym = Keysym(key::braille_dots_14568);
    #[doc(alias = "XK_braille_dots_24568")]
    pub const braille_dots_24568: Keysym = Keysym(key::braille_dots_24568);
    #[doc(alias = "XK_braille_dots_124568")]
    pub const braille_dots_124568: Keysym = Keysym(key::braille_dots_124568);
    #[doc(alias = "XK_braille_dots_34568")]
    pub const braille_dots_34568: Keysym = Keysym(key::braille_dots_34568);
    #[doc(alias = "XK_braille_dots_134568")]
    pub const braille_dots_134568: Keysym = Keysym(key::braille_dots_134568);
    #[doc(alias = "XK_braille_dots_234568")]
    pub const braille_dots_234568: Keysym = Keysym(key::braille_dots_234568);
    #[doc(alias = "XK_braille_dots_1234568")]
    pub const braille_dots_1234568: Keysym = Keysym(key::braille_dots_1234568);
    #[doc(alias = "XK_braille_dots_78")]
    pub const braille_dots_78: Keysym = Keysym(key::braille_dots_78);
    #[doc(alias = "XK_braille_dots_178")]
    pub const braille_dots_178: Keysym = Keysym(key::braille_dots_178);
    #[doc(alias = "XK_braille_dots_278")]
    pub const braille_dots_278: Keysym = Keysym(key::braille_dots_278);
    #[doc(alias = "XK_braille_dots_1278")]
    pub const braille_dots_1278: Keysym = Keysym(key::braille_dots_1278);
    #[doc(alias = "XK_braille_dots_378")]
    pub const braille_dots_378: Keysym = Keysym(key::braille_dots_378);
    #[doc(alias = "XK_braille_dots_1378")]
    pub const braille_dots_1378: Keysym = Keysym(key::braille_dots_1378);
    #[doc(alias = "XK_braille_dots_2378")]
    pub const braille_dots_2378: Keysym = Keysym(key::braille_dots_2378);
    #[doc(alias = "XK_braille_dots_12378")]
    pub const braille_dots_12378: Keysym = Keysym(key::braille_dots_12378);
    #[doc(alias = "XK_braille_dots_478")]
    pub const braille_dots_478: Keysym = Keysym(key::braille_dots_478);
    #[doc(alias = "XK_braille_dots_1478")]
    pub const braille_dots_1478: Keysym = Keysym(key::braille_dots_1478);
    #[doc(alias = "XK_braille_dots_2478")]
    pub const braille_dots_2478: Keysym = Keysym(key::braille_dots_2478);
    #[doc(alias = "XK_braille_dots_12478")]
    pub const braille_dots_12478: Keysym = Keysym(key::braille_dots_12478);
    #[doc(alias = "XK_braille_dots_3478")]
    pub const braille_dots_3478: Keysym = Keysym(key::braille_dots_3478);
    #[doc(alias = "XK_braille_dots_13478")]
    pub const braille_dots_13478: Keysym = Keysym(key::braille_dots_13478);
    #[doc(alias = "XK_braille_dots_23478")]
    pub const braille_dots_23478: Keysym = Keysym(key::braille_dots_23478);
    #[doc(alias = "XK_braille_dots_123478")]
    pub const braille_dots_123478: Keysym = Keysym(key::braille_dots_123478);
    #[doc(alias = "XK_braille_dots_578")]
    pub const braille_dots_578: Keysym = Keysym(key::braille_dots_578);
    #[doc(alias = "XK_braille_dots_1578")]
    pub const braille_dots_1578: Keysym = Keysym(key::braille_dots_1578);
    #[doc(alias = "XK_braille_dots_2578")]
    pub const braille_dots_2578: Keysym = Keysym(key::braille_dots_2578);
    #[doc(alias = "XK_braille_dots_12578")]
    pub const braille_dots_12578: Keysym = Keysym(key::braille_dots_12578);
    #[doc(alias = "XK_braille_dots_3578")]
    pub const braille_dots_3578: Keysym = Keysym(key::braille_dots_3578);
    #[doc(alias = "XK_braille_dots_13578")]
    pub const braille_dots_13578: Keysym = Keysym(key::braille_dots_13578);
    #[doc(alias = "XK_braille_dots_23578")]
    pub const braille_dots_23578: Keysym = Keysym(key::braille_dots_23578);
    #[doc(alias = "XK_braille_dots_123578")]
    pub const braille_dots_123578: Keysym = Keysym(key::braille_dots_123578);
    #[doc(alias = "XK_braille_dots_4578")]
    pub const braille_dots_4578: Keysym = Keysym(key::braille_dots_4578);
    #[doc(alias = "XK_braille_dots_14578")]
    pub const braille_dots_14578: Keysym = Keysym(key::braille_dots_14578);
    #[doc(alias = "XK_braille_dots_24578")]
    pub const braille_dots_24578: Keysym = Keysym(key::braille_dots_24578);
    #[doc(alias = "XK_braille_dots_124578")]
    pub const braille_dots_124578: Keysym = Keysym(key::braille_dots_124578);
    #[doc(alias = "XK_braille_dots_34578")]
    pub const braille_dots_34578: Keysym = Keysym(key::braille_dots_34578);
    #[doc(alias = "XK_braille_dots_134578")]
    pub const braille_dots_134578: Keysym = Keysym(key::braille_dots_134578);
    #[doc(alias = "XK_braille_dots_234578")]
    pub const braille_dots_234578: Keysym = Keysym(key::braille_dots_234578);
    #[doc(alias = "XK_braille_dots_1234578")]
    pub const braille_dots_1234578: Keysym = Keysym(key::braille_dots_1234578);
    #[doc(alias = "XK_braille_dots_678")]
    pub const braille_dots_678: Keysym = Keysym(key::braille_dots_678);
    #[doc(alias = "XK_braille_dots_1678")]
    pub const braille_dots_1678: Keysym = Keysym(key::braille_dots_1678);
    #[doc(alias = "XK_braille_dots_2678")]
    pub const braille_dots_2678: Keysym = Keysym(key::braille_dots_2678);
    #[doc(alias = "XK_braille_dots_12678")]
    pub const braille_dots_12678: Keysym = Keysym(key::braille_dots_12678);
    #[doc(alias = "XK_braille_dots_3678")]
    pub const braille_dots_3678: Keysym = Keysym(key::braille_dots_3678);
    #[doc(alias = "XK_braille_dots_13678")]
    pub const braille_dots_13678: Keysym = Keysym(key::braille_dots_13678);
    #[doc(alias = "XK_braille_dots_23678")]
    pub const braille_dots_23678: Keysym = Keysym(key::braille_dots_23678);
    #[doc(alias = "XK_braille_dots_123678")]
    pub const braille_dots_123678: Keysym = Keysym(key::braille_dots_123678);
    #[doc(alias = "XK_braille_dots_4678")]
    pub const braille_dots_4678: Keysym = Keysym(key::braille_dots_4678);
    #[doc(alias = "XK_braille_dots_14678")]
    pub const braille_dots_14678: Keysym = Keysym(key::braille_dots_14678);
    #[doc(alias = "XK_braille_dots_24678")]
    pub const braille_dots_24678: Keysym = Keysym(key::braille_dots_24678);
    #[doc(alias = "XK_braille_dots_124678")]
    pub const braille_dots_124678: Keysym = Keysym(key::braille_dots_124678);
    #[doc(alias = "XK_braille_dots_34678")]
    pub const braille_dots_34678: Keysym = Keysym(key::braille_dots_34678);
    #[doc(alias = "XK_braille_dots_134678")]
    pub const braille_dots_134678: Keysym = Keysym(key::braille_dots_134678);
    #[doc(alias = "XK_braille_dots_234678")]
    pub const braille_dots_234678: Keysym = Keysym(key::braille_dots_234678);
    #[doc(alias = "XK_braille_dots_1234678")]
    pub const braille_dots_1234678: Keysym = Keysym(key::braille_dots_1234678);
    #[doc(alias = "XK_braille_dots_5678")]
    pub const braille_dots_5678: Keysym = Keysym(key::braille_dots_5678);
    #[doc(alias = "XK_braille_dots_15678")]
    pub const braille_dots_15678: Keysym = Keysym(key::braille_dots_15678);
    #[doc(alias = "XK_braille_dots_25678")]
    pub const braille_dots_25678: Keysym = Keysym(key::braille_dots_25678);
    #[doc(alias = "XK_braille_dots_125678")]
    pub const braille_dots_125678: Keysym = Keysym(key::braille_dots_125678);
    #[doc(alias = "XK_braille_dots_35678")]
    pub const braille_dots_35678: Keysym = Keysym(key::braille_dots_35678);
    #[doc(alias = "XK_braille_dots_135678")]
    pub const braille_dots_135678: Keysym = Keysym(key::braille_dots_135678);
    #[doc(alias = "XK_braille_dots_235678")]
    pub const braille_dots_235678: Keysym = Keysym(key::braille_dots_235678);
    #[doc(alias = "XK_braille_dots_1235678")]
    pub const braille_dots_1235678: Keysym = Keysym(key::braille_dots_1235678);
    #[doc(alias = "XK_braille_dots_45678")]
    pub const braille_dots_45678: Keysym = Keysym(key::braille_dots_45678);
    #[doc(alias = "XK_braille_dots_145678")]
    pub const braille_dots_145678: Keysym = Keysym(key::braille_dots_145678);
    #[doc(alias = "XK_braille_dots_245678")]
    pub const braille_dots_245678: Keysym = Keysym(key::braille_dots_245678);
    #[doc(alias = "XK_braille_dots_1245678")]
    pub const braille_dots_1245678: Keysym = Keysym(key::braille_dots_1245678);
    #[doc(alias = "XK_braille_dots_345678")]
    pub const braille_dots_345678: Keysym = Keysym(key::braille_dots_345678);
    #[doc(alias = "XK_braille_dots_1345678")]
    pub const braille_dots_1345678: Keysym = Keysym(key::braille_dots_1345678);
    #[doc(alias = "XK_braille_dots_2345678")]
    pub const braille_dots_2345678: Keysym = Keysym(key::braille_dots_2345678);
    #[doc(alias = "XK_braille_dots_12345678")]
    pub const braille_dots_12345678: Keysym = Keysym(key::braille_dots_12345678);
    #[doc(alias = "XK_Sinh_ng")]
    pub const Sinh_ng: Keysym = Keysym(key::Sinh_ng);
    #[doc(alias = "XK_Sinh_h2")]
    pub const Sinh_h2: Keysym = Keysym(key::Sinh_h2);
    #[doc(alias = "XK_Sinh_a")]
    pub const Sinh_a: Keysym = Keysym(key::Sinh_a);
    #[doc(alias = "XK_Sinh_aa")]
    pub const Sinh_aa: Keysym = Keysym(key::Sinh_aa);
    #[doc(alias = "XK_Sinh_ae")]
    pub const Sinh_ae: Keysym = Keysym(key::Sinh_ae);
    #[doc(alias = "XK_Sinh_aee")]
    pub const Sinh_aee: Keysym = Keysym(key::Sinh_aee);
    #[doc(alias = "XK_Sinh_i")]
    pub const Sinh_i: Keysym = Keysym(key::Sinh_i);
    #[doc(alias = "XK_Sinh_ii")]
    pub const Sinh_ii: Keysym = Keysym(key::Sinh_ii);
    #[doc(alias = "XK_Sinh_u")]
    pub const Sinh_u: Keysym = Keysym(key::Sinh_u);
    #[doc(alias = "XK_Sinh_uu")]
    pub const Sinh_uu: Keysym = Keysym(key::Sinh_uu);
    #[doc(alias = "XK_Sinh_ri")]
    pub const Sinh_ri: Keysym = Keysym(key::Sinh_ri);
    #[doc(alias = "XK_Sinh_rii")]
    pub const Sinh_rii: Keysym = Keysym(key::Sinh_rii);
    #[doc(alias = "XK_Sinh_lu")]
    pub const Sinh_lu: Keysym = Keysym(key::Sinh_lu);
    #[doc(alias = "XK_Sinh_luu")]
    pub const Sinh_luu: Keysym = Keysym(key::Sinh_luu);
    #[doc(alias = "XK_Sinh_e")]
    pub const Sinh_e: Keysym = Keysym(key::Sinh_e);
    #[doc(alias = "XK_Sinh_ee")]
    pub const Sinh_ee: Keysym = Keysym(key::Sinh_ee);
    #[doc(alias = "XK_Sinh_ai")]
    pub const Sinh_ai: Keysym = Keysym(key::Sinh_ai);
    #[doc(alias = "XK_Sinh_o")]
    pub const Sinh_o: Keysym = Keysym(key::Sinh_o);
    #[doc(alias = "XK_Sinh_oo")]
    pub const Sinh_oo: Keysym = Keysym(key::Sinh_oo);
    #[doc(alias = "XK_Sinh_au")]
    pub const Sinh_au: Keysym = Keysym(key::Sinh_au);
    #[doc(alias = "XK_Sinh_ka")]
    pub const Sinh_ka: Keysym = Keysym(key::Sinh_ka);
    #[doc(alias = "XK_Sinh_kha")]
    pub const Sinh_kha: Keysym = Keysym(key::Sinh_kha);
    #[doc(alias = "XK_Sinh_ga")]
    pub const Sinh_ga: Keysym = Keysym(key::Sinh_ga);
    #[doc(alias = "XK_Sinh_gha")]
    pub const Sinh_gha: Keysym = Keysym(key::Sinh_gha);
    #[doc(alias = "XK_Sinh_ng2")]
    pub const Sinh_ng2: Keysym = Keysym(key::Sinh_ng2);
    #[doc(alias = "XK_Sinh_nga")]
    pub const Sinh_nga: Keysym = Keysym(key::Sinh_nga);
    #[doc(alias = "XK_Sinh_ca")]
    pub const Sinh_ca: Keysym = Keysym(key::Sinh_ca);
    #[doc(alias = "XK_Sinh_cha")]
    pub const Sinh_cha: Keysym = Keysym(key::Sinh_cha);
    #[doc(alias = "XK_Sinh_ja")]
    pub const Sinh_ja: Keysym = Keysym(key::Sinh_ja);
    #[doc(alias = "XK_Sinh_jha")]
    pub const Sinh_jha: Keysym = Keysym(key::Sinh_jha);
    #[doc(alias = "XK_Sinh_nya")]
    pub const Sinh_nya: Keysym = Keysym(key::Sinh_nya);
    #[doc(alias = "XK_Sinh_jnya")]
    pub const Sinh_jnya: Keysym = Keysym(key::Sinh_jnya);
    #[doc(alias = "XK_Sinh_nja")]
    pub const Sinh_nja: Keysym = Keysym(key::Sinh_nja);
    #[doc(alias = "XK_Sinh_tta")]
    pub const Sinh_tta: Keysym = Keysym(key::Sinh_tta);
    #[doc(alias = "XK_Sinh_ttha")]
    pub const Sinh_ttha: Keysym = Keysym(key::Sinh_ttha);
    #[doc(alias = "XK_Sinh_dda")]
    pub const Sinh_dda: Keysym = Keysym(key::Sinh_dda);
    #[doc(alias = "XK_Sinh_ddha")]
    pub const Sinh_ddha: Keysym = Keysym(key::Sinh_ddha);
    #[doc(alias = "XK_Sinh_nna")]
    pub const Sinh_nna: Keysym = Keysym(key::Sinh_nna);
    #[doc(alias = "XK_Sinh_ndda")]
    pub const Sinh_ndda: Keysym = Keysym(key::Sinh_ndda);
    #[doc(alias = "XK_Sinh_tha")]
    pub const Sinh_tha: Keysym = Keysym(key::Sinh_tha);
    #[doc(alias = "XK_Sinh_thha")]
    pub const Sinh_thha: Keysym = Keysym(key::Sinh_thha);
    #[doc(alias = "XK_Sinh_dha")]
    pub const Sinh_dha: Keysym = Keysym(key::Sinh_dha);
    #[doc(alias = "XK_Sinh_dhha")]
    pub const Sinh_dhha: Keysym = Keysym(key::Sinh_dhha);
    #[doc(alias = "XK_Sinh_na")]
    pub const Sinh_na: Keysym = Keysym(key::Sinh_na);
    #[doc(alias = "XK_Sinh_ndha")]
    pub const Sinh_ndha: Keysym = Keysym(key::Sinh_ndha);
    #[doc(alias = "XK_Sinh_pa")]
    pub const Sinh_pa: Keysym = Keysym(key::Sinh_pa);
    #[doc(alias = "XK_Sinh_pha")]
    pub const Sinh_pha: Keysym = Keysym(key::Sinh_pha);
    #[doc(alias = "XK_Sinh_ba")]
    pub const Sinh_ba: Keysym = Keysym(key::Sinh_ba);
    #[doc(alias = "XK_Sinh_bha")]
    pub const Sinh_bha: Keysym = Keysym(key::Sinh_bha);
    #[doc(alias = "XK_Sinh_ma")]
    pub const Sinh_ma: Keysym = Keysym(key::Sinh_ma);
    #[doc(alias = "XK_Sinh_mba")]
    pub const Sinh_mba: Keysym = Keysym(key::Sinh_mba);
    #[doc(alias = "XK_Sinh_ya")]
    pub const Sinh_ya: Keysym = Keysym(key::Sinh_ya);
    #[doc(alias = "XK_Sinh_ra")]
    pub const Sinh_ra: Keysym = Keysym(key::Sinh_ra);
    #[doc(alias = "XK_Sinh_la")]
    pub const Sinh_la: Keysym = Keysym(key::Sinh_la);
    #[doc(alias = "XK_Sinh_va")]
    pub const Sinh_va: Keysym = Keysym(key::Sinh_va);
    #[doc(alias = "XK_Sinh_sha")]
    pub const Sinh_sha: Keysym = Keysym(key::Sinh_sha);
    #[doc(alias = "XK_Sinh_ssha")]
    pub const Sinh_ssha: Keysym = Keysym(key::Sinh_ssha);
    #[doc(alias = "XK_Sinh_sa")]
    pub const Sinh_sa: Keysym = Keysym(key::Sinh_sa);
    #[doc(alias = "XK_Sinh_ha")]
    pub const Sinh_ha: Keysym = Keysym(key::Sinh_ha);
    #[doc(alias = "XK_Sinh_lla")]
    pub const Sinh_lla: Keysym = Keysym(key::Sinh_lla);
    #[doc(alias = "XK_Sinh_fa")]
    pub const Sinh_fa: Keysym = Keysym(key::Sinh_fa);
    #[doc(alias = "XK_Sinh_al")]
    pub const Sinh_al: Keysym = Keysym(key::Sinh_al);
    #[doc(alias = "XK_Sinh_aa2")]
    pub const Sinh_aa2: Keysym = Keysym(key::Sinh_aa2);
    #[doc(alias = "XK_Sinh_ae2")]
    pub const Sinh_ae2: Keysym = Keysym(key::Sinh_ae2);
    #[doc(alias = "XK_Sinh_aee2")]
    pub const Sinh_aee2: Keysym = Keysym(key::Sinh_aee2);
    #[doc(alias = "XK_Sinh_i2")]
    pub const Sinh_i2: Keysym = Keysym(key::Sinh_i2);
    #[doc(alias = "XK_Sinh_ii2")]
    pub const Sinh_ii2: Keysym = Keysym(key::Sinh_ii2);
    #[doc(alias = "XK_Sinh_u2")]
    pub const Sinh_u2: Keysym = Keysym(key::Sinh_u2);
    #[doc(alias = "XK_Sinh_uu2")]
    pub const Sinh_uu2: Keysym = Keysym(key::Sinh_uu2);
    #[doc(alias = "XK_Sinh_ru2")]
    pub const Sinh_ru2: Keysym = Keysym(key::Sinh_ru2);
    #[doc(alias = "XK_Sinh_e2")]
    pub const Sinh_e2: Keysym = Keysym(key::Sinh_e2);
    #[doc(alias = "XK_Sinh_ee2")]
    pub const Sinh_ee2: Keysym = Keysym(key::Sinh_ee2);
    #[doc(alias = "XK_Sinh_ai2")]
    pub const Sinh_ai2: Keysym = Keysym(key::Sinh_ai2);
    #[doc(alias = "XK_Sinh_o2")]
    pub const Sinh_o2: Keysym = Keysym(key::Sinh_o2);
    #[doc(alias = "XK_Sinh_oo2")]
    pub const Sinh_oo2: Keysym = Keysym(key::Sinh_oo2);
    #[doc(alias = "XK_Sinh_au2")]
    pub const Sinh_au2: Keysym = Keysym(key::Sinh_au2);
    #[doc(alias = "XK_Sinh_lu2")]
    pub const Sinh_lu2: Keysym = Keysym(key::Sinh_lu2);
    #[doc(alias = "XK_Sinh_ruu2")]
    pub const Sinh_ruu2: Keysym = Keysym(key::Sinh_ruu2);
    #[doc(alias = "XK_Sinh_luu2")]
    pub const Sinh_luu2: Keysym = Keysym(key::Sinh_luu2);
    #[doc(alias = "XK_Sinh_kunddaliya")]
    pub const Sinh_kunddaliya: Keysym = Keysym(key::Sinh_kunddaliya);
    #[doc(alias = "XF86XK_ModeLock")]
    pub const XF86_ModeLock: Keysym = Keysym(key::XF86_ModeLock);
    #[doc(alias = "XF86XK_MonBrightnessUp")]
    pub const XF86_MonBrightnessUp: Keysym = Keysym(key::XF86_MonBrightnessUp);
    #[doc(alias = "XF86XK_MonBrightnessDown")]
    pub const XF86_MonBrightnessDown: Keysym = Keysym(key::XF86_MonBrightnessDown);
    #[doc(alias = "XF86XK_KbdLightOnOff")]
    pub const XF86_KbdLightOnOff: Keysym = Keysym(key::XF86_KbdLightOnOff);
    #[doc(alias = "XF86XK_KbdBrightnessUp")]
    pub const XF86_KbdBrightnessUp: Keysym = Keysym(key::XF86_KbdBrightnessUp);
    #[doc(alias = "XF86XK_KbdBrightnessDown")]
    pub const XF86_KbdBrightnessDown: Keysym = Keysym(key::XF86_KbdBrightnessDown);
    #[doc(alias = "XF86XK_MonBrightnessCycle")]
    pub const XF86_MonBrightnessCycle: Keysym = Keysym(key::XF86_MonBrightnessCycle);
    #[doc(alias = "XF86XK_Standby")]
    pub const XF86_Standby: Keysym = Keysym(key::XF86_Standby);
    #[doc(alias = "XF86XK_AudioLowerVolume")]
    pub const XF86_AudioLowerVolume: Keysym = Keysym(key::XF86_AudioLowerVolume);
    #[doc(alias = "XF86XK_AudioMute")]
    pub const XF86_AudioMute: Keysym = Keysym(key::XF86_AudioMute);
    #[doc(alias = "XF86XK_AudioRaiseVolume")]
    pub const XF86_AudioRaiseVolume: Keysym = Keysym(key::XF86_AudioRaiseVolume);
    #[doc(alias = "XF86XK_AudioPlay")]
    pub const XF86_AudioPlay: Keysym = Keysym(key::XF86_AudioPlay);
    #[doc(alias = "XF86XK_AudioStop")]
    pub const XF86_AudioStop: Keysym = Keysym(key::XF86_AudioStop);
    #[doc(alias = "XF86XK_AudioPrev")]
    pub const XF86_AudioPrev: Keysym = Keysym(key::XF86_AudioPrev);
    #[doc(alias = "XF86XK_AudioNext")]
    pub const XF86_AudioNext: Keysym = Keysym(key::XF86_AudioNext);
    #[doc(alias = "XF86XK_HomePage")]
    pub const XF86_HomePage: Keysym = Keysym(key::XF86_HomePage);
    #[doc(alias = "XF86XK_Mail")]
    pub const XF86_Mail: Keysym = Keysym(key::XF86_Mail);
    #[doc(alias = "XF86XK_Start")]
    pub const XF86_Start: Keysym = Keysym(key::XF86_Start);
    #[doc(alias = "XF86XK_Search")]
    pub const XF86_Search: Keysym = Keysym(key::XF86_Search);
    #[doc(alias = "XF86XK_AudioRecord")]
    pub const XF86_AudioRecord: Keysym = Keysym(key::XF86_AudioRecord);
    #[doc(alias = "XF86XK_Calculator")]
    pub const XF86_Calculator: Keysym = Keysym(key::XF86_Calculator);
    #[doc(alias = "XF86XK_Memo")]
    pub const XF86_Memo: Keysym = Keysym(key::XF86_Memo);
    #[doc(alias = "XF86XK_ToDoList")]
    pub const XF86_ToDoList: Keysym = Keysym(key::XF86_ToDoList);
    #[doc(alias = "XF86XK_Calendar")]
    pub const XF86_Calendar: Keysym = Keysym(key::XF86_Calendar);
    #[doc(alias = "XF86XK_PowerDown")]
    pub const XF86_PowerDown: Keysym = Keysym(key::XF86_PowerDown);
    #[doc(alias = "XF86XK_ContrastAdjust")]
    pub const XF86_ContrastAdjust: Keysym = Keysym(key::XF86_ContrastAdjust);
    #[doc(alias = "XF86XK_RockerUp")]
    pub const XF86_RockerUp: Keysym = Keysym(key::XF86_RockerUp);
    #[doc(alias = "XF86XK_RockerDown")]
    pub const XF86_RockerDown: Keysym = Keysym(key::XF86_RockerDown);
    #[doc(alias = "XF86XK_RockerEnter")]
    pub const XF86_RockerEnter: Keysym = Keysym(key::XF86_RockerEnter);
    #[doc(alias = "XF86XK_Back")]
    pub const XF86_Back: Keysym = Keysym(key::XF86_Back);
    #[doc(alias = "XF86XK_Forward")]
    pub const XF86_Forward: Keysym = Keysym(key::XF86_Forward);
    #[doc(alias = "XF86XK_Stop")]
    pub const XF86_Stop: Keysym = Keysym(key::XF86_Stop);
    #[doc(alias = "XF86XK_Refresh")]
    pub const XF86_Refresh: Keysym = Keysym(key::XF86_Refresh);
    #[doc(alias = "XF86XK_PowerOff")]
    pub const XF86_PowerOff: Keysym = Keysym(key::XF86_PowerOff);
    #[doc(alias = "XF86XK_WakeUp")]
    pub const XF86_WakeUp: Keysym = Keysym(key::XF86_WakeUp);
    #[doc(alias = "XF86XK_Eject")]
    pub const XF86_Eject: Keysym = Keysym(key::XF86_Eject);
    #[doc(alias = "XF86XK_ScreenSaver")]
    pub const XF86_ScreenSaver: Keysym = Keysym(key::XF86_ScreenSaver);
    #[doc(alias = "XF86XK_WWW")]
    pub const XF86_WWW: Keysym = Keysym(key::XF86_WWW);
    #[doc(alias = "XF86XK_Sleep")]
    pub const XF86_Sleep: Keysym = Keysym(key::XF86_Sleep);
    #[doc(alias = "XF86XK_Favorites")]
    pub const XF86_Favorites: Keysym = Keysym(key::XF86_Favorites);
    #[doc(alias = "XF86XK_AudioPause")]
    pub const XF86_AudioPause: Keysym = Keysym(key::XF86_AudioPause);
    #[doc(alias = "XF86XK_AudioMedia")]
    pub const XF86_AudioMedia: Keysym = Keysym(key::XF86_AudioMedia);
    #[doc(alias = "XF86XK_MyComputer")]
    pub const XF86_MyComputer: Keysym = Keysym(key::XF86_MyComputer);
    #[doc(alias = "XF86XK_VendorHome")]
    pub const XF86_VendorHome: Keysym = Keysym(key::XF86_VendorHome);
    #[doc(alias = "XF86XK_LightBulb")]
    pub const XF86_LightBulb: Keysym = Keysym(key::XF86_LightBulb);
    #[doc(alias = "XF86XK_Shop")]
    pub const XF86_Shop: Keysym = Keysym(key::XF86_Shop);
    #[doc(alias = "XF86XK_History")]
    pub const XF86_History: Keysym = Keysym(key::XF86_History);
    #[doc(alias = "XF86XK_OpenURL")]
    pub const XF86_OpenURL: Keysym = Keysym(key::XF86_OpenURL);
    #[doc(alias = "XF86XK_AddFavorite")]
    pub const XF86_AddFavorite: Keysym = Keysym(key::XF86_AddFavorite);
    #[doc(alias = "XF86XK_HotLinks")]
    pub const XF86_HotLinks: Keysym = Keysym(key::XF86_HotLinks);
    #[doc(alias = "XF86XK_BrightnessAdjust")]
    pub const XF86_BrightnessAdjust: Keysym = Keysym(key::XF86_BrightnessAdjust);
    #[doc(alias = "XF86XK_Finance")]
    pub const XF86_Finance: Keysym = Keysym(key::XF86_Finance);
    #[doc(alias = "XF86XK_Community")]
    pub const XF86_Community: Keysym = Keysym(key::XF86_Community);
    #[doc(alias = "XF86XK_AudioRewind")]
    pub const XF86_AudioRewind: Keysym = Keysym(key::XF86_AudioRewind);
    #[doc(alias = "XF86XK_BackForward")]
    pub const XF86_BackForward: Keysym = Keysym(key::XF86_BackForward);
    #[doc(alias = "XF86XK_Launch0")]
    pub const XF86_Launch0: Keysym = Keysym(key::XF86_Launch0);
    #[doc(alias = "XF86XK_Launch1")]
    pub const XF86_Launch1: Keysym = Keysym(key::XF86_Launch1);
    #[doc(alias = "XF86XK_Launch2")]
    pub const XF86_Launch2: Keysym = Keysym(key::XF86_Launch2);
    #[doc(alias = "XF86XK_Launch3")]
    pub const XF86_Launch3: Keysym = Keysym(key::XF86_Launch3);
    #[doc(alias = "XF86XK_Launch4")]
    pub const XF86_Launch4: Keysym = Keysym(key::XF86_Launch4);
    #[doc(alias = "XF86XK_Launch5")]
    pub const XF86_Launch5: Keysym = Keysym(key::XF86_Launch5);
    #[doc(alias = "XF86XK_Launch6")]
    pub const XF86_Launch6: Keysym = Keysym(key::XF86_Launch6);
    #[doc(alias = "XF86XK_Launch7")]
    pub const XF86_Launch7: Keysym = Keysym(key::XF86_Launch7);
    #[doc(alias = "XF86XK_Launch8")]
    pub const XF86_Launch8: Keysym = Keysym(key::XF86_Launch8);
    #[doc(alias = "XF86XK_Launch9")]
    pub const XF86_Launch9: Keysym = Keysym(key::XF86_Launch9);
    #[doc(alias = "XF86XK_LaunchA")]
    pub const XF86_LaunchA: Keysym = Keysym(key::XF86_LaunchA);
    #[doc(alias = "XF86XK_LaunchB")]
    pub const XF86_LaunchB: Keysym = Keysym(key::XF86_LaunchB);
    #[doc(alias = "XF86XK_LaunchC")]
    pub const XF86_LaunchC: Keysym = Keysym(key::XF86_LaunchC);
    #[doc(alias = "XF86XK_LaunchD")]
    pub const XF86_LaunchD: Keysym = Keysym(key::XF86_LaunchD);
    #[doc(alias = "XF86XK_LaunchE")]
    pub const XF86_LaunchE: Keysym = Keysym(key::XF86_LaunchE);
    #[doc(alias = "XF86XK_LaunchF")]
    pub const XF86_LaunchF: Keysym = Keysym(key::XF86_LaunchF);
    #[doc(alias = "XF86XK_ApplicationLeft")]
    pub const XF86_ApplicationLeft: Keysym = Keysym(key::XF86_ApplicationLeft);
    #[doc(alias = "XF86XK_ApplicationRight")]
    pub const XF86_ApplicationRight: Keysym = Keysym(key::XF86_ApplicationRight);
    #[doc(alias = "XF86XK_Book")]
    pub const XF86_Book: Keysym = Keysym(key::XF86_Book);
    #[doc(alias = "XF86XK_CD")]
    pub const XF86_CD: Keysym = Keysym(key::XF86_CD);
    #[doc(alias = "XF86XK_Calculater")]
    pub const XF86_Calculater: Keysym = Keysym(key::XF86_Calculater);
    #[doc(alias = "XF86XK_Clear")]
    pub const XF86_Clear: Keysym = Keysym(key::XF86_Clear);
    #[doc(alias = "XF86XK_Close")]
    pub const XF86_Close: Keysym = Keysym(key::XF86_Close);
    #[doc(alias = "XF86XK_Copy")]
    pub const XF86_Copy: Keysym = Keysym(key::XF86_Copy);
    #[doc(alias = "XF86XK_Cut")]
    pub const XF86_Cut: Keysym = Keysym(key::XF86_Cut);
    #[doc(alias = "XF86XK_Display")]
    pub const XF86_Display: Keysym = Keysym(key::XF86_Display);
    #[doc(alias = "XF86XK_DOS")]
    pub const XF86_DOS: Keysym = Keysym(key::XF86_DOS);
    #[doc(alias = "XF86XK_Documents")]
    pub const XF86_Documents: Keysym = Keysym(key::XF86_Documents);
    #[doc(alias = "XF86XK_Excel")]
    pub const XF86_Excel: Keysym = Keysym(key::XF86_Excel);
    #[doc(alias = "XF86XK_Explorer")]
    pub const XF86_Explorer: Keysym = Keysym(key::XF86_Explorer);
    #[doc(alias = "XF86XK_Game")]
    pub const XF86_Game: Keysym = Keysym(key::XF86_Game);
    #[doc(alias = "XF86XK_Go")]
    pub const XF86_Go: Keysym = Keysym(key::XF86_Go);
    #[doc(alias = "XF86XK_iTouch")]
    pub const XF86_iTouch: Keysym = Keysym(key::XF86_iTouch);
    #[doc(alias = "XF86XK_LogOff")]
    pub const XF86_LogOff: Keysym = Keysym(key::XF86_LogOff);
    #[doc(alias = "XF86XK_Market")]
    pub const XF86_Market: Keysym = Keysym(key::XF86_Market);
    #[doc(alias = "XF86XK_Meeting")]
    pub const XF86_Meeting: Keysym = Keysym(key::XF86_Meeting);
    #[doc(alias = "XF86XK_MenuKB")]
    pub const XF86_MenuKB: Keysym = Keysym(key::XF86_MenuKB);
    #[doc(alias = "XF86XK_MenuPB")]
    pub const XF86_MenuPB: Keysym = Keysym(key::XF86_MenuPB);
    #[doc(alias = "XF86XK_MySites")]
    pub const XF86_MySites: Keysym = Keysym(key::XF86_MySites);
    #[doc(alias = "XF86XK_New")]
    pub const XF86_New: Keysym = Keysym(key::XF86_New);
    #[doc(alias = "XF86XK_News")]
    pub const XF86_News: Keysym = Keysym(key::XF86_News);
    #[doc(alias = "XF86XK_OfficeHome")]
    pub const XF86_OfficeHome: Keysym = Keysym(key::XF86_OfficeHome);
    #[doc(alias = "XF86XK_Open")]
    pub const XF86_Open: Keysym = Keysym(key::XF86_Open);
    #[doc(alias = "XF86XK_Option")]
    pub const XF86_Option: Keysym = Keysym(key::XF86_Option);
    #[doc(alias = "XF86XK_Paste")]
    pub const XF86_Paste: Keysym = Keysym(key::XF86_Paste);
    #[doc(alias = "XF86XK_Phone")]
    pub const XF86_Phone: Keysym = Keysym(key::XF86_Phone);
    #[doc(alias = "XF86XK_Q")]
    pub const XF86_Q: Keysym = Keysym(key::XF86_Q);
    #[doc(alias = "XF86XK_Reply")]
    pub const XF86_Reply: Keysym = Keysym(key::XF86_Reply);
    #[doc(alias = "XF86XK_Reload")]
    pub const XF86_Reload: Keysym = Keysym(key::XF86_Reload);
    #[doc(alias = "XF86XK_RotateWindows")]
    pub const XF86_RotateWindows: Keysym = Keysym(key::XF86_RotateWindows);
    #[doc(alias = "XF86XK_RotationPB")]
    pub const XF86_RotationPB: Keysym = Keysym(key::XF86_RotationPB);
    #[doc(alias = "XF86XK_RotationKB")]
    pub const XF86_RotationKB: Keysym = Keysym(key::XF86_RotationKB);
    #[doc(alias = "XF86XK_Save")]
    pub const XF86_Save: Keysym = Keysym(key::XF86_Save);
    #[doc(alias = "XF86XK_ScrollUp")]
    pub const XF86_ScrollUp: Keysym = Keysym(key::XF86_ScrollUp);
    #[doc(alias = "XF86XK_ScrollDown")]
    pub const XF86_ScrollDown: Keysym = Keysym(key::XF86_ScrollDown);
    #[doc(alias = "XF86XK_ScrollClick")]
    pub const XF86_ScrollClick: Keysym = Keysym(key::XF86_ScrollClick);
    #[doc(alias = "XF86XK_Send")]
    pub const XF86_Send: Keysym = Keysym(key::XF86_Send);
    #[doc(alias = "XF86XK_Spell")]
    pub const XF86_Spell: Keysym = Keysym(key::XF86_Spell);
    #[doc(alias = "XF86XK_SplitScreen")]
    pub const XF86_SplitScreen: Keysym = Keysym(key::XF86_SplitScreen);
    #[doc(alias = "XF86XK_Support")]
    pub const XF86_Support: Keysym = Keysym(key::XF86_Support);
    #[doc(alias = "XF86XK_TaskPane")]
    pub const XF86_TaskPane: Keysym = Keysym(key::XF86_TaskPane);
    #[doc(alias = "XF86XK_Terminal")]
    pub const XF86_Terminal: Keysym = Keysym(key::XF86_Terminal);
    #[doc(alias = "XF86XK_Tools")]
    pub const XF86_Tools: Keysym = Keysym(key::XF86_Tools);
    #[doc(alias = "XF86XK_Travel")]
    pub const XF86_Travel: Keysym = Keysym(key::XF86_Travel);
    #[doc(alias = "XF86XK_UserPB")]
    pub const XF86_UserPB: Keysym = Keysym(key::XF86_UserPB);
    #[doc(alias = "XF86XK_User1KB")]
    pub const XF86_User1KB: Keysym = Keysym(key::XF86_User1KB);
    #[doc(alias = "XF86XK_User2KB")]
    pub const XF86_User2KB: Keysym = Keysym(key::XF86_User2KB);
    #[doc(alias = "XF86XK_Video")]
    pub const XF86_Video: Keysym = Keysym(key::XF86_Video);
    #[doc(alias = "XF86XK_WheelButton")]
    pub const XF86_WheelButton: Keysym = Keysym(key::XF86_WheelButton);
    #[doc(alias = "XF86XK_Word")]
    pub const XF86_Word: Keysym = Keysym(key::XF86_Word);
    #[doc(alias = "XF86XK_Xfer")]
    pub const XF86_Xfer: Keysym = Keysym(key::XF86_Xfer);
    #[doc(alias = "XF86XK_ZoomIn")]
    pub const XF86_ZoomIn: Keysym = Keysym(key::XF86_ZoomIn);
    #[doc(alias = "XF86XK_ZoomOut")]
    pub const XF86_ZoomOut: Keysym = Keysym(key::XF86_ZoomOut);
    #[doc(alias = "XF86XK_Away")]
    pub const XF86_Away: Keysym = Keysym(key::XF86_Away);
    #[doc(alias = "XF86XK_Messenger")]
    pub const XF86_Messenger: Keysym = Keysym(key::XF86_Messenger);
    #[doc(alias = "XF86XK_WebCam")]
    pub const XF86_WebCam: Keysym = Keysym(key::XF86_WebCam);
    #[doc(alias = "XF86XK_MailForward")]
    pub const XF86_MailForward: Keysym = Keysym(key::XF86_MailForward);
    #[doc(alias = "XF86XK_Pictures")]
    pub const XF86_Pictures: Keysym = Keysym(key::XF86_Pictures);
    #[doc(alias = "XF86XK_Music")]
    pub const XF86_Music: Keysym = Keysym(key::XF86_Music);
    #[doc(alias = "XF86XK_Battery")]
    pub const XF86_Battery: Keysym = Keysym(key::XF86_Battery);
    #[doc(alias = "XF86XK_Bluetooth")]
    pub const XF86_Bluetooth: Keysym = Keysym(key::XF86_Bluetooth);
    #[doc(alias = "XF86XK_WLAN")]
    pub const XF86_WLAN: Keysym = Keysym(key::XF86_WLAN);
    #[doc(alias = "XF86XK_UWB")]
    pub const XF86_UWB: Keysym = Keysym(key::XF86_UWB);
    #[doc(alias = "XF86XK_AudioForward")]
    pub const XF86_AudioForward: Keysym = Keysym(key::XF86_AudioForward);
    #[doc(alias = "XF86XK_AudioRepeat")]
    pub const XF86_AudioRepeat: Keysym = Keysym(key::XF86_AudioRepeat);
    #[doc(alias = "XF86XK_AudioRandomPlay")]
    pub const XF86_AudioRandomPlay: Keysym = Keysym(key::XF86_AudioRandomPlay);
    #[doc(alias = "XF86XK_Subtitle")]
    pub const XF86_Subtitle: Keysym = Keysym(key::XF86_Subtitle);
    #[doc(alias = "XF86XK_AudioCycleTrack")]
    pub const XF86_AudioCycleTrack: Keysym = Keysym(key::XF86_AudioCycleTrack);
    #[doc(alias = "XF86XK_CycleAngle")]
    pub const XF86_CycleAngle: Keysym = Keysym(key::XF86_CycleAngle);
    #[doc(alias = "XF86XK_FrameBack")]
    pub const XF86_FrameBack: Keysym = Keysym(key::XF86_FrameBack);
    #[doc(alias = "XF86XK_FrameForward")]
    pub const XF86_FrameForward: Keysym = Keysym(key::XF86_FrameForward);
    #[doc(alias = "XF86XK_Time")]
    pub const XF86_Time: Keysym = Keysym(key::XF86_Time);
    #[doc(alias = "XF86XK_Select")]
    pub const XF86_Select: Keysym = Keysym(key::XF86_Select);
    #[doc(alias = "XF86XK_View")]
    pub const XF86_View: Keysym = Keysym(key::XF86_View);
    #[doc(alias = "XF86XK_TopMenu")]
    pub const XF86_TopMenu: Keysym = Keysym(key::XF86_TopMenu);
    #[doc(alias = "XF86XK_Red")]
    pub const XF86_Red: Keysym = Keysym(key::XF86_Red);
    #[doc(alias = "XF86XK_Green")]
    pub const XF86_Green: Keysym = Keysym(key::XF86_Green);
    #[doc(alias = "XF86XK_Yellow")]
    pub const XF86_Yellow: Keysym = Keysym(key::XF86_Yellow);
    #[doc(alias = "XF86XK_Blue")]
    pub const XF86_Blue: Keysym = Keysym(key::XF86_Blue);
    #[doc(alias = "XF86XK_Suspend")]
    pub const XF86_Suspend: Keysym = Keysym(key::XF86_Suspend);
    #[doc(alias = "XF86XK_Hibernate")]
    pub const XF86_Hibernate: Keysym = Keysym(key::XF86_Hibernate);
    #[doc(alias = "XF86XK_TouchpadToggle")]
    pub const XF86_TouchpadToggle: Keysym = Keysym(key::XF86_TouchpadToggle);
    #[doc(alias = "XF86XK_TouchpadOn")]
    pub const XF86_TouchpadOn: Keysym = Keysym(key::XF86_TouchpadOn);
    #[doc(alias = "XF86XK_TouchpadOff")]
    pub const XF86_TouchpadOff: Keysym = Keysym(key::XF86_TouchpadOff);
    #[doc(alias = "XF86XK_AudioMicMute")]
    pub const XF86_AudioMicMute: Keysym = Keysym(key::XF86_AudioMicMute);
    #[doc(alias = "XF86XK_Keyboard")]
    pub const XF86_Keyboard: Keysym = Keysym(key::XF86_Keyboard);
    #[doc(alias = "XF86XK_WWAN")]
    pub const XF86_WWAN: Keysym = Keysym(key::XF86_WWAN);
    #[doc(alias = "XF86XK_RFKill")]
    pub const XF86_RFKill: Keysym = Keysym(key::XF86_RFKill);
    #[doc(alias = "XF86XK_AudioPreset")]
    pub const XF86_AudioPreset: Keysym = Keysym(key::XF86_AudioPreset);
    #[doc(alias = "XF86XK_RotationLockToggle")]
    pub const XF86_RotationLockToggle: Keysym = Keysym(key::XF86_RotationLockToggle);
    #[doc(alias = "XF86XK_FullScreen")]
    pub const XF86_FullScreen: Keysym = Keysym(key::XF86_FullScreen);
    #[doc(alias = "XF86XK_Switch_VT_1")]
    pub const XF86_Switch_VT_1: Keysym = Keysym(key::XF86_Switch_VT_1);
    #[doc(alias = "XF86XK_Switch_VT_2")]
    pub const XF86_Switch_VT_2: Keysym = Keysym(key::XF86_Switch_VT_2);
    #[doc(alias = "XF86XK_Switch_VT_3")]
    pub const XF86_Switch_VT_3: Keysym = Keysym(key::XF86_Switch_VT_3);
    #[doc(alias = "XF86XK_Switch_VT_4")]
    pub const XF86_Switch_VT_4: Keysym = Keysym(key::XF86_Switch_VT_4);
    #[doc(alias = "XF86XK_Switch_VT_5")]
    pub const XF86_Switch_VT_5: Keysym = Keysym(key::XF86_Switch_VT_5);
    #[doc(alias = "XF86XK_Switch_VT_6")]
    pub const XF86_Switch_VT_6: Keysym = Keysym(key::XF86_Switch_VT_6);
    #[doc(alias = "XF86XK_Switch_VT_7")]
    pub const XF86_Switch_VT_7: Keysym = Keysym(key::XF86_Switch_VT_7);
    #[doc(alias = "XF86XK_Switch_VT_8")]
    pub const XF86_Switch_VT_8: Keysym = Keysym(key::XF86_Switch_VT_8);
    #[doc(alias = "XF86XK_Switch_VT_9")]
    pub const XF86_Switch_VT_9: Keysym = Keysym(key::XF86_Switch_VT_9);
    #[doc(alias = "XF86XK_Switch_VT_10")]
    pub const XF86_Switch_VT_10: Keysym = Keysym(key::XF86_Switch_VT_10);
    #[doc(alias = "XF86XK_Switch_VT_11")]
    pub const XF86_Switch_VT_11: Keysym = Keysym(key::XF86_Switch_VT_11);
    #[doc(alias = "XF86XK_Switch_VT_12")]
    pub const XF86_Switch_VT_12: Keysym = Keysym(key::XF86_Switch_VT_12);
    #[doc(alias = "XF86XK_Ungrab")]
    pub const XF86_Ungrab: Keysym = Keysym(key::XF86_Ungrab);
    #[doc(alias = "XF86XK_ClearGrab")]
    pub const XF86_ClearGrab: Keysym = Keysym(key::XF86_ClearGrab);
    #[doc(alias = "XF86XK_Next_VMode")]
    pub const XF86_Next_VMode: Keysym = Keysym(key::XF86_Next_VMode);
    #[doc(alias = "XF86XK_Prev_VMode")]
    pub const XF86_Prev_VMode: Keysym = Keysym(key::XF86_Prev_VMode);
    #[doc(alias = "XF86XK_LogWindowTree")]
    pub const XF86_LogWindowTree: Keysym = Keysym(key::XF86_LogWindowTree);
    #[doc(alias = "XF86XK_LogGrabInfo")]
    pub const XF86_LogGrabInfo: Keysym = Keysym(key::XF86_LogGrabInfo);
    #[doc(alias = "XF86XK_BrightnessAuto")]
    pub const XF86_BrightnessAuto: Keysym = Keysym(key::XF86_BrightnessAuto);
    #[doc(alias = "XF86XK_DisplayOff")]
    pub const XF86_DisplayOff: Keysym = Keysym(key::XF86_DisplayOff);
    #[doc(alias = "XF86XK_Info")]
    pub const XF86_Info: Keysym = Keysym(key::XF86_Info);
    #[doc(alias = "XF86XK_AspectRatio")]
    pub const XF86_AspectRatio: Keysym = Keysym(key::XF86_AspectRatio);
    #[doc(alias = "XF86XK_DVD")]
    pub const XF86_DVD: Keysym = Keysym(key::XF86_DVD);
    #[doc(alias = "XF86XK_Audio")]
    pub const XF86_Audio: Keysym = Keysym(key::XF86_Audio);
    #[doc(alias = "XF86XK_ChannelUp")]
    pub const XF86_ChannelUp: Keysym = Keysym(key::XF86_ChannelUp);
    #[doc(alias = "XF86XK_ChannelDown")]
    pub const XF86_ChannelDown: Keysym = Keysym(key::XF86_ChannelDown);
    #[doc(alias = "XF86XK_Break")]
    pub const XF86_Break: Keysym = Keysym(key::XF86_Break);
    #[doc(alias = "XF86XK_VideoPhone")]
    pub const XF86_VideoPhone: Keysym = Keysym(key::XF86_VideoPhone);
    #[doc(alias = "XF86XK_ZoomReset")]
    pub const XF86_ZoomReset: Keysym = Keysym(key::XF86_ZoomReset);
    #[doc(alias = "XF86XK_Editor")]
    pub const XF86_Editor: Keysym = Keysym(key::XF86_Editor);
    #[doc(alias = "XF86XK_GraphicsEditor")]
    pub const XF86_GraphicsEditor: Keysym = Keysym(key::XF86_GraphicsEditor);
    #[doc(alias = "XF86XK_Presentation")]
    pub const XF86_Presentation: Keysym = Keysym(key::XF86_Presentation);
    #[doc(alias = "XF86XK_Database")]
    pub const XF86_Database: Keysym = Keysym(key::XF86_Database);
    #[doc(alias = "XF86XK_Voicemail")]
    pub const XF86_Voicemail: Keysym = Keysym(key::XF86_Voicemail);
    #[doc(alias = "XF86XK_Addressbook")]
    pub const XF86_Addressbook: Keysym = Keysym(key::XF86_Addressbook);
    #[doc(alias = "XF86XK_DisplayToggle")]
    pub const XF86_DisplayToggle: Keysym = Keysym(key::XF86_DisplayToggle);
    #[doc(alias = "XF86XK_SpellCheck")]
    pub const XF86_SpellCheck: Keysym = Keysym(key::XF86_SpellCheck);
    #[doc(alias = "XF86XK_ContextMenu")]
    pub const XF86_ContextMenu: Keysym = Keysym(key::XF86_ContextMenu);
    #[doc(alias = "XF86XK_MediaRepeat")]
    pub const XF86_MediaRepeat: Keysym = Keysym(key::XF86_MediaRepeat);
    #[doc(alias = "XF86XK_10ChannelsUp")]
    pub const XF86_10ChannelsUp: Keysym = Keysym(key::XF86_10ChannelsUp);
    #[doc(alias = "XF86XK_10ChannelsDown")]
    pub const XF86_10ChannelsDown: Keysym = Keysym(key::XF86_10ChannelsDown);
    #[doc(alias = "XF86XK_Images")]
    pub const XF86_Images: Keysym = Keysym(key::XF86_Images);
    #[doc(alias = "XF86XK_NotificationCenter")]
    pub const XF86_NotificationCenter: Keysym = Keysym(key::XF86_NotificationCenter);
    #[doc(alias = "XF86XK_PickupPhone")]
    pub const XF86_PickupPhone: Keysym = Keysym(key::XF86_PickupPhone);
    #[doc(alias = "XF86XK_HangupPhone")]
    pub const XF86_HangupPhone: Keysym = Keysym(key::XF86_HangupPhone);
    #[doc(alias = "XF86XK_Fn")]
    pub const XF86_Fn: Keysym = Keysym(key::XF86_Fn);
    #[doc(alias = "XF86XK_Fn_Esc")]
    pub const XF86_Fn_Esc: Keysym = Keysym(key::XF86_Fn_Esc);
    #[doc(alias = "XF86XK_FnRightShift")]
    pub const XF86_FnRightShift: Keysym = Keysym(key::XF86_FnRightShift);
    #[doc(alias = "XF86XK_Numeric0")]
    pub const XF86_Numeric0: Keysym = Keysym(key::XF86_Numeric0);
    #[doc(alias = "XF86XK_Numeric1")]
    pub const XF86_Numeric1: Keysym = Keysym(key::XF86_Numeric1);
    #[doc(alias = "XF86XK_Numeric2")]
    pub const XF86_Numeric2: Keysym = Keysym(key::XF86_Numeric2);
    #[doc(alias = "XF86XK_Numeric3")]
    pub const XF86_Numeric3: Keysym = Keysym(key::XF86_Numeric3);
    #[doc(alias = "XF86XK_Numeric4")]
    pub const XF86_Numeric4: Keysym = Keysym(key::XF86_Numeric4);
    #[doc(alias = "XF86XK_Numeric5")]
    pub const XF86_Numeric5: Keysym = Keysym(key::XF86_Numeric5);
    #[doc(alias = "XF86XK_Numeric6")]
    pub const XF86_Numeric6: Keysym = Keysym(key::XF86_Numeric6);
    #[doc(alias = "XF86XK_Numeric7")]
    pub const XF86_Numeric7: Keysym = Keysym(key::XF86_Numeric7);
    #[doc(alias = "XF86XK_Numeric8")]
    pub const XF86_Numeric8: Keysym = Keysym(key::XF86_Numeric8);
    #[doc(alias = "XF86XK_Numeric9")]
    pub const XF86_Numeric9: Keysym = Keysym(key::XF86_Numeric9);
    #[doc(alias = "XF86XK_NumericStar")]
    pub const XF86_NumericStar: Keysym = Keysym(key::XF86_NumericStar);
    #[doc(alias = "XF86XK_NumericPound")]
    pub const XF86_NumericPound: Keysym = Keysym(key::XF86_NumericPound);
    #[doc(alias = "XF86XK_NumericA")]
    pub const XF86_NumericA: Keysym = Keysym(key::XF86_NumericA);
    #[doc(alias = "XF86XK_NumericB")]
    pub const XF86_NumericB: Keysym = Keysym(key::XF86_NumericB);
    #[doc(alias = "XF86XK_NumericC")]
    pub const XF86_NumericC: Keysym = Keysym(key::XF86_NumericC);
    #[doc(alias = "XF86XK_NumericD")]
    pub const XF86_NumericD: Keysym = Keysym(key::XF86_NumericD);
    #[doc(alias = "XF86XK_CameraFocus")]
    pub const XF86_CameraFocus: Keysym = Keysym(key::XF86_CameraFocus);
    #[doc(alias = "XF86XK_WPSButton")]
    pub const XF86_WPSButton: Keysym = Keysym(key::XF86_WPSButton);
    #[doc(alias = "XF86XK_CameraZoomIn")]
    pub const XF86_CameraZoomIn: Keysym = Keysym(key::XF86_CameraZoomIn);
    #[doc(alias = "XF86XK_CameraZoomOut")]
    pub const XF86_CameraZoomOut: Keysym = Keysym(key::XF86_CameraZoomOut);
    #[doc(alias = "XF86XK_CameraUp")]
    pub const XF86_CameraUp: Keysym = Keysym(key::XF86_CameraUp);
    #[doc(alias = "XF86XK_CameraDown")]
    pub const XF86_CameraDown: Keysym = Keysym(key::XF86_CameraDown);
    #[doc(alias = "XF86XK_CameraLeft")]
    pub const XF86_CameraLeft: Keysym = Keysym(key::XF86_CameraLeft);
    #[doc(alias = "XF86XK_CameraRight")]
    pub const XF86_CameraRight: Keysym = Keysym(key::XF86_CameraRight);
    #[doc(alias = "XF86XK_AttendantOn")]
    pub const XF86_AttendantOn: Keysym = Keysym(key::XF86_AttendantOn);
    #[doc(alias = "XF86XK_AttendantOff")]
    pub const XF86_AttendantOff: Keysym = Keysym(key::XF86_AttendantOff);
    #[doc(alias = "XF86XK_AttendantToggle")]
    pub const XF86_AttendantToggle: Keysym = Keysym(key::XF86_AttendantToggle);
    #[doc(alias = "XF86XK_LightsToggle")]
    pub const XF86_LightsToggle: Keysym = Keysym(key::XF86_LightsToggle);
    #[doc(alias = "XF86XK_ALSToggle")]
    pub const XF86_ALSToggle: Keysym = Keysym(key::XF86_ALSToggle);
    #[doc(alias = "XF86XK_Buttonconfig")]
    pub const XF86_Buttonconfig: Keysym = Keysym(key::XF86_Buttonconfig);
    #[doc(alias = "XF86XK_Taskmanager")]
    pub const XF86_Taskmanager: Keysym = Keysym(key::XF86_Taskmanager);
    #[doc(alias = "XF86XK_Journal")]
    pub const XF86_Journal: Keysym = Keysym(key::XF86_Journal);
    #[doc(alias = "XF86XK_ControlPanel")]
    pub const XF86_ControlPanel: Keysym = Keysym(key::XF86_ControlPanel);
    #[doc(alias = "XF86XK_AppSelect")]
    pub const XF86_AppSelect: Keysym = Keysym(key::XF86_AppSelect);
    #[doc(alias = "XF86XK_Screensaver")]
    pub const XF86_Screensaver: Keysym = Keysym(key::XF86_Screensaver);
    #[doc(alias = "XF86XK_VoiceCommand")]
    pub const XF86_VoiceCommand: Keysym = Keysym(key::XF86_VoiceCommand);
    #[doc(alias = "XF86XK_Assistant")]
    pub const XF86_Assistant: Keysym = Keysym(key::XF86_Assistant);
    #[doc(alias = "XF86XK_BrightnessMin")]
    pub const XF86_BrightnessMin: Keysym = Keysym(key::XF86_BrightnessMin);
    #[doc(alias = "XF86XK_BrightnessMax")]
    pub const XF86_BrightnessMax: Keysym = Keysym(key::XF86_BrightnessMax);
    #[doc(alias = "XF86XK_KbdInputAssistPrev")]
    pub const XF86_KbdInputAssistPrev: Keysym = Keysym(key::XF86_KbdInputAssistPrev);
    #[doc(alias = "XF86XK_KbdInputAssistNext")]
    pub const XF86_KbdInputAssistNext: Keysym = Keysym(key::XF86_KbdInputAssistNext);
    #[doc(alias = "XF86XK_KbdInputAssistPrevgroup")]
    pub const XF86_KbdInputAssistPrevgroup: Keysym = Keysym(key::XF86_KbdInputAssistPrevgroup);
    #[doc(alias = "XF86XK_KbdInputAssistNextgroup")]
    pub const XF86_KbdInputAssistNextgroup: Keysym = Keysym(key::XF86_KbdInputAssistNextgroup);
    #[doc(alias = "XF86XK_KbdInputAssistAccept")]
    pub const XF86_KbdInputAssistAccept: Keysym = Keysym(key::XF86_KbdInputAssistAccept);
    #[doc(alias = "XF86XK_KbdInputAssistCancel")]
    pub const XF86_KbdInputAssistCancel: Keysym = Keysym(key::XF86_KbdInputAssistCancel);
    #[doc(alias = "XF86XK_RightUp")]
    pub const XF86_RightUp: Keysym = Keysym(key::XF86_RightUp);
    #[doc(alias = "XF86XK_RightDown")]
    pub const XF86_RightDown: Keysym = Keysym(key::XF86_RightDown);
    #[doc(alias = "XF86XK_LeftUp")]
    pub const XF86_LeftUp: Keysym = Keysym(key::XF86_LeftUp);
    #[doc(alias = "XF86XK_LeftDown")]
    pub const XF86_LeftDown: Keysym = Keysym(key::XF86_LeftDown);
    #[doc(alias = "XF86XK_RootMenu")]
    pub const XF86_RootMenu: Keysym = Keysym(key::XF86_RootMenu);
    #[doc(alias = "XF86XK_MediaTopMenu")]
    pub const XF86_MediaTopMenu: Keysym = Keysym(key::XF86_MediaTopMenu);
    #[doc(alias = "XF86XK_Numeric11")]
    pub const XF86_Numeric11: Keysym = Keysym(key::XF86_Numeric11);
    #[doc(alias = "XF86XK_Numeric12")]
    pub const XF86_Numeric12: Keysym = Keysym(key::XF86_Numeric12);
    #[doc(alias = "XF86XK_AudioDesc")]
    pub const XF86_AudioDesc: Keysym = Keysym(key::XF86_AudioDesc);
    #[doc(alias = "XF86XK_3DMode")]
    pub const XF86_3DMode: Keysym = Keysym(key::XF86_3DMode);
    #[doc(alias = "XF86XK_NextFavorite")]
    pub const XF86_NextFavorite: Keysym = Keysym(key::XF86_NextFavorite);
    #[doc(alias = "XF86XK_StopRecord")]
    pub const XF86_StopRecord: Keysym = Keysym(key::XF86_StopRecord);
    #[doc(alias = "XF86XK_PauseRecord")]
    pub const XF86_PauseRecord: Keysym = Keysym(key::XF86_PauseRecord);
    #[doc(alias = "XF86XK_VOD")]
    pub const XF86_VOD: Keysym = Keysym(key::XF86_VOD);
    #[doc(alias = "XF86XK_Unmute")]
    pub const XF86_Unmute: Keysym = Keysym(key::XF86_Unmute);
    #[doc(alias = "XF86XK_FastReverse")]
    pub const XF86_FastReverse: Keysym = Keysym(key::XF86_FastReverse);
    #[doc(alias = "XF86XK_SlowReverse")]
    pub const XF86_SlowReverse: Keysym = Keysym(key::XF86_SlowReverse);
    #[doc(alias = "XF86XK_Data")]
    pub const XF86_Data: Keysym = Keysym(key::XF86_Data);
    #[doc(alias = "XF86XK_OnScreenKeyboard")]
    pub const XF86_OnScreenKeyboard: Keysym = Keysym(key::XF86_OnScreenKeyboard);
    #[doc(alias = "XF86XK_PrivacyScreenToggle")]
    pub const XF86_PrivacyScreenToggle: Keysym = Keysym(key::XF86_PrivacyScreenToggle);
    #[doc(alias = "XF86XK_SelectiveScreenshot")]
    pub const XF86_SelectiveScreenshot: Keysym = Keysym(key::XF86_SelectiveScreenshot);
    #[doc(alias = "XF86XK_Macro1")]
    pub const XF86_Macro1: Keysym = Keysym(key::XF86_Macro1);
    #[doc(alias = "XF86XK_Macro2")]
    pub const XF86_Macro2: Keysym = Keysym(key::XF86_Macro2);
    #[doc(alias = "XF86XK_Macro3")]
    pub const XF86_Macro3: Keysym = Keysym(key::XF86_Macro3);
    #[doc(alias = "XF86XK_Macro4")]
    pub const XF86_Macro4: Keysym = Keysym(key::XF86_Macro4);
    #[doc(alias = "XF86XK_Macro5")]
    pub const XF86_Macro5: Keysym = Keysym(key::XF86_Macro5);
    #[doc(alias = "XF86XK_Macro6")]
    pub const XF86_Macro6: Keysym = Keysym(key::XF86_Macro6);
    #[doc(alias = "XF86XK_Macro7")]
    pub const XF86_Macro7: Keysym = Keysym(key::XF86_Macro7);
    #[doc(alias = "XF86XK_Macro8")]
    pub const XF86_Macro8: Keysym = Keysym(key::XF86_Macro8);
    #[doc(alias = "XF86XK_Macro9")]
    pub const XF86_Macro9: Keysym = Keysym(key::XF86_Macro9);
    #[doc(alias = "XF86XK_Macro10")]
    pub const XF86_Macro10: Keysym = Keysym(key::XF86_Macro10);
    #[doc(alias = "XF86XK_Macro11")]
    pub const XF86_Macro11: Keysym = Keysym(key::XF86_Macro11);
    #[doc(alias = "XF86XK_Macro12")]
    pub const XF86_Macro12: Keysym = Keysym(key::XF86_Macro12);
    #[doc(alias = "XF86XK_Macro13")]
    pub const XF86_Macro13: Keysym = Keysym(key::XF86_Macro13);
    #[doc(alias = "XF86XK_Macro14")]
    pub const XF86_Macro14: Keysym = Keysym(key::XF86_Macro14);
    #[doc(alias = "XF86XK_Macro15")]
    pub const XF86_Macro15: Keysym = Keysym(key::XF86_Macro15);
    #[doc(alias = "XF86XK_Macro16")]
    pub const XF86_Macro16: Keysym = Keysym(key::XF86_Macro16);
    #[doc(alias = "XF86XK_Macro17")]
    pub const XF86_Macro17: Keysym = Keysym(key::XF86_Macro17);
    #[doc(alias = "XF86XK_Macro18")]
    pub const XF86_Macro18: Keysym = Keysym(key::XF86_Macro18);
    #[doc(alias = "XF86XK_Macro19")]
    pub const XF86_Macro19: Keysym = Keysym(key::XF86_Macro19);
    #[doc(alias = "XF86XK_Macro20")]
    pub const XF86_Macro20: Keysym = Keysym(key::XF86_Macro20);
    #[doc(alias = "XF86XK_Macro21")]
    pub const XF86_Macro21: Keysym = Keysym(key::XF86_Macro21);
    #[doc(alias = "XF86XK_Macro22")]
    pub const XF86_Macro22: Keysym = Keysym(key::XF86_Macro22);
    #[doc(alias = "XF86XK_Macro23")]
    pub const XF86_Macro23: Keysym = Keysym(key::XF86_Macro23);
    #[doc(alias = "XF86XK_Macro24")]
    pub const XF86_Macro24: Keysym = Keysym(key::XF86_Macro24);
    #[doc(alias = "XF86XK_Macro25")]
    pub const XF86_Macro25: Keysym = Keysym(key::XF86_Macro25);
    #[doc(alias = "XF86XK_Macro26")]
    pub const XF86_Macro26: Keysym = Keysym(key::XF86_Macro26);
    #[doc(alias = "XF86XK_Macro27")]
    pub const XF86_Macro27: Keysym = Keysym(key::XF86_Macro27);
    #[doc(alias = "XF86XK_Macro28")]
    pub const XF86_Macro28: Keysym = Keysym(key::XF86_Macro28);
    #[doc(alias = "XF86XK_Macro29")]
    pub const XF86_Macro29: Keysym = Keysym(key::XF86_Macro29);
    #[doc(alias = "XF86XK_Macro30")]
    pub const XF86_Macro30: Keysym = Keysym(key::XF86_Macro30);
    #[doc(alias = "XF86XK_MacroRecordStart")]
    pub const XF86_MacroRecordStart: Keysym = Keysym(key::XF86_MacroRecordStart);
    #[doc(alias = "XF86XK_MacroRecordStop")]
    pub const XF86_MacroRecordStop: Keysym = Keysym(key::XF86_MacroRecordStop);
    #[doc(alias = "XF86XK_MacroPresetCycle")]
    pub const XF86_MacroPresetCycle: Keysym = Keysym(key::XF86_MacroPresetCycle);
    #[doc(alias = "XF86XK_MacroPreset1")]
    pub const XF86_MacroPreset1: Keysym = Keysym(key::XF86_MacroPreset1);
    #[doc(alias = "XF86XK_MacroPreset2")]
    pub const XF86_MacroPreset2: Keysym = Keysym(key::XF86_MacroPreset2);
    #[doc(alias = "XF86XK_MacroPreset3")]
    pub const XF86_MacroPreset3: Keysym = Keysym(key::XF86_MacroPreset3);
    #[doc(alias = "XF86XK_KbdLcdMenu1")]
    pub const XF86_KbdLcdMenu1: Keysym = Keysym(key::XF86_KbdLcdMenu1);
    #[doc(alias = "XF86XK_KbdLcdMenu2")]
    pub const XF86_KbdLcdMenu2: Keysym = Keysym(key::XF86_KbdLcdMenu2);
    #[doc(alias = "XF86XK_KbdLcdMenu3")]
    pub const XF86_KbdLcdMenu3: Keysym = Keysym(key::XF86_KbdLcdMenu3);
    #[doc(alias = "XF86XK_KbdLcdMenu4")]
    pub const XF86_KbdLcdMenu4: Keysym = Keysym(key::XF86_KbdLcdMenu4);
    #[doc(alias = "XF86XK_KbdLcdMenu5")]
    pub const XF86_KbdLcdMenu5: Keysym = Keysym(key::XF86_KbdLcdMenu5);
    #[doc(alias = "SunXK_FA_Grave")]
    pub const SUN_FA_Grave: Keysym = Keysym(key::SUN_FA_Grave);
    #[doc(alias = "SunXK_FA_Circum")]
    pub const SUN_FA_Circum: Keysym = Keysym(key::SUN_FA_Circum);
    #[doc(alias = "SunXK_FA_Tilde")]
    pub const SUN_FA_Tilde: Keysym = Keysym(key::SUN_FA_Tilde);
    #[doc(alias = "SunXK_FA_Acute")]
    pub const SUN_FA_Acute: Keysym = Keysym(key::SUN_FA_Acute);
    #[doc(alias = "SunXK_FA_Diaeresis")]
    pub const SUN_FA_Diaeresis: Keysym = Keysym(key::SUN_FA_Diaeresis);
    #[doc(alias = "SunXK_FA_Cedilla")]
    pub const SUN_FA_Cedilla: Keysym = Keysym(key::SUN_FA_Cedilla);
    #[doc(alias = "SunXK_F36")]
    pub const SUN_F36: Keysym = Keysym(key::SUN_F36);
    #[doc(alias = "SunXK_F37")]
    pub const SUN_F37: Keysym = Keysym(key::SUN_F37);
    #[doc(alias = "SunXK_Sys_Req")]
    pub const SUN_Sys_Req: Keysym = Keysym(key::SUN_Sys_Req);
    #[doc(alias = "SunXK_Print_Screen")]
    pub const SUN_Print_Screen: Keysym = Keysym(key::SUN_Print_Screen);
    #[doc(alias = "SunXK_Compose")]
    pub const SUN_Compose: Keysym = Keysym(key::SUN_Compose);
    #[doc(alias = "SunXK_AltGraph")]
    pub const SUN_AltGraph: Keysym = Keysym(key::SUN_AltGraph);
    #[doc(alias = "SunXK_PageUp")]
    pub const SUN_PageUp: Keysym = Keysym(key::SUN_PageUp);
    #[doc(alias = "SunXK_PageDown")]
    pub const SUN_PageDown: Keysym = Keysym(key::SUN_PageDown);
    #[doc(alias = "SunXK_Undo")]
    pub const SUN_Undo: Keysym = Keysym(key::SUN_Undo);
    #[doc(alias = "SunXK_Again")]
    pub const SUN_Again: Keysym = Keysym(key::SUN_Again);
    #[doc(alias = "SunXK_Find")]
    pub const SUN_Find: Keysym = Keysym(key::SUN_Find);
    #[doc(alias = "SunXK_Stop")]
    pub const SUN_Stop: Keysym = Keysym(key::SUN_Stop);
    #[doc(alias = "SunXK_Props")]
    pub const SUN_Props: Keysym = Keysym(key::SUN_Props);
    #[doc(alias = "SunXK_Front")]
    pub const SUN_Front: Keysym = Keysym(key::SUN_Front);
    #[doc(alias = "SunXK_Copy")]
    pub const SUN_Copy: Keysym = Keysym(key::SUN_Copy);
    #[doc(alias = "SunXK_Open")]
    pub const SUN_Open: Keysym = Keysym(key::SUN_Open);
    #[doc(alias = "SunXK_Paste")]
    pub const SUN_Paste: Keysym = Keysym(key::SUN_Paste);
    #[doc(alias = "SunXK_Cut")]
    pub const SUN_Cut: Keysym = Keysym(key::SUN_Cut);
    #[doc(alias = "SunXK_PowerSwitch")]
    pub const SUN_PowerSwitch: Keysym = Keysym(key::SUN_PowerSwitch);
    #[doc(alias = "SunXK_AudioLowerVolume")]
    pub const SUN_AudioLowerVolume: Keysym = Keysym(key::SUN_AudioLowerVolume);
    #[doc(alias = "SunXK_AudioMute")]
    pub const SUN_AudioMute: Keysym = Keysym(key::SUN_AudioMute);
    #[doc(alias = "SunXK_AudioRaiseVolume")]
    pub const SUN_AudioRaiseVolume: Keysym = Keysym(key::SUN_AudioRaiseVolume);
    #[doc(alias = "SunXK_VideoDegauss")]
    pub const SUN_VideoDegauss: Keysym = Keysym(key::SUN_VideoDegauss);
    #[doc(alias = "SunXK_VideoLowerBrightness")]
    pub const SUN_VideoLowerBrightness: Keysym = Keysym(key::SUN_VideoLowerBrightness);
    #[doc(alias = "SunXK_VideoRaiseBrightness")]
    pub const SUN_VideoRaiseBrightness: Keysym = Keysym(key::SUN_VideoRaiseBrightness);
    #[doc(alias = "SunXK_PowerSwitchShift")]
    pub const SUN_PowerSwitchShift: Keysym = Keysym(key::SUN_PowerSwitchShift);
    #[doc(alias = "DXK_ring_accent")]
    pub const D_ring_accent: Keysym = Keysym(key::D_ring_accent);
    #[doc(alias = "DXK_circumflex_accent")]
    pub const D_circumflex_accent: Keysym = Keysym(key::D_circumflex_accent);
    #[doc(alias = "DXK_cedilla_accent")]
    pub const D_cedilla_accent: Keysym = Keysym(key::D_cedilla_accent);
    #[doc(alias = "DXK_acute_accent")]
    pub const D_acute_accent: Keysym = Keysym(key::D_acute_accent);
    #[doc(alias = "DXK_grave_accent")]
    pub const D_grave_accent: Keysym = Keysym(key::D_grave_accent);
    #[doc(alias = "DXK_tilde")]
    pub const D_tilde: Keysym = Keysym(key::D_tilde);
    #[doc(alias = "DXK_diaeresis")]
    pub const D_diaeresis: Keysym = Keysym(key::D_diaeresis);
    #[doc(alias = "DXK_Remove")]
    pub const D_Remove: Keysym = Keysym(key::D_Remove);
    #[doc(alias = "hpXK_ClearLine")]
    pub const HP_ClearLine: Keysym = Keysym(key::HP_ClearLine);
    #[doc(alias = "hpXK_InsertLine")]
    pub const HP_InsertLine: Keysym = Keysym(key::HP_InsertLine);
    #[doc(alias = "hpXK_DeleteLine")]
    pub const HP_DeleteLine: Keysym = Keysym(key::HP_DeleteLine);
    #[doc(alias = "hpXK_InsertChar")]
    pub const HP_InsertChar: Keysym = Keysym(key::HP_InsertChar);
    #[doc(alias = "hpXK_DeleteChar")]
    pub const HP_DeleteChar: Keysym = Keysym(key::HP_DeleteChar);
    #[doc(alias = "hpXK_BackTab")]
    pub const HP_BackTab: Keysym = Keysym(key::HP_BackTab);
    #[doc(alias = "hpXK_KP_BackTab")]
    pub const HP_KP_BackTab: Keysym = Keysym(key::HP_KP_BackTab);
    #[doc(alias = "hpXK_Modelock1")]
    pub const HP_Modelock1: Keysym = Keysym(key::HP_Modelock1);
    #[doc(alias = "hpXK_Modelock2")]
    pub const HP_Modelock2: Keysym = Keysym(key::HP_Modelock2);
    #[doc(alias = "hpXK_Reset")]
    pub const HP_Reset: Keysym = Keysym(key::HP_Reset);
    #[doc(alias = "hpXK_System")]
    pub const HP_System: Keysym = Keysym(key::HP_System);
    #[doc(alias = "hpXK_User")]
    pub const HP_User: Keysym = Keysym(key::HP_User);
    #[doc(alias = "hpXK_mute_acute")]
    pub const HP_mute_acute: Keysym = Keysym(key::HP_mute_acute);
    #[doc(alias = "hpXK_mute_grave")]
    pub const HP_mute_grave: Keysym = Keysym(key::HP_mute_grave);
    #[doc(alias = "hpXK_mute_asciicircum")]
    pub const HP_mute_asciicircum: Keysym = Keysym(key::HP_mute_asciicircum);
    #[doc(alias = "hpXK_mute_diaeresis")]
    pub const HP_mute_diaeresis: Keysym = Keysym(key::HP_mute_diaeresis);
    #[doc(alias = "hpXK_mute_asciitilde")]
    pub const HP_mute_asciitilde: Keysym = Keysym(key::HP_mute_asciitilde);
    #[doc(alias = "hpXK_lira")]
    pub const HP_lira: Keysym = Keysym(key::HP_lira);
    #[doc(alias = "hpXK_guilder")]
    pub const HP_guilder: Keysym = Keysym(key::HP_guilder);
    #[doc(alias = "hpXK_IO")]
    pub const HP_IO: Keysym = Keysym(key::HP_IO);
    #[doc(alias = "hpXK_longminus")]
    pub const HP_longminus: Keysym = Keysym(key::HP_longminus);
    #[doc(alias = "hpXK_block")]
    pub const HP_block: Keysym = Keysym(key::HP_block);
    #[doc(alias = "osfXK_Copy")]
    pub const OSF_Copy: Keysym = Keysym(key::OSF_Copy);
    #[doc(alias = "osfXK_Cut")]
    pub const OSF_Cut: Keysym = Keysym(key::OSF_Cut);
    #[doc(alias = "osfXK_Paste")]
    pub const OSF_Paste: Keysym = Keysym(key::OSF_Paste);
    #[doc(alias = "osfXK_BackTab")]
    pub const OSF_BackTab: Keysym = Keysym(key::OSF_BackTab);
    #[doc(alias = "osfXK_BackSpace")]
    pub const OSF_BackSpace: Keysym = Keysym(key::OSF_BackSpace);
    #[doc(alias = "osfXK_Clear")]
    pub const OSF_Clear: Keysym = Keysym(key::OSF_Clear);
    #[doc(alias = "osfXK_Escape")]
    pub const OSF_Escape: Keysym = Keysym(key::OSF_Escape);
    #[doc(alias = "osfXK_AddMode")]
    pub const OSF_AddMode: Keysym = Keysym(key::OSF_AddMode);
    #[doc(alias = "osfXK_PrimaryPaste")]
    pub const OSF_PrimaryPaste: Keysym = Keysym(key::OSF_PrimaryPaste);
    #[doc(alias = "osfXK_QuickPaste")]
    pub const OSF_QuickPaste: Keysym = Keysym(key::OSF_QuickPaste);
    #[doc(alias = "osfXK_PageLeft")]
    pub const OSF_PageLeft: Keysym = Keysym(key::OSF_PageLeft);
    #[doc(alias = "osfXK_PageUp")]
    pub const OSF_PageUp: Keysym = Keysym(key::OSF_PageUp);
    #[doc(alias = "osfXK_PageDown")]
    pub const OSF_PageDown: Keysym = Keysym(key::OSF_PageDown);
    #[doc(alias = "osfXK_PageRight")]
    pub const OSF_PageRight: Keysym = Keysym(key::OSF_PageRight);
    #[doc(alias = "osfXK_Activate")]
    pub const OSF_Activate: Keysym = Keysym(key::OSF_Activate);
    #[doc(alias = "osfXK_MenuBar")]
    pub const OSF_MenuBar: Keysym = Keysym(key::OSF_MenuBar);
    #[doc(alias = "osfXK_Left")]
    pub const OSF_Left: Keysym = Keysym(key::OSF_Left);
    #[doc(alias = "osfXK_Up")]
    pub const OSF_Up: Keysym = Keysym(key::OSF_Up);
    #[doc(alias = "osfXK_Right")]
    pub const OSF_Right: Keysym = Keysym(key::OSF_Right);
    #[doc(alias = "osfXK_Down")]
    pub const OSF_Down: Keysym = Keysym(key::OSF_Down);
    #[doc(alias = "osfXK_EndLine")]
    pub const OSF_EndLine: Keysym = Keysym(key::OSF_EndLine);
    #[doc(alias = "osfXK_BeginLine")]
    pub const OSF_BeginLine: Keysym = Keysym(key::OSF_BeginLine);
    #[doc(alias = "osfXK_EndData")]
    pub const OSF_EndData: Keysym = Keysym(key::OSF_EndData);
    #[doc(alias = "osfXK_BeginData")]
    pub const OSF_BeginData: Keysym = Keysym(key::OSF_BeginData);
    #[doc(alias = "osfXK_PrevMenu")]
    pub const OSF_PrevMenu: Keysym = Keysym(key::OSF_PrevMenu);
    #[doc(alias = "osfXK_NextMenu")]
    pub const OSF_NextMenu: Keysym = Keysym(key::OSF_NextMenu);
    #[doc(alias = "osfXK_PrevField")]
    pub const OSF_PrevField: Keysym = Keysym(key::OSF_PrevField);
    #[doc(alias = "osfXK_NextField")]
    pub const OSF_NextField: Keysym = Keysym(key::OSF_NextField);
    #[doc(alias = "osfXK_Select")]
    pub const OSF_Select: Keysym = Keysym(key::OSF_Select);
    #[doc(alias = "osfXK_Insert")]
    pub const OSF_Insert: Keysym = Keysym(key::OSF_Insert);
    #[doc(alias = "osfXK_Undo")]
    pub const OSF_Undo: Keysym = Keysym(key::OSF_Undo);
    #[doc(alias = "osfXK_Menu")]
    pub const OSF_Menu: Keysym = Keysym(key::OSF_Menu);
    #[doc(alias = "osfXK_Cancel")]
    pub const OSF_Cancel: Keysym = Keysym(key::OSF_Cancel);
    #[doc(alias = "osfXK_Help")]
    pub const OSF_Help: Keysym = Keysym(key::OSF_Help);
    #[doc(alias = "osfXK_SelectAll")]
    pub const OSF_SelectAll: Keysym = Keysym(key::OSF_SelectAll);
    #[doc(alias = "osfXK_DeselectAll")]
    pub const OSF_DeselectAll: Keysym = Keysym(key::OSF_DeselectAll);
    #[doc(alias = "osfXK_Reselect")]
    pub const OSF_Reselect: Keysym = Keysym(key::OSF_Reselect);
    #[doc(alias = "osfXK_Extend")]
    pub const OSF_Extend: Keysym = Keysym(key::OSF_Extend);
    #[doc(alias = "osfXK_Restore")]
    pub const OSF_Restore: Keysym = Keysym(key::OSF_Restore);
    #[doc(alias = "osfXK_Delete")]
    pub const OSF_Delete: Keysym = Keysym(key::OSF_Delete);
    #[doc(alias = "XK_Reset")]
    pub const Reset: Keysym = Keysym(key::Reset);
    #[doc(alias = "XK_System")]
    pub const System: Keysym = Keysym(key::System);
    #[doc(alias = "XK_User")]
    pub const User: Keysym = Keysym(key::User);
    #[doc(alias = "XK_ClearLine")]
    pub const ClearLine: Keysym = Keysym(key::ClearLine);
    #[doc(alias = "XK_InsertLine")]
    pub const InsertLine: Keysym = Keysym(key::InsertLine);
    #[doc(alias = "XK_DeleteLine")]
    pub const DeleteLine: Keysym = Keysym(key::DeleteLine);
    #[doc(alias = "XK_InsertChar")]
    pub const InsertChar: Keysym = Keysym(key::InsertChar);
    #[doc(alias = "XK_DeleteChar")]
    pub const DeleteChar: Keysym = Keysym(key::DeleteChar);
    #[doc(alias = "XK_BackTab")]
    pub const BackTab: Keysym = Keysym(key::BackTab);
    #[doc(alias = "XK_KP_BackTab")]
    pub const KP_BackTab: Keysym = Keysym(key::KP_BackTab);
    #[doc(alias = "XK_Ext16bit_L")]
    pub const Ext16bit_L: Keysym = Keysym(key::Ext16bit_L);
    #[doc(alias = "XK_Ext16bit_R")]
    pub const Ext16bit_R: Keysym = Keysym(key::Ext16bit_R);
    #[doc(alias = "XK_mute_acute")]
    pub const mute_acute: Keysym = Keysym(key::mute_acute);
    #[doc(alias = "XK_mute_grave")]
    pub const mute_grave: Keysym = Keysym(key::mute_grave);
    #[doc(alias = "XK_mute_asciicircum")]
    pub const mute_asciicircum: Keysym = Keysym(key::mute_asciicircum);
    #[doc(alias = "XK_mute_diaeresis")]
    pub const mute_diaeresis: Keysym = Keysym(key::mute_diaeresis);
    #[doc(alias = "XK_mute_asciitilde")]
    pub const mute_asciitilde: Keysym = Keysym(key::mute_asciitilde);
    #[doc(alias = "XK_lira")]
    pub const lira: Keysym = Keysym(key::lira);
    #[doc(alias = "XK_guilder")]
    pub const guilder: Keysym = Keysym(key::guilder);
    #[doc(alias = "XK_IO")]
    pub const IO: Keysym = Keysym(key::IO);
    #[doc(alias = "XK_longminus")]
    pub const longminus: Keysym = Keysym(key::longminus);
    #[doc(alias = "XK_block")]
    pub const block: Keysym = Keysym(key::block);
}


#[allow(unreachable_patterns)]
pub(crate) const fn name(keysym: Keysym) -> Option<&'static str> {
    match keysym {
        Keysym::VoidSymbol => Some("XK_VoidSymbol"),
        Keysym::BackSpace => Some("XK_BackSpace"),
        Keysym::Tab => Some("XK_Tab"),
        Keysym::Linefeed => Some("XK_Linefeed"),
        Keysym::Clear => Some("XK_Clear"),
        Keysym::Return => Some("XK_Return"),
        Keysym::Pause => Some("XK_Pause"),
        Keysym::Scroll_Lock => Some("XK_Scroll_Lock"),
        Keysym::Sys_Req => Some("XK_Sys_Req"),
        Keysym::Escape => Some("XK_Escape"),
        Keysym::Delete => Some("XK_Delete"),
        Keysym::Multi_key => Some("XK_Multi_key"),
        Keysym::Codeinput => Some("XK_Codeinput"),
        Keysym::SingleCandidate => Some("XK_SingleCandidate"),
        Keysym::MultipleCandidate => Some("XK_MultipleCandidate"),
        Keysym::PreviousCandidate => Some("XK_PreviousCandidate"),
        Keysym::Kanji => Some("XK_Kanji"),
        Keysym::Muhenkan => Some("XK_Muhenkan"),
        Keysym::Henkan_Mode => Some("XK_Henkan_Mode"),
        Keysym::Henkan => Some("XK_Henkan"),
        Keysym::Romaji => Some("XK_Romaji"),
        Keysym::Hiragana => Some("XK_Hiragana"),
        Keysym::Katakana => Some("XK_Katakana"),
        Keysym::Hiragana_Katakana => Some("XK_Hiragana_Katakana"),
        Keysym::Zenkaku => Some("XK_Zenkaku"),
        Keysym::Hankaku => Some("XK_Hankaku"),
        Keysym::Zenkaku_Hankaku => Some("XK_Zenkaku_Hankaku"),
        Keysym::Touroku => Some("XK_Touroku"),
        Keysym::Massyo => Some("XK_Massyo"),
        Keysym::Kana_Lock => Some("XK_Kana_Lock"),
        Keysym::Kana_Shift => Some("XK_Kana_Shift"),
        Keysym::Eisu_Shift => Some("XK_Eisu_Shift"),
        Keysym::Eisu_toggle => Some("XK_Eisu_toggle"),
        Keysym::Kanji_Bangou => Some("XK_Kanji_Bangou"),
        Keysym::Zen_Koho => Some("XK_Zen_Koho"),
        Keysym::Mae_Koho => Some("XK_Mae_Koho"),
        Keysym::Home => Some("XK_Home"),
        Keysym::Left => Some("XK_Left"),
        Keysym::Up => Some("XK_Up"),
        Keysym::Right => Some("XK_Right"),
        Keysym::Down => Some("XK_Down"),
        Keysym::Prior => Some("XK_Prior"),
        Keysym::Page_Up => Some("XK_Page_Up"),
        Keysym::Next => Some("XK_Next"),
        Keysym::Page_Down => Some("XK_Page_Down"),
        Keysym::End => Some("XK_End"),
        Keysym::Begin => Some("XK_Begin"),
        Keysym::Select => Some("XK_Select"),
        Keysym::Print => Some("XK_Print"),
        Keysym::Execute => Some("XK_Execute"),
        Keysym::Insert => Some("XK_Insert"),
        Keysym::Undo => Some("XK_Undo"),
        Keysym::Redo => Some("XK_Redo"),
        Keysym::Menu => Some("XK_Menu"),
        Keysym::Find => Some("XK_Find"),
        Keysym::Cancel => Some("XK_Cancel"),
        Keysym::Help => Some("XK_Help"),
        Keysym::Break => Some("XK_Break"),
        Keysym::Mode_switch => Some("XK_Mode_switch"),
        Keysym::script_switch => Some("XK_script_switch"),
        Keysym::Num_Lock => Some("XK_Num_Lock"),
        Keysym::KP_Space => Some("XK_KP_Space"),
        Keysym::KP_Tab => Some("XK_KP_Tab"),
        Keysym::KP_Enter => Some("XK_KP_Enter"),
        Keysym::KP_F1 => Some("XK_KP_F1"),
        Keysym::KP_F2 => Some("XK_KP_F2"),
        Keysym::KP_F3 => Some("XK_KP_F3"),
        Keysym::KP_F4 => Some("XK_KP_F4"),
        Keysym::KP_Home => Some("XK_KP_Home"),
        Keysym::KP_Left => Some("XK_KP_Left"),
        Keysym::KP_Up => Some("XK_KP_Up"),
        Keysym::KP_Right => Some("XK_KP_Right"),
        Keysym::KP_Down => Some("XK_KP_Down"),
        Keysym::KP_Prior => Some("XK_KP_Prior"),
        Keysym::KP_Page_Up => Some("XK_KP_Page_Up"),
        Keysym::KP_Next => Some("XK_KP_Next"),
        Keysym::KP_Page_Down => Some("XK_KP_Page_Down"),
        Keysym::KP_End => Some("XK_KP_End"),
        Keysym::KP_Begin => Some("XK_KP_Begin"),
        Keysym::KP_Insert => Some("XK_KP_Insert"),
        Keysym::KP_Delete => Some("XK_KP_Delete"),
        Keysym::KP_Equal => Some("XK_KP_Equal"),
        Keysym::KP_Multiply => Some("XK_KP_Multiply"),
        Keysym::KP_Add => Some("XK_KP_Add"),
        Keysym::KP_Separator => Some("XK_KP_Separator"),
        Keysym::KP_Subtract => Some("XK_KP_Subtract"),
        Keysym::KP_Decimal => Some("XK_KP_Decimal"),
        Keysym::KP_Divide => Some("XK_KP_Divide"),
        Keysym::KP_0 => Some("XK_KP_0"),
        Keysym::KP_1 => Some("XK_KP_1"),
        Keysym::KP_2 => Some("XK_KP_2"),
        Keysym::KP_3 => Some("XK_KP_3"),
        Keysym::KP_4 => Some("XK_KP_4"),
        Keysym::KP_5 => Some("XK_KP_5"),
        Keysym::KP_6 => Some("XK_KP_6"),
        Keysym::KP_7 => Some("XK_KP_7"),
        Keysym::KP_8 => Some("XK_KP_8"),
        Keysym::KP_9 => Some("XK_KP_9"),
        Keysym::F1 => Some("XK_F1"),
        Keysym::F2 => Some("XK_F2"),
        Keysym::F3 => Some("XK_F3"),
        Keysym::F4 => Some("XK_F4"),
        Keysym::F5 => Some("XK_F5"),
        Keysym::F6 => Some("XK_F6"),
        Keysym::F7 => Some("XK_F7"),
        Keysym::F8 => Some("XK_F8"),
        Keysym::F9 => Some("XK_F9"),
        Keysym::F10 => Some("XK_F10"),
        Keysym::F11 => Some("XK_F11"),
        Keysym::L1 => Some("XK_L1"),
        Keysym::F12 => Some("XK_F12"),
        Keysym::L2 => Some("XK_L2"),
        Keysym::F13 => Some("XK_F13"),
        Keysym::L3 => Some("XK_L3"),
        Keysym::F14 => Some("XK_F14"),
        Keysym::L4 => Some("XK_L4"),
        Keysym::F15 => Some("XK_F15"),
        Keysym::L5 => Some("XK_L5"),
        Keysym::F16 => Some("XK_F16"),
        Keysym::L6 => Some("XK_L6"),
        Keysym::F17 => Some("XK_F17"),
        Keysym::L7 => Some("XK_L7"),
        Keysym::F18 => Some("XK_F18"),
        Keysym::L8 => Some("XK_L8"),
        Keysym::F19 => Some("XK_F19"),
        Keysym::L9 => Some("XK_L9"),
        Keysym::F20 => Some("XK_F20"),
        Keysym::L10 => Some("XK_L10"),
        Keysym::F21 => Some("XK_F21"),
        Keysym::R1 => Some("XK_R1"),
        Keysym::F22 => Some("XK_F22"),
        Keysym::R2 => Some("XK_R2"),
        Keysym::F23 => Some("XK_F23"),
        Keysym::R3 => Some("XK_R3"),
        Keysym::F24 => Some("XK_F24"),
        Keysym::R4 => Some("XK_R4"),
        Keysym::F25 => Some("XK_F25"),
        Keysym::R5 => Some("XK_R5"),
        Keysym::F26 => Some("XK_F26"),
        Keysym::R6 => Some("XK_R6"),
        Keysym::F27 => Some("XK_F27"),
        Keysym::R7 => Some("XK_R7"),
        Keysym::F28 => Some("XK_F28"),
        Keysym::R8 => Some("XK_R8"),
        Keysym::F29 => Some("XK_F29"),
        Keysym::R9 => Some("XK_R9"),
        Keysym::F30 => Some("XK_F30"),
        Keysym::R10 => Some("XK_R10"),
        Keysym::F31 => Some("XK_F31"),
        Keysym::R11 => Some("XK_R11"),
        Keysym::F32 => Some("XK_F32"),
        Keysym::R12 => Some("XK_R12"),
        Keysym::F33 => Some("XK_F33"),
        Keysym::R13 => Some("XK_R13"),
        Keysym::F34 => Some("XK_F34"),
        Keysym::R14 => Some("XK_R14"),
        Keysym::F35 => Some("XK_F35"),
        Keysym::R15 => Some("XK_R15"),
        Keysym::Shift_L => Some("XK_Shift_L"),
        Keysym::Shift_R => Some("XK_Shift_R"),
        Keysym::Control_L => Some("XK_Control_L"),
        Keysym::Control_R => Some("XK_Control_R"),
        Keysym::Caps_Lock => Some("XK_Caps_Lock"),
        Keysym::Shift_Lock => Some("XK_Shift_Lock"),
        Keysym::Meta_L => Some("XK_Meta_L"),
        Keysym::Meta_R => Some("XK_Meta_R"),
        Keysym::Alt_L => Some("XK_Alt_L"),
        Keysym::Alt_R => Some("XK_Alt_R"),
        Keysym::Super_L => Some("XK_Super_L"),
        Keysym::Super_R => Some("XK_Super_R"),
        Keysym::Hyper_L => Some("XK_Hyper_L"),
        Keysym::Hyper_R => Some("XK_Hyper_R"),
        Keysym::ISO_Lock => Some("XK_ISO_Lock"),
        Keysym::ISO_Level2_Latch => Some("XK_ISO_Level2_Latch"),
        Keysym::ISO_Level3_Shift => Some("XK_ISO_Level3_Shift"),
        Keysym::ISO_Level3_Latch => Some("XK_ISO_Level3_Latch"),
        Keysym::ISO_Level3_Lock => Some("XK_ISO_Level3_Lock"),
        Keysym::ISO_Level5_Shift => Some("XK_ISO_Level5_Shift"),
        Keysym::ISO_Level5_Latch => Some("XK_ISO_Level5_Latch"),
        Keysym::ISO_Level5_Lock => Some("XK_ISO_Level5_Lock"),
        Keysym::ISO_Group_Shift => Some("XK_ISO_Group_Shift"),
        Keysym::ISO_Group_Latch => Some("XK_ISO_Group_Latch"),
        Keysym::ISO_Group_Lock => Some("XK_ISO_Group_Lock"),
        Keysym::ISO_Next_Group => Some("XK_ISO_Next_Group"),
        Keysym::ISO_Next_Group_Lock => Some("XK_ISO_Next_Group_Lock"),
        Keysym::ISO_Prev_Group => Some("XK_ISO_Prev_Group"),
        Keysym::ISO_Prev_Group_Lock => Some("XK_ISO_Prev_Group_Lock"),
        Keysym::ISO_First_Group => Some("XK_ISO_First_Group"),
        Keysym::ISO_First_Group_Lock => Some("XK_ISO_First_Group_Lock"),
        Keysym::ISO_Last_Group => Some("XK_ISO_Last_Group"),
        Keysym::ISO_Last_Group_Lock => Some("XK_ISO_Last_Group_Lock"),
        Keysym::ISO_Left_Tab => Some("XK_ISO_Left_Tab"),
        Keysym::ISO_Move_Line_Up => Some("XK_ISO_Move_Line_Up"),
        Keysym::ISO_Move_Line_Down => Some("XK_ISO_Move_Line_Down"),
        Keysym::ISO_Partial_Line_Up => Some("XK_ISO_Partial_Line_Up"),
        Keysym::ISO_Partial_Line_Down => Some("XK_ISO_Partial_Line_Down"),
        Keysym::ISO_Partial_Space_Left => Some("XK_ISO_Partial_Space_Left"),
        Keysym::ISO_Partial_Space_Right => Some("XK_ISO_Partial_Space_Right"),
        Keysym::ISO_Set_Margin_Left => Some("XK_ISO_Set_Margin_Left"),
        Keysym::ISO_Set_Margin_Right => Some("XK_ISO_Set_Margin_Right"),
        Keysym::ISO_Release_Margin_Left => Some("XK_ISO_Release_Margin_Left"),
        Keysym::ISO_Release_Margin_Right => Some("XK_ISO_Release_Margin_Right"),
        Keysym::ISO_Release_Both_Margins => Some("XK_ISO_Release_Both_Margins"),
        Keysym::ISO_Fast_Cursor_Left => Some("XK_ISO_Fast_Cursor_Left"),
        Keysym::ISO_Fast_Cursor_Right => Some("XK_ISO_Fast_Cursor_Right"),
        Keysym::ISO_Fast_Cursor_Up => Some("XK_ISO_Fast_Cursor_Up"),
        Keysym::ISO_Fast_Cursor_Down => Some("XK_ISO_Fast_Cursor_Down"),
        Keysym::ISO_Continuous_Underline => Some("XK_ISO_Continuous_Underline"),
        Keysym::ISO_Discontinuous_Underline => Some("XK_ISO_Discontinuous_Underline"),
        Keysym::ISO_Emphasize => Some("XK_ISO_Emphasize"),
        Keysym::ISO_Center_Object => Some("XK_ISO_Center_Object"),
        Keysym::ISO_Enter => Some("XK_ISO_Enter"),
        Keysym::dead_grave => Some("XK_dead_grave"),
        Keysym::dead_acute => Some("XK_dead_acute"),
        Keysym::dead_circumflex => Some("XK_dead_circumflex"),
        Keysym::dead_tilde => Some("XK_dead_tilde"),
        Keysym::dead_perispomeni => Some("XK_dead_perispomeni"),
        Keysym::dead_macron => Some("XK_dead_macron"),
        Keysym::dead_breve => Some("XK_dead_breve"),
        Keysym::dead_abovedot => Some("XK_dead_abovedot"),
        Keysym::dead_diaeresis => Some("XK_dead_diaeresis"),
        Keysym::dead_abovering => Some("XK_dead_abovering"),
        Keysym::dead_doubleacute => Some("XK_dead_doubleacute"),
        Keysym::dead_caron => Some("XK_dead_caron"),
        Keysym::dead_cedilla => Some("XK_dead_cedilla"),
        Keysym::dead_ogonek => Some("XK_dead_ogonek"),
        Keysym::dead_iota => Some("XK_dead_iota"),
        Keysym::dead_voiced_sound => Some("XK_dead_voiced_sound"),
        Keysym::dead_semivoiced_sound => Some("XK_dead_semivoiced_sound"),
        Keysym::dead_belowdot => Some("XK_dead_belowdot"),
        Keysym::dead_hook => Some("XK_dead_hook"),
        Keysym::dead_horn => Some("XK_dead_horn"),
        Keysym::dead_stroke => Some("XK_dead_stroke"),
        Keysym::dead_abovecomma => Some("XK_dead_abovecomma"),
        Keysym::dead_psili => Some("XK_dead_psili"),
        Keysym::dead_abovereversedcomma => Some("XK_dead_abovereversedcomma"),
        Keysym::dead_dasia => Some("XK_dead_dasia"),
        Keysym::dead_doublegrave => Some("XK_dead_doublegrave"),
        Keysym::dead_belowring => Some("XK_dead_belowring"),
        Keysym::dead_belowmacron => Some("XK_dead_belowmacron"),
        Keysym::dead_belowcircumflex => Some("XK_dead_belowcircumflex"),
        Keysym::dead_belowtilde => Some("XK_dead_belowtilde"),
        Keysym::dead_belowbreve => Some("XK_dead_belowbreve"),
        Keysym::dead_belowdiaeresis => Some("XK_dead_belowdiaeresis"),
        Keysym::dead_invertedbreve => Some("XK_dead_invertedbreve"),
        Keysym::dead_belowcomma => Some("XK_dead_belowcomma"),
        Keysym::dead_currency => Some("XK_dead_currency"),
        Keysym::dead_lowline => Some("XK_dead_lowline"),
        Keysym::dead_aboveverticalline => Some("XK_dead_aboveverticalline"),
        Keysym::dead_belowverticalline => Some("XK_dead_belowverticalline"),
        Keysym::dead_longsolidusoverlay => Some("XK_dead_longsolidusoverlay"),
        Keysym::dead_a => Some("XK_dead_a"),
        Keysym::dead_A => Some("XK_dead_A"),
        Keysym::dead_e => Some("XK_dead_e"),
        Keysym::dead_E => Some("XK_dead_E"),
        Keysym::dead_i => Some("XK_dead_i"),
        Keysym::dead_I => Some("XK_dead_I"),
        Keysym::dead_o => Some("XK_dead_o"),
        Keysym::dead_O => Some("XK_dead_O"),
        Keysym::dead_u => Some("XK_dead_u"),
        Keysym::dead_U => Some("XK_dead_U"),
        Keysym::dead_small_schwa => Some("XK_dead_small_schwa"),
        Keysym::dead_capital_schwa => Some("XK_dead_capital_schwa"),
        Keysym::dead_greek => Some("XK_dead_greek"),
        Keysym::First_Virtual_Screen => Some("XK_First_Virtual_Screen"),
        Keysym::Prev_Virtual_Screen => Some("XK_Prev_Virtual_Screen"),
        Keysym::Next_Virtual_Screen => Some("XK_Next_Virtual_Screen"),
        Keysym::Last_Virtual_Screen => Some("XK_Last_Virtual_Screen"),
        Keysym::Terminate_Server => Some("XK_Terminate_Server"),
        Keysym::AccessX_Enable => Some("XK_AccessX_Enable"),
        Keysym::AccessX_Feedback_Enable => Some("XK_AccessX_Feedback_Enable"),
        Keysym::RepeatKeys_Enable => Some("XK_RepeatKeys_Enable"),
        Keysym::SlowKeys_Enable => Some("XK_SlowKeys_Enable"),
        Keysym::BounceKeys_Enable => Some("XK_BounceKeys_Enable"),
        Keysym::StickyKeys_Enable => Some("XK_StickyKeys_Enable"),
        Keysym::MouseKeys_Enable => Some("XK_MouseKeys_Enable"),
        Keysym::MouseKeys_Accel_Enable => Some("XK_MouseKeys_Accel_Enable"),
        Keysym::Overlay1_Enable => Some("XK_Overlay1_Enable"),
        Keysym::Overlay2_Enable => Some("XK_Overlay2_Enable"),
        Keysym::AudibleBell_Enable => Some("XK_AudibleBell_Enable"),
        Keysym::Pointer_Left => Some("XK_Pointer_Left"),
        Keysym::Pointer_Right => Some("XK_Pointer_Right"),
        Keysym::Pointer_Up => Some("XK_Pointer_Up"),
        Keysym::Pointer_Down => Some("XK_Pointer_Down"),
        Keysym::Pointer_UpLeft => Some("XK_Pointer_UpLeft"),
        Keysym::Pointer_UpRight => Some("XK_Pointer_UpRight"),
        Keysym::Pointer_DownLeft => Some("XK_Pointer_DownLeft"),
        Keysym::Pointer_DownRight => Some("XK_Pointer_DownRight"),
        Keysym::Pointer_Button_Dflt => Some("XK_Pointer_Button_Dflt"),
        Keysym::Pointer_Button1 => Some("XK_Pointer_Button1"),
        Keysym::Pointer_Button2 => Some("XK_Pointer_Button2"),
        Keysym::Pointer_Button3 => Some("XK_Pointer_Button3"),
        Keysym::Pointer_Button4 => Some("XK_Pointer_Button4"),
        Keysym::Pointer_Button5 => Some("XK_Pointer_Button5"),
        Keysym::Pointer_DblClick_Dflt => Some("XK_Pointer_DblClick_Dflt"),
        Keysym::Pointer_DblClick1 => Some("XK_Pointer_DblClick1"),
        Keysym::Pointer_DblClick2 => Some("XK_Pointer_DblClick2"),
        Keysym::Pointer_DblClick3 => Some("XK_Pointer_DblClick3"),
        Keysym::Pointer_DblClick4 => Some("XK_Pointer_DblClick4"),
        Keysym::Pointer_DblClick5 => Some("XK_Pointer_DblClick5"),
        Keysym::Pointer_Drag_Dflt => Some("XK_Pointer_Drag_Dflt"),
        Keysym::Pointer_Drag1 => Some("XK_Pointer_Drag1"),
        Keysym::Pointer_Drag2 => Some("XK_Pointer_Drag2"),
        Keysym::Pointer_Drag3 => Some("XK_Pointer_Drag3"),
        Keysym::Pointer_Drag4 => Some("XK_Pointer_Drag4"),
        Keysym::Pointer_Drag5 => Some("XK_Pointer_Drag5"),
        Keysym::Pointer_EnableKeys => Some("XK_Pointer_EnableKeys"),
        Keysym::Pointer_Accelerate => Some("XK_Pointer_Accelerate"),
        Keysym::Pointer_DfltBtnNext => Some("XK_Pointer_DfltBtnNext"),
        Keysym::Pointer_DfltBtnPrev => Some("XK_Pointer_DfltBtnPrev"),
        Keysym::ch => Some("XK_ch"),
        Keysym::Ch => Some("XK_Ch"),
        Keysym::CH => Some("XK_CH"),
        Keysym::c_h => Some("XK_c_h"),
        Keysym::C_h => Some("XK_C_h"),
        Keysym::C_H => Some("XK_C_H"),
        Keysym::_3270_Duplicate => Some("XK_3270_Duplicate"),
        Keysym::_3270_FieldMark => Some("XK_3270_FieldMark"),
        Keysym::_3270_Right2 => Some("XK_3270_Right2"),
        Keysym::_3270_Left2 => Some("XK_3270_Left2"),
        Keysym::_3270_BackTab => Some("XK_3270_BackTab"),
        Keysym::_3270_EraseEOF => Some("XK_3270_EraseEOF"),
        Keysym::_3270_EraseInput => Some("XK_3270_EraseInput"),
        Keysym::_3270_Reset => Some("XK_3270_Reset"),
        Keysym::_3270_Quit => Some("XK_3270_Quit"),
        Keysym::_3270_PA1 => Some("XK_3270_PA1"),
        Keysym::_3270_PA2 => Some("XK_3270_PA2"),
        Keysym::_3270_PA3 => Some("XK_3270_PA3"),
        Keysym::_3270_Test => Some("XK_3270_Test"),
        Keysym::_3270_Attn => Some("XK_3270_Attn"),
        Keysym::_3270_CursorBlink => Some("XK_3270_CursorBlink"),
        Keysym::_3270_AltCursor => Some("XK_3270_AltCursor"),
        Keysym::_3270_KeyClick => Some("XK_3270_KeyClick"),
        Keysym::_3270_Jump => Some("XK_3270_Jump"),
        Keysym::_3270_Ident => Some("XK_3270_Ident"),
        Keysym::_3270_Rule => Some("XK_3270_Rule"),
        Keysym::_3270_Copy => Some("XK_3270_Copy"),
        Keysym::_3270_Play => Some("XK_3270_Play"),
        Keysym::_3270_Setup => Some("XK_3270_Setup"),
        Keysym::_3270_Record => Some("XK_3270_Record"),
        Keysym::_3270_ChangeScreen => Some("XK_3270_ChangeScreen"),
        Keysym::_3270_DeleteWord => Some("XK_3270_DeleteWord"),
        Keysym::_3270_ExSelect => Some("XK_3270_ExSelect"),
        Keysym::_3270_CursorSelect => Some("XK_3270_CursorSelect"),
        Keysym::_3270_PrintScreen => Some("XK_3270_PrintScreen"),
        Keysym::_3270_Enter => Some("XK_3270_Enter"),
        Keysym::space => Some("XK_space"),
        Keysym::exclam => Some("XK_exclam"),
        Keysym::quotedbl => Some("XK_quotedbl"),
        Keysym::numbersign => Some("XK_numbersign"),
        Keysym::dollar => Some("XK_dollar"),
        Keysym::percent => Some("XK_percent"),
        Keysym::ampersand => Some("XK_ampersand"),
        Keysym::apostrophe => Some("XK_apostrophe"),
        Keysym::quoteright => Some("XK_quoteright"),
        Keysym::parenleft => Some("XK_parenleft"),
        Keysym::parenright => Some("XK_parenright"),
        Keysym::asterisk => Some("XK_asterisk"),
        Keysym::plus => Some("XK_plus"),
        Keysym::comma => Some("XK_comma"),
        Keysym::minus => Some("XK_minus"),
        Keysym::period => Some("XK_period"),
        Keysym::slash => Some("XK_slash"),
        Keysym::_0 => Some("XK_0"),
        Keysym::_1 => Some("XK_1"),
        Keysym::_2 => Some("XK_2"),
        Keysym::_3 => Some("XK_3"),
        Keysym::_4 => Some("XK_4"),
        Keysym::_5 => Some("XK_5"),
        Keysym::_6 => Some("XK_6"),
        Keysym::_7 => Some("XK_7"),
        Keysym::_8 => Some("XK_8"),
        Keysym::_9 => Some("XK_9"),
        Keysym::colon => Some("XK_colon"),
        Keysym::semicolon => Some("XK_semicolon"),
        Keysym::less => Some("XK_less"),
        Keysym::equal => Some("XK_equal"),
        Keysym::greater => Some("XK_greater"),
        Keysym::question => Some("XK_question"),
        Keysym::at => Some("XK_at"),
        Keysym::A => Some("XK_A"),
        Keysym::B => Some("XK_B"),
        Keysym::C => Some("XK_C"),
        Keysym::D => Some("XK_D"),
        Keysym::E => Some("XK_E"),
        Keysym::F => Some("XK_F"),
        Keysym::G => Some("XK_G"),
        Keysym::H => Some("XK_H"),
        Keysym::I => Some("XK_I"),
        Keysym::J => Some("XK_J"),
        Keysym::K => Some("XK_K"),
        Keysym::L => Some("XK_L"),
        Keysym::M => Some("XK_M"),
        Keysym::N => Some("XK_N"),
        Keysym::O => Some("XK_O"),
        Keysym::P => Some("XK_P"),
        Keysym::Q => Some("XK_Q"),
        Keysym::R => Some("XK_R"),
        Keysym::S => Some("XK_S"),
        Keysym::T => Some("XK_T"),
        Keysym::U => Some("XK_U"),
        Keysym::V => Some("XK_V"),
        Keysym::W => Some("XK_W"),
        Keysym::X => Some("XK_X"),
        Keysym::Y => Some("XK_Y"),
        Keysym::Z => Some("XK_Z"),
        Keysym::bracketleft => Some("XK_bracketleft"),
        Keysym::backslash => Some("XK_backslash"),
        Keysym::bracketright => Some("XK_bracketright"),
        Keysym::asciicircum => Some("XK_asciicircum"),
        Keysym::underscore => Some("XK_underscore"),
        Keysym::grave => Some("XK_grave"),
        Keysym::quoteleft => Some("XK_quoteleft"),
        Keysym::a => Some("XK_a"),
        Keysym::b => Some("XK_b"),
        Keysym::c => Some("XK_c"),
        Keysym::d => Some("XK_d"),
        Keysym::e => Some("XK_e"),
        Keysym::f => Some("XK_f"),
        Keysym::g => Some("XK_g"),
        Keysym::h => Some("XK_h"),
        Keysym::i => Some("XK_i"),
        Keysym::j => Some("XK_j"),
        Keysym::k => Some("XK_k"),
        Keysym::l => Some("XK_l"),
        Keysym::m => Some("XK_m"),
        Keysym::n => Some("XK_n"),
        Keysym::o => Some("XK_o"),
        Keysym::p => Some("XK_p"),
        Keysym::q => Some("XK_q"),
        Keysym::r => Some("XK_r"),
        Keysym::s => Some("XK_s"),
        Keysym::t => Some("XK_t"),
        Keysym::u => Some("XK_u"),
        Keysym::v => Some("XK_v"),
        Keysym::w => Some("XK_w"),
        Keysym::x => Some("XK_x"),
        Keysym::y => Some("XK_y"),
        Keysym::z => Some("XK_z"),
        Keysym::braceleft => Some("XK_braceleft"),
        Keysym::bar => Some("XK_bar"),
        Keysym::braceright => Some("XK_braceright"),
        Keysym::asciitilde => Some("XK_asciitilde"),
        Keysym::nobreakspace => Some("XK_nobreakspace"),
        Keysym::exclamdown => Some("XK_exclamdown"),
        Keysym::cent => Some("XK_cent"),
        Keysym::sterling => Some("XK_sterling"),
        Keysym::currency => Some("XK_currency"),
        Keysym::yen => Some("XK_yen"),
        Keysym::brokenbar => Some("XK_brokenbar"),
        Keysym::section => Some("XK_section"),
        Keysym::diaeresis => Some("XK_diaeresis"),
        Keysym::copyright => Some("XK_copyright"),
        Keysym::ordfeminine => Some("XK_ordfeminine"),
        Keysym::guillemotleft => Some("XK_guillemotleft"),
        Keysym::notsign => Some("XK_notsign"),
        Keysym::hyphen => Some("XK_hyphen"),
        Keysym::registered => Some("XK_registered"),
        Keysym::macron => Some("XK_macron"),
        Keysym::degree => Some("XK_degree"),
        Keysym::plusminus => Some("XK_plusminus"),
        Keysym::twosuperior => Some("XK_twosuperior"),
        Keysym::threesuperior => Some("XK_threesuperior"),
        Keysym::acute => Some("XK_acute"),
        Keysym::mu => Some("XK_mu"),
        Keysym::paragraph => Some("XK_paragraph"),
        Keysym::periodcentered => Some("XK_periodcentered"),
        Keysym::cedilla => Some("XK_cedilla"),
        Keysym::onesuperior => Some("XK_onesuperior"),
        Keysym::masculine => Some("XK_masculine"),
        Keysym::guillemotright => Some("XK_guillemotright"),
        Keysym::onequarter => Some("XK_onequarter"),
        Keysym::onehalf => Some("XK_onehalf"),
        Keysym::threequarters => Some("XK_threequarters"),
        Keysym::questiondown => Some("XK_questiondown"),
        Keysym::Agrave => Some("XK_Agrave"),
        Keysym::Aacute => Some("XK_Aacute"),
        Keysym::Acircumflex => Some("XK_Acircumflex"),
        Keysym::Atilde => Some("XK_Atilde"),
        Keysym::Adiaeresis => Some("XK_Adiaeresis"),
        Keysym::Aring => Some("XK_Aring"),
        Keysym::AE => Some("XK_AE"),
        Keysym::Ccedilla => Some("XK_Ccedilla"),
        Keysym::Egrave => Some("XK_Egrave"),
        Keysym::Eacute => Some("XK_Eacute"),
        Keysym::Ecircumflex => Some("XK_Ecircumflex"),
        Keysym::Ediaeresis => Some("XK_Ediaeresis"),
        Keysym::Igrave => Some("XK_Igrave"),
        Keysym::Iacute => Some("XK_Iacute"),
        Keysym::Icircumflex => Some("XK_Icircumflex"),
        Keysym::Idiaeresis => Some("XK_Idiaeresis"),
        Keysym::ETH => Some("XK_ETH"),
        Keysym::Eth => Some("XK_Eth"),
        Keysym::Ntilde => Some("XK_Ntilde"),
        Keysym::Ograve => Some("XK_Ograve"),
        Keysym::Oacute => Some("XK_Oacute"),
        Keysym::Ocircumflex => Some("XK_Ocircumflex"),
        Keysym::Otilde => Some("XK_Otilde"),
        Keysym::Odiaeresis => Some("XK_Odiaeresis"),
        Keysym::multiply => Some("XK_multiply"),
        Keysym::Oslash => Some("XK_Oslash"),
        Keysym::Ooblique => Some("XK_Ooblique"),
        Keysym::Ugrave => Some("XK_Ugrave"),
        Keysym::Uacute => Some("XK_Uacute"),
        Keysym::Ucircumflex => Some("XK_Ucircumflex"),
        Keysym::Udiaeresis => Some("XK_Udiaeresis"),
        Keysym::Yacute => Some("XK_Yacute"),
        Keysym::THORN => Some("XK_THORN"),
        Keysym::Thorn => Some("XK_Thorn"),
        Keysym::ssharp => Some("XK_ssharp"),
        Keysym::agrave => Some("XK_agrave"),
        Keysym::aacute => Some("XK_aacute"),
        Keysym::acircumflex => Some("XK_acircumflex"),
        Keysym::atilde => Some("XK_atilde"),
        Keysym::adiaeresis => Some("XK_adiaeresis"),
        Keysym::aring => Some("XK_aring"),
        Keysym::ae => Some("XK_ae"),
        Keysym::ccedilla => Some("XK_ccedilla"),
        Keysym::egrave => Some("XK_egrave"),
        Keysym::eacute => Some("XK_eacute"),
        Keysym::ecircumflex => Some("XK_ecircumflex"),
        Keysym::ediaeresis => Some("XK_ediaeresis"),
        Keysym::igrave => Some("XK_igrave"),
        Keysym::iacute => Some("XK_iacute"),
        Keysym::icircumflex => Some("XK_icircumflex"),
        Keysym::idiaeresis => Some("XK_idiaeresis"),
        Keysym::eth => Some("XK_eth"),
        Keysym::ntilde => Some("XK_ntilde"),
        Keysym::ograve => Some("XK_ograve"),
        Keysym::oacute => Some("XK_oacute"),
        Keysym::ocircumflex => Some("XK_ocircumflex"),
        Keysym::otilde => Some("XK_otilde"),
        Keysym::odiaeresis => Some("XK_odiaeresis"),
        Keysym::division => Some("XK_division"),
        Keysym::oslash => Some("XK_oslash"),
        Keysym::ooblique => Some("XK_ooblique"),
        Keysym::ugrave => Some("XK_ugrave"),
        Keysym::uacute => Some("XK_uacute"),
        Keysym::ucircumflex => Some("XK_ucircumflex"),
        Keysym::udiaeresis => Some("XK_udiaeresis"),
        Keysym::yacute => Some("XK_yacute"),
        Keysym::thorn => Some("XK_thorn"),
        Keysym::ydiaeresis => Some("XK_ydiaeresis"),
        Keysym::Aogonek => Some("XK_Aogonek"),
        Keysym::breve => Some("XK_breve"),
        Keysym::Lstroke => Some("XK_Lstroke"),
        Keysym::Lcaron => Some("XK_Lcaron"),
        Keysym::Sacute => Some("XK_Sacute"),
        Keysym::Scaron => Some("XK_Scaron"),
        Keysym::Scedilla => Some("XK_Scedilla"),
        Keysym::Tcaron => Some("XK_Tcaron"),
        Keysym::Zacute => Some("XK_Zacute"),
        Keysym::Zcaron => Some("XK_Zcaron"),
        Keysym::Zabovedot => Some("XK_Zabovedot"),
        Keysym::aogonek => Some("XK_aogonek"),
        Keysym::ogonek => Some("XK_ogonek"),
        Keysym::lstroke => Some("XK_lstroke"),
        Keysym::lcaron => Some("XK_lcaron"),
        Keysym::sacute => Some("XK_sacute"),
        Keysym::caron => Some("XK_caron"),
        Keysym::scaron => Some("XK_scaron"),
        Keysym::scedilla => Some("XK_scedilla"),
        Keysym::tcaron => Some("XK_tcaron"),
        Keysym::zacute => Some("XK_zacute"),
        Keysym::doubleacute => Some("XK_doubleacute"),
        Keysym::zcaron => Some("XK_zcaron"),
        Keysym::zabovedot => Some("XK_zabovedot"),
        Keysym::Racute => Some("XK_Racute"),
        Keysym::Abreve => Some("XK_Abreve"),
        Keysym::Lacute => Some("XK_Lacute"),
        Keysym::Cacute => Some("XK_Cacute"),
        Keysym::Ccaron => Some("XK_Ccaron"),
        Keysym::Eogonek => Some("XK_Eogonek"),
        Keysym::Ecaron => Some("XK_Ecaron"),
        Keysym::Dcaron => Some("XK_Dcaron"),
        Keysym::Dstroke => Some("XK_Dstroke"),
        Keysym::Nacute => Some("XK_Nacute"),
        Keysym::Ncaron => Some("XK_Ncaron"),
        Keysym::Odoubleacute => Some("XK_Odoubleacute"),
        Keysym::Rcaron => Some("XK_Rcaron"),
        Keysym::Uring => Some("XK_Uring"),
        Keysym::Udoubleacute => Some("XK_Udoubleacute"),
        Keysym::Tcedilla => Some("XK_Tcedilla"),
        Keysym::racute => Some("XK_racute"),
        Keysym::abreve => Some("XK_abreve"),
        Keysym::lacute => Some("XK_lacute"),
        Keysym::cacute => Some("XK_cacute"),
        Keysym::ccaron => Some("XK_ccaron"),
        Keysym::eogonek => Some("XK_eogonek"),
        Keysym::ecaron => Some("XK_ecaron"),
        Keysym::dcaron => Some("XK_dcaron"),
        Keysym::dstroke => Some("XK_dstroke"),
        Keysym::nacute => Some("XK_nacute"),
        Keysym::ncaron => Some("XK_ncaron"),
        Keysym::odoubleacute => Some("XK_odoubleacute"),
        Keysym::rcaron => Some("XK_rcaron"),
        Keysym::uring => Some("XK_uring"),
        Keysym::udoubleacute => Some("XK_udoubleacute"),
        Keysym::tcedilla => Some("XK_tcedilla"),
        Keysym::abovedot => Some("XK_abovedot"),
        Keysym::Hstroke => Some("XK_Hstroke"),
        Keysym::Hcircumflex => Some("XK_Hcircumflex"),
        Keysym::Iabovedot => Some("XK_Iabovedot"),
        Keysym::Gbreve => Some("XK_Gbreve"),
        Keysym::Jcircumflex => Some("XK_Jcircumflex"),
        Keysym::hstroke => Some("XK_hstroke"),
        Keysym::hcircumflex => Some("XK_hcircumflex"),
        Keysym::idotless => Some("XK_idotless"),
        Keysym::gbreve => Some("XK_gbreve"),
        Keysym::jcircumflex => Some("XK_jcircumflex"),
        Keysym::Cabovedot => Some("XK_Cabovedot"),
        Keysym::Ccircumflex => Some("XK_Ccircumflex"),
        Keysym::Gabovedot => Some("XK_Gabovedot"),
        Keysym::Gcircumflex => Some("XK_Gcircumflex"),
        Keysym::Ubreve => Some("XK_Ubreve"),
        Keysym::Scircumflex => Some("XK_Scircumflex"),
        Keysym::cabovedot => Some("XK_cabovedot"),
        Keysym::ccircumflex => Some("XK_ccircumflex"),
        Keysym::gabovedot => Some("XK_gabovedot"),
        Keysym::gcircumflex => Some("XK_gcircumflex"),
        Keysym::ubreve => Some("XK_ubreve"),
        Keysym::scircumflex => Some("XK_scircumflex"),
        Keysym::kra => Some("XK_kra"),
        Keysym::kappa => Some("XK_kappa"),
        Keysym::Rcedilla => Some("XK_Rcedilla"),
        Keysym::Itilde => Some("XK_Itilde"),
        Keysym::Lcedilla => Some("XK_Lcedilla"),
        Keysym::Emacron => Some("XK_Emacron"),
        Keysym::Gcedilla => Some("XK_Gcedilla"),
        Keysym::Tslash => Some("XK_Tslash"),
        Keysym::rcedilla => Some("XK_rcedilla"),
        Keysym::itilde => Some("XK_itilde"),
        Keysym::lcedilla => Some("XK_lcedilla"),
        Keysym::emacron => Some("XK_emacron"),
        Keysym::gcedilla => Some("XK_gcedilla"),
        Keysym::tslash => Some("XK_tslash"),
        Keysym::ENG => Some("XK_ENG"),
        Keysym::eng => Some("XK_eng"),
        Keysym::Amacron => Some("XK_Amacron"),
        Keysym::Iogonek => Some("XK_Iogonek"),
        Keysym::Eabovedot => Some("XK_Eabovedot"),
        Keysym::Imacron => Some("XK_Imacron"),
        Keysym::Ncedilla => Some("XK_Ncedilla"),
        Keysym::Omacron => Some("XK_Omacron"),
        Keysym::Kcedilla => Some("XK_Kcedilla"),
        Keysym::Uogonek => Some("XK_Uogonek"),
        Keysym::Utilde => Some("XK_Utilde"),
        Keysym::Umacron => Some("XK_Umacron"),
        Keysym::amacron => Some("XK_amacron"),
        Keysym::iogonek => Some("XK_iogonek"),
        Keysym::eabovedot => Some("XK_eabovedot"),
        Keysym::imacron => Some("XK_imacron"),
        Keysym::ncedilla => Some("XK_ncedilla"),
        Keysym::omacron => Some("XK_omacron"),
        Keysym::kcedilla => Some("XK_kcedilla"),
        Keysym::uogonek => Some("XK_uogonek"),
        Keysym::utilde => Some("XK_utilde"),
        Keysym::umacron => Some("XK_umacron"),
        Keysym::Wcircumflex => Some("XK_Wcircumflex"),
        Keysym::wcircumflex => Some("XK_wcircumflex"),
        Keysym::Ycircumflex => Some("XK_Ycircumflex"),
        Keysym::ycircumflex => Some("XK_ycircumflex"),
        Keysym::Babovedot => Some("XK_Babovedot"),
        Keysym::babovedot => Some("XK_babovedot"),
        Keysym::Dabovedot => Some("XK_Dabovedot"),
        Keysym::dabovedot => Some("XK_dabovedot"),
        Keysym::Fabovedot => Some("XK_Fabovedot"),
        Keysym::fabovedot => Some("XK_fabovedot"),
        Keysym::Mabovedot => Some("XK_Mabovedot"),
        Keysym::mabovedot => Some("XK_mabovedot"),
        Keysym::Pabovedot => Some("XK_Pabovedot"),
        Keysym::pabovedot => Some("XK_pabovedot"),
        Keysym::Sabovedot => Some("XK_Sabovedot"),
        Keysym::sabovedot => Some("XK_sabovedot"),
        Keysym::Tabovedot => Some("XK_Tabovedot"),
        Keysym::tabovedot => Some("XK_tabovedot"),
        Keysym::Wgrave => Some("XK_Wgrave"),
        Keysym::wgrave => Some("XK_wgrave"),
        Keysym::Wacute => Some("XK_Wacute"),
        Keysym::wacute => Some("XK_wacute"),
        Keysym::Wdiaeresis => Some("XK_Wdiaeresis"),
        Keysym::wdiaeresis => Some("XK_wdiaeresis"),
        Keysym::Ygrave => Some("XK_Ygrave"),
        Keysym::ygrave => Some("XK_ygrave"),
        Keysym::OE => Some("XK_OE"),
        Keysym::oe => Some("XK_oe"),
        Keysym::Ydiaeresis => Some("XK_Ydiaeresis"),
        Keysym::overline => Some("XK_overline"),
        Keysym::kana_fullstop => Some("XK_kana_fullstop"),
        Keysym::kana_openingbracket => Some("XK_kana_openingbracket"),
        Keysym::kana_closingbracket => Some("XK_kana_closingbracket"),
        Keysym::kana_comma => Some("XK_kana_comma"),
        Keysym::kana_conjunctive => Some("XK_kana_conjunctive"),
        Keysym::kana_middledot => Some("XK_kana_middledot"),
        Keysym::kana_WO => Some("XK_kana_WO"),
        Keysym::kana_a => Some("XK_kana_a"),
        Keysym::kana_i => Some("XK_kana_i"),
        Keysym::kana_u => Some("XK_kana_u"),
        Keysym::kana_e => Some("XK_kana_e"),
        Keysym::kana_o => Some("XK_kana_o"),
        Keysym::kana_ya => Some("XK_kana_ya"),
        Keysym::kana_yu => Some("XK_kana_yu"),
        Keysym::kana_yo => Some("XK_kana_yo"),
        Keysym::kana_tsu => Some("XK_kana_tsu"),
        Keysym::kana_tu => Some("XK_kana_tu"),
        Keysym::prolongedsound => Some("XK_prolongedsound"),
        Keysym::kana_A => Some("XK_kana_A"),
        Keysym::kana_I => Some("XK_kana_I"),
        Keysym::kana_U => Some("XK_kana_U"),
        Keysym::kana_E => Some("XK_kana_E"),
        Keysym::kana_O => Some("XK_kana_O"),
        Keysym::kana_KA => Some("XK_kana_KA"),
        Keysym::kana_KI => Some("XK_kana_KI"),
        Keysym::kana_KU => Some("XK_kana_KU"),
        Keysym::kana_KE => Some("XK_kana_KE"),
        Keysym::kana_KO => Some("XK_kana_KO"),
        Keysym::kana_SA => Some("XK_kana_SA"),
        Keysym::kana_SHI => Some("XK_kana_SHI"),
        Keysym::kana_SU => Some("XK_kana_SU"),
        Keysym::kana_SE => Some("XK_kana_SE"),
        Keysym::kana_SO => Some("XK_kana_SO"),
        Keysym::kana_TA => Some("XK_kana_TA"),
        Keysym::kana_CHI => Some("XK_kana_CHI"),
        Keysym::kana_TI => Some("XK_kana_TI"),
        Keysym::kana_TSU => Some("XK_kana_TSU"),
        Keysym::kana_TU => Some("XK_kana_TU"),
        Keysym::kana_TE => Some("XK_kana_TE"),
        Keysym::kana_TO => Some("XK_kana_TO"),
        Keysym::kana_NA => Some("XK_kana_NA"),
        Keysym::kana_NI => Some("XK_kana_NI"),
        Keysym::kana_NU => Some("XK_kana_NU"),
        Keysym::kana_NE => Some("XK_kana_NE"),
        Keysym::kana_NO => Some("XK_kana_NO"),
        Keysym::kana_HA => Some("XK_kana_HA"),
        Keysym::kana_HI => Some("XK_kana_HI"),
        Keysym::kana_FU => Some("XK_kana_FU"),
        Keysym::kana_HU => Some("XK_kana_HU"),
        Keysym::kana_HE => Some("XK_kana_HE"),
        Keysym::kana_HO => Some("XK_kana_HO"),
        Keysym::kana_MA => Some("XK_kana_MA"),
        Keysym::kana_MI => Some("XK_kana_MI"),
        Keysym::kana_MU => Some("XK_kana_MU"),
        Keysym::kana_ME => Some("XK_kana_ME"),
        Keysym::kana_MO => Some("XK_kana_MO"),
        Keysym::kana_YA => Some("XK_kana_YA"),
        Keysym::kana_YU => Some("XK_kana_YU"),
        Keysym::kana_YO => Some("XK_kana_YO"),
        Keysym::kana_RA => Some("XK_kana_RA"),
        Keysym::kana_RI => Some("XK_kana_RI"),
        Keysym::kana_RU => Some("XK_kana_RU"),
        Keysym::kana_RE => Some("XK_kana_RE"),
        Keysym::kana_RO => Some("XK_kana_RO"),
        Keysym::kana_WA => Some("XK_kana_WA"),
        Keysym::kana_N => Some("XK_kana_N"),
        Keysym::voicedsound => Some("XK_voicedsound"),
        Keysym::semivoicedsound => Some("XK_semivoicedsound"),
        Keysym::kana_switch => Some("XK_kana_switch"),
        Keysym::Farsi_0 => Some("XK_Farsi_0"),
        Keysym::Farsi_1 => Some("XK_Farsi_1"),
        Keysym::Farsi_2 => Some("XK_Farsi_2"),
        Keysym::Farsi_3 => Some("XK_Farsi_3"),
        Keysym::Farsi_4 => Some("XK_Farsi_4"),
        Keysym::Farsi_5 => Some("XK_Farsi_5"),
        Keysym::Farsi_6 => Some("XK_Farsi_6"),
        Keysym::Farsi_7 => Some("XK_Farsi_7"),
        Keysym::Farsi_8 => Some("XK_Farsi_8"),
        Keysym::Farsi_9 => Some("XK_Farsi_9"),
        Keysym::Arabic_percent => Some("XK_Arabic_percent"),
        Keysym::Arabic_superscript_alef => Some("XK_Arabic_superscript_alef"),
        Keysym::Arabic_tteh => Some("XK_Arabic_tteh"),
        Keysym::Arabic_peh => Some("XK_Arabic_peh"),
        Keysym::Arabic_tcheh => Some("XK_Arabic_tcheh"),
        Keysym::Arabic_ddal => Some("XK_Arabic_ddal"),
        Keysym::Arabic_rreh => Some("XK_Arabic_rreh"),
        Keysym::Arabic_comma => Some("XK_Arabic_comma"),
        Keysym::Arabic_fullstop => Some("XK_Arabic_fullstop"),
        Keysym::Arabic_0 => Some("XK_Arabic_0"),
        Keysym::Arabic_1 => Some("XK_Arabic_1"),
        Keysym::Arabic_2 => Some("XK_Arabic_2"),
        Keysym::Arabic_3 => Some("XK_Arabic_3"),
        Keysym::Arabic_4 => Some("XK_Arabic_4"),
        Keysym::Arabic_5 => Some("XK_Arabic_5"),
        Keysym::Arabic_6 => Some("XK_Arabic_6"),
        Keysym::Arabic_7 => Some("XK_Arabic_7"),
        Keysym::Arabic_8 => Some("XK_Arabic_8"),
        Keysym::Arabic_9 => Some("XK_Arabic_9"),
        Keysym::Arabic_semicolon => Some("XK_Arabic_semicolon"),
        Keysym::Arabic_question_mark => Some("XK_Arabic_question_mark"),
        Keysym::Arabic_hamza => Some("XK_Arabic_hamza"),
        Keysym::Arabic_maddaonalef => Some("XK_Arabic_maddaonalef"),
        Keysym::Arabic_hamzaonalef => Some("XK_Arabic_hamzaonalef"),
        Keysym::Arabic_hamzaonwaw => Some("XK_Arabic_hamzaonwaw"),
        Keysym::Arabic_hamzaunderalef => Some("XK_Arabic_hamzaunderalef"),
        Keysym::Arabic_hamzaonyeh => Some("XK_Arabic_hamzaonyeh"),
        Keysym::Arabic_alef => Some("XK_Arabic_alef"),
        Keysym::Arabic_beh => Some("XK_Arabic_beh"),
        Keysym::Arabic_tehmarbuta => Some("XK_Arabic_tehmarbuta"),
        Keysym::Arabic_teh => Some("XK_Arabic_teh"),
        Keysym::Arabic_theh => Some("XK_Arabic_theh"),
        Keysym::Arabic_jeem => Some("XK_Arabic_jeem"),
        Keysym::Arabic_hah => Some("XK_Arabic_hah"),
        Keysym::Arabic_khah => Some("XK_Arabic_khah"),
        Keysym::Arabic_dal => Some("XK_Arabic_dal"),
        Keysym::Arabic_thal => Some("XK_Arabic_thal"),
        Keysym::Arabic_ra => Some("XK_Arabic_ra"),
        Keysym::Arabic_zain => Some("XK_Arabic_zain"),
        Keysym::Arabic_seen => Some("XK_Arabic_seen"),
        Keysym::Arabic_sheen => Some("XK_Arabic_sheen"),
        Keysym::Arabic_sad => Some("XK_Arabic_sad"),
        Keysym::Arabic_dad => Some("XK_Arabic_dad"),
        Keysym::Arabic_tah => Some("XK_Arabic_tah"),
        Keysym::Arabic_zah => Some("XK_Arabic_zah"),
        Keysym::Arabic_ain => Some("XK_Arabic_ain"),
        Keysym::Arabic_ghain => Some("XK_Arabic_ghain"),
        Keysym::Arabic_tatweel => Some("XK_Arabic_tatweel"),
        Keysym::Arabic_feh => Some("XK_Arabic_feh"),
        Keysym::Arabic_qaf => Some("XK_Arabic_qaf"),
        Keysym::Arabic_kaf => Some("XK_Arabic_kaf"),
        Keysym::Arabic_lam => Some("XK_Arabic_lam"),
        Keysym::Arabic_meem => Some("XK_Arabic_meem"),
        Keysym::Arabic_noon => Some("XK_Arabic_noon"),
        Keysym::Arabic_ha => Some("XK_Arabic_ha"),
        Keysym::Arabic_heh => Some("XK_Arabic_heh"),
        Keysym::Arabic_waw => Some("XK_Arabic_waw"),
        Keysym::Arabic_alefmaksura => Some("XK_Arabic_alefmaksura"),
        Keysym::Arabic_yeh => Some("XK_Arabic_yeh"),
        Keysym::Arabic_fathatan => Some("XK_Arabic_fathatan"),
        Keysym::Arabic_dammatan => Some("XK_Arabic_dammatan"),
        Keysym::Arabic_kasratan => Some("XK_Arabic_kasratan"),
        Keysym::Arabic_fatha => Some("XK_Arabic_fatha"),
        Keysym::Arabic_damma => Some("XK_Arabic_damma"),
        Keysym::Arabic_kasra => Some("XK_Arabic_kasra"),
        Keysym::Arabic_shadda => Some("XK_Arabic_shadda"),
        Keysym::Arabic_sukun => Some("XK_Arabic_sukun"),
        Keysym::Arabic_madda_above => Some("XK_Arabic_madda_above"),
        Keysym::Arabic_hamza_above => Some("XK_Arabic_hamza_above"),
        Keysym::Arabic_hamza_below => Some("XK_Arabic_hamza_below"),
        Keysym::Arabic_jeh => Some("XK_Arabic_jeh"),
        Keysym::Arabic_veh => Some("XK_Arabic_veh"),
        Keysym::Arabic_keheh => Some("XK_Arabic_keheh"),
        Keysym::Arabic_gaf => Some("XK_Arabic_gaf"),
        Keysym::Arabic_noon_ghunna => Some("XK_Arabic_noon_ghunna"),
        Keysym::Arabic_heh_doachashmee => Some("XK_Arabic_heh_doachashmee"),
        Keysym::Farsi_yeh => Some("XK_Farsi_yeh"),
        Keysym::Arabic_farsi_yeh => Some("XK_Arabic_farsi_yeh"),
        Keysym::Arabic_yeh_baree => Some("XK_Arabic_yeh_baree"),
        Keysym::Arabic_heh_goal => Some("XK_Arabic_heh_goal"),
        Keysym::Arabic_switch => Some("XK_Arabic_switch"),
        Keysym::Cyrillic_GHE_bar => Some("XK_Cyrillic_GHE_bar"),
        Keysym::Cyrillic_ghe_bar => Some("XK_Cyrillic_ghe_bar"),
        Keysym::Cyrillic_ZHE_descender => Some("XK_Cyrillic_ZHE_descender"),
        Keysym::Cyrillic_zhe_descender => Some("XK_Cyrillic_zhe_descender"),
        Keysym::Cyrillic_KA_descender => Some("XK_Cyrillic_KA_descender"),
        Keysym::Cyrillic_ka_descender => Some("XK_Cyrillic_ka_descender"),
        Keysym::Cyrillic_KA_vertstroke => Some("XK_Cyrillic_KA_vertstroke"),
        Keysym::Cyrillic_ka_vertstroke => Some("XK_Cyrillic_ka_vertstroke"),
        Keysym::Cyrillic_EN_descender => Some("XK_Cyrillic_EN_descender"),
        Keysym::Cyrillic_en_descender => Some("XK_Cyrillic_en_descender"),
        Keysym::Cyrillic_U_straight => Some("XK_Cyrillic_U_straight"),
        Keysym::Cyrillic_u_straight => Some("XK_Cyrillic_u_straight"),
        Keysym::Cyrillic_U_straight_bar => Some("XK_Cyrillic_U_straight_bar"),
        Keysym::Cyrillic_u_straight_bar => Some("XK_Cyrillic_u_straight_bar"),
        Keysym::Cyrillic_HA_descender => Some("XK_Cyrillic_HA_descender"),
        Keysym::Cyrillic_ha_descender => Some("XK_Cyrillic_ha_descender"),
        Keysym::Cyrillic_CHE_descender => Some("XK_Cyrillic_CHE_descender"),
        Keysym::Cyrillic_che_descender => Some("XK_Cyrillic_che_descender"),
        Keysym::Cyrillic_CHE_vertstroke => Some("XK_Cyrillic_CHE_vertstroke"),
        Keysym::Cyrillic_che_vertstroke => Some("XK_Cyrillic_che_vertstroke"),
        Keysym::Cyrillic_SHHA => Some("XK_Cyrillic_SHHA"),
        Keysym::Cyrillic_shha => Some("XK_Cyrillic_shha"),
        Keysym::Cyrillic_SCHWA => Some("XK_Cyrillic_SCHWA"),
        Keysym::Cyrillic_schwa => Some("XK_Cyrillic_schwa"),
        Keysym::Cyrillic_I_macron => Some("XK_Cyrillic_I_macron"),
        Keysym::Cyrillic_i_macron => Some("XK_Cyrillic_i_macron"),
        Keysym::Cyrillic_O_bar => Some("XK_Cyrillic_O_bar"),
        Keysym::Cyrillic_o_bar => Some("XK_Cyrillic_o_bar"),
        Keysym::Cyrillic_U_macron => Some("XK_Cyrillic_U_macron"),
        Keysym::Cyrillic_u_macron => Some("XK_Cyrillic_u_macron"),
        Keysym::Serbian_dje => Some("XK_Serbian_dje"),
        Keysym::Macedonia_gje => Some("XK_Macedonia_gje"),
        Keysym::Cyrillic_io => Some("XK_Cyrillic_io"),
        Keysym::Ukrainian_ie => Some("XK_Ukrainian_ie"),
        Keysym::Ukranian_je => Some("XK_Ukranian_je"),
        Keysym::Macedonia_dse => Some("XK_Macedonia_dse"),
        Keysym::Ukrainian_i => Some("XK_Ukrainian_i"),
        Keysym::Ukranian_i => Some("XK_Ukranian_i"),
        Keysym::Ukrainian_yi => Some("XK_Ukrainian_yi"),
        Keysym::Ukranian_yi => Some("XK_Ukranian_yi"),
        Keysym::Cyrillic_je => Some("XK_Cyrillic_je"),
        Keysym::Serbian_je => Some("XK_Serbian_je"),
        Keysym::Cyrillic_lje => Some("XK_Cyrillic_lje"),
        Keysym::Serbian_lje => Some("XK_Serbian_lje"),
        Keysym::Cyrillic_nje => Some("XK_Cyrillic_nje"),
        Keysym::Serbian_nje => Some("XK_Serbian_nje"),
        Keysym::Serbian_tshe => Some("XK_Serbian_tshe"),
        Keysym::Macedonia_kje => Some("XK_Macedonia_kje"),
        Keysym::Ukrainian_ghe_with_upturn => Some("XK_Ukrainian_ghe_with_upturn"),
        Keysym::Byelorussian_shortu => Some("XK_Byelorussian_shortu"),
        Keysym::Cyrillic_dzhe => Some("XK_Cyrillic_dzhe"),
        Keysym::Serbian_dze => Some("XK_Serbian_dze"),
        Keysym::numerosign => Some("XK_numerosign"),
        Keysym::Serbian_DJE => Some("XK_Serbian_DJE"),
        Keysym::Macedonia_GJE => Some("XK_Macedonia_GJE"),
        Keysym::Cyrillic_IO => Some("XK_Cyrillic_IO"),
        Keysym::Ukrainian_IE => Some("XK_Ukrainian_IE"),
        Keysym::Ukranian_JE => Some("XK_Ukranian_JE"),
        Keysym::Macedonia_DSE => Some("XK_Macedonia_DSE"),
        Keysym::Ukrainian_I => Some("XK_Ukrainian_I"),
        Keysym::Ukranian_I => Some("XK_Ukranian_I"),
        Keysym::Ukrainian_YI => Some("XK_Ukrainian_YI"),
        Keysym::Ukranian_YI => Some("XK_Ukranian_YI"),
        Keysym::Cyrillic_JE => Some("XK_Cyrillic_JE"),
        Keysym::Serbian_JE => Some("XK_Serbian_JE"),
        Keysym::Cyrillic_LJE => Some("XK_Cyrillic_LJE"),
        Keysym::Serbian_LJE => Some("XK_Serbian_LJE"),
        Keysym::Cyrillic_NJE => Some("XK_Cyrillic_NJE"),
        Keysym::Serbian_NJE => Some("XK_Serbian_NJE"),
        Keysym::Serbian_TSHE => Some("XK_Serbian_TSHE"),
        Keysym::Macedonia_KJE => Some("XK_Macedonia_KJE"),
        Keysym::Ukrainian_GHE_WITH_UPTURN => Some("XK_Ukrainian_GHE_WITH_UPTURN"),
        Keysym::Byelorussian_SHORTU => Some("XK_Byelorussian_SHORTU"),
        Keysym::Cyrillic_DZHE => Some("XK_Cyrillic_DZHE"),
        Keysym::Serbian_DZE => Some("XK_Serbian_DZE"),
        Keysym::Cyrillic_yu => Some("XK_Cyrillic_yu"),
        Keysym::Cyrillic_a => Some("XK_Cyrillic_a"),
        Keysym::Cyrillic_be => Some("XK_Cyrillic_be"),
        Keysym::Cyrillic_tse => Some("XK_Cyrillic_tse"),
        Keysym::Cyrillic_de => Some("XK_Cyrillic_de"),
        Keysym::Cyrillic_ie => Some("XK_Cyrillic_ie"),
        Keysym::Cyrillic_ef => Some("XK_Cyrillic_ef"),
        Keysym::Cyrillic_ghe => Some("XK_Cyrillic_ghe"),
        Keysym::Cyrillic_ha => Some("XK_Cyrillic_ha"),
        Keysym::Cyrillic_i => Some("XK_Cyrillic_i"),
        Keysym::Cyrillic_shorti => Some("XK_Cyrillic_shorti"),
        Keysym::Cyrillic_ka => Some("XK_Cyrillic_ka"),
        Keysym::Cyrillic_el => Some("XK_Cyrillic_el"),
        Keysym::Cyrillic_em => Some("XK_Cyrillic_em"),
        Keysym::Cyrillic_en => Some("XK_Cyrillic_en"),
        Keysym::Cyrillic_o => Some("XK_Cyrillic_o"),
        Keysym::Cyrillic_pe => Some("XK_Cyrillic_pe"),
        Keysym::Cyrillic_ya => Some("XK_Cyrillic_ya"),
        Keysym::Cyrillic_er => Some("XK_Cyrillic_er"),
        Keysym::Cyrillic_es => Some("XK_Cyrillic_es"),
        Keysym::Cyrillic_te => Some("XK_Cyrillic_te"),
        Keysym::Cyrillic_u => Some("XK_Cyrillic_u"),
        Keysym::Cyrillic_zhe => Some("XK_Cyrillic_zhe"),
        Keysym::Cyrillic_ve => Some("XK_Cyrillic_ve"),
        Keysym::Cyrillic_softsign => Some("XK_Cyrillic_softsign"),
        Keysym::Cyrillic_yeru => Some("XK_Cyrillic_yeru"),
        Keysym::Cyrillic_ze => Some("XK_Cyrillic_ze"),
        Keysym::Cyrillic_sha => Some("XK_Cyrillic_sha"),
        Keysym::Cyrillic_e => Some("XK_Cyrillic_e"),
        Keysym::Cyrillic_shcha => Some("XK_Cyrillic_shcha"),
        Keysym::Cyrillic_che => Some("XK_Cyrillic_che"),
        Keysym::Cyrillic_hardsign => Some("XK_Cyrillic_hardsign"),
        Keysym::Cyrillic_YU => Some("XK_Cyrillic_YU"),
        Keysym::Cyrillic_A => Some("XK_Cyrillic_A"),
        Keysym::Cyrillic_BE => Some("XK_Cyrillic_BE"),
        Keysym::Cyrillic_TSE => Some("XK_Cyrillic_TSE"),
        Keysym::Cyrillic_DE => Some("XK_Cyrillic_DE"),
        Keysym::Cyrillic_IE => Some("XK_Cyrillic_IE"),
        Keysym::Cyrillic_EF => Some("XK_Cyrillic_EF"),
        Keysym::Cyrillic_GHE => Some("XK_Cyrillic_GHE"),
        Keysym::Cyrillic_HA => Some("XK_Cyrillic_HA"),
        Keysym::Cyrillic_I => Some("XK_Cyrillic_I"),
        Keysym::Cyrillic_SHORTI => Some("XK_Cyrillic_SHORTI"),
        Keysym::Cyrillic_KA => Some("XK_Cyrillic_KA"),
        Keysym::Cyrillic_EL => Some("XK_Cyrillic_EL"),
        Keysym::Cyrillic_EM => Some("XK_Cyrillic_EM"),
        Keysym::Cyrillic_EN => Some("XK_Cyrillic_EN"),
        Keysym::Cyrillic_O => Some("XK_Cyrillic_O"),
        Keysym::Cyrillic_PE => Some("XK_Cyrillic_PE"),
        Keysym::Cyrillic_YA => Some("XK_Cyrillic_YA"),
        Keysym::Cyrillic_ER => Some("XK_Cyrillic_ER"),
        Keysym::Cyrillic_ES => Some("XK_Cyrillic_ES"),
        Keysym::Cyrillic_TE => Some("XK_Cyrillic_TE"),
        Keysym::Cyrillic_U => Some("XK_Cyrillic_U"),
        Keysym::Cyrillic_ZHE => Some("XK_Cyrillic_ZHE"),
        Keysym::Cyrillic_VE => Some("XK_Cyrillic_VE"),
        Keysym::Cyrillic_SOFTSIGN => Some("XK_Cyrillic_SOFTSIGN"),
        Keysym::Cyrillic_YERU => Some("XK_Cyrillic_YERU"),
        Keysym::Cyrillic_ZE => Some("XK_Cyrillic_ZE"),
        Keysym::Cyrillic_SHA => Some("XK_Cyrillic_SHA"),
        Keysym::Cyrillic_E => Some("XK_Cyrillic_E"),
        Keysym::Cyrillic_SHCHA => Some("XK_Cyrillic_SHCHA"),
        Keysym::Cyrillic_CHE => Some("XK_Cyrillic_CHE"),
        Keysym::Cyrillic_HARDSIGN => Some("XK_Cyrillic_HARDSIGN"),
        Keysym::Greek_ALPHAaccent => Some("XK_Greek_ALPHAaccent"),
        Keysym::Greek_EPSILONaccent => Some("XK_Greek_EPSILONaccent"),
        Keysym::Greek_ETAaccent => Some("XK_Greek_ETAaccent"),
        Keysym::Greek_IOTAaccent => Some("XK_Greek_IOTAaccent"),
        Keysym::Greek_IOTAdieresis => Some("XK_Greek_IOTAdieresis"),
        Keysym::Greek_IOTAdiaeresis => Some("XK_Greek_IOTAdiaeresis"),
        Keysym::Greek_OMICRONaccent => Some("XK_Greek_OMICRONaccent"),
        Keysym::Greek_UPSILONaccent => Some("XK_Greek_UPSILONaccent"),
        Keysym::Greek_UPSILONdieresis => Some("XK_Greek_UPSILONdieresis"),
        Keysym::Greek_OMEGAaccent => Some("XK_Greek_OMEGAaccent"),
        Keysym::Greek_accentdieresis => Some("XK_Greek_accentdieresis"),
        Keysym::Greek_horizbar => Some("XK_Greek_horizbar"),
        Keysym::Greek_alphaaccent => Some("XK_Greek_alphaaccent"),
        Keysym::Greek_epsilonaccent => Some("XK_Greek_epsilonaccent"),
        Keysym::Greek_etaaccent => Some("XK_Greek_etaaccent"),
        Keysym::Greek_iotaaccent => Some("XK_Greek_iotaaccent"),
        Keysym::Greek_iotadieresis => Some("XK_Greek_iotadieresis"),
        Keysym::Greek_iotaaccentdieresis => Some("XK_Greek_iotaaccentdieresis"),
        Keysym::Greek_omicronaccent => Some("XK_Greek_omicronaccent"),
        Keysym::Greek_upsilonaccent => Some("XK_Greek_upsilonaccent"),
        Keysym::Greek_upsilondieresis => Some("XK_Greek_upsilondieresis"),
        Keysym::Greek_upsilonaccentdieresis => Some("XK_Greek_upsilonaccentdieresis"),
        Keysym::Greek_omegaaccent => Some("XK_Greek_omegaaccent"),
        Keysym::Greek_ALPHA => Some("XK_Greek_ALPHA"),
        Keysym::Greek_BETA => Some("XK_Greek_BETA"),
        Keysym::Greek_GAMMA => Some("XK_Greek_GAMMA"),
        Keysym::Greek_DELTA => Some("XK_Greek_DELTA"),
        Keysym::Greek_EPSILON => Some("XK_Greek_EPSILON"),
        Keysym::Greek_ZETA => Some("XK_Greek_ZETA"),
        Keysym::Greek_ETA => Some("XK_Greek_ETA"),
        Keysym::Greek_THETA => Some("XK_Greek_THETA"),
        Keysym::Greek_IOTA => Some("XK_Greek_IOTA"),
        Keysym::Greek_KAPPA => Some("XK_Greek_KAPPA"),
        Keysym::Greek_LAMDA => Some("XK_Greek_LAMDA"),
        Keysym::Greek_LAMBDA => Some("XK_Greek_LAMBDA"),
        Keysym::Greek_MU => Some("XK_Greek_MU"),
        Keysym::Greek_NU => Some("XK_Greek_NU"),
        Keysym::Greek_XI => Some("XK_Greek_XI"),
        Keysym::Greek_OMICRON => Some("XK_Greek_OMICRON"),
        Keysym::Greek_PI => Some("XK_Greek_PI"),
        Keysym::Greek_RHO => Some("XK_Greek_RHO"),
        Keysym::Greek_SIGMA => Some("XK_Greek_SIGMA"),
        Keysym::Greek_TAU => Some("XK_Greek_TAU"),
        Keysym::Greek_UPSILON => Some("XK_Greek_UPSILON"),
        Keysym::Greek_PHI => Some("XK_Greek_PHI"),
        Keysym::Greek_CHI => Some("XK_Greek_CHI"),
        Keysym::Greek_PSI => Some("XK_Greek_PSI"),
        Keysym::Greek_OMEGA => Some("XK_Greek_OMEGA"),
        Keysym::Greek_alpha => Some("XK_Greek_alpha"),
        Keysym::Greek_beta => Some("XK_Greek_beta"),
        Keysym::Greek_gamma => Some("XK_Greek_gamma"),
        Keysym::Greek_delta => Some("XK_Greek_delta"),
        Keysym::Greek_epsilon => Some("XK_Greek_epsilon"),
        Keysym::Greek_zeta => Some("XK_Greek_zeta"),
        Keysym::Greek_eta => Some("XK_Greek_eta"),
        Keysym::Greek_theta => Some("XK_Greek_theta"),
        Keysym::Greek_iota => Some("XK_Greek_iota"),
        Keysym::Greek_kappa => Some("XK_Greek_kappa"),
        Keysym::Greek_lamda => Some("XK_Greek_lamda"),
        Keysym::Greek_lambda => Some("XK_Greek_lambda"),
        Keysym::Greek_mu => Some("XK_Greek_mu"),
        Keysym::Greek_nu => Some("XK_Greek_nu"),
        Keysym::Greek_xi => Some("XK_Greek_xi"),
        Keysym::Greek_omicron => Some("XK_Greek_omicron"),
        Keysym::Greek_pi => Some("XK_Greek_pi"),
        Keysym::Greek_rho => Some("XK_Greek_rho"),
        Keysym::Greek_sigma => Some("XK_Greek_sigma"),
        Keysym::Greek_finalsmallsigma => Some("XK_Greek_finalsmallsigma"),
        Keysym::Greek_tau => Some("XK_Greek_tau"),
        Keysym::Greek_upsilon => Some("XK_Greek_upsilon"),
        Keysym::Greek_phi => Some("XK_Greek_phi"),
        Keysym::Greek_chi => Some("XK_Greek_chi"),
        Keysym::Greek_psi => Some("XK_Greek_psi"),
        Keysym::Greek_omega => Some("XK_Greek_omega"),
        Keysym::Greek_switch => Some("XK_Greek_switch"),
        Keysym::leftradical => Some("XK_leftradical"),
        Keysym::topleftradical => Some("XK_topleftradical"),
        Keysym::horizconnector => Some("XK_horizconnector"),
        Keysym::topintegral => Some("XK_topintegral"),
        Keysym::botintegral => Some("XK_botintegral"),
        Keysym::vertconnector => Some("XK_vertconnector"),
        Keysym::topleftsqbracket => Some("XK_topleftsqbracket"),
        Keysym::botleftsqbracket => Some("XK_botleftsqbracket"),
        Keysym::toprightsqbracket => Some("XK_toprightsqbracket"),
        Keysym::botrightsqbracket => Some("XK_botrightsqbracket"),
        Keysym::topleftparens => Some("XK_topleftparens"),
        Keysym::botleftparens => Some("XK_botleftparens"),
        Keysym::toprightparens => Some("XK_toprightparens"),
        Keysym::botrightparens => Some("XK_botrightparens"),
        Keysym::leftmiddlecurlybrace => Some("XK_leftmiddlecurlybrace"),
        Keysym::rightmiddlecurlybrace => Some("XK_rightmiddlecurlybrace"),
        Keysym::topleftsummation => Some("XK_topleftsummation"),
        Keysym::botleftsummation => Some("XK_botleftsummation"),
        Keysym::topvertsummationconnector => Some("XK_topvertsummationconnector"),
        Keysym::botvertsummationconnector => Some("XK_botvertsummationconnector"),
        Keysym::toprightsummation => Some("XK_toprightsummation"),
        Keysym::botrightsummation => Some("XK_botrightsummation"),
        Keysym::rightmiddlesummation => Some("XK_rightmiddlesummation"),
        Keysym::lessthanequal => Some("XK_lessthanequal"),
        Keysym::notequal => Some("XK_notequal"),
        Keysym::greaterthanequal => Some("XK_greaterthanequal"),
        Keysym::integral => Some("XK_integral"),
        Keysym::therefore => Some("XK_therefore"),
        Keysym::variation => Some("XK_variation"),
        Keysym::infinity => Some("XK_infinity"),
        Keysym::nabla => Some("XK_nabla"),
        Keysym::approximate => Some("XK_approximate"),
        Keysym::similarequal => Some("XK_similarequal"),
        Keysym::ifonlyif => Some("XK_ifonlyif"),
        Keysym::implies => Some("XK_implies"),
        Keysym::identical => Some("XK_identical"),
        Keysym::radical => Some("XK_radical"),
        Keysym::includedin => Some("XK_includedin"),
        Keysym::includes => Some("XK_includes"),
        Keysym::intersection => Some("XK_intersection"),
        Keysym::union => Some("XK_union"),
        Keysym::logicaland => Some("XK_logicaland"),
        Keysym::logicalor => Some("XK_logicalor"),
        Keysym::partialderivative => Some("XK_partialderivative"),
        Keysym::function => Some("XK_function"),
        Keysym::leftarrow => Some("XK_leftarrow"),
        Keysym::uparrow => Some("XK_uparrow"),
        Keysym::rightarrow => Some("XK_rightarrow"),
        Keysym::downarrow => Some("XK_downarrow"),
        Keysym::blank => Some("XK_blank"),
        Keysym::soliddiamond => Some("XK_soliddiamond"),
        Keysym::checkerboard => Some("XK_checkerboard"),
        Keysym::ht => Some("XK_ht"),
        Keysym::ff => Some("XK_ff"),
        Keysym::cr => Some("XK_cr"),
        Keysym::lf => Some("XK_lf"),
        Keysym::nl => Some("XK_nl"),
        Keysym::vt => Some("XK_vt"),
        Keysym::lowrightcorner => Some("XK_lowrightcorner"),
        Keysym::uprightcorner => Some("XK_uprightcorner"),
        Keysym::upleftcorner => Some("XK_upleftcorner"),
        Keysym::lowleftcorner => Some("XK_lowleftcorner"),
        Keysym::crossinglines => Some("XK_crossinglines"),
        Keysym::horizlinescan1 => Some("XK_horizlinescan1"),
        Keysym::horizlinescan3 => Some("XK_horizlinescan3"),
        Keysym::horizlinescan5 => Some("XK_horizlinescan5"),
        Keysym::horizlinescan7 => Some("XK_horizlinescan7"),
        Keysym::horizlinescan9 => Some("XK_horizlinescan9"),
        Keysym::leftt => Some("XK_leftt"),
        Keysym::rightt => Some("XK_rightt"),
        Keysym::bott => Some("XK_bott"),
        Keysym::topt => Some("XK_topt"),
        Keysym::vertbar => Some("XK_vertbar"),
        Keysym::emspace => Some("XK_emspace"),
        Keysym::enspace => Some("XK_enspace"),
        Keysym::em3space => Some("XK_em3space"),
        Keysym::em4space => Some("XK_em4space"),
        Keysym::digitspace => Some("XK_digitspace"),
        Keysym::punctspace => Some("XK_punctspace"),
        Keysym::thinspace => Some("XK_thinspace"),
        Keysym::hairspace => Some("XK_hairspace"),
        Keysym::emdash => Some("XK_emdash"),
        Keysym::endash => Some("XK_endash"),
        Keysym::signifblank => Some("XK_signifblank"),
        Keysym::ellipsis => Some("XK_ellipsis"),
        Keysym::doubbaselinedot => Some("XK_doubbaselinedot"),
        Keysym::onethird => Some("XK_onethird"),
        Keysym::twothirds => Some("XK_twothirds"),
        Keysym::onefifth => Some("XK_onefifth"),
        Keysym::twofifths => Some("XK_twofifths"),
        Keysym::threefifths => Some("XK_threefifths"),
        Keysym::fourfifths => Some("XK_fourfifths"),
        Keysym::onesixth => Some("XK_onesixth"),
        Keysym::fivesixths => Some("XK_fivesixths"),
        Keysym::careof => Some("XK_careof"),
        Keysym::figdash => Some("XK_figdash"),
        Keysym::leftanglebracket => Some("XK_leftanglebracket"),
        Keysym::decimalpoint => Some("XK_decimalpoint"),
        Keysym::rightanglebracket => Some("XK_rightanglebracket"),
        Keysym::marker => Some("XK_marker"),
        Keysym::oneeighth => Some("XK_oneeighth"),
        Keysym::threeeighths => Some("XK_threeeighths"),
        Keysym::fiveeighths => Some("XK_fiveeighths"),
        Keysym::seveneighths => Some("XK_seveneighths"),
        Keysym::trademark => Some("XK_trademark"),
        Keysym::signaturemark => Some("XK_signaturemark"),
        Keysym::trademarkincircle => Some("XK_trademarkincircle"),
        Keysym::leftopentriangle => Some("XK_leftopentriangle"),
        Keysym::rightopentriangle => Some("XK_rightopentriangle"),
        Keysym::emopencircle => Some("XK_emopencircle"),
        Keysym::emopenrectangle => Some("XK_emopenrectangle"),
        Keysym::leftsinglequotemark => Some("XK_leftsinglequotemark"),
        Keysym::rightsinglequotemark => Some("XK_rightsinglequotemark"),
        Keysym::leftdoublequotemark => Some("XK_leftdoublequotemark"),
        Keysym::rightdoublequotemark => Some("XK_rightdoublequotemark"),
        Keysym::prescription => Some("XK_prescription"),
        Keysym::permille => Some("XK_permille"),
        Keysym::minutes => Some("XK_minutes"),
        Keysym::seconds => Some("XK_seconds"),
        Keysym::latincross => Some("XK_latincross"),
        Keysym::hexagram => Some("XK_hexagram"),
        Keysym::filledrectbullet => Some("XK_filledrectbullet"),
        Keysym::filledlefttribullet => Some("XK_filledlefttribullet"),
        Keysym::filledrighttribullet => Some("XK_filledrighttribullet"),
        Keysym::emfilledcircle => Some("XK_emfilledcircle"),
        Keysym::emfilledrect => Some("XK_emfilledrect"),
        Keysym::enopencircbullet => Some("XK_enopencircbullet"),
        Keysym::enopensquarebullet => Some("XK_enopensquarebullet"),
        Keysym::openrectbullet => Some("XK_openrectbullet"),
        Keysym::opentribulletup => Some("XK_opentribulletup"),
        Keysym::opentribulletdown => Some("XK_opentribulletdown"),
        Keysym::openstar => Some("XK_openstar"),
        Keysym::enfilledcircbullet => Some("XK_enfilledcircbullet"),
        Keysym::enfilledsqbullet => Some("XK_enfilledsqbullet"),
        Keysym::filledtribulletup => Some("XK_filledtribulletup"),
        Keysym::filledtribulletdown => Some("XK_filledtribulletdown"),
        Keysym::leftpointer => Some("XK_leftpointer"),
        Keysym::rightpointer => Some("XK_rightpointer"),
        Keysym::club => Some("XK_club"),
        Keysym::diamond => Some("XK_diamond"),
        Keysym::heart => Some("XK_heart"),
        Keysym::maltesecross => Some("XK_maltesecross"),
        Keysym::dagger => Some("XK_dagger"),
        Keysym::doubledagger => Some("XK_doubledagger"),
        Keysym::checkmark => Some("XK_checkmark"),
        Keysym::ballotcross => Some("XK_ballotcross"),
        Keysym::musicalsharp => Some("XK_musicalsharp"),
        Keysym::musicalflat => Some("XK_musicalflat"),
        Keysym::malesymbol => Some("XK_malesymbol"),
        Keysym::femalesymbol => Some("XK_femalesymbol"),
        Keysym::telephone => Some("XK_telephone"),
        Keysym::telephonerecorder => Some("XK_telephonerecorder"),
        Keysym::phonographcopyright => Some("XK_phonographcopyright"),
        Keysym::caret => Some("XK_caret"),
        Keysym::singlelowquotemark => Some("XK_singlelowquotemark"),
        Keysym::doublelowquotemark => Some("XK_doublelowquotemark"),
        Keysym::cursor => Some("XK_cursor"),
        Keysym::leftcaret => Some("XK_leftcaret"),
        Keysym::rightcaret => Some("XK_rightcaret"),
        Keysym::downcaret => Some("XK_downcaret"),
        Keysym::upcaret => Some("XK_upcaret"),
        Keysym::overbar => Some("XK_overbar"),
        Keysym::downtack => Some("XK_downtack"),
        Keysym::upshoe => Some("XK_upshoe"),
        Keysym::downstile => Some("XK_downstile"),
        Keysym::underbar => Some("XK_underbar"),
        Keysym::jot => Some("XK_jot"),
        Keysym::quad => Some("XK_quad"),
        Keysym::uptack => Some("XK_uptack"),
        Keysym::circle => Some("XK_circle"),
        Keysym::upstile => Some("XK_upstile"),
        Keysym::downshoe => Some("XK_downshoe"),
        Keysym::rightshoe => Some("XK_rightshoe"),
        Keysym::leftshoe => Some("XK_leftshoe"),
        Keysym::lefttack => Some("XK_lefttack"),
        Keysym::righttack => Some("XK_righttack"),
        Keysym::hebrew_doublelowline => Some("XK_hebrew_doublelowline"),
        Keysym::hebrew_aleph => Some("XK_hebrew_aleph"),
        Keysym::hebrew_bet => Some("XK_hebrew_bet"),
        Keysym::hebrew_beth => Some("XK_hebrew_beth"),
        Keysym::hebrew_gimel => Some("XK_hebrew_gimel"),
        Keysym::hebrew_gimmel => Some("XK_hebrew_gimmel"),
        Keysym::hebrew_dalet => Some("XK_hebrew_dalet"),
        Keysym::hebrew_daleth => Some("XK_hebrew_daleth"),
        Keysym::hebrew_he => Some("XK_hebrew_he"),
        Keysym::hebrew_waw => Some("XK_hebrew_waw"),
        Keysym::hebrew_zain => Some("XK_hebrew_zain"),
        Keysym::hebrew_zayin => Some("XK_hebrew_zayin"),
        Keysym::hebrew_chet => Some("XK_hebrew_chet"),
        Keysym::hebrew_het => Some("XK_hebrew_het"),
        Keysym::hebrew_tet => Some("XK_hebrew_tet"),
        Keysym::hebrew_teth => Some("XK_hebrew_teth"),
        Keysym::hebrew_yod => Some("XK_hebrew_yod"),
        Keysym::hebrew_finalkaph => Some("XK_hebrew_finalkaph"),
        Keysym::hebrew_kaph => Some("XK_hebrew_kaph"),
        Keysym::hebrew_lamed => Some("XK_hebrew_lamed"),
        Keysym::hebrew_finalmem => Some("XK_hebrew_finalmem"),
        Keysym::hebrew_mem => Some("XK_hebrew_mem"),
        Keysym::hebrew_finalnun => Some("XK_hebrew_finalnun"),
        Keysym::hebrew_nun => Some("XK_hebrew_nun"),
        Keysym::hebrew_samech => Some("XK_hebrew_samech"),
        Keysym::hebrew_samekh => Some("XK_hebrew_samekh"),
        Keysym::hebrew_ayin => Some("XK_hebrew_ayin"),
        Keysym::hebrew_finalpe => Some("XK_hebrew_finalpe"),
        Keysym::hebrew_pe => Some("XK_hebrew_pe"),
        Keysym::hebrew_finalzade => Some("XK_hebrew_finalzade"),
        Keysym::hebrew_finalzadi => Some("XK_hebrew_finalzadi"),
        Keysym::hebrew_zade => Some("XK_hebrew_zade"),
        Keysym::hebrew_zadi => Some("XK_hebrew_zadi"),
        Keysym::hebrew_qoph => Some("XK_hebrew_qoph"),
        Keysym::hebrew_kuf => Some("XK_hebrew_kuf"),
        Keysym::hebrew_resh => Some("XK_hebrew_resh"),
        Keysym::hebrew_shin => Some("XK_hebrew_shin"),
        Keysym::hebrew_taw => Some("XK_hebrew_taw"),
        Keysym::hebrew_taf => Some("XK_hebrew_taf"),
        Keysym::Hebrew_switch => Some("XK_Hebrew_switch"),
        Keysym::Thai_kokai => Some("XK_Thai_kokai"),
        Keysym::Thai_khokhai => Some("XK_Thai_khokhai"),
        Keysym::Thai_khokhuat => Some("XK_Thai_khokhuat"),
        Keysym::Thai_khokhwai => Some("XK_Thai_khokhwai"),
        Keysym::Thai_khokhon => Some("XK_Thai_khokhon"),
        Keysym::Thai_khorakhang => Some("XK_Thai_khorakhang"),
        Keysym::Thai_ngongu => Some("XK_Thai_ngongu"),
        Keysym::Thai_chochan => Some("XK_Thai_chochan"),
        Keysym::Thai_choching => Some("XK_Thai_choching"),
        Keysym::Thai_chochang => Some("XK_Thai_chochang"),
        Keysym::Thai_soso => Some("XK_Thai_soso"),
        Keysym::Thai_chochoe => Some("XK_Thai_chochoe"),
        Keysym::Thai_yoying => Some("XK_Thai_yoying"),
        Keysym::Thai_dochada => Some("XK_Thai_dochada"),
        Keysym::Thai_topatak => Some("XK_Thai_topatak"),
        Keysym::Thai_thothan => Some("XK_Thai_thothan"),
        Keysym::Thai_thonangmontho => Some("XK_Thai_thonangmontho"),
        Keysym::Thai_thophuthao => Some("XK_Thai_thophuthao"),
        Keysym::Thai_nonen => Some("XK_Thai_nonen"),
        Keysym::Thai_dodek => Some("XK_Thai_dodek"),
        Keysym::Thai_totao => Some("XK_Thai_totao"),
        Keysym::Thai_thothung => Some("XK_Thai_thothung"),
        Keysym::Thai_thothahan => Some("XK_Thai_thothahan"),
        Keysym::Thai_thothong => Some("XK_Thai_thothong"),
        Keysym::Thai_nonu => Some("XK_Thai_nonu"),
        Keysym::Thai_bobaimai => Some("XK_Thai_bobaimai"),
        Keysym::Thai_popla => Some("XK_Thai_popla"),
        Keysym::Thai_phophung => Some("XK_Thai_phophung"),
        Keysym::Thai_fofa => Some("XK_Thai_fofa"),
        Keysym::Thai_phophan => Some("XK_Thai_phophan"),
        Keysym::Thai_fofan => Some("XK_Thai_fofan"),
        Keysym::Thai_phosamphao => Some("XK_Thai_phosamphao"),
        Keysym::Thai_moma => Some("XK_Thai_moma"),
        Keysym::Thai_yoyak => Some("XK_Thai_yoyak"),
        Keysym::Thai_rorua => Some("XK_Thai_rorua"),
        Keysym::Thai_ru => Some("XK_Thai_ru"),
        Keysym::Thai_loling => Some("XK_Thai_loling"),
        Keysym::Thai_lu => Some("XK_Thai_lu"),
        Keysym::Thai_wowaen => Some("XK_Thai_wowaen"),
        Keysym::Thai_sosala => Some("XK_Thai_sosala"),
        Keysym::Thai_sorusi => Some("XK_Thai_sorusi"),
        Keysym::Thai_sosua => Some("XK_Thai_sosua"),
        Keysym::Thai_hohip => Some("XK_Thai_hohip"),
        Keysym::Thai_lochula => Some("XK_Thai_lochula"),
        Keysym::Thai_oang => Some("XK_Thai_oang"),
        Keysym::Thai_honokhuk => Some("XK_Thai_honokhuk"),
        Keysym::Thai_paiyannoi => Some("XK_Thai_paiyannoi"),
        Keysym::Thai_saraa => Some("XK_Thai_saraa"),
        Keysym::Thai_maihanakat => Some("XK_Thai_maihanakat"),
        Keysym::Thai_saraaa => Some("XK_Thai_saraaa"),
        Keysym::Thai_saraam => Some("XK_Thai_saraam"),
        Keysym::Thai_sarai => Some("XK_Thai_sarai"),
        Keysym::Thai_saraii => Some("XK_Thai_saraii"),
        Keysym::Thai_saraue => Some("XK_Thai_saraue"),
        Keysym::Thai_sarauee => Some("XK_Thai_sarauee"),
        Keysym::Thai_sarau => Some("XK_Thai_sarau"),
        Keysym::Thai_sarauu => Some("XK_Thai_sarauu"),
        Keysym::Thai_phinthu => Some("XK_Thai_phinthu"),
        Keysym::Thai_maihanakat_maitho => Some("XK_Thai_maihanakat_maitho"),
        Keysym::Thai_baht => Some("XK_Thai_baht"),
        Keysym::Thai_sarae => Some("XK_Thai_sarae"),
        Keysym::Thai_saraae => Some("XK_Thai_saraae"),
        Keysym::Thai_sarao => Some("XK_Thai_sarao"),
        Keysym::Thai_saraaimaimuan => Some("XK_Thai_saraaimaimuan"),
        Keysym::Thai_saraaimaimalai => Some("XK_Thai_saraaimaimalai"),
        Keysym::Thai_lakkhangyao => Some("XK_Thai_lakkhangyao"),
        Keysym::Thai_maiyamok => Some("XK_Thai_maiyamok"),
        Keysym::Thai_maitaikhu => Some("XK_Thai_maitaikhu"),
        Keysym::Thai_maiek => Some("XK_Thai_maiek"),
        Keysym::Thai_maitho => Some("XK_Thai_maitho"),
        Keysym::Thai_maitri => Some("XK_Thai_maitri"),
        Keysym::Thai_maichattawa => Some("XK_Thai_maichattawa"),
        Keysym::Thai_thanthakhat => Some("XK_Thai_thanthakhat"),
        Keysym::Thai_nikhahit => Some("XK_Thai_nikhahit"),
        Keysym::Thai_leksun => Some("XK_Thai_leksun"),
        Keysym::Thai_leknung => Some("XK_Thai_leknung"),
        Keysym::Thai_leksong => Some("XK_Thai_leksong"),
        Keysym::Thai_leksam => Some("XK_Thai_leksam"),
        Keysym::Thai_leksi => Some("XK_Thai_leksi"),
        Keysym::Thai_lekha => Some("XK_Thai_lekha"),
        Keysym::Thai_lekhok => Some("XK_Thai_lekhok"),
        Keysym::Thai_lekchet => Some("XK_Thai_lekchet"),
        Keysym::Thai_lekpaet => Some("XK_Thai_lekpaet"),
        Keysym::Thai_lekkao => Some("XK_Thai_lekkao"),
        Keysym::Hangul => Some("XK_Hangul"),
        Keysym::Hangul_Start => Some("XK_Hangul_Start"),
        Keysym::Hangul_End => Some("XK_Hangul_End"),
        Keysym::Hangul_Hanja => Some("XK_Hangul_Hanja"),
        Keysym::Hangul_Jamo => Some("XK_Hangul_Jamo"),
        Keysym::Hangul_Romaja => Some("XK_Hangul_Romaja"),
        Keysym::Hangul_Codeinput => Some("XK_Hangul_Codeinput"),
        Keysym::Hangul_Jeonja => Some("XK_Hangul_Jeonja"),
        Keysym::Hangul_Banja => Some("XK_Hangul_Banja"),
        Keysym::Hangul_PreHanja => Some("XK_Hangul_PreHanja"),
        Keysym::Hangul_PostHanja => Some("XK_Hangul_PostHanja"),
        Keysym::Hangul_SingleCandidate => Some("XK_Hangul_SingleCandidate"),
        Keysym::Hangul_MultipleCandidate => Some("XK_Hangul_MultipleCandidate"),
        Keysym::Hangul_PreviousCandidate => Some("XK_Hangul_PreviousCandidate"),
        Keysym::Hangul_Special => Some("XK_Hangul_Special"),
        Keysym::Hangul_switch => Some("XK_Hangul_switch"),
        Keysym::Hangul_Kiyeog => Some("XK_Hangul_Kiyeog"),
        Keysym::Hangul_SsangKiyeog => Some("XK_Hangul_SsangKiyeog"),
        Keysym::Hangul_KiyeogSios => Some("XK_Hangul_KiyeogSios"),
        Keysym::Hangul_Nieun => Some("XK_Hangul_Nieun"),
        Keysym::Hangul_NieunJieuj => Some("XK_Hangul_NieunJieuj"),
        Keysym::Hangul_NieunHieuh => Some("XK_Hangul_NieunHieuh"),
        Keysym::Hangul_Dikeud => Some("XK_Hangul_Dikeud"),
        Keysym::Hangul_SsangDikeud => Some("XK_Hangul_SsangDikeud"),
        Keysym::Hangul_Rieul => Some("XK_Hangul_Rieul"),
        Keysym::Hangul_RieulKiyeog => Some("XK_Hangul_RieulKiyeog"),
        Keysym::Hangul_RieulMieum => Some("XK_Hangul_RieulMieum"),
        Keysym::Hangul_RieulPieub => Some("XK_Hangul_RieulPieub"),
        Keysym::Hangul_RieulSios => Some("XK_Hangul_RieulSios"),
        Keysym::Hangul_RieulTieut => Some("XK_Hangul_RieulTieut"),
        Keysym::Hangul_RieulPhieuf => Some("XK_Hangul_RieulPhieuf"),
        Keysym::Hangul_RieulHieuh => Some("XK_Hangul_RieulHieuh"),
        Keysym::Hangul_Mieum => Some("XK_Hangul_Mieum"),
        Keysym::Hangul_Pieub => Some("XK_Hangul_Pieub"),
        Keysym::Hangul_SsangPieub => Some("XK_Hangul_SsangPieub"),
        Keysym::Hangul_PieubSios => Some("XK_Hangul_PieubSios"),
        Keysym::Hangul_Sios => Some("XK_Hangul_Sios"),
        Keysym::Hangul_SsangSios => Some("XK_Hangul_SsangSios"),
        Keysym::Hangul_Ieung => Some("XK_Hangul_Ieung"),
        Keysym::Hangul_Jieuj => Some("XK_Hangul_Jieuj"),
        Keysym::Hangul_SsangJieuj => Some("XK_Hangul_SsangJieuj"),
        Keysym::Hangul_Cieuc => Some("XK_Hangul_Cieuc"),
        Keysym::Hangul_Khieuq => Some("XK_Hangul_Khieuq"),
        Keysym::Hangul_Tieut => Some("XK_Hangul_Tieut"),
        Keysym::Hangul_Phieuf => Some("XK_Hangul_Phieuf"),
        Keysym::Hangul_Hieuh => Some("XK_Hangul_Hieuh"),
        Keysym::Hangul_A => Some("XK_Hangul_A"),
        Keysym::Hangul_AE => Some("XK_Hangul_AE"),
        Keysym::Hangul_YA => Some("XK_Hangul_YA"),
        Keysym::Hangul_YAE => Some("XK_Hangul_YAE"),
        Keysym::Hangul_EO => Some("XK_Hangul_EO"),
        Keysym::Hangul_E => Some("XK_Hangul_E"),
        Keysym::Hangul_YEO => Some("XK_Hangul_YEO"),
        Keysym::Hangul_YE => Some("XK_Hangul_YE"),
        Keysym::Hangul_O => Some("XK_Hangul_O"),
        Keysym::Hangul_WA => Some("XK_Hangul_WA"),
        Keysym::Hangul_WAE => Some("XK_Hangul_WAE"),
        Keysym::Hangul_OE => Some("XK_Hangul_OE"),
        Keysym::Hangul_YO => Some("XK_Hangul_YO"),
        Keysym::Hangul_U => Some("XK_Hangul_U"),
        Keysym::Hangul_WEO => Some("XK_Hangul_WEO"),
        Keysym::Hangul_WE => Some("XK_Hangul_WE"),
        Keysym::Hangul_WI => Some("XK_Hangul_WI"),
        Keysym::Hangul_YU => Some("XK_Hangul_YU"),
        Keysym::Hangul_EU => Some("XK_Hangul_EU"),
        Keysym::Hangul_YI => Some("XK_Hangul_YI"),
        Keysym::Hangul_I => Some("XK_Hangul_I"),
        Keysym::Hangul_J_Kiyeog => Some("XK_Hangul_J_Kiyeog"),
        Keysym::Hangul_J_SsangKiyeog => Some("XK_Hangul_J_SsangKiyeog"),
        Keysym::Hangul_J_KiyeogSios => Some("XK_Hangul_J_KiyeogSios"),
        Keysym::Hangul_J_Nieun => Some("XK_Hangul_J_Nieun"),
        Keysym::Hangul_J_NieunJieuj => Some("XK_Hangul_J_NieunJieuj"),
        Keysym::Hangul_J_NieunHieuh => Some("XK_Hangul_J_NieunHieuh"),
        Keysym::Hangul_J_Dikeud => Some("XK_Hangul_J_Dikeud"),
        Keysym::Hangul_J_Rieul => Some("XK_Hangul_J_Rieul"),
        Keysym::Hangul_J_RieulKiyeog => Some("XK_Hangul_J_RieulKiyeog"),
        Keysym::Hangul_J_RieulMieum => Some("XK_Hangul_J_RieulMieum"),
        Keysym::Hangul_J_RieulPieub => Some("XK_Hangul_J_RieulPieub"),
        Keysym::Hangul_J_RieulSios => Some("XK_Hangul_J_RieulSios"),
        Keysym::Hangul_J_RieulTieut => Some("XK_Hangul_J_RieulTieut"),
        Keysym::Hangul_J_RieulPhieuf => Some("XK_Hangul_J_RieulPhieuf"),
        Keysym::Hangul_J_RieulHieuh => Some("XK_Hangul_J_RieulHieuh"),
        Keysym::Hangul_J_Mieum => Some("XK_Hangul_J_Mieum"),
        Keysym::Hangul_J_Pieub => Some("XK_Hangul_J_Pieub"),
        Keysym::Hangul_J_PieubSios => Some("XK_Hangul_J_PieubSios"),
        Keysym::Hangul_J_Sios => Some("XK_Hangul_J_Sios"),
        Keysym::Hangul_J_SsangSios => Some("XK_Hangul_J_SsangSios"),
        Keysym::Hangul_J_Ieung => Some("XK_Hangul_J_Ieung"),
        Keysym::Hangul_J_Jieuj => Some("XK_Hangul_J_Jieuj"),
        Keysym::Hangul_J_Cieuc => Some("XK_Hangul_J_Cieuc"),
        Keysym::Hangul_J_Khieuq => Some("XK_Hangul_J_Khieuq"),
        Keysym::Hangul_J_Tieut => Some("XK_Hangul_J_Tieut"),
        Keysym::Hangul_J_Phieuf => Some("XK_Hangul_J_Phieuf"),
        Keysym::Hangul_J_Hieuh => Some("XK_Hangul_J_Hieuh"),
        Keysym::Hangul_RieulYeorinHieuh => Some("XK_Hangul_RieulYeorinHieuh"),
        Keysym::Hangul_SunkyeongeumMieum => Some("XK_Hangul_SunkyeongeumMieum"),
        Keysym::Hangul_SunkyeongeumPieub => Some("XK_Hangul_SunkyeongeumPieub"),
        Keysym::Hangul_PanSios => Some("XK_Hangul_PanSios"),
        Keysym::Hangul_KkogjiDalrinIeung => Some("XK_Hangul_KkogjiDalrinIeung"),
        Keysym::Hangul_SunkyeongeumPhieuf => Some("XK_Hangul_SunkyeongeumPhieuf"),
        Keysym::Hangul_YeorinHieuh => Some("XK_Hangul_YeorinHieuh"),
        Keysym::Hangul_AraeA => Some("XK_Hangul_AraeA"),
        Keysym::Hangul_AraeAE => Some("XK_Hangul_AraeAE"),
        Keysym::Hangul_J_PanSios => Some("XK_Hangul_J_PanSios"),
        Keysym::Hangul_J_KkogjiDalrinIeung => Some("XK_Hangul_J_KkogjiDalrinIeung"),
        Keysym::Hangul_J_YeorinHieuh => Some("XK_Hangul_J_YeorinHieuh"),
        Keysym::Korean_Won => Some("XK_Korean_Won"),
        Keysym::Armenian_ligature_ew => Some("XK_Armenian_ligature_ew"),
        Keysym::Armenian_full_stop => Some("XK_Armenian_full_stop"),
        Keysym::Armenian_verjaket => Some("XK_Armenian_verjaket"),
        Keysym::Armenian_separation_mark => Some("XK_Armenian_separation_mark"),
        Keysym::Armenian_but => Some("XK_Armenian_but"),
        Keysym::Armenian_hyphen => Some("XK_Armenian_hyphen"),
        Keysym::Armenian_yentamna => Some("XK_Armenian_yentamna"),
        Keysym::Armenian_exclam => Some("XK_Armenian_exclam"),
        Keysym::Armenian_amanak => Some("XK_Armenian_amanak"),
        Keysym::Armenian_accent => Some("XK_Armenian_accent"),
        Keysym::Armenian_shesht => Some("XK_Armenian_shesht"),
        Keysym::Armenian_question => Some("XK_Armenian_question"),
        Keysym::Armenian_paruyk => Some("XK_Armenian_paruyk"),
        Keysym::Armenian_AYB => Some("XK_Armenian_AYB"),
        Keysym::Armenian_ayb => Some("XK_Armenian_ayb"),
        Keysym::Armenian_BEN => Some("XK_Armenian_BEN"),
        Keysym::Armenian_ben => Some("XK_Armenian_ben"),
        Keysym::Armenian_GIM => Some("XK_Armenian_GIM"),
        Keysym::Armenian_gim => Some("XK_Armenian_gim"),
        Keysym::Armenian_DA => Some("XK_Armenian_DA"),
        Keysym::Armenian_da => Some("XK_Armenian_da"),
        Keysym::Armenian_YECH => Some("XK_Armenian_YECH"),
        Keysym::Armenian_yech => Some("XK_Armenian_yech"),
        Keysym::Armenian_ZA => Some("XK_Armenian_ZA"),
        Keysym::Armenian_za => Some("XK_Armenian_za"),
        Keysym::Armenian_E => Some("XK_Armenian_E"),
        Keysym::Armenian_e => Some("XK_Armenian_e"),
        Keysym::Armenian_AT => Some("XK_Armenian_AT"),
        Keysym::Armenian_at => Some("XK_Armenian_at"),
        Keysym::Armenian_TO => Some("XK_Armenian_TO"),
        Keysym::Armenian_to => Some("XK_Armenian_to"),
        Keysym::Armenian_ZHE => Some("XK_Armenian_ZHE"),
        Keysym::Armenian_zhe => Some("XK_Armenian_zhe"),
        Keysym::Armenian_INI => Some("XK_Armenian_INI"),
        Keysym::Armenian_ini => Some("XK_Armenian_ini"),
        Keysym::Armenian_LYUN => Some("XK_Armenian_LYUN"),
        Keysym::Armenian_lyun => Some("XK_Armenian_lyun"),
        Keysym::Armenian_KHE => Some("XK_Armenian_KHE"),
        Keysym::Armenian_khe => Some("XK_Armenian_khe"),
        Keysym::Armenian_TSA => Some("XK_Armenian_TSA"),
        Keysym::Armenian_tsa => Some("XK_Armenian_tsa"),
        Keysym::Armenian_KEN => Some("XK_Armenian_KEN"),
        Keysym::Armenian_ken => Some("XK_Armenian_ken"),
        Keysym::Armenian_HO => Some("XK_Armenian_HO"),
        Keysym::Armenian_ho => Some("XK_Armenian_ho"),
        Keysym::Armenian_DZA => Some("XK_Armenian_DZA"),
        Keysym::Armenian_dza => Some("XK_Armenian_dza"),
        Keysym::Armenian_GHAT => Some("XK_Armenian_GHAT"),
        Keysym::Armenian_ghat => Some("XK_Armenian_ghat"),
        Keysym::Armenian_TCHE => Some("XK_Armenian_TCHE"),
        Keysym::Armenian_tche => Some("XK_Armenian_tche"),
        Keysym::Armenian_MEN => Some("XK_Armenian_MEN"),
        Keysym::Armenian_men => Some("XK_Armenian_men"),
        Keysym::Armenian_HI => Some("XK_Armenian_HI"),
        Keysym::Armenian_hi => Some("XK_Armenian_hi"),
        Keysym::Armenian_NU => Some("XK_Armenian_NU"),
        Keysym::Armenian_nu => Some("XK_Armenian_nu"),
        Keysym::Armenian_SHA => Some("XK_Armenian_SHA"),
        Keysym::Armenian_sha => Some("XK_Armenian_sha"),
        Keysym::Armenian_VO => Some("XK_Armenian_VO"),
        Keysym::Armenian_vo => Some("XK_Armenian_vo"),
        Keysym::Armenian_CHA => Some("XK_Armenian_CHA"),
        Keysym::Armenian_cha => Some("XK_Armenian_cha"),
        Keysym::Armenian_PE => Some("XK_Armenian_PE"),
        Keysym::Armenian_pe => Some("XK_Armenian_pe"),
        Keysym::Armenian_JE => Some("XK_Armenian_JE"),
        Keysym::Armenian_je => Some("XK_Armenian_je"),
        Keysym::Armenian_RA => Some("XK_Armenian_RA"),
        Keysym::Armenian_ra => Some("XK_Armenian_ra"),
        Keysym::Armenian_SE => Some("XK_Armenian_SE"),
        Keysym::Armenian_se => Some("XK_Armenian_se"),
        Keysym::Armenian_VEV => Some("XK_Armenian_VEV"),
        Keysym::Armenian_vev => Some("XK_Armenian_vev"),
        Keysym::Armenian_TYUN => Some("XK_Armenian_TYUN"),
        Keysym::Armenian_tyun => Some("XK_Armenian_tyun"),
        Keysym::Armenian_RE => Some("XK_Armenian_RE"),
        Keysym::Armenian_re => Some("XK_Armenian_re"),
        Keysym::Armenian_TSO => Some("XK_Armenian_TSO"),
        Keysym::Armenian_tso => Some("XK_Armenian_tso"),
        Keysym::Armenian_VYUN => Some("XK_Armenian_VYUN"),
        Keysym::Armenian_vyun => Some("XK_Armenian_vyun"),
        Keysym::Armenian_PYUR => Some("XK_Armenian_PYUR"),
        Keysym::Armenian_pyur => Some("XK_Armenian_pyur"),
        Keysym::Armenian_KE => Some("XK_Armenian_KE"),
        Keysym::Armenian_ke => Some("XK_Armenian_ke"),
        Keysym::Armenian_O => Some("XK_Armenian_O"),
        Keysym::Armenian_o => Some("XK_Armenian_o"),
        Keysym::Armenian_FE => Some("XK_Armenian_FE"),
        Keysym::Armenian_fe => Some("XK_Armenian_fe"),
        Keysym::Armenian_apostrophe => Some("XK_Armenian_apostrophe"),
        Keysym::Georgian_an => Some("XK_Georgian_an"),
        Keysym::Georgian_ban => Some("XK_Georgian_ban"),
        Keysym::Georgian_gan => Some("XK_Georgian_gan"),
        Keysym::Georgian_don => Some("XK_Georgian_don"),
        Keysym::Georgian_en => Some("XK_Georgian_en"),
        Keysym::Georgian_vin => Some("XK_Georgian_vin"),
        Keysym::Georgian_zen => Some("XK_Georgian_zen"),
        Keysym::Georgian_tan => Some("XK_Georgian_tan"),
        Keysym::Georgian_in => Some("XK_Georgian_in"),
        Keysym::Georgian_kan => Some("XK_Georgian_kan"),
        Keysym::Georgian_las => Some("XK_Georgian_las"),
        Keysym::Georgian_man => Some("XK_Georgian_man"),
        Keysym::Georgian_nar => Some("XK_Georgian_nar"),
        Keysym::Georgian_on => Some("XK_Georgian_on"),
        Keysym::Georgian_par => Some("XK_Georgian_par"),
        Keysym::Georgian_zhar => Some("XK_Georgian_zhar"),
        Keysym::Georgian_rae => Some("XK_Georgian_rae"),
        Keysym::Georgian_san => Some("XK_Georgian_san"),
        Keysym::Georgian_tar => Some("XK_Georgian_tar"),
        Keysym::Georgian_un => Some("XK_Georgian_un"),
        Keysym::Georgian_phar => Some("XK_Georgian_phar"),
        Keysym::Georgian_khar => Some("XK_Georgian_khar"),
        Keysym::Georgian_ghan => Some("XK_Georgian_ghan"),
        Keysym::Georgian_qar => Some("XK_Georgian_qar"),
        Keysym::Georgian_shin => Some("XK_Georgian_shin"),
        Keysym::Georgian_chin => Some("XK_Georgian_chin"),
        Keysym::Georgian_can => Some("XK_Georgian_can"),
        Keysym::Georgian_jil => Some("XK_Georgian_jil"),
        Keysym::Georgian_cil => Some("XK_Georgian_cil"),
        Keysym::Georgian_char => Some("XK_Georgian_char"),
        Keysym::Georgian_xan => Some("XK_Georgian_xan"),
        Keysym::Georgian_jhan => Some("XK_Georgian_jhan"),
        Keysym::Georgian_hae => Some("XK_Georgian_hae"),
        Keysym::Georgian_he => Some("XK_Georgian_he"),
        Keysym::Georgian_hie => Some("XK_Georgian_hie"),
        Keysym::Georgian_we => Some("XK_Georgian_we"),
        Keysym::Georgian_har => Some("XK_Georgian_har"),
        Keysym::Georgian_hoe => Some("XK_Georgian_hoe"),
        Keysym::Georgian_fi => Some("XK_Georgian_fi"),
        Keysym::Xabovedot => Some("XK_Xabovedot"),
        Keysym::Ibreve => Some("XK_Ibreve"),
        Keysym::Zstroke => Some("XK_Zstroke"),
        Keysym::Gcaron => Some("XK_Gcaron"),
        Keysym::Ocaron => Some("XK_Ocaron"),
        Keysym::Obarred => Some("XK_Obarred"),
        Keysym::xabovedot => Some("XK_xabovedot"),
        Keysym::ibreve => Some("XK_ibreve"),
        Keysym::zstroke => Some("XK_zstroke"),
        Keysym::gcaron => Some("XK_gcaron"),
        Keysym::ocaron => Some("XK_ocaron"),
        Keysym::obarred => Some("XK_obarred"),
        Keysym::SCHWA => Some("XK_SCHWA"),
        Keysym::schwa => Some("XK_schwa"),
        Keysym::EZH => Some("XK_EZH"),
        Keysym::ezh => Some("XK_ezh"),
        Keysym::Lbelowdot => Some("XK_Lbelowdot"),
        Keysym::lbelowdot => Some("XK_lbelowdot"),
        Keysym::Abelowdot => Some("XK_Abelowdot"),
        Keysym::abelowdot => Some("XK_abelowdot"),
        Keysym::Ahook => Some("XK_Ahook"),
        Keysym::ahook => Some("XK_ahook"),
        Keysym::Acircumflexacute => Some("XK_Acircumflexacute"),
        Keysym::acircumflexacute => Some("XK_acircumflexacute"),
        Keysym::Acircumflexgrave => Some("XK_Acircumflexgrave"),
        Keysym::acircumflexgrave => Some("XK_acircumflexgrave"),
        Keysym::Acircumflexhook => Some("XK_Acircumflexhook"),
        Keysym::acircumflexhook => Some("XK_acircumflexhook"),
        Keysym::Acircumflextilde => Some("XK_Acircumflextilde"),
        Keysym::acircumflextilde => Some("XK_acircumflextilde"),
        Keysym::Acircumflexbelowdot => Some("XK_Acircumflexbelowdot"),
        Keysym::acircumflexbelowdot => Some("XK_acircumflexbelowdot"),
        Keysym::Abreveacute => Some("XK_Abreveacute"),
        Keysym::abreveacute => Some("XK_abreveacute"),
        Keysym::Abrevegrave => Some("XK_Abrevegrave"),
        Keysym::abrevegrave => Some("XK_abrevegrave"),
        Keysym::Abrevehook => Some("XK_Abrevehook"),
        Keysym::abrevehook => Some("XK_abrevehook"),
        Keysym::Abrevetilde => Some("XK_Abrevetilde"),
        Keysym::abrevetilde => Some("XK_abrevetilde"),
        Keysym::Abrevebelowdot => Some("XK_Abrevebelowdot"),
        Keysym::abrevebelowdot => Some("XK_abrevebelowdot"),
        Keysym::Ebelowdot => Some("XK_Ebelowdot"),
        Keysym::ebelowdot => Some("XK_ebelowdot"),
        Keysym::Ehook => Some("XK_Ehook"),
        Keysym::ehook => Some("XK_ehook"),
        Keysym::Etilde => Some("XK_Etilde"),
        Keysym::etilde => Some("XK_etilde"),
        Keysym::Ecircumflexacute => Some("XK_Ecircumflexacute"),
        Keysym::ecircumflexacute => Some("XK_ecircumflexacute"),
        Keysym::Ecircumflexgrave => Some("XK_Ecircumflexgrave"),
        Keysym::ecircumflexgrave => Some("XK_ecircumflexgrave"),
        Keysym::Ecircumflexhook => Some("XK_Ecircumflexhook"),
        Keysym::ecircumflexhook => Some("XK_ecircumflexhook"),
        Keysym::Ecircumflextilde => Some("XK_Ecircumflextilde"),
        Keysym::ecircumflextilde => Some("XK_ecircumflextilde"),
        Keysym::Ecircumflexbelowdot => Some("XK_Ecircumflexbelowdot"),
        Keysym::ecircumflexbelowdot => Some("XK_ecircumflexbelowdot"),
        Keysym::Ihook => Some("XK_Ihook"),
        Keysym::ihook => Some("XK_ihook"),
        Keysym::Ibelowdot => Some("XK_Ibelowdot"),
        Keysym::ibelowdot => Some("XK_ibelowdot"),
        Keysym::Obelowdot => Some("XK_Obelowdot"),
        Keysym::obelowdot => Some("XK_obelowdot"),
        Keysym::Ohook => Some("XK_Ohook"),
        Keysym::ohook => Some("XK_ohook"),
        Keysym::Ocircumflexacute => Some("XK_Ocircumflexacute"),
        Keysym::ocircumflexacute => Some("XK_ocircumflexacute"),
        Keysym::Ocircumflexgrave => Some("XK_Ocircumflexgrave"),
        Keysym::ocircumflexgrave => Some("XK_ocircumflexgrave"),
        Keysym::Ocircumflexhook => Some("XK_Ocircumflexhook"),
        Keysym::ocircumflexhook => Some("XK_ocircumflexhook"),
        Keysym::Ocircumflextilde => Some("XK_Ocircumflextilde"),
        Keysym::ocircumflextilde => Some("XK_ocircumflextilde"),
        Keysym::Ocircumflexbelowdot => Some("XK_Ocircumflexbelowdot"),
        Keysym::ocircumflexbelowdot => Some("XK_ocircumflexbelowdot"),
        Keysym::Ohornacute => Some("XK_Ohornacute"),
        Keysym::ohornacute => Some("XK_ohornacute"),
        Keysym::Ohorngrave => Some("XK_Ohorngrave"),
        Keysym::ohorngrave => Some("XK_ohorngrave"),
        Keysym::Ohornhook => Some("XK_Ohornhook"),
        Keysym::ohornhook => Some("XK_ohornhook"),
        Keysym::Ohorntilde => Some("XK_Ohorntilde"),
        Keysym::ohorntilde => Some("XK_ohorntilde"),
        Keysym::Ohornbelowdot => Some("XK_Ohornbelowdot"),
        Keysym::ohornbelowdot => Some("XK_ohornbelowdot"),
        Keysym::Ubelowdot => Some("XK_Ubelowdot"),
        Keysym::ubelowdot => Some("XK_ubelowdot"),
        Keysym::Uhook => Some("XK_Uhook"),
        Keysym::uhook => Some("XK_uhook"),
        Keysym::Uhornacute => Some("XK_Uhornacute"),
        Keysym::uhornacute => Some("XK_uhornacute"),
        Keysym::Uhorngrave => Some("XK_Uhorngrave"),
        Keysym::uhorngrave => Some("XK_uhorngrave"),
        Keysym::Uhornhook => Some("XK_Uhornhook"),
        Keysym::uhornhook => Some("XK_uhornhook"),
        Keysym::Uhorntilde => Some("XK_Uhorntilde"),
        Keysym::uhorntilde => Some("XK_uhorntilde"),
        Keysym::Uhornbelowdot => Some("XK_Uhornbelowdot"),
        Keysym::uhornbelowdot => Some("XK_uhornbelowdot"),
        Keysym::Ybelowdot => Some("XK_Ybelowdot"),
        Keysym::ybelowdot => Some("XK_ybelowdot"),
        Keysym::Yhook => Some("XK_Yhook"),
        Keysym::yhook => Some("XK_yhook"),
        Keysym::Ytilde => Some("XK_Ytilde"),
        Keysym::ytilde => Some("XK_ytilde"),
        Keysym::Ohorn => Some("XK_Ohorn"),
        Keysym::ohorn => Some("XK_ohorn"),
        Keysym::Uhorn => Some("XK_Uhorn"),
        Keysym::uhorn => Some("XK_uhorn"),
        Keysym::combining_tilde => Some("XK_combining_tilde"),
        Keysym::combining_grave => Some("XK_combining_grave"),
        Keysym::combining_acute => Some("XK_combining_acute"),
        Keysym::combining_hook => Some("XK_combining_hook"),
        Keysym::combining_belowdot => Some("XK_combining_belowdot"),
        Keysym::EcuSign => Some("XK_EcuSign"),
        Keysym::ColonSign => Some("XK_ColonSign"),
        Keysym::CruzeiroSign => Some("XK_CruzeiroSign"),
        Keysym::FFrancSign => Some("XK_FFrancSign"),
        Keysym::LiraSign => Some("XK_LiraSign"),
        Keysym::MillSign => Some("XK_MillSign"),
        Keysym::NairaSign => Some("XK_NairaSign"),
        Keysym::PesetaSign => Some("XK_PesetaSign"),
        Keysym::RupeeSign => Some("XK_RupeeSign"),
        Keysym::WonSign => Some("XK_WonSign"),
        Keysym::NewSheqelSign => Some("XK_NewSheqelSign"),
        Keysym::DongSign => Some("XK_DongSign"),
        Keysym::EuroSign => Some("XK_EuroSign"),
        Keysym::zerosuperior => Some("XK_zerosuperior"),
        Keysym::foursuperior => Some("XK_foursuperior"),
        Keysym::fivesuperior => Some("XK_fivesuperior"),
        Keysym::sixsuperior => Some("XK_sixsuperior"),
        Keysym::sevensuperior => Some("XK_sevensuperior"),
        Keysym::eightsuperior => Some("XK_eightsuperior"),
        Keysym::ninesuperior => Some("XK_ninesuperior"),
        Keysym::zerosubscript => Some("XK_zerosubscript"),
        Keysym::onesubscript => Some("XK_onesubscript"),
        Keysym::twosubscript => Some("XK_twosubscript"),
        Keysym::threesubscript => Some("XK_threesubscript"),
        Keysym::foursubscript => Some("XK_foursubscript"),
        Keysym::fivesubscript => Some("XK_fivesubscript"),
        Keysym::sixsubscript => Some("XK_sixsubscript"),
        Keysym::sevensubscript => Some("XK_sevensubscript"),
        Keysym::eightsubscript => Some("XK_eightsubscript"),
        Keysym::ninesubscript => Some("XK_ninesubscript"),
        Keysym::partdifferential => Some("XK_partdifferential"),
        Keysym::emptyset => Some("XK_emptyset"),
        Keysym::elementof => Some("XK_elementof"),
        Keysym::notelementof => Some("XK_notelementof"),
        Keysym::containsas => Some("XK_containsas"),
        Keysym::squareroot => Some("XK_squareroot"),
        Keysym::cuberoot => Some("XK_cuberoot"),
        Keysym::fourthroot => Some("XK_fourthroot"),
        Keysym::dintegral => Some("XK_dintegral"),
        Keysym::tintegral => Some("XK_tintegral"),
        Keysym::because => Some("XK_because"),
        Keysym::approxeq => Some("XK_approxeq"),
        Keysym::notapproxeq => Some("XK_notapproxeq"),
        Keysym::notidentical => Some("XK_notidentical"),
        Keysym::stricteq => Some("XK_stricteq"),
        Keysym::braille_dot_1 => Some("XK_braille_dot_1"),
        Keysym::braille_dot_2 => Some("XK_braille_dot_2"),
        Keysym::braille_dot_3 => Some("XK_braille_dot_3"),
        Keysym::braille_dot_4 => Some("XK_braille_dot_4"),
        Keysym::braille_dot_5 => Some("XK_braille_dot_5"),
        Keysym::braille_dot_6 => Some("XK_braille_dot_6"),
        Keysym::braille_dot_7 => Some("XK_braille_dot_7"),
        Keysym::braille_dot_8 => Some("XK_braille_dot_8"),
        Keysym::braille_dot_9 => Some("XK_braille_dot_9"),
        Keysym::braille_dot_10 => Some("XK_braille_dot_10"),
        Keysym::braille_blank => Some("XK_braille_blank"),
        Keysym::braille_dots_1 => Some("XK_braille_dots_1"),
        Keysym::braille_dots_2 => Some("XK_braille_dots_2"),
        Keysym::braille_dots_12 => Some("XK_braille_dots_12"),
        Keysym::braille_dots_3 => Some("XK_braille_dots_3"),
        Keysym::braille_dots_13 => Some("XK_braille_dots_13"),
        Keysym::braille_dots_23 => Some("XK_braille_dots_23"),
        Keysym::braille_dots_123 => Some("XK_braille_dots_123"),
        Keysym::braille_dots_4 => Some("XK_braille_dots_4"),
        Keysym::braille_dots_14 => Some("XK_braille_dots_14"),
        Keysym::braille_dots_24 => Some("XK_braille_dots_24"),
        Keysym::braille_dots_124 => Some("XK_braille_dots_124"),
        Keysym::braille_dots_34 => Some("XK_braille_dots_34"),
        Keysym::braille_dots_134 => Some("XK_braille_dots_134"),
        Keysym::braille_dots_234 => Some("XK_braille_dots_234"),
        Keysym::braille_dots_1234 => Some("XK_braille_dots_1234"),
        Keysym::braille_dots_5 => Some("XK_braille_dots_5"),
        Keysym::braille_dots_15 => Some("XK_braille_dots_15"),
        Keysym::braille_dots_25 => Some("XK_braille_dots_25"),
        Keysym::braille_dots_125 => Some("XK_braille_dots_125"),
        Keysym::braille_dots_35 => Some("XK_braille_dots_35"),
        Keysym::braille_dots_135 => Some("XK_braille_dots_135"),
        Keysym::braille_dots_235 => Some("XK_braille_dots_235"),
        Keysym::braille_dots_1235 => Some("XK_braille_dots_1235"),
        Keysym::braille_dots_45 => Some("XK_braille_dots_45"),
        Keysym::braille_dots_145 => Some("XK_braille_dots_145"),
        Keysym::braille_dots_245 => Some("XK_braille_dots_245"),
        Keysym::braille_dots_1245 => Some("XK_braille_dots_1245"),
        Keysym::braille_dots_345 => Some("XK_braille_dots_345"),
        Keysym::braille_dots_1345 => Some("XK_braille_dots_1345"),
        Keysym::braille_dots_2345 => Some("XK_braille_dots_2345"),
        Keysym::braille_dots_12345 => Some("XK_braille_dots_12345"),
        Keysym::braille_dots_6 => Some("XK_braille_dots_6"),
        Keysym::braille_dots_16 => Some("XK_braille_dots_16"),
        Keysym::braille_dots_26 => Some("XK_braille_dots_26"),
        Keysym::braille_dots_126 => Some("XK_braille_dots_126"),
        Keysym::braille_dots_36 => Some("XK_braille_dots_36"),
        Keysym::braille_dots_136 => Some("XK_braille_dots_136"),
        Keysym::braille_dots_236 => Some("XK_braille_dots_236"),
        Keysym::braille_dots_1236 => Some("XK_braille_dots_1236"),
        Keysym::braille_dots_46 => Some("XK_braille_dots_46"),
        Keysym::braille_dots_146 => Some("XK_braille_dots_146"),
        Keysym::braille_dots_246 => Some("XK_braille_dots_246"),
        Keysym::braille_dots_1246 => Some("XK_braille_dots_1246"),
        Keysym::braille_dots_346 => Some("XK_braille_dots_346"),
        Keysym::braille_dots_1346 => Some("XK_braille_dots_1346"),
        Keysym::braille_dots_2346 => Some("XK_braille_dots_2346"),
        Keysym::braille_dots_12346 => Some("XK_braille_dots_12346"),
        Keysym::braille_dots_56 => Some("XK_braille_dots_56"),
        Keysym::braille_dots_156 => Some("XK_braille_dots_156"),
        Keysym::braille_dots_256 => Some("XK_braille_dots_256"),
        Keysym::braille_dots_1256 => Some("XK_braille_dots_1256"),
        Keysym::braille_dots_356 => Some("XK_braille_dots_356"),
        Keysym::braille_dots_1356 => Some("XK_braille_dots_1356"),
        Keysym::braille_dots_2356 => Some("XK_braille_dots_2356"),
        Keysym::braille_dots_12356 => Some("XK_braille_dots_12356"),
        Keysym::braille_dots_456 => Some("XK_braille_dots_456"),
        Keysym::braille_dots_1456 => Some("XK_braille_dots_1456"),
        Keysym::braille_dots_2456 => Some("XK_braille_dots_2456"),
        Keysym::braille_dots_12456 => Some("XK_braille_dots_12456"),
        Keysym::braille_dots_3456 => Some("XK_braille_dots_3456"),
        Keysym::braille_dots_13456 => Some("XK_braille_dots_13456"),
        Keysym::braille_dots_23456 => Some("XK_braille_dots_23456"),
        Keysym::braille_dots_123456 => Some("XK_braille_dots_123456"),
        Keysym::braille_dots_7 => Some("XK_braille_dots_7"),
        Keysym::braille_dots_17 => Some("XK_braille_dots_17"),
        Keysym::braille_dots_27 => Some("XK_braille_dots_27"),
        Keysym::braille_dots_127 => Some("XK_braille_dots_127"),
        Keysym::braille_dots_37 => Some("XK_braille_dots_37"),
        Keysym::braille_dots_137 => Some("XK_braille_dots_137"),
        Keysym::braille_dots_237 => Some("XK_braille_dots_237"),
        Keysym::braille_dots_1237 => Some("XK_braille_dots_1237"),
        Keysym::braille_dots_47 => Some("XK_braille_dots_47"),
        Keysym::braille_dots_147 => Some("XK_braille_dots_147"),
        Keysym::braille_dots_247 => Some("XK_braille_dots_247"),
        Keysym::braille_dots_1247 => Some("XK_braille_dots_1247"),
        Keysym::braille_dots_347 => Some("XK_braille_dots_347"),
        Keysym::braille_dots_1347 => Some("XK_braille_dots_1347"),
        Keysym::braille_dots_2347 => Some("XK_braille_dots_2347"),
        Keysym::braille_dots_12347 => Some("XK_braille_dots_12347"),
        Keysym::braille_dots_57 => Some("XK_braille_dots_57"),
        Keysym::braille_dots_157 => Some("XK_braille_dots_157"),
        Keysym::braille_dots_257 => Some("XK_braille_dots_257"),
        Keysym::braille_dots_1257 => Some("XK_braille_dots_1257"),
        Keysym::braille_dots_357 => Some("XK_braille_dots_357"),
        Keysym::braille_dots_1357 => Some("XK_braille_dots_1357"),
        Keysym::braille_dots_2357 => Some("XK_braille_dots_2357"),
        Keysym::braille_dots_12357 => Some("XK_braille_dots_12357"),
        Keysym::braille_dots_457 => Some("XK_braille_dots_457"),
        Keysym::braille_dots_1457 => Some("XK_braille_dots_1457"),
        Keysym::braille_dots_2457 => Some("XK_braille_dots_2457"),
        Keysym::braille_dots_12457 => Some("XK_braille_dots_12457"),
        Keysym::braille_dots_3457 => Some("XK_braille_dots_3457"),
        Keysym::braille_dots_13457 => Some("XK_braille_dots_13457"),
        Keysym::braille_dots_23457 => Some("XK_braille_dots_23457"),
        Keysym::braille_dots_123457 => Some("XK_braille_dots_123457"),
        Keysym::braille_dots_67 => Some("XK_braille_dots_67"),
        Keysym::braille_dots_167 => Some("XK_braille_dots_167"),
        Keysym::braille_dots_267 => Some("XK_braille_dots_267"),
        Keysym::braille_dots_1267 => Some("XK_braille_dots_1267"),
        Keysym::braille_dots_367 => Some("XK_braille_dots_367"),
        Keysym::braille_dots_1367 => Some("XK_braille_dots_1367"),
        Keysym::braille_dots_2367 => Some("XK_braille_dots_2367"),
        Keysym::braille_dots_12367 => Some("XK_braille_dots_12367"),
        Keysym::braille_dots_467 => Some("XK_braille_dots_467"),
        Keysym::braille_dots_1467 => Some("XK_braille_dots_1467"),
        Keysym::braille_dots_2467 => Some("XK_braille_dots_2467"),
        Keysym::braille_dots_12467 => Some("XK_braille_dots_12467"),
        Keysym::braille_dots_3467 => Some("XK_braille_dots_3467"),
        Keysym::braille_dots_13467 => Some("XK_braille_dots_13467"),
        Keysym::braille_dots_23467 => Some("XK_braille_dots_23467"),
        Keysym::braille_dots_123467 => Some("XK_braille_dots_123467"),
        Keysym::braille_dots_567 => Some("XK_braille_dots_567"),
        Keysym::braille_dots_1567 => Some("XK_braille_dots_1567"),
        Keysym::braille_dots_2567 => Some("XK_braille_dots_2567"),
        Keysym::braille_dots_12567 => Some("XK_braille_dots_12567"),
        Keysym::braille_dots_3567 => Some("XK_braille_dots_3567"),
        Keysym::braille_dots_13567 => Some("XK_braille_dots_13567"),
        Keysym::braille_dots_23567 => Some("XK_braille_dots_23567"),
        Keysym::braille_dots_123567 => Some("XK_braille_dots_123567"),
        Keysym::braille_dots_4567 => Some("XK_braille_dots_4567"),
        Keysym::braille_dots_14567 => Some("XK_braille_dots_14567"),
        Keysym::braille_dots_24567 => Some("XK_braille_dots_24567"),
        Keysym::braille_dots_124567 => Some("XK_braille_dots_124567"),
        Keysym::braille_dots_34567 => Some("XK_braille_dots_34567"),
        Keysym::braille_dots_134567 => Some("XK_braille_dots_134567"),
        Keysym::braille_dots_234567 => Some("XK_braille_dots_234567"),
        Keysym::braille_dots_1234567 => Some("XK_braille_dots_1234567"),
        Keysym::braille_dots_8 => Some("XK_braille_dots_8"),
        Keysym::braille_dots_18 => Some("XK_braille_dots_18"),
        Keysym::braille_dots_28 => Some("XK_braille_dots_28"),
        Keysym::braille_dots_128 => Some("XK_braille_dots_128"),
        Keysym::braille_dots_38 => Some("XK_braille_dots_38"),
        Keysym::braille_dots_138 => Some("XK_braille_dots_138"),
        Keysym::braille_dots_238 => Some("XK_braille_dots_238"),
        Keysym::braille_dots_1238 => Some("XK_braille_dots_1238"),
        Keysym::braille_dots_48 => Some("XK_braille_dots_48"),
        Keysym::braille_dots_148 => Some("XK_braille_dots_148"),
        Keysym::braille_dots_248 => Some("XK_braille_dots_248"),
        Keysym::braille_dots_1248 => Some("XK_braille_dots_1248"),
        Keysym::braille_dots_348 => Some("XK_braille_dots_348"),
        Keysym::braille_dots_1348 => Some("XK_braille_dots_1348"),
        Keysym::braille_dots_2348 => Some("XK_braille_dots_2348"),
        Keysym::braille_dots_12348 => Some("XK_braille_dots_12348"),
        Keysym::braille_dots_58 => Some("XK_braille_dots_58"),
        Keysym::braille_dots_158 => Some("XK_braille_dots_158"),
        Keysym::braille_dots_258 => Some("XK_braille_dots_258"),
        Keysym::braille_dots_1258 => Some("XK_braille_dots_1258"),
        Keysym::braille_dots_358 => Some("XK_braille_dots_358"),
        Keysym::braille_dots_1358 => Some("XK_braille_dots_1358"),
        Keysym::braille_dots_2358 => Some("XK_braille_dots_2358"),
        Keysym::braille_dots_12358 => Some("XK_braille_dots_12358"),
        Keysym::braille_dots_458 => Some("XK_braille_dots_458"),
        Keysym::braille_dots_1458 => Some("XK_braille_dots_1458"),
        Keysym::braille_dots_2458 => Some("XK_braille_dots_2458"),
        Keysym::braille_dots_12458 => Some("XK_braille_dots_12458"),
        Keysym::braille_dots_3458 => Some("XK_braille_dots_3458"),
        Keysym::braille_dots_13458 => Some("XK_braille_dots_13458"),
        Keysym::braille_dots_23458 => Some("XK_braille_dots_23458"),
        Keysym::braille_dots_123458 => Some("XK_braille_dots_123458"),
        Keysym::braille_dots_68 => Some("XK_braille_dots_68"),
        Keysym::braille_dots_168 => Some("XK_braille_dots_168"),
        Keysym::braille_dots_268 => Some("XK_braille_dots_268"),
        Keysym::braille_dots_1268 => Some("XK_braille_dots_1268"),
        Keysym::braille_dots_368 => Some("XK_braille_dots_368"),
        Keysym::braille_dots_1368 => Some("XK_braille_dots_1368"),
        Keysym::braille_dots_2368 => Some("XK_braille_dots_2368"),
        Keysym::braille_dots_12368 => Some("XK_braille_dots_12368"),
        Keysym::braille_dots_468 => Some("XK_braille_dots_468"),
        Keysym::braille_dots_1468 => Some("XK_braille_dots_1468"),
        Keysym::braille_dots_2468 => Some("XK_braille_dots_2468"),
        Keysym::braille_dots_12468 => Some("XK_braille_dots_12468"),
        Keysym::braille_dots_3468 => Some("XK_braille_dots_3468"),
        Keysym::braille_dots_13468 => Some("XK_braille_dots_13468"),
        Keysym::braille_dots_23468 => Some("XK_braille_dots_23468"),
        Keysym::braille_dots_123468 => Some("XK_braille_dots_123468"),
        Keysym::braille_dots_568 => Some("XK_braille_dots_568"),
        Keysym::braille_dots_1568 => Some("XK_braille_dots_1568"),
        Keysym::braille_dots_2568 => Some("XK_braille_dots_2568"),
        Keysym::braille_dots_12568 => Some("XK_braille_dots_12568"),
        Keysym::braille_dots_3568 => Some("XK_braille_dots_3568"),
        Keysym::braille_dots_13568 => Some("XK_braille_dots_13568"),
        Keysym::braille_dots_23568 => Some("XK_braille_dots_23568"),
        Keysym::braille_dots_123568 => Some("XK_braille_dots_123568"),
        Keysym::braille_dots_4568 => Some("XK_braille_dots_4568"),
        Keysym::braille_dots_14568 => Some("XK_braille_dots_14568"),
        Keysym::braille_dots_24568 => Some("XK_braille_dots_24568"),
        Keysym::braille_dots_124568 => Some("XK_braille_dots_124568"),
        Keysym::braille_dots_34568 => Some("XK_braille_dots_34568"),
        Keysym::braille_dots_134568 => Some("XK_braille_dots_134568"),
        Keysym::braille_dots_234568 => Some("XK_braille_dots_234568"),
        Keysym::braille_dots_1234568 => Some("XK_braille_dots_1234568"),
        Keysym::braille_dots_78 => Some("XK_braille_dots_78"),
        Keysym::braille_dots_178 => Some("XK_braille_dots_178"),
        Keysym::braille_dots_278 => Some("XK_braille_dots_278"),
        Keysym::braille_dots_1278 => Some("XK_braille_dots_1278"),
        Keysym::braille_dots_378 => Some("XK_braille_dots_378"),
        Keysym::braille_dots_1378 => Some("XK_braille_dots_1378"),
        Keysym::braille_dots_2378 => Some("XK_braille_dots_2378"),
        Keysym::braille_dots_12378 => Some("XK_braille_dots_12378"),
        Keysym::braille_dots_478 => Some("XK_braille_dots_478"),
        Keysym::braille_dots_1478 => Some("XK_braille_dots_1478"),
        Keysym::braille_dots_2478 => Some("XK_braille_dots_2478"),
        Keysym::braille_dots_12478 => Some("XK_braille_dots_12478"),
        Keysym::braille_dots_3478 => Some("XK_braille_dots_3478"),
        Keysym::braille_dots_13478 => Some("XK_braille_dots_13478"),
        Keysym::braille_dots_23478 => Some("XK_braille_dots_23478"),
        Keysym::braille_dots_123478 => Some("XK_braille_dots_123478"),
        Keysym::braille_dots_578 => Some("XK_braille_dots_578"),
        Keysym::braille_dots_1578 => Some("XK_braille_dots_1578"),
        Keysym::braille_dots_2578 => Some("XK_braille_dots_2578"),
        Keysym::braille_dots_12578 => Some("XK_braille_dots_12578"),
        Keysym::braille_dots_3578 => Some("XK_braille_dots_3578"),
        Keysym::braille_dots_13578 => Some("XK_braille_dots_13578"),
        Keysym::braille_dots_23578 => Some("XK_braille_dots_23578"),
        Keysym::braille_dots_123578 => Some("XK_braille_dots_123578"),
        Keysym::braille_dots_4578 => Some("XK_braille_dots_4578"),
        Keysym::braille_dots_14578 => Some("XK_braille_dots_14578"),
        Keysym::braille_dots_24578 => Some("XK_braille_dots_24578"),
        Keysym::braille_dots_124578 => Some("XK_braille_dots_124578"),
        Keysym::braille_dots_34578 => Some("XK_braille_dots_34578"),
        Keysym::braille_dots_134578 => Some("XK_braille_dots_134578"),
        Keysym::braille_dots_234578 => Some("XK_braille_dots_234578"),
        Keysym::braille_dots_1234578 => Some("XK_braille_dots_1234578"),
        Keysym::braille_dots_678 => Some("XK_braille_dots_678"),
        Keysym::braille_dots_1678 => Some("XK_braille_dots_1678"),
        Keysym::braille_dots_2678 => Some("XK_braille_dots_2678"),
        Keysym::braille_dots_12678 => Some("XK_braille_dots_12678"),
        Keysym::braille_dots_3678 => Some("XK_braille_dots_3678"),
        Keysym::braille_dots_13678 => Some("XK_braille_dots_13678"),
        Keysym::braille_dots_23678 => Some("XK_braille_dots_23678"),
        Keysym::braille_dots_123678 => Some("XK_braille_dots_123678"),
        Keysym::braille_dots_4678 => Some("XK_braille_dots_4678"),
        Keysym::braille_dots_14678 => Some("XK_braille_dots_14678"),
        Keysym::braille_dots_24678 => Some("XK_braille_dots_24678"),
        Keysym::braille_dots_124678 => Some("XK_braille_dots_124678"),
        Keysym::braille_dots_34678 => Some("XK_braille_dots_34678"),
        Keysym::braille_dots_134678 => Some("XK_braille_dots_134678"),
        Keysym::braille_dots_234678 => Some("XK_braille_dots_234678"),
        Keysym::braille_dots_1234678 => Some("XK_braille_dots_1234678"),
        Keysym::braille_dots_5678 => Some("XK_braille_dots_5678"),
        Keysym::braille_dots_15678 => Some("XK_braille_dots_15678"),
        Keysym::braille_dots_25678 => Some("XK_braille_dots_25678"),
        Keysym::braille_dots_125678 => Some("XK_braille_dots_125678"),
        Keysym::braille_dots_35678 => Some("XK_braille_dots_35678"),
        Keysym::braille_dots_135678 => Some("XK_braille_dots_135678"),
        Keysym::braille_dots_235678 => Some("XK_braille_dots_235678"),
        Keysym::braille_dots_1235678 => Some("XK_braille_dots_1235678"),
        Keysym::braille_dots_45678 => Some("XK_braille_dots_45678"),
        Keysym::braille_dots_145678 => Some("XK_braille_dots_145678"),
        Keysym::braille_dots_245678 => Some("XK_braille_dots_245678"),
        Keysym::braille_dots_1245678 => Some("XK_braille_dots_1245678"),
        Keysym::braille_dots_345678 => Some("XK_braille_dots_345678"),
        Keysym::braille_dots_1345678 => Some("XK_braille_dots_1345678"),
        Keysym::braille_dots_2345678 => Some("XK_braille_dots_2345678"),
        Keysym::braille_dots_12345678 => Some("XK_braille_dots_12345678"),
        Keysym::Sinh_ng => Some("XK_Sinh_ng"),
        Keysym::Sinh_h2 => Some("XK_Sinh_h2"),
        Keysym::Sinh_a => Some("XK_Sinh_a"),
        Keysym::Sinh_aa => Some("XK_Sinh_aa"),
        Keysym::Sinh_ae => Some("XK_Sinh_ae"),
        Keysym::Sinh_aee => Some("XK_Sinh_aee"),
        Keysym::Sinh_i => Some("XK_Sinh_i"),
        Keysym::Sinh_ii => Some("XK_Sinh_ii"),
        Keysym::Sinh_u => Some("XK_Sinh_u"),
        Keysym::Sinh_uu => Some("XK_Sinh_uu"),
        Keysym::Sinh_ri => Some("XK_Sinh_ri"),
        Keysym::Sinh_rii => Some("XK_Sinh_rii"),
        Keysym::Sinh_lu => Some("XK_Sinh_lu"),
        Keysym::Sinh_luu => Some("XK_Sinh_luu"),
        Keysym::Sinh_e => Some("XK_Sinh_e"),
        Keysym::Sinh_ee => Some("XK_Sinh_ee"),
        Keysym::Sinh_ai => Some("XK_Sinh_ai"),
        Keysym::Sinh_o => Some("XK_Sinh_o"),
        Keysym::Sinh_oo => Some("XK_Sinh_oo"),
        Keysym::Sinh_au => Some("XK_Sinh_au"),
        Keysym::Sinh_ka => Some("XK_Sinh_ka"),
        Keysym::Sinh_kha => Some("XK_Sinh_kha"),
        Keysym::Sinh_ga => Some("XK_Sinh_ga"),
        Keysym::Sinh_gha => Some("XK_Sinh_gha"),
        Keysym::Sinh_ng2 => Some("XK_Sinh_ng2"),
        Keysym::Sinh_nga => Some("XK_Sinh_nga"),
        Keysym::Sinh_ca => Some("XK_Sinh_ca"),
        Keysym::Sinh_cha => Some("XK_Sinh_cha"),
        Keysym::Sinh_ja => Some("XK_Sinh_ja"),
        Keysym::Sinh_jha => Some("XK_Sinh_jha"),
        Keysym::Sinh_nya => Some("XK_Sinh_nya"),
        Keysym::Sinh_jnya => Some("XK_Sinh_jnya"),
        Keysym::Sinh_nja => Some("XK_Sinh_nja"),
        Keysym::Sinh_tta => Some("XK_Sinh_tta"),
        Keysym::Sinh_ttha => Some("XK_Sinh_ttha"),
        Keysym::Sinh_dda => Some("XK_Sinh_dda"),
        Keysym::Sinh_ddha => Some("XK_Sinh_ddha"),
        Keysym::Sinh_nna => Some("XK_Sinh_nna"),
        Keysym::Sinh_ndda => Some("XK_Sinh_ndda"),
        Keysym::Sinh_tha => Some("XK_Sinh_tha"),
        Keysym::Sinh_thha => Some("XK_Sinh_thha"),
        Keysym::Sinh_dha => Some("XK_Sinh_dha"),
        Keysym::Sinh_dhha => Some("XK_Sinh_dhha"),
        Keysym::Sinh_na => Some("XK_Sinh_na"),
        Keysym::Sinh_ndha => Some("XK_Sinh_ndha"),
        Keysym::Sinh_pa => Some("XK_Sinh_pa"),
        Keysym::Sinh_pha => Some("XK_Sinh_pha"),
        Keysym::Sinh_ba => Some("XK_Sinh_ba"),
        Keysym::Sinh_bha => Some("XK_Sinh_bha"),
        Keysym::Sinh_ma => Some("XK_Sinh_ma"),
        Keysym::Sinh_mba => Some("XK_Sinh_mba"),
        Keysym::Sinh_ya => Some("XK_Sinh_ya"),
        Keysym::Sinh_ra => Some("XK_Sinh_ra"),
        Keysym::Sinh_la => Some("XK_Sinh_la"),
        Keysym::Sinh_va => Some("XK_Sinh_va"),
        Keysym::Sinh_sha => Some("XK_Sinh_sha"),
        Keysym::Sinh_ssha => Some("XK_Sinh_ssha"),
        Keysym::Sinh_sa => Some("XK_Sinh_sa"),
        Keysym::Sinh_ha => Some("XK_Sinh_ha"),
        Keysym::Sinh_lla => Some("XK_Sinh_lla"),
        Keysym::Sinh_fa => Some("XK_Sinh_fa"),
        Keysym::Sinh_al => Some("XK_Sinh_al"),
        Keysym::Sinh_aa2 => Some("XK_Sinh_aa2"),
        Keysym::Sinh_ae2 => Some("XK_Sinh_ae2"),
        Keysym::Sinh_aee2 => Some("XK_Sinh_aee2"),
        Keysym::Sinh_i2 => Some("XK_Sinh_i2"),
        Keysym::Sinh_ii2 => Some("XK_Sinh_ii2"),
        Keysym::Sinh_u2 => Some("XK_Sinh_u2"),
        Keysym::Sinh_uu2 => Some("XK_Sinh_uu2"),
        Keysym::Sinh_ru2 => Some("XK_Sinh_ru2"),
        Keysym::Sinh_e2 => Some("XK_Sinh_e2"),
        Keysym::Sinh_ee2 => Some("XK_Sinh_ee2"),
        Keysym::Sinh_ai2 => Some("XK_Sinh_ai2"),
        Keysym::Sinh_o2 => Some("XK_Sinh_o2"),
        Keysym::Sinh_oo2 => Some("XK_Sinh_oo2"),
        Keysym::Sinh_au2 => Some("XK_Sinh_au2"),
        Keysym::Sinh_lu2 => Some("XK_Sinh_lu2"),
        Keysym::Sinh_ruu2 => Some("XK_Sinh_ruu2"),
        Keysym::Sinh_luu2 => Some("XK_Sinh_luu2"),
        Keysym::Sinh_kunddaliya => Some("XK_Sinh_kunddaliya"),
        Keysym::XF86_ModeLock => Some("XF86XK_ModeLock"),
        Keysym::XF86_MonBrightnessUp => Some("XF86XK_MonBrightnessUp"),
        Keysym::XF86_MonBrightnessDown => Some("XF86XK_MonBrightnessDown"),
        Keysym::XF86_KbdLightOnOff => Some("XF86XK_KbdLightOnOff"),
        Keysym::XF86_KbdBrightnessUp => Some("XF86XK_KbdBrightnessUp"),
        Keysym::XF86_KbdBrightnessDown => Some("XF86XK_KbdBrightnessDown"),
        Keysym::XF86_MonBrightnessCycle => Some("XF86XK_MonBrightnessCycle"),
        Keysym::XF86_Standby => Some("XF86XK_Standby"),
        Keysym::XF86_AudioLowerVolume => Some("XF86XK_AudioLowerVolume"),
        Keysym::XF86_AudioMute => Some("XF86XK_AudioMute"),
        Keysym::XF86_AudioRaiseVolume => Some("XF86XK_AudioRaiseVolume"),
        Keysym::XF86_AudioPlay => Some("XF86XK_AudioPlay"),
        Keysym::XF86_AudioStop => Some("XF86XK_AudioStop"),
        Keysym::XF86_AudioPrev => Some("XF86XK_AudioPrev"),
        Keysym::XF86_AudioNext => Some("XF86XK_AudioNext"),
        Keysym::XF86_HomePage => Some("XF86XK_HomePage"),
        Keysym::XF86_Mail => Some("XF86XK_Mail"),
        Keysym::XF86_Start => Some("XF86XK_Start"),
        Keysym::XF86_Search => Some("XF86XK_Search"),
        Keysym::XF86_AudioRecord => Some("XF86XK_AudioRecord"),
        Keysym::XF86_Calculator => Some("XF86XK_Calculator"),
        Keysym::XF86_Memo => Some("XF86XK_Memo"),
        Keysym::XF86_ToDoList => Some("XF86XK_ToDoList"),
        Keysym::XF86_Calendar => Some("XF86XK_Calendar"),
        Keysym::XF86_PowerDown => Some("XF86XK_PowerDown"),
        Keysym::XF86_ContrastAdjust => Some("XF86XK_ContrastAdjust"),
        Keysym::XF86_RockerUp => Some("XF86XK_RockerUp"),
        Keysym::XF86_RockerDown => Some("XF86XK_RockerDown"),
        Keysym::XF86_RockerEnter => Some("XF86XK_RockerEnter"),
        Keysym::XF86_Back => Some("XF86XK_Back"),
        Keysym::XF86_Forward => Some("XF86XK_Forward"),
        Keysym::XF86_Stop => Some("XF86XK_Stop"),
        Keysym::XF86_Refresh => Some("XF86XK_Refresh"),
        Keysym::XF86_PowerOff => Some("XF86XK_PowerOff"),
        Keysym::XF86_WakeUp => Some("XF86XK_WakeUp"),
        Keysym::XF86_Eject => Some("XF86XK_Eject"),
        Keysym::XF86_ScreenSaver => Some("XF86XK_ScreenSaver"),
        Keysym::XF86_WWW => Some("XF86XK_WWW"),
        Keysym::XF86_Sleep => Some("XF86XK_Sleep"),
        Keysym::XF86_Favorites => Some("XF86XK_Favorites"),
        Keysym::XF86_AudioPause => Some("XF86XK_AudioPause"),
        Keysym::XF86_AudioMedia => Some("XF86XK_AudioMedia"),
        Keysym::XF86_MyComputer => Some("XF86XK_MyComputer"),
        Keysym::XF86_VendorHome => Some("XF86XK_VendorHome"),
        Keysym::XF86_LightBulb => Some("XF86XK_LightBulb"),
        Keysym::XF86_Shop => Some("XF86XK_Shop"),
        Keysym::XF86_History => Some("XF86XK_History"),
        Keysym::XF86_OpenURL => Some("XF86XK_OpenURL"),
        Keysym::XF86_AddFavorite => Some("XF86XK_AddFavorite"),
        Keysym::XF86_HotLinks => Some("XF86XK_HotLinks"),
        Keysym::XF86_BrightnessAdjust => Some("XF86XK_BrightnessAdjust"),
        Keysym::XF86_Finance => Some("XF86XK_Finance"),
        Keysym::XF86_Community => Some("XF86XK_Community"),
        Keysym::XF86_AudioRewind => Some("XF86XK_AudioRewind"),
        Keysym::XF86_BackForward => Some("XF86XK_BackForward"),
        Keysym::XF86_Launch0 => Some("XF86XK_Launch0"),
        Keysym::XF86_Launch1 => Some("XF86XK_Launch1"),
        Keysym::XF86_Launch2 => Some("XF86XK_Launch2"),
        Keysym::XF86_Launch3 => Some("XF86XK_Launch3"),
        Keysym::XF86_Launch4 => Some("XF86XK_Launch4"),
        Keysym::XF86_Launch5 => Some("XF86XK_Launch5"),
        Keysym::XF86_Launch6 => Some("XF86XK_Launch6"),
        Keysym::XF86_Launch7 => Some("XF86XK_Launch7"),
        Keysym::XF86_Launch8 => Some("XF86XK_Launch8"),
        Keysym::XF86_Launch9 => Some("XF86XK_Launch9"),
        Keysym::XF86_LaunchA => Some("XF86XK_LaunchA"),
        Keysym::XF86_LaunchB => Some("XF86XK_LaunchB"),
        Keysym::XF86_LaunchC => Some("XF86XK_LaunchC"),
        Keysym::XF86_LaunchD => Some("XF86XK_LaunchD"),
        Keysym::XF86_LaunchE => Some("XF86XK_LaunchE"),
        Keysym::XF86_LaunchF => Some("XF86XK_LaunchF"),
        Keysym::XF86_ApplicationLeft => Some("XF86XK_ApplicationLeft"),
        Keysym::XF86_ApplicationRight => Some("XF86XK_ApplicationRight"),
        Keysym::XF86_Book => Some("XF86XK_Book"),
        Keysym::XF86_CD => Some("XF86XK_CD"),
        Keysym::XF86_Calculater => Some("XF86XK_Calculater"),
        Keysym::XF86_Clear => Some("XF86XK_Clear"),
        Keysym::XF86_Close => Some("XF86XK_Close"),
        Keysym::XF86_Copy => Some("XF86XK_Copy"),
        Keysym::XF86_Cut => Some("XF86XK_Cut"),
        Keysym::XF86_Display => Some("XF86XK_Display"),
        Keysym::XF86_DOS => Some("XF86XK_DOS"),
        Keysym::XF86_Documents => Some("XF86XK_Documents"),
        Keysym::XF86_Excel => Some("XF86XK_Excel"),
        Keysym::XF86_Explorer => Some("XF86XK_Explorer"),
        Keysym::XF86_Game => Some("XF86XK_Game"),
        Keysym::XF86_Go => Some("XF86XK_Go"),
        Keysym::XF86_iTouch => Some("XF86XK_iTouch"),
        Keysym::XF86_LogOff => Some("XF86XK_LogOff"),
        Keysym::XF86_Market => Some("XF86XK_Market"),
        Keysym::XF86_Meeting => Some("XF86XK_Meeting"),
        Keysym::XF86_MenuKB => Some("XF86XK_MenuKB"),
        Keysym::XF86_MenuPB => Some("XF86XK_MenuPB"),
        Keysym::XF86_MySites => Some("XF86XK_MySites"),
        Keysym::XF86_New => Some("XF86XK_New"),
        Keysym::XF86_News => Some("XF86XK_News"),
        Keysym::XF86_OfficeHome => Some("XF86XK_OfficeHome"),
        Keysym::XF86_Open => Some("XF86XK_Open"),
        Keysym::XF86_Option => Some("XF86XK_Option"),
        Keysym::XF86_Paste => Some("XF86XK_Paste"),
        Keysym::XF86_Phone => Some("XF86XK_Phone"),
        Keysym::XF86_Q => Some("XF86XK_Q"),
        Keysym::XF86_Reply => Some("XF86XK_Reply"),
        Keysym::XF86_Reload => Some("XF86XK_Reload"),
        Keysym::XF86_RotateWindows => Some("XF86XK_RotateWindows"),
        Keysym::XF86_RotationPB => Some("XF86XK_RotationPB"),
        Keysym::XF86_RotationKB => Some("XF86XK_RotationKB"),
        Keysym::XF86_Save => Some("XF86XK_Save"),
        Keysym::XF86_ScrollUp => Some("XF86XK_ScrollUp"),
        Keysym::XF86_ScrollDown => Some("XF86XK_ScrollDown"),
        Keysym::XF86_ScrollClick => Some("XF86XK_ScrollClick"),
        Keysym::XF86_Send => Some("XF86XK_Send"),
        Keysym::XF86_Spell => Some("XF86XK_Spell"),
        Keysym::XF86_SplitScreen => Some("XF86XK_SplitScreen"),
        Keysym::XF86_Support => Some("XF86XK_Support"),
        Keysym::XF86_TaskPane => Some("XF86XK_TaskPane"),
        Keysym::XF86_Terminal => Some("XF86XK_Terminal"),
        Keysym::XF86_Tools => Some("XF86XK_Tools"),
        Keysym::XF86_Travel => Some("XF86XK_Travel"),
        Keysym::XF86_UserPB => Some("XF86XK_UserPB"),
        Keysym::XF86_User1KB => Some("XF86XK_User1KB"),
        Keysym::XF86_User2KB => Some("XF86XK_User2KB"),
        Keysym::XF86_Video => Some("XF86XK_Video"),
        Keysym::XF86_WheelButton => Some("XF86XK_WheelButton"),
        Keysym::XF86_Word => Some("XF86XK_Word"),
        Keysym::XF86_Xfer => Some("XF86XK_Xfer"),
        Keysym::XF86_ZoomIn => Some("XF86XK_ZoomIn"),
        Keysym::XF86_ZoomOut => Some("XF86XK_ZoomOut"),
        Keysym::XF86_Away => Some("XF86XK_Away"),
        Keysym::XF86_Messenger => Some("XF86XK_Messenger"),
        Keysym::XF86_WebCam => Some("XF86XK_WebCam"),
        Keysym::XF86_MailForward => Some("XF86XK_MailForward"),
        Keysym::XF86_Pictures => Some("XF86XK_Pictures"),
        Keysym::XF86_Music => Some("XF86XK_Music"),
        Keysym::XF86_Battery => Some("XF86XK_Battery"),
        Keysym::XF86_Bluetooth => Some("XF86XK_Bluetooth"),
        Keysym::XF86_WLAN => Some("XF86XK_WLAN"),
        Keysym::XF86_UWB => Some("XF86XK_UWB"),
        Keysym::XF86_AudioForward => Some("XF86XK_AudioForward"),
        Keysym::XF86_AudioRepeat => Some("XF86XK_AudioRepeat"),
        Keysym::XF86_AudioRandomPlay => Some("XF86XK_AudioRandomPlay"),
        Keysym::XF86_Subtitle => Some("XF86XK_Subtitle"),
        Keysym::XF86_AudioCycleTrack => Some("XF86XK_AudioCycleTrack"),
        Keysym::XF86_CycleAngle => Some("XF86XK_CycleAngle"),
        Keysym::XF86_FrameBack => Some("XF86XK_FrameBack"),
        Keysym::XF86_FrameForward => Some("XF86XK_FrameForward"),
        Keysym::XF86_Time => Some("XF86XK_Time"),
        Keysym::XF86_Select => Some("XF86XK_Select"),
        Keysym::XF86_View => Some("XF86XK_View"),
        Keysym::XF86_TopMenu => Some("XF86XK_TopMenu"),
        Keysym::XF86_Red => Some("XF86XK_Red"),
        Keysym::XF86_Green => Some("XF86XK_Green"),
        Keysym::XF86_Yellow => Some("XF86XK_Yellow"),
        Keysym::XF86_Blue => Some("XF86XK_Blue"),
        Keysym::XF86_Suspend => Some("XF86XK_Suspend"),
        Keysym::XF86_Hibernate => Some("XF86XK_Hibernate"),
        Keysym::XF86_TouchpadToggle => Some("XF86XK_TouchpadToggle"),
        Keysym::XF86_TouchpadOn => Some("XF86XK_TouchpadOn"),
        Keysym::XF86_TouchpadOff => Some("XF86XK_TouchpadOff"),
        Keysym::XF86_AudioMicMute => Some("XF86XK_AudioMicMute"),
        Keysym::XF86_Keyboard => Some("XF86XK_Keyboard"),
        Keysym::XF86_WWAN => Some("XF86XK_WWAN"),
        Keysym::XF86_RFKill => Some("XF86XK_RFKill"),
        Keysym::XF86_AudioPreset => Some("XF86XK_AudioPreset"),
        Keysym::XF86_RotationLockToggle => Some("XF86XK_RotationLockToggle"),
        Keysym::XF86_FullScreen => Some("XF86XK_FullScreen"),
        Keysym::XF86_Switch_VT_1 => Some("XF86XK_Switch_VT_1"),
        Keysym::XF86_Switch_VT_2 => Some("XF86XK_Switch_VT_2"),
        Keysym::XF86_Switch_VT_3 => Some("XF86XK_Switch_VT_3"),
        Keysym::XF86_Switch_VT_4 => Some("XF86XK_Switch_VT_4"),
        Keysym::XF86_Switch_VT_5 => Some("XF86XK_Switch_VT_5"),
        Keysym::XF86_Switch_VT_6 => Some("XF86XK_Switch_VT_6"),
        Keysym::XF86_Switch_VT_7 => Some("XF86XK_Switch_VT_7"),
        Keysym::XF86_Switch_VT_8 => Some("XF86XK_Switch_VT_8"),
        Keysym::XF86_Switch_VT_9 => Some("XF86XK_Switch_VT_9"),
        Keysym::XF86_Switch_VT_10 => Some("XF86XK_Switch_VT_10"),
        Keysym::XF86_Switch_VT_11 => Some("XF86XK_Switch_VT_11"),
        Keysym::XF86_Switch_VT_12 => Some("XF86XK_Switch_VT_12"),
        Keysym::XF86_Ungrab => Some("XF86XK_Ungrab"),
        Keysym::XF86_ClearGrab => Some("XF86XK_ClearGrab"),
        Keysym::XF86_Next_VMode => Some("XF86XK_Next_VMode"),
        Keysym::XF86_Prev_VMode => Some("XF86XK_Prev_VMode"),
        Keysym::XF86_LogWindowTree => Some("XF86XK_LogWindowTree"),
        Keysym::XF86_LogGrabInfo => Some("XF86XK_LogGrabInfo"),
        Keysym::XF86_BrightnessAuto => Some("XF86XK_BrightnessAuto"),
        Keysym::XF86_DisplayOff => Some("XF86XK_DisplayOff"),
        Keysym::XF86_Info => Some("XF86XK_Info"),
        Keysym::XF86_AspectRatio => Some("XF86XK_AspectRatio"),
        Keysym::XF86_DVD => Some("XF86XK_DVD"),
        Keysym::XF86_Audio => Some("XF86XK_Audio"),
        Keysym::XF86_ChannelUp => Some("XF86XK_ChannelUp"),
        Keysym::XF86_ChannelDown => Some("XF86XK_ChannelDown"),
        Keysym::XF86_Break => Some("XF86XK_Break"),
        Keysym::XF86_VideoPhone => Some("XF86XK_VideoPhone"),
        Keysym::XF86_ZoomReset => Some("XF86XK_ZoomReset"),
        Keysym::XF86_Editor => Some("XF86XK_Editor"),
        Keysym::XF86_GraphicsEditor => Some("XF86XK_GraphicsEditor"),
        Keysym::XF86_Presentation => Some("XF86XK_Presentation"),
        Keysym::XF86_Database => Some("XF86XK_Database"),
        Keysym::XF86_Voicemail => Some("XF86XK_Voicemail"),
        Keysym::XF86_Addressbook => Some("XF86XK_Addressbook"),
        Keysym::XF86_DisplayToggle => Some("XF86XK_DisplayToggle"),
        Keysym::XF86_SpellCheck => Some("XF86XK_SpellCheck"),
        Keysym::XF86_ContextMenu => Some("XF86XK_ContextMenu"),
        Keysym::XF86_MediaRepeat => Some("XF86XK_MediaRepeat"),
        Keysym::XF86_10ChannelsUp => Some("XF86XK_10ChannelsUp"),
        Keysym::XF86_10ChannelsDown => Some("XF86XK_10ChannelsDown"),
        Keysym::XF86_Images => Some("XF86XK_Images"),
        Keysym::XF86_NotificationCenter => Some("XF86XK_NotificationCenter"),
        Keysym::XF86_PickupPhone => Some("XF86XK_PickupPhone"),
        Keysym::XF86_HangupPhone => Some("XF86XK_HangupPhone"),
        Keysym::XF86_Fn => Some("XF86XK_Fn"),
        Keysym::XF86_Fn_Esc => Some("XF86XK_Fn_Esc"),
        Keysym::XF86_FnRightShift => Some("XF86XK_FnRightShift"),
        Keysym::XF86_Numeric0 => Some("XF86XK_Numeric0"),
        Keysym::XF86_Numeric1 => Some("XF86XK_Numeric1"),
        Keysym::XF86_Numeric2 => Some("XF86XK_Numeric2"),
        Keysym::XF86_Numeric3 => Some("XF86XK_Numeric3"),
        Keysym::XF86_Numeric4 => Some("XF86XK_Numeric4"),
        Keysym::XF86_Numeric5 => Some("XF86XK_Numeric5"),
        Keysym::XF86_Numeric6 => Some("XF86XK_Numeric6"),
        Keysym::XF86_Numeric7 => Some("XF86XK_Numeric7"),
        Keysym::XF86_Numeric8 => Some("XF86XK_Numeric8"),
        Keysym::XF86_Numeric9 => Some("XF86XK_Numeric9"),
        Keysym::XF86_NumericStar => Some("XF86XK_NumericStar"),
        Keysym::XF86_NumericPound => Some("XF86XK_NumericPound"),
        Keysym::XF86_NumericA => Some("XF86XK_NumericA"),
        Keysym::XF86_NumericB => Some("XF86XK_NumericB"),
        Keysym::XF86_NumericC => Some("XF86XK_NumericC"),
        Keysym::XF86_NumericD => Some("XF86XK_NumericD"),
        Keysym::XF86_CameraFocus => Some("XF86XK_CameraFocus"),
        Keysym::XF86_WPSButton => Some("XF86XK_WPSButton"),
        Keysym::XF86_CameraZoomIn => Some("XF86XK_CameraZoomIn"),
        Keysym::XF86_CameraZoomOut => Some("XF86XK_CameraZoomOut"),
        Keysym::XF86_CameraUp => Some("XF86XK_CameraUp"),
        Keysym::XF86_CameraDown => Some("XF86XK_CameraDown"),
        Keysym::XF86_CameraLeft => Some("XF86XK_CameraLeft"),
        Keysym::XF86_CameraRight => Some("XF86XK_CameraRight"),
        Keysym::XF86_AttendantOn => Some("XF86XK_AttendantOn"),
        Keysym::XF86_AttendantOff => Some("XF86XK_AttendantOff"),
        Keysym::XF86_AttendantToggle => Some("XF86XK_AttendantToggle"),
        Keysym::XF86_LightsToggle => Some("XF86XK_LightsToggle"),
        Keysym::XF86_ALSToggle => Some("XF86XK_ALSToggle"),
        Keysym::XF86_Buttonconfig => Some("XF86XK_Buttonconfig"),
        Keysym::XF86_Taskmanager => Some("XF86XK_Taskmanager"),
        Keysym::XF86_Journal => Some("XF86XK_Journal"),
        Keysym::XF86_ControlPanel => Some("XF86XK_ControlPanel"),
        Keysym::XF86_AppSelect => Some("XF86XK_AppSelect"),
        Keysym::XF86_Screensaver => Some("XF86XK_Screensaver"),
        Keysym::XF86_VoiceCommand => Some("XF86XK_VoiceCommand"),
        Keysym::XF86_Assistant => Some("XF86XK_Assistant"),
        Keysym::XF86_BrightnessMin => Some("XF86XK_BrightnessMin"),
        Keysym::XF86_BrightnessMax => Some("XF86XK_BrightnessMax"),
        Keysym::XF86_KbdInputAssistPrev => Some("XF86XK_KbdInputAssistPrev"),
        Keysym::XF86_KbdInputAssistNext => Some("XF86XK_KbdInputAssistNext"),
        Keysym::XF86_KbdInputAssistPrevgroup => Some("XF86XK_KbdInputAssistPrevgroup"),
        Keysym::XF86_KbdInputAssistNextgroup => Some("XF86XK_KbdInputAssistNextgroup"),
        Keysym::XF86_KbdInputAssistAccept => Some("XF86XK_KbdInputAssistAccept"),
        Keysym::XF86_KbdInputAssistCancel => Some("XF86XK_KbdInputAssistCancel"),
        Keysym::XF86_RightUp => Some("XF86XK_RightUp"),
        Keysym::XF86_RightDown => Some("XF86XK_RightDown"),
        Keysym::XF86_LeftUp => Some("XF86XK_LeftUp"),
        Keysym::XF86_LeftDown => Some("XF86XK_LeftDown"),
        Keysym::XF86_RootMenu => Some("XF86XK_RootMenu"),
        Keysym::XF86_MediaTopMenu => Some("XF86XK_MediaTopMenu"),
        Keysym::XF86_Numeric11 => Some("XF86XK_Numeric11"),
        Keysym::XF86_Numeric12 => Some("XF86XK_Numeric12"),
        Keysym::XF86_AudioDesc => Some("XF86XK_AudioDesc"),
        Keysym::XF86_3DMode => Some("XF86XK_3DMode"),
        Keysym::XF86_NextFavorite => Some("XF86XK_NextFavorite"),
        Keysym::XF86_StopRecord => Some("XF86XK_StopRecord"),
        Keysym::XF86_PauseRecord => Some("XF86XK_PauseRecord"),
        Keysym::XF86_VOD => Some("XF86XK_VOD"),
        Keysym::XF86_Unmute => Some("XF86XK_Unmute"),
        Keysym::XF86_FastReverse => Some("XF86XK_FastReverse"),
        Keysym::XF86_SlowReverse => Some("XF86XK_SlowReverse"),
        Keysym::XF86_Data => Some("XF86XK_Data"),
        Keysym::XF86_OnScreenKeyboard => Some("XF86XK_OnScreenKeyboard"),
        Keysym::XF86_PrivacyScreenToggle => Some("XF86XK_PrivacyScreenToggle"),
        Keysym::XF86_SelectiveScreenshot => Some("XF86XK_SelectiveScreenshot"),
        Keysym::XF86_Macro1 => Some("XF86XK_Macro1"),
        Keysym::XF86_Macro2 => Some("XF86XK_Macro2"),
        Keysym::XF86_Macro3 => Some("XF86XK_Macro3"),
        Keysym::XF86_Macro4 => Some("XF86XK_Macro4"),
        Keysym::XF86_Macro5 => Some("XF86XK_Macro5"),
        Keysym::XF86_Macro6 => Some("XF86XK_Macro6"),
        Keysym::XF86_Macro7 => Some("XF86XK_Macro7"),
        Keysym::XF86_Macro8 => Some("XF86XK_Macro8"),
        Keysym::XF86_Macro9 => Some("XF86XK_Macro9"),
        Keysym::XF86_Macro10 => Some("XF86XK_Macro10"),
        Keysym::XF86_Macro11 => Some("XF86XK_Macro11"),
        Keysym::XF86_Macro12 => Some("XF86XK_Macro12"),
        Keysym::XF86_Macro13 => Some("XF86XK_Macro13"),
        Keysym::XF86_Macro14 => Some("XF86XK_Macro14"),
        Keysym::XF86_Macro15 => Some("XF86XK_Macro15"),
        Keysym::XF86_Macro16 => Some("XF86XK_Macro16"),
        Keysym::XF86_Macro17 => Some("XF86XK_Macro17"),
        Keysym::XF86_Macro18 => Some("XF86XK_Macro18"),
        Keysym::XF86_Macro19 => Some("XF86XK_Macro19"),
        Keysym::XF86_Macro20 => Some("XF86XK_Macro20"),
        Keysym::XF86_Macro21 => Some("XF86XK_Macro21"),
        Keysym::XF86_Macro22 => Some("XF86XK_Macro22"),
        Keysym::XF86_Macro23 => Some("XF86XK_Macro23"),
        Keysym::XF86_Macro24 => Some("XF86XK_Macro24"),
        Keysym::XF86_Macro25 => Some("XF86XK_Macro25"),
        Keysym::XF86_Macro26 => Some("XF86XK_Macro26"),
        Keysym::XF86_Macro27 => Some("XF86XK_Macro27"),
        Keysym::XF86_Macro28 => Some("XF86XK_Macro28"),
        Keysym::XF86_Macro29 => Some("XF86XK_Macro29"),
        Keysym::XF86_Macro30 => Some("XF86XK_Macro30"),
        Keysym::XF86_MacroRecordStart => Some("XF86XK_MacroRecordStart"),
        Keysym::XF86_MacroRecordStop => Some("XF86XK_MacroRecordStop"),
        Keysym::XF86_MacroPresetCycle => Some("XF86XK_MacroPresetCycle"),
        Keysym::XF86_MacroPreset1 => Some("XF86XK_MacroPreset1"),
        Keysym::XF86_MacroPreset2 => Some("XF86XK_MacroPreset2"),
        Keysym::XF86_MacroPreset3 => Some("XF86XK_MacroPreset3"),
        Keysym::XF86_KbdLcdMenu1 => Some("XF86XK_KbdLcdMenu1"),
        Keysym::XF86_KbdLcdMenu2 => Some("XF86XK_KbdLcdMenu2"),
        Keysym::XF86_KbdLcdMenu3 => Some("XF86XK_KbdLcdMenu3"),
        Keysym::XF86_KbdLcdMenu4 => Some("XF86XK_KbdLcdMenu4"),
        Keysym::XF86_KbdLcdMenu5 => Some("XF86XK_KbdLcdMenu5"),
        Keysym::SUN_FA_Grave => Some("SunXK_FA_Grave"),
        Keysym::SUN_FA_Circum => Some("SunXK_FA_Circum"),
        Keysym::SUN_FA_Tilde => Some("SunXK_FA_Tilde"),
        Keysym::SUN_FA_Acute => Some("SunXK_FA_Acute"),
        Keysym::SUN_FA_Diaeresis => Some("SunXK_FA_Diaeresis"),
        Keysym::SUN_FA_Cedilla => Some("SunXK_FA_Cedilla"),
        Keysym::SUN_F36 => Some("SunXK_F36"),
        Keysym::SUN_F37 => Some("SunXK_F37"),
        Keysym::SUN_Sys_Req => Some("SunXK_Sys_Req"),
        Keysym::SUN_Print_Screen => Some("SunXK_Print_Screen"),
        Keysym::SUN_Compose => Some("SunXK_Compose"),
        Keysym::SUN_AltGraph => Some("SunXK_AltGraph"),
        Keysym::SUN_PageUp => Some("SunXK_PageUp"),
        Keysym::SUN_PageDown => Some("SunXK_PageDown"),
        Keysym::SUN_Undo => Some("SunXK_Undo"),
        Keysym::SUN_Again => Some("SunXK_Again"),
        Keysym::SUN_Find => Some("SunXK_Find"),
        Keysym::SUN_Stop => Some("SunXK_Stop"),
        Keysym::SUN_Props => Some("SunXK_Props"),
        Keysym::SUN_Front => Some("SunXK_Front"),
        Keysym::SUN_Copy => Some("SunXK_Copy"),
        Keysym::SUN_Open => Some("SunXK_Open"),
        Keysym::SUN_Paste => Some("SunXK_Paste"),
        Keysym::SUN_Cut => Some("SunXK_Cut"),
        Keysym::SUN_PowerSwitch => Some("SunXK_PowerSwitch"),
        Keysym::SUN_AudioLowerVolume => Some("SunXK_AudioLowerVolume"),
        Keysym::SUN_AudioMute => Some("SunXK_AudioMute"),
        Keysym::SUN_AudioRaiseVolume => Some("SunXK_AudioRaiseVolume"),
        Keysym::SUN_VideoDegauss => Some("SunXK_VideoDegauss"),
        Keysym::SUN_VideoLowerBrightness => Some("SunXK_VideoLowerBrightness"),
        Keysym::SUN_VideoRaiseBrightness => Some("SunXK_VideoRaiseBrightness"),
        Keysym::SUN_PowerSwitchShift => Some("SunXK_PowerSwitchShift"),
        Keysym::D_ring_accent => Some("DXK_ring_accent"),
        Keysym::D_circumflex_accent => Some("DXK_circumflex_accent"),
        Keysym::D_cedilla_accent => Some("DXK_cedilla_accent"),
        Keysym::D_acute_accent => Some("DXK_acute_accent"),
        Keysym::D_grave_accent => Some("DXK_grave_accent"),
        Keysym::D_tilde => Some("DXK_tilde"),
        Keysym::D_diaeresis => Some("DXK_diaeresis"),
        Keysym::D_Remove => Some("DXK_Remove"),
        Keysym::HP_ClearLine => Some("hpXK_ClearLine"),
        Keysym::HP_InsertLine => Some("hpXK_InsertLine"),
        Keysym::HP_DeleteLine => Some("hpXK_DeleteLine"),
        Keysym::HP_InsertChar => Some("hpXK_InsertChar"),
        Keysym::HP_DeleteChar => Some("hpXK_DeleteChar"),
        Keysym::HP_BackTab => Some("hpXK_BackTab"),
        Keysym::HP_KP_BackTab => Some("hpXK_KP_BackTab"),
        Keysym::HP_Modelock1 => Some("hpXK_Modelock1"),
        Keysym::HP_Modelock2 => Some("hpXK_Modelock2"),
        Keysym::HP_Reset => Some("hpXK_Reset"),
        Keysym::HP_System => Some("hpXK_System"),
        Keysym::HP_User => Some("hpXK_User"),
        Keysym::HP_mute_acute => Some("hpXK_mute_acute"),
        Keysym::HP_mute_grave => Some("hpXK_mute_grave"),
        Keysym::HP_mute_asciicircum => Some("hpXK_mute_asciicircum"),
        Keysym::HP_mute_diaeresis => Some("hpXK_mute_diaeresis"),
        Keysym::HP_mute_asciitilde => Some("hpXK_mute_asciitilde"),
        Keysym::HP_lira => Some("hpXK_lira"),
        Keysym::HP_guilder => Some("hpXK_guilder"),
        Keysym::HP_IO => Some("hpXK_IO"),
        Keysym::HP_longminus => Some("hpXK_longminus"),
        Keysym::HP_block => Some("hpXK_block"),
        Keysym::OSF_Copy => Some("osfXK_Copy"),
        Keysym::OSF_Cut => Some("osfXK_Cut"),
        Keysym::OSF_Paste => Some("osfXK_Paste"),
        Keysym::OSF_BackTab => Some("osfXK_BackTab"),
        Keysym::OSF_BackSpace => Some("osfXK_BackSpace"),
        Keysym::OSF_Clear => Some("osfXK_Clear"),
        Keysym::OSF_Escape => Some("osfXK_Escape"),
        Keysym::OSF_AddMode => Some("osfXK_AddMode"),
        Keysym::OSF_PrimaryPaste => Some("osfXK_PrimaryPaste"),
        Keysym::OSF_QuickPaste => Some("osfXK_QuickPaste"),
        Keysym::OSF_PageLeft => Some("osfXK_PageLeft"),
        Keysym::OSF_PageUp => Some("osfXK_PageUp"),
        Keysym::OSF_PageDown => Some("osfXK_PageDown"),
        Keysym::OSF_PageRight => Some("osfXK_PageRight"),
        Keysym::OSF_Activate => Some("osfXK_Activate"),
        Keysym::OSF_MenuBar => Some("osfXK_MenuBar"),
        Keysym::OSF_Left => Some("osfXK_Left"),
        Keysym::OSF_Up => Some("osfXK_Up"),
        Keysym::OSF_Right => Some("osfXK_Right"),
        Keysym::OSF_Down => Some("osfXK_Down"),
        Keysym::OSF_EndLine => Some("osfXK_EndLine"),
        Keysym::OSF_BeginLine => Some("osfXK_BeginLine"),
        Keysym::OSF_EndData => Some("osfXK_EndData"),
        Keysym::OSF_BeginData => Some("osfXK_BeginData"),
        Keysym::OSF_PrevMenu => Some("osfXK_PrevMenu"),
        Keysym::OSF_NextMenu => Some("osfXK_NextMenu"),
        Keysym::OSF_PrevField => Some("osfXK_PrevField"),
        Keysym::OSF_NextField => Some("osfXK_NextField"),
        Keysym::OSF_Select => Some("osfXK_Select"),
        Keysym::OSF_Insert => Some("osfXK_Insert"),
        Keysym::OSF_Undo => Some("osfXK_Undo"),
        Keysym::OSF_Menu => Some("osfXK_Menu"),
        Keysym::OSF_Cancel => Some("osfXK_Cancel"),
        Keysym::OSF_Help => Some("osfXK_Help"),
        Keysym::OSF_SelectAll => Some("osfXK_SelectAll"),
        Keysym::OSF_DeselectAll => Some("osfXK_DeselectAll"),
        Keysym::OSF_Reselect => Some("osfXK_Reselect"),
        Keysym::OSF_Extend => Some("osfXK_Extend"),
        Keysym::OSF_Restore => Some("osfXK_Restore"),
        Keysym::OSF_Delete => Some("osfXK_Delete"),
        Keysym::Reset => Some("XK_Reset"),
        Keysym::System => Some("XK_System"),
        Keysym::User => Some("XK_User"),
        Keysym::ClearLine => Some("XK_ClearLine"),
        Keysym::InsertLine => Some("XK_InsertLine"),
        Keysym::DeleteLine => Some("XK_DeleteLine"),
        Keysym::InsertChar => Some("XK_InsertChar"),
        Keysym::DeleteChar => Some("XK_DeleteChar"),
        Keysym::BackTab => Some("XK_BackTab"),
        Keysym::KP_BackTab => Some("XK_KP_BackTab"),
        Keysym::Ext16bit_L => Some("XK_Ext16bit_L"),
        Keysym::Ext16bit_R => Some("XK_Ext16bit_R"),
        Keysym::mute_acute => Some("XK_mute_acute"),
        Keysym::mute_grave => Some("XK_mute_grave"),
        Keysym::mute_asciicircum => Some("XK_mute_asciicircum"),
        Keysym::mute_diaeresis => Some("XK_mute_diaeresis"),
        Keysym::mute_asciitilde => Some("XK_mute_asciitilde"),
        Keysym::lira => Some("XK_lira"),
        Keysym::guilder => Some("XK_guilder"),
        Keysym::IO => Some("XK_IO"),
        Keysym::longminus => Some("XK_longminus"),
        Keysym::block => Some("XK_block"),

        _ => None,
    }
}
