// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "HdyKeypad")]
    pub struct Keypad(Object<ffi::HdyKeypad, ffi::HdyKeypadClass>) @extends gtk::Bin, gtk::Container, gtk::Widget, @implements gtk::Buildable;

    match fn {
        type_ => || ffi::hdy_keypad_get_type(),
    }
}

impl Keypad {
    pub const NONE: Option<&'static Keypad> = None;

    #[doc(alias = "hdy_keypad_new")]
    pub fn new(symbols_visible: bool, letters_visible: bool) -> Keypad {
        assert_initialized_main_thread!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::hdy_keypad_new(
                symbols_visible.into_glib(),
                letters_visible.into_glib(),
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Keypad`] objects.
    ///
    /// This method returns an instance of [`KeypadBuilder`](crate::builders::KeypadBuilder) which can be used to create [`Keypad`] objects.
    pub fn builder() -> KeypadBuilder {
        KeypadBuilder::new()
    }
}

impl Default for Keypad {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Keypad`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct KeypadBuilder {
    builder: glib::object::ObjectBuilder<'static, Keypad>,
}

impl KeypadBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn column_spacing(self, column_spacing: u32) -> Self {
        Self {
            builder: self.builder.property("column-spacing", column_spacing),
        }
    }

    pub fn end_action(self, end_action: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("end-action", end_action.clone().upcast()),
        }
    }

    pub fn entry(self, entry: &impl IsA<gtk::Entry>) -> Self {
        Self {
            builder: self.builder.property("entry", entry.clone().upcast()),
        }
    }

    pub fn letters_visible(self, letters_visible: bool) -> Self {
        Self {
            builder: self.builder.property("letters-visible", letters_visible),
        }
    }

    pub fn row_spacing(self, row_spacing: u32) -> Self {
        Self {
            builder: self.builder.property("row-spacing", row_spacing),
        }
    }

    pub fn start_action(self, start_action: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("start-action", start_action.clone().upcast()),
        }
    }

    pub fn symbols_visible(self, symbols_visible: bool) -> Self {
        Self {
            builder: self.builder.property("symbols-visible", symbols_visible),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: gtk::ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<gtk::Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    //pub fn style(self, style: &impl IsA</*Ignored*/gtk::Style>) -> Self {
    //    Self { builder: self.builder.property("style", style.clone().upcast()), }
    //}

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Keypad`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Keypad {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Keypad>> Sealed for T {}
}

pub trait KeypadExt: IsA<Keypad> + sealed::Sealed + 'static {
    #[doc(alias = "hdy_keypad_get_column_spacing")]
    #[doc(alias = "get_column_spacing")]
    fn column_spacing(&self) -> u32 {
        unsafe { ffi::hdy_keypad_get_column_spacing(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "hdy_keypad_get_end_action")]
    #[doc(alias = "get_end_action")]
    fn end_action(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_keypad_get_end_action(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_keypad_get_entry")]
    #[doc(alias = "get_entry")]
    fn entry(&self) -> Option<gtk::Entry> {
        unsafe { from_glib_none(ffi::hdy_keypad_get_entry(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "hdy_keypad_get_letters_visible")]
    #[doc(alias = "get_letters_visible")]
    fn is_letters_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_keypad_get_letters_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_keypad_get_row_spacing")]
    #[doc(alias = "get_row_spacing")]
    fn row_spacing(&self) -> u32 {
        unsafe { ffi::hdy_keypad_get_row_spacing(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "hdy_keypad_get_start_action")]
    #[doc(alias = "get_start_action")]
    fn start_action(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_keypad_get_start_action(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_keypad_get_symbols_visible")]
    #[doc(alias = "get_symbols_visible")]
    fn is_symbols_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_keypad_get_symbols_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_keypad_set_column_spacing")]
    fn set_column_spacing(&self, spacing: u32) {
        unsafe {
            ffi::hdy_keypad_set_column_spacing(self.as_ref().to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "hdy_keypad_set_end_action")]
    fn set_end_action(&self, end_action: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::hdy_keypad_set_end_action(
                self.as_ref().to_glib_none().0,
                end_action.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_keypad_set_entry")]
    fn set_entry(&self, entry: Option<&impl IsA<gtk::Entry>>) {
        unsafe {
            ffi::hdy_keypad_set_entry(
                self.as_ref().to_glib_none().0,
                entry.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_keypad_set_letters_visible")]
    fn set_letters_visible(&self, letters_visible: bool) {
        unsafe {
            ffi::hdy_keypad_set_letters_visible(
                self.as_ref().to_glib_none().0,
                letters_visible.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_keypad_set_row_spacing")]
    fn set_row_spacing(&self, spacing: u32) {
        unsafe {
            ffi::hdy_keypad_set_row_spacing(self.as_ref().to_glib_none().0, spacing);
        }
    }

    #[doc(alias = "hdy_keypad_set_start_action")]
    fn set_start_action(&self, start_action: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::hdy_keypad_set_start_action(
                self.as_ref().to_glib_none().0,
                start_action.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_keypad_set_symbols_visible")]
    fn set_symbols_visible(&self, symbols_visible: bool) {
        unsafe {
            ffi::hdy_keypad_set_symbols_visible(
                self.as_ref().to_glib_none().0,
                symbols_visible.into_glib(),
            );
        }
    }

    #[doc(alias = "column-spacing")]
    fn connect_column_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_spacing_trampoline<
            P: IsA<Keypad>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::column-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_column_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "end-action")]
    fn connect_end_action_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_end_action_trampoline<P: IsA<Keypad>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::end-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_end_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "entry")]
    fn connect_entry_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_entry_trampoline<P: IsA<Keypad>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::entry\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_entry_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "letters-visible")]
    fn connect_letters_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_letters_visible_trampoline<
            P: IsA<Keypad>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letters-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letters_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-spacing")]
    fn connect_row_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_spacing_trampoline<P: IsA<Keypad>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::row-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_row_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "start-action")]
    fn connect_start_action_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_action_trampoline<P: IsA<Keypad>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::start-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_start_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "symbols-visible")]
    fn connect_symbols_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_symbols_visible_trampoline<
            P: IsA<Keypad>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyKeypad,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Keypad::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::symbols-visible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_symbols_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Keypad>> KeypadExt for O {}

impl fmt::Display for Keypad {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Keypad")
    }
}
