% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\docType{methods}
\name{db-meta}
\alias{db-meta}
\alias{dbGetException,MySQLConnection-method}
\alias{dbGetInfo,MySQLConnection-method}
\alias{dbListResults,MySQLConnection-method}
\alias{show,MySQLConnection-method}
\alias{summary,MySQLConnection-method}
\title{Database interface meta-data}
\usage{
\S4method{dbGetInfo}{MySQLConnection}(dbObj, what = "", ...)

\S4method{dbListResults}{MySQLConnection}(conn, ...)

\S4method{summary}{MySQLConnection}(object, verbose = FALSE, ...)

\S4method{dbGetException}{MySQLConnection}(conn, ...)

\S4method{show}{MySQLConnection}(object)
}
\arguments{
\item{what}{optional}

\item{...}{Other arguments for compatibility with generic.}

\item{conn, dbObj, object}{MySQLConnection object.}

\item{verbose}{If \code{TRUE}, add extra info.}
}
\description{
Database interface meta-data
}
\examples{
if (mysqlHasDefault()) {
  con <- dbConnect(RMySQL::MySQL(), dbname = "test")

  summary(con)

  dbGetInfo(con)
  dbListResults(con)
  dbListTables(con)

  dbDisconnect(con)
}
}

