#ifndef _RHEOLEF_GEO_HEADER_H
#define _RHEOLEF_GEO_HEADER_H
//
// i/o for geo header file format version 3
//
#include "rheolef/diststream.h"
#include "rheolef/reference_element.h"
#include "rheolef/space_constant.h"

namespace rheolef {

struct geo_header {
  typedef size_t                          size_type;
  typedef space_constant::coordinate_type coordinate_type;
  geo_header();
// accessor:
  bool need_upgrade() const;
// data:
  size_type dimension;
  size_type map_dimension;
  coordinate_type sys_coord;
  size_type order;
  size_type dis_size_by_variant   [reference_element::max_variant];
  size_type dis_size_by_dimension [4];
};
inline
geo_header::geo_header()
  : dimension(0),
    sys_coord(space_constant::cartesian),
    order(1)
{
  std::fill (dis_size_by_variant,   dis_size_by_variant + reference_element::max_variant, 0);
  std::fill (dis_size_by_dimension, dis_size_by_dimension + 4, 0);
}
idiststream& operator>> (idiststream& ips, geo_header& h);
odiststream& operator<< (odiststream& ops, const geo_header& h);

} // namespace rheolef {
#endif // _RHEOLEF_GEO_HEADER_H
