% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{revision_content}
\alias{revision_content}
\title{Retrieves MediaWiki revisions}
\usage{
revision_content(language = NULL, project = NULL, domain = NULL,
  revisions, properties = c("content", "ids", "flags", "timestamp", "user",
  "userid", "size", "sha1", "contentmodel", "comment", "parsedcomment", "tags"),
  clean_response = FALSE, ...)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{revisions}{The revision IDs of each desired revision.}

\item{properties}{Properties you're trying to retrieve about that revision, should you want to;
options include "ids" (the revision ID of the revision...which is pointless),
"flags" (whether the revision was 'minor' or not), "timestamp" (the timestamp of the revision),
"user" (the username of the person who made that revision), "userid"
(the userID of the person who made the revision),
"size" (the size, in uncompressed bytes, of the revision), "sha1" (the SHA-1 hash of
the revision text), "contentmodel" (the content model of the page, usually "wikitext"),
"comment" (the revision summary associated with the revision), "parsedcomment" (the same,
but parsed, generating HTML from any wikitext in that comment), "tags" (any tags associated
with the revision) and "flagged" (the revision's status under Flagged Revisions).}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
Retrieves the content of a provided list of revisions from whichever MediaWiki instance you're
querying. Returns as wikimarkup.
}
\examples{

#Revision content from a Wikimedia project
wp_content <- revision_content("en","wikipedia", revisions = 552373187)

#Revision content from a non-Wikimedia project
rw_content <- revision_content(domain = "rationalwiki.org", revisions = 88616)
}
\seealso{
\code{\link{revision_diff}} for diffs between revisions,
and \code{\link{page_content}} for the content a specific page currently has.
}

