% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tukey.R
\name{tukeyTexture}
\alias{tukeyTexture}
\title{Generate random positions based on Tukey texture algorithm}
\usage{
tukeyTexture(x, jitter = TRUE, thin = FALSE, hollow = FALSE,
  delta = diff(stats::quantile(x, c(0.25, 0.75))) * 0.03)
}
\arguments{
\item{x}{the points to be jittered. really only used to calculate length}

\item{jitter}{if TRUE add random jitter to each point}

\item{thin}{if TRUE then push points to the center in thin regions}

\item{hollow}{if TRUE then expand points outward to avoid ``hollowness''}

\item{delta}{a ``reasonably small value'' used in edge straightening and thinning}
}
\value{
a vector of length length(x) giving displacements for each corresponding point in x
}
\description{
Generate partly random, partly constrained lateral displacements based on Tukey texture algorithm from Tukey and Tukey 1990
}
\examples{
x<-rnorm(200)
plot(tukeyTexture(x),x)
x<-1:100
plot(tukeyTexture(x),x)
plot(tukeyTexture(log10(counties$landArea),TRUE,TRUE),log10(counties$landArea),cex=.25)
}
