\name{DanishWelfare}
\alias{DanishWelfare}
\docType{data}
\title{Danish Welfare Study Data}
\description{
  Data from the Danish Welfare Study.
}
\usage{data("DanishWelfare")}
\format{
  A data frame with 180 observations and 5 variables.
  \describe{
    \item{Freq}{frequency.}
    \item{Alcohol}{factor indicating daily alcohol consumption: less
      than 1 unit (<1), 1-2 units (1-2) or more than 2 units (>2).
      1 unit is approximately 1 bottle of beer or 4cl 40\% alcohol.}
    \item{Income}{factor indicating income group in 1000 DKK (0-50,
      50-100, 100-150, >150).} 
    \item{Status}{factor indicating marriage status (Widow, Married,
      Unmarried).}
    \item{Urban}{factor indicating urbanization: Copenhagen
      (Copenhagen), Suburbian Copenhagen (SubCopenhagen), three largest
      cities (LargeCity), other cities (City), countryside (Country).}
  }
}

\references{
  E. B. Andersen (1991),
  \emph{The Statistical Analysis of Categorical Data}.
  2nd edition.
  Springer-Verlag, Berlin.
}

\source{
  E. B. Andersen (1991),
  The Statistical Analysis of Categorical Data, page 205.
}
\examples{
data("DanishWelfare")
ftable(xtabs(Freq ~ ., data = DanishWelfare))
}

\keyword{datasets}
