% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{auto_resolve_theme}
\alias{auto_resolve_theme}
\title{Resolve auto values}
\usage{
auto_resolve_theme(theme)
}
\arguments{
\item{theme}{a \code{thematic_theme()} object.}
}
\value{
The \code{theme} object with resolved \code{'auto'} values.
}
\description{
Resolves \code{'auto'} values based on the current execution environment
and configuration (i.e., \code{\link[=auto_config_get]{auto_config_get()}}).
}
\examples{

old_config <- auto_config_set(auto_config(bg = "black", fg = "white"))

# Resolving auto values in local theme objects
theme <- thematic_theme()
theme[c("bg", "fg")]
theme <- auto_resolve_theme(theme)
theme[c("bg", "fg")]

# By default, auto values are resolved when accessing
# global theme options
thematic_on()
thematic_get_option("bg", resolve = FALSE)
thematic_get_option("bg")
thematic_off()

auto_config_set(old_config)

}
\seealso{
\code{\link[=auto_config_set]{auto_config_set()}}
}
