% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{auto_config}
\alias{auto_config}
\alias{auto_config_set}
\alias{auto_config_get}
\title{Configure auto theming behavior}
\usage{
auto_config(
  bg = NULL,
  fg = NULL,
  accent = NULL,
  font = NULL,
  priority = c("shiny", "config", "bslib", "rstudio")
)

auto_config_set(config)

auto_config_get()
}
\arguments{
\item{bg}{a background color.}

\item{fg}{a foreground color.}

\item{accent}{a color for making certain graphical markers 'stand out'
(e.g., the fitted line color for \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}).
Can be 2 colors for lattice (stroke vs fill accent).}

\item{font}{a \code{\link[=font_spec]{font_spec()}} object. If missing, font defaults are not altered.}

\item{priority}{the order of priority to use when resolving auto values.
Possible values include:
\itemize{
\item \code{"shiny"}: use \code{\link[shiny:getCurrentOutputInfo]{shiny::getCurrentOutputInfo()}} values (if any) to resolve auto values.
\item \code{"config"}: use the values provided to this function (if any) to resolve auto values.
\item \code{"bslib"}: use \code{bslib::bs_get_variables()} values (if any)
to resolve auto values (only relevant when knitr is in progress).
\item \code{"rstudio"}: use \code{\link[rstudioapi:getThemeInfo]{rstudioapi::getThemeInfo()}} values (if any) to resolve auto values.
}}

\item{config}{a \code{auto_config()} object.}
}
\value{
a config (list-like) object.
}
\description{
Auto theming is really only "guaranteed" to work inside of a \strong{shiny}
runtime. In any other context, auto theming is based on a set of heuristics,
which won't fit every use case. As a workaround, this function allows one
to configure both a preference for specific auto values (e.g., \code{bg}, \code{fg}, etc)
as well as the \code{priority} that certain information should receive.
}
\details{
Configuring auto theming behavior is especially useful
for developers of a custom rmarkdown output document that wish to
have more sensible auto theming behavior for users of the document.
In particular, by having the output document call \code{auto_config_set()}
"pre-knit" with the document's styling preferences (and restoring the
old defaults "post-knit"), users of the output document can then simply
call \code{thematic_on()} within their document to use those preferences.

Call this function with no arguments to get the current auto defaults.
}
\examples{
old_config <- auto_config_set(auto_config("black", "white"))
thematic_with_theme(
  thematic_theme(), {
    plot(1:10, 1:10)
 })
auto_config_set(old_config)
}
