% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_get.R
\name{config_get}
\alias{config_get}
\title{Get Solr configuration details}
\usage{
config_get(conn, name, what = NULL, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core. If not given, all cores.}

\item{what}{(character) What you want to look at. One of solrconfig or
schema. Default: solrconfig}

\item{wt}{(character) One of json (default) or xml. Data type returned.
If json, uses \code{\link[jsonlite]{fromJSON}} to parse. If xml, uses
\code{\link[xml2]{read_xml}} to parse.}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list, \code{xml_document}, or character
}
\description{
Get Solr configuration details
}
\details{
Note that if \code{raw=TRUE}, \code{what} is ignored. That is,
you get all the data when \code{raw=TRUE}.
}
\examples{
\dontrun{
# start Solr with Cloud mode via the schemaless eg: bin/solr -e cloud
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
(conn <- SolrClient$new())

# all config settings
conn$config_get("gettingstarted")

# just znodeVersion
conn$config_get("gettingstarted", "znodeVersion")

# just znodeVersion
conn$config_get("gettingstarted", "luceneMatchVersion")

# just updateHandler
conn$config_get("gettingstarted", "updateHandler")

# just updateHandler
conn$config_get("gettingstarted", "requestHandler")

## Get XML
conn$config_get("gettingstarted", wt = "xml")
conn$config_get("gettingstarted", "updateHandler", wt = "xml")
conn$config_get("gettingstarted", "requestHandler", wt = "xml")

## Raw data - what param ignored when raw=TRUE
conn$config_get("gettingstarted", raw = TRUE)
}
}
