% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R, R/join.R
\name{tidyverse}
\alias{tidyverse}
\alias{filter.sf}
\alias{arrange.sf}
\alias{group_by.sf}
\alias{ungroup.sf}
\alias{rowwise.sf}
\alias{mutate.sf}
\alias{transmute.sf}
\alias{select.sf}
\alias{rename.sf}
\alias{rename_with.sf}
\alias{slice.sf}
\alias{summarise.sf}
\alias{summarise}
\alias{distinct.sf}
\alias{gather.sf}
\alias{pivot_longer.sf}
\alias{pivot_wider.sf}
\alias{spread.sf}
\alias{sample_n.sf}
\alias{sample_frac.sf}
\alias{group_split.sf}
\alias{nest.sf}
\alias{separate.sf}
\alias{separate_rows.sf}
\alias{unite.sf}
\alias{unnest.sf}
\alias{drop_na.sf}
\alias{inner_join.sf}
\alias{left_join.sf}
\alias{right_join.sf}
\alias{full_join.sf}
\alias{semi_join.sf}
\alias{anti_join.sf}
\title{Tidyverse methods for sf objects}
\usage{
filter.sf(.data, ..., .dots)

arrange.sf(.data, ..., .dots)

group_by.sf(.data, ..., add = FALSE)

ungroup.sf(x, ...)

rowwise.sf(x, ...)

mutate.sf(.data, ..., .dots)

transmute.sf(.data, ..., .dots)

select.sf(.data, ...)

rename.sf(.data, ...)

rename_with.sf(.data, .fn, .cols, ...)

slice.sf(.data, ..., .dots)

summarise.sf(.data, ..., .dots, do_union = TRUE, is_coverage = FALSE)

distinct.sf(.data, ..., .keep_all = FALSE)

gather.sf(
  data,
  key,
  value,
  ...,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)

pivot_longer.sf(
  data,
  cols,
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL,
  ...
)

pivot_wider.sf(
  data,
  ...,
  id_cols = NULL,
  id_expand = FALSE,
  names_from = name,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE,
  names_repair = "check_unique",
  values_from = value,
  values_fill = NULL,
  values_fn = NULL,
  unused_fn = NULL
)

spread.sf(
  data,
  key,
  value,
  fill = NA,
  convert = FALSE,
  drop = TRUE,
  sep = NULL
)

sample_n.sf(tbl, size, replace = FALSE, weight = NULL, .env = parent.frame())

sample_frac.sf(
  tbl,
  size = 1,
  replace = FALSE,
  weight = NULL,
  .env = parent.frame()
)

group_split.sf(.tbl, ..., .keep = TRUE)

nest.sf(.data, ...)

separate.sf(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)

separate_rows.sf(data, ..., sep = "[^[:alnum:]]+", convert = FALSE)

unite.sf(data, col, ..., sep = "_", remove = TRUE)

unnest.sf(data, ..., .preserve = NULL)

drop_na.sf(x, ...)

inner_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

anti_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)
}
\arguments{
\item{.data}{data object of class \link{sf}}

\item{...}{other arguments}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{add}{see corresponding function in dplyr}

\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{.fn, .cols}{see original docs}

\item{do_union}{logical; in case \code{summary} does not create a geometry column, should geometries be created by unioning using \link{st_union}, or simply by combining using \link{st_combine}? Using \link{st_union} resolves internal boundaries, but in case of unioning points, this will likely change the order of the points; see Details.}

\item{is_coverage}{logical; if \code{do_union} is \code{TRUE}, use an optimized algorithm for features that form a polygonal coverage (have no overlaps)}

\item{.keep_all}{see corresponding function in dplyr}

\item{data}{see original function docs}

\item{key}{see original function docs}

\item{value}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see \link[tidyr]{separate_rows}}

\item{factor_key}{see original function docs}

\item{cols}{see original function docs}

\item{names_to, names_pattern, names_ptypes, names_transform}{see \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}}

\item{names_prefix, names_sep, names_repair}{see original function docs.}

\item{values_to, values_drop_na, values_ptypes, values_transform}{See \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}}

\item{id_cols, id_expand, names_from, names_sort, names_glue, names_vary, names_expand}{see \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}}

\item{values_from, values_fill, values_fn, unused_fn}{see \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see \link[tidyr]{separate_rows}}

\item{tbl}{see original function docs}

\item{size}{see original function docs}

\item{replace}{see original function docs}

\item{weight}{see original function docs}

\item{.env}{see original function docs}

\item{.tbl}{see original function docs}

\item{.keep}{see original function docs}

\item{col}{see \link[tidyr]{separate}}

\item{into}{see \link[tidyr]{separate}}

\item{remove}{see \link[tidyr]{separate}}

\item{extra}{see \link[tidyr]{separate}}

\item{.preserve}{see \link[tidyr:nest]{unnest}}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}
}
\value{
an object of class \link{sf}
}
\description{
Tidyverse methods for sf objects. Geometries are sticky, use \link{as.data.frame} to let \code{dplyr}'s own methods drop them.
Use these methods after loading the tidyverse package with the generic (or after loading package tidyverse).
}
\details{
\code{select} keeps the geometry regardless whether it is selected or not; to deselect it, first pipe through \code{as.data.frame} to let dplyr's own \code{select} drop it.

In case one or more of the arguments (expressions) in the \code{summarise} call creates a geometry list-column, the first of these will be the (active) geometry of the returned object. If this is not the case, a geometry column is created, depending on the value of \code{do_union}.

In case \code{do_union} is \code{FALSE}, \code{summarise} will simply combine geometries using \link{c.sfg}. When polygons sharing a boundary are combined, this leads to geometries that are invalid; see for instance \url{https://github.com/r-spatial/sf/issues/681}.

\code{distinct} gives distinct records for which all attributes and geometries are distinct; \link{st_equals} is used to find out which geometries are distinct.

\code{nest} assumes that a simple feature geometry list-column was among the columns that were nested.
}
\examples{
if (require(dplyr, quietly = TRUE)) {
 nc = read_sf(system.file("shape/nc.shp", package="sf"))
 nc \%>\% filter(AREA > .1) \%>\% plot()
 # plot 10 smallest counties in grey:
 st_geometry(nc) \%>\% plot()
 nc \%>\% select(AREA) \%>\% arrange(AREA) \%>\% slice(1:10) \%>\% plot(add = TRUE, col = 'grey')
 title("the ten counties with smallest area")
 nc2 <- nc \%>\% mutate(area10 = AREA/10)
 nc \%>\% slice(1:2)
}
# plot 10 smallest counties in grey:
if (require(dplyr, quietly = TRUE)) {
 st_geometry(nc) \%>\% plot()
 nc \%>\% select(AREA) \%>\% arrange(AREA) \%>\% slice(1:10) \%>\% plot(add = TRUE, col = 'grey')
 title("the ten counties with smallest area")
}
if (require(dplyr, quietly = TRUE)) {
 nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
 nc \%>\% group_by(area_cl) \%>\% class()
}
if (require(dplyr, quietly = TRUE)) {
 nc2 <- nc \%>\% mutate(area10 = AREA/10)
}
if (require(dplyr, quietly = TRUE)) {
 nc \%>\% transmute(AREA = AREA/10) \%>\% class()
}
if (require(dplyr, quietly = TRUE)) {
 nc \%>\% select(SID74, SID79) \%>\% names()
 nc \%>\% select(SID74, SID79) \%>\% class()
}
if (require(dplyr, quietly = TRUE)) {
 nc2 <- nc \%>\% rename(area = AREA)
}
if (require(dplyr, quietly = TRUE)) {
 nc \%>\% slice(1:2)
}
if (require(dplyr, quietly = TRUE)) {
 nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
 nc.g <- nc \%>\% group_by(area_cl)
 nc.g \%>\% summarise(mean(AREA))
 nc.g \%>\% summarise(mean(AREA)) \%>\% plot(col = grey(3:6 / 7))
 nc \%>\% as.data.frame \%>\% summarise(mean(AREA))
}
if (require(dplyr, quietly = TRUE)) {
 nc[c(1:100, 1:10), ] \%>\% distinct() \%>\% nrow()
}
if (require(tidyr, quietly = TRUE) && require(dplyr, quietly = TRUE) && "geometry" \%in\% names(nc)) {
 nc \%>\% select(SID74, SID79) \%>\% gather("VAR", "SID", -geometry) \%>\% summary()
}
if (require(tidyr, quietly = TRUE) && require(dplyr, quietly = TRUE) && "geometry" \%in\% names(nc)) {
 nc$row = 1:100 # needed for spread to work
 nc \%>\% select(SID74, SID79, geometry, row) \%>\%
	gather("VAR", "SID", -geometry, -row) \%>\%
	spread(VAR, SID) \%>\% head()
}
if (require(tidyr, quietly = TRUE) && require(dplyr, quietly = TRUE)) {
 storms.sf = st_as_sf(storms, coords = c("long", "lat"), crs = 4326)
 x <- storms.sf \%>\% group_by(name, year) \%>\% nest
 trs = lapply(x$data, function(tr) st_cast(st_combine(tr), "LINESTRING")[[1]]) \%>\%
    st_sfc(crs = 4326)
 trs.sf = st_sf(x[,1:2], trs)
 plot(trs.sf["year"], axes = TRUE)
}
}
