% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{BlackAndWhite}
\alias{BlackAndWhite}
\alias{BlueAndRed}
\alias{CustomPalette}
\alias{PurpleAndYellow}
\title{Create a custom color palette}
\usage{
BlackAndWhite(mid = NULL, k = 50)

BlueAndRed(k = 50)

CustomPalette(low = "white", high = "red", mid = NULL, k = 50)

PurpleAndYellow(k = 50)
}
\arguments{
\item{mid}{middle color. Optional.}

\item{k}{number of steps (colors levels) to include between low and high values}

\item{low}{low color}

\item{high}{high color}
}
\value{
A color palette for plotting
}
\description{
Creates a custom color palette based on low, middle, and high color values
}
\examples{
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
plot(df, col = BlackAndWhite())

df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
plot(df, col = BlueAndRed())

myPalette <- CustomPalette()
myPalette

df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
plot(df, col = PurpleAndYellow())

}
\concept{visualization}
