% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{HVFInfo.SCTAssay}
\alias{HVFInfo.SCTAssay}
\title{Get Variable Feature Information}
\usage{
\method{HVFInfo}{SCTAssay}(object, selection.method, status = FALSE, ...)
}
\arguments{
\item{object}{An object}

\item{selection.method}{Which method to pull. For \code{HVFInfo} and
\code{VariableFeatures}, choose one from one of the
following:
\itemize{
 \item \dQuote{vst}
 \item \dQuote{sctransform} or \dQuote{sct}
 \item \dQuote{mean.var.plot}, \dQuote{dispersion}, \dQuote{mvp}, or
  \dQuote{disp}
}
For \code{SVFInfo} and \code{SpatiallyVariableFeatures}, choose from:
\itemize{
 \item \dQuote{markvariogram}
 \item \dQuote{moransi}
}}

\item{status}{Add variable status to the resulting data frame}

\item{...}{Arguments passed to other methods}
}
\description{
Get variable feature information from \code{\link{SCTAssay}} objects
}
\examples{
# Get the HVF info directly from an SCTAssay object
pbmc_small <- SCTransform(pbmc_small)
HVFInfo(pbmc_small[["SCT"]], selection.method = 'sct')[1:5, ]

}
\seealso{
\code{\link[SeuratObject]{HVFInfo}}
}
