% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{session}
\alias{session}
\alias{is.session}
\alias{session_jump_to}
\alias{session_follow_link}
\alias{session_back}
\alias{session_forward}
\alias{session_history}
\alias{session_submit}
\title{Simulate a session in web browser}
\usage{
session(url, ...)

is.session(x)

session_jump_to(x, url, ...)

session_follow_link(x, i, css, xpath, ...)

session_back(x)

session_forward(x)

session_history(x)

session_submit(x, form, submit = NULL, ...)
}
\arguments{
\item{url}{A URL, either relative or absolute, to navigate to.}

\item{...}{Any additional httr config to use throughout the session.}

\item{x}{A session.}

\item{i}{A integer to select the ith link or a string to match the
first link containing that text (case sensitive).}

\item{css, xpath}{Elements to select. Supply one of \code{css} or \code{xpath}
depending on whether you want to use a CSS selector or XPath 1.0
expression.}

\item{form}{An \link{html_form} to submit}

\item{submit}{Which button should be used to submit the form?
\itemize{
\item \code{NULL}, the default, uses the first button.
\item A string selects a button by its name.
\item A number selects a button using its relative position.
}}
}
\description{
This set of functions allows you to simulate a user interacting with a
website, using forms and navigating from page to page.
\itemize{
\item Create a session with \code{session(url)}
\item Navigate to a specified url with \code{session_jump_to()}, or follow a link on the
page with \code{session_follow_link()}.
\item Submit an \link{html_form} with \code{session_submit()}.
\item View the history with \code{session_history()} and navigate back and forward
with \code{session_back()} and \code{session_forward()}.
\item Extract page contents with \code{\link[=html_element]{html_element()}} and \code{\link[=html_elements]{html_elements()}}, or get the
complete HTML document with \code{\link[=read_html]{read_html()}}.
\item Inspect the HTTP response with \code{\link[httr:cookies]{httr::cookies()}}, \code{\link[httr:headers]{httr::headers()}},
and \code{\link[httr:status_code]{httr::status_code()}}.
}
}
\examples{
s <- session("http://hadley.nz")
s \%>\%
  session_jump_to("hadley-wickham.jpg") \%>\%
  session_jump_to("/") \%>\%
  session_history()

s \%>\%
  session_jump_to("hadley-wickham.jpg") \%>\%
  session_back() \%>\%
  session_history()

\donttest{
s \%>\%
  session_follow_link(css = "p a") \%>\%
  html_elements("p")
}
}
