% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalize_input}
\alias{normalize_input}
\title{Normalize input data matrix}
\usage{
normalize_input(X)
}
\arguments{
\item{X}{matrix; Input data matrix with rows as observations and columns as variables/dimensions.}
}
\value{
A numeric matrix of the same dimensions as \code{X} but centred by column and scaled to have a maximum deviation of 1.
}
\description{
Mean centers each column of an input data matrix so that it has a mean of zero.
Scales the entire matrix so that the largest absolute of the centered matrix is equal to unity.
}
\details{
Normalization avoids numerical problems when the coordinates (and thus the distances between observations) are very large.
Directly computing distances on this scale may lead to underflow when computing the probabilities in the t-SNE algorithm.
Rescaling the input values mitigates these problems to some extent.
}
\examples{
iris_unique <- unique(iris) # Remove duplicates
iris_matrix <- as.matrix(iris_unique[,1:4])
X <- normalize_input(iris_matrix)
colMeans(X)
range(X)
}
\author{
Aaron Lun
}
