% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{reverse_splits}
\alias{reverse_splits}
\alias{reverse_splits.default}
\alias{reverse_splits.permutations}
\alias{reverse_splits.perm_split}
\alias{reverse_splits.rsplit}
\alias{reverse_splits.rset}
\title{Reverse the analysis and assessment sets}
\usage{
reverse_splits(x, ...)

\method{reverse_splits}{default}(x, ...)

\method{reverse_splits}{permutations}(x, ...)

\method{reverse_splits}{perm_split}(x, ...)

\method{reverse_splits}{rsplit}(x, ...)

\method{reverse_splits}{rset}(x, ...)
}
\arguments{
\item{x}{An \code{rset} or \code{rsplit} object.}

\item{...}{Not currently used.}
}
\value{
An object of the same class as \code{x}
}
\description{
This functions "swaps" the analysis and assessment sets of either a single
\code{rsplit} or all \code{rsplit}s in the \code{splits} column of an \code{rset} object.
}
\examples{
set.seed(123)
starting_splits <- vfold_cv(mtcars, v = 3)
reverse_splits(starting_splits)
reverse_splits(starting_splits$splits[[1]])

}
