% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{step_slice}
\alias{step_slice}
\alias{tidy.step_slice}
\title{Filter rows by position using dplyr}
\usage{
step_slice(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("slice")
)

\method{tidy}{step_slice}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{Integer row values. See
\code{\link[dplyr:slice]{dplyr::slice()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{Quosure of values given by \code{...}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_slice} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which
contains the filterint indices.
}
\description{
\code{step_slice} creates a \emph{specification} of a recipe step
that will filter rows using \code{\link[dplyr:slice]{dplyr::slice()}}.
}
\details{
When an object in the user's global environment is
referenced in the expression defining the new variable(s),
it is a good idea to use quasiquotation (e.g. \verb{!!})
to embed the value of the object in the expression (to
be portable between sessions). See the examples.
}
\examples{
rec <- recipe( ~ ., data = iris) \%>\%
  step_slice(1:3)

prepped <- prep(rec, training = iris \%>\% slice(1:75))
tidy(prepped, number = 1)

library(dplyr)

dplyr_train <-
  iris \%>\%
  as_tibble() \%>\%
  slice(1:75) \%>\%
  slice(1:3)

rec_train <- juice(prepped)
all.equal(dplyr_train, rec_train)

dplyr_test <-
  iris \%>\%
  as_tibble() \%>\%
  slice(76:150) \%>\%
  slice(1:3)
rec_test <- bake(prepped, iris \%>\% slice(76:150))
all.equal(dplyr_test, rec_test)

# Embedding the integer expression (or vector) into the
# recipe:

keep_rows <- 1:6

qq_rec <-
  recipe( ~ ., data = iris) \%>\%
  # Embed `keep_rows` in the call using !!
  step_slice(!!keep_rows) \%>\%
  prep(training = iris)

tidy(qq_rec, number = 1)
}
\concept{preprocessing}
\keyword{datagen}
