% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newvalues.R
\name{check_new_values}
\alias{check_new_values}
\title{Check for New Values}
\usage{
check_new_values(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  ignore_NA = TRUE,
  values = NULL,
  skip = FALSE,
  id = rand_id("new_values")
)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this check. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this check since no new variables are
created.}

\item{trained}{A logical for whether the selectors in \code{...}
have been resolved by \code{\link[=prep]{prep()}}.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the terms argument.}

\item{ignore_NA}{A logical that indicates if we should consider missing
values as value or not. Defaults to \code{TRUE}.}

\item{values}{A named list with the allowed values.
This is \code{NULL} until computed by prep.recipe().}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this check to identify it.}
}
\value{
An updated version of \code{recipe} with the new check added to the
sequence of any existing operations.
}
\description{
\code{check_new_values} creates a \emph{specification} of a recipe
operation that will check if variables contain new values.
}
\details{
This check will break the \code{bake} function if any of the checked
columns does contain values it did not contain when \code{prep} was called
on the recipe. If the check passes, nothing is changed to the data.

When you \code{\link[=tidy]{tidy()}} this check, a tibble with columns \code{terms} (the
selectors or variables selected) is returned.
}
\examples{
library(modeldata)
data(credit_data)

# If the test passes, `new_data` is returned unaltered
recipe(credit_data) \%>\%
  check_new_values(Home) \%>\%
  prep() \%>\%
  bake(new_data = credit_data)

# If `new_data` contains values not in `x` at the `prep()` function,
# the `bake()` function will break.
\dontrun{
recipe(credit_data \%>\% dplyr::filter(Home != "rent")) \%>\%
  check_new_values(Home) \%>\%
  prep() \%>\%
  bake(new_data = credit_data)
}

# By default missing values are ignored, so this passes.
recipe(credit_data \%>\% dplyr::filter(!is.na(Home))) \%>\%
  check_new_values(Home) \%>\%
  prep() \%>\%
  bake(credit_data)

# Use `ignore_NA = FALSE` if you consider missing values  as a value,
# that should not occur when not observed in the train set.
\dontrun{
recipe(credit_data \%>\% dplyr::filter(!is.na(Home))) \%>\%
  check_new_values(Home, ignore_NA = FALSE) \%>\%
  prep() \%>\%
  bake(credit_data)
}
}
\seealso{
Other checks: 
\code{\link{check_class}()},
\code{\link{check_cols}()},
\code{\link{check_missing}()},
\code{\link{check_range}()}
}
\concept{checks}
