% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind}
\alias{bind}
\alias{bind_cols}
\alias{bind_rows}
\title{Efficiently bind multiple \code{data.frame}s by row and column}
\usage{
bind_cols(...)

bind_rows(..., .id = NULL)
}
\arguments{
\item{...}{\code{data.frame}s to combine.

Each argument can either be a \code{data.frame}, a \code{list} that could be a \code{data.frame}, or a \code{list} of \code{data.frame}s.

When row-binding, columns are matched by name, and any missing columns will be filled with \code{NA}.

When column-binding, rows are matched by position, so all \code{data.frame}s must have the same number of rows. To match
by value, not position, see \link{mutate_joins}.}

\item{.id}{\code{character(1)}. \code{data.frame} identifier.

When \code{.id} is supplied, a new column of identifiers is created to link each row to its original \code{data.frame}. The
labels are taken from the named arguments to \code{bind_rows()}. When a \code{list} of \code{data.frame}s is supplied, the labels
are taken from the names of the \code{list}. If no names are found a numeric sequence is used instead.}
}
\description{
Efficiently bind multiple \code{data.frame}s by row and column
}
\examples{
one <- mtcars[1:4, ]
two <- mtcars[9:12, ]

# You can supply data frames as arguments:
bind_rows(one, two)

# The contents of lists are spliced automatically:
bind_rows(list(one, two))
bind_rows(split(mtcars, mtcars$cyl))
bind_rows(list(one, two), list(two, one))

# In addition to data frames, you can supply vectors. In the rows
# direction, the vectors represent rows and should have inner
# names:
bind_rows(
  c(a = 1, b = 2),
  c(a = 3, b = 4)
)

# You can mix vectors and data frames:
bind_rows(
  c(a = 1, b = 2),
  data.frame(a = 3:4, b = 5:6),
  c(a = 7, b = 8)
)

# When you supply a column name with the `.id` argument, a new
# column is created to link each row to its original data frame
bind_rows(list(one, two), .id = "id")
bind_rows(list(a = one, b = two), .id = "id")
bind_rows("group 1" = one, "group 2" = two, .id = "groups")

\dontrun{
# Rows need to match when column-binding
bind_cols(data.frame(x = 1:3), data.frame(y = 1:2))

# even with 0 columns
bind_cols(data.frame(x = 1:3), data.frame())
}

bind_cols(one, two)
bind_cols(list(one, two))

}
