% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyDat.R
\name{phyDat}
\alias{phyDat}
\alias{as.phyDat.character}
\alias{as.phyDat.data.frame}
\alias{as.phyDat.matrix}
\alias{as.MultipleAlignment}
\alias{as.MultipleAlignment.phyDat}
\alias{cbind.phyDat}
\alias{c.phyDat}
\alias{acgt2ry}
\alias{removeUndeterminedSites}
\alias{phyDat2MultipleAlignment}
\alias{dna2codon}
\alias{codon2dna}
\alias{as.phyDat}
\alias{as.phyDat.factor}
\alias{as.phyDat.DNAbin}
\alias{as.phyDat.alignment}
\alias{phyDat2alignment}
\alias{as.phyDat.MultipleAlignment}
\alias{as.character.phyDat}
\alias{as.data.frame.phyDat}
\alias{as.DNAbin.phyDat}
\alias{as.AAbin.phyDat}
\alias{write.phyDat}
\alias{read.phyDat}
\alias{baseFreq}
\alias{subset.phyDat}
\alias{unique.phyDat}
\alias{allSitePattern}
\alias{genlight2phyDat}
\alias{image.phyDat}
\title{Conversion among Sequence Formats}
\usage{
phyDat(data, type = "DNA", levels = NULL, return.index = TRUE, ...)

dna2codon(x)

codon2dna(x)

as.phyDat(x, ...)

\method{as.phyDat}{factor}(x, ...)

\method{as.phyDat}{DNAbin}(x, ...)

\method{as.phyDat}{alignment}(x, type = "DNA", ...)

phyDat2alignment(x)

\method{as.phyDat}{MultipleAlignment}(x, ...)

\method{as.character}{phyDat}(x, allLevels = TRUE, ...)

\method{as.data.frame}{phyDat}(x, ...)

\method{as.DNAbin}{phyDat}(x, ...)

\method{as.AAbin}{phyDat}(x, ...)

write.phyDat(x, file, format = "phylip", colsep = "", nbcol = -1, ...)

read.phyDat(file, format = "phylip", type = "DNA", ...)

baseFreq(obj, freq = FALSE, all = FALSE, drop.unused.levels = FALSE)

\method{subset}{phyDat}(x, subset, select, site.pattern = TRUE, ...)

\method{unique}{phyDat}(x, incomparables = FALSE, identical = TRUE, ...)

allSitePattern(n, levels = c("a", "c", "g", "t"), names = NULL)

genlight2phyDat(x, ambiguity = NA)

\method{image}{phyDat}(x, ...)
}
\arguments{
\item{data}{An object containing sequences.}

\item{type}{Type of sequences ("DNA", "AA", "CODON" or "USER").}

\item{levels}{Level attributes.}

\item{return.index}{If TRUE returns a index of the site patterns.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object containing sequences.}

\item{allLevels}{return original data.}

\item{file}{A file name.}

\item{format}{File format of the sequence alignment (see details).  Several
popular formats are supported: "phylip", "interleaved", "sequential",
"clustal", "fasta" or "nexus", or any unambiguous abbreviation of these.}

\item{colsep}{a character used to separate the columns (a single space by
default).}

\item{nbcol}{a numeric specifying the number of columns per row (-1 by
default); may be negative implying that the nucleotides are printed on a
single line.}

\item{obj}{as object of class phyDat}

\item{freq}{logical, if 'TRUE', frequencies or counts are returned otherwise
proportions}

\item{all}{all a logical; if all = TRUE, all counts of bases, ambiguous
codes, missing data, and alignment gaps are returned as defined in the
contrast.}

\item{drop.unused.levels}{logical, drop unused levels}

\item{subset}{a subset of taxa.}

\item{select}{a subset of characters.}

\item{site.pattern}{select site pattern or sites.}

\item{incomparables}{for compatibility with unique.}

\item{identical}{if TRUE (default) sequences have to be identical, if FALSE
sequences are considered duplicates if distance between sequences is zero
(happens frequently with ambiguous sites).}

\item{n}{Number of sequences.}

\item{names}{Names of sequences.}

\item{ambiguity}{character for ambiguous character and no contrast is provided.}
}
\value{
The functions return an object of class \code{phyDat}.
}
\description{
These functions transform several DNA formats into the \code{phyDat} format.
\code{allSitePattern} generates an alignment of all possible site patterns.
}
\details{
If \code{type} "USER" a vector has to be give to \code{levels}. For example
c("a", "c", "g", "t", "-") would create a data object that can be used in
phylogenetic analysis with gaps as fifth state.  There is a more detailed
example for specifying "USER" defined data formats in the vignette
"phangorn-specials".

\code{allSitePattern} returns all possible site patterns and can be useful
in simulation studies. For further details see the vignette
phangorn-specials.

\code{write.phyDat} calls the function write.dna or write.nexus.data and
\code{read.phyDat} calls the function \code{read.dna}, \code{read.aa} or
\code{read.nexus.data} see for more details over there.

You may import data directly with \code{\link[ape]{read.dna}} or
\code{\link[ape]{read.nexus.data}} and convert the data to class phyDat.

The generic function \code{c} can be used to to combine sequences and
\code{unique} to get all unique sequences or unique haplotypes.

\code{acgt2ry} converts a \code{phyDat} object of nucleotides into an binary
ry-coded dataset.
}
\examples{

data(Laurasiatherian)
class(Laurasiatherian)
Laurasiatherian
baseFreq(Laurasiatherian)
baseFreq(Laurasiatherian, all=TRUE)
subset(Laurasiatherian, subset=1:5)
# transform into old ape format
LauraChar <- as.character(Laurasiatherian)
# and back 
Laura <- phyDat(LauraChar)
all.equal(Laurasiatherian, Laura)
allSitePattern(5)

}
\seealso{
\code{\link{DNAbin}}, \code{\link{as.DNAbin}},
\code{\link{read.dna}}, \code{\link{read.aa}}, \code{\link{read.nexus.data}}
and the chapter 1 in the \code{vignette("phangorn-specials",
package="phangorn")} and the example of \code{\link{pmlMix}} for the use of
\code{allSitePattern}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
