% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{formatter_glue_or_sprintf}
\alias{formatter_glue_or_sprintf}
\title{Apply \code{glue} and \code{sprintf}}
\usage{
formatter_glue_or_sprintf(
  msg,
  ...,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)
}
\arguments{
\item{msg}{passed to \code{sprintf} as \code{fmt} or handled as part of \code{...} in \code{glue}}

\item{...}{passed to \code{glue} for the text interpolation}

\item{.logcall}{the logging call being evaluated (useful in formatters and layouts when you want to have access to the raw, unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was called (useful in formatters and layouts to extract the calling function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function where the formatter function will be evaluated and that is used to look up the \code{namespace} as well via \code{logger:::top_env_name}}
}
\value{
character vector
}
\description{
The best of both words: using both formatter functions in your log messages, which can be useful eg if you are migrating from \code{sprintf} formatted log messages to \code{glue} or similar.
}
\details{
Note that this function tries to be smart when passing arguments to \code{glue} and \code{sprintf}, but might fail with some edge cases, and returns an unformatted string.
}
\examples{
\dontrun{
formatter_glue_or_sprintf("{a} + {b} = \%s", a = 2, b = 3, 5)
formatter_glue_or_sprintf("{pi} * {2} = \%s", pi*2)
formatter_glue_or_sprintf("{pi} * {2} = {pi*2}")

formatter_glue_or_sprintf("Hi ", "{c('foo', 'bar')}, did you know that 2*4={2*4}")
formatter_glue_or_sprintf("Hi {c('foo', 'bar')}, did you know that 2*4={2*4}")
formatter_glue_or_sprintf("Hi {c('foo', 'bar')}, did you know that 2*4=\%s", 2*4)
formatter_glue_or_sprintf("Hi \%s, did you know that 2*4={2*4}", c('foo', 'bar'))
formatter_glue_or_sprintf("Hi \%s, did you know that 2*4=\%s", c('foo', 'bar'), 2*4)
}
}
\seealso{
This is a \code{\link{log_formatter}}, for alternatives, see \code{\link{formatter_paste}}, \code{\link{formatter_sprintf}}, \code{\link{formatter_glue_or_sprintf}}, \code{\link{formatter_logging}}, \code{\link{formatter_json}}, \code{\link{formatter_pander}} and \code{\link{skip_formatter}} for marking a string not to apply the formatter on it.
}
