% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-password.R
\name{req_oauth_password}
\alias{req_oauth_password}
\alias{oauth_flow_password}
\title{OAuth with username and password}
\usage{
req_oauth_password(
  req,
  client,
  username,
  password = NULL,
  scope = NULL,
  token_params = list(),
  cache_disk = FALSE,
  cache_key = username
)

oauth_flow_password(
  client,
  username,
  password = NULL,
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{req}{A \link{request}.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{username}{User name.}

\item{password}{Password. You avoid entering the password directly when
calling this function as it will be captured by \code{.Rhistory}. Instead,
leave it unset and the default behaviour will prompt you for it
interactively.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}

\item{cache_disk}{Should the access token be cached on disk? This reduces
the number of times that you need to re-authenticate at the cost of
storing access credentials on disk.

Learn more in \code{vignette("oauth")}}

\item{cache_key}{If you want to cache multiple tokens per app, use this
key to disambiguate them.}
}
\value{
\code{req_oauth_password()} returns a modified HTTP \link{request} that will
use OAuth; \code{oauth_flow_password()} returns an \link{oauth_token}.
}
\description{
This function implements the OAuth \strong{resource owner password flow}, as
defined by \href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.3}{Section 4.3 of RFC 6749}. It allows the user to supply their password
once, exchanging it for an access token that can be cached locally.

Learn more about the overall OAuth authentication flow in \code{vignette("oauth")}.
}
\examples{
req_auth <- function(req) {
  req_oauth_password(req,
    client = oauth_client("example", "https://example.com/get_token"),
    username = "username"
  )
}
if (interactive()) {
  request("https://example.com") |>
    req_auth()
}
}
\seealso{
Other OAuth flows: 
\code{\link{req_oauth_auth_code}()},
\code{\link{req_oauth_bearer_jwt}()},
\code{\link{req_oauth_client_credentials}()},
\code{\link{req_oauth_refresh}()}
}
\concept{OAuth flows}
