% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{req_oauth}
\alias{req_oauth}
\title{OAuth authentication}
\usage{
req_oauth(req, flow, flow_params, cache)
}
\arguments{
\item{req}{A \link{request}.}

\item{flow}{An \code{oauth_flow_} function used to generate the access token.}

\item{flow_params}{Parameters for the flow. This should be a named list
whose names match the argument names of \code{flow}.}

\item{cache}{An object that controls how the token is cached. This should
be a list containing three functions:
\itemize{
\item \code{get()} retrieves the token from the cache, returning \code{NULL} if not
cached yet.
\item \code{set()} saves the token to the cache.
\item \code{clear()} removes the token from the cache
}}
}
\value{
An \link{oauth_token}.
}
\description{
This is a low-level helper for automatically authenticating a request with
an OAuth flow, caching the access token and refreshing it where possible.
You should only need to use this function if you're implementing your own
OAuth flow.
}
\keyword{internal}
