% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate-helpers.R
\name{iterate_with_offset}
\alias{iterate_with_offset}
\alias{iterate_with_cursor}
\alias{iterate_with_link_url}
\title{Iteration helpers}
\usage{
iterate_with_offset(
  param_name,
  start = 1,
  offset = 1,
  resp_pages = NULL,
  resp_complete = NULL
)

iterate_with_cursor(param_name, resp_param_value)

iterate_with_link_url(rel = "next")
}
\arguments{
\item{param_name}{Name of query parameter.}

\item{start}{Starting value.}

\item{offset}{Offset for each page. The default is set to \code{1} so you get
(e.g.) \code{?page=1}, \code{?page=2}, ... If \code{param_name} refers to an element
index (rather than a page index) you'll want to set this to a larger number
so you get (e.g.) \code{?items=20}, \code{?items=40}, ...}

\item{resp_pages}{A callback function that takes a response (\code{resp}) and
returns the total number of pages, or \code{NULL} if unknown. It will only
be called once.}

\item{resp_complete}{A callback function that takes a response (\code{resp})
and returns \code{TRUE} if there are no further pages.}

\item{resp_param_value}{A callback function that takes a response (\code{resp})
and returns the next cursor value. Return \code{NULL} if there are no further
pages.}

\item{rel}{The "link relation type" to use to retrieve the next page.}
}
\description{
These functions are intended for use with the \code{next_req} argument to
\code{\link[=req_perform_iterative]{req_perform_iterative()}}. Each implements iteration for a common
pagination pattern:
\itemize{
\item \code{iterate_with_offset()} increments a query parameter, e.g. \code{?page=1},
\code{?page=2}, or \code{?offset=1}, \code{offset=21}.
\item \code{iterate_with_cursor()} updates a query parameter with the value of a
cursor found somewhere in the response.
\item \code{iterate_with_link_url()} follows the url found in the \code{Link} header.
See \code{resp_link_url()} for more details.
}
}
\examples{
req <- request(example_url()) |>
  req_url_path("/iris") |>
  req_throttle(10) |>
  req_url_query(limit = 50)

# If you don't know the total number of pages in advance, you can
# provide a `resp_complete()` callback
is_complete <- function(resp) {
  length(resp_body_json(resp)$data) == 0
}
resps <- req_perform_iterative(
  req,
  next_req = iterate_with_offset("page_index", resp_complete = is_complete),
  max_reqs = Inf
)

\dontrun{
# Alternatively, if the response returns the total number of pages (or you
# can easily calculate it), you can use the `resp_pages()` callback which
# will generate a better progress bar.

resps <- req_perform_iterative(
  req |> req_url_query(limit = 1),
  next_req = iterate_with_offset(
    "page_index",
    resp_pages = function(resp) resp_body_json(resp)$pages
  ),
  max_reqs = Inf
)
}
}
