% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{builder}
\alias{builder}
\alias{tags}
\alias{p}
\alias{h1}
\alias{h2}
\alias{h3}
\alias{h4}
\alias{h5}
\alias{h6}
\alias{a}
\alias{br}
\alias{div}
\alias{span}
\alias{pre}
\alias{code}
\alias{img}
\alias{strong}
\alias{em}
\alias{hr}
\alias{tag}
\title{Create HTML tags}
\usage{
tags

p(..., .noWS = NULL, .renderHook = NULL)

h1(..., .noWS = NULL, .renderHook = NULL)

h2(..., .noWS = NULL, .renderHook = NULL)

h3(..., .noWS = NULL, .renderHook = NULL)

h4(..., .noWS = NULL, .renderHook = NULL)

h5(..., .noWS = NULL, .renderHook = NULL)

h6(..., .noWS = NULL, .renderHook = NULL)

a(..., .noWS = NULL, .renderHook = NULL)

br(..., .noWS = NULL, .renderHook = NULL)

div(..., .noWS = NULL, .renderHook = NULL)

span(..., .noWS = NULL, .renderHook = NULL)

pre(..., .noWS = NULL, .renderHook = NULL)

code(..., .noWS = NULL, .renderHook = NULL)

img(..., .noWS = NULL, .renderHook = NULL)

strong(..., .noWS = NULL, .renderHook = NULL)

em(..., .noWS = NULL, .renderHook = NULL)

hr(..., .noWS = NULL, .renderHook = NULL)

tag(`_tag_name`, varArgs, .noWS = NULL, .renderHook = NULL)
}
\arguments{
\item{...}{Tag attributes (named arguments) and children (unnamed arguments).
A named argument with an \code{NA} value is rendered as a boolean attributes
(see example). Children may include any combination of:
\itemize{
\item Other tags objects
\item \code{\link[=HTML]{HTML()}} strings
\item \code{\link[=htmlDependency]{htmlDependency()}}s
\item Single-element atomic vectors
\item \code{list()}s containing any combination of the above
}}

\item{.noWS}{Character vector used to omit some of the whitespace that would
normally be written around this tag. Valid options include \code{before},
\code{after}, \code{outside}, \code{after-begin}, and \code{before-end}.
Any number of these options can be specified.}

\item{.renderHook}{A function (or list of functions) to call when the \code{tag} is rendered. This
function should have at least one argument (the \code{tag}) and return anything
that can be converted into tags via \code{\link[=as.tags]{as.tags()}}. Additional hooks may also be
added to a particular \code{tag} via \code{\link[=tagAddRenderHook]{tagAddRenderHook()}}.}

\item{_tag_name}{A character string to use for the tag name.}

\item{varArgs}{List of tag attributes and children.}
}
\value{
A \code{list()} with a \code{shiny.tag} class that can be converted into an
HTML string via \code{as.character()} and saved to a file with \code{save_html()}.
}
\description{
Create an R object that represents an HTML tag. For convenience, common HTML
tags (e.g., \verb{<div>}) can be created by calling for their tag name directly
(e.g., \code{div()}). To create less common HTML5 (or SVG) tags (e.g.,
\verb{<article>}), use the \code{tags} list collection (e.g., \code{tags$article()}). To
create other non HTML/SVG tags, use the lower-level \code{tag()} constructor.
}
\examples{
tags$html(
  tags$head(
    tags$title('My first page')
  ),
  tags$body(
    h1('My first heading'),
    p('My first paragraph, with some ', strong('bold'), ' text.'),
    div(
      id = 'myDiv', class = 'simpleDiv',
      'Here is a div with some attributes.'
     )
  )
)

# html5 <audio> with boolean control attribute
# https://www.w3.org/TR/html5/infrastructure.html#sec-boolean-attributes
tags$audio(
  controls = NA,
  tags$source(
    src = "myfile.wav",
    type = "audio/wav"
  )
)

# suppress the whitespace between tags
tags$span(
  tags$strong("I'm strong", .noWS="outside")
)

}
\seealso{
\code{\link[=tagList]{tagList()}}, \code{\link[=withTags]{withTags()}}, \code{\link[=tagAppendAttributes]{tagAppendAttributes()}}, \code{\link[=tagQuery]{tagQuery()}}
}
