% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{htmlPreserve}
\alias{htmlPreserve}
\alias{extractPreserveChunks}
\alias{restorePreserveChunks}
\title{Preserve HTML regions}
\usage{
htmlPreserve(x)

extractPreserveChunks(strval)

restorePreserveChunks(strval, chunks)
}
\arguments{
\item{x}{A character vector of HTML to be preserved.}

\item{strval}{Input string from which to extract/restore chunks.}

\item{chunks}{The \code{chunks} element of the return value of
\code{extractPreserveChunks}.}
}
\value{
\code{htmlPreserve} returns a single-element character vector with
  "magic" HTML comments surrounding the original text (unless the original
  text was empty, in which case an empty string is returned).

\code{extractPreserveChunks} returns a list with two named elements:
  \code{value} is the string with the regions replaced, and \code{chunks} is
  a named character vector where the names are the IDs and the values are the
  regions that were extracted.

\code{restorePreserveChunks} returns a character vector with the
  chunk IDs replaced with their original values.
}
\description{
Use "magic" HTML comments to protect regions of HTML from being modified by
text processing tools.
}
\details{
Text processing tools like markdown and pandoc are designed to turn
human-friendly markup into common output formats like HTML. This works well
for most prose, but components that generate their own HTML may break if
their markup is interpreted as the input language. The \code{htmlPreserve}
function is used to mark regions of an input document as containing pure HTML
that must not be modified. This is achieved by substituting each such region
with a benign but unique string before processing, and undoing those
substitutions after processing.
}
\examples{
# htmlPreserve will prevent "<script>alert(10*2*3);</script>"
# from getting an <em> tag inserted in the middle
markup <- paste(sep = "\\n",
  "This is *emphasized* text in markdown.",
  htmlPreserve("<script>alert(10*2*3);</script>"),
  "Here is some more *emphasized text*."
)
extracted <- extractPreserveChunks(markup)
markup <- extracted$value
# Just think of this next line as Markdown processing
output <- gsub("\\\\*(.*?)\\\\*", "<em>\\\\1</em>", markup)
output <- restorePreserveChunks(output, extracted$chunks)
output

}
