% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_render_getThead.R
\name{prGetThead}
\alias{prGetThead}
\title{Renders the table head (thead)}
\usage{
prGetThead(
  x,
  header = NULL,
  cgroup = NULL,
  n.cgroup = NULL,
  caption = NULL,
  compatibility,
  total_columns,
  css.cgroup,
  top_row_style,
  rnames,
  rowlabel = NULL,
  cgroup_spacer_cells,
  prepped_cell_css,
  style_list,
  cell_style
)
}
\arguments{
\item{x}{The matrix/data.frame with the data. For the \code{print} and \code{knit_print}
it takes a string of the class \code{htmlTable} as \code{x} argument.}

\item{header}{A vector of character strings specifying column
header, defaulting to \code{\link[base:colnames]{colnames(x)}}}

\item{cgroup}{A vector, matrix or list of character strings defining major column header. The default
is to have none. These elements are also known as \emph{column spanners}. If you want a column \emph{not}
to have a spanner then put that column as "". If you pass cgroup and \code{n.crgroup} as
matrices you can have column spanners for several rows. See cgroup section below for details.}

\item{n.cgroup}{An integer vector, matrix or list containing the number of columns for which each element in
cgroup is a heading. For example, specify \code{cgroup=c("Major_1","Major_2")},
\code{n.cgroup=c(3,3)} if \code{"Major_1"} is to span columns 1-3 and
\code{"Major_2"} is to span columns 4-6.
\code{rowlabel} does not count in the column numbers. You can omit \code{n.cgroup}
if all groups have the same number of columns. If the \code{n.cgroup} is one less than
the number of columns in the matrix/data.frame then it automatically adds those.}

\item{caption}{Adds a table caption.}

\item{compatibility}{Is default set to \code{LibreOffice} as some
settings need to be in old HTML format as Libre Office can't
handle some commands such as the css caption-alignment. Note: this
option is not yet fully implemented for all details, in the future
I aim to generate a HTML-correct table and one that is aimed
at Libre Office compatibility. Word-compatibility is difficult as
Word ignores most settings and destroys all layout attempts
(at least that is how my 2010 version behaves). You can additinally use the
\code{options(htmlTableCompat = "html")} if you want a change to apply
to the entire document.
MS Excel sometimes misinterprets certain cell data when opening HTML-tables (eg. 1/2 becomes 1. February).
To avoid this please specify the correct Microsoft Office format for each cell in the table using the css.cell-argument.
To make MS Excel interpret everything as text use "mso-number-format:\"\\@\"".}

\item{total_columns}{The total number of columns including the rowlabel and the
specer cells}

\item{top_row_style}{The top row has a special style depending on
the \code{ctable} option in the \code{htmlTable} call.}

\item{rnames}{Default row names are generated from \code{\link[base:colnames]{rownames(x)}}. If you
provide \code{FALSE} then it will skip the row names. \emph{Note:} For \code{data.frames}
if you do \code{\link[base:colnames]{rownames(my_dataframe) <- NULL}} it still has
row names. Thus you need to use \code{FALSE} if you want to
supress row names for \code{data.frames}.}

\item{rowlabel}{If the table has row names or \code{rnames},
\code{rowlabel} is a character string containing the
column heading for the \code{rnames}.}

\item{cgroup_spacer_cells}{The spacer cells due to the multiple cgroup levels.
With multiple rows in cgroup we need to keep track of how many spacer cells
occur between the columns. This variable contains is of the size \code{ncol(x)-1}
and 0 if there is no cgroup element between.}

\item{style_list}{The list with all the styles}
}
\value{
\code{string} Returns the html string for the \verb{<thead>...</thead>} element
}
\description{
Renders the table head (thead)
}
\keyword{internal}
