test_that("ggeffect works when 0 is in representative values", {
  skip_if_not_installed("effects")
  d <- data.frame(
    Group = c(rep(433L, 50), rep(463L, 50)),
    RelativeElapsedHours = c(
      0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
      10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
      26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38.01, 39.01,
      40.01, 41.01, 42, 43, 44, 45, 46.01, 47.01, 48.01, 49.01, 50.01,
      51.01, 52.01, 53, 54.01, 55.01, 56.01, 57.01, 58.01, 59.01, 60.01,
      61.01, 62.01, 63.01, 64.01, 65.01, 66.01, 67.01, 68.01, 69.01,
      70.01, 71.01, 72.01, 73.01, 74.01, 75.01, 76.01, 77.01, 78.01,
      79.01, 80.01, 81.01, 82.01, 83.01, 84.01, 85.01, 86.01, 87.01,
      88.01, 89.01, 90.01, 91.01, 92.01, 93.01, 94.01, 95.01, 96.01,
      97.01, 98.01, 99.01
    ), PrimaryRootLength = c(
      0.05, 0.04, 0.07,
      0.06, 0.07, 0.11, 0.06, 0.08, 0.09, 0.13, 0.1, 0.1, 0.15, 0.17,
      0.14, 0.17, 0.13, 0.2, 0.18, 0.17, 0.17, 0.16, 0.2, 0.21, 0.23,
      0.25, 0.25, 0.26, 0.29, 0.29, 0.3, 0.31, 0.3, 0.33, 0.34, 0.36,
      0.36, 0.37, 0.4, 0.4, 0.43, 0.46, 0.5, 0.5, 0.51, 0.57, 0.6,
      0.64, 0.57, 0.59, 0.6, 0.61, 0.65, 0.69, 0.68, 0.7, 0.7, 0.73,
      0.72, 0.74, 0.76, 0.79, 0.79, 0.81, 0.84, 0.86, 0.85, 0.89, 0.92,
      0.93, 0.97, 0.98, 1.01, 1.03, 1.1, 1.17, 1.25, 1.35, 1.26, 1.42,
      1.45, 1.46, 1.52, 1.48, 1.57, 1.55, 1.48, 1.52, 1.46, 1.47, 1.64,
      1.6, 1.68, 1.76, 1.86, 1.75, 1.8, 1.84, 1.97, 1.95
    )
  )
  d$Group <- as.factor(d$Group)
  m <- lm(PrimaryRootLength ~ RelativeElapsedHours * Group, d)
  pr <- ggeffect(m, c("RelativeElapsedHours [0,24,48]", "Group"))
  expect_equal(
    pr$predicted,
    c(-0.00664, -0.92569, 0.26277, -0.2435, 0.53218, 0.43868),
    tolerance = 1e-4
  )
})
