% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov}
\alias{vcov}
\alias{vcov.ggeffects}
\title{Calculate variance-covariance matrix for adjusted predictions}
\usage{
\method{vcov}{ggeffects}(object, vcov = NULL, vcov_args = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"ggeffects"}, as returned by \code{predict_response()}.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for confidence intervals based on robust standard errors). This
argument accepts a covariance matrix, a function which returns a covariance
matrix, or a string which identifies the function to be used to compute the
covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"},
\code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"},
\code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"BS"}, \code{"xy"}, \code{"fractional"}, \code{"jackknife"}, \code{"residual"},
\code{"wild"}, \code{"mammen"}, \code{"norm"}, \code{"webb"}. See \code{?sandwich::vcovBS}
\item Other \code{sandwich} package functions: \code{"HAC"}, \code{"PC"}, \code{"CL"}, or \code{"PL"}.
}
}

If \code{NULL}, standard errors (and confidence intervals) for predictions are
based on the standard errors as returned by the \code{predict()}-function.
\strong{Note} that probably not all model objects that work with
\code{predict_response()} are also supported by the \strong{sandwich} or
\strong{clubSandwich} packages.

See details in \href{https://strengejacke.github.io/ggeffects/articles/practical_robustestimation.html}{this vignette}.}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the
\strong{sandwich} or \strong{clubSandwich} packages. Please refer to their
documentation (e.g., \code{?sandwich::vcovHAC}) to see the list of available
arguments. If no estimation type (argument \code{type}) is given, the default
type for \code{"HC"} equals the default from the \strong{sandwich} package; for type
\code{"CR"} the default is set to \code{"CR3"}. For other defaults, refer to the
documentation in the \strong{sandwich} or \strong{clubSandwich} package.}

\item{verbose}{Toggle messages or warnings.}

\item{...}{Currently not used.}
}
\value{
The variance-covariance matrix for the predicted values from \code{object}.
}
\description{
Returns the variance-covariance matrix for the predicted values from \code{object}.
}
\details{
The returned matrix has as many rows (and columns) as possible combinations
of predicted values from the \code{predict_response()} call. For example, if there
are two variables in the \code{terms}-argument of \code{predict_response()} with 3 and 4
levels each, there will be 3*4 combinations of predicted values, so the returned
matrix has a 12x12 dimension. In short, \code{nrow(object)} is always equal to
\code{nrow(vcov(object))}. See also 'Examples'.
}
\examples{
data(efc)
model <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
result <- predict_response(model, c("c12hour [meansd]", "c161sex"))

vcov(result)

# compare standard errors
sqrt(diag(vcov(result)))
as.data.frame(result)

# only two predicted values, no further terms
# vcov() returns a 2x2 matrix
result <- predict_response(model, "c161sex")
vcov(result)

# 2 levels for c161sex multiplied by 3 levels for c172code
# result in 6 combinations of predicted values
# thus vcov() returns a 6x6 matrix
result <- predict_response(model, c("c161sex", "c172code"))
vcov(result)
}
