% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_imap.R
\name{future_imap}
\alias{future_imap}
\alias{future_imap_chr}
\alias{future_imap_dbl}
\alias{future_imap_int}
\alias{future_imap_lgl}
\alias{future_imap_dfr}
\alias{future_imap_dfc}
\title{Apply a function to each element of a vector, and its index via futures}
\usage{
future_imap(.x, .f, ..., .progress = FALSE, .options = future_options())

future_imap_chr(.x, .f, ..., .progress = FALSE, .options = future_options())

future_imap_dbl(.x, .f, ..., .progress = FALSE, .options = future_options())

future_imap_int(.x, .f, ..., .progress = FALSE, .options = future_options())

future_imap_lgl(.x, .f, ..., .progress = FALSE, .options = future_options())

future_imap_dfr(.x, .f, ..., .id = NULL, .progress = FALSE,
  .options = future_options())

future_imap_dfc(.x, .f, ..., .progress = FALSE, .options = future_options())
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.progress}{A logical, for whether or not to print a progress bar for
multiprocess, multisession, and multicore plans.}

\item{.options}{The \code{future} specific options to use with the workers. This must
be the result from a call to \code{\link[=future_options]{future_options()}}.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}
}
\value{
A vector the same length as .x.
}
\description{
These functions work exactly the same as \code{\link[purrr:imap]{purrr::imap()}} functions, but allow
you to map in parallel.
}
\examples{

library(furrr)
\donttest{
plan(multiprocess)
}

future_imap_chr(sample(10), ~ paste0(.y, ": ", .x))

}
