\name{fingerprint-class}
\docType{class}
\alias{fingerprint-class}

\alias{euc.vector,fingerprint-method}
\alias{fold,fingerprint-method}
\alias{random.fingerprint,numeric,numeric-method}

\title{Class "fingerpint"}
\description{This class represents binary fingerprints, usually
  generated by a variety of cheminformatics software, but not
  restricted to such
  }
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("fingerprint", ...)}.
	Fingerprints can traditionally thought of as a vector of 1's and
	0's. However for large fingerprints this is inefficient and
	instead we simply store the positions of the bits that are
	on. Certain operations also need to know the length of the
	original bit string and this length is stored in the object at
	construction. Even though we store extra information along with
	the bit positions, conceptually we still consider the objects as
	simple bit strings. Thus the usual bitwise logical operations
	(&, |, !, xor) can be applied to objects of this class.
}
\section{Slots}{
	 \describe{
    \item{\code{bits}:}{Object of class \code{"numeric"} ~~ A vector
      indicating the bit positions that are on. }
    \item{\code{nbit}:}{Object of class \code{"numeric"} ~~ Indicates the length of the original bit string.}
    \item{\code{folded}:}{Object of class \code{"logical"} ~~ Indicates
      whether the fingerprint has been folded.}
    \item{\code{provider}:}{Object of class \code{"character"} ~~
      Indicates the source of the fingerprint. Can be useful to keep
      track of what software generated the fingerprint.}
    \item{\code{name}:}{Object of class \code{"character"} ~~
      The name associated with the fingerprint. If not name is available
    this gets set to an empty string}
    \item{\code{misc}:}{Object of class \code{"list"} ~~
    A holder for arbitrary items that may have been stored along with the fingerprint. Only
    certain formats allow extra items to be stored with the fingerprint, so in many cases
    this field is just an empty list}

  }
}
\section{Methods}{
  \describe{
    \item{distance}{\code{signature(fp1 = "fingerprint", fp2 = "fingerprint", method = "missing", a = "missing", b = "missing")}: ... }
    \item{distance}{\code{signature(fp1 = "fingerprint", fp2 = "fingerprint", method = "character", a = "missing", b = "missing")}: ... }
    \item{euc.vector}{\code{signature(fp = "fingerprint")}: ... }
    \item{fold}{\code{signature(fp = "fingerprint")}: ... }
    \item{random.fingerprint}{\code{signature(nbit = "numeric", on = "numeric")}: ... }    
	 }
}
\author{Rajarshi Guha \email{rajarshi.guha@gmail.com}}
\seealso{
  \code{\link{fp.read}}, \code{\link{fp.read.to.matrix}}
  \code{\link{fp.sim.matrix}}, \code{\link{fp.to.matrix}},
  \code{\link{fp.factor.matrix}}
  \code{\link{random.fingerprint}}
  }

\examples{
## make fingerprints
x <- new("fingerprint", nbit=128, bits=sample(1:128, 100))
y <- x
distance(x,y) # should be 1
x <- new("fingerprint", nbit=128, bits=sample(1:128, 100))
distance(x,y)
folded <- fold(x)

## binary operations on fingerprints
x <- new("fingerprint", nbit=8, bits=c(1,2,3,6,8))
y <- new("fingerprint", nbit=8, bits=c(1,2,4,5,7,8))
x & y
x | y
!x
}
\keyword{classes}
\keyword{logic}