% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-complex.R
\name{chk_complex}
\alias{chk_complex}
\alias{vld_complex}
\title{Check Complex}
\usage{
chk_complex(x, x_name = NULL)

vld_complex(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if complex using

\code{is.complex(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_complex()}: Validate Complex

}}
\examples{
# chk_complex
chk_complex(1i)
try(chk_complex(1))
# vld_complex
vld_complex(1i)
vld_complex(complex())
vld_complex(NA_complex_)
vld_complex(1)
vld_complex(TRUE)
}
\seealso{
\code{\link[=is.complex]{is.complex()}}

For more details about the use of this function,
please read the article
\href{https://poissonconsulting.github.io/chk/articles/chk-families.html}{chk families}.

Other data_type_checkers: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_logical}()},
\code{\link{chk_numeric}()},
\code{\link{chk_raw}()}
}
\concept{data_type_checkers}
