% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCglmm_tidiers.R
\name{.extractEffects}
\alias{.extractEffects}
\title{Internal function to extract the fixed or random effects from an \code{MCMCglmm} object}
\usage{
.extractEffects(
  object,
  use = c("all", "mean"),
  which = c("fixed", "random"),
  ...
)
}
\arguments{
\item{object}{An \code{MCMCglmm} object}

\item{use}{A character string indicating whether to return \dQuote{all} the
posterior samples (the default) or only the \dQuote{mean} of them.}

\item{which}{A character string indicating whether to return the
\dQuote{fixed} (the default) or \dQuote{random} effects.}

\item{\dots}{Not currently used.}
}
\value{
A matrix of the posterior samples or means for the fixed or random effects.
}
\description{
Extracts the fixed or random effects portions from an MCMCglmm object.
Note for the random, these are the estimates themselves,
not the variability in the estimates. The \code{use} options let you
get either just the posterior mean or all the posterior samples.
}
\seealso{
\code{\link{fixef.MCMCglmm}}, \code{\link{ranef.MCMCglmm}}
}
\keyword{internal}
