% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.afex_aov}
\alias{residuals.afex_aov}
\alias{fitted.afex_aov}
\title{Extract Residuals and Fitted Values from \code{afex_aov} objects}
\usage{
\method{residuals}{afex_aov}(object, append = FALSE, colname_residuals = ".residuals", ...)

\method{fitted}{afex_aov}(object, append = FALSE, colname_fitted = ".fitted", ...)
}
\arguments{
\item{object}{\code{afex_aov} object.}

\item{append}{If set to \code{TRUE} returns the residuals/fitted values
appended as an additional column to the long data. Recommended when data
was aggregated across within conditions.}

\item{colname_residuals, colname_fitted}{Name of the appended column when
\code{append = TRUE}.}

\item{...}{Additional arguments passed to
\code{residuals.lm}/\code{fitted.lm}.}
}
\value{
A vector of residuals/fitted values corresponding to the data in
  \code{object$data$long}, or if \code{append = TRUE} a data frame with an
  additional column of residuals/fitted values.
}
\description{
Extract Residuals and Fitted Values from \code{afex_aov} objects.
}
\examples{
### Setup ANOVAs
data(obk.long, package = "afex")
between <- aov_car(value ~ treatment*gender + Error(id), data = obk.long)
within <- aov_car(value ~ 1 + Error(id/(phase*hour)), data = obk.long)
mixed <- aov_car(value ~ treatment * gender + Error(id/(phase*hour)), data = obk.long)

# All residuals call produce the message that the data was changed during calculation.
residuals(within)
residuals(mixed)
residuals(between)

## Get residuals plus data used for fitting: 
residuals(within, append = TRUE)
residuals(mixed, append = TRUE)
residuals(between, append = TRUE)

### in case data is correctly ordered before fitting, this message is not shown

## between data:
obk2 <- aggregate(value ~ gender + treatment + id , data = obk.long, FUN = mean)
between2 <- aov_car(value ~ treatment*gender + Error(id), data = obk2)

residuals(between2) ## no message
all.equal(obk2, between2$data$long[,colnames(obk2)]) ## TRUE

# Therefore okay:
obk2$residuals <- residuals(between2)

## within data
obk3 <- obk.long[with(obk.long, order(id, phase, hour)), ]
within2 <- aov_car(value ~ 1 + Error(id/(phase*hour)), data = obk3)
residuals(within2) ## no message, because order is correct
# Therefore okay:
obk3$residuals <- residuals(within2)

## Same for fitted values:
# (show message)
fitted(within)
fitted(mixed)
fitted(between)

## Get fitted values plus data used for fitting: 
fitted(within, append = TRUE)
fitted(mixed, append = TRUE)
fitted(between, append = TRUE)

## No message:
fitted(between2)
fitted(within2)

#### residuals() and fitted() methods can be used for plotting
### requires package ggResidpanel
if (require("ggResidpanel")) {
  resid_auxpanel(residuals = residuals(mixed), predicted = fitted(mixed))
  
  \dontrun{
  ## suppress Messages:
  suppressMessages(
    resid_auxpanel(residuals = residuals(mixed), predicted = fitted(mixed))
  )
  }
}
}
\author{
Mattan S. Ben-Shachar
}
