% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDeltaFromMedian.R
\name{getDeltaFromMedian}
\alias{getDeltaFromMedian}
\title{Compute the difference from median}
\usage{
getDeltaFromMedian(results)
}
\arguments{
\item{results}{A \linkS4class{DataFrame} containing the output generated by \code{\link{SingleR}} or \code{\link{classifySingleR}}.}
}
\value{
A numeric vector containing delta values for each cell in \code{results}.
}
\description{
Compute the delta value for each cell,
defined as the difference between the score for the assigned label and the and median score across all labels.
}
\details{
This funciton computes the same delta value that is used in \code{\link{pruneScores}},
for users who want to apply more custom filters or visualizations.
}
\examples{
# Running the SingleR() example.
example(SingleR, echo=FALSE)

summary(getDeltaFromMedian(pred))

}
\seealso{
\code{\link{pruneScores}}, where the delta values are used.
}
\author{
Aaron Lun
}
