% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HuCortexData.R
\name{HuCortexData}
\alias{HuCortexData}
\title{Obtain the Hu cortex data}
\usage{
HuCortexData(
  mode = c("ctx", "3T3"),
  samples = NULL,
  ensembl = FALSE,
  location = TRUE
)
}
\arguments{
\item{mode}{Character vector indicating whether to return data for the 3T3 cells or the mouse cortex.}

\item{samples}{Character vector indicating whether to return data for specific samples, see Details.
If specified, this overrides \code{mode}.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse cortex single-nuclei RNA-seq data from Hu et al. (2017).
}
\details{
Column metadata includes the mode and sample corresponding to each cell/nuclei.
Available samples are:
\itemize{
\item \code{"cell-3T3"} and \code{"nuclei-3T3"}, generated from the 3T3 cell line.
\item \code{"nuclei-ctx-X"}, nuclei generated from the cortex of animal number X (from 1 to 13).
\item \code{"nuclei-ctx-salineX"} or \code{"nuclei-ctx-PTZX"}, nuclei generated from the cortex of saline- or PTZ-treated mice.
X represents the replicate number and can be 1 or 2.
}

If multiple modes are requested, counts are only reported for the intersection of genes across all modes.
This is because the gene annotation in the original count matrices differs across modes.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/wu-kidney}.
}
\examples{
sce <- HuCortexData("3T3")

}
\references{
Hu P et al. (2017). 
Dissecting cell-type composition and activity-dependent transcriptional state in mammalian brains by massively parallel single-nucleus RNA-seq.
\emph{Mol. cell} 68, 1006-1015.
}
\author{
Aaron Lun
}
