write.csv(file="../extdata/2.0.0/metadata-xin-pancreas.csv",
    data.frame(
        Title = sprintf("Xin pancreas %s", c("RPKMs", "rowData", "colData")),
        Description = sprintf("%s for the Xin pancreas single-cell RNA-seq dataset", 
            c("RPKM matrix", "Per-gene metadata", "Per-cell metadata")),
        RDataPath = file.path("scRNAseq", "xin-pancreas", "2.0.0", 
            c("rpkm.rds", "rowdata.rds", "coldata.rds")),
        BiocVersion="3.10",
        Genome="hg19",
        SourceType=c("TSV", "CSV", "TSV"),
        SourceUrl=c("https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE81608",
            rep("https://s3.amazonaws.com/scrnaseq-public-datasets/manual-data/xin", 2)), 
        SourceVersion=c(
            "GSE81608_human_islets_rpkm.txt.gz",
            "human_gene_annotation.csv",
            "human_islet_cell_identity.txt"),
        Species="Homo sapiens",
        TaxonomyId="9606",
        Coordinate_1_based=NA,
        DataProvider=c("GEO", rep("Martin Hemberg", 2)),
        Maintainer="Aaron Lun <infinite.monkeys.with.keyboards@gmail.com>",
        RDataClass=c("dgCMatrix", rep("DataFrame", 2)),
        DispatchClass="Rds",
        stringsAsFactors = FALSE
    ),
    row.names=FALSE)
