% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwlProcessWorkflow-methods.R
\name{cwlProcess-methods}
\alias{cwlProcess-methods}
\alias{cwlVersion}
\alias{cwlVersion<-}
\alias{cwlClass}
\alias{cwlClass<-}
\alias{baseCommand}
\alias{baseCommand<-}
\alias{arguments}
\alias{arguments<-}
\alias{hints}
\alias{hints<-}
\alias{requirements}
\alias{requirements<-}
\alias{inputs}
\alias{$,cwlProcess-method}
\alias{$<-,cwlProcess-method}
\alias{outputs}
\alias{stdOut}
\alias{stdOut<-}
\alias{extensions}
\alias{extensions<-}
\alias{short}
\title{cwlProcess methods}
\usage{
cwlVersion(cwl)

cwlVersion(cwl) <- value

cwlClass(cwl)

cwlClass(cwl) <- value

baseCommand(cwl)

baseCommand(cwl) <- value

arguments(cwl, step = NULL)

arguments(cwl, step = NULL) <- value

hints(cwl)

hints(cwl) <- value

requirements(cwl, step = NULL)

requirements(cwl, step = NULL) <- value

inputs(cwl)

\S4method{$}{cwlProcess}(x, name)

\S4method{$}{cwlProcess}(x, name) <- value

outputs(cwl)

stdOut(cwl)

stdOut(cwl) <- value

extensions(cwl)

extensions(cwl) <- value

short(cwl)
}
\arguments{
\item{cwl}{A `cwlProcess` (or `cwlWorkflow`) object.}

\item{value}{To assign a list of `requirements` value.}

\item{step}{To specifiy a step ID when `cwl` is a workflow.}

\item{x}{A `cwlProcess` object.}

\item{name}{One of input list.}
}
\value{
cwlVersion: cwl document version

cwlClass: CWL class of `cwlProcess` or `cwlWorkflow` object.

baseCommand: base command for the `cwlProcess` object.

arguments: CWL arguments.

hints: CWL hints.

requirements: CWL requirments.

inputs: A list of `InputParam`.

`$`: the `InputParam` value for `cwlProcess` object.

outputs: A list of `OutputParam`.

stdOut: CWL stdout.

extensions: A list of extensions or metadata.

short: A short summary of an object of `cwlProcess` or `cwlWorkflow`.
}
\description{
Some useful methods for `cwlProcess` objects.

`$`: Extract input values for `cwlProcess`
    object. (Can auto-complete the input names using tab)

`$<-`: Set input values for `cwlProcess` object by name.

outputs: The outputs of a `cwlProcess` object.

stdOut: stdout of `cwlProcess` object.

extensions: Extensions and metadata of `cwlProcess` object.

short: The function to show a short summary of `cwlProcess` or
`cwlWorkflow` object.
}
\examples{
ip <- InputParam(id = "sth")
echo <- cwlProcess(baseCommand = "echo", inputs = InputParamList(ip))
cwlVersion(echo)
cwlClass(echo)
baseCommand(echo)
hints(echo)
requirements(echo)
inputs(echo)
outputs(echo)
stdOut(echo)
extensions(echo)

s1 <- cwlWorkflow()
runs(s1)
s1
short(s1)
}
