% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/504-readMolFromSmi.R
\name{readMolFromSmi}
\alias{readMolFromSmi}
\title{Read Molecules from SMILES Files and Return Parsed Java
Molecular Object or Plain Text List}
\usage{
readMolFromSmi(smifile, type = c("mol", "text"))
}
\arguments{
\item{smifile}{Character vector, containing SMILES file location(s).}

\item{type}{\code{'mol'} or \code{'text'}. \code{'mol'} returns parsed
Java molecular object, used for \code{'text'} returns (plain-text)
character string list. For common molecular descriptors and
fingerprints, use \code{'mol'}.
For descriptors and fingerprints calculated by OpenBabel,
i.e. functions named \code{extractDrugOB...()} , use \code{'text'}.}
}
\value{
A list, containing parsed Java molecular object or character strings.
}
\description{
Read Molecules from SMILES Files and Return Parsed Java
Molecular Object or Plain Text List
}
\details{
This function reads molecules from SMILES strings and return
parsed Java molecular object or plain text list
needed by \code{extractDrug...()} functions.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol1 = readMolFromSmi(smi, type = 'mol')
mol2 = readMolFromSmi(smi, type = 'text')}
}
\seealso{
See \code{\link{readMolFromSDF}} for reading molecules
from SDF files and returning parsed Java molecular object.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{MOL}
\keyword{SMILES}
\keyword{readMolFromSmi}
