% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/333-extractDrugLengthOverBreadth.R
\name{extractDrugLengthOverBreadth}
\alias{extractDrugLengthOverBreadth}
\title{Calculate the Ratio of Length to Breadth Descriptor}
\usage{
extractDrugLengthOverBreadth(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns two columns named \code{LOBMAX} and \code{LOBMIN}:
\itemize{
\item \code{LOBMAX} - The maximum L/B ratio;
\item \code{LOBMIN} - The L/B ratio for the rotation that results in the
minimum area (defined by the product of the X & Y extents for that orientation).
}
}
\description{
Calculate the Ratio of Length to Breadth Descriptor
}
\details{
Calculates the Ratio of Length to Breadth, as a result ti does not perform
any orientation and only considers the X & Y
extents for a series of rotations about the Z axis
(in 10 degree increments).
}
\note{
The descriptor assumes that the atoms have been configured.
}
\examples{
sdf = system.file('sysdata/OptAA3d.sdf', package = 'Rcpi')
\donttest{
mol = readMolFromSDF(sdf)
dat = extractDrugLengthOverBreadth(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Breadth}
\keyword{Length}
\keyword{extractDrugLengthOverBreadth}
