% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAllelicCountsFile.R
\name{readAllelicCountsFile}
\alias{readAllelicCountsFile}
\title{Read allelic counts file}
\usage{
readAllelicCountsFile(file, format, zero = NULL)
}
\arguments{
\item{file}{Input file containing counts of ref and alt alleles}

\item{format}{File format. If missing, derived from the file 
extension. Currently only GATK4 CollectAllelicCounts (tsv)
format supported.}

\item{zero}{Start position is 0-based. Default is \code{FALSE}
for GATK, \code{TRUE} for BED file based intervals.}
}
\value{
A \code{CollapsedVCF} with the parsed allelic counts.
}
\description{
Read file containing counts of ref and alt alleles of common
Toolkit 4.
}
\examples{

ac.file <- system.file("extdata", "example_allelic_counts.tsv", 
    package="PureCN")
vcf_ac <- readAllelicCountsFile(ac.file)

}
\author{
Markus Riester
}
