% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createNormalDatabase.R
\name{calculateTangentNormal}
\alias{calculateTangentNormal}
\title{Calculate tangent normal}
\usage{
calculateTangentNormal(
  tumor.coverage.file,
  normalDB,
  num.eigen = 20,
  ignore.sex = FALSE,
  sex = NULL
)
}
\arguments{
\item{tumor.coverage.file}{Coverage file or data  of a tumor sample.}

\item{normalDB}{Database of normal samples, created with
\code{\link{createNormalDatabase}}.}

\item{num.eigen}{Number of eigen vectors used.}

\item{ignore.sex}{If \code{FALSE}, detects sex of sample and returns best
normals with matching sex.}

\item{sex}{Sex of sample. If \code{NULL}, determine with
\code{\link{getSexFromCoverage}} and default parameters. Valid values are
\code{F} for female, \code{M} for male. If all chromosomes are diploid,
specify \code{diploid}.}
}
\description{
Reimplementation of GATK4 denoising. Please cite the relevant GATK
publication if you use this in a publication.
}
\examples{

tumor.coverage.file <- system.file('extdata', 'example_tumor.txt.gz', 
    package = 'PureCN')
normal.coverage.file <- system.file("extdata", "example_normal.txt.gz", 
    package = "PureCN")
normal2.coverage.file <- system.file("extdata", "example_normal2.txt.gz", 
    package = "PureCN")
normal.coverage.files <- c(normal.coverage.file, normal2.coverage.file)
normalDB <- createNormalDatabase(normal.coverage.files)
pool <- calculateTangentNormal(tumor.coverage.file, normalDB)

}
\seealso{
\code{\link{createNormalDatabase}}
}
\author{
Markus Riester
}
