% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callLOH.R
\name{callLOH}
\alias{callLOH}
\title{Get regions of LOH}
\usage{
callLOH(res, id = 1, arm.cutoff = 0.9, keep.no.snp.segments = TRUE)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{id}{Candidate solution to extract LOH from. \code{id=1} will use the
maximum likelihood solution.}

\item{arm.cutoff}{Min fraction LOH on a chromosome arm to call whole arm
events.}

\item{keep.no.snp.segments}{Segments without heterozygous SNPs
have no LOH information. This defines whether these segments should
be reported anyways.}
}
\value{
Returns \code{data.frame} with LOH regions.
}
\description{
This function provides detailed LOH information by region.
}
\examples{

data(purecn.example.output)
head(callLOH(purecn.example.output))

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
