\name{PCA}
\alias{PCA-class}
\alias{PCA}
\alias{show,PCA-method}
\alias{explo.plot,PCA-method}
\alias{dat2save,PCA-method}
\docType{class}
\title{PCA class}

\description{
PCA class generated from dat() function with type="PCA". This object contains the results of the PCA on the data matrix as well as the arguments used.
}

\usage{
\S4method{explo.plot}{PCA}(object, samples = 1:2, plottype = "scores", factor = NULL)
\S4method{dat2save}{PCA}(object)
}

\arguments{
  \item{object}{
    Object generated from \code{dat()} function.
  }
  \item{samples}{
    Principal components to be plotted. If NULL, the two first components are plotted.
  }
  \item{plottype}{
    If plottype="scores", the experimental samples are displayed in the plot and colored according to the values of the selected factor.
    If plottype="loadings", the genes are plotted. 
  }
  \item{factor}{
    The samples in the score plot will be colored according to the values of the selected factor. If NULL, the first factor is chosen.
  }
}

\section{Slots/List Components}{
An object of this class contains an element (dat) which is a list with the following components:

  \code{result}: List containing the output of PCA. It contains the following elements: "eigen" (eigenvalues and eigenvectors from the PCA decomposition), 
	  "var.exp" (variance explained by each Principal Component), "scores" (coefficients of samples in each PC), "loadings" (coefficients of genes in each PC).
  
  \code{factors}: Data.frame with factors inherited from object generated by readData() function.

  \code{norm}: Value provided for argument "norm". 

  \code{logtransf}: Value provided for argument "logtransf". 
}

\section{Methods}{
This class has an specific \code{show} method in order to work and print
a summary of the elements which are contained and a \code{dat2save} method
to save the relevant information in an object cleanly. It also has an
\code{explo.plot} method to plot the data contained in the object.
}

\author{Sonia Tarazona}

\keyword{classes}
