% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateBySample.R
\name{aggregateBySample}
\alias{aggregateBySample}
\alias{aggSamp}
\title{Aggregates a MRexperiment object or counts matrix to by a factor.}
\usage{
aggregateBySample(obj, fct, aggfun = rowMeans, out = "MRexperiment")

aggSamp(obj, fct, aggfun = rowMeans, out = "MRexperiment")
}
\arguments{
\item{obj}{A MRexperiment object or count matrix.}

\item{fct}{phenoData column name from the MRexperiment object or if count matrix object a vector of labels.}

\item{aggfun}{Aggregation function.}

\item{out}{Either 'MRexperiment' or 'matrix'}
}
\value{
An aggregated count matrix or MRexperiment object where the new pData is a vector of `fct` levels.
}
\description{
Using the phenoData information in the MRexperiment, calling aggregateBySample on a
MRexperiment and a particular phenoData column (i.e. 'diet') will aggregate counts
using the aggfun function (default rowMeans). Possible aggfun alternatives
include rowMeans and rowMedians.
}
\examples{

data(mouseData)
aggregateBySample(mouseData[1:100,],fct="diet",aggfun=rowSums)
# not run
# aggregateBySample(mouseData,fct="diet",aggfun=matrixStats::rowMedians)
# aggSamp(mouseData,fct='diet',aggfun=rowMaxs)

}
