% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degFilter}
\alias{degFilter}
\title{Filter genes by group}
\usage{
degFilter(counts, metadata, group, min = 0.8, minreads = 0)
}
\arguments{
\item{counts}{Matrix with expression data, columns are samples
and rows are genes or other feature.}

\item{metadata}{Data.frame with information about
each column in counts matrix. Rownames should match
\code{colnames(counts)}.}

\item{group}{Character column in metadata used to
group samples and applied the cutoff.}

\item{min}{Percentage value indicating the minimum
number of samples in each group that should have
more than 0 in count matrix.}

\item{minreads}{Integer minimum number of reads to consider
a feature expressed.}
}
\value{
count \code{matrix} after filtering genes (features)
with not enough expression in any group.
}
\description{
This function will keep only rows that have a minimum counts of
1 at least in a \code{min} number of samples (default 80\%).
}
\examples{
data(humanGender)
library(SummarizedExperiment)
idx <- c(1:10, 75:85)
c <- degFilter(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], "group", min=1)
}
