# General

* A new freedesktop module helps UNIX application developers to follow the
  freedesktop.org guidelines.
* The Android module now allows resourcesDir, sourcesDir and assetsDir to be
  specified as relative paths.
* A new ConanfileProbe allows better and more flexible integration of Qbs and
  the Conan package manager.
* A new hostArchitecture property has been added to the qbs module.


# Language

* List properties in modules are now merged according to inter-module
  dependencies. This is important when flags like cpp.staticLibraries are
  contributed by multiple modules with dependencies between each other.
  (QBS-1517).
* Dependency matching of multiplexed products is now less strict and does not
  require all multiplex properties to match. For instance, if product A is
  multiplexed over qbs.architecture and qbs.buildVariant while product B is only
  multiplexed over one of these axes, then Qbs no longer fails (QBS-1515).


# C/C++ Support

* The Renesas RL78 architecture is now supported in GCC and IAR and the
  toolchains are auto-detected by qbs-setup-toolchains.
* The Renesas RX as well as the RH850, V850, 78K are now supported in IAR and
  the toolchains are auto-detected by qbs-setup-toolchains.
* The MPLAB X32 GCC-based toolchain is now auto-detected on Windows.
* Multiple occurrences of static libraries on the linker command line are now
  pruned and the last instance always wins when using GCC or LLVM-based
  toolchains. This avoids problems with excessively long linker command lines
  (QBS-1273).
* Clang-cl and MSVC toolchains use the compiler frontend instead of the linker
  when linking. The old behavior can be restored by setting cpp.linkerMode to
  "manual". This allows to use sanitizers with clang-cl by passing
  "-fsanitise=xxx" via cpp.driverFlags (QBS-1522).
* The clang-cl toolchain now uses "link.exe" as the default linker.
  "lld-link.exe" can be explicitly selected by setting cpp.linkerVariant to
  "lld" (QBS-1522).
* The MSVC, clang-cl and MinGW toolchains are now automatically detected if the
  profile does not set an explicit installation location, for instance because
  no profile was given.
* Installation of separate debug information can now be enabled and configured
  by simply setting the installDebugInformation and debugInformationInstallDir
  properties in the Application and Library convenience items. This works for
  toolchains based upon GCC, MSVC or clang-cl.
* Xcode version 11.4 is now supported on macOS.


# Qt Support

* Qbs now supports Qt 5.14 for Android which comes as a multi-architecture
  package. The qbs-setup-android tool has been updated accordingly (QBS-1497).
* JSON metatype files generated by moc (Qt >= 5.15) are supported by setting
  Qt.core.generateMetaTypesFile and Qt.core.metaTypesInstallDir (QBS-1531).
* Pure debug builds of Qt (>= 5.14) with MinGW are now properly supported. They
  don't have the 'd' suffix (QTBUG-80792).
* The QML type declaration mechanism introduced in Qt 5.15 is now supported by
  the Qt.qml module (QBS-1531).
* Generated qmltypes files are now named according to the product's targetName
  property (QTBUG-82710).


# Documentation

* The how-to chapter has been extended with sections about debugging Qbs files
  and about building separate debug information in C++ projects.
* The item and module reference documentation has been improved for the
  cpp.libraryPaths, cpp.dynamicLibraries (QBS-1516), qbs.toolchainType and
  qbs.toolchain properties as well as the Export item and the Library
  convenience item.
* Documentation for various path probes has been added (QBS-1187).
* The README was extended and a CONTRIBUTING file has been added which provides
  useful information for potential contributors. This is important for people
  looking at our github mirror.


# Infrastructure

* The Debian Docker image has been removed.
* We are now using ccache and clcache in our CI pipelines to shrink the build
  time.
* Clang-tidy is now used to identify potential problems in the code base and a
  lot of action was taken upon a lot of findings.
* A Docker image for testing Qbs with Android and Qt has been added.


# Important Bug Fixes

* Fix nullpointer access and heap-use-after-free error (QBS-1485).
* Select the right instance when Depends.profiles is used on a dependency with
  an aggregator product (QBS-1513).
* Fix crash when specifying a non-existing profile in Depends.profiles
  (QBS-1514).
* Try harder to detect GCC toolchains in qbs-setup-toolchains (QBS-1524).
* Code signing for Core Foundation Bundles on macOS has been fixed.
* Automatic artifact scanning now prefers artifacts from product dependencies if
  multiple candidates are found. This improves dependency tracking in complex
  projects (QBS-1532).
* The grpcIncludePath property in the probufcpp module has been fixed
  (QBS-1542).
* Qbs does no longer crash when accessing a property of a non-existent module in
  "IDE mode".


# Contributors

* Alberto Mardegan
* Björn Schäpers
* BogDan Vatra
* Christian Kandeler
* Christian Stenger
* Denis Shienkov
* Ivan Komissarov
* Jochen Ulrich
* Joerg Bornemann
* Leon Buckel
* Marius Sincovici
* Maximilian Goldstein
* Mitch Curtis
* Oliver Wolff
* Orgad Shaneh
* Raphaël Cotty
* Richard Weickelt
