#!/usr/bin/env python3

# This script massages the reStructuredText files generated by
# gdbus-codegen into something that's slightly more suitable for
# the online documentation of XDG Desktop Portal. It's not a
# general purpose script.

import os
import sys

output_dir = sys.argv[1]
filename_prefix = sys.argv[2]
inputs = sys.argv[3:]


def adjust_title(lines):
    title = lines[3].strip()

    if title.startswith("org.freedesktop.portal."):
        adjusted_title = title.replace("org.freedesktop.portal.", "")
    elif title.startswith("org.freedesktop.impl.portal"):
        adjusted_title = title.replace("org.freedesktop.impl.portal.", "")
    elif title.startswith("org.freedesktop.host.portal"):
        adjusted_title = title.replace("org.freedesktop.host.portal.", "")
    elif title.startswith("org.freedesktop.background.Monitor"):
        adjusted_title = title.replace(
            "org.freedesktop.background.Monitor", "Background Apps Monitor"
        )
    else:
        adjusted_title = title

    # CamelCase → Camel Case
    if adjusted_title not in ["OpenURI", "ScreenCast"]:
        adjusted_title = "".join(
            map(lambda x: x if x.islower() else f" {x}", adjusted_title)
        )

    lines[3] = f"{adjusted_title}\n"


# Temporary fix for '.. {title}:' strings in the generated files. Should be
# removed after GLib 2.78.4 hits the CI images.
#
# See: https://gitlab.gnome.org/GNOME/glib/-/merge_requests/3751
def fix_title_template_string(lines):
    for index, line in enumerate(lines):
        if line.strip() == ".. _{title}:":
            next_title = lines[index + 2].strip()
            lines[index] = f".. _{next_title}:\n"


for file in inputs:
    basename = os.path.basename(file)
    fullpath = os.path.join(output_dir, f"{filename_prefix}-{basename}")

    with open(fullpath) as f:
        lines = f.readlines()

    adjust_title(lines)
    fix_title_template_string(lines)

    with open(fullpath, "w") as f:
        f.writelines(lines)
