//
// Copyright 2025 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: rf_atr_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // RF0_ATR_STATE       : 0x0 (rf_atr_control.v)
  // RF1_ATR_STATE       : 0x400 (rf_atr_control.v)
  // RF2_ATR_STATE       : 0x800 (rf_atr_control.v)
  // RF3_ATR_STATE       : 0xC00 (rf_atr_control.v)
  // ATR_OPTION_REGISTER : 0x1000 (rf_atr_control.v)
  // RF_ATR_DISABLED     : 0x1004 (rf_atr_control.v)

//===============================================================================
// RegTypes
//===============================================================================

  // RF_ATR_STATE Type (from rf_atr_control.v)
  localparam RF_ATR_STATE_SIZE = 32;
  localparam RF_ATR_STATE_MASK = 32'h7;
  localparam TX_RX_RFS_SIZE = 1;  //RF_ATR_STATE:TX_RX_RFS
  localparam TX_RX_RFS_MSB  = 0;  //RF_ATR_STATE:TX_RX_RFS
  localparam TX_RX_RFS      = 0;  //RF_ATR_STATE:TX_RX_RFS
  localparam RX_RFS_SIZE = 1;  //RF_ATR_STATE:RX_RFS
  localparam RX_RFS_MSB  = 1;  //RF_ATR_STATE:RX_RFS
  localparam RX_RFS      = 1;  //RF_ATR_STATE:RX_RFS
  localparam TDDS_SIZE = 1;  //RF_ATR_STATE:TDDS
  localparam TDDS_MSB  = 2;  //RF_ATR_STATE:TDDS
  localparam TDDS      = 2;  //RF_ATR_STATE:TDDS

//===============================================================================
// Register Group RF_ATR_REGISTERS
//===============================================================================

  // Enumerated type RF_SWITCHES_SIZE_TYPE
  localparam RF_SWITCHES_SIZE_TYPE_SIZE = 1;
  localparam RFS_SIZE  = 'h3;  // RF_SWITCHES_SIZE_TYPE:RFS_SIZE

  // RF0_ATR_STATE Register (from rf_atr_control.v)
  localparam RF0_ATR_STATE_COUNT = 256; // Number of elements in array

  // RF1_ATR_STATE Register (from rf_atr_control.v)
  localparam RF1_ATR_STATE_COUNT = 256; // Number of elements in array

  // RF2_ATR_STATE Register (from rf_atr_control.v)
  localparam RF2_ATR_STATE_COUNT = 256; // Number of elements in array

  // RF3_ATR_STATE Register (from rf_atr_control.v)
  localparam RF3_ATR_STATE_COUNT = 256; // Number of elements in array

  // ATR_OPTION_REGISTER Register (from rf_atr_control.v)
  localparam ATR_OPTION_REGISTER = 'h1000; // Register Offset
  localparam ATR_OPTION_REGISTER_SIZE = 32;  // register width in bits
  localparam ATR_OPTION_REGISTER_MASK = 32'hF;
  localparam RF0_ATR_OPTION_SIZE = 1;  //ATR_OPTION_REGISTER:RF0_ATR_OPTION
  localparam RF0_ATR_OPTION_MSB  = 0;  //ATR_OPTION_REGISTER:RF0_ATR_OPTION
  localparam RF0_ATR_OPTION      = 0;  //ATR_OPTION_REGISTER:RF0_ATR_OPTION
  localparam RF1_ATR_OPTION_SIZE = 1;  //ATR_OPTION_REGISTER:RF1_ATR_OPTION
  localparam RF1_ATR_OPTION_MSB  = 1;  //ATR_OPTION_REGISTER:RF1_ATR_OPTION
  localparam RF1_ATR_OPTION      = 1;  //ATR_OPTION_REGISTER:RF1_ATR_OPTION
  localparam RF2_ATR_OPTION_SIZE = 1;  //ATR_OPTION_REGISTER:RF2_ATR_OPTION
  localparam RF2_ATR_OPTION_MSB  = 2;  //ATR_OPTION_REGISTER:RF2_ATR_OPTION
  localparam RF2_ATR_OPTION      = 2;  //ATR_OPTION_REGISTER:RF2_ATR_OPTION
  localparam RF3_ATR_OPTION_SIZE = 1;  //ATR_OPTION_REGISTER:RF3_ATR_OPTION
  localparam RF3_ATR_OPTION_MSB  = 3;  //ATR_OPTION_REGISTER:RF3_ATR_OPTION
  localparam RF3_ATR_OPTION      = 3;  //ATR_OPTION_REGISTER:RF3_ATR_OPTION

  // RF_ATR_DISABLED Register (from rf_atr_control.v)
  localparam RF_ATR_DISABLED = 'h1004; // Register Offset
  localparam RF_ATR_DISABLED_SIZE = 32;  // register width in bits
  localparam RF_ATR_DISABLED_MASK = 32'hF;
  localparam RF0_ATR_DISABLED_SIZE = 1;  //RF_ATR_DISABLED:RF0_ATR_DISABLED
  localparam RF0_ATR_DISABLED_MSB  = 0;  //RF_ATR_DISABLED:RF0_ATR_DISABLED
  localparam RF0_ATR_DISABLED      = 0;  //RF_ATR_DISABLED:RF0_ATR_DISABLED
  localparam RF1_ATR_DISABLED_SIZE = 1;  //RF_ATR_DISABLED:RF1_ATR_DISABLED
  localparam RF1_ATR_DISABLED_MSB  = 1;  //RF_ATR_DISABLED:RF1_ATR_DISABLED
  localparam RF1_ATR_DISABLED      = 1;  //RF_ATR_DISABLED:RF1_ATR_DISABLED
  localparam RF2_ATR_DISABLED_SIZE = 1;  //RF_ATR_DISABLED:RF2_ATR_DISABLED
  localparam RF2_ATR_DISABLED_MSB  = 2;  //RF_ATR_DISABLED:RF2_ATR_DISABLED
  localparam RF2_ATR_DISABLED      = 2;  //RF_ATR_DISABLED:RF2_ATR_DISABLED
  localparam RF3_ATR_DISABLED_SIZE = 1;  //RF_ATR_DISABLED:RF3_ATR_DISABLED
  localparam RF3_ATR_DISABLED_MSB  = 3;  //RF_ATR_DISABLED:RF3_ATR_DISABLED
  localparam RF3_ATR_DISABLED      = 3;  //RF_ATR_DISABLED:RF3_ATR_DISABLED

  // Return the offset of an element of register array RF0_ATR_STATE
  function automatic integer RF0_ATR_STATE (input integer i);
  begin
    RF0_ATR_STATE = (i * 'h4) + 'h0;
  end
  endfunction

  // Return the offset of an element of register array RF1_ATR_STATE
  function automatic integer RF1_ATR_STATE (input integer i);
  begin
    RF1_ATR_STATE = (i * 'h4) + 'h400;
  end
  endfunction

  // Return the offset of an element of register array RF2_ATR_STATE
  function automatic integer RF2_ATR_STATE (input integer i);
  begin
    RF2_ATR_STATE = (i * 'h4) + 'h800;
  end
  endfunction

  // Return the offset of an element of register array RF3_ATR_STATE
  function automatic integer RF3_ATR_STATE (input integer i);
  begin
    RF3_ATR_STATE = (i * 'h4) + 'hC00;
  end
  endfunction
